DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

INSERT INTO `wp_commentmeta` VALUES("63","34","_wp_trash_meta_status","0");
INSERT INTO `wp_commentmeta` VALUES("64","33","_wp_trash_meta_status","0");


DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

INSERT INTO `wp_comments` VALUES("33","2161","http://www.gp.se/fescvea","","http://www.gp.se/fescvea","191.101.243.42","2015-02-01 10:46:50","2015-02-01 09:46:50","<strong>http://www.gp.se/fescvea</strong>

[...]we came across a cool internet site that you just may love. Take a search if you want[...]","0","spam","Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 5.1; .NET CLR 1.1.4322; InfoPath.1)","trackback","0","0");
INSERT INTO `wp_comments` VALUES("34","2161","northface-outletstore.us","","http://www.northface-outletstore.us","36.250.174.6","2015-03-20 22:31:34","2015-03-20 21:31:34","<strong>northface-outletstore.us</strong>

Oh man, you have no theory what you just missed.","0","spam","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) )","trackback","0","0");


DROP TABLE IF EXISTS `wp_duplicator_packages`;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_duplicator_packages` VALUES("1","20150417_les48hdelapige","55310965234f97154150417132349","100","2015-04-17 13:24:03","Cyrille","O:11:\"DUP_Package\":16:{s:2:\"ID\";i:1;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150417_les48hdelapige_55310965234f97154150417132349_scan.json\";s:7:\"Runtime\";s:10:\"54.70 sec.\";s:7:\"ExeSize\";s:8:\"316.87KB\";s:7:\"ZipSize\";s:8:\"196.97MB\";s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150417_les48hdelapige_55310965234f97154150417132349_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:22:\"/home/pigiste/48heures\";s:4:\"Size\";i:206533114;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";r:1;s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:67:\"20150417_les48hdelapige_55310965234f97154150417132349_installer.php\";s:4:\"Size\";i:324473;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:23031946;s:4:\"File\";s:66:\"20150417_les48hdelapige_55310965234f97154150417132349_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:106:\"/home/pigiste/48heures/wp-snapshots/tmp/20150417_les48hdelapige_55310965234f97154150417132349_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");


DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(20) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(20) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(20) DEFAULT NULL,
  `log_username` varchar(20) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(20) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_layerslider`;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_layerslider` VALUES("1","Slide Home page","{\"properties\":{\"title\":\"Slide Home page\",\"width\":\"100%\",\"height\":\"470\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"80\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2014\\/05\\/cistude_romain_riols.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2013\\/04\\/Logo48hcyan-01.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"900\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"20px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"900\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1450\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"250\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"187px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/le-programme\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"221px\",\"left\":\"671px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-02.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/sinscrire-aux-48h\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"299px\",\"left\":\"668px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-03.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/pratique\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"378px\",\"left\":\"666px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2015\\/03\\/48hVichy-juil14-bandeau1200.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/blancPP-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"450\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"119px\",\"left\":\"20px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"550\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"68\\\\\\\"}\",\"top\":\"348px\",\"left\":\"21px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1428671868","0","0");
INSERT INTO `wp_layerslider` VALUES("2","Why Enfold - Small Header","{\"properties\":{\"title\":\"Why Enfold - Small Header\",\"width\":\"100%\",\"height\":\"150\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"1\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"#aac98e\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1200\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"150\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-18px\",\"left\":\"800px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1300\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"842px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l17.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"350\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-279px\",\"left\":\"951px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"450\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"51px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-22px\",\"left\":\"-107px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Why you should choose\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"650\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"68px\",\"left\":\"214px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"684px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1398347374","0","0");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_newsletter`;

CREATE TABLE `wp_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `sex` char(1) NOT NULL DEFAULT 'n',
  `status` char(1) NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(50) NOT NULL DEFAULT '',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `country` varchar(4) NOT NULL DEFAULT '',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) NOT NULL DEFAULT '',
  `profile_2` varchar(255) NOT NULL DEFAULT '',
  `profile_3` varchar(255) NOT NULL DEFAULT '',
  `profile_4` varchar(255) NOT NULL DEFAULT '',
  `profile_5` varchar(255) NOT NULL DEFAULT '',
  `profile_6` varchar(255) NOT NULL DEFAULT '',
  `profile_7` varchar(255) NOT NULL DEFAULT '',
  `profile_8` varchar(255) NOT NULL DEFAULT '',
  `profile_9` varchar(255) NOT NULL DEFAULT '',
  `profile_10` varchar(255) NOT NULL DEFAULT '',
  `profile_11` varchar(255) NOT NULL DEFAULT '',
  `profile_12` varchar(255) NOT NULL DEFAULT '',
  `profile_13` varchar(255) NOT NULL DEFAULT '',
  `profile_14` varchar(255) NOT NULL DEFAULT '',
  `profile_15` varchar(255) NOT NULL DEFAULT '',
  `profile_16` varchar(255) NOT NULL DEFAULT '',
  `profile_17` varchar(255) NOT NULL DEFAULT '',
  `profile_18` varchar(255) NOT NULL DEFAULT '',
  `profile_19` varchar(255) NOT NULL DEFAULT '',
  `profile_20` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(50) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  `flow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter` VALUES("1","paulineburguin@hotmail.fr ","","","n","C","2014-05-07 22:10:12","a6896fa250","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("2","jacson-christel@voila.fr ","","","n","C","2014-05-07 22:10:26","35897a25c8","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("3","henry.castelbou@numericable.fr ","","","n","C","2014-05-07 22:10:34","5fb9736511","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("4","nicolas.jaunet@argus-presse.fr","","","n","C","2014-05-07 22:10:44","6120a0dae4","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("5","manager@mtwevts.com ","","","n","C","2014-05-07 22:10:58","f3504d96fa","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("6","max.twa@gmail.com","","","n","C","2014-05-07 22:13:09","2379dc6e8e","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","1","0");


DROP TABLE IF EXISTS `wp_newsletter_emails`;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext,
  `message_text` longtext,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `send_on` int(11) NOT NULL DEFAULT '0',
  `track` tinyint(4) NOT NULL DEFAULT '0',
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` char(1) NOT NULL DEFAULT '',
  `query` text,
  `preferences` text,
  `options` longtext,
  `token` varchar(10) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_emails` VALUES("1","<!DOCTYPE html>
<html>
    <head>
        <title></title>
        <style>
            * {
                font-family: ;
                font-size: ;
            }
        </style>
    </head>
    <body style=\"font:normal 11px helvetica,sans-serif;\"><table style=\"background-color: #ffffff; width: 600px; background-position: initial initial; background-repeat: initial initial;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
<tbody>
<tr>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">Cet email a &eacute;t&eacute; envoy&eacute; &agrave; {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.</td>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">&nbsp;</td>
</tr>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">
<table style=\"height: 90px; width: 334px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"20\" align=\"center\">
<tbody>
<tr>
<td style=\"background: #ffffff;\"><a href=\"http://www.48h.pigiste.org\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/Logo48hPP-01.png\" alt=\"\" width=\"382\" height=\"211\" /></a></td>
<td style=\"background: #ffffff;\">
<p><a href=\"http://48h.pigiste.org/le-programme/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-01.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
<p><a href=\"http://48h.pigiste.org/sinscrire-aux-48h/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-02.png\" alt=\"\" width=\"223\" height=\"50\" /></a></p>
<p><a href=\"http://48h.pigiste.org/pratique/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-03.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
</td>
</tr>
</tbody>
</table>
</td>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">&nbsp;</td>
</tr>
</tbody>
</table></body></html>","This email requires a modern e-mail reader. You can view the email online here:

{email_url}.

Thank you, Les 48h de la pige
To change your subscription follow:
{profile_url}.","Le programme est enfin publié !","message","2014-05-07 22:04:24","sent","6","6","6","1399492800","1","0","","select * from wp_newsletter where status=\'C\'","","a:5:{s:18:\"preferences_status\";s:1:\"0\";s:11:\"preferences\";N;s:3:\"sex\";N;s:6:\"status\";s:1:\"C\";s:8:\"wp_users\";s:1:\"0\";}","52730d2b3d","0");


DROP TABLE IF EXISTS `wp_newsletter_stats`;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` int(11) NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) NOT NULL DEFAULT '',
  `anchor` varchar(200) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_stats` VALUES("1","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("2","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("3","6","1","0","2014-05-07 22:13:52","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("4","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("5","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("6","5","1","0","2014-05-07 22:17:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("7","6","1","0","2014-05-07 22:18:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("8","6","1","0","2014-05-07 22:18:14","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("9","5","1","0","2014-05-07 23:09:03","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("10","2","1","0","2014-05-08 08:57:32","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("11","2","1","0","2014-05-08 08:57:46","http://48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("12","2","1","0","2014-05-08 09:07:45","http://48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("13","5","1","0","2014-05-08 10:03:29","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("14","2","1","0","2014-05-08 10:28:31","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("15","2","1","0","2014-05-08 10:28:41","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("16","2","1","0","2014-05-08 10:34:35","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("17","1","1","0","2014-05-08 12:23:30","","","157.55.0.155","");
INSERT INTO `wp_newsletter_stats` VALUES("18","1","1","0","2014-05-08 12:23:31","http://48h.pigiste.org/le-programme/","","86.214.59.246","");
INSERT INTO `wp_newsletter_stats` VALUES("19","2","1","0","2014-05-08 13:11:18","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("20","5","1","0","2014-05-08 14:36:19","","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("21","5","1","0","2014-05-08 14:37:19","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("22","5","1","0","2014-05-08 14:37:22","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("23","5","1","0","2014-05-08 14:37:41","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("24","5","1","0","2014-05-08 14:39:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("25","5","1","0","2014-05-08 14:43:29","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("26","5","1","0","2014-05-08 14:45:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("27","2","1","0","2014-05-08 19:31:34","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("28","5","1","0","2014-05-09 00:40:29","http://48h.pigiste.org/le-programme/","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("29","2","1","0","2014-05-09 09:08:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("30","2","1","0","2014-05-09 09:29:42","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("31","2","1","0","2014-05-09 10:09:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("32","2","1","0","2014-06-01 12:08:09","","","90.9.60.51","");


DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=115042 DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` VALUES("1","siteurl","http://48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("2","blogname","Les 48h de la pige","yes");
INSERT INTO `wp_options` VALUES("3","blogdescription","Un événement Profession : Pigiste","yes");
INSERT INTO `wp_options` VALUES("4","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("5","admin_email","max.twa@gmail.com","yes");
INSERT INTO `wp_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("17","default_category","1","yes");
INSERT INTO `wp_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("22","date_format","j F Y","yes");
INSERT INTO `wp_options` VALUES("23","time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("24","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("165","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("166","widget_nav_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `wp_options` VALUES("32","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("34","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("35","active_plugins","a:9:{i:0;s:19:\"bbpress/bbpress.php\";i:1;s:41:\"better-wp-security/better-wp-security.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"email-users/email-users.php\";i:4;s:41:\"google-maps-widget/google-maps-widget.php\";i:5;s:21:\"newsletter/plugin.php\";i:6;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:7;s:27:\"updraftplus/updraftplus.php\";i:8;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";}","yes");
INSERT INTO `wp_options` VALUES("36","home","http://48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("37","category_base","","yes");
INSERT INTO `wp_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `wp_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("41","gmt_offset","1","yes");
INSERT INTO `wp_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("43","recently_edited","a:5:{i:0;s:74:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/includes/error404.php\";i:2;s:60:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/404.php\";i:3;s:62:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/style.css\";i:4;s:66:\"/homez.313/pigiste/48heures/wp-content/plugins/bbpress/bbpress.php\";i:5;s:63:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/footer.php\";}","no");
INSERT INTO `wp_options` VALUES("44","template","enfold","yes");
INSERT INTO `wp_options` VALUES("45","stylesheet","enfold","yes");
INSERT INTO `wp_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("52","db_version","30133","yes");
INSERT INTO `wp_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("54","upload_path","","yes");
INSERT INTO `wp_options` VALUES("55","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("57","show_on_front","posts","yes");
INSERT INTO `wp_options` VALUES("58","tag_base","","yes");
INSERT INTO `wp_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("62","thumbnail_size_w","80","yes");
INSERT INTO `wp_options` VALUES("63","thumbnail_size_h","80","yes");
INSERT INTO `wp_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("68","large_size_w","1030","yes");
INSERT INTO `wp_options` VALUES("69","large_size_h","1030","yes");
INSERT INTO `wp_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `wp_options` VALUES("71","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("72","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("77","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("82","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("83","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("85","uninstall_plugins","a:2:{s:41:\"google-maps-widget/google-maps-widget.php\";a:2:{i:0;s:3:\"GMW\";i:1;s:9:\"uninstall\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}}","no");
INSERT INTO `wp_options` VALUES("86","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("88","page_on_front","0","yes");
INSERT INTO `wp_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","26691","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:66:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:12:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:6:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"email_single_user\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:29:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:25:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("93","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("94","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("96","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("98","sidebars_widgets","a:13:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:9:\"sidebar-7\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:1:{i:0;s:18:\"avia_google_maps-5\";}s:10:\"sidebar-10\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("99","cron","a:10:{i:1429280222;a:1:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1429295460;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429304325;a:2:{s:14:\"updraft_backup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"updraft_backup_database\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429321360;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429347752;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429364593;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429365793;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429732938;a:1:{s:25:\"newsletter_check_versions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"newsletter_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1429805372;a:1:{s:8:\"gmw_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"gmw_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("114272","updraft_dreamobjects","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("151","recently_activated","a:2:{s:21:\"polylang/polylang.php\";i:1429220309;s:19:\"akismet/akismet.php\";i:1429218125;}","yes");
INSERT INTO `wp_options` VALUES("154","_bbp_private_forums","a:1:{i:0;i:1739;}","yes");
INSERT INTO `wp_options` VALUES("155","_bbp_hidden_forums","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("501","_bbp_forum_slug","forum","yes");
INSERT INTO `wp_options` VALUES("156","_bbp_db_version","250","yes");
INSERT INTO `wp_options` VALUES("157","widget_newsbox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("158","widget_portfoliobox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("159","widget_avia_socialcount","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("160","widget_avia_combo_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("161","widget_avia_partner_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("162","widget_avia_google_maps","a:3:{i:1;a:0:{}i:5;a:15:{s:5:\"title\";s:84:\"Cette année, rendez-vous sur le Campus Albert Londres à Vichy les 3 et 4 juillet !\";s:14:\"street-address\";s:36:\"Pôle technologique et universitaire\";s:4:\"city\";s:0:\"\";s:5:\"state\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:7:\"country\";s:5:\"VICHY\";s:3:\"lat\";s:8:\"46.11946\";s:3:\"lng\";s:16:\"3.42521320000003\";s:4:\"zoom\";s:2:\"15\";s:4:\"type\";s:7:\"ROADMAP\";s:12:\"directionsto\";s:0:\"\";s:7:\"content\";s:0:\"\";s:4:\"icon\";s:65:\"http://48h.pigiste.org/wp-content/uploads/2014/05/marqueur-01.png\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:5:\"280px\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("163","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("164","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("168","widget_bbp_login_widget","a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:12:\"Se connecter\";s:8:\"register\";s:0:\"\";s:8:\"lostpass\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("115017","_site_transient_timeout_theme_roots","1429280042","yes");
INSERT INTO `wp_options` VALUES("115018","_site_transient_theme_roots","a:2:{s:6:\"enfold\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";}","yes");
INSERT INTO `wp_options` VALUES("114285","updraft_split_every","500","yes");
INSERT INTO `wp_options` VALUES("114286","updraft_dir","updraft","yes");
INSERT INTO `wp_options` VALUES("114180","_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c","1429254793","no");
INSERT INTO `wp_options` VALUES("7724","_transient__bbp_2a01:e35:2e1e:d280:e4ee:792d:4e43:9768_last_post","1401444151","yes");
INSERT INTO `wp_options` VALUES("502","_bbp_topic_slug","sujet","yes");
INSERT INTO `wp_options` VALUES("503","_bbp_topic_tag_slug","mot-cle","yes");
INSERT INTO `wp_options` VALUES("504","_bbp_view_slug","voir-le-sujet","yes");
INSERT INTO `wp_options` VALUES("505","_bbp_reply_slug","repondre","yes");
INSERT INTO `wp_options` VALUES("506","_bbp_search_slug","rechercher","yes");
INSERT INTO `wp_options` VALUES("507","_bbp_user_slug","utilisateurs","yes");
INSERT INTO `wp_options` VALUES("508","_bbp_topic_archive_slug","sujets","yes");
INSERT INTO `wp_options` VALUES("509","_bbp_reply_archive_slug","réponses","yes");
INSERT INTO `wp_options` VALUES("510","_bbp_user_favs_slug","favoris","yes");
INSERT INTO `wp_options` VALUES("511","_bbp_user_subs_slug","souscrire","yes");
INSERT INTO `wp_options` VALUES("99130","_transient_timeout_feed_mod_2fb9572e3d6a42f680e36370936a57ae","1427747214","no");
INSERT INTO `wp_options` VALUES("99131","_transient_feed_mod_2fb9572e3d6a42f680e36370936a57ae","1427704014","no");
INSERT INTO `wp_options` VALUES("108711","_site_transient_timeout_browser_48ce97d67f5c394f5ce1d5ccaf049307","1429273849","yes");
INSERT INTO `wp_options` VALUES("108712","_site_transient_browser_48ce97d67f5c394f5ce1d5ccaf049307","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114181","_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c","1429211593","no");
INSERT INTO `wp_options` VALUES("114184","_transient_timeout_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1429254794","no");
INSERT INTO `wp_options` VALUES("101709","theme_mods_twentyfifteen","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1427960171;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:18:\"orphaned_widgets_3\";a:0:{}s:18:\"orphaned_widgets_4\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("114182","_transient_timeout_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","1429254794","no");
INSERT INTO `wp_options` VALUES("114183","_transient_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 07:37:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/nhFl_mTTaWE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6597:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/nhFl_mTTaWE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/KJsEy-lwkw0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3044:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/KJsEy-lwkw0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/Nxk3eqWFjXU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3658:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/Nxk3eqWFjXU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/odATT589tL4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3638:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/odATT589tL4\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/TbIvObIyepg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3888:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/TbIvObIyepg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/A_tvnBn7-wc/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9052:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/A_tvnBn7-wc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/d4xirCr8u6U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4899:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/d4xirCr8u6U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/FwIaDMiQ8vo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5443:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/FwIaDMiQ8vo\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/dpw1jMQN_tw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2589:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/dpw1jMQN_tw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"L’Hebdo WordPress n°249 : Bonne Année 2015 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/vn9uES3y6lo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 06:44:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7343\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Bonne année 2015 ! Toute l&#8217;équipe de l&#8217;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets. Notre communauté va arroser ses 10 ans d&#8217;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&#8217;est en bonne voie, on croise les [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4791:\"<h2>Bonne année 2015 !</h2>
<p>Toute l&rsquo;équipe de l&rsquo;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets.</p>
<p>Notre communauté va arroser ses 10 ans d&rsquo;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&rsquo;est en bonne voie, on croise les doigts). Le premier événement de l&rsquo;année est bien sur le <a href=\"http://2015.paris.wordcamp.org/\">WordCamp Paris 2015</a> , les 23 et 24 janvier prochains. Suivrons, j&rsquo;espère, plein d&rsquo;autres belles surprises. Restez connectés !</p>
<p>&nbsp;</p>
<h2>Place à l&rsquo;Hebdo !</h2>
<h3>WPMX Session #8</h3>
<p>WPMX, l&rsquo;association WordPress du Sud Ouest, présente sa <a href=\"http://wpchannel.com/meetup-wpmx-8-wordpress-securite/\">8e session consacrée à la sécurité</a> le 15 janvier 2015 en présence de Julio Potier.</p>
<h3>Brute Protect</h3>
<p><a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">Brute Protect s&rsquo;explique (en)</a> suite à son rachat par <a href=\"http://ma.tt/2015/01/jetpack-speed/\">Automattic (en)</a>.</p>
<h3>Les choses à faire après l&rsquo;installation de WordPress</h3>
<p>Dès lors que votre site WordPress est installé, <a href=\"http://www.labnol.org/internet/wordpress-optimization-guide/3931/\">pensez à ces quelques étapes</a> ! (en)</p>
<h3>Un peu d&rsquo;histoire</h3>
<p>WordPress a passé la dizaine, faire un peu d&rsquo;<a href=\"http://wptavern.com/historic-wordpress-project-seeks-contributors\">histoire peut être intéressant</a> (en).</p>
<h3>Post format, inconnu et déjà mort ?</h3>
<p><a href=\"http://www.poststat.us/post-formats-looking-back/\">Petite discussion autour des Post Format</a> qui sont sous exploités (en).</p>
<h3>WordPress en 2015</h3>
<p>Noel Tock nous livre sa vision de <a href=\"https://medium.com/@noeltock/wordpress-in-2015-ed6a4674a608\">WordPress en 2015</a> (en).</p>
<h3>6 extensions indispensables</h3>
<p><a href=\"http://www.tanguy-nicolas.com/extensions-indispensables-blog-wordpress/\">Les 6 extensions indispensables</a> selon Tanguy Nicolas.</p>
<h3>L&rsquo;année de WP Marmite</h3>
<p><a href=\"http://wpmarmite.com/recapitulatif-2014-plans-2015/\">WP Marmite est apparu en 2014</a>, voici une rétrospective et les projets à venir.</p>
<h3>Tout savoir le nouveau mode d&rsquo;écriture sans distraction</h3>
<p>Voici tout ce que vous devriez savoir sur <a href=\"http://premium.wpmudev.org/blog/distraction-free-mode-wordpress/\">le nouveau mode d&rsquo;écriture sans distraction</a> (en).</p>
<h3>Le livre WordPress de Christophe Aubry</h3>
<p>WPChannel présente le livre de <a href=\"http://wpchannel.com/wordpress-gerer-site-multi-utilisateur-christophe-aubry/\">Christophe Aubry sur WordPress</a>.</p>
<h3>Les résolutions 2015 de Julio</h3>
<p>Julio prends de bonne résultions 2015 pour WordPress et <a href=\"http://boiteaweb.fr/resolutions-wordpress-2015-dans-vos-developpements-8487.html\">vous les partage</a>.</p>
<h3>Le thème 2015 par Rodrigue</h3>
<p>Rodrigue propose une <a href=\"http://www.cree1site.com/review-du-theme-wordpress-twenty-fifteen/\">revue du thème par défaut &laquo;&nbsp;Twenty Fifteen&nbsp;&raquo;</a>.</p>
<h3>Les commentaires et leurs interactions</h3>
<p>WP Formation fait le tour des <a href=\"http://wpformation.com/commentaires-wordpress-interaction/\">bonnes pratiques en terme de commentaires</a>.</p>
<h3>Genesis : créer son accueil</h3>
<p>Grégoire présente la façon de <a href=\"http://www.gregoirenoyelle.com/genesis-comprendre-creer-page-accueil-wordpress-sur-mesure/\">créer une page d&rsquo;accueil avec Genesis</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/20scgnJiK4c\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/vn9uES3y6lo\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:78:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/20scgnJiK4c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:15:\"feedburner/cjgl\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:18:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:96:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:21:\"Subscribe with Feedly\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:80:\"http://feedly.com/#subscription/feed/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:42:\"http://s3.feedly.com/feedburner/feedly.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:72:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:95:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:34:\"Subscribe with The Free Dictionary\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:103:\"http://www.thefreedictionary.com/_/hp/AddRSS.aspx?http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://img.tfd.com/hp/addToTheFreeDictionary.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:28:\"Subscribe with Bitty Browser\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:115:\"http://www.bitty.com/manual/?contenttype=rssfeed&contentvalue=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://www.bitty.com/img/bittychicklet_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:16;a:5:{s:4:\"data\";s:28:\"Subscribe with Podcast Ready\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:107:\"http://www.podcastready.com/oneclick_bookmark.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:58:\"http://www.podcastready.com/images/podcastready_button.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:17;a:5:{s:4:\"data\";s:29:\"Subscribe with Daily Rotation\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"http://www.dailyrotation.com/index.php?feed=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:40:\"http://www.dailyrotation.com/rss-dr2.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:43:\"http://feeds.feedburner.com/feedburner/cjgL\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Thu, 16 Apr 2015 19:00:20 GMT\";s:4:\"date\";s:29:\"Thu, 16 Apr 2015 19:13:14 GMT\";s:7:\"expires\";s:29:\"Thu, 16 Apr 2015 19:13:14 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:13:\"80:quic,p=0.5\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("99146","_site_transient_timeout_browser_6405adb15b203b9da650c82d6da703bc","1428309245","yes");
INSERT INTO `wp_options` VALUES("99147","_site_transient_browser_6405adb15b203b9da650c82d6da703bc","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"5.0.6\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114268","updraft_encryptionphrase","","yes");
INSERT INTO `wp_options` VALUES("114269","updraft_service","ftp","yes");
INSERT INTO `wp_options` VALUES("114270","updraft_s3","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114271","updraft_ftp","a:4:{s:4:\"host\";s:22:\"ftp.cluster003.ovh.net\";s:4:\"user\";s:7:\"pigiste\";s:4:\"pass\";s:9:\"piges2014\";s:4:\"path\";s:20:\"48heures_sauvegardes\";}","yes");
INSERT INTO `wp_options` VALUES("99268","can_compress_scripts","0","yes");
INSERT INTO `wp_options` VALUES("99228","_transient__bbp_112.111.184.211_last_posted","1427711663","yes");
INSERT INTO `wp_options` VALUES("99247","_transient__bbp_117.169.1.15_last_posted","1427713385","yes");
INSERT INTO `wp_options` VALUES("99254","_transient__bbp_120.203.149.104_last_posted","1427714156","yes");
INSERT INTO `wp_options` VALUES("60280","_transient__bbp_118.244.255.72_last_posted","1423090281","yes");
INSERT INTO `wp_options` VALUES("44078","_transient__bbp_62.210.91.186_last_posted","1420523537","yes");
INSERT INTO `wp_options` VALUES("44155","_transient__bbp_46.161.41.31_last_posted","1420039318","yes");
INSERT INTO `wp_options` VALUES("80475","_transient__bbp_183.220.195.144_last_posted","1425622388","yes");
INSERT INTO `wp_options` VALUES("80517","_transient__bbp_124.205.129.97_last_posted","1425632059","yes");
INSERT INTO `wp_options` VALUES("81205","_transient__bbp_118.97.129.26_last_posted","1425946347","yes");
INSERT INTO `wp_options` VALUES("114274","updraft_cloudfiles","a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114275","updraft_bitcasa","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114276","updraft_copycom","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114277","updraft_openstack","a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114278","updraft_googledrive","a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}","yes");
INSERT INTO `wp_options` VALUES("114279","updraft_sftp_settings","","yes");
INSERT INTO `wp_options` VALUES("114280","updraft_webdav_settings","","yes");
INSERT INTO `wp_options` VALUES("114281","updraft_ssl_nossl","0","yes");
INSERT INTO `wp_options` VALUES("114282","updraft_log_syslog","0","yes");
INSERT INTO `wp_options` VALUES("114283","updraft_ssl_useservercerts","0","yes");
INSERT INTO `wp_options` VALUES("114284","updraft_ssl_disableverify","0","yes");
INSERT INTO `wp_options` VALUES("44604","_transient__bbp_46.161.41.34_last_posted","1427715262","yes");
INSERT INTO `wp_options` VALUES("47095","_transient__bbp_118.97.195.42_last_posted","1420695170","yes");
INSERT INTO `wp_options` VALUES("59878","_transient__bbp_94.23.200.91_last_posted","1423043475","yes");
INSERT INTO `wp_options` VALUES("65286","_transient__bbp_218.204.141.204_last_posted","1426315447","yes");
INSERT INTO `wp_options` VALUES("48118","_transient__bbp_222.77.203.168_last_posted","1420893501","yes");
INSERT INTO `wp_options` VALUES("48299","_transient__bbp_74.91.20.250_last_posted","1420929729","yes");
INSERT INTO `wp_options` VALUES("49887","_transient__bbp_219.93.183.102_last_posted","1423806568","yes");
INSERT INTO `wp_options` VALUES("50283","_transient__bbp_27.159.225.139_last_posted","1421389418","yes");
INSERT INTO `wp_options` VALUES("50518","_transient__bbp_121.205.244.37_last_posted","1421443204","yes");
INSERT INTO `wp_options` VALUES("51199","_transient__bbp_203.144.144.162_last_posted","1421618332","yes");
INSERT INTO `wp_options` VALUES("51473","_transient__bbp_192.3.34.98_last_posted","1422106978","yes");
INSERT INTO `wp_options` VALUES("68434","_transient__bbp_183.222.152.174_last_posted","1423981537","yes");
INSERT INTO `wp_options` VALUES("68532","_transient__bbp_114.255.183.174_last_posted","1424435586","yes");
INSERT INTO `wp_options` VALUES("52528","_transient__bbp_195.154.181.152_last_posted","1427715152","yes");
INSERT INTO `wp_options` VALUES("52729","_transient__bbp_110.89.37.30_last_posted","1421979198","yes");
INSERT INTO `wp_options` VALUES("52763","_transient__bbp_27.159.225.207_last_posted","1421986737","yes");
INSERT INTO `wp_options` VALUES("55617","_transient__bbp_94.23.11.68_last_posted","1423752012","yes");
INSERT INTO `wp_options` VALUES("55999","_transient__bbp_37.57.231.241_last_posted","1423316577","yes");
INSERT INTO `wp_options` VALUES("56000","_transient__bbp_46.118.127.156_last_posted","1423212605","yes");
INSERT INTO `wp_options` VALUES("56818","_transient__bbp_198.204.252.211_last_posted","1425266094","yes");
INSERT INTO `wp_options` VALUES("56998","_transient__bbp_190.41.100.17_last_posted","1422682180","yes");
INSERT INTO `wp_options` VALUES("57317","_transient__bbp_104.194.28.210_last_posted","1422714916","yes");
INSERT INTO `wp_options` VALUES("57547","_transient__bbp_31.184.238.187_last_posted","1422748425","yes");
INSERT INTO `wp_options` VALUES("58022","_transient__bbp_60.9.141.66_last_posted","1422810885","yes");
INSERT INTO `wp_options` VALUES("58304","_transient__bbp_177.223.0.26_last_posted","1422846724","yes");
INSERT INTO `wp_options` VALUES("58344","_transient__bbp_76.164.202.114_last_posted","1422852498","yes");
INSERT INTO `wp_options` VALUES("59179","_transient__bbp_95.37.148.100_last_posted","1422960496","yes");
INSERT INTO `wp_options` VALUES("59361","_transient__bbp_218.104.239.12_last_posted","1426555022","yes");
INSERT INTO `wp_options` VALUES("59371","_transient__bbp_46.161.41.199_last_posted","1423068333","yes");
INSERT INTO `wp_options` VALUES("59491","_transient__bbp_114.44.209.214_last_posted","1422998088","yes");
INSERT INTO `wp_options` VALUES("59546","_transient__bbp_198.27.66.79_last_posted","1425787831","yes");
INSERT INTO `wp_options` VALUES("113906","itsec_data","a:5:{s:5:\"build\";i:4036;s:20:\"activation_timestamp\";i:1429192993;s:17:\"already_supported\";b:0;s:15:\"setup_completed\";b:1;s:18:\"tooltips_dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113907","itsec_global","a:24:{s:11:\"write_files\";b:1;s:18:\"notification_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:12:\"digest_email\";b:1;s:12:\"backup_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:15:\"lockout_message\";s:14:\"error - erreur\";s:20:\"user_lockout_message\";s:158:\"You have been locked out due to too many invalid login attempts.
Vous avez été bloquée suite à un trop grand nombre de tentatives de connexion invalides.\";s:25:\"community_lockout_message\";s:153:\"Your IP address has been flagged as a threat by the iThemes Security network.
Votre adresse IP a été marquée comme une menace par iThemes sécurité.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:1:{i:0;s:13:\"78.206.68.131\";}s:19:\"email_notifications\";b:1;s:8:\"log_type\";i:2;s:12:\"log_rotation\";i:14;s:12:\"log_location\";s:63:\"/home/pigiste/48heures/wp-content/uploads/ithemes-security/logs\";s:14:\"allow_tracking\";b:1;s:11:\"did_upgrade\";b:0;s:10:\"nginx_file\";s:33:\"/home/pigiste/48heures/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:8:\"log_info\";s:21:\"les-48h-de-la-pige-QJ\";s:9:\"lock_file\";b:0;s:14:\"proxy_override\";b:0;s:14:\"hide_admin_bar\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113908","itsec_initials","a:3:{s:5:\"login\";b:0;s:5:\"admin\";b:0;s:11:\"file_editor\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("16530","_transient__bbp_82.230.168.8_last_posted","1404140205","yes");
INSERT INTO `wp_options` VALUES("17154","_transient__bbp_90.8.46.50_last_posted","1403889121","yes");
INSERT INTO `wp_options` VALUES("17064","_transient__bbp_92.149.9.100_last_posted","1403880354","yes");
INSERT INTO `wp_options` VALUES("17578","_transient__bbp_90.61.162.114_last_posted","1403952777","yes");
INSERT INTO `wp_options` VALUES("17638","_transient__bbp_213.111.4.73_last_posted","1403963158","yes");
INSERT INTO `wp_options` VALUES("18570","_transient__bbp_37.163.65.189_last_posted","1404132532","yes");
INSERT INTO `wp_options` VALUES("18587","_transient__bbp_90.83.121.65_last_posted","1404222127","yes");
INSERT INTO `wp_options` VALUES("18733","_transient__bbp_82.226.37.175_last_posted","1404149336","yes");
INSERT INTO `wp_options` VALUES("18814","_transient__bbp_31.39.169.47_last_posted","1404157140","yes");
INSERT INTO `wp_options` VALUES("19091","_transient__bbp_78.250.64.139_last_posted","1404197517","yes");
INSERT INTO `wp_options` VALUES("19258","_transient__bbp_84.103.193.190_last_posted","1404215558","yes");
INSERT INTO `wp_options` VALUES("3492","_transient__bbp_82.247.140.57_last_posted","1401864189","yes");
INSERT INTO `wp_options` VALUES("38628","_transient__bbp_94.23.59.169_last_posted","1418617334","yes");
INSERT INTO `wp_options` VALUES("38894","_transient__bbp_27.159.211.141_last_posted","1417774064","yes");
INSERT INTO `wp_options` VALUES("39808","_transient__bbp_62.210.82.82_last_posted","1418507363","yes");
INSERT INTO `wp_options` VALUES("13315","_transient__bbp_78.127.17.164_last_posted","1402914057","yes");
INSERT INTO `wp_options` VALUES("13337","_transient__bbp_198.147.19.2_last_posted","1404293672","yes");
INSERT INTO `wp_options` VALUES("13370","_transient__bbp_82.233.72.204_last_posted","1403132586","yes");
INSERT INTO `wp_options` VALUES("7883","_transient__bbp_82.224.188.52_last_posted","1401712310","yes");
INSERT INTO `wp_options` VALUES("7884","_transient__bbp_82.254.176.76_last_posted","1401715515","yes");
INSERT INTO `wp_options` VALUES("7903","_transient__bbp_78.206.68.131_last_posted","1404210992","yes");
INSERT INTO `wp_options` VALUES("7908","_transient__bbp_92.150.170.112_last_posted","1401811615","yes");
INSERT INTO `wp_options` VALUES("13509","_transient__bbp_84.100.218.48_last_posted","1403275532","yes");
INSERT INTO `wp_options` VALUES("13848","_transient__bbp_90.55.15.115_last_posted","1403365456","yes");
INSERT INTO `wp_options` VALUES("13775","_transient__bbp_78.123.29.27_last_posted","1403349667","yes");
INSERT INTO `wp_options` VALUES("14117","_transient__bbp_78.239.128.36_last_posted","1403427818","yes");
INSERT INTO `wp_options` VALUES("14578","_transient__bbp_78.113.57.88_last_posted","1403516858","yes");
INSERT INTO `wp_options` VALUES("14582","_transient__bbp_109.30.200.11_last_posted","1403517292","yes");
INSERT INTO `wp_options` VALUES("15127","_transient__bbp_109.10.28.239_last_posted","1403594034","yes");
INSERT INTO `wp_options` VALUES("38547","_transient__bbp_120.37.238.71_last_posted","1417603897","yes");
INSERT INTO `wp_options` VALUES("62161","_transient__bbp_183.62.60.100_last_posted","1426639085","yes");
INSERT INTO `wp_options` VALUES("62171","_transient__bbp_121.31.5.182_last_posted","1426235563","yes");
INSERT INTO `wp_options` VALUES("62172","_transient__bbp_88.150.136.178_last_posted","1427683163","yes");
INSERT INTO `wp_options` VALUES("62188","_transient__bbp_218.206.83.89_last_posted","1427343280","yes");
INSERT INTO `wp_options` VALUES("62210","_transient__bbp_190.201.61.95_last_posted","1423315302","yes");
INSERT INTO `wp_options` VALUES("62223","_transient__bbp_190.204.197.229_last_posted","1423518386","yes");
INSERT INTO `wp_options` VALUES("62233","_transient__bbp_101.71.27.27_last_posted","1423631092","yes");
INSERT INTO `wp_options` VALUES("62246","_transient__bbp_60.191.205.70_last_posted","1424416238","yes");
INSERT INTO `wp_options` VALUES("62268","_transient__bbp_104.230.38.176_last_posted","1423320747","yes");
INSERT INTO `wp_options` VALUES("62281","_transient__bbp_183.220.105.140_last_posted","1423322009","yes");
INSERT INTO `wp_options` VALUES("62285","_transient__bbp_111.13.55.3_last_posted","1427155185","yes");
INSERT INTO `wp_options` VALUES("62334","_transient__bbp_120.203.149.162_last_posted","1427416008","yes");
INSERT INTO `wp_options` VALUES("62347","_transient__bbp_101.71.27.120_last_posted","1427714260","yes");
INSERT INTO `wp_options` VALUES("62366","_transient__bbp_117.135.250.68_last_posted","1423406217","yes");
INSERT INTO `wp_options` VALUES("62385","_transient__bbp_218.204.89.114_last_posted","1423333046","yes");
INSERT INTO `wp_options` VALUES("62405","_transient__bbp_113.207.130.182_last_posted","1423836199","yes");
INSERT INTO `wp_options` VALUES("62427","_transient__bbp_117.169.1.70_last_posted","1426431527","yes");
INSERT INTO `wp_options` VALUES("62443","_transient__bbp_183.220.198.22_last_posted","1423378481","yes");
INSERT INTO `wp_options` VALUES("62444","_transient__bbp_151.236.242.8_last_posted","1423338527","yes");
INSERT INTO `wp_options` VALUES("62478","_transient__bbp_180.166.69.1_last_posted","1427368461","yes");
INSERT INTO `wp_options` VALUES("62488","_transient__bbp_190.198.108.145_last_posted","1423658248","yes");
INSERT INTO `wp_options` VALUES("62498","_transient__bbp_61.53.143.179_last_posted","1426873836","yes");
INSERT INTO `wp_options` VALUES("62541","_transient__bbp_123.30.189.246_last_posted","1423488818","yes");
INSERT INTO `wp_options` VALUES("62566","_transient__bbp_201.210.36.230_last_posted","1423352814","yes");
INSERT INTO `wp_options` VALUES("62585","_transient__bbp_219.93.183.93_last_posted","1427633439","yes");
INSERT INTO `wp_options` VALUES("62586","_transient__bbp_190.78.171.12_last_posted","1423354630","yes");
INSERT INTO `wp_options` VALUES("62632","_transient__bbp_177.0.118.245_last_posted","1424401588","yes");
INSERT INTO `wp_options` VALUES("62638","_transient__bbp_113.207.130.166_last_posted","1425610154","yes");
INSERT INTO `wp_options` VALUES("62648","_transient__bbp_117.177.240.29_last_posted","1427603066","yes");
INSERT INTO `wp_options` VALUES("62664","_transient__bbp_175.44.9.27_last_posted","1423362295","yes");
INSERT INTO `wp_options` VALUES("25328","_transient__bbp_85.28.10.73_last_posted","1405506750","yes");
INSERT INTO `wp_options` VALUES("25497","_transient__bbp_41.231.53.43_last_posted","1405571465","yes");
INSERT INTO `wp_options` VALUES("25684","_transient__bbp_5.79.73.142_last_posted","1406245602","yes");
INSERT INTO `wp_options` VALUES("25695","_transient__bbp_46.165.225.198_last_posted","1405651297","yes");
INSERT INTO `wp_options` VALUES("25915","_transient__bbp_95.211.192.231_last_posted","1406152488","yes");
INSERT INTO `wp_options` VALUES("480","_bbp_edit_lock","5","yes");
INSERT INTO `wp_options` VALUES("481","_bbp_throttle_time","10","yes");
INSERT INTO `wp_options` VALUES("482","_bbp_allow_anonymous","1","yes");
INSERT INTO `wp_options` VALUES("483","_bbp_allow_global_access","1","yes");
INSERT INTO `wp_options` VALUES("484","_bbp_default_role","bbp_participant","yes");
INSERT INTO `wp_options` VALUES("485","_bbp_allow_revisions","1","yes");
INSERT INTO `wp_options` VALUES("486","_bbp_enable_favorites","1","yes");
INSERT INTO `wp_options` VALUES("487","_bbp_enable_subscriptions","1","yes");
INSERT INTO `wp_options` VALUES("488","_bbp_allow_topic_tags","1","yes");
INSERT INTO `wp_options` VALUES("489","_bbp_allow_search","1","yes");
INSERT INTO `wp_options` VALUES("490","_bbp_use_wp_editor","1","yes");
INSERT INTO `wp_options` VALUES("491","_bbp_use_autoembed","1","yes");
INSERT INTO `wp_options` VALUES("492","_bbp_thread_replies_depth","2","yes");
INSERT INTO `wp_options` VALUES("493","_bbp_allow_threaded_replies","0","yes");
INSERT INTO `wp_options` VALUES("494","_bbp_topics_per_page","15","yes");
INSERT INTO `wp_options` VALUES("495","_bbp_replies_per_page","15","yes");
INSERT INTO `wp_options` VALUES("496","_bbp_topics_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("497","_bbp_replies_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("498","_bbp_root_slug","forum","yes");
INSERT INTO `wp_options` VALUES("499","_bbp_include_root","1","yes");
INSERT INTO `wp_options` VALUES("500","_bbp_show_on_root","forums","yes");
INSERT INTO `wp_options` VALUES("147","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("8625","_transient__bbp_88.180.124.214_last_posted","1403734526","yes");
INSERT INTO `wp_options` VALUES("9719","_transient__bbp_178.137.163.60_last_posted","1402175272","yes");
INSERT INTO `wp_options` VALUES("10222","_transient__bbp_82.249.73.117_last_posted","1402322808","yes");
INSERT INTO `wp_options` VALUES("65797","_transient__bbp_190.207.166.78_last_posted","1423704946","yes");
INSERT INTO `wp_options` VALUES("63724","_transient__bbp_60.5.252.76_last_posted","1425364951","yes");
INSERT INTO `wp_options` VALUES("63734","_transient__bbp_115.28.85.240_last_posted","1427018133","yes");
INSERT INTO `wp_options` VALUES("827","_transient__bbp_78.213.9.145_last_posted","1399558712","yes");
INSERT INTO `wp_options` VALUES("861","widget_newsletterwidget","a:2:{i:2;a:2:{s:5:\"title\";s:36:\"Inscrivez vous à notre newsletter !\";s:4:\"text\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("112358","_transient_timeout_plugin_slugs","1429362634","no");
INSERT INTO `wp_options` VALUES("112359","_transient_plugin_slugs","a:11:{i:0;s:19:\"akismet/akismet.php\";i:1;s:19:\"bbpress/bbpress.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"email-users/email-users.php\";i:4;s:41:\"google-maps-widget/google-maps-widget.php\";i:5;s:41:\"better-wp-security/better-wp-security.php\";i:6;s:21:\"newsletter/plugin.php\";i:7;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:8;s:21:\"polylang/polylang.php\";i:9;s:27:\"updraftplus/updraftplus.php\";i:10;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";}","no");
INSERT INTO `wp_options` VALUES("99276","newsletter_diagnostic_cron_calls","a:300:{i:0;i:1429193315;i:1;i:1429193648;i:2;i:1429193928;i:3;i:1429194219;i:4;i:1429194640;i:5;i:1429194814;i:6;i:1429195122;i:7;i:1429195414;i:8;i:1429195769;i:9;i:1429196013;i:10;i:1429197424;i:11;i:1429197564;i:12;i:1429197830;i:13;i:1429198116;i:14;i:1429198434;i:15;i:1429198708;i:16;i:1429199012;i:17;i:1429199316;i:18;i:1429199613;i:19;i:1429199980;i:20;i:1429200246;i:21;i:1429200539;i:22;i:1429200576;i:23;i:1429200851;i:24;i:1429201358;i:25;i:1429201441;i:26;i:1429201809;i:27;i:1429202013;i:28;i:1429202404;i:29;i:1429202652;i:30;i:1429202981;i:31;i:1429203221;i:32;i:1429203544;i:33;i:1429203870;i:34;i:1429204140;i:35;i:1429204424;i:36;i:1429204425;i:37;i:1429204706;i:38;i:1429205011;i:39;i:1429205352;i:40;i:1429205744;i:41;i:1429205919;i:42;i:1429206300;i:43;i:1429206686;i:44;i:1429206928;i:45;i:1429207149;i:46;i:1429207459;i:47;i:1429207935;i:48;i:1429208010;i:49;i:1429208355;i:50;i:1429208650;i:51;i:1429209100;i:52;i:1429209215;i:53;i:1429209538;i:54;i:1429209911;i:55;i:1429210229;i:56;i:1429210427;i:57;i:1429210723;i:58;i:1429211053;i:59;i:1429211394;i:60;i:1429211613;i:61;i:1429211941;i:62;i:1429212206;i:63;i:1429212507;i:64;i:1429212807;i:65;i:1429213112;i:66;i:1429213434;i:67;i:1429213718;i:68;i:1429214076;i:69;i:1429214310;i:70;i:1429214687;i:71;i:1429214906;i:72;i:1429215208;i:73;i:1429215508;i:74;i:1429215806;i:75;i:1429216114;i:76;i:1429216325;i:77;i:1429216409;i:78;i:1429216535;i:79;i:1429216722;i:80;i:1429216745;i:81;i:1429216955;i:82;i:1429217021;i:83;i:1429217165;i:84;i:1429217333;i:85;i:1429217375;i:86;i:1429217585;i:87;i:1429217619;i:88;i:1429217795;i:89;i:1429217929;i:90;i:1429217930;i:91;i:1429217997;i:92;i:1429218016;i:93;i:1429218208;i:94;i:1429218226;i:95;i:1429218512;i:96;i:1429218819;i:97;i:1429219119;i:98;i:1429219435;i:99;i:1429219706;i:100;i:1429220017;i:101;i:1429220309;i:102;i:1429220611;i:103;i:1429221224;i:104;i:1429221534;i:105;i:1429221891;i:106;i:1429222289;i:107;i:1429222583;i:108;i:1429222805;i:109;i:1429223163;i:110;i:1429223484;i:111;i:1429223719;i:112;i:1429224032;i:113;i:1429224473;i:114;i:1429224521;i:115;i:1429224978;i:116;i:1429225127;i:117;i:1429225422;i:118;i:1429225755;i:119;i:1429226174;i:120;i:1429226439;i:121;i:1429226735;i:122;i:1429227289;i:123;i:1429227642;i:124;i:1429227829;i:125;i:1429228143;i:126;i:1429228423;i:127;i:1429228783;i:128;i:1429229074;i:129;i:1429229325;i:130;i:1429229611;i:131;i:1429229909;i:132;i:1429230237;i:133;i:1429230507;i:134;i:1429231011;i:135;i:1429231265;i:136;i:1429231779;i:137;i:1429232132;i:138;i:1429232344;i:139;i:1429232649;i:140;i:1429232907;i:141;i:1429233231;i:142;i:1429233630;i:143;i:1429234040;i:144;i:1429234299;i:145;i:1429234413;i:146;i:1429234729;i:147;i:1429235139;i:148;i:1429235340;i:149;i:1429235815;i:150;i:1429235930;i:151;i:1429236314;i:152;i:1429236684;i:153;i:1429237054;i:154;i:1429237129;i:155;i:1429237428;i:156;i:1429237711;i:157;i:1429238206;i:158;i:1429238444;i:159;i:1429238653;i:160;i:1429239001;i:161;i:1429239242;i:162;i:1429239566;i:163;i:1429239830;i:164;i:1429240204;i:165;i:1429240576;i:166;i:1429240874;i:167;i:1429241013;i:168;i:1429241355;i:169;i:1429241713;i:170;i:1429242008;i:171;i:1429242234;i:172;i:1429242532;i:173;i:1429242843;i:174;i:1429243234;i:175;i:1429243408;i:176;i:1429243720;i:177;i:1429244092;i:178;i:1429244322;i:179;i:1429244615;i:180;i:1429244907;i:181;i:1429245293;i:182;i:1429245584;i:183;i:1429246017;i:184;i:1429246106;i:185;i:1429246443;i:186;i:1429246727;i:187;i:1429247123;i:188;i:1429247589;i:189;i:1429247683;i:190;i:1429247906;i:191;i:1429248313;i:192;i:1429248508;i:193;i:1429248897;i:194;i:1429249136;i:195;i:1429249432;i:196;i:1429249781;i:197;i:1429250043;i:198;i:1429250405;i:199;i:1429250658;i:200;i:1429250949;i:201;i:1429251274;i:202;i:1429251607;i:203;i:1429251806;i:204;i:1429252208;i:205;i:1429252463;i:206;i:1429252737;i:207;i:1429253007;i:208;i:1429253372;i:209;i:1429253612;i:210;i:1429253920;i:211;i:1429254212;i:212;i:1429254551;i:213;i:1429254812;i:214;i:1429255170;i:215;i:1429255412;i:216;i:1429255772;i:217;i:1429256012;i:218;i:1429256348;i:219;i:1429256612;i:220;i:1429256952;i:221;i:1429257214;i:222;i:1429257577;i:223;i:1429257812;i:224;i:1429258053;i:225;i:1429258350;i:226;i:1429258653;i:227;i:1429258653;i:228;i:1429258938;i:229;i:1429259241;i:230;i:1429259547;i:231;i:1429259832;i:232;i:1429260140;i:233;i:1429260453;i:234;i:1429260729;i:235;i:1429261053;i:236;i:1429261352;i:237;i:1429261653;i:238;i:1429261950;i:239;i:1429262349;i:240;i:1429262560;i:241;i:1429262868;i:242;i:1429263313;i:243;i:1429263745;i:244;i:1429264027;i:245;i:1429264366;i:246;i:1429264644;i:247;i:1429264928;i:248;i:1429265310;i:249;i:1429265535;i:250;i:1429265823;i:251;i:1429266149;i:252;i:1429266512;i:253;i:1429266930;i:254;i:1429267053;i:255;i:1429267376;i:256;i:1429267760;i:257;i:1429268087;i:258;i:1429268405;i:259;i:1429268542;i:260;i:1429268972;i:261;i:1429269147;i:262;i:1429269599;i:263;i:1429269810;i:264;i:1429270098;i:265;i:1429270356;i:266;i:1429270717;i:267;i:1429270926;i:268;i:1429271247;i:269;i:1429271542;i:270;i:1429272160;i:271;i:1429272454;i:272;i:1429272775;i:273;i:1429273040;i:274;i:1429273431;i:275;i:1429273864;i:276;i:1429273933;i:277;i:1429274254;i:278;i:1429274524;i:279;i:1429275112;i:280;i:1429275164;i:281;i:1429275453;i:282;i:1429275814;i:283;i:1429276053;i:284;i:1429276332;i:285;i:1429276623;i:286;i:1429276718;i:287;i:1429276923;i:288;i:1429277230;i:289;i:1429277531;i:290;i:1429277869;i:291;i:1429278124;i:292;i:1429278241;i:293;i:1429278478;i:294;i:1429278883;i:295;i:1429279063;i:296;i:1429279377;i:297;i:1429279553;i:298;i:1429279636;i:299;i:1429280067;}","no");
INSERT INTO `wp_options` VALUES("99285","wpmm_settings","a:3:{s:7:\"general\";a:10:{s:6:\"status\";i:1;s:11:\"bypass_bots\";i:0;s:12:\"backend_role\";s:13:\"administrator\";s:13:\"frontend_role\";s:13:\"administrator\";s:11:\"meta_robots\";i:0;s:11:\"redirection\";s:0:\"\";s:7:\"exclude\";a:3:{i:0;s:4:\"feed\";i:1;s:8:\"wp-login\";i:2;s:5:\"login\";}s:6:\"notice\";i:1;s:10:\"admin_link\";i:0;s:11:\"status_date\";s:19:\"2015-04-02 07:34:45\";}s:6:\"design\";a:10:{s:5:\"title\";s:16:\"Mode Maintenance\";s:7:\"heading\";s:16:\"Mode Maintenance\";s:13:\"heading_color\";s:7:\"#ffffff\";s:4:\"text\";s:223:\"<p>Le site des 48h de la Pige fait peau neuve pour son édition 2015 qui se tiendra les 2 et 3 juillet à Strasbourg.</p>
<p>Très bientôt, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !</p>\";s:10:\"text_color\";s:7:\"#1e73be\";s:7:\"bg_type\";s:10:\"predefined\";s:8:\"bg_color\";s:0:\"\";s:9:\"bg_custom\";s:0:\"\";s:13:\"bg_predefined\";s:7:\"bg4.jpg\";s:10:\"custom_css\";a:3:{s:13:\"heading_color\";s:28:\".wrap h1 { color: #ffffff; }\";s:10:\"text_color\";s:28:\".wrap h2 { color: #1e73be; }\";s:6:\"bg_url\";s:180:\".background { background: url(http://48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }\";}}s:7:\"modules\";a:22:{s:16:\"countdown_status\";i:0;s:15:\"countdown_start\";s:19:\"2015-03-30 11:34:16\";s:17:\"countdown_details\";a:3:{s:4:\"days\";s:2:\"10\";s:5:\"hours\";s:1:\"1\";s:7:\"minutes\";s:1:\"0\";}s:15:\"countdown_color\";s:0:\"\";s:16:\"subscribe_status\";i:0;s:14:\"subscribe_text\";s:30:\"Me notifier quand c\\\'est prêt\";s:20:\"subscribe_text_color\";s:0:\"\";s:13:\"social_status\";i:0;s:13:\"social_target\";i:1;s:13:\"social_github\";s:0:\"\";s:15:\"social_dribbble\";s:0:\"\";s:14:\"social_twitter\";s:0:\"\";s:15:\"social_facebook\";s:0:\"\";s:16:\"social_pinterest\";s:0:\"\";s:14:\"social_google+\";s:0:\"\";s:15:\"social_linkedin\";s:0:\"\";s:14:\"contact_status\";i:0;s:13:\"contact_email\";s:17:\"max.twa@gmail.com\";s:15:\"contact_effects\";s:20:\"move_top|move_bottom\";s:9:\"ga_status\";i:0;s:7:\"ga_code\";s:0:\"\";s:10:\"custom_css\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("167","widget_akismet_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("129","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1398350987;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("130","current_theme","Enfold","yes");
INSERT INTO `wp_options` VALUES("131","theme_mods_enfold","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:5:\"avia3\";i:33;s:4:\"avia\";i:33;}}","yes");
INSERT INTO `wp_options` VALUES("132","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("133","enfold_layerslider_activated","1","yes");
INSERT INTO `wp_options` VALUES("134","shop_catalog_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("135","shop_single_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("136","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("137","avia_woocommerce_column_count","3","yes");
INSERT INTO `wp_options` VALUES("138","avia_woocommerce_product_count","15","yes");
INSERT INTO `wp_options` VALUES("139","woocommerce_single_image_crop","no","yes");
INSERT INTO `wp_options` VALUES("114978","_transient_timeout_avia_theme_latest_version","1429881009","no");
INSERT INTO `wp_options` VALUES("114979","_transient_avia_theme_latest_version","<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<notifier version=\"1.0\">
 <LatestVersion>
  <version>1.3</version>
 </LatestVersion>
 <PreviousVersions>
 </PreviousVersions>
</notifier>
","no");
INSERT INTO `wp_options` VALUES("142","enfold_woo_settings_enabled","1","yes");
INSERT INTO `wp_options` VALUES("143","avia_options_enfold","a:1:{s:4:\"avia\";a:94:{s:17:\"avia-nonce-import\";s:10:\"947b4125f1\";s:9:\"frontpage\";s:3:\"734\";s:9:\"undefined\";s:32:\"header_setting::{contains}social\";s:8:\"blogpage\";s:0:\"\";s:4:\"logo\";s:69:\"http://48h.pigiste.org/wp-content/uploads/2013/04/48hbyPP-300x158.png\";s:7:\"favicon\";s:64:\"http://48h.pigiste.org/wp-content/uploads/2013/04/favicon-01.png\";s:9:\"analytics\";s:0:\"\";s:12:\"color_scheme\";s:11:\"Black-White\";s:14:\"google_webfont\";s:17:\"Open Sans:400,600\";s:12:\"default_font\";s:17:\"Open Sans:400,600\";s:16:\"color-body_style\";s:9:\"stretched\";s:16:\"color-body_color\";s:7:\"#333333\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#1bbce9\";s:31:\"colorset-header_color-secondary\";s:7:\"#1bbce9\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#000000\";s:29:\"colorset-main_color-secondary\";s:7:\"#666666\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#111111\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#222222\";s:32:\"colorset-alternate_color-primary\";s:7:\"#000000\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#bdbdbd\";s:30:\"colorset-alternate_color-color\";s:7:\"#888888\";s:31:\"colorset-alternate_color-border\";s:7:\"#333333\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#000000\";s:25:\"colorset-footer_color-bg2\";s:7:\"#222222\";s:29:\"colorset-footer_color-primary\";s:7:\"#aaaaaa\";s:31:\"colorset-footer_color-secondary\";s:7:\"#ffffff\";s:27:\"colorset-footer_color-color\";s:7:\"#aaaaaa\";s:28:\"colorset-footer_color-border\";s:7:\"#555555\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:13:\"center center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#333333\";s:25:\"colorset-socket_color-bg2\";s:7:\"#000000\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#eeeeee\";s:27:\"colorset-socket_color-color\";s:7:\"#eeeeee\";s:28:\"colorset-socket_color-border\";s:7:\"#333333\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:9:\"quick_css\";s:8:\"[nolink]\";s:17:\"responsive_layout\";s:10:\"responsive\";s:15:\"websave_windows\";s:6:\"active\";s:10:\"blog_style\";s:10:\"single-big\";s:17:\"single_post_style\";s:10:\"single-big\";s:15:\"iconfont_upload\";s:0:\"\";s:14:\"header_setting\";s:12:\"fixed_header\";s:5:\"phone\";s:0:\"\";s:12:\"social_icons\";a:4:{i:0;a:2:{s:11:\"social_icon\";s:8:\"facebook\";s:16:\"social_icon_link\";s:34:\"https://www.facebook.com/kriesi.at\";}i:1;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:1:\"#\";}i:2;a:2:{s:11:\"social_icon\";s:5:\"skype\";s:16:\"social_icon_link\";s:0:\"\";}i:3;a:2:{s:11:\"social_icon\";s:4:\"mail\";s:16:\"social_icon_link\";s:0:\"\";}}s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:11:\"header_menu\";s:16:\"mobile_drop_down\";s:14:\"archive_layout\";s:8:\"fullsize\";s:11:\"blog_layout\";s:8:\"fullsize\";s:13:\"single_layout\";s:8:\"fullsize\";s:11:\"page_layout\";s:8:\"fullsize\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:8:\"disabled\";s:22:\"display_widgets_socket\";s:15:\"nofooterwidgets\";s:14:\"footer_columns\";s:1:\"2\";s:9:\"copyright\";s:89:\"&copy; Les 48h de la pige 2014 - Un &eacute;v&eacute;nement Profession : Pigiste [nolink]\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("202","avia_permalink_settings","a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}","yes");
INSERT INTO `wp_options` VALUES("204","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("200","_transient_twentyfourteen_category_count","5","yes");
INSERT INTO `wp_options` VALUES("145","avia_stylesheet_dir_writableenfold","true","yes");
INSERT INTO `wp_options` VALUES("146","avia_stylesheet_existsenfold","true","yes");
INSERT INTO `wp_options` VALUES("169","widget_bbp_views_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("170","widget_bbp_search_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("171","widget_bbp_forums_widget","a:3:{i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:6:\"Forums\";s:12:\"parent_forum\";s:3:\"any\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("172","widget_bbp_topics_widget","a:3:{i:1;a:0:{}i:2;a:6:{s:5:\"title\";s:15:\"Sujets récents\";s:8:\"order_by\";s:7:\"newness\";s:12:\"parent_forum\";s:3:\"any\";s:9:\"show_date\";b:0;s:9:\"show_user\";b:0;s:9:\"max_shown\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("173","widget_bbp_replies_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("174","widget_bbp_stats_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("194","shop_order_status_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114419","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("254","portfolio_entries_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("193","product_cat_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("203","avia_rewrite_flush","1","yes");
INSERT INTO `wp_options` VALUES("114418","_transient_pll_languages_list","a:2:{i:0;a:20:{s:7:\"term_id\";i:44;s:4:\"name\";s:9:\"Français\";s:4:\"slug\";s:2:\"fr\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:44;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"fr_FR\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:220;s:10:\"tl_term_id\";i:45;s:19:\"tl_term_taxonomy_id\";i:45;s:8:\"tl_count\";i:14;s:6:\"locale\";R:9;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:66:\"http://48h.pigiste.org/wp-content/plugins/polylang/flags/fr_FR.png\";s:4:\"flag\";s:798:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGzSURBVHjaYiyeepkBBv79+Zfnx/f379+fP38CyT9//jAyMiq5GP77wvDnJ8MfoAIGBoAAYgGqC7STApL///3/9++/pCTv////Qdz/QO4/IMna0vf/z+9/v379//37bUUTQACBNDD8Z/j87fffvyAVX79+/Q8GQDbQeKA9fM+e/Pv18/+vnwzCIkBLAAKQOAY5AIAwCEv4/4PddNUm3ji0QJyxW3rgzE0iLfqDGr2oYuu0l54AYvnz5x9Q6d+/QPQfyAQqAin9B3EOyG1A1UDj//36zfjr1y8GBoAAFI9BDgAwCMIw+P8Ho3GDO6XQ0l4MN8b2kUwYaLszqgKM/KHcDXwBxAJUD3TJ779A8h9Q5D8SAHoARP36+Rfo41+/mcA2AAQQy49ff0Cu//MPpAeI/0FdA1QNYYNVA/3wmwEYVgwMAAHE8uPHH5BqoD1//gJJLADoJKDS378Z//wFhhJAALF8A3rizz8uTmYg788fJkj4QOKREQyYxSWBhjEC/fcXZANAALF8+/anbcHlHz9+ffvx58uPX9KckkCn/gby/wLd8uvHjx96k+cD1UGiGQgAAgwA7q17ZpsMdUQAAAAASUVORK5CYII=\" title=\"Français\" alt=\"Français\" />\";s:8:\"home_url\";s:26:\"http://48h.pigiste.org/fr/\";s:10:\"search_url\";s:26:\"http://48h.pigiste.org/fr/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19724\";}i:1;a:20:{s:7:\"term_id\";i:60;s:4:\"name\";s:7:\"English\";s:4:\"slug\";s:2:\"en\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:60;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"en_GB\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:0;s:10:\"tl_term_id\";i:61;s:19:\"tl_term_taxonomy_id\";i:61;s:8:\"tl_count\";i:0;s:6:\"locale\";R:29;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:66:\"http://48h.pigiste.org/wp-content/plugins/polylang/flags/en_GB.png\";s:4:\"flag\";s:866:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAflJREFUeNpinDRzn5qN3uFDt16+YWBg+Pv339+KGN0rbVP+//2rW5tf0Hfy/2+mr99+yKpyOl3Ydt8njEWIn8f9zj639NC7j78eP//8739GVUUhNUNuhl8//ysKeZrJ/v7z10Zb2PTQTIY1XZO2Xmfad+f7XgkXxuUrVB6cjPVXef78JyMjA8PFuwyX7gAZj97+T2e9o3d4BWNp84K1NzubTjAB3fH0+fv6N3qP/ir9bW6ozNQCijB8/8zw/TuQ7r4/ndvN5mZgkpPXiis3Pv34+ZPh5t23//79Rwehof/9/NDEgMrOXHvJcrllgpoRN8PFOwy/fzP8+gUlgZI/f/5xcPj/69e/37//AUX+/mXRkN555gsOG2xt/5hZQMwF4r9///75++f3nz8nr75gSms82jfvQnT6zqvXPjC8e/srJQHo9P9fvwNtAHmG4f8zZ6dDc3bIyM2LTNlsbtfM9OPHH3FhtqUz3eXX9H+cOy9ZMB2o6t/Pn0DHMPz/b+2wXGTvPlPGFxdcD+mZyjP8+8MUE6sa7a/xo6Pykn1s4zdzIZ6///8zMGpKM2pKAB0jqy4UE7/msKat6Jw5mafrsxNtWZ6/fjvNLW29qv25pQd///n+5+/fxDDVbcc//P/zx/36m5Ub9zL8+7t66yEROcHK7q5bldMBAgwADcRBCuVLfoEAAAAASUVORK5CYII=\" title=\"English\" alt=\"English\" />\";s:8:\"home_url\";s:26:\"http://48h.pigiste.org/en/\";s:10:\"search_url\";s:26:\"http://48h.pigiste.org/en/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19725\";}}","yes");
INSERT INTO `wp_options` VALUES("114426","rewrite_rules","a:160:{s:8:\"forum/?$\";s:25:\"index.php?post_type=forum\";s:38:\"forum/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:33:\"forum/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:25:\"forum/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"sujets/?$\";s:25:\"index.php?post_type=topic\";s:39:\"sujets/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"sujets/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"sujets/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:27:\"forum/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:27:\"forum/sujet/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:30:\"forum/repondre/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:29:\"forum/mot-cle/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:54:\"forum/utilisateurs/([^/]+)/sujets/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/réponses/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:55:\"forum/utilisateurs/([^/]+)/favoris/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/souscrire/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:36:\"forum/utilisateurs/([^/]+)/sujets/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:39:\"forum/utilisateurs/([^/]+)/réponses/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:37:\"forum/utilisateurs/([^/]+)/favoris/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:39:\"forum/utilisateurs/([^/]+)/souscrire/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:34:\"forum/utilisateurs/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:29:\"forum/utilisateurs/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:48:\"forum/voir-le-sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:35:\"forum/voir-le-sujet/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:30:\"forum/voir-le-sujet/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:37:\"forum/rechercher/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:19:\"forum/rechercher/?$\";s:20:\"index.php?bbp_search\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"forum/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"forum/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"forum/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:50:\"forum/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:45:\"forum/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:38:\"forum/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:45:\"forum/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:39:\"forum/sujet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"forum/sujet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"forum/sujet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:52:\"forum/sujet/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:47:\"forum/sujet/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:40:\"forum/sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:47:\"forum/sujet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:28:\"forum/sujet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"forum/sujet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"forum/sujet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"forum/repondre/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"forum/repondre/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"forum/repondre/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"forum/repondre/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"forum/repondre/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forum/repondre/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:43:\"forum/repondre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:50:\"forum/repondre/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:35:\"forum/repondre/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:31:\"forum/repondre/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"forum/repondre/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"forum/repondre/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"forum/repondre/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"forum/repondre/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"forum/mot-cle/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:49:\"forum/mot-cle/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:42:\"forum/mot-cle/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:24:\"forum/mot-cle/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:45:\"forum/rechercher/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:27:\"forum/rechercher/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO `wp_options` VALUES("114980","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1429287010","yes");
INSERT INTO `wp_options` VALUES("114981","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"4916\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3078\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3022\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2529\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2346\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1892\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1729\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1680\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1678\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1676\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1612\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1609\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1505\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1322\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1276\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1175\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1171\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1083\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1079\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"918\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"905\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"874\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"843\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"837\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"794\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"758\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"748\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"709\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"700\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"692\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"682\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"657\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"649\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"642\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"642\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"623\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"620\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"605\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"600\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"593\";}}","yes");
INSERT INTO `wp_options` VALUES("212","gmw_options","a:4:{s:13:\"first_version\";s:4:\"1.60\";s:13:\"first_install\";i:1398358539;s:13:\"last_tracking\";i:1429204176;s:14:\"allow_tracking\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("213","widget_googlemapswidget","a:2:{i:2;a:22:{s:5:\"title\";s:47:\"Rendez-vous au campus Albert Londres à Vichy !\";s:7:\"address\";s:43:\"Pôle technologique et universitaire, Vichy\";s:15:\"thumb_pin_color\";s:4:\"gray\";s:14:\"thumb_pin_size\";s:7:\"default\";s:11:\"thumb_width\";i:500;s:12:\"thumb_height\";i:300;s:10:\"thumb_zoom\";s:2:\"13\";s:10:\"thumb_type\";s:7:\"roadmap\";s:15:\"thumb_link_type\";s:8:\"lightbox\";s:10:\"thumb_link\";s:0:\"\";s:12:\"thumb_header\";s:0:\"\";s:12:\"thumb_footer\";s:0:\"\";s:16:\"thumb_new_colors\";b:1;s:14:\"lightbox_width\";i:600;s:15:\"lightbox_height\";i:400;s:13:\"lightbox_type\";s:1:\"m\";s:13:\"lightbox_zoom\";s:2:\"14\";s:15:\"lightbox_bubble\";b:1;s:14:\"lightbox_title\";b:0;s:15:\"lightbox_header\";s:0:\"\";s:15:\"lightbox_footer\";s:0:\"\";s:13:\"lightbox_skin\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("599","newsletter_main_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("600","newsletter","a:26:{s:12:\"profile_text\";s:104:\"{profile_form}<p>To cancel your subscription, <a href=\'{unsubscription_confirm_url}\'>click here</a>.</p>\";s:10:\"error_text\";s:173:\"<p>This subscription can\'t be completed, sorry. The email address is blocked or already subscribed. You should contact the owner to unlock that email address. Thank you.</p>\";s:22:\"already_confirmed_text\";s:99:\"<p>This email address is already subscribed, anyway a welcome email has been resent. Thank you.</p>\";s:18:\"subscribe_wp_users\";s:1:\"0\";s:17:\"subscription_text\";s:19:\"{subscription_form}\";s:17:\"confirmation_text\";s:167:\"<p>Votre demande d\'inscription est enregistr&eacute;e. Merci ! Un e-mail de confirmation vous a été envoyé. V&eacute;rifier &eacute;galement votre dossier spam.</p>\";s:20:\"confirmation_subject\";s:66:\"Inscription &agrave; la lettre d&prime;information de {blog_title}\";s:20:\"confirmation_message\";s:517:\"<p>Bonjour {name}!</p>
<p>Vous recevez cet e-mail car nous avons enregistr&eacute; une demande d&prime;inscription &agrave; la lettre d&prime;infrmation de {blog_title}.
Merci de confirmer votre inscription en cliquant sur le lien suivant : <a href=\"{subscription_confirm_url}\"><strong>je confirme mon inscription.</strong></a>.
Si le lien ne fonctionne pas, merci d\'utiliser cette adresse :</p>
<p>{subscription_confirm_url}</p>
<p>Ignorez ce message si vous n\'avez pas effectué de demande.</p>
<p>Merci !</p>\";s:14:\"confirmed_text\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:17:\"confirmed_subject\";s:17:\"Bienvenue, {name}\";s:17:\"confirmed_message\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:19:\"unsubscription_text\";s:160:\"<p>&Ecirc;tes-vous certain de vouloir vous d&eacute;sinscrire de la lettre d&prime;information de {blog_title} ? <a href=\"{unsubscription_confirm_url}\">Oui</a>.\";s:17:\"unsubscribed_text\";s:153:\"<p>Vous n&prime;&ecirc;tes plus abonn&eacute; &agrave; la lettre d\'information de {blog_title}. Merci de nous avoir suivi et &agrave; bient&ocirc;t !</p>\";s:20:\"unsubscribed_subject\";s:18:\"Au revoir {name} !\";s:20:\"unsubscribed_message\";s:108:\"<p>Cet email confirme votre désinscription à notre newsletter<br>
<a href=\'{blog_url}\'>{blog_url}</a></p>\";s:14:\"noconfirmation\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:8:\"novisual\";s:1:\"0\";s:6:\"notify\";s:1:\"0\";s:12:\"notify_email\";s:0:\"\";s:16:\"confirmation_url\";s:0:\"\";s:13:\"confirmed_url\";s:0:\"\";s:18:\"confirmed_tracking\";s:0:\"\";s:13:\"profile_saved\";s:0:\"\";s:24:\"subscribe_wp_users_label\";s:0:\"\";s:10:\"wp_welcome\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("214","avia_sidebars","a:5:{i:0;s:10:\"Google Map\";i:1;s:10:\"Live Tweet\";i:2;s:7:\"Contact\";i:3;s:11:\"Login forum\";i:4;s:13:\"Recent topics\";}","yes");
INSERT INTO `wp_options` VALUES("262","widget_oauth_twitter_widget","a:2:{i:2;a:12:{s:4:\"user\";s:6:\"pigist\";s:5:\"count\";s:0:\"\";s:11:\"widgetTitle\";s:0:\"\";s:12:\"widgetFooter\";s:0:\"\";s:16:\"oAuthAccessToken\";s:0:\"\";s:22:\"oAuthAccessTokenSecret\";s:0:\"\";s:11:\"consumerKey\";s:0:\"\";s:14:\"consumerSecret\";s:0:\"\";s:17:\"showTwitterIconTF\";b:0;s:16:\"showProfilePicTF\";b:0;s:15:\"showTweetTimeTF\";b:0;s:16:\"includeRepliesTF\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("263","_transient_random_seed","c40f49789ebee4bd8cbc4b27761f00f2","yes");
INSERT INTO `wp_options` VALUES("99286","wpmm_version","2.0.3","yes");
INSERT INTO `wp_options` VALUES("114265","updraft_interval_increments","","yes");
INSERT INTO `wp_options` VALUES("114266","updraft_retain","8","yes");
INSERT INTO `wp_options` VALUES("114267","updraft_retain_db","20","yes");
INSERT INTO `wp_options` VALUES("562","_transient__bbp_2a01:e34:ed50:9910:c08c:8ed3:d3f9:8470_last_post","1399455139","yes");
INSERT INTO `wp_options` VALUES("597","newsletter_logger_secret","5180c642","yes");
INSERT INTO `wp_options` VALUES("598","newsletter_main","a:20:{s:12:\"sender_email\";s:26:\"newsletter@48h.pigiste.org\";s:11:\"sender_name\";s:18:\"Les 48h de la pige\";s:11:\"return_path\";N;s:8:\"reply_to\";s:23:\"raphaelbaldos@gmail.com\";s:12:\"contract_key\";s:0:\"\";s:13:\"scheduler_max\";s:3:\"100\";s:6:\"editor\";s:1:\"0\";s:7:\"api_key\";s:10:\"186aecbfd3\";s:3:\"css\";s:0:\"\";s:25:\"content_transfer_encoding\";s:0:\"\";s:12:\"smtp_enabled\";s:1:\"0\";s:9:\"smtp_host\";s:0:\"\";s:9:\"smtp_port\";s:0:\"\";s:11:\"smtp_secure\";s:0:\"\";s:9:\"smtp_user\";s:0:\"\";s:9:\"smtp_pass\";s:0:\"\";s:15:\"smtp_test_email\";s:0:\"\";s:8:\"lock_ids\";s:0:\"\";s:8:\"lock_url\";s:0:\"\";s:12:\"lock_message\";s:107:\"This content is protected, only newsletter subscribers can access it. Subscribe now!

{subscription_form}\";}","yes");
INSERT INTO `wp_options` VALUES("602","newsletter_subscription_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("603","newsletter_emails","a:12:{s:5:\"theme\";s:10:\"vimeo-like\";s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("604","newsletter_emails_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("605","newsletter_emails_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("606","newsletter_users","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("607","newsletter_users_version","1.0.4","yes");
INSERT INTO `wp_options` VALUES("608","newsletter_statistics","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("609","newsletter_statistics_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("610","newsletter_feed","a:2:{s:5:\"theme\";s:7:\"default\";s:12:\"subscription\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("611","newsletter_feed_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("612","newsletter_feed_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("601","newsletter_profile","a:61:{s:5:\"email\";s:5:\"Email\";s:11:\"email_error\";s:24:\"The email is not correct\";s:4:\"name\";s:4:\"Name\";s:10:\"name_error\";s:23:\"The name is not correct\";s:11:\"name_status\";i:0;s:10:\"name_rules\";i:0;s:7:\"surname\";s:9:\"Last name\";s:13:\"surname_error\";s:28:\"The last name is not correct\";s:14:\"surname_status\";i:0;s:3:\"sex\";s:3:\"I\'m\";s:7:\"privacy\";s:51:\"Subscribing I accept the privacy rules of this site\";s:13:\"privacy_error\";s:37:\"You must accept the privacy statement\";s:14:\"privacy_status\";i:0;s:9:\"subscribe\";s:9:\"Subscribe\";s:4:\"save\";s:4:\"Save\";s:12:\"title_female\";s:4:\"Mrs.\";s:10:\"title_male\";s:3:\"Mr.\";s:10:\"title_none\";s:4:\"Dear\";s:8:\"sex_male\";s:3:\"Man\";s:10:\"sex_female\";s:5:\"Woman\";s:8:\"sex_none\";s:4:\"None\";s:13:\"list_1_status\";i:0;s:13:\"list_2_status\";i:0;s:13:\"list_3_status\";i:0;s:13:\"list_4_status\";i:0;s:13:\"list_5_status\";i:0;s:13:\"list_6_status\";i:0;s:13:\"list_7_status\";i:0;s:13:\"list_8_status\";i:0;s:13:\"list_9_status\";i:0;s:14:\"list_10_status\";i:0;s:14:\"list_11_status\";i:0;s:14:\"list_12_status\";i:0;s:14:\"list_13_status\";i:0;s:14:\"list_14_status\";i:0;s:14:\"list_15_status\";i:0;s:14:\"list_16_status\";i:0;s:14:\"list_17_status\";i:0;s:14:\"list_18_status\";i:0;s:14:\"list_19_status\";i:0;s:14:\"list_20_status\";i:0;s:16:\"profile_1_status\";i:0;s:16:\"profile_2_status\";i:0;s:16:\"profile_3_status\";i:0;s:16:\"profile_4_status\";i:0;s:16:\"profile_5_status\";i:0;s:16:\"profile_6_status\";i:0;s:16:\"profile_7_status\";i:0;s:16:\"profile_8_status\";i:0;s:16:\"profile_9_status\";i:0;s:17:\"profile_10_status\";i:0;s:17:\"profile_11_status\";i:0;s:17:\"profile_12_status\";i:0;s:17:\"profile_13_status\";i:0;s:17:\"profile_14_status\";i:0;s:17:\"profile_15_status\";i:0;s:17:\"profile_16_status\";i:0;s:17:\"profile_17_status\";i:0;s:17:\"profile_18_status\";i:0;s:17:\"profile_19_status\";i:0;s:17:\"profile_20_status\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("624","newsletter_emails_theme_vimeo-like","a:11:{s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("617","newsletter_feed_available_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("616","newsletter_reports_available_version","1.0.7","yes");
INSERT INTO `wp_options` VALUES("618","newsletter_followup_available_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("619","newsletter_facebook_available_version","1.1.3","yes");
INSERT INTO `wp_options` VALUES("620","newsletter_sendgrid_available_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("621","newsletter_popup_available_version","1.0.5","yes");
INSERT INTO `wp_options` VALUES("622","newsletter_mandrill_available_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("623","newsletter_mailjet_available_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("919","auto_core_update_notified","a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:17:\"max.twa@gmail.com\";s:7:\"version\";s:5:\"4.0.1\";s:9:\"timestamp\";i:1416530671;}","yes");
INSERT INTO `wp_options` VALUES("99151","_site_transient_timeout_browser_664efc36c93685cc0a4b220f6b21652f","1428309676","yes");
INSERT INTO `wp_options` VALUES("99152","_site_transient_browser_664efc36c93685cc0a4b220f6b21652f","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"6.1.6\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("61039","_transient__bbp_218.204.140.212_last_posted","1426733724","yes");
INSERT INTO `wp_options` VALUES("99375","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429278246;s:7:\"checked\";a:2:{s:6:\"enfold\";s:5:\"2.4.5\";s:13:\"twentyfifteen\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("11140","_transient__bbp_81.65.161.8_last_posted","1402822926","yes");
INSERT INTO `wp_options` VALUES("11199","_transient__bbp_90.28.60.18_last_posted","1402498697","yes");
INSERT INTO `wp_options` VALUES("11337","_transient__bbp_2.10.234.105_last_posted","1402516429","yes");
INSERT INTO `wp_options` VALUES("8069","_transient__bbp_82.249.237.149_last_posted","1401881839","yes");
INSERT INTO `wp_options` VALUES("114264","updraft_interval_database","daily","yes");
INSERT INTO `wp_options` VALUES("114263","updraft_interval","daily","yes");
INSERT INTO `wp_options` VALUES("113893","_site_transient_timeout_browser_4e23a6000876e66a7ec0dd24366f9a45","1429797250","yes");
INSERT INTO `wp_options` VALUES("113894","_site_transient_browser_4e23a6000876e66a7ec0dd24366f9a45","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("40309","_transient__bbp_117.26.252.17_last_posted","1418119364","yes");
INSERT INTO `wp_options` VALUES("65300","_transient__bbp_82.211.201.188_last_posted","1424791982","yes");
INSERT INTO `wp_options` VALUES("99262","WPLANG","fr_FR","yes");
INSERT INTO `wp_options` VALUES("99374","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.1.1\";s:7:\"version\";s:5:\"4.1.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1429278242;s:15:\"version_checked\";s:5:\"4.1.1\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("65316","_transient__bbp_59.61.79.124_last_posted","1427185641","yes");
INSERT INTO `wp_options` VALUES("63774","_transient__bbp_183.221.217.205_last_posted","1423484161","yes");
INSERT INTO `wp_options` VALUES("63814","_transient__bbp_176.31.138.187_last_posted","1427123537","yes");
INSERT INTO `wp_options` VALUES("63845","_transient__bbp_62.109.17.73_last_posted","1424851235","yes");
INSERT INTO `wp_options` VALUES("63898","_transient__bbp_183.220.105.76_last_posted","1423492753","yes");
INSERT INTO `wp_options` VALUES("63965","_transient__bbp_183.222.159.219_last_posted","1423502784","yes");
INSERT INTO `wp_options` VALUES("63978","_transient__bbp_190.198.160.73_last_posted","1423953689","yes");
INSERT INTO `wp_options` VALUES("64007","_transient__bbp_186.95.25.190_last_posted","1423507591","yes");
INSERT INTO `wp_options` VALUES("64026","_transient__bbp_117.21.193.1_last_posted","1423509348","yes");
INSERT INTO `wp_options` VALUES("64030","_transient__bbp_186.95.95.24_last_posted","1423509729","yes");
INSERT INTO `wp_options` VALUES("64058","_transient__bbp_183.223.218.51_last_posted","1423513012","yes");
INSERT INTO `wp_options` VALUES("64074","_transient__bbp_58.252.72.179_last_posted","1427347476","yes");
INSERT INTO `wp_options` VALUES("64108","_transient__bbp_186.95.245.156_last_posted","1423518355","yes");
INSERT INTO `wp_options` VALUES("64127","_transient__bbp_186.91.89.55_last_posted","1423520405","yes");
INSERT INTO `wp_options` VALUES("64146","_transient__bbp_5.153.59.141_last_posted","1423523293","yes");
INSERT INTO `wp_options` VALUES("64147","_transient__bbp_202.106.169.228_last_posted","1423523304","yes");
INSERT INTO `wp_options` VALUES("64169","_transient__bbp_183.218.63.59_last_posted","1427190438","yes");
INSERT INTO `wp_options` VALUES("64170","_transient__bbp_186.93.9.74_last_posted","1423953122","yes");
INSERT INTO `wp_options` VALUES("64189","_transient__bbp_175.43.20.95_last_posted","1427701755","yes");
INSERT INTO `wp_options` VALUES("64190","_transient__bbp_134.208.39.180_last_posted","1423745464","yes");
INSERT INTO `wp_options` VALUES("64212","_transient__bbp_117.173.20.148_last_posted","1423530695","yes");
INSERT INTO `wp_options` VALUES("64262","_transient__bbp_118.201.155.68_last_posted","1423535895","yes");
INSERT INTO `wp_options` VALUES("64287","_transient__bbp_223.85.81.185_last_posted","1423538149","yes");
INSERT INTO `wp_options` VALUES("64291","_transient__bbp_218.78.210.190_last_posted","1427393513","yes");
INSERT INTO `wp_options` VALUES("64337","_transient__bbp_203.192.10.66_last_posted","1426248807","yes");
INSERT INTO `wp_options` VALUES("64362","_transient__bbp_111.10.49.29_last_posted","1423546001","yes");
INSERT INTO `wp_options` VALUES("64378","_transient__bbp_49.4.180.70_last_posted","1423547753","yes");
INSERT INTO `wp_options` VALUES("64419","_transient__bbp_117.173.22.54_last_posted","1423552271","yes");
INSERT INTO `wp_options` VALUES("64420","_transient__bbp_183.220.105.71_last_posted","1423552419","yes");
INSERT INTO `wp_options` VALUES("64463","_transient__bbp_183.224.1.12_last_posted","1426953680","yes");
INSERT INTO `wp_options` VALUES("64467","_transient__bbp_58.214.5.226_last_posted","1427593816","yes");
INSERT INTO `wp_options` VALUES("64468","_transient__bbp_201.243.195.187_last_posted","1423557249","yes");
INSERT INTO `wp_options` VALUES("64487","_transient__bbp_117.21.193.2_last_posted","1423559619","yes");
INSERT INTO `wp_options` VALUES("64545","_transient__bbp_183.222.152.201_last_posted","1423565496","yes");
INSERT INTO `wp_options` VALUES("64621","_transient__bbp_223.86.68.253_last_posted","1423573827","yes");
INSERT INTO `wp_options` VALUES("64622","_transient__bbp_183.224.1.13_last_posted","1427062896","yes");
INSERT INTO `wp_options` VALUES("64638","_transient__bbp_123.110.131.167_last_posted","1423575526","yes");
INSERT INTO `wp_options` VALUES("64642","_transient__bbp_61.57.90.29_last_posted","1423575571","yes");
INSERT INTO `wp_options` VALUES("64671","_transient__bbp_200.124.225.76_last_posted","1423579150","yes");
INSERT INTO `wp_options` VALUES("64690","_transient__bbp_183.220.198.87_last_posted","1423580720","yes");
INSERT INTO `wp_options` VALUES("64727","_transient__bbp_183.178.197.181_last_posted","1423586052","yes");
INSERT INTO `wp_options` VALUES("64731","_transient__bbp_211.141.130.96_last_posted","1427363376","yes");
INSERT INTO `wp_options` VALUES("64808","_transient__bbp_190.202.173.94_last_posted","1424324464","yes");
INSERT INTO `wp_options` VALUES("64854","_transient__bbp_186.91.59.144_last_posted","1423599087","yes");
INSERT INTO `wp_options` VALUES("64864","_transient__bbp_140.123.124.150_last_posted","1423600593","yes");
INSERT INTO `wp_options` VALUES("64973","_transient__bbp_78.36.205.18_last_posted","1423926395","yes");
INSERT INTO `wp_options` VALUES("65027","_transient__bbp_213.114.238.64_last_posted","1423619954","yes");
INSERT INTO `wp_options` VALUES("64990","_transient__bbp_200.90.84.103_last_posted","1423615480","yes");
INSERT INTO `wp_options` VALUES("65067","_transient__bbp_130.255.61.211_last_posted","1426153245","yes");
INSERT INTO `wp_options` VALUES("65074","_transient__bbp_115.43.17.163_last_posted","1423625345","yes");
INSERT INTO `wp_options` VALUES("65081","_transient__bbp_117.173.21.247_last_posted","1423626226","yes");
INSERT INTO `wp_options` VALUES("65100","_transient__bbp_183.203.208.179_last_posted","1427114867","yes");
INSERT INTO `wp_options` VALUES("65110","_transient__bbp_223.86.67.235_last_posted","1423630541","yes");
INSERT INTO `wp_options` VALUES("65141","_transient__bbp_142.4.212.20_last_posted","1423633689","yes");
INSERT INTO `wp_options` VALUES("65203","_transient__bbp_121.243.51.107_last_posted","1424294478","yes");
INSERT INTO `wp_options` VALUES("65243","_transient__bbp_86.122.124.11_last_posted","1424800833","yes");
INSERT INTO `wp_options` VALUES("65247","_transient__bbp_175.44.9.93_last_posted","1423644985","yes");
INSERT INTO `wp_options` VALUES("65266","_transient__bbp_124.158.222.231_last_posted","1423647172","yes");
INSERT INTO `wp_options` VALUES("65279","_transient__bbp_203.187.230.251_last_posted","1423648922","yes");
INSERT INTO `wp_options` VALUES("62671","_transient__bbp_201.209.55.116_last_posted","1423363061","yes");
INSERT INTO `wp_options` VALUES("62684","_transient__bbp_117.169.1.184_last_posted","1423364747","yes");
INSERT INTO `wp_options` VALUES("62685","_transient__bbp_222.45.196.46_last_posted","1427228064","yes");
INSERT INTO `wp_options` VALUES("62698","_transient__bbp_188.132.226.2_last_posted","1427408701","yes");
INSERT INTO `wp_options` VALUES("62714","_transient__bbp_117.169.1.9_last_posted","1426489903","yes");
INSERT INTO `wp_options` VALUES("62727","_transient__bbp_91.72.220.218_last_posted","1425697863","yes");
INSERT INTO `wp_options` VALUES("62737","_transient__bbp_119.46.91.234_last_posted","1425398255","yes");
INSERT INTO `wp_options` VALUES("62769","_transient__bbp_111.85.83.61_last_posted","1423374114","yes");
INSERT INTO `wp_options` VALUES("62782","_transient__bbp_117.135.250.51_last_posted","1423464650","yes");
INSERT INTO `wp_options` VALUES("62806","_transient__bbp_222.45.196.45_last_posted","1427253592","yes");
INSERT INTO `wp_options` VALUES("62819","_transient__bbp_120.202.249.204_last_posted","1426210500","yes");
INSERT INTO `wp_options` VALUES("62835","_transient__bbp_117.173.16.88_last_posted","1423380177","yes");
INSERT INTO `wp_options` VALUES("62854","_transient__bbp_120.236.148.113_last_posted","1427367257","yes");
INSERT INTO `wp_options` VALUES("62885","_transient__bbp_183.203.208.173_last_posted","1427469566","yes");
INSERT INTO `wp_options` VALUES("62917","_transient__bbp_195.154.211.26_last_posted","1423389098","yes");
INSERT INTO `wp_options` VALUES("62945","_transient__bbp_118.163.151.173_last_posted","1423497740","yes");
INSERT INTO `wp_options` VALUES("62952","_transient__bbp_117.169.1.6_last_posted","1423392642","yes");
INSERT INTO `wp_options` VALUES("62983","_transient__bbp_2001:41d0:52:cff::5f2_last_posted","1423971770","yes");
INSERT INTO `wp_options` VALUES("62993","_transient__bbp_117.173.21.157_last_posted","1423396479","yes");
INSERT INTO `wp_options` VALUES("63015","_transient__bbp_202.107.233.85_last_posted","1427059269","yes");
INSERT INTO `wp_options` VALUES("63028","_transient__bbp_211.152.50.70_last_posted","1423399975","yes");
INSERT INTO `wp_options` VALUES("63044","_transient__bbp_223.86.215.243_last_posted","1423402087","yes");
INSERT INTO `wp_options` VALUES("63073","_transient__bbp_211.77.5.41_last_posted","1423404810","yes");
INSERT INTO `wp_options` VALUES("63110","_transient__bbp_67.215.230.82_last_posted","1424299940","yes");
INSERT INTO `wp_options` VALUES("63180","_transient__bbp_183.220.105.75_last_posted","1423446392","yes");
INSERT INTO `wp_options` VALUES("63218","_transient__bbp_117.173.21.174_last_posted","1423420569","yes");
INSERT INTO `wp_options` VALUES("63243","_transient__bbp_190.199.56.226_last_posted","1423423207","yes");
INSERT INTO `wp_options` VALUES("63256","_transient__bbp_2001:41d0:51:1::4ae_last_posted","1427284453","yes");
INSERT INTO `wp_options` VALUES("63266","_transient__bbp_121.14.138.50_last_posted","1427331668","yes");
INSERT INTO `wp_options` VALUES("63303","_transient__bbp_58.61.29.233_last_posted","1427701412","yes");
INSERT INTO `wp_options` VALUES("63316","_transient__bbp_223.86.216.104_last_posted","1423431394","yes");
INSERT INTO `wp_options` VALUES("63335","_transient__bbp_117.177.240.39_last_posted","1425998413","yes");
INSERT INTO `wp_options` VALUES("63351","_transient__bbp_117.177.141.32_last_posted","1423434873","yes");
INSERT INTO `wp_options` VALUES("63364","_transient__bbp_180.176.175.13_last_posted","1423969343","yes");
INSERT INTO `wp_options` VALUES("63413","_transient__bbp_190.36.7.211_last_posted","1423441346","yes");
INSERT INTO `wp_options` VALUES("63435","_transient__bbp_117.177.147.5_last_posted","1423443784","yes");
INSERT INTO `wp_options` VALUES("63454","_transient__bbp_198.50.195.97_last_posted","1423445401","yes");
INSERT INTO `wp_options` VALUES("63499","_transient__bbp_182.254.129.68_last_posted","1427707518","yes");
INSERT INTO `wp_options` VALUES("63536","_transient__bbp_183.203.208.171_last_posted","1427377983","yes");
INSERT INTO `wp_options` VALUES("63552","_transient__bbp_183.222.152.237_last_posted","1423460200","yes");
INSERT INTO `wp_options` VALUES("63574","_transient__bbp_220.135.237.167_last_posted","1423458802","yes");
INSERT INTO `wp_options` VALUES("63608","_transient__bbp_58.240.238.218_last_posted","1427629356","yes");
INSERT INTO `wp_options` VALUES("63644","_transient__bbp_117.174.206.120_last_posted","1423466398","yes");
INSERT INTO `wp_options` VALUES("63660","_transient__bbp_198.12.76.168_last_posted","1423468158","yes");
INSERT INTO `wp_options` VALUES("63670","_transient__bbp_182.235.39.76_last_posted","1423469279","yes");
INSERT INTO `wp_options` VALUES("63705","_transient__bbp_185.54.4.198_last_posted","1427157855","yes");
INSERT INTO `wp_options` VALUES("114186","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1429254795","no");
INSERT INTO `wp_options` VALUES("114187","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
	
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"
		
		
		
		
		
		
				

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		

	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Apr 2015 18:46:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WP Smush\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-smushit/#post-7936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Dec 2008 00:00:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"7936@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Reduce image file sizes, improve performance and boost your SEO using the free WPMU DEV WordPress Smush API.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Dunae\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"EWWW Image Optimizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/ewww-image-optimizer/#post-38780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jun 2012 19:30:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38780@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Reduce file sizes for images in WordPress including NextGEN, GRAND FlAGallery and more using lossless/lossy methods and image format conversion.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"nosilver4u\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Shortcodes Ultimate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/plugins/shortcodes-ultimate/#post-25618\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Apr 2011 13:08:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25618@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Supercharge your WordPress theme with mega pack of shortcodes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Vladimir Anokhin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 12 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Broken Link Checker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/broken-link-checker/#post-2441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Oct 2007 21:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2441@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"This plugin will check your posts, comments and other content for broken links and missing images, and notify you if any are found.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Janis Elsts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"solarissmoke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"All In One WP Security &amp; Firewall\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/#post-54002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 May 2013 23:50:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"54002@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"A comprehensive, user-friendly, all in one WordPress security and firewall plugin for your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"mra13\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WPtouch Mobile Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wptouch/#post-5468\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 May 2008 04:58:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5468@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Make your WordPress website mobile-friendly with just a few clicks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"BraveNewCode Inc.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/buddypress/#post-10314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Apr 2009 17:48:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"10314@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"BuddyPress helps you run any kind of social network on your WordPress, with member profiles, activity streams, user groups, messaging, and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andy Peatling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Fast Secure Contact Form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/si-contact-form/#post-12636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Aug 2009 01:20:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12636@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"An easy and powerful form builder that lets your visitors send you email. Blocks all automated spammers. No templates to mess with.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mike Challis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"MailChimp for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/mailchimp-for-wp/#post-54377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Jun 2013 17:32:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"54377@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The best MailChimp plugin to get more email subscribers. Easily add MailChimp sign-up forms and sign-up checkboxes to your WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Danny van Kooten\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 16 Apr 2015 19:13:15 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Thu, 16 Apr 2015 19:21:04 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Thu, 16 Apr 2015 18:46:04 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("114247","updraft_dropbox","a:5:{s:6:\"appkey\";N;s:6:\"secret\";N;s:6:\"folder\";N;s:16:\"tk_request_token\";N;s:15:\"tk_access_token\";N;}","yes");
INSERT INTO `wp_options` VALUES("61119","_transient__bbp_27.187.214.135_last_posted","1423558690","yes");
INSERT INTO `wp_options` VALUES("62122","_transient__bbp_183.223.204.203_last_posted","1423306394","yes");
INSERT INTO `wp_options` VALUES("62129","_transient__bbp_183.223.204.170_last_posted","1423306974","yes");
INSERT INTO `wp_options` VALUES("61970","_transient__bbp_220.160.142.85_last_posted","1423289423","yes");
INSERT INTO `wp_options` VALUES("62136","_transient__bbp_1.34.191.236_last_posted","1423438192","yes");
INSERT INTO `wp_options` VALUES("65320","_transient__bbp_119.147.91.21_last_posted","1424623878","yes");
INSERT INTO `wp_options` VALUES("65324","_transient__bbp_197.234.70.162_last_posted","1423653821","yes");
INSERT INTO `wp_options` VALUES("65361","_transient__bbp_184.161.53.102_last_posted","1423658428","yes");
INSERT INTO `wp_options` VALUES("65371","_transient__bbp_175.44.25.7_last_posted","1423659301","yes");
INSERT INTO `wp_options` VALUES("65384","_transient__bbp_85.154.230.162_last_posted","1423896271","yes");
INSERT INTO `wp_options` VALUES("65405","_transient__bbp_119.28.3.200_last_posted","1427312712","yes");
INSERT INTO `wp_options` VALUES("65412","_transient__bbp_198.50.211.54_last_posted","1424726189","yes");
INSERT INTO `wp_options` VALUES("65452","_transient__bbp_59.125.78.183_last_posted","1423667953","yes");
INSERT INTO `wp_options` VALUES("65504","_transient__bbp_31.170.237.202_last_posted","1423673095","yes");
INSERT INTO `wp_options` VALUES("65526","_transient__bbp_186.88.112.128_last_posted","1423675328","yes");
INSERT INTO `wp_options` VALUES("65588","_transient__bbp_61.156.3.166_last_posted","1427331944","yes");
INSERT INTO `wp_options` VALUES("65607","_transient__bbp_58.215.185.46_last_posted","1426048419","yes");
INSERT INTO `wp_options` VALUES("65633","_transient__bbp_114.80.182.132_last_posted","1427320526","yes");
INSERT INTO `wp_options` VALUES("65661","_transient__bbp_213.238.175.29_last_posted","1423689222","yes");
INSERT INTO `wp_options` VALUES("65692","_transient__bbp_190.73.122.109_last_posted","1423693088","yes");
INSERT INTO `wp_options` VALUES("65708","_transient__bbp_186.91.41.139_last_posted","1423694879","yes");
INSERT INTO `wp_options` VALUES("65748","_transient__bbp_123.249.34.12_last_posted","1426496721","yes");
INSERT INTO `wp_options` VALUES("65764","_transient__bbp_190.77.234.101_last_posted","1423701773","yes");
INSERT INTO `wp_options` VALUES("65786","_transient__bbp_117.169.1.90_last_posted","1425543123","yes");
INSERT INTO `wp_options` VALUES("65787","_transient__bbp_61.184.192.42_last_posted","1426052769","yes");
INSERT INTO `wp_options` VALUES("65883","_transient__bbp_186.90.101.187_last_posted","1423714491","yes");
INSERT INTO `wp_options` VALUES("65917","_transient__bbp_83.128.239.152_last_posted","1423718760","yes");
INSERT INTO `wp_options` VALUES("65957","_transient__bbp_219.93.183.103_last_posted","1424569561","yes");
INSERT INTO `wp_options` VALUES("66005","_transient__bbp_200.109.192.122_last_posted","1423727268","yes");
INSERT INTO `wp_options` VALUES("66012","_transient__bbp_124.123.42.207_last_posted","1423727795","yes");
INSERT INTO `wp_options` VALUES("66019","_transient__bbp_222.45.196.17_last_posted","1425622293","yes");
INSERT INTO `wp_options` VALUES("66041","_transient__bbp_60.251.242.122_last_posted","1423731208","yes");
INSERT INTO `wp_options` VALUES("66139","_transient__bbp_91.202.26.170_last_posted","1423907217","yes");
INSERT INTO `wp_options` VALUES("66222","_transient__bbp_183.222.154.85_last_posted","1423748946","yes");
INSERT INTO `wp_options` VALUES("66286","_transient__bbp_27.147.158.188_last_posted","1423755211","yes");
INSERT INTO `wp_options` VALUES("66296","_transient__bbp_190.37.76.22_last_posted","1423755880","yes");
INSERT INTO `wp_options` VALUES("66297","_transient__bbp_41.222.206.51_last_posted","1423756061","yes");
INSERT INTO `wp_options` VALUES("66329","_transient__bbp_14.199.236.214_last_posted","1423758971","yes");
INSERT INTO `wp_options` VALUES("66330","_transient__bbp_218.29.130.91_last_posted","1423817871","yes");
INSERT INTO `wp_options` VALUES("66352","_transient__bbp_178.249.14.19_last_posted","1425096771","yes");
INSERT INTO `wp_options` VALUES("66451","_transient__bbp_183.222.159.19_last_posted","1423778061","yes");
INSERT INTO `wp_options` VALUES("66477","_transient__bbp_117.169.1.140_last_posted","1427665713","yes");
INSERT INTO `wp_options` VALUES("66456","_transient__bbp_175.44.4.147_last_posted","1423771491","yes");
INSERT INTO `wp_options` VALUES("66598","_transient__bbp_211.141.130.245_last_posted","1426884835","yes");
INSERT INTO `wp_options` VALUES("66611","_transient__bbp_117.169.1.101_last_posted","1424306359","yes");
INSERT INTO `wp_options` VALUES("66615","_transient__bbp_117.169.1.186_last_posted","1424246247","yes");
INSERT INTO `wp_options` VALUES("66634","_transient__bbp_117.176.55.50_last_posted","1423789769","yes");
INSERT INTO `wp_options` VALUES("66657","_transient__bbp_117.177.240.37_last_posted","1423791971","yes");
INSERT INTO `wp_options` VALUES("66730","_transient__bbp_111.9.234.220_last_posted","1423799636","yes");
INSERT INTO `wp_options` VALUES("66734","_transient__bbp_103.224.81.170_last_posted","1423799769","yes");
INSERT INTO `wp_options` VALUES("66756","_transient__bbp_183.222.157.169_last_posted","1423802300","yes");
INSERT INTO `wp_options` VALUES("66805","_transient__bbp_210.119.81.109_last_posted","1423807063","yes");
INSERT INTO `wp_options` VALUES("66853","_transient__bbp_211.141.133.100_last_posted","1427280189","yes");
INSERT INTO `wp_options` VALUES("66890","_transient__bbp_183.222.161.233_last_posted","1423815475","yes");
INSERT INTO `wp_options` VALUES("66955","_transient__bbp_37.59.36.198_last_posted","1427070754","yes");
INSERT INTO `wp_options` VALUES("67040","_transient__bbp_84.253.75.6_last_posted","1425757379","yes");
INSERT INTO `wp_options` VALUES("67059","_transient__bbp_89.39.12.57_last_posted","1423833868","yes");
INSERT INTO `wp_options` VALUES("67112","_transient__bbp_183.222.153.115_last_posted","1423839065","yes");
INSERT INTO `wp_options` VALUES("67185","_transient__bbp_117.173.21.206_last_posted","1423863304","yes");
INSERT INTO `wp_options` VALUES("67213","_transient__bbp_91.207.9.154_last_posted","1427585936","yes");
INSERT INTO `wp_options` VALUES("67214","_transient__bbp_218.191.141.226_last_posted","1423848751","yes");
INSERT INTO `wp_options` VALUES("67215","_transient__bbp_183.223.209.106_last_posted","1423848793","yes");
INSERT INTO `wp_options` VALUES("67234","_transient__bbp_119.6.78.39_last_posted","1423850939","yes");
INSERT INTO `wp_options` VALUES("67264","_transient__bbp_91.207.9.146_last_posted","1427567831","yes");
INSERT INTO `wp_options` VALUES("67268","_transient__bbp_111.10.146.209_last_posted","1423853619","yes");
INSERT INTO `wp_options` VALUES("67290","_transient__bbp_222.59.246.38_last_posted","1426957728","yes");
INSERT INTO `wp_options` VALUES("67342","_transient__bbp_5.226.86.83_last_posted","1427038600","yes");
INSERT INTO `wp_options` VALUES("67349","_transient__bbp_212.68.51.58_last_posted","1427574943","yes");
INSERT INTO `wp_options` VALUES("67446","_transient__bbp_117.173.200.199_last_posted","1423870623","yes");
INSERT INTO `wp_options` VALUES("67468","_transient__bbp_186.94.38.207_last_posted","1423872699","yes");
INSERT INTO `wp_options` VALUES("67499","_transient__bbp_89.39.12.71_last_posted","1423875724","yes");
INSERT INTO `wp_options` VALUES("67518","_transient__bbp_42.121.105.155_last_posted","1427363750","yes");
INSERT INTO `wp_options` VALUES("67589","_transient__bbp_117.173.20.16_last_posted","1423885144","yes");
INSERT INTO `wp_options` VALUES("67605","_transient__bbp_117.169.1.224_last_posted","1423887406","yes");
INSERT INTO `wp_options` VALUES("67703","_transient__bbp_117.173.61.138_last_posted","1423898391","yes");
INSERT INTO `wp_options` VALUES("67725","_transient__bbp_183.227.217.186_last_posted","1423900493","yes");
INSERT INTO `wp_options` VALUES("67825","_transient__bbp_159.224.171.1_last_posted","1423911435","yes");
INSERT INTO `wp_options` VALUES("67929","_transient__bbp_190.77.198.216_last_posted","1423922893","yes");
INSERT INTO `wp_options` VALUES("68047","_transient__bbp_83.87.193.246_last_posted","1423935932","yes");
INSERT INTO `wp_options` VALUES("68089","_transient__bbp_116.236.216.116_last_posted","1427342670","yes");
INSERT INTO `wp_options` VALUES("77356","_transient__bbp_2602:306:3077:2e60:388c:b7a7:65fb:9df9_last_post","1425177854","yes");
INSERT INTO `wp_options` VALUES("79379","_transient__bbp_117.169.1.154_last_posted","1427713792","yes");
INSERT INTO `wp_options` VALUES("68317","_transient__bbp_183.222.153.127_last_posted","1423967365","yes");
INSERT INTO `wp_options` VALUES("68372","_transient__bbp_103.38.18.112_last_posted","1423974200","yes");
INSERT INTO `wp_options` VALUES("68376","_transient__bbp_117.175.109.62_last_posted","1423974440","yes");
INSERT INTO `wp_options` VALUES("68481","_transient__bbp_186.93.20.57_last_posted","1423988338","yes");
INSERT INTO `wp_options` VALUES("68503","_transient__bbp_61.70.81.30_last_posted","1423990681","yes");
INSERT INTO `wp_options` VALUES("68507","_transient__bbp_183.222.154.113_last_posted","1423990838","yes");
INSERT INTO `wp_options` VALUES("68527","_transient__bbp_58.252.167.103_last_posted","1424835135","yes");
INSERT INTO `wp_options` VALUES("68550","_transient__bbp_85.15.176.223_last_posted","1426188772","yes");
INSERT INTO `wp_options` VALUES("68581","_transient__bbp_211.141.230.23_last_posted","1423999501","yes");
INSERT INTO `wp_options` VALUES("68624","_transient__bbp_121.12.120.246_last_posted","1424795621","yes");
INSERT INTO `wp_options` VALUES("68686","_transient__bbp_117.169.1.67_last_posted","1424330164","yes");
INSERT INTO `wp_options` VALUES("68696","_transient__bbp_223.86.79.23_last_posted","1424012083","yes");
INSERT INTO `wp_options` VALUES("68712","_transient__bbp_117.177.147.84_last_posted","1424013520","yes");
INSERT INTO `wp_options` VALUES("68719","_transient__bbp_54.225.192.171_last_posted","1424014061","yes");
INSERT INTO `wp_options` VALUES("68744","_transient__bbp_117.166.18.126_last_posted","1424018459","yes");
INSERT INTO `wp_options` VALUES("68754","_transient__bbp_117.169.1.91_last_posted","1426473069","yes");
INSERT INTO `wp_options` VALUES("68761","_transient__bbp_111.10.145.76_last_posted","1424019996","yes");
INSERT INTO `wp_options` VALUES("68795","_transient__bbp_117.169.1.131_last_posted","1425405027","yes");
INSERT INTO `wp_options` VALUES("68805","_transient__bbp_117.169.1.228_last_posted","1424458580","yes");
INSERT INTO `wp_options` VALUES("68814","_transient__bbp_117.169.1.124_last_posted","1424025312","yes");
INSERT INTO `wp_options` VALUES("68848","_transient__bbp_117.169.1.240_last_posted","1425680780","yes");
INSERT INTO `wp_options` VALUES("68888","_transient__bbp_183.222.159.83_last_posted","1424439396","yes");
INSERT INTO `wp_options` VALUES("68901","_transient__bbp_190.203.41.179_last_posted","1424034825","yes");
INSERT INTO `wp_options` VALUES("68908","_transient__bbp_2001:41d0:51:1::12b7_last_posted","1425930171","yes");
INSERT INTO `wp_options` VALUES("68930","_transient__bbp_117.169.1.96_last_posted","1424038907","yes");
INSERT INTO `wp_options` VALUES("68937","_transient__bbp_190.205.117.229_last_posted","1424039667","yes");
INSERT INTO `wp_options` VALUES("68968","_transient__bbp_117.169.1.35_last_posted","1424044184","yes");
INSERT INTO `wp_options` VALUES("68978","_transient__bbp_117.169.1.209_last_posted","1424044892","yes");
INSERT INTO `wp_options` VALUES("68979","_transient__bbp_183.223.213.83_last_posted","1424044925","yes");
INSERT INTO `wp_options` VALUES("68992","_transient__bbp_117.169.1.106_last_posted","1427575561","yes");
INSERT INTO `wp_options` VALUES("69017","_transient__bbp_117.169.1.17_last_posted","1424128950","yes");
INSERT INTO `wp_options` VALUES("69024","_transient__bbp_112.19.112.30_last_posted","1424049949","yes");
INSERT INTO `wp_options` VALUES("69025","_transient__bbp_198.204.255.10_last_posted","1424050150","yes");
INSERT INTO `wp_options` VALUES("69042","_transient__bbp_117.169.1.166_last_posted","1427565431","yes");
INSERT INTO `wp_options` VALUES("69070","_transient__bbp_117.169.1.220_last_posted","1424147656","yes");
INSERT INTO `wp_options` VALUES("69077","_transient__bbp_112.19.127.235_last_posted","1424055858","yes");
INSERT INTO `wp_options` VALUES("69090","_transient__bbp_117.166.243.239_last_posted","1424255223","yes");
INSERT INTO `wp_options` VALUES("69115","_transient__bbp_117.169.1.117_last_posted","1424207596","yes");
INSERT INTO `wp_options` VALUES("69119","_transient__bbp_183.220.246.236_last_posted","1424061512","yes");
INSERT INTO `wp_options` VALUES("69126","_transient__bbp_117.169.1.49_last_posted","1427591351","yes");
INSERT INTO `wp_options` VALUES("69157","_transient__bbp_117.169.1.150_last_posted","1427491865","yes");
INSERT INTO `wp_options` VALUES("69161","_transient__bbp_117.169.1.180_last_posted","1424416427","yes");
INSERT INTO `wp_options` VALUES("69181","_transient__bbp_117.169.1.171_last_posted","1427491856","yes");
INSERT INTO `wp_options` VALUES("69206","_transient__bbp_117.169.1.200_last_posted","1424330378","yes");
INSERT INTO `wp_options` VALUES("69207","_transient__bbp_221.178.85.27_last_posted","1424119440","yes");
INSERT INTO `wp_options` VALUES("69217","_transient__bbp_221.178.119.54_last_posted","1424074517","yes");
INSERT INTO `wp_options` VALUES("69224","_transient__bbp_117.169.1.230_last_posted","1427482389","yes");
INSERT INTO `wp_options` VALUES("69252","_transient__bbp_223.86.68.109_last_posted","1424174279","yes");
INSERT INTO `wp_options` VALUES("69259","_transient__bbp_117.169.1.210_last_posted","1427491901","yes");
INSERT INTO `wp_options` VALUES("69269","_transient__bbp_117.169.1.217_last_posted","1427622796","yes");
INSERT INTO `wp_options` VALUES("69291","_transient__bbp_117.169.1.149_last_posted","1425479791","yes");
INSERT INTO `wp_options` VALUES("69334","_transient__bbp_183.220.106.80_last_posted","1424092657","yes");
INSERT INTO `wp_options` VALUES("69338","_transient__bbp_183.223.204.74_last_posted","1424093190","yes");
INSERT INTO `wp_options` VALUES("69349","_transient__bbp_188.94.168.30_last_posted","1424094579","yes");
INSERT INTO `wp_options` VALUES("69383","_transient__bbp_183.223.215.135_last_posted","1424098885","yes");
INSERT INTO `wp_options` VALUES("69393","_transient__bbp_27.2.207.156_last_posted","1424100870","yes");
INSERT INTO `wp_options` VALUES("69424","_transient__bbp_117.169.1.28_last_posted","1425587731","yes");
INSERT INTO `wp_options` VALUES("69425","_transient__bbp_2400:6180:0:d0::370:a001_last_posted","1424105220","yes");
INSERT INTO `wp_options` VALUES("70122","_transient__bbp_117.169.1.71_last_posted","1426533834","yes");
INSERT INTO `wp_options` VALUES("69468","_transient__bbp_117.169.1.75_last_posted","1427559299","yes");
INSERT INTO `wp_options` VALUES("69503","_transient__bbp_117.169.1.159_last_posted","1426688464","yes");
INSERT INTO `wp_options` VALUES("69510","_transient__bbp_117.169.1.221_last_posted","1427520418","yes");
INSERT INTO `wp_options` VALUES("69565","_transient__bbp_117.169.1.145_last_posted","1426501939","yes");
INSERT INTO `wp_options` VALUES("69584","_transient__bbp_211.141.130.56_last_posted","1427606837","yes");
INSERT INTO `wp_options` VALUES("69588","_transient__bbp_117.169.1.44_last_posted","1427606935","yes");
INSERT INTO `wp_options` VALUES("69592","_transient__bbp_175.44.24.170_last_posted","1424129222","yes");
INSERT INTO `wp_options` VALUES("69632","_transient__bbp_39.182.11.190_last_posted","1424137089","yes");
INSERT INTO `wp_options` VALUES("69652","_transient__bbp_117.173.22.223_last_posted","1424140700","yes");
INSERT INTO `wp_options` VALUES("69668","_transient__bbp_117.169.1.206_last_posted","1427498679","yes");
INSERT INTO `wp_options` VALUES("69690","_transient__bbp_117.169.1.185_last_posted","1426630069","yes");
INSERT INTO `wp_options` VALUES("69709","_transient__bbp_123.110.134.102_last_posted","1424149698","yes");
INSERT INTO `wp_options` VALUES("69731","_transient__bbp_117.169.1.24_last_posted","1424153364","yes");
INSERT INTO `wp_options` VALUES("69735","_transient__bbp_54.191.182.62_last_posted","1424153938","yes");
INSERT INTO `wp_options` VALUES("69739","_transient__bbp_117.169.1.55_last_posted","1424154016","yes");
INSERT INTO `wp_options` VALUES("69762","_transient__bbp_117.169.1.164_last_posted","1427497132","yes");
INSERT INTO `wp_options` VALUES("69787","_transient__bbp_117.169.1.18_last_posted","1424159546","yes");
INSERT INTO `wp_options` VALUES("69806","_transient__bbp_117.169.1.161_last_posted","1426529038","yes");
INSERT INTO `wp_options` VALUES("69846","_transient__bbp_42.82.90.105_last_posted","1424166429","yes");
INSERT INTO `wp_options` VALUES("69886","_transient__bbp_118.244.255.13_last_posted","1427237439","yes");
INSERT INTO `wp_options` VALUES("69890","_transient__bbp_110.247.28.102_last_posted","1424306196","yes");
INSERT INTO `wp_options` VALUES("69897","_transient__bbp_119.188.94.145_last_posted","1424619559","yes");
INSERT INTO `wp_options` VALUES("69925","_transient__bbp_117.169.1.218_last_posted","1426578168","yes");
INSERT INTO `wp_options` VALUES("69950","_transient__bbp_177.124.164.10_last_posted","1424340293","yes");
INSERT INTO `wp_options` VALUES("69994","_transient__bbp_190.201.35.47_last_posted","1424186203","yes");
INSERT INTO `wp_options` VALUES("70019","_transient__bbp_39.64.64.68_last_posted","1424830636","yes");
INSERT INTO `wp_options` VALUES("70023","_transient__bbp_117.169.1.107_last_posted","1424189796","yes");
INSERT INTO `wp_options` VALUES("70075","_transient__bbp_54.207.199.79_last_posted","1424195746","yes");
INSERT INTO `wp_options` VALUES("70098","_transient__bbp_190.38.1.230_last_posted","1424197993","yes");
INSERT INTO `wp_options` VALUES("70120","_transient__bbp_123.125.19.44_last_posted","1427025807","yes");
INSERT INTO `wp_options` VALUES("70121","_transient__bbp_117.169.1.205_last_posted","1427568956","yes");
INSERT INTO `wp_options` VALUES("70171","_transient__bbp_117.169.1.214_last_posted","1426364096","yes");
INSERT INTO `wp_options` VALUES("70220","_transient__bbp_117.169.1.68_last_posted","1427626760","yes");
INSERT INTO `wp_options` VALUES("70221","_transient__bbp_183.222.157.216_last_posted","1424213282","yes");
INSERT INTO `wp_options` VALUES("70261","_transient__bbp_117.169.1.136_last_posted","1425335179","yes");
INSERT INTO `wp_options` VALUES("70283","_transient__bbp_49.4.167.139_last_posted","1424989951","yes");
INSERT INTO `wp_options` VALUES("70321","_transient__bbp_190.37.228.237_last_posted","1424225426","yes");
INSERT INTO `wp_options` VALUES("70337","_transient__bbp_183.220.128.68_last_posted","1424227719","yes");
INSERT INTO `wp_options` VALUES("70374","_transient__bbp_203.110.169.108_last_posted","1425792287","yes");
INSERT INTO `wp_options` VALUES("70390","_transient__bbp_190.198.153.24_last_posted","1424234436","yes");
INSERT INTO `wp_options` VALUES("70412","_transient__bbp_178.211.164.146_last_posted","1424238157","yes");
INSERT INTO `wp_options` VALUES("70413","_transient__bbp_117.169.1.114_last_posted","1424238196","yes");
INSERT INTO `wp_options` VALUES("70445","_transient__bbp_117.169.1.151_last_posted","1427671569","yes");
INSERT INTO `wp_options` VALUES("70449","_transient__bbp_117.169.1.237_last_posted","1424243939","yes");
INSERT INTO `wp_options` VALUES("70453","_transient__bbp_117.175.62.50_last_posted","1424244077","yes");
INSERT INTO `wp_options` VALUES("70490","_transient__bbp_112.26.162.4_last_posted","1424248837","yes");
INSERT INTO `wp_options` VALUES("70497","_transient__bbp_117.169.1.215_last_posted","1425603241","yes");
INSERT INTO `wp_options` VALUES("70498","_transient__bbp_117.169.1.195_last_posted","1425265335","yes");
INSERT INTO `wp_options` VALUES("70551","_transient__bbp_54.187.174.193_last_posted","1424255395","yes");
INSERT INTO `wp_options` VALUES("70585","_transient__bbp_111.9.232.44_last_posted","1424335451","yes");
INSERT INTO `wp_options` VALUES("70619","_transient__bbp_183.223.214.131_last_posted","1424266281","yes");
INSERT INTO `wp_options` VALUES("70645","_transient__bbp_190.206.226.87_last_posted","1424270592","yes");
INSERT INTO `wp_options` VALUES("70649","_transient__bbp_183.222.155.241_last_posted","1424270847","yes");
INSERT INTO `wp_options` VALUES("70695","_transient__bbp_117.169.1.118_last_posted","1427282916","yes");
INSERT INTO `wp_options` VALUES("70702","_transient__bbp_124.205.129.99_last_posted","1425890558","yes");
INSERT INTO `wp_options` VALUES("70712","_transient__bbp_117.169.1.129_last_posted","1427547602","yes");
INSERT INTO `wp_options` VALUES("70740","_transient__bbp_218.204.141.92_last_posted","1427026628","yes");
INSERT INTO `wp_options` VALUES("70750","_transient__bbp_117.169.1.79_last_posted","1424283784","yes");
INSERT INTO `wp_options` VALUES("70785","_transient__bbp_112.26.162.16_last_posted","1424735085","yes");
INSERT INTO `wp_options` VALUES("70792","_transient__bbp_117.169.1.37_last_posted","1427495257","yes");
INSERT INTO `wp_options` VALUES("70796","_transient__bbp_117.169.1.211_last_posted","1427613776","yes");
INSERT INTO `wp_options` VALUES("70827","_transient__bbp_117.169.1.187_last_posted","1425375077","yes");
INSERT INTO `wp_options` VALUES("70873","_transient__bbp_199.167.228.36_last_posted","1426721406","yes");
INSERT INTO `wp_options` VALUES("70895","_transient__bbp_117.169.1.199_last_posted","1427473110","yes");
INSERT INTO `wp_options` VALUES("70902","_transient__bbp_201.211.248.133_last_posted","1424306452","yes");
INSERT INTO `wp_options` VALUES("70937","_transient__bbp_201.210.61.127_last_posted","1424311841","yes");
INSERT INTO `wp_options` VALUES("70938","_transient__bbp_188.143.233.145_last_posted","1424409793","yes");
INSERT INTO `wp_options` VALUES("70945","_transient__bbp_190.77.173.65_last_posted","1424312522","yes");
INSERT INTO `wp_options` VALUES("70973","_transient__bbp_175.111.39.9_last_posted","1424318079","yes");
INSERT INTO `wp_options` VALUES("70980","_transient__bbp_117.169.1.169_last_posted","1427620355","yes");
INSERT INTO `wp_options` VALUES("71008","_transient__bbp_183.228.73.248_last_posted","1424323888","yes");
INSERT INTO `wp_options` VALUES("71094","_transient__bbp_123.241.107.14_last_posted","1424335826","yes");
INSERT INTO `wp_options` VALUES("71095","_transient__bbp_117.169.1.147_last_posted","1426400100","yes");
INSERT INTO `wp_options` VALUES("71156","_transient__bbp_183.220.246.254_last_posted","1424345355","yes");
INSERT INTO `wp_options` VALUES("71160","_transient__bbp_111.9.232.128_last_posted","1424345810","yes");
INSERT INTO `wp_options` VALUES("71191","_transient__bbp_190.204.245.249_last_posted","1424350535","yes");
INSERT INTO `wp_options` VALUES("71229","_transient__bbp_190.205.155.190_last_posted","1424355223","yes");
INSERT INTO `wp_options` VALUES("71269","_transient__bbp_94.213.182.96_last_posted","1424360212","yes");
INSERT INTO `wp_options` VALUES("71273","_transient__bbp_190.77.187.97_last_posted","1424360482","yes");
INSERT INTO `wp_options` VALUES("71277","_transient__bbp_186.93.188.79_last_posted","1424361193","yes");
INSERT INTO `wp_options` VALUES("71397","_transient__bbp_117.177.240.33_last_posted","1425597020","yes");
INSERT INTO `wp_options` VALUES("71312","_transient__bbp_117.169.1.130_last_posted","1424461074","yes");
INSERT INTO `wp_options` VALUES("71398","_transient__bbp_117.169.1.189_last_posted","1427604223","yes");
INSERT INTO `wp_options` VALUES("71399","_transient__bbp_190.202.228.48_last_posted","1424376002","yes");
INSERT INTO `wp_options` VALUES("71406","_transient__bbp_190.37.103.131_last_posted","1424376545","yes");
INSERT INTO `wp_options` VALUES("71461","_transient__bbp_183.220.244.148_last_posted","1424386395","yes");
INSERT INTO `wp_options` VALUES("71462","_transient__bbp_106.158.16.3_last_posted","1424386438","yes");
INSERT INTO `wp_options` VALUES("71493","_transient__bbp_117.169.1.121_last_posted","1424391361","yes");
INSERT INTO `wp_options` VALUES("71494","_transient__bbp_1.34.66.148_last_posted","1424391575","yes");
INSERT INTO `wp_options` VALUES("71501","_transient__bbp_117.169.1.125_last_posted","1424391929","yes");
INSERT INTO `wp_options` VALUES("71526","_transient__bbp_117.175.34.253_last_posted","1424396470","yes");
INSERT INTO `wp_options` VALUES("71527","_transient__bbp_111.72.95.133_last_posted","1424396538","yes");
INSERT INTO `wp_options` VALUES("71536","_transient__bbp_223.72.142.130_last_posted","1425088385","yes");
INSERT INTO `wp_options` VALUES("71567","_transient__bbp_78.41.115.145_last_posted","1424401814","yes");
INSERT INTO `wp_options` VALUES("71592","_transient__bbp_183.220.246.144_last_posted","1424406286","yes");
INSERT INTO `wp_options` VALUES("71602","_transient__bbp_190.207.19.91_last_posted","1424406972","yes");
INSERT INTO `wp_options` VALUES("71627","_transient__bbp_54.87.79.103_last_posted","1424411264","yes");
INSERT INTO `wp_options` VALUES("71628","_transient__bbp_183.222.156.194_last_posted","1424411379","yes");
INSERT INTO `wp_options` VALUES("71654","_transient__bbp_120.210.75.11_last_posted","1424416126","yes");
INSERT INTO `wp_options` VALUES("71658","_transient__bbp_124.166.242.221_last_posted","1424943792","yes");
INSERT INTO `wp_options` VALUES("71683","_transient__bbp_120.131.70.214_last_posted","1425096962","yes");
INSERT INTO `wp_options` VALUES("71705","_transient__bbp_175.183.1.127_last_posted","1424425915","yes");
INSERT INTO `wp_options` VALUES("71733","_transient__bbp_77.43.143.31_last_posted","1424430609","yes");
INSERT INTO `wp_options` VALUES("71758","_transient__bbp_118.244.190.34_last_posted","1425842373","yes");
INSERT INTO `wp_options` VALUES("71762","_transient__bbp_145.118.111.106_last_posted","1424434889","yes");
INSERT INTO `wp_options` VALUES("71845","_transient__bbp_190.39.107.85_last_posted","1424449100","yes");
INSERT INTO `wp_options` VALUES("71849","_transient__bbp_176.108.160.253_last_posted","1424500614","yes");
INSERT INTO `wp_options` VALUES("71859","_transient__bbp_115.236.59.194_last_posted","1424709048","yes");
INSERT INTO `wp_options` VALUES("71891","_transient__bbp_190.198.48.32_last_posted","1424458400","yes");
INSERT INTO `wp_options` VALUES("71913","_transient__bbp_200.223.155.35_last_posted","1424462951","yes");
INSERT INTO `wp_options` VALUES("71939","_transient__bbp_186.88.214.160_last_posted","1424466549","yes");
INSERT INTO `wp_options` VALUES("71918","_transient__bbp_190.207.176.189_last_posted","1424463326","yes");
INSERT INTO `wp_options` VALUES("71946","_transient__bbp_190.77.6.57_last_posted","1424467717","yes");
INSERT INTO `wp_options` VALUES("71950","_transient__bbp_190.207.146.158_last_posted","1424467992","yes");
INSERT INTO `wp_options` VALUES("71987","_transient__bbp_117.177.147.161_last_posted","1424472760","yes");
INSERT INTO `wp_options` VALUES("71988","_transient__bbp_190.199.146.168_last_posted","1424472852","yes");
INSERT INTO `wp_options` VALUES("72010","_transient__bbp_183.203.208.163_last_posted","1427707937","yes");
INSERT INTO `wp_options` VALUES("72035","_transient__bbp_190.79.211.20_last_posted","1424482005","yes");
INSERT INTO `wp_options` VALUES("72036","_transient__bbp_186.91.75.50_last_posted","1424482041","yes");
INSERT INTO `wp_options` VALUES("72040","_transient__bbp_197.231.248.92_last_posted","1424891924","yes");
INSERT INTO `wp_options` VALUES("72069","_transient__bbp_190.77.129.131_last_posted","1424486815","yes");
INSERT INTO `wp_options` VALUES("72070","_transient__bbp_103.4.144.102_last_posted","1424486974","yes");
INSERT INTO `wp_options` VALUES("72095","_transient__bbp_202.62.65.78_last_posted","1425855858","yes");
INSERT INTO `wp_options` VALUES("72123","_transient__bbp_200.198.193.144_last_posted","1424496125","yes");
INSERT INTO `wp_options` VALUES("72124","_transient__bbp_117.173.20.129_last_posted","1424496182","yes");
INSERT INTO `wp_options` VALUES("72128","_transient__bbp_115.43.4.68_last_posted","1425186783","yes");
INSERT INTO `wp_options` VALUES("72151","_transient__bbp_37.187.129.166_last_posted","1424500502","yes");
INSERT INTO `wp_options` VALUES("72173","_transient__bbp_111.13.136.56_last_posted","1425519358","yes");
INSERT INTO `wp_options` VALUES("72177","_transient__bbp_112.19.125.106_last_posted","1424505165","yes");
INSERT INTO `wp_options` VALUES("72184","_transient__bbp_183.223.204.163_last_posted","1424509173","yes");
INSERT INTO `wp_options` VALUES("72188","_transient__bbp_183.224.1.56_last_posted","1427388314","yes");
INSERT INTO `wp_options` VALUES("72205","_transient__bbp_31.3.244.10_last_posted","1424513384","yes");
INSERT INTO `wp_options` VALUES("72209","_transient__bbp_119.14.107.213_last_posted","1424513485","yes");
INSERT INTO `wp_options` VALUES("72225","_transient__bbp_117.174.201.135_last_posted","1424670593","yes");
INSERT INTO `wp_options` VALUES("72241","_transient__bbp_62.245.45.50_last_posted","1424521398","yes");
INSERT INTO `wp_options` VALUES("72245","_transient__bbp_87.252.230.142_last_posted","1424521520","yes");
INSERT INTO `wp_options` VALUES("72246","_transient__bbp_194.63.140.147_last_posted","1424521598","yes");
INSERT INTO `wp_options` VALUES("72250","_transient__bbp_183.222.159.228_last_posted","1424521850","yes");
INSERT INTO `wp_options` VALUES("72306","_transient__bbp_106.37.236.144_last_posted","1424534551","yes");
INSERT INTO `wp_options` VALUES("73111","_transient__bbp_124.207.129.166_last_posted","1426866117","yes");
INSERT INTO `wp_options` VALUES("72268","_transient__bbp_163.30.45.100_last_posted","1424526204","yes");
INSERT INTO `wp_options` VALUES("72337","_transient__bbp_27.254.141.10_last_posted","1424538839","yes");
INSERT INTO `wp_options` VALUES("72341","_transient__bbp_59.125.78.181_last_posted","1424539004","yes");
INSERT INTO `wp_options` VALUES("72357","_transient__bbp_117.166.21.106_last_posted","1424543090","yes");
INSERT INTO `wp_options` VALUES("72419","_transient__bbp_192.227.220.47_last_posted","1424552198","yes");
INSERT INTO `wp_options` VALUES("72435","_transient__bbp_223.86.66.251_last_posted","1424555853","yes");
INSERT INTO `wp_options` VALUES("72460","_transient__bbp_95.56.192.75_last_posted","1424758494","yes");
INSERT INTO `wp_options` VALUES("72518","_transient__bbp_93.174.90.30_last_posted","1424568472","yes");
INSERT INTO `wp_options` VALUES("72522","_transient__bbp_118.244.190.32_last_posted","1424782400","yes");
INSERT INTO `wp_options` VALUES("72554","_transient__bbp_182.118.23.7_last_posted","1427653639","yes");
INSERT INTO `wp_options` VALUES("72579","_transient__bbp_117.177.240.40_last_posted","1427137697","yes");
INSERT INTO `wp_options` VALUES("72583","_transient__bbp_117.173.21.128_last_posted","1424577203","yes");
INSERT INTO `wp_options` VALUES("72593","_transient__bbp_223.86.66.191_last_posted","1424678732","yes");
INSERT INTO `wp_options` VALUES("72615","_transient__bbp_201.210.88.149_last_posted","1424581446","yes");
INSERT INTO `wp_options` VALUES("72619","_transient__bbp_183.220.247.138_last_posted","1424581531","yes");
INSERT INTO `wp_options` VALUES("72632","_transient__bbp_117.173.121.169_last_posted","1424582991","yes");
INSERT INTO `wp_options` VALUES("72682","_transient__bbp_2001:41d0:52:800::607_last_posted","1425504430","yes");
INSERT INTO `wp_options` VALUES("72707","_transient__bbp_2001:4b98:dc0:45:216:3eff:fefa:4e62_last_posted","1424594030","yes");
INSERT INTO `wp_options` VALUES("72723","_transient__bbp_212.4.97.117_last_posted","1424595320","yes");
INSERT INTO `wp_options` VALUES("72745","_transient__bbp_183.222.156.2_last_posted","1424598275","yes");
INSERT INTO `wp_options` VALUES("72809","_transient__bbp_117.177.144.240_last_posted","1424606204","yes");
INSERT INTO `wp_options` VALUES("72840","_transient__bbp_117.177.240.30_last_posted","1424610328","yes");
INSERT INTO `wp_options` VALUES("72844","_transient__bbp_212.12.12.165_last_posted","1424610769","yes");
INSERT INTO `wp_options` VALUES("72879","_transient__bbp_89.107.114.160_last_posted","1425017447","yes");
INSERT INTO `wp_options` VALUES("72904","_transient__bbp_183.223.213.241_last_posted","1424619430","yes");
INSERT INTO `wp_options` VALUES("72938","_transient__bbp_186.94.173.26_last_posted","1424623591","yes");
INSERT INTO `wp_options` VALUES("72939","_transient__bbp_183.222.158.100_last_posted","1424623763","yes");
INSERT INTO `wp_options` VALUES("72974","_transient__bbp_112.19.13.167_last_posted","1424628120","yes");
INSERT INTO `wp_options` VALUES("73021","_transient__bbp_183.222.156.250_last_posted","1424638952","yes");
INSERT INTO `wp_options` VALUES("73028","_transient__bbp_183.228.69.20_last_posted","1424640281","yes");
INSERT INTO `wp_options` VALUES("73035","_transient__bbp_111.248.132.80_last_posted","1424642904","yes");
INSERT INTO `wp_options` VALUES("73039","_transient__bbp_190.72.160.68_last_posted","1424700077","yes");
INSERT INTO `wp_options` VALUES("73067","_transient__bbp_54.198.153.225_last_posted","1424648954","yes");
INSERT INTO `wp_options` VALUES("73118","_transient__bbp_54.167.83.163_last_posted","1424657272","yes");
INSERT INTO `wp_options` VALUES("74913","_transient__bbp_115.28.238.147_last_posted","1425821475","yes");
INSERT INTO `wp_options` VALUES("73122","_transient__bbp_183.136.135.153_last_posted","1427133203","yes");
INSERT INTO `wp_options` VALUES("73123","_transient__bbp_180.177.86.46_last_posted","1424657606","yes");
INSERT INTO `wp_options` VALUES("73187","_transient__bbp_117.177.240.66_last_posted","1424666196","yes");
INSERT INTO `wp_options` VALUES("73212","_transient__bbp_183.220.241.192_last_posted","1424670384","yes");
INSERT INTO `wp_options` VALUES("73259","_transient__bbp_111.9.232.64_last_posted","1424678170","yes");
INSERT INTO `wp_options` VALUES("73287","_transient__bbp_202.106.182.248_last_posted","1427269446","yes");
INSERT INTO `wp_options` VALUES("73328","_transient__bbp_123.195.4.150_last_posted","1424691083","yes");
INSERT INTO `wp_options` VALUES("73427","_transient__bbp_183.222.157.101_last_posted","1424704652","yes");
INSERT INTO `wp_options` VALUES("73458","_transient__bbp_200.84.235.176_last_posted","1424708855","yes");
INSERT INTO `wp_options` VALUES("73483","_transient__bbp_118.244.190.38_last_posted","1425004221","yes");
INSERT INTO `wp_options` VALUES("73487","_transient__bbp_115.29.8.107_last_posted","1427073643","yes");
INSERT INTO `wp_options` VALUES("73494","_transient__bbp_201.211.148.75_last_posted","1424714132","yes");
INSERT INTO `wp_options` VALUES("73520","_transient__bbp_200.84.203.122_last_posted","1424717130","yes");
INSERT INTO `wp_options` VALUES("73557","_transient__bbp_134.100.127.214_last_posted","1424721990","yes");
INSERT INTO `wp_options` VALUES("73615","_transient__bbp_119.2.47.91_last_posted","1424730594","yes");
INSERT INTO `wp_options` VALUES("73619","_transient__bbp_182.18.158.110_last_posted","1424955758","yes");
INSERT INTO `wp_options` VALUES("73626","_transient__bbp_183.222.157.126_last_posted","1424731736","yes");
INSERT INTO `wp_options` VALUES("73660","_transient__bbp_187.50.138.205_last_posted","1424735659","yes");
INSERT INTO `wp_options` VALUES("73737","_transient__bbp_85.17.155.77_last_posted","1424744624","yes");
INSERT INTO `wp_options` VALUES("73774","_transient__bbp_112.19.124.72_last_posted","1424748745","yes");
INSERT INTO `wp_options` VALUES("73802","_transient__bbp_36.231.40.143_last_posted","1424752730","yes");
INSERT INTO `wp_options` VALUES("73867","_transient__bbp_117.139.28.252_last_posted","1424760950","yes");
INSERT INTO `wp_options` VALUES("73913","_transient__bbp_183.222.153.227_last_posted","1424766858","yes");
INSERT INTO `wp_options` VALUES("73938","_transient__bbp_186.89.240.232_last_posted","1424769603","yes");
INSERT INTO `wp_options` VALUES("73939","_transient__bbp_62.212.89.117_last_posted","1424769605","yes");
INSERT INTO `wp_options` VALUES("73943","_transient__bbp_211.157.180.62_last_posted","1424769627","yes");
INSERT INTO `wp_options` VALUES("73956","_transient__bbp_119.40.94.195_last_posted","1424861986","yes");
INSERT INTO `wp_options` VALUES("73993","_transient__bbp_117.174.206.229_last_posted","1424775726","yes");
INSERT INTO `wp_options` VALUES("74033","_transient__bbp_183.220.240.34_last_posted","1424844489","yes");
INSERT INTO `wp_options` VALUES("74089","_transient__bbp_183.220.246.164_last_posted","1424791219","yes");
INSERT INTO `wp_options` VALUES("74174","_transient__bbp_183.220.244.32_last_posted","1424796464","yes");
INSERT INTO `wp_options` VALUES("74287","_transient__bbp_183.223.174.68_last_posted","1424808768","yes");
INSERT INTO `wp_options` VALUES("74297","_transient__bbp_222.39.87.140_last_posted","1425594179","yes");
INSERT INTO `wp_options` VALUES("74322","_transient__bbp_37.187.101.28_last_posted","1427207975","yes");
INSERT INTO `wp_options` VALUES("74338","_transient__bbp_114.112.91.97_last_posted","1427520180","yes");
INSERT INTO `wp_options` VALUES("74366","_transient__bbp_186.92.12.58_last_posted","1424818289","yes");
INSERT INTO `wp_options` VALUES("74379","_transient__bbp_186.93.167.91_last_posted","1424819613","yes");
INSERT INTO `wp_options` VALUES("74401","_transient__bbp_201.219.182.202_last_posted","1424822667","yes");
INSERT INTO `wp_options` VALUES("74417","_transient__bbp_156.17.194.36_last_posted","1424824203","yes");
INSERT INTO `wp_options` VALUES("74436","_transient__bbp_117.139.28.156_last_posted","1424826384","yes");
INSERT INTO `wp_options` VALUES("74478","_transient__bbp_223.86.67.241_last_posted","1424832727","yes");
INSERT INTO `wp_options` VALUES("74578","_transient__bbp_117.177.226.103_last_posted","1424842634","yes");
INSERT INTO `wp_options` VALUES("74603","_transient__bbp_176.114.249.253_last_posted","1425008873","yes");
INSERT INTO `wp_options` VALUES("74614","_transient__bbp_177.66.76.92_last_posted","1424846880","yes");
INSERT INTO `wp_options` VALUES("74627","_transient__bbp_183.222.159.150_last_posted","1424848625","yes");
INSERT INTO `wp_options` VALUES("74670","_transient__bbp_176.108.160.241_last_posted","1424854366","yes");
INSERT INTO `wp_options` VALUES("74699","_transient__bbp_123.240.5.32_last_posted","1424964445","yes");
INSERT INTO `wp_options` VALUES("74842","_transient__bbp_118.244.190.37_last_posted","1425934825","yes");
INSERT INTO `wp_options` VALUES("74916","_transient__bbp_183.203.208.166_last_posted","1427343243","yes");
INSERT INTO `wp_options` VALUES("74944","_transient__bbp_122.117.237.149_last_posted","1424887559","yes");
INSERT INTO `wp_options` VALUES("74945","_transient__bbp_83.99.156.232_last_posted","1424887746","yes");
INSERT INTO `wp_options` VALUES("75021","_transient__bbp_183.220.241.228_last_posted","1424896365","yes");
INSERT INTO `wp_options` VALUES("80419","_transient__bbp_42.51.132.239_last_posted","1427090045","yes");
INSERT INTO `wp_options` VALUES("74957","_transient__bbp_182.234.74.161_last_posted","1424889068","yes");
INSERT INTO `wp_options` VALUES("75064","_transient__bbp_213.138.115.18_last_posted","1425850043","yes");
INSERT INTO `wp_options` VALUES("75104","_transient__bbp_190.78.110.254_last_posted","1424905067","yes");
INSERT INTO `wp_options` VALUES("75241","_transient__bbp_222.45.196.19_last_posted","1427043497","yes");
INSERT INTO `wp_options` VALUES("75260","_transient__bbp_212.16.104.33_last_posted","1424922775","yes");
INSERT INTO `wp_options` VALUES("75282","_transient__bbp_58.246.199.122_last_posted","1424925303","yes");
INSERT INTO `wp_options` VALUES("75301","_transient__bbp_137.117.176.132_last_posted","1424927181","yes");
INSERT INTO `wp_options` VALUES("75448","_transient__bbp_117.173.21.148_last_posted","1425013575","yes");
INSERT INTO `wp_options` VALUES("75470","_transient__bbp_58.23.233.7_last_posted","1424945025","yes");
INSERT INTO `wp_options` VALUES("75492","_transient__bbp_85.183.206.188_last_posted","1426123852","yes");
INSERT INTO `wp_options` VALUES("75565","_transient__bbp_111.9.232.155_last_posted","1424956580","yes");
INSERT INTO `wp_options` VALUES("75690","_transient__bbp_117.177.147.56_last_posted","1424973275","yes");
INSERT INTO `wp_options` VALUES("75839","_transient__bbp_183.220.106.164_last_posted","1424990970","yes");
INSERT INTO `wp_options` VALUES("75888","_transient__bbp_117.174.192.25_last_posted","1424996148","yes");
INSERT INTO `wp_options` VALUES("75916","_transient__bbp_117.177.45.157_last_posted","1424999461","yes");
INSERT INTO `wp_options` VALUES("75996","_transient__bbp_218.204.118.236_last_posted","1425008555","yes");
INSERT INTO `wp_options` VALUES("76006","_transient__bbp_221.228.248.248_last_posted","1425009733","yes");
INSERT INTO `wp_options` VALUES("76108","_transient__bbp_193.110.157.151_last_posted","1426743009","yes");
INSERT INTO `wp_options` VALUES("76157","_transient__bbp_217.12.214.70_last_posted","1425027860","yes");
INSERT INTO `wp_options` VALUES("76188","_transient__bbp_117.175.110.186_last_posted","1425031625","yes");
INSERT INTO `wp_options` VALUES("76222","_transient__bbp_112.18.184.92_last_posted","1425036213","yes");
INSERT INTO `wp_options` VALUES("76238","_transient__bbp_178.217.25.138_last_posted","1425193649","yes");
INSERT INTO `wp_options` VALUES("76298","_transient__bbp_114.255.183.173_last_posted","1425045026","yes");
INSERT INTO `wp_options` VALUES("76299","_transient__bbp_183.220.241.254_last_posted","1425045230","yes");
INSERT INTO `wp_options` VALUES("76366","_transient__bbp_222.55.9.21_last_posted","1425054193","yes");
INSERT INTO `wp_options` VALUES("76385","_transient__bbp_117.175.11.105_last_posted","1425056180","yes");
INSERT INTO `wp_options` VALUES("76462","_transient__bbp_183.220.244.160_last_posted","1425067255","yes");
INSERT INTO `wp_options` VALUES("76511","_transient__bbp_46.238.120.2_last_posted","1425074974","yes");
INSERT INTO `wp_options` VALUES("76590","_transient__bbp_119.97.164.48_last_posted","1426035643","yes");
INSERT INTO `wp_options` VALUES("76640","_transient__bbp_117.175.59.150_last_posted","1425091397","yes");
INSERT INTO `wp_options` VALUES("76647","_transient__bbp_183.224.1.29_last_posted","1425092640","yes");
INSERT INTO `wp_options` VALUES("76775","_transient__bbp_112.19.6.97_last_posted","1425108729","yes");
INSERT INTO `wp_options` VALUES("76855","_transient__bbp_94.247.25.162_last_posted","1427395233","yes");
INSERT INTO `wp_options` VALUES("76856","_transient__bbp_219.140.175.71_last_posted","1425445458","yes");
INSERT INTO `wp_options` VALUES("76944","_transient__bbp_183.223.204.189_last_posted","1425130098","yes");
INSERT INTO `wp_options` VALUES("77051","_transient__bbp_183.222.152.116_last_posted","1425142638","yes");
INSERT INTO `wp_options` VALUES("77138","_transient__bbp_117.173.20.168_last_posted","1425152612","yes");
INSERT INTO `wp_options` VALUES("77255","_transient__bbp_183.222.157.23_last_posted","1425167695","yes");
INSERT INTO `wp_options` VALUES("80410","_transient__bbp_190.158.241.146_last_posted","1425577456","yes");
INSERT INTO `wp_options` VALUES("77408","_transient__bbp_117.177.147.9_last_posted","1425184854","yes");
INSERT INTO `wp_options` VALUES("77512","_transient__bbp_145.100.91.12_last_posted","1425197366","yes");
INSERT INTO `wp_options` VALUES("77567","_transient__bbp_200.16.119.246_last_posted","1425203661","yes");
INSERT INTO `wp_options` VALUES("77679","_transient__bbp_112.18.183.163_last_posted","1425216523","yes");
INSERT INTO `wp_options` VALUES("77683","_transient__bbp_112.18.74.33_last_posted","1425216750","yes");
INSERT INTO `wp_options` VALUES("77715","_transient__bbp_109.184.192.49_last_posted","1425219958","yes");
INSERT INTO `wp_options` VALUES("77716","_transient__bbp_223.16.0.191_last_posted","1425219969","yes");
INSERT INTO `wp_options` VALUES("77732","_transient__bbp_117.173.22.149_last_posted","1425222862","yes");
INSERT INTO `wp_options` VALUES("77736","_transient__bbp_183.222.81.213_last_posted","1425222975","yes");
INSERT INTO `wp_options` VALUES("77749","_transient__bbp_200.109.60.223_last_posted","1425225250","yes");
INSERT INTO `wp_options` VALUES("77780","_transient__bbp_117.174.203.187_last_posted","1425228883","yes");
INSERT INTO `wp_options` VALUES("77796","_transient__bbp_183.223.199.160_last_posted","1425230928","yes");
INSERT INTO `wp_options` VALUES("77824","_transient__bbp_117.169.1.115_last_posted","1426404158","yes");
INSERT INTO `wp_options` VALUES("77828","_transient__bbp_223.87.183.31_last_posted","1425234450","yes");
INSERT INTO `wp_options` VALUES("77839","_transient__bbp_117.169.1.51_last_posted","1425521640","yes");
INSERT INTO `wp_options` VALUES("77852","_transient__bbp_104.207.134.21_last_posted","1425237812","yes");
INSERT INTO `wp_options` VALUES("77868","_transient__bbp_183.220.244.251_last_posted","1425239872","yes");
INSERT INTO `wp_options` VALUES("77869","_transient__bbp_183.228.239.25_last_posted","1425239983","yes");
INSERT INTO `wp_options` VALUES("77882","_transient__bbp_117.169.1.74_last_posted","1427648967","yes");
INSERT INTO `wp_options` VALUES("77892","_transient__bbp_223.86.219.186_last_posted","1425243417","yes");
INSERT INTO `wp_options` VALUES("77911","_transient__bbp_111.10.38.21_last_posted","1425245257","yes");
INSERT INTO `wp_options` VALUES("77912","_transient__bbp_182.155.112.152_last_posted","1425245316","yes");
INSERT INTO `wp_options` VALUES("77931","_transient__bbp_210.32.33.183_last_posted","1425721389","yes");
INSERT INTO `wp_options` VALUES("77947","_transient__bbp_200.109.139.197_last_posted","1425249310","yes");
INSERT INTO `wp_options` VALUES("77969","_transient__bbp_117.169.1.26_last_posted","1425251406","yes");
INSERT INTO `wp_options` VALUES("77973","_transient__bbp_117.169.1.56_last_posted","1427690128","yes");
INSERT INTO `wp_options` VALUES("77986","_transient__bbp_117.169.1.181_last_posted","1427647803","yes");
INSERT INTO `wp_options` VALUES("78002","_transient__bbp_111.9.133.115_last_posted","1425255323","yes");
INSERT INTO `wp_options` VALUES("78021","_transient__bbp_175.182.130.236_last_posted","1425257412","yes");
INSERT INTO `wp_options` VALUES("78059","_transient__bbp_117.139.46.180_last_posted","1425261317","yes");
INSERT INTO `wp_options` VALUES("78081","_transient__bbp_111.10.195.193_last_posted","1425263518","yes");
INSERT INTO `wp_options` VALUES("78082","_transient__bbp_186.93.5.63_last_posted","1425263621","yes");
INSERT INTO `wp_options` VALUES("78110","_transient__bbp_117.166.53.233_last_posted","1425267611","yes");
INSERT INTO `wp_options` VALUES("78132","_transient__bbp_117.169.1.69_last_posted","1425270053","yes");
INSERT INTO `wp_options` VALUES("78133","_transient__bbp_183.226.55.23_last_posted","1425270057","yes");
INSERT INTO `wp_options` VALUES("78146","_transient__bbp_112.44.204.29_last_posted","1425271983","yes");
INSERT INTO `wp_options` VALUES("78168","_transient__bbp_117.169.1.179_last_posted","1426622766","yes");
INSERT INTO `wp_options` VALUES("78187","_transient__bbp_183.131.144.204_last_posted","1427701707","yes");
INSERT INTO `wp_options` VALUES("78201","_transient__bbp_117.169.1.4_last_posted","1425353897","yes");
INSERT INTO `wp_options` VALUES("78211","_transient__bbp_117.169.1.167_last_posted","1427438671","yes");
INSERT INTO `wp_options` VALUES("78233","_transient__bbp_183.220.247.117_last_posted","1425283063","yes");
INSERT INTO `wp_options` VALUES("78234","_transient__bbp_183.223.40.153_last_posted","1425283117","yes");
INSERT INTO `wp_options` VALUES("78250","_transient__bbp_112.44.5.99_last_posted","1425284519","yes");
INSERT INTO `wp_options` VALUES("78281","_transient__bbp_117.174.217.157_last_posted","1425289885","yes");
INSERT INTO `wp_options` VALUES("78291","_transient__bbp_117.169.1.80_last_posted","1425290749","yes");
INSERT INTO `wp_options` VALUES("78329","_transient__bbp_112.19.128.40_last_posted","1425296730","yes");
INSERT INTO `wp_options` VALUES("78330","_transient__bbp_36.233.171.115_last_posted","1425296896","yes");
INSERT INTO `wp_options` VALUES("78364","_transient__bbp_117.176.55.62_last_posted","1425301341","yes");
INSERT INTO `wp_options` VALUES("78383","_transient__bbp_117.166.55.146_last_posted","1425303666","yes");
INSERT INTO `wp_options` VALUES("78432","_transient__bbp_223.85.80.199_last_posted","1425308788","yes");
INSERT INTO `wp_options` VALUES("78487","_transient__bbp_117.172.222.13_last_posted","1425315673","yes");
INSERT INTO `wp_options` VALUES("78494","_transient__bbp_111.197.163.250_last_posted","1425317111","yes");
INSERT INTO `wp_options` VALUES("78504","_transient__bbp_223.85.19.165_last_posted","1425317837","yes");
INSERT INTO `wp_options` VALUES("78545","_transient__bbp_117.169.1.54_last_posted","1426721712","yes");
INSERT INTO `wp_options` VALUES("78558","_transient__bbp_66.154.208.24_last_posted","1426095711","yes");
INSERT INTO `wp_options` VALUES("78562","_transient__bbp_117.169.1.77_last_posted","1425323530","yes");
INSERT INTO `wp_options` VALUES("78593","_transient__bbp_190.37.161.112_last_posted","1425327952","yes");
INSERT INTO `wp_options` VALUES("78603","_transient__bbp_117.173.203.33_last_posted","1425329272","yes");
INSERT INTO `wp_options` VALUES("78607","_transient__bbp_117.166.23.247_last_posted","1425399193","yes");
INSERT INTO `wp_options` VALUES("78644","_transient__bbp_117.169.1.7_last_posted","1427544969","yes");
INSERT INTO `wp_options` VALUES("78660","_transient__bbp_117.169.1.45_last_posted","1427665774","yes");
INSERT INTO `wp_options` VALUES("78664","_transient__bbp_117.168.13.84_last_posted","1425335496","yes");
INSERT INTO `wp_options` VALUES("78771","_transient__bbp_117.169.1.207_last_posted","1425457592","yes");
INSERT INTO `wp_options` VALUES("78817","_transient__bbp_117.168.35.100_last_posted","1425353362","yes");
INSERT INTO `wp_options` VALUES("78872","_transient__bbp_223.85.22.119_last_posted","1425359848","yes");
INSERT INTO `wp_options` VALUES("78879","_transient__bbp_117.169.1.194_last_posted","1426487760","yes");
INSERT INTO `wp_options` VALUES("78883","_transient__bbp_183.222.166.80_last_posted","1425361098","yes");
INSERT INTO `wp_options` VALUES("78957","_transient__bbp_223.85.80.143_last_posted","1425369271","yes");
INSERT INTO `wp_options` VALUES("78961","_transient__bbp_117.169.1.201_last_posted","1425369552","yes");
INSERT INTO `wp_options` VALUES("78965","_transient__bbp_117.169.1.157_last_posted","1427446521","yes");
INSERT INTO `wp_options` VALUES("79050","_transient__bbp_117.169.1.165_last_posted","1426561544","yes");
INSERT INTO `wp_options` VALUES("79128","_transient__bbp_183.222.153.59_last_posted","1425392713","yes");
INSERT INTO `wp_options` VALUES("79207","_transient__bbp_117.169.1.197_last_posted","1427474908","yes");
INSERT INTO `wp_options` VALUES("79211","_transient__bbp_117.169.1.234_last_posted","1425404063","yes");
INSERT INTO `wp_options` VALUES("79255","_transient__bbp_221.226.2.254_last_posted","1426321603","yes");
INSERT INTO `wp_options` VALUES("79301","_transient__bbp_118.114.98.57_last_posted","1425415711","yes");
INSERT INTO `wp_options` VALUES("79305","_transient__bbp_218.65.219.172_last_posted","1425816245","yes");
INSERT INTO `wp_options` VALUES("79333","_transient__bbp_117.166.41.245_last_posted","1425421145","yes");
INSERT INTO `wp_options` VALUES("79334","_transient__bbp_112.19.125.38_last_posted","1425421215","yes");
INSERT INTO `wp_options` VALUES("79339","_transient__bbp_117.169.1.241_last_posted","1425421423","yes");
INSERT INTO `wp_options` VALUES("79419","_transient__bbp_117.169.1.98_last_posted","1425432584","yes");
INSERT INTO `wp_options` VALUES("79478","_transient__bbp_23.106.176.176_last_posted","1425438628","yes");
INSERT INTO `wp_options` VALUES("79482","_transient__bbp_116.228.80.186_last_posted","1426971832","yes");
INSERT INTO `wp_options` VALUES("79486","_transient__bbp_117.169.1.137_last_posted","1426455607","yes");
INSERT INTO `wp_options` VALUES("79665","_transient__bbp_117.169.1.100_last_posted","1425457933","yes");
INSERT INTO `wp_options` VALUES("79669","_transient__bbp_178.151.98.102_last_posted","1425458158","yes");
INSERT INTO `wp_options` VALUES("79760","_transient__bbp_117.173.22.77_last_posted","1425468838","yes");
INSERT INTO `wp_options` VALUES("79770","_transient__bbp_183.223.216.56_last_posted","1425469602","yes");
INSERT INTO `wp_options` VALUES("79807","_transient__bbp_198.23.250.31_last_posted","1425474388","yes");
INSERT INTO `wp_options` VALUES("79851","_transient__bbp_222.45.194.122_last_posted","1425928525","yes");
INSERT INTO `wp_options` VALUES("79891","_transient__bbp_123.155.152.61_last_posted","1425485186","yes");
INSERT INTO `wp_options` VALUES("79895","_transient__bbp_117.169.1.128_last_posted","1426530954","yes");
INSERT INTO `wp_options` VALUES("79905","_transient__bbp_46.229.139.77_last_posted","1426882429","yes");
INSERT INTO `wp_options` VALUES("79933","_transient__bbp_117.169.1.204_last_posted","1427506138","yes");
INSERT INTO `wp_options` VALUES("79937","_transient__bbp_117.175.98.141_last_posted","1425491418","yes");
INSERT INTO `wp_options` VALUES("79944","_transient__bbp_117.169.1.225_last_posted","1425616271","yes");
INSERT INTO `wp_options` VALUES("79976","_transient__bbp_117.169.1.188_last_posted","1427587794","yes");
INSERT INTO `wp_options` VALUES("79989","_transient__bbp_192.99.73.116_last_posted","1425498516","yes");
INSERT INTO `wp_options` VALUES("80023","_transient__bbp_117.166.246.80_last_posted","1425502343","yes");
INSERT INTO `wp_options` VALUES("80069","_transient__bbp_117.169.1.50_last_posted","1425508113","yes");
INSERT INTO `wp_options` VALUES("80106","_transient__bbp_59.78.160.246_last_posted","1425513618","yes");
INSERT INTO `wp_options` VALUES("80107","_transient__bbp_95.168.217.24_last_posted","1427005313","yes");
INSERT INTO `wp_options` VALUES("80144","_transient__bbp_117.148.53.144_last_posted","1425519317","yes");
INSERT INTO `wp_options` VALUES("80182","_transient__bbp_111.10.49.98_last_posted","1425525120","yes");
INSERT INTO `wp_options` VALUES("80219","_transient__bbp_183.203.208.164_last_posted","1427107463","yes");
INSERT INTO `wp_options` VALUES("80266","_transient__bbp_117.169.1.10_last_posted","1425537216","yes");
INSERT INTO `wp_options` VALUES("80401","_transient__bbp_183.220.128.52_last_posted","1425558907","yes");
INSERT INTO `wp_options` VALUES("80402","_transient__bbp_112.19.134.45_last_posted","1425559258","yes");
INSERT INTO `wp_options` VALUES("80408","_transient__bbp_186.101.13.213_last_posted","1425939456","yes");
INSERT INTO `wp_options` VALUES("80411","_transient__bbp_117.177.147.204_last_posted","1425579528","yes");
INSERT INTO `wp_options` VALUES("80417","_transient__bbp_222.161.213.77_last_posted","1425944014","yes");
INSERT INTO `wp_options` VALUES("80418","_transient__bbp_117.177.240.64_last_posted","1426002531","yes");
INSERT INTO `wp_options` VALUES("80420","_transient__bbp_112.19.221.255_last_posted","1425596285","yes");
INSERT INTO `wp_options` VALUES("80421","_transient__bbp_117.169.1.61_last_posted","1426779484","yes");
INSERT INTO `wp_options` VALUES("96862","_transient__bbp_196.201.218.202_last_posted","1427671513","yes");
INSERT INTO `wp_options` VALUES("97156","_transient__bbp_117.169.1.29_last_posted","1427516371","yes");
INSERT INTO `wp_options` VALUES("80433","_transient__bbp_117.169.1.168_last_posted","1426710681","yes");
INSERT INTO `wp_options` VALUES("80443","_transient__bbp_124.205.129.100_last_posted","1425617503","yes");
INSERT INTO `wp_options` VALUES("80632","_transient__bbp_14.18.234.131_last_posted","1426676795","yes");
INSERT INTO `wp_options` VALUES("80642","_transient__bbp_49.65.226.178_last_posted","1425646662","yes");
INSERT INTO `wp_options` VALUES("80658","_transient__bbp_182.73.213.58_last_posted","1425648167","yes");
INSERT INTO `wp_options` VALUES("80734","_transient__bbp_210.211.99.70_last_posted","1426282650","yes");
INSERT INTO `wp_options` VALUES("80880","_transient__bbp_183.221.217.19_last_posted","1425672254","yes");
INSERT INTO `wp_options` VALUES("88062","_transient__bbp_177.223.48.132_last_posted","1426558261","yes");
INSERT INTO `wp_options` VALUES("88117","_transient__bbp_2001:da8:e000:1410:214:5eff:fe2b:9a9d_last_poste","1427246588","yes");
INSERT INTO `wp_options` VALUES("88367","_transient__bbp_128.199.129.237_last_posted","1426593264","yes");
INSERT INTO `wp_options` VALUES("80974","_transient__bbp_2001:4800:7813:516:4dab:7174:ff04:fbda_last_post","1425916392","yes");
INSERT INTO `wp_options` VALUES("81081","_transient__bbp_117.169.1.156_last_posted","1425695911","yes");
INSERT INTO `wp_options` VALUES("81187","_transient__bbp_183.220.71.235_last_posted","1425709548","yes");
INSERT INTO `wp_options` VALUES("81259","_transient__bbp_112.0.158.219_last_posted","1425718573","yes");
INSERT INTO `wp_options` VALUES("81281","_transient__bbp_37.187.97.36_last_posted","1427192227","yes");
INSERT INTO `wp_options` VALUES("81297","_transient__bbp_58.251.78.71_last_posted","1425957986","yes");
INSERT INTO `wp_options` VALUES("81325","_transient__bbp_223.85.99.79_last_posted","1425727239","yes");
INSERT INTO `wp_options` VALUES("81408","_transient__bbp_111.10.90.144_last_posted","1425738657","yes");
INSERT INTO `wp_options` VALUES("81463","_transient__bbp_213.211.132.220_last_posted","1425747013","yes");
INSERT INTO `wp_options` VALUES("81491","_transient__bbp_113.106.94.57_last_posted","1426329309","yes");
INSERT INTO `wp_options` VALUES("81498","_transient__bbp_117.173.21.88_last_posted","1425751338","yes");
INSERT INTO `wp_options` VALUES("81581","_transient__bbp_117.173.20.108_last_posted","1425761819","yes");
INSERT INTO `wp_options` VALUES("81642","_transient__bbp_223.87.191.55_last_posted","1425769587","yes");
INSERT INTO `wp_options` VALUES("81803","_transient__bbp_61.153.209.18_last_posted","1425787553","yes");
INSERT INTO `wp_options` VALUES("81890","_transient__bbp_177.0.118.244_last_posted","1426131899","yes");
INSERT INTO `wp_options` VALUES("82189","_transient__bbp_183.220.245.216_last_posted","1425832893","yes");
INSERT INTO `wp_options` VALUES("82241","_transient__bbp_94.247.179.116_last_posted","1425838913","yes");
INSERT INTO `wp_options` VALUES("82255","_transient__bbp_173.255.115.54_last_posted","1425840014","yes");
INSERT INTO `wp_options` VALUES("82286","_transient__bbp_78.22.24.121_last_posted","1425843558","yes");
INSERT INTO `wp_options` VALUES("82410","_transient__bbp_117.169.1.20_last_posted","1425858300","yes");
INSERT INTO `wp_options` VALUES("82420","_transient__bbp_183.221.220.10_last_posted","1425859192","yes");
INSERT INTO `wp_options` VALUES("82457","_transient__bbp_201.48.207.146_last_posted","1425863307","yes");
INSERT INTO `wp_options` VALUES("82464","_transient__bbp_49.74.88.8_last_posted","1425863914","yes");
INSERT INTO `wp_options` VALUES("82490","_transient__bbp_221.212.46.11_last_posted","1425866712","yes");
INSERT INTO `wp_options` VALUES("82503","_transient__bbp_117.166.65.75_last_posted","1425867849","yes");
INSERT INTO `wp_options` VALUES("82529","_transient__bbp_121.17.105.69_last_posted","1426140008","yes");
INSERT INTO `wp_options` VALUES("82520","_transient__bbp_183.228.73.122_last_posted","1425870589","yes");
INSERT INTO `wp_options` VALUES("82608","_transient__bbp_211.139.80.180_last_posted","1425882600","yes");
INSERT INTO `wp_options` VALUES("82710","_transient__bbp_175.44.27.177_last_posted","1425894983","yes");
INSERT INTO `wp_options` VALUES("82783","_transient__bbp_117.177.240.36_last_posted","1426904510","yes");
INSERT INTO `wp_options` VALUES("82966","_transient__bbp_117.177.240.34_last_posted","1425998317","yes");
INSERT INTO `wp_options` VALUES("82985","_transient__bbp_117.166.43.229_last_posted","1425928997","yes");
INSERT INTO `wp_options` VALUES("83052","_transient__bbp_138.0.253.43_last_posted","1426705308","yes");
INSERT INTO `wp_options` VALUES("83131","_transient__bbp_131.229.80.59_last_posted","1425950549","yes");
INSERT INTO `wp_options` VALUES("83244","_transient__bbp_124.207.175.91_last_posted","1425966627","yes");
INSERT INTO `wp_options` VALUES("83273","_transient__bbp_46.31.213.122_last_posted","1425970691","yes");
INSERT INTO `wp_options` VALUES("83301","_transient__bbp_211.157.180.58_last_posted","1426275104","yes");
INSERT INTO `wp_options` VALUES("83404","_transient__bbp_124.207.129.160_last_posted","1425988744","yes");
INSERT INTO `wp_options` VALUES("83438","_transient__bbp_175.44.4.142_last_posted","1425992571","yes");
INSERT INTO `wp_options` VALUES("83442","_transient__bbp_89.175.89.22_last_posted","1425993340","yes");
INSERT INTO `wp_options` VALUES("83555","_transient__bbp_138.0.253.18_last_posted","1426006732","yes");
INSERT INTO `wp_options` VALUES("83562","_transient__bbp_14.147.121.178_last_posted","1426007802","yes");
INSERT INTO `wp_options` VALUES("83649","_transient__bbp_89.31.147.68_last_posted","1426028107","yes");
INSERT INTO `wp_options` VALUES("83743","_transient__bbp_183.221.8.163_last_posted","1426029048","yes");
INSERT INTO `wp_options` VALUES("83804","_transient__bbp_59.78.160.244_last_posted","1426814664","yes");
INSERT INTO `wp_options` VALUES("83811","_transient__bbp_195.178.94.39_last_posted","1426036465","yes");
INSERT INTO `wp_options` VALUES("83840","_transient__bbp_180.250.44.162_last_posted","1426039795","yes");
INSERT INTO `wp_options` VALUES("83841","_transient__bbp_111.10.49.65_last_posted","1426039846","yes");
INSERT INTO `wp_options` VALUES("83918","_transient__bbp_183.222.162.181_last_posted","1426048118","yes");
INSERT INTO `wp_options` VALUES("83922","_transient__bbp_114.111.167.215_last_posted","1426048478","yes");
INSERT INTO `wp_options` VALUES("84029","_transient__bbp_120.202.249.196_last_posted","1426061613","yes");
INSERT INTO `wp_options` VALUES("84102","_transient__bbp_117.177.147.96_last_posted","1426070674","yes");
INSERT INTO `wp_options` VALUES("84169","_transient__bbp_116.51.12.146_last_posted","1426079439","yes");
INSERT INTO `wp_options` VALUES("84170","_transient__bbp_124.200.52.16_last_posted","1426758676","yes");
INSERT INTO `wp_options` VALUES("84214","_transient__bbp_114.111.167.210_last_posted","1427695612","yes");
INSERT INTO `wp_options` VALUES("84336","_transient__bbp_109.163.234.8_last_posted","1426099452","yes");
INSERT INTO `wp_options` VALUES("84364","_transient__bbp_184.105.239.95_last_posted","1426102965","yes");
INSERT INTO `wp_options` VALUES("84455","_transient__bbp_117.169.1.86_last_posted","1426113064","yes");
INSERT INTO `wp_options` VALUES("84825","_transient__bbp_222.45.195.34_last_posted","1427255114","yes");
INSERT INTO `wp_options` VALUES("84850","_transient__bbp_183.224.1.55_last_posted","1426158113","yes");
INSERT INTO `wp_options` VALUES("84857","_transient__bbp_93.120.179.174_last_posted","1426475885","yes");
INSERT INTO `wp_options` VALUES("84864","_transient__bbp_198.99.224.134_last_posted","1426159152","yes");
INSERT INTO `wp_options` VALUES("84941","_transient__bbp_173.182.188.48_last_posted","1426168221","yes");
INSERT INTO `wp_options` VALUES("84975","_transient__bbp_183.230.53.97_last_posted","1426172819","yes");
INSERT INTO `wp_options` VALUES("85042","_transient__bbp_223.4.21.184_last_posted","1426180087","yes");
INSERT INTO `wp_options` VALUES("85098","_transient__bbp_117.139.28.51_last_posted","1427085960","yes");
INSERT INTO `wp_options` VALUES("85159","_transient__bbp_183.220.158.16_last_posted","1426193369","yes");
INSERT INTO `wp_options` VALUES("85241","_transient__bbp_117.177.240.65_last_posted","1427036097","yes");
INSERT INTO `wp_options` VALUES("85260","_transient__bbp_59.78.160.247_last_posted","1426205363","yes");
INSERT INTO `wp_options` VALUES("85273","_transient__bbp_117.169.1.138_last_posted","1427039855","yes");
INSERT INTO `wp_options` VALUES("85317","_transient__bbp_216.218.216.194_last_posted","1426211163","yes");
INSERT INTO `wp_options` VALUES("85351","_transient__bbp_77.247.181.162_last_posted","1426215582","yes");
INSERT INTO `wp_options` VALUES("85391","_transient__bbp_60.206.239.195_last_posted","1426220387","yes");
INSERT INTO `wp_options` VALUES("85612","_transient__bbp_2a01:4f8:d12:3cf::2_last_posted","1426247208","yes");
INSERT INTO `wp_options` VALUES("85689","_transient__bbp_117.177.141.4_last_posted","1426256936","yes");
INSERT INTO `wp_options` VALUES("85744","_transient__bbp_155.133.18.152_last_posted","1426405725","yes");
INSERT INTO `wp_options` VALUES("85748","_transient__bbp_23.95.71.12_last_posted","1426263603","yes");
INSERT INTO `wp_options` VALUES("85948","_transient__bbp_183.222.152.87_last_posted","1426286422","yes");
INSERT INTO `wp_options` VALUES("85964","_transient__bbp_183.222.182.172_last_posted","1426288511","yes");
INSERT INTO `wp_options` VALUES("85995","_transient__bbp_117.169.1.155_last_posted","1426457839","yes");
INSERT INTO `wp_options` VALUES("86008","_transient__bbp_114.111.166.249_last_posted","1426293706","yes");
INSERT INTO `wp_options` VALUES("86058","_transient__bbp_177.0.118.247_last_posted","1427400666","yes");
INSERT INTO `wp_options` VALUES("86095","_transient__bbp_117.177.240.67_last_posted","1426303636","yes");
INSERT INTO `wp_options` VALUES("86202","_transient__bbp_118.244.255.12_last_posted","1426316826","yes");
INSERT INTO `wp_options` VALUES("86263","_transient__bbp_69.197.186.210_last_posted","1427203774","yes");
INSERT INTO `wp_options` VALUES("86418","_transient__bbp_111.10.59.80_last_posted","1426344198","yes");
INSERT INTO `wp_options` VALUES("86437","_transient__bbp_117.166.246.52_last_posted","1426453210","yes");
INSERT INTO `wp_options` VALUES("86456","_transient__bbp_123.204.186.209_last_posted","1426349049","yes");
INSERT INTO `wp_options` VALUES("86490","_transient__bbp_117.174.197.245_last_posted","1426352882","yes");
INSERT INTO `wp_options` VALUES("86491","_transient__bbp_117.175.110.228_last_posted","1426353022","yes");
INSERT INTO `wp_options` VALUES("86504","_transient__bbp_183.209.236.8_last_posted","1426355735","yes");
INSERT INTO `wp_options` VALUES("86520","_transient__bbp_117.169.1.40_last_posted","1426357551","yes");
INSERT INTO `wp_options` VALUES("86534","_transient__bbp_111.10.91.210_last_posted","1426358969","yes");
INSERT INTO `wp_options` VALUES("86544","_transient__bbp_117.169.1.127_last_posted","1427572680","yes");
INSERT INTO `wp_options` VALUES("86551","_transient__bbp_117.166.107.139_last_posted","1426363225","yes");
INSERT INTO `wp_options` VALUES("86573","_transient__bbp_117.169.1.176_last_posted","1426801149","yes");
INSERT INTO `wp_options` VALUES("86586","_transient__bbp_117.169.1.141_last_posted","1426368804","yes");
INSERT INTO `wp_options` VALUES("86590","_transient__bbp_117.139.28.43_last_posted","1426369548","yes");
INSERT INTO `wp_options` VALUES("86624","_transient__bbp_117.169.1.34_last_posted","1427499031","yes");
INSERT INTO `wp_options` VALUES("86631","_transient__bbp_112.18.177.83_last_posted","1426375564","yes");
INSERT INTO `wp_options` VALUES("86635","_transient__bbp_91.229.20.73_last_posted","1427641668","yes");
INSERT INTO `wp_options` VALUES("86657","_transient__bbp_117.169.1.89_last_posted","1426522887","yes");
INSERT INTO `wp_options` VALUES("86664","_transient__bbp_117.169.1.19_last_posted","1427707874","yes");
INSERT INTO `wp_options` VALUES("86699","_transient__bbp_183.228.198.248_last_posted","1426387917","yes");
INSERT INTO `wp_options` VALUES("86715","_transient__bbp_183.223.17.189_last_posted","1426389518","yes");
INSERT INTO `wp_options` VALUES("86752","_transient__bbp_111.10.193.181_last_posted","1426396764","yes");
INSERT INTO `wp_options` VALUES("86784","_transient__bbp_218.197.204.212_last_posted","1426402051","yes");
INSERT INTO `wp_options` VALUES("86788","_transient__bbp_117.169.1.177_last_posted","1426429048","yes");
INSERT INTO `wp_options` VALUES("86834","_transient__bbp_213.119.37.145_last_posted","1426409013","yes");
INSERT INTO `wp_options` VALUES("86886","_transient__bbp_223.86.6.219_last_posted","1426416310","yes");
INSERT INTO `wp_options` VALUES("86905","_transient__bbp_210.14.152.121_last_posted","1427343242","yes");
INSERT INTO `wp_options` VALUES("86933","_transient__bbp_117.177.171.215_last_posted","1426421271","yes");
INSERT INTO `wp_options` VALUES("87016","_transient__bbp_117.169.1.94_last_posted","1426431562","yes");
INSERT INTO `wp_options` VALUES("87083","_transient__bbp_117.166.67.82_last_posted","1426439244","yes");
INSERT INTO `wp_options` VALUES("87131","_transient__bbp_39.184.24.101_last_posted","1426444273","yes");
INSERT INTO `wp_options` VALUES("87171","_transient__bbp_117.176.1.64_last_posted","1426448859","yes");
INSERT INTO `wp_options` VALUES("87211","_transient__bbp_117.169.1.229_last_posted","1426453446","yes");
INSERT INTO `wp_options` VALUES("87263","_transient__bbp_117.169.1.65_last_posted","1426715940","yes");
INSERT INTO `wp_options` VALUES("87267","_transient__bbp_117.169.1.135_last_posted","1426460094","yes");
INSERT INTO `wp_options` VALUES("87283","_transient__bbp_2607:5300:100:200::153e_last_posted","1427354742","yes");
INSERT INTO `wp_options` VALUES("87302","_transient__bbp_117.177.147.145_last_posted","1426464166","yes");
INSERT INTO `wp_options` VALUES("87321","_transient__bbp_212.144.224.58_last_posted","1426466353","yes");
INSERT INTO `wp_options` VALUES("87365","_transient__bbp_117.169.1.25_last_posted","1426470893","yes");
INSERT INTO `wp_options` VALUES("87399","_transient__bbp_117.169.1.198_last_posted","1426475248","yes");
INSERT INTO `wp_options` VALUES("87442","_transient__bbp_103.249.101.120_last_posted","1426480314","yes");
INSERT INTO `wp_options` VALUES("87446","_transient__bbp_117.169.1.58_last_posted","1427432750","yes");
INSERT INTO `wp_options` VALUES("87462","_transient__bbp_37.239.46.74_last_posted","1427689673","yes");
INSERT INTO `wp_options` VALUES("87469","_transient__bbp_95.37.138.250_last_posted","1427180484","yes");
INSERT INTO `wp_options` VALUES("87482","_transient__bbp_112.19.126.69_last_posted","1426485460","yes");
INSERT INTO `wp_options` VALUES("87502","_transient__bbp_222.45.16.102_last_posted","1426742855","yes");
INSERT INTO `wp_options` VALUES("87614","_transient__bbp_117.169.1.226_last_posted","1426503251","yes");
INSERT INTO `wp_options` VALUES("87660","_transient__bbp_117.169.1.60_last_posted","1427513001","yes");
INSERT INTO `wp_options` VALUES("87661","_transient__bbp_39.184.16.127_last_posted","1426508768","yes");
INSERT INTO `wp_options` VALUES("87677","_transient__bbp_117.169.1.116_last_posted","1426510628","yes");
INSERT INTO `wp_options` VALUES("87746","_transient__bbp_112.19.126.209_last_posted","1426518096","yes");
INSERT INTO `wp_options` VALUES("87828","_transient__bbp_223.85.96.89_last_posted","1426529282","yes");
INSERT INTO `wp_options` VALUES("87872","_transient__bbp_117.175.60.14_last_posted","1426535138","yes");
INSERT INTO `wp_options` VALUES("87906","_transient__bbp_183.221.147.78_last_posted","1426539808","yes");
INSERT INTO `wp_options` VALUES("87916","_transient__bbp_183.203.208.172_last_posted","1427367289","yes");
INSERT INTO `wp_options` VALUES("87956","_transient__bbp_117.166.227.86_last_posted","1426545783","yes");
INSERT INTO `wp_options` VALUES("114273","updraft_s3generic","a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("90755","_transient__bbp_83.103.150.72_last_posted","1426851821","yes");
INSERT INTO `wp_options` VALUES("88228","_transient__bbp_183.222.153.95_last_posted","1426578105","yes");
INSERT INTO `wp_options` VALUES("88244","_transient__bbp_117.166.119.226_last_posted","1426579703","yes");
INSERT INTO `wp_options` VALUES("88347","_transient__bbp_117.169.1.48_last_posted","1426591389","yes");
INSERT INTO `wp_options` VALUES("88348","_transient__bbp_117.169.1.78_last_posted","1427404556","yes");
INSERT INTO `wp_options` VALUES("88416","_transient__bbp_111.23.58.46_last_posted","1427326136","yes");
INSERT INTO `wp_options` VALUES("99122","_site_transient_timeout_browser_c917cbcbdbc2b619466b4aeb270ad980","1428308808","yes");
INSERT INTO `wp_options` VALUES("99123","_site_transient_browser_c917cbcbdbc2b619466b4aeb270ad980","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"36.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("99128","_transient_timeout_feed_2fb9572e3d6a42f680e36370936a57ae","1427747214","no");
INSERT INTO `wp_options` VALUES("99129","_transient_feed_2fb9572e3d6a42f680e36370936a57ae","a:4:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:303:\"
    
    
    
    
    
    
    
  
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordPress Francophone : Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/planet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:9:\"alternate\";s:4:\"type\";s:9:\"text/html\";s:4:\"href\";s:35:\"http://www.wordpress-fr.net/planet/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:20:\"application/atom+xml\";s:4:\"href\";s:54:\"http://feeds.feedburner.com/WordpressFrancophonePlanet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"2015-03-30T10:19:31Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Author\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:5:\"entry\";a:20:{i:0;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WP Formation : En juin 2015, faites le plein de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wpformation.com/juin-2015-plein-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://wpformation.com/juin-2015-plein-de-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-30T08:00:30+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WPFormation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1320:\"<div>
<p><img width=\"300\" height=\"236\" src=\"http://wpformation.com/wp-content/uploads/2015/03/wc-lyon-2015-300x236.jpg\" class=\"attachment-medium wp-post-image\" alt=\"wordcamp Lyon 2015\" style=\"float: right; margin:0 0 10px 10px;\">Il est des mois comme cela ou les &eacute;v&eacute;nements WordPress se bousculent... En juin 2015, il y aura 2 &eacute;v&eacute;nements WordPress &agrave; 1&nbsp;jour d&rsquo;intervalle.&nbsp;Il s\'agit du premier WordCamp Lyon&nbsp;le 05 juin 2015 et&nbsp;du&nbsp;WPMX Day 2015 le 06 juin 2015 &agrave; Biarritz. &nbsp; 1er WordCamp LYON La premi&egrave;re &eacute;dition du WordCamp Lyon aura lieu le 5 [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/juin-2015-plein-de-wordpress/\">En juin 2015, faites le plein de WordPress</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Grégoire Noyelle : ACF Pro :: Ajouter des pages d’options WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:80:\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-30T07:00:55+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:779:\"<div>Dans ce tutoriel, nous verrons comment utiliser le Add-on Options Page du plugin Advanced Custom Fields (ACF) avec le th&egrave;me par d&eacute;faut Twenty Fifteen. Pr&eacute;sentation de l&rsquo;add-on Options page est r&eacute;serv&eacute; pour ajouter de nouvelles options dans votre back-office. Celles-ci seront accessibles par l&rsquo;administrateur du futur site. Applications possibles Tous les champs ACF sont disponibles ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 30 mars 2015 par <a href=\"http://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\">ACF Pro :: Ajouter des pages d&rsquo;options WordPress</a>.</p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"SEOMix : Nouvelle session de formation « WordPress et SEO »\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:65:\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-26T08:00:27+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:2325:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2011/05/banniere-seomix-250x250.png\" class=\"attachment-thumb-250-250-true wp-post-image\" alt=\"SeoMix\"></div>SeoMix lance une nouvelle date de formation \"WordPress et R&eacute;f&eacute;rencement naturel\". Ne ratez pas cette occasion d\'am&eacute;liorer vos connaissances !<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\">Nouvelle session de formation &laquo;&nbsp;WordPress et SEO&nbsp;&raquo;</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> Une toute nouvelle session de la formation WordPress et SEO vient d&rsquo;&ecirc;tre ajout&eacute;e. Je r&eacute;it&egrave;re cette ann&eacute;e l&rsquo;op&eacute;ration qui avait si bien fonctionn&eacute; l&rsquo;ann&eacute;e derni&egrave;re, et dont les retours des participants avaient &eacute;t&eacute; excellents. Si vous voulez r&eacute;ellement savoir optimiser le SEO de ce CMS, sautez sur l&rsquo;occasion ! Plan de formation Voici les grandes th&eacute;matiques qui seront abord&eacute;es lors de cette journ&eacute;e : Avant-propos sur le r&eacute;f&eacute;rencement naturel Les contenus et la Structure La popularit&eacute; L&rsquo;aspect technique 2- Auditer son site WordPress Que regarder en premier ? Les outils externes Les outils internes Le suivi des erreurs, du trafic et du positionnement L&rsquo;analyse sp&eacute;cifique de WordPress lors de l&rsquo;audit Comment corriger son site ? 3- La s&eacute;curit&eacute; de son site L&rsquo;impact en r&eacute;f&eacute;rencement Les utilisateurs Les plugins Les backups 4- Les r&eacute;glages de WordPress G&eacute;n&eacute;ral &Eacute;criture Lecture Discussion M&eacute;dias Permaliens 5- Les plugins de r&eacute;f&eacute;rence Yoast WordPress SEO Redirection Broken Link Checker WP Sitemap Page YARPP WP Page-Navi SX no Pagination 6- Les th&egrave;mes Pourquoi s&rsquo;en m&eacute;fier La duplication de contenus (DUST) La duplication de liens Les contenus pauvres Les erreurs du header Le concept des hooks Maillage interne et structure en silos 7- Performance, ergonomie et optimisation SEO&hellip;</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/J9I81Jrq2KU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WP Formation : Par où commencer pour auditer votre WordPress ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wpformation.com/auditer-votre-site-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://wpformation.com/auditer-votre-site-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-26T07:09:01+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1323:\"<div>
<p><img width=\"300\" height=\"200\" src=\"http://wpformation.com/wp-content/uploads/2015/03/Audit-wordpress-300x200.jpg\" class=\"attachment-medium wp-post-image\" alt=\"Audit WordPress\" style=\"float: right; margin:0 0 10px 10px;\">Parmi tous les outils SEO du web, il en existe quelques-uns qui sortent du lot comme &eacute;crit dans plusieurs articles en mati&egrave;re de r&eacute;f&eacute;rencement. Ce concept ne fait pas tout. Voil&agrave; pourquoi, aujourd\'hui, je publie quelques astuces pour influencer ou plus directement et de mani&egrave;re b&eacute;n&eacute;fique votre tendance SEO. &nbsp; Se tenir au courant des [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/auditer-votre-site-wordpress/\">Par o&ugrave; commencer pour auditer votre WordPress ?</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WordPress Francophone : La problématique des traductions officielles\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-25T09:07:35+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:6942:\"<div>
<p>Merci &agrave; WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une probl&eacute;matique tr&egrave;s sp&eacute;cifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je r&eacute;dige une seconde version du livre &laquo;&nbsp;Optimiser son r&eacute;f&eacute;rencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confront&eacute; &agrave; une probl&eacute;matique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilis&eacute; ?</h2>
<p>Th&eacute;oriquement, la seule et unique r&eacute;ponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la premi&egrave;re fois que j&rsquo;ai &eacute;t&eacute; confront&eacute; &agrave; ce probl&egrave;me de traduction a &eacute;t&eacute; lorsque mon &eacute;diteur m&rsquo;a indiqu&eacute; que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez &eacute;trange, et la question que je me pose &agrave; nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilis&eacute; par la communaut&eacute; : Plugin ;</li>
<li>un autre terme utilis&eacute; par une partie de la communaut&eacute; : Moudule ;</li>
<li>le terme le plus couramment utilis&eacute; par certains &eacute;diteurs : Plug-in.</li>
</ul>
<p>Pour y r&eacute;pondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la r&eacute;ponse est sans appel : le terme le plus utilis&eacute; de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\"></a></p>
<p>PS : pour avoir les derniers chiffres &agrave; jour de l&rsquo;&eacute;tude, les r&eacute;sultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une diff&eacute;rence entre traduction et usage ?</h2>
<p>Cette diff&eacute;rence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communaut&eacute; WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles fran&ccedil;ais utilise de mani&egrave;re naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plut&ocirc;t que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques compl&egrave;tement diff&eacute;rentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxB&eacute;nard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son r&eacute;f&eacute;rencement WordPress</em>&nbsp;&raquo; est le seul &agrave; utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes diff&eacute;rents pour d&eacute;signer une seule et m&ecirc;me chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communaut&eacute; : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilis&eacute; par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour d&eacute;signer cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confront&eacute; &agrave; un &eacute;norme probl&egrave;me d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;&ecirc;tre perdus puisque le terme a chang&eacute; dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et th&egrave;mes pouvaient r&eacute;cup&eacute;rer la valeur de la traduction de cette cha&icirc;ne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incoh&eacute;rences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous &agrave; changer nos appellations. Chaque membre de la communaut&eacute; devrait alors remplacer de mani&egrave;re syst&eacute;matique sa mani&egrave;re de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en r&eacute;f&eacute;rencement naturel : pourquoi appeler un &eacute;l&eacute;ment &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorit&eacute; de personnes utilise un autre terme lors de ses recherches sur le web&hellip;</p>
<p>Je reste donc assez mitig&eacute; sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"BoiteAWeb : WordCamp Lyon 2015 : 5 juin 2015, La plateforme\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://boiteaweb.fr/wordcamp-lyon-5-juin-2015-la-plateforme-8562.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:69:\"http://boiteaweb.fr/wordcamp-lyon-5-juin-2015-la-plateforme-8562.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T16:00:28+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:494:\"<div>Dans quelques&nbsp;semaines d&eacute;butera&nbsp;la premi&egrave;re &eacute;dition du WordCamp Lyon ! Th&eacute;oriquement, il fera beau&nbsp;et&nbsp;chaud, toute leur &eacute;quipe de volontaire accueillera le public et les orateurs avec entrain&nbsp;pour partager avec vous la premi&egrave;re &laquo; croisi&egrave;re WordPress &raquo; &agrave; bord de la Plateforme. En attendant il reste pas mal&nbsp;de travail et, en parlant des orateurs,&nbsp;un appel &agrave; tous [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"BoiteAWeb : Enquête 2015 AFUP et Human Coders : Les salaires de l’IT en France\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://boiteaweb.fr/enquete-2015-afup-human-coders-8560.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:60:\"http://boiteaweb.fr/enquete-2015-afup-human-coders-8560.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T10:48:25+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"<div>L\'AFUP lance la troisi&egrave;me &eacute;dition du barom&egrave;tre des salaires du PHP en France.</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WordPress Francophone : L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T07:52:23+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3077:\"<div>
<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;&eacute;quipe de traduction</h3>
<ul>
<li>Le WordCamp London a &eacute;t&eacute; l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arriv&eacute;e d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version fran&ccedil;aise de Belgique (en)</a>.</li>
<li>
<a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des &eacute;quipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a &eacute;t&eacute; expos&eacute;e &agrave; des failles de s&eacute;curit&eacute; importantes</a>. R&eacute;active, l&rsquo;&eacute;quipe de d&eacute;veloppement a publi&eacute; une version qui corrige les probl&egrave;mes.</p>
<h3>Pourquoi une agence a abandonn&eacute; WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise exp&eacute;rience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de No&euml;l</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndr&ocirc;me Sapin de No&euml;l </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour s&eacute;curiser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de s&eacute;curit&eacute;</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"L\'écho des plugins WordPress : Project Force Field\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://www.echodesplugins.li-an.fr/plugins/project-force-field/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:63:\"http://www.echodesplugins.li-an.fr/plugins/project-force-field/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-22T08:47:07+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"<div>Trompez les agresseurs sur le lien de login</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WordPress Francophone : L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-17T07:38:32+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3783:\"<div>
<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&hellip; Un grand &eacute;v&eacute;nement WordPress qui aura lieu &agrave; Biarritz. Les billets sont d&rsquo;ores et d&eacute;j&agrave; en vente !<br>
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;id&eacute;es au sein de la communaut&eacute; WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La premi&egrave;re beta de WordPress 4.2 est disponible</a>. Il est rappel&eacute; qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de d&eacute;veloppement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au t&eacute;l&eacute;chargement. C&rsquo;est une version de s&eacute;curit&eacute; : mettez &agrave; jour !<br>
&hellip;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug c&ocirc;t&eacute; notifications.</p>
<h3>Une mise &agrave; jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise &agrave; jour automatique des extensions</a> (en) pour raison de s&eacute;curit&eacute; est mise en place pour les versions sup&eacute;rieures ou &eacute;gales &agrave; WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui &ccedil;a existe</a> !</p>
<h3>Vuln&eacute;rabilit&eacute; dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vuln&eacute;rabilit&eacute; a &eacute;t&eacute; d&eacute;couverte dans WooCommerce</a> (en) par l&rsquo;&eacute;quipe de WordFence. L&rsquo;&eacute;quipe de Woo a rapidement r&eacute;agit pour colmater la br&egrave;che.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&hellip; (en).</p>
<h3>Le guide pour d&eacute;butant pour h&eacute;berger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les d&eacute;butants qui veulent se lancer dans l&rsquo;h&eacute;bergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"L\'écho des plugins WordPress : Changez rapidement la nature de vos billets\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://www.echodesplugins.li-an.fr/plugins/post-type-switcher/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:62:\"http://www.echodesplugins.li-an.fr/plugins/post-type-switcher/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-13T18:07:38+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"<div>Deux plugins qui permettent de modifier le type de vos billets</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WP Formation : Comment s’assurer que votre site est SEO-Friendly\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:72:\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-13T07:12:21+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1374:\"<div>
<p><img width=\"300\" height=\"120\" src=\"http://wpformation.com/wp-content/uploads/2015/03/audit-seo-woorank-300x120.png\" class=\"attachment-medium wp-post-image\" alt=\"audit seo woorank\" style=\"float: right; margin:0 0 10px 10px;\">En r&eacute;ponse &agrave; une remarque en commentaire sur cet article, j\'ai d&eacute;cid&eacute;, aujourd\'hui de m\'atteler &agrave; la pr&eacute;sentation de Woorank. &nbsp; Analyser, pas &agrave; pas, les pages de votre site M&ecirc;me si Woorank est limit&eacute; dans son offre gratuite, cet outil SEO en ligne offre beaucoup de donn&eacute;es pertinentes pour am&eacute;liorer votre site.&nbsp;Je vous sugg&egrave;re [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\">Comment s&rsquo;assurer que votre site est SEO-Friendly</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WordPress Francophone : L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-10T07:39:49+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3661:\"<div>
<h3>Un guide des communaut&eacute;s WordPress</h3>
<p>Tom Zsomborgi et son &eacute;quipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communaut&eacute;s WordPress</a> &agrave; travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aur&eacute;lien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel &agrave; candidature pour h&eacute;berger l&rsquo;&eacute;v&eacute;nement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau r&eacute;pertoire de th&egrave;mes et d&rsquo;extensions</h3>
<p>Les r&eacute;pertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">th&egrave;mes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont &eacute;t&eacute; refondus. (en)</p>
<h3>Et si on &eacute;crivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;id&eacute;e de Siobhan McKeown&hellip; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs &agrave; ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">&Eacute;milie indique les 8 erreurs</a> &agrave; ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t&rsquo;anime jour et nuit, depuis ton plus jeune &acirc;ge</em>&hellip; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&hellip; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Grégoire Noyelle : WordPress :: Masquer les sous-menus de votre back-office\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-09T07:01:16+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:763:\"<div>Dans ce tutoriel, nous verrons comment masquer des &eacute;l&eacute;ments de votre sous-menu, dans le back-office de WordPress. Masquer un &eacute;l&eacute;ment du menu D&rsquo;abord, je vais me concentrer sur la barre lat&eacute;rale de l&rsquo;administration WordPress. Les &eacute;l&eacute;ments de premier niveau ont souvent des classes ou des identifiants. J&rsquo;aurais donc pu me d&eacute;brouiller avec une feuille de ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 9 mars 2015 par <a href=\"http://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\">WordPress :: Masquer les sous-menus de votre back-office</a>.</p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"wabeo : Un délai pour mettre à jour automatiquement les plugins\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/JTcZ44oQJd0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/JTcZ44oQJd0/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-06T09:20:15+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Willy Bahuaud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:605:\"<div>
<p>Depuis la version 3.7 de WordPress nous avons la possibilit&eacute; de mettre &agrave; jour automatiquement WordPress et ses modules. Et si on attendait quelques jours avant d\'appliquer une mise &agrave; jour de mani&egrave;re automatique ? Voyons comment proc&eacute;der...</p>
<hr>
Voir <a rel=\"nofollow\" href=\"http://wabeo.fr/delai-mise-a-jour-plugins/\">Un d&eacute;lai pour mettre &agrave; jour automatiquement les plugins</a> directement sur <a rel=\"nofollow\" href=\"http://wabeo.fr/\">wabeo</a><img src=\"http://feeds.feedburner.com/~r/Wabeo/~4/JTcZ44oQJd0\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"BoiteAWeb : Happiness bar 2 : Du multisite en locale\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://boiteaweb.fr/happiness-bar-2-du-multisite-en-locale-8531.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:68:\"http://boiteaweb.fr/happiness-bar-2-du-multisite-en-locale-8531.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-05T21:55:36+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"<div>Samedi 24 janvier se d&eacute;roulait la seconde journ&eacute;e du WordCamp Paris 2015. Comme en 2014 et comme la veille, je tenais le Happiness Bar accompagn&eacute; de Alex Concha et d&rsquo;autres b&eacute;n&eacute;voles d&eacute;sireux d&rsquo;aider les visiteurs. J&rsquo;ai encore eu une question technique qui a &eacute;t&eacute; r&eacute;solue avec un seul hook. Lilou multisite &laquo;&nbsp;Dans un multisite, tous [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"BoiteAWeb : ++$boiteaweb; : Le site en version 5.0\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://boiteaweb.fr/version-5-8555.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:39:\"http://boiteaweb.fr/version-5-8555.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-04T21:38:50+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:403:\"<div>Pouf pouf hop comme &ccedil;a vite fait, une petite v5 du site. J&rsquo;attendais le th&egrave;me TwentyFifteen pour cette V5, je l&rsquo;ai test&eacute; et finalement, non. J&rsquo;ai alors cherch&eacute; un autre th&egrave;me gratuit, j&rsquo;ai trouv&eacute; que Eighties mettais bien en valeur les animaux en HD, alors j&rsquo;ai dis banco. Sur le fond rien ne change, toujours [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WordPress Channel : Supprimer le slug d’une taxonomie sous WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:56:\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-04T16:29:18+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:817:\"<div>
<p>Les custom taxonomies ou taxonomies personnalis&eacute;es offrent la possibilit&eacute; de cr&eacute;er des filtres suppl&eacute;mentaires afin de classer vos contenus aussi bien en back-office qu&rsquo;en front-office. Nativement, elles rajoutent un mot-cl&eacute; dans l&rsquo;URL qui rallongent inutilement les URLs et qui n&rsquo;a bien souvent que peu de sens pour les moteurs de recherche. Cette astuce vous explique&hellip;</p>
<p><a rel=\"nofollow\" href=\"http://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"http://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\">Supprimer le slug d&rsquo;une taxonomie sous WordPress</a></p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"wabeo : Les hooks des menus de navigation de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/GpkNl8fwI0k/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/GpkNl8fwI0k/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-02T10:59:42+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Willy Bahuaud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:454:\"<div>
<p>Suite au tutoriel pour customiser les menus avec les walkers, voici un article expliquant comment personnaliser les menus en utilisant les hooks de WordPress</p>
<hr>
Voir <a rel=\"nofollow\" href=\"http://wabeo.fr/hook-nav-menus/\">Les hooks des menus de navigation de WordPress</a> directement sur <a rel=\"nofollow\" href=\"http://wabeo.fr/\">wabeo</a><img src=\"http://feeds.feedburner.com/~r/Wabeo/~4/GpkNl8fwI0k\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WP Formation : Trouver gratuitement un maximum de vos backlinks !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:72:\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-02T08:00:17+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1365:\"<div>
<p><img width=\"300\" height=\"150\" src=\"http://wpformation.com/wp-content/uploads/2015/02/Majestic-SEO-300x150.jpg\" class=\"attachment-medium wp-post-image\" alt=\"Majestic-SEO\" style=\"float: right; margin:0 0 10px 10px;\">Dans un pr&eacute;c&eacute;dent article, j\'ai &eacute;voqu&eacute; l\'outil d\'analyse de liens pointant vers un site : SEO Cleaner. Vous vous &ecirc;tes sans doute pos&eacute; la question : comment obtenir la liste la plus compl&egrave;te de backlinks&nbsp;&agrave; moindre co&ucirc;t ? Pour ce faire, je vous pr&eacute;sente aujourd\'hui&nbsp;l\'outil Majestic SEO. Une r&eacute;f&eacute;rence dans le domaine ! &nbsp; Attention, [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\">Trouver gratuitement un maximum de vos backlinks !</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:26:\"wordpressfrancophoneplanet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Mon, 30 Mar 2015 08:19:32 GMT\";s:4:\"date\";s:29:\"Mon, 30 Mar 2015 08:26:54 GMT\";s:7:\"expires\";s:29:\"Mon, 30 Mar 2015 08:26:54 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:13:\"80:quic,p=0.5\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("114178","_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c","1429254793","no");
INSERT INTO `wp_options` VALUES("88458","_transient__bbp_117.169.1.227_last_posted","1427659783","yes");
INSERT INTO `wp_options` VALUES("88558","_transient__bbp_202.75.216.235_last_posted","1427240880","yes");
INSERT INTO `wp_options` VALUES("88565","_transient__bbp_183.221.147.105_last_posted","1426612124","yes");
INSERT INTO `wp_options` VALUES("88575","_transient__bbp_121.9.232.237_last_posted","1427203209","yes");
INSERT INTO `wp_options` VALUES("88603","_transient__bbp_183.222.154.64_last_posted","1426616441","yes");
INSERT INTO `wp_options` VALUES("88630","_transient__bbp_117.169.1.191_last_posted","1427683415","yes");
INSERT INTO `wp_options` VALUES("99258","_site_transient_timeout_browser_fb7e73d137e6cd6d4a2ec6775f80507c","1428319299","yes");
INSERT INTO `wp_options` VALUES("99259","_site_transient_browser_fb7e73d137e6cd6d4a2ec6775f80507c","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"36.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("88934","_transient__bbp_117.169.1.46_last_posted","1426653648","yes");
INSERT INTO `wp_options` VALUES("88965","_transient__bbp_203.100.80.81_last_posted","1426658127","yes");
INSERT INTO `wp_options` VALUES("89031","_transient__bbp_59.58.162.141_last_posted","1427005183","yes");
INSERT INTO `wp_options` VALUES("89032","_transient__bbp_31.207.64.110_last_posted","1426664720","yes");
INSERT INTO `wp_options` VALUES("88665","_transient__bbp_183.203.208.170_last_posted","1427324589","yes");
INSERT INTO `wp_options` VALUES("88683","_transient__bbp_103.249.101.129_last_posted","1426623518","yes");
INSERT INTO `wp_options` VALUES("88777","_transient__bbp_117.166.45.243_last_posted","1426633599","yes");
INSERT INTO `wp_options` VALUES("88784","_transient__bbp_134.60.39.36_last_posted","1426634219","yes");
INSERT INTO `wp_options` VALUES("88839","_transient__bbp_117.166.58.99_last_posted","1426645366","yes");
INSERT INTO `wp_options` VALUES("88874","_transient__bbp_211.141.130.186_last_posted","1427568260","yes");
INSERT INTO `wp_options` VALUES("88878","_transient__bbp_39.188.122.98_last_posted","1426645597","yes");
INSERT INTO `wp_options` VALUES("88915","_transient__bbp_117.166.229.79_last_posted","1426651778","yes");
INSERT INTO `wp_options` VALUES("89091","_transient__bbp_36.250.174.6_last_posted","1426670374","yes");
INSERT INTO `wp_options` VALUES("89152","_transient__bbp_121.9.232.202_last_posted","1426676357","yes");
INSERT INTO `wp_options` VALUES("89216","_transient__bbp_82.139.114.74_last_posted","1426682675","yes");
INSERT INTO `wp_options` VALUES("89284","_transient__bbp_183.222.157.47_last_posted","1426688842","yes");
INSERT INTO `wp_options` VALUES("89461","_transient__bbp_217.12.24.130_last_posted","1427022279","yes");
INSERT INTO `wp_options` VALUES("89514","_transient__bbp_2607:5300:100:200::1073_last_posted","1426710673","yes");
INSERT INTO `wp_options` VALUES("89524","_transient__bbp_82.199.193.209_last_posted","1426711417","yes");
INSERT INTO `wp_options` VALUES("89567","_transient__bbp_201.243.185.159_last_posted","1426715854","yes");
INSERT INTO `wp_options` VALUES("89598","_transient__bbp_101.30.202.71_last_posted","1426955976","yes");
INSERT INTO `wp_options` VALUES("89629","_transient__bbp_223.86.78.125_last_posted","1426722623","yes");
INSERT INTO `wp_options` VALUES("89666","_transient__bbp_121.9.232.201_last_posted","1426726946","yes");
INSERT INTO `wp_options` VALUES("89722","_transient__bbp_117.169.1.196_last_posted","1426732087","yes");
INSERT INTO `wp_options` VALUES("89810","_transient__bbp_112.19.11.96_last_posted","1426808973","yes");
INSERT INTO `wp_options` VALUES("89814","_transient__bbp_193.201.224.26_last_posted","1426747597","yes");
INSERT INTO `wp_options` VALUES("89868","_transient__bbp_178.248.24.26_last_posted","1427065718","yes");
INSERT INTO `wp_options` VALUES("89908","_transient__bbp_114.111.166.251_last_posted","1427125705","yes");
INSERT INTO `wp_options` VALUES("89912","_transient__bbp_117.169.1.219_last_posted","1426753681","yes");
INSERT INTO `wp_options` VALUES("89958","_transient__bbp_117.166.64.192_last_posted","1426759526","yes");
INSERT INTO `wp_options` VALUES("89992","_transient__bbp_117.173.23.193_last_posted","1426763491","yes");
INSERT INTO `wp_options` VALUES("90041","_transient__bbp_183.203.208.165_last_posted","1427203265","yes");
INSERT INTO `wp_options` VALUES("90045","_transient__bbp_111.1.91.137_last_posted","1427620290","yes");
INSERT INTO `wp_options` VALUES("90104","_transient__bbp_183.203.208.174_last_posted","1427060168","yes");
INSERT INTO `wp_options` VALUES("90183","_transient__bbp_117.175.99.223_last_posted","1426915196","yes");
INSERT INTO `wp_options` VALUES("90184","_transient__bbp_67.58.38.246_last_posted","1427265112","yes");
INSERT INTO `wp_options` VALUES("90212","_transient__bbp_210.101.131.227_last_posted","1427425414","yes");
INSERT INTO `wp_options` VALUES("90216","_transient__bbp_117.173.21.74_last_posted","1426788936","yes");
INSERT INTO `wp_options` VALUES("90284","_transient__bbp_121.9.232.193_last_posted","1427141538","yes");
INSERT INTO `wp_options` VALUES("90324","_transient__bbp_183.203.208.162_last_posted","1427138225","yes");
INSERT INTO `wp_options` VALUES("90643","_transient__bbp_94.183.153.191_last_posted","1426838494","yes");
INSERT INTO `wp_options` VALUES("90686","_transient__bbp_183.26.229.146_last_posted","1426843477","yes");
INSERT INTO `wp_options` VALUES("90702","_transient__bbp_183.221.220.217_last_posted","1426846933","yes");
INSERT INTO `wp_options` VALUES("90742","_transient__bbp_85.105.197.216_last_posted","1426850976","yes");
INSERT INTO `wp_options` VALUES("90768","_transient__bbp_202.154.179.58_last_posted","1427620444","yes");
INSERT INTO `wp_options` VALUES("90793","_transient__bbp_92.242.59.6_last_posted","1426855980","yes");
INSERT INTO `wp_options` VALUES("90818","_transient__bbp_101.4.136.66_last_posted","1427280333","yes");
INSERT INTO `wp_options` VALUES("90844","_transient__bbp_117.166.222.243_last_posted","1426861045","yes");
INSERT INTO `wp_options` VALUES("90854","_transient__bbp_223.82.137.37_last_posted","1426861731","yes");
INSERT INTO `wp_options` VALUES("91023","_transient__bbp_177.66.241.4_last_posted","1426881519","yes");
INSERT INTO `wp_options` VALUES("95261","_transient__bbp_121.9.232.169_last_posted","1427335372","yes");
INSERT INTO `wp_options` VALUES("90968","_transient__bbp_186.233.116.90_last_posted","1427384780","yes");
INSERT INTO `wp_options` VALUES("91099","_transient__bbp_223.86.64.28_last_posted","1426889496","yes");
INSERT INTO `wp_options` VALUES("91184","_transient__bbp_77.247.181.163_last_posted","1426899295","yes");
INSERT INTO `wp_options` VALUES("91197","_transient__bbp_117.173.21.136_last_posted","1426924685","yes");
INSERT INTO `wp_options` VALUES("91232","_transient__bbp_173.192.79.55_last_posted","1426911471","yes");
INSERT INTO `wp_options` VALUES("91254","_transient__bbp_187.95.34.3_last_posted","1426907209","yes");
INSERT INTO `wp_options` VALUES("91282","_transient__bbp_183.220.244.162_last_posted","1426910823","yes");
INSERT INTO `wp_options` VALUES("91310","_transient__bbp_107.6.12.37_last_posted","1427426349","yes");
INSERT INTO `wp_options` VALUES("91366","_transient__bbp_88.159.52.39_last_posted","1426919830","yes");
INSERT INTO `wp_options` VALUES("91385","_transient__bbp_97.88.124.52_last_posted","1426921850","yes");
INSERT INTO `wp_options` VALUES("91419","_transient__bbp_222.45.196.53_last_posted","1426926390","yes");
INSERT INTO `wp_options` VALUES("91448","_transient__bbp_61.154.127.136_last_posted","1427077227","yes");
INSERT INTO `wp_options` VALUES("91449","_transient__bbp_117.177.226.169_last_posted","1426930926","yes");
INSERT INTO `wp_options` VALUES("91507","_transient__bbp_114.34.42.94_last_posted","1426938188","yes");
INSERT INTO `wp_options` VALUES("91508","_transient__bbp_112.228.71.217_last_posted","1426938337","yes");
INSERT INTO `wp_options` VALUES("91524","_transient__bbp_210.57.208.14_last_posted","1426940045","yes");
INSERT INTO `wp_options` VALUES("91528","_transient__bbp_111.10.199.174_last_posted","1426940315","yes");
INSERT INTO `wp_options` VALUES("91587","_transient__bbp_117.177.147.142_last_posted","1426947149","yes");
INSERT INTO `wp_options` VALUES("91663","_transient__bbp_222.45.212.130_last_posted","1427294804","yes");
INSERT INTO `wp_options` VALUES("91715","_transient__bbp_5.135.158.101_last_posted","1426961252","yes");
INSERT INTO `wp_options` VALUES("91765","_transient__bbp_117.176.56.2_last_posted","1426967529","yes");
INSERT INTO `wp_options` VALUES("91868","_transient__bbp_183.203.208.168_last_posted","1427201847","yes");
INSERT INTO `wp_options` VALUES("91923","_transient__bbp_112.45.179.194_last_posted","1426987788","yes");
INSERT INTO `wp_options` VALUES("92000","_transient__bbp_117.177.103.145_last_posted","1426998117","yes");
INSERT INTO `wp_options` VALUES("92086","_transient__bbp_78.41.100.202_last_posted","1427009559","yes");
INSERT INTO `wp_options` VALUES("92105","_transient__bbp_117.175.110.170_last_posted","1427011738","yes");
INSERT INTO `wp_options` VALUES("92115","_transient__bbp_112.228.18.132_last_posted","1427013210","yes");
INSERT INTO `wp_options` VALUES("92152","_transient__bbp_121.9.232.166_last_posted","1427018058","yes");
INSERT INTO `wp_options` VALUES("92165","_transient__bbp_46.126.46.181_last_posted","1427197157","yes");
INSERT INTO `wp_options` VALUES("92172","_transient__bbp_91.121.113.76_last_posted","1427021304","yes");
INSERT INTO `wp_options` VALUES("92251","_transient__bbp_183.221.220.28_last_posted","1427031705","yes");
INSERT INTO `wp_options` VALUES("92310","_transient__bbp_185.14.28.27_last_posted","1427175022","yes");
INSERT INTO `wp_options` VALUES("92353","_transient__bbp_111.10.139.58_last_posted","1427044156","yes");
INSERT INTO `wp_options` VALUES("92412","_transient__bbp_183.203.208.169_last_posted","1427051204","yes");
INSERT INTO `wp_options` VALUES("92440","_transient__bbp_18.239.0.155_last_posted","1427054890","yes");
INSERT INTO `wp_options` VALUES("92531","_transient__bbp_85.226.63.243_last_posted","1427434654","yes");
INSERT INTO `wp_options` VALUES("92559","_transient__bbp_60.191.39.252_last_posted","1427069106","yes");
INSERT INTO `wp_options` VALUES("92596","_transient__bbp_121.9.232.194_last_posted","1427073316","yes");
INSERT INTO `wp_options` VALUES("92609","_transient__bbp_222.68.250.2_last_posted","1427074517","yes");
INSERT INTO `wp_options` VALUES("92668","_transient__bbp_117.169.1.216_last_posted","1427081452","yes");
INSERT INTO `wp_options` VALUES("92778","_transient__bbp_195.4.128.175_last_posted","1427180237","yes");
INSERT INTO `wp_options` VALUES("92785","_transient__bbp_117.176.55.84_last_posted","1427095061","yes");
INSERT INTO `wp_options` VALUES("92807","_transient__bbp_112.228.40.26_last_posted","1427097734","yes");
INSERT INTO `wp_options` VALUES("92853","_transient__bbp_114.111.167.208_last_posted","1427102569","yes");
INSERT INTO `wp_options` VALUES("92869","_transient__bbp_147.83.143.44_last_posted","1427103889","yes");
INSERT INTO `wp_options` VALUES("93006","_transient__bbp_159.255.169.4_last_posted","1427196465","yes");
INSERT INTO `wp_options` VALUES("93052","_transient__bbp_134.249.53.36_last_posted","1427715011","yes");
INSERT INTO `wp_options` VALUES("93053","_transient__bbp_46.118.123.80_last_posted","1427715158","yes");
INSERT INTO `wp_options` VALUES("93176","_transient__bbp_218.207.54.112_last_posted","1427136394","yes");
INSERT INTO `wp_options` VALUES("93252","_transient__bbp_183.223.208.98_last_posted","1427143726","yes");
INSERT INTO `wp_options` VALUES("93331","_transient__bbp_87.98.250.222_last_posted","1427151409","yes");
INSERT INTO `wp_options` VALUES("93362","_transient__bbp_80.149.233.237_last_posted","1427154172","yes");
INSERT INTO `wp_options` VALUES("93372","_transient__bbp_193.109.166.219_last_posted","1427155128","yes");
INSERT INTO `wp_options` VALUES("93455","_transient__bbp_117.173.20.141_last_posted","1427162787","yes");
INSERT INTO `wp_options` VALUES("93471","_transient__bbp_94.180.36.205_last_posted","1427163910","yes");
INSERT INTO `wp_options` VALUES("93526","_transient__bbp_183.61.240.126_last_posted","1427376048","yes");
INSERT INTO `wp_options` VALUES("93569","_transient__bbp_78.152.116.238_last_posted","1427173484","yes");
INSERT INTO `wp_options` VALUES("93719","_transient__bbp_93.120.205.110_last_posted","1427214235","yes");
INSERT INTO `wp_options` VALUES("93729","_transient__bbp_223.86.208.18_last_posted","1427188706","yes");
INSERT INTO `wp_options` VALUES("93821","_transient__bbp_112.228.25.167_last_posted","1427240782","yes");
INSERT INTO `wp_options` VALUES("93834","_transient__bbp_222.45.85.210_last_posted","1427562231","yes");
INSERT INTO `wp_options` VALUES("93911","_transient__bbp_23.96.16.159_last_posted","1427205941","yes");
INSERT INTO `wp_options` VALUES("93930","_transient__bbp_85.25.103.119_last_posted","1427207637","yes");
INSERT INTO `wp_options` VALUES("94241","_transient__bbp_197.231.221.211_last_posted","1427237078","yes");
INSERT INTO `wp_options` VALUES("94507","_transient__bbp_112.19.125.247_last_posted","1427263052","yes");
INSERT INTO `wp_options` VALUES("94517","_transient__bbp_117.173.238.196_last_posted","1427263677","yes");
INSERT INTO `wp_options` VALUES("94562","_transient__bbp_221.130.124.91_last_posted","1427267785","yes");
INSERT INTO `wp_options` VALUES("94681","_transient__bbp_89.169.0.122_last_posted","1427279318","yes");
INSERT INTO `wp_options` VALUES("94760","_transient__bbp_120.15.33.201_last_posted","1427287133","yes");
INSERT INTO `wp_options` VALUES("94761","_transient__bbp_121.9.232.197_last_posted","1427287305","yes");
INSERT INTO `wp_options` VALUES("94865","_transient__bbp_112.19.9.18_last_posted","1427297045","yes");
INSERT INTO `wp_options` VALUES("94944","_transient__bbp_213.1.221.206_last_posted","1427304979","yes");
INSERT INTO `wp_options` VALUES("94951","_transient__bbp_37.57.231.112_last_posted","1427305467","yes");
INSERT INTO `wp_options` VALUES("95124","_transient__bbp_178.252.87.75_last_posted","1427322390","yes");
INSERT INTO `wp_options` VALUES("95200","_transient__bbp_36.248.170.217_last_posted","1427329767","yes");
INSERT INTO `wp_options` VALUES("95256","_transient__bbp_117.177.240.32_last_posted","1427334841","yes");
INSERT INTO `wp_options` VALUES("95294","_transient__bbp_183.221.191.97_last_posted","1427338652","yes");
INSERT INTO `wp_options` VALUES("95415","_transient__bbp_117.166.1.71_last_posted","1427350414","yes");
INSERT INTO `wp_options` VALUES("95422","_transient__bbp_200.220.195.42_last_posted","1427351054","yes");
INSERT INTO `wp_options` VALUES("95472","_transient__bbp_74.208.7.207_last_posted","1427355215","yes");
INSERT INTO `wp_options` VALUES("95479","_transient__bbp_84.107.88.151_last_posted","1427355798","yes");
INSERT INTO `wp_options` VALUES("95561","_transient__bbp_200.24.220.253_last_posted","1427364030","yes");
INSERT INTO `wp_options` VALUES("95619","_transient__bbp_195.154.188.41_last_posted","1427592327","yes");
INSERT INTO `wp_options` VALUES("95641","_transient__bbp_54.69.43.14_last_posted","1427371726","yes");
INSERT INTO `wp_options` VALUES("95645","_transient__bbp_183.220.71.40_last_posted","1427372039","yes");
INSERT INTO `wp_options` VALUES("95685","_transient__bbp_80.112.136.116_last_posted","1427376134","yes");
INSERT INTO `wp_options` VALUES("95738","_transient__bbp_183.222.156.66_last_posted","1427380878","yes");
INSERT INTO `wp_options` VALUES("95745","_transient__bbp_109.184.213.149_last_posted","1427381298","yes");
INSERT INTO `wp_options` VALUES("95852","_transient__bbp_182.92.240.197_last_posted","1427391872","yes");
INSERT INTO `wp_options` VALUES("96002","_transient__bbp_117.169.1.64_last_posted","1427406285","yes");
INSERT INTO `wp_options` VALUES("96027","_transient__bbp_117.173.238.89_last_posted","1427408597","yes");
INSERT INTO `wp_options` VALUES("96080","_transient__bbp_117.169.1.47_last_posted","1427413733","yes");
INSERT INTO `wp_options` VALUES("96044","_transient__bbp_117.169.1.11_last_posted","1427410371","yes");
INSERT INTO `wp_options` VALUES("96102","_transient__bbp_117.169.1.144_last_posted","1427416016","yes");
INSERT INTO `wp_options` VALUES("96161","_transient__bbp_88.159.216.98_last_posted","1427421207","yes");
INSERT INTO `wp_options` VALUES("96162","_transient__bbp_167.160.116.88_last_posted","1427421458","yes");
INSERT INTO `wp_options` VALUES("96187","_transient__bbp_117.174.192.238_last_posted","1427423640","yes");
INSERT INTO `wp_options` VALUES("96188","_transient__bbp_117.166.236.247_last_posted","1427423650","yes");
INSERT INTO `wp_options` VALUES("96316","_transient__bbp_111.10.144.188_last_posted","1427436250","yes");
INSERT INTO `wp_options` VALUES("96350","_transient__bbp_46.151.53.31_last_posted","1427487029","yes");
INSERT INTO `wp_options` VALUES("96266","_transient__bbp_211.141.130.105_last_posted","1427461820","yes");
INSERT INTO `wp_options` VALUES("96402","_transient__bbp_117.169.1.109_last_posted","1427444235","yes");
INSERT INTO `wp_options` VALUES("96427","_transient__bbp_49.212.220.47_last_posted","1427509184","yes");
INSERT INTO `wp_options` VALUES("96437","_transient__bbp_112.44.88.103_last_posted","1427447448","yes");
INSERT INTO `wp_options` VALUES("96537","_transient__bbp_117.169.1.236_last_posted","1427695487","yes");
INSERT INTO `wp_options` VALUES("96553","_transient__bbp_59.144.8.141_last_posted","1427458910","yes");
INSERT INTO `wp_options` VALUES("96581","_transient__bbp_117.169.1.190_last_posted","1427461421","yes");
INSERT INTO `wp_options` VALUES("96622","_transient__bbp_117.169.1.108_last_posted","1427465267","yes");
INSERT INTO `wp_options` VALUES("96641","_transient__bbp_223.86.120.197_last_posted","1427466944","yes");
INSERT INTO `wp_options` VALUES("96657","_transient__bbp_58.23.19.164_last_posted","1427468351","yes");
INSERT INTO `wp_options` VALUES("96670","_transient__bbp_80.93.24.144_last_posted","1427469674","yes");
INSERT INTO `wp_options` VALUES("96743","_transient__bbp_117.135.250.69_last_posted","1427476858","yes");
INSERT INTO `wp_options` VALUES("96747","_transient__bbp_211.157.180.56_last_posted","1427672545","yes");
INSERT INTO `wp_options` VALUES("96824","_transient__bbp_117.166.4.250_last_posted","1427484288","yes");
INSERT INTO `wp_options` VALUES("96884","_transient__bbp_183.221.162.63_last_posted","1427489980","yes");
INSERT INTO `wp_options` VALUES("96972","_transient__bbp_211.142.197.91_last_posted","1427499027","yes");
INSERT INTO `wp_options` VALUES("97006","_transient__bbp_117.176.244.103_last_posted","1427502336","yes");
INSERT INTO `wp_options` VALUES("97043","_transient__bbp_117.169.1.97_last_posted","1427505865","yes");
INSERT INTO `wp_options` VALUES("97096","_transient__bbp_46.151.53.37_last_posted","1427529687","yes");
INSERT INTO `wp_options` VALUES("97121","_transient__bbp_117.132.14.219_last_posted","1427689554","yes");
INSERT INTO `wp_options` VALUES("97122","_transient__bbp_183.203.208.197_last_posted","1427587392","yes");
INSERT INTO `wp_options` VALUES("97332","_transient__bbp_190.166.56.211_last_posted","1427533478","yes");
INSERT INTO `wp_options` VALUES("97345","_transient__bbp_77.174.132.47_last_posted","1427534577","yes");
INSERT INTO `wp_options` VALUES("97412","_transient__bbp_211.23.248.21_last_posted","1427708545","yes");
INSERT INTO `wp_options` VALUES("97449","_transient__bbp_196.201.218.203_last_posted","1427600160","yes");
INSERT INTO `wp_options` VALUES("97481","_transient__bbp_125.161.83.96_last_posted","1427548442","yes");
INSERT INTO `wp_options` VALUES("97558","_transient__bbp_122.94.164.62_last_posted","1427555646","yes");
INSERT INTO `wp_options` VALUES("97619","_transient__bbp_117.169.1.158_last_posted","1427561630","yes");
INSERT INTO `wp_options` VALUES("97626","_transient__bbp_112.12.151.136_last_posted","1427562309","yes");
INSERT INTO `wp_options` VALUES("97663","_transient__bbp_117.169.1.111_last_posted","1427565981","yes");
INSERT INTO `wp_options` VALUES("97690","_transient__bbp_46.151.53.46_last_posted","1427568096","yes");
INSERT INTO `wp_options` VALUES("97766","_transient__bbp_39.188.84.150_last_posted","1427575487","yes");
INSERT INTO `wp_options` VALUES("97827","_transient__bbp_5.79.68.161_last_posted","1427581523","yes");
INSERT INTO `wp_options` VALUES("97864","_transient__bbp_213.114.232.2_last_posted","1427584966","yes");
INSERT INTO `wp_options` VALUES("97892","_transient__bbp_117.169.1.99_last_posted","1427587565","yes");
INSERT INTO `wp_options` VALUES("97961","_transient__bbp_117.166.74.211_last_posted","1427593965","yes");
INSERT INTO `wp_options` VALUES("98001","_transient__bbp_211.141.130.114_last_posted","1427597662","yes");
INSERT INTO `wp_options` VALUES("98165","_transient__bbp_160.228.152.4_last_posted","1427613544","yes");
INSERT INTO `wp_options` VALUES("98193","_transient__bbp_117.21.192.134_last_posted","1427616205","yes");
INSERT INTO `wp_options` VALUES("98260","_transient__bbp_183.203.208.178_last_posted","1427622780","yes");
INSERT INTO `wp_options` VALUES("98300","_transient__bbp_117.169.1.104_last_posted","1427626864","yes");
INSERT INTO `wp_options` VALUES("98301","_transient__bbp_114.111.167.209_last_posted","1427626889","yes");
INSERT INTO `wp_options` VALUES("98368","_transient__bbp_111.206.1.198_last_posted","1427633492","yes");
INSERT INTO `wp_options` VALUES("98407","_transient__bbp_195.154.189.155_last_posted","1427712726","yes");
INSERT INTO `wp_options` VALUES("98473","_transient__bbp_211.141.130.108_last_posted","1427642859","yes");
INSERT INTO `wp_options` VALUES("98520","_transient__bbp_123.233.147.86_last_posted","1427702025","yes");
INSERT INTO `wp_options` VALUES("98554","_transient__bbp_195.154.188.74_last_posted","1427650437","yes");
INSERT INTO `wp_options` VALUES("98599","_transient__bbp_114.32.254.106_last_posted","1427654231","yes");
INSERT INTO `wp_options` VALUES("98612","_transient__bbp_204.152.202.195_last_posted","1427655290","yes");
INSERT INTO `wp_options` VALUES("98658","_transient__bbp_117.169.1.14_last_posted","1427659872","yes");
INSERT INTO `wp_options` VALUES("98668","_transient__bbp_120.203.149.110_last_posted","1427660630","yes");
INSERT INTO `wp_options` VALUES("98675","_transient__bbp_210.133.103.162_last_posted","1427661357","yes");
INSERT INTO `wp_options` VALUES("98727","_transient__bbp_195.154.211.220_last_posted","1427666336","yes");
INSERT INTO `wp_options` VALUES("98788","_transient__bbp_207.91.10.234_last_posted","1427672567","yes");
INSERT INTO `wp_options` VALUES("98966","_transient__bbp_116.77.128.68_last_posted","1427689423","yes");
INSERT INTO `wp_options` VALUES("99027","_transient__bbp_117.169.1.30_last_posted","1427695566","yes");
INSERT INTO `wp_options` VALUES("99031","_transient__bbp_37.9.184.190_last_posted","1427695703","yes");
INSERT INTO `wp_options` VALUES("99038","_transient__bbp_202.195.161.28_last_posted","1427696348","yes");
INSERT INTO `wp_options` VALUES("99104","_transient__bbp_183.224.99.148_last_posted","1427702408","yes");
INSERT INTO `wp_options` VALUES("114179","_transient_feed_66a70e9599b658d5cc038e8074597e7c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 07:37:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6495:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2942:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3556:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3536:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3786:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8950:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4797:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5341:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"L’Hebdo WordPress n°249 : Bonne Année 2015 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/20scgnJiK4c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 06:44:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7343\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Bonne année 2015 ! Toute l&#8217;équipe de l&#8217;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets. Notre communauté va arroser ses 10 ans d&#8217;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&#8217;est en bonne voie, on croise les [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4689:\"<h2>Bonne année 2015 !</h2>
<p>Toute l&rsquo;équipe de l&rsquo;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets.</p>
<p>Notre communauté va arroser ses 10 ans d&rsquo;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&rsquo;est en bonne voie, on croise les doigts). Le premier événement de l&rsquo;année est bien sur le <a href=\"http://2015.paris.wordcamp.org/\">WordCamp Paris 2015</a> , les 23 et 24 janvier prochains. Suivrons, j&rsquo;espère, plein d&rsquo;autres belles surprises. Restez connectés !</p>
<p>&nbsp;</p>
<h2>Place à l&rsquo;Hebdo !</h2>
<h3>WPMX Session #8</h3>
<p>WPMX, l&rsquo;association WordPress du Sud Ouest, présente sa <a href=\"http://wpchannel.com/meetup-wpmx-8-wordpress-securite/\">8e session consacrée à la sécurité</a> le 15 janvier 2015 en présence de Julio Potier.</p>
<h3>Brute Protect</h3>
<p><a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">Brute Protect s&rsquo;explique (en)</a> suite à son rachat par <a href=\"http://ma.tt/2015/01/jetpack-speed/\">Automattic (en)</a>.</p>
<h3>Les choses à faire après l&rsquo;installation de WordPress</h3>
<p>Dès lors que votre site WordPress est installé, <a href=\"http://www.labnol.org/internet/wordpress-optimization-guide/3931/\">pensez à ces quelques étapes</a> ! (en)</p>
<h3>Un peu d&rsquo;histoire</h3>
<p>WordPress a passé la dizaine, faire un peu d&rsquo;<a href=\"http://wptavern.com/historic-wordpress-project-seeks-contributors\">histoire peut être intéressant</a> (en).</p>
<h3>Post format, inconnu et déjà mort ?</h3>
<p><a href=\"http://www.poststat.us/post-formats-looking-back/\">Petite discussion autour des Post Format</a> qui sont sous exploités (en).</p>
<h3>WordPress en 2015</h3>
<p>Noel Tock nous livre sa vision de <a href=\"https://medium.com/@noeltock/wordpress-in-2015-ed6a4674a608\">WordPress en 2015</a> (en).</p>
<h3>6 extensions indispensables</h3>
<p><a href=\"http://www.tanguy-nicolas.com/extensions-indispensables-blog-wordpress/\">Les 6 extensions indispensables</a> selon Tanguy Nicolas.</p>
<h3>L&rsquo;année de WP Marmite</h3>
<p><a href=\"http://wpmarmite.com/recapitulatif-2014-plans-2015/\">WP Marmite est apparu en 2014</a>, voici une rétrospective et les projets à venir.</p>
<h3>Tout savoir le nouveau mode d&rsquo;écriture sans distraction</h3>
<p>Voici tout ce que vous devriez savoir sur <a href=\"http://premium.wpmudev.org/blog/distraction-free-mode-wordpress/\">le nouveau mode d&rsquo;écriture sans distraction</a> (en).</p>
<h3>Le livre WordPress de Christophe Aubry</h3>
<p>WPChannel présente le livre de <a href=\"http://wpchannel.com/wordpress-gerer-site-multi-utilisateur-christophe-aubry/\">Christophe Aubry sur WordPress</a>.</p>
<h3>Les résolutions 2015 de Julio</h3>
<p>Julio prends de bonne résultions 2015 pour WordPress et <a href=\"http://boiteaweb.fr/resolutions-wordpress-2015-dans-vos-developpements-8487.html\">vous les partage</a>.</p>
<h3>Le thème 2015 par Rodrigue</h3>
<p>Rodrigue propose une <a href=\"http://www.cree1site.com/review-du-theme-wordpress-twenty-fifteen/\">revue du thème par défaut &laquo;&nbsp;Twenty Fifteen&nbsp;&raquo;</a>.</p>
<h3>Les commentaires et leurs interactions</h3>
<p>WP Formation fait le tour des <a href=\"http://wpformation.com/commentaires-wordpress-interaction/\">bonnes pratiques en terme de commentaires</a>.</p>
<h3>Genesis : créer son accueil</h3>
<p>Grégoire présente la façon de <a href=\"http://www.gregoirenoyelle.com/genesis-comprendre-creer-page-accueil-wordpress-sur-mesure/\">créer une page d&rsquo;accueil avec Genesis</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/20scgnJiK4c\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:48:\"http://feeds.feedburner.com/WordpressFrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:9:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Thu, 16 Apr 2015 19:04:26 GMT\";s:4:\"date\";s:29:\"Thu, 16 Apr 2015 19:13:12 GMT\";s:7:\"expires\";s:29:\"Thu, 16 Apr 2015 19:13:12 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:13:\"80:quic,p=0.5\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("114185","_transient_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1429211594","no");
INSERT INTO `wp_options` VALUES("114188","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1429254795","no");
INSERT INTO `wp_options` VALUES("114189","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1429211595","no");
INSERT INTO `wp_options` VALUES("108747","_site_transient_timeout_browser_d731389443c1dc79df25aeea8fbd3f27","1429275611","yes");
INSERT INTO `wp_options` VALUES("108748","_site_transient_browser_d731389443c1dc79df25aeea8fbd3f27","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"8.0.3\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("115031","_site_transient_timeout_itsec_upload_dir","1429365953","yes");
INSERT INTO `wp_options` VALUES("115032","_site_transient_itsec_upload_dir","a:6:{s:4:\"path\";s:49:\"/home/pigiste/48heures/wp-content/uploads/2015/04\";s:3:\"url\";s:49:\"http://48h.pigiste.org/wp-content/uploads/2015/04\";s:6:\"subdir\";s:8:\"/2015/04\";s:7:\"basedir\";s:41:\"/home/pigiste/48heures/wp-content/uploads\";s:7:\"baseurl\";s:41:\"http://48h.pigiste.org/wp-content/uploads\";s:5:\"error\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113910","itsec_ipcheck","a:4:{s:17:\"optin-brute-force\";s:1:\"1\";s:7:\"api_ban\";b:1;s:7:\"api_key\";s:32:\"F3VcyPwndUeR62i6lj6dEi54gny7K94o\";s:5:\"api_s\";s:128:\"uAZ92bmH9Q2Buj5l4z5eYSy3d4dvh1x2D502q7Z6k0kWfdFz3BGBXf0408M5QKcRWaJi7o0jqe77FL8h57rnRCeLzp0z24f5cWSq4T2MKmX3wr8Y1W40mCi4vhe9MJ0K\";}","yes");
INSERT INTO `wp_options` VALUES("113911","itsec_four_oh_four","a:5:{s:7:\"enabled\";b:1;s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}}","yes");
INSERT INTO `wp_options` VALUES("113912","itsec_away_mode","a:4:{s:7:\"enabled\";b:1;s:4:\"type\";i:1;s:5:\"start\";i:1429230600;s:3:\"end\";i:1429336800;}","yes");
INSERT INTO `wp_options` VALUES("113913","itsec_ban_users","a:4:{s:7:\"default\";b:1;s:7:\"enabled\";b:1;s:9:\"host_list\";a:0:{}s:10:\"agent_list\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("113915","itsec_brute_force","a:5:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113916","itsec_backup","a:9:{s:9:\"all_sites\";b:1;s:6:\"method\";i:0;s:8:\"location\";s:66:\"/home/pigiste/48heures/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:20;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1429193724;}","yes");
INSERT INTO `wp_options` VALUES("113917","itsec_file_change","a:9:{s:6:\"method\";b:1;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:7:\"enabled\";b:0;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";i:1429116552;}","yes");
INSERT INTO `wp_options` VALUES("113918","itsec_hide_backend","a:7:{s:7:\"enabled\";b:1;s:4:\"slug\";s:5:\"porte\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:12:\"show-tooltip\";b:0;s:8:\"register\";s:15:\"wp-register.php\";}","yes");
INSERT INTO `wp_options` VALUES("113919","itsec_malware","a:2:{s:7:\"enabled\";b:1;s:7:\"api_key\";s:64:\"41989a8a898c77c889af9274298782a51133e7532f6075a5ddcf630bb245f642\";}","yes");
INSERT INTO `wp_options` VALUES("113920","itsec_ssl","a:3:{s:8:\"frontend\";i:0;s:5:\"login\";b:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113922","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:11:\"contributor\";}","yes");
INSERT INTO `wp_options` VALUES("113923","itsec_tweaks","a:22:{s:13:\"protect_files\";b:1;s:18:\"directory_browsing\";b:1;s:15:\"request_methods\";b:1;s:24:\"suspicious_query_strings\";b:1;s:17:\"write_permissions\";b:1;s:11:\"uploads_php\";b:1;s:13:\"generator_tag\";b:1;s:18:\"wlwmanifest_header\";b:1;s:14:\"edituri_header\";b:1;s:12:\"comment_spam\";b:1;s:14:\"random_version\";b:1;s:14:\"disable_xmlrpc\";i:2;s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:22:\"non_english_characters\";b:0;s:16:\"long_url_strings\";b:0;s:13:\"theme_updates\";b:0;s:14:\"plugin_updates\";b:0;s:12:\"core_updates\";b:0;s:11:\"file_editor\";b:0;s:11:\"safe_jquery\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113937","itsec_message_queue","a:2:{s:9:\"last_sent\";i:1429279763;s:8:\"messages\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("114036","_site_transient_timeout_itsec_random_version","1429285247","yes");
INSERT INTO `wp_options` VALUES("114014","itsec_jquery_version","1.11.1","yes");
INSERT INTO `wp_options` VALUES("114037","_site_transient_itsec_random_version","280","yes");
INSERT INTO `wp_options` VALUES("114047","itsec_salts","1429199122","yes");
INSERT INTO `wp_options` VALUES("114985","duplicator_settings","a:10:{s:7:\"version\";s:6:\"0.5.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114986","duplicator_version_plugin","0.5.16","yes");
INSERT INTO `wp_options` VALUES("114287","updraft_email","","yes");
INSERT INTO `wp_options` VALUES("114288","updraft_report_warningsonly","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114289","updraft_report_wholebackup","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114290","updraft_autobackup_default","0","yes");
INSERT INTO `wp_options` VALUES("114291","updraft_delete_local","1","yes");
INSERT INTO `wp_options` VALUES("114292","updraft_debug_mode","0","yes");
INSERT INTO `wp_options` VALUES("114293","updraft_extradbs","","yes");
INSERT INTO `wp_options` VALUES("114294","updraft_backupdb_nonwp","0","yes");
INSERT INTO `wp_options` VALUES("114295","updraft_include_plugins","1","yes");
INSERT INTO `wp_options` VALUES("114296","updraft_include_themes","1","yes");
INSERT INTO `wp_options` VALUES("114297","updraft_include_uploads","1","yes");
INSERT INTO `wp_options` VALUES("114298","updraft_include_others","1","yes");
INSERT INTO `wp_options` VALUES("114299","updraft_include_wpcore","0","yes");
INSERT INTO `wp_options` VALUES("114300","updraft_include_wpcore_exclude","","yes");
INSERT INTO `wp_options` VALUES("114301","updraft_include_more","0","yes");
INSERT INTO `wp_options` VALUES("114302","updraft_include_more_path","","yes");
INSERT INTO `wp_options` VALUES("114303","updraft_include_uploads_exclude","backup*,*backups,backwpup*,wp-clone","yes");
INSERT INTO `wp_options` VALUES("114304","updraft_include_others_exclude","upgrade,cache,updraft,backup*,*backups","yes");
INSERT INTO `wp_options` VALUES("114305","updraft_starttime_files","13:20","yes");
INSERT INTO `wp_options` VALUES("114306","updraft_starttime_db","13:20","yes");
INSERT INTO `wp_options` VALUES("114307","updraft_startday_files","0","yes");
INSERT INTO `wp_options` VALUES("114308","updraft_startday_db","0","yes");
INSERT INTO `wp_options` VALUES("114322","updraft_backup_history","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114314","updraft_lastmessage","Remote archives deleted: 0 (avr 17 14:19:29)","yes");
INSERT INTO `wp_options` VALUES("114315","updraftplus_unlocked_fd","1","yes");
INSERT INTO `wp_options` VALUES("114316","updraftplus_last_lock_time_fd","2015-04-17 13:15:17","yes");
INSERT INTO `wp_options` VALUES("114317","updraftplus_semaphore_fd","0","yes");
INSERT INTO `wp_options` VALUES("114344","mailusers_copy_sender","false","yes");
INSERT INTO `wp_options` VALUES("114345","mailusers_add_x_mailer_header","false","yes");
INSERT INTO `wp_options` VALUES("114346","mailusers_omit_display_names","false","yes");
INSERT INTO `wp_options` VALUES("114347","mailusers_footer","<h5 style=\"border-top: 1px solid #eee;\">Powered by <a href=\"http://wordpress.org/plugins/email-users/\">Email Users</a>.</h5>","yes");
INSERT INTO `wp_options` VALUES("114348","mailusers_debug","false","yes");
INSERT INTO `wp_options` VALUES("114349","mailusers_base64_encode","false","yes");
INSERT INTO `wp_options` VALUES("114350","mailusers_dashboard_widgets","true","yes");
INSERT INTO `wp_options` VALUES("114342","mailusers_shortcode_processing","false","yes");
INSERT INTO `wp_options` VALUES("114343","mailusers_from_sender_exclude","true","yes");
INSERT INTO `wp_options` VALUES("114321","updraftplus_semaphore_","0","yes");
INSERT INTO `wp_options` VALUES("114341","mailusers_no_role_filter","false","yes");
INSERT INTO `wp_options` VALUES("114319","updraftplus_unlocked_","1","yes");
INSERT INTO `wp_options` VALUES("114320","updraftplus_last_lock_time_","2015-04-16 20:58:50","yes");
INSERT INTO `wp_options` VALUES("114331","mailusers_default_mail_format","html","yes");
INSERT INTO `wp_options` VALUES("114332","mailusers_default_sort_users_by","none","yes");
INSERT INTO `wp_options` VALUES("114333","mailusers_max_bcc_recipients","0","yes");
INSERT INTO `wp_options` VALUES("114334","mailusers_from_sender_name_override","","yes");
INSERT INTO `wp_options` VALUES("114335","mailusers_from_sender_address_override","","yes");
INSERT INTO `wp_options` VALUES("114336","mailusers_send_bounces_to_address_override","","yes");
INSERT INTO `wp_options` VALUES("114337","mailusers_user_settings_table_rows","20","yes");
INSERT INTO `wp_options` VALUES("114338","mailusers_default_notifications","true","yes");
INSERT INTO `wp_options` VALUES("114339","mailusers_default_mass_email","true","yes");
INSERT INTO `wp_options` VALUES("114340","mailusers_default_user_control","true","yes");
INSERT INTO `wp_options` VALUES("114323","updraft_last_backup","a:5:{s:11:\"backup_time\";i:1429276517;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-plugins.zip\";}s:12:\"plugins-size\";i:15076515;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-uploads.zip\";}s:12:\"uploads-size\";i:174946225;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-db.gz\";s:7:\"db-size\";i:2826836;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"89c9709b239707ff2ba8ada1eb6b6db2453c3d91\";s:7:\"themes0\";s:40:\"c79130bde557e35e5ec828184efd24f96e1655ad\";s:8:\"uploads0\";s:40:\"214fc5db2f078af39fec19cd638da727aa8194df\";s:7:\"others0\";s:40:\"89694a6a854f356db15719a4057355b11dab6900\";s:3:\"db0\";s:40:\"b56295004df74ecb16d93ac77fb5547a13ac8fe4\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"b7f423e5e98a\";}","yes");
INSERT INTO `wp_options` VALUES("115037","_site_transient_timeout_itsec_notification_running","1429283364","yes");
INSERT INTO `wp_options` VALUES("115038","_site_transient_itsec_notification_running","1","yes");
INSERT INTO `wp_options` VALUES("114330","mailusers_default_body","<p>Bonjour, </p><p>J\'aimerais attirer votre attention sur un nouvel article publi&eacute; sur le blog (voir infos ci-dessous). J\'esp&egrave;re que vous le trouverez int&eacute;ressant.</p><p>Cordialement,</p><p>%FROM_NAME%</p><hr><p><strong>%POST_TITLE%</strong></p><p>%POST_EXCERPT%</p><ul><li>Lien vers l\'article : <a href=\"%POST_URL%\">%POST_URL%</a></li><li>Lien vers %BLOG_NAME%: <a href=\"%BLOG_URL%\">%BLOG_URL%</a></li></ul>","yes");
INSERT INTO `wp_options` VALUES("114329","mailusers_default_subject","[%BLOG_NAME%] A post of interest: \"%POST_TITLE%\"","yes");
INSERT INTO `wp_options` VALUES("114397","polylang","a:12:{s:7:\"browser\";i:1;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:0;s:10:\"force_lang\";i:0;s:13:\"redirect_lang\";i:0;s:13:\"media_support\";i:1;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"1.7.3\";s:12:\"default_lang\";s:2:\"fr\";}","yes");
INSERT INTO `wp_options` VALUES("114328","mailusers_version","4.7.1","yes");
INSERT INTO `wp_options` VALUES("114987","duplicator_ui_view_state","a:4:{s:14:\"dup-wpnotice01\";b:1;s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:27:\"dup-settings-diag-srv-panel\";s:1:\"0\";s:28:\"dup-settings-diag-opts-panel\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("114988","duplicator_package_active","O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150417_les48hdelapige_55310965234f97154150417132349_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:22:\"/home/pigiste/48heures\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:30;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}","yes");
INSERT INTO `wp_options` VALUES("114984","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429278244;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.1.zip\";}s:19:\"bbpress/bbpress.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11780\";s:4:\"slug\";s:7:\"bbpress\";s:6:\"plugin\";s:19:\"bbpress/bbpress.php\";s:11:\"new_version\";s:5:\"2.5.6\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/bbpress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.16\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.16.zip\";}s:27:\"email-users/email-users.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"580\";s:4:\"slug\";s:11:\"email-users\";s:6:\"plugin\";s:27:\"email-users/email-users.php\";s:11:\"new_version\";s:5:\"4.7.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/email-users/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/email-users.4.7.1.zip\";}s:41:\"google-maps-widget/google-maps-widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33487\";s:4:\"slug\";s:18:\"google-maps-widget\";s:6:\"plugin\";s:41:\"google-maps-widget/google-maps-widget.php\";s:11:\"new_version\";s:4:\"2.30\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/google-maps-widget/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/google-maps-widget.2.30.zip\";}s:41:\"better-wp-security/better-wp-security.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"18308\";s:4:\"slug\";s:18:\"better-wp-security\";s:6:\"plugin\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"new_version\";s:6:\"4.6.13\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/better-wp-security/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/better-wp-security.4.6.13.zip\";}s:21:\"newsletter/plugin.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8171\";s:4:\"slug\";s:10:\"newsletter\";s:6:\"plugin\";s:21:\"newsletter/plugin.php\";s:11:\"new_version\";s:5:\"3.7.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/newsletter/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/plugin/newsletter.zip\";}s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41825\";s:4:\"slug\";s:28:\"oauth-twitter-sidebar-widget\";s:6:\"plugin\";s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/oauth-twitter-sidebar-widget/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/oauth-twitter-sidebar-widget.zip\";}s:21:\"polylang/polylang.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25780\";s:4:\"slug\";s:8:\"polylang\";s:6:\"plugin\";s:21:\"polylang/polylang.php\";s:11:\"new_version\";s:5:\"1.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/polylang/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/polylang.1.7.3.zip\";}s:27:\"updraftplus/updraftplus.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"31679\";s:4:\"slug\";s:11:\"updraftplus\";s:6:\"plugin\";s:27:\"updraftplus/updraftplus.php\";s:11:\"new_version\";s:6:\"1.9.63\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/updraftplus/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/updraftplus.1.9.63.zip\";}s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"13204\";s:4:\"slug\";s:19:\"wp-maintenance-mode\";s:6:\"plugin\";s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-maintenance-mode/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-maintenance-mode.2.0.3.zip\";}}}","yes");
INSERT INTO `wp_options` VALUES("114373","_site_transient_timeout_available_translations","1429230297","yes");
INSERT INTO `wp_options` VALUES("114374","_site_transient_available_translations","a:54:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-01 13:21:43\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:15:41\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:19:26\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:22:49\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:24:48\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:30:22\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:32:23\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:34:24\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:38:25\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-15 12:48:44\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:44:26\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:46:15\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:42:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:48:12\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:54:32\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:56:31\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:50:12\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-04 19:47:01\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.0/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 08:55:29\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:03:17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-18 08:12:21\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:08:29\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-05 17:37:43\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.0/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:14:57\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.1/haz.zip\";s:3:\"iso\";a:2:{i:1;s:3:\"haz\";i:2;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-08 22:28:26\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:25:25\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:27:28\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:29:34\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-15 22:23:37\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:33:39\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:35:42\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:43:18\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:47:56\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:7:\"Burmese\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:59:41\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:02:30\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-16 06:38:46\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:07:08\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ps.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ps\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:11:07\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:14:41\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 14:48:56\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:19:48\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:23:44\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:25:46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:30:35\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:33:33\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 00:00:51\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:43:10\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-10 12:55:55\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:55:15\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-26 02:21:02\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}","yes");
INSERT INTO `wp_options` VALUES("114999","updraft_jobdata_6d2bdde2587d","a:2:{s:8:\"job_type\";s:6:\"delete\";s:11:\"job_time_ms\";d:1429276769.608705;}","yes");
INSERT INTO `wp_options` VALUES("114998","updraft_jobdata_9a518246ab22","a:2:{s:8:\"job_type\";s:6:\"delete\";s:11:\"job_time_ms\";d:1429276766.5092449;}","yes");


DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=108230 DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` VALUES("5","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"1-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"1-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"1-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"1-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4","313","_wp_attached_file","2012/04/1.jpg");
INSERT INTO `wp_postmeta` VALUES("6","313","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("7","314","_wp_attached_file","2012/04/013.jpg");
INSERT INTO `wp_postmeta` VALUES("8","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/013.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"013-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"013-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"013-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"013-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"013-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"013-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"013-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"013-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"013-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"013-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"013-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"013-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("9","314","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("10","315","_wp_attached_file","2012/04/014.jpg");
INSERT INTO `wp_postmeta` VALUES("11","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/014.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"014-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"014-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"014-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"014-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"014-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"014-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"014-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"014-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"014-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"014-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"014-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"014-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"014-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("12","315","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("13","316","_wp_attached_file","2012/04/2.jpg");
INSERT INTO `wp_postmeta` VALUES("14","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/2.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"2-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"2-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"2-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"2-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"2-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"2-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"2-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("15","316","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("16","745","_wp_attached_file","2011/12/imac_big_demo.png");
INSERT INTO `wp_postmeta` VALUES("17","745","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2011/12/imac_big_demo.png\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x360.png\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x430.png\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x270.png\";s:5:\"width\";i:450;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("18","751","_avia_builder_template_single_portfolio_-_slider_two_third","{{{Single Portfolio - Slider Two Third}}}[av_two_third first]
[av_slideshow size=\'gallery\' animation=\'slide\' autoplay=\'true\' interval=\'5\']
[av_slide id=\'316\']
[av_slide id=\'315\']
[av_slide id=\'314\']
[av_slide id=\'313\']
[/av_slideshow]
[/av_two_third]

[av_one_third]
[av_textblock]
<h3>Portfolio Entry!</h3>
Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.
[/av_textblock]

[av_toggle_container initial=\'1\' mode=\'accordion\']
[av_toggle title=\'Client\']
<strong>XY Media</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

<strong>XY Media</strong> Website: <a href=\"http://www.wikipedia.com\">http://www.wikipedia.com</a>
[/av_toggle]
[av_toggle title=\'Our Task\']
<strong>Task</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu.
[/av_toggle]
[av_toggle title=\'Skills Involved\']
<strong>Skills</strong>
<ul>
	<li>Photoshop</li>
	<li>Indesign</li>
	<li>HTML</li>
	<li>CSS</li>
</ul>
[/av_toggle]
[/av_toggle_container]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_textblock]
<h4 style=\"text-align: center;\">Most Recent Entries</h4>
[/av_textblock]

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("3951","2317","_bbp_anonymous_email","dhgrygjv@rnexkaxo.com");
INSERT INTO `wp_postmeta` VALUES("3952","2317","_bbp_anonymous_website","http://generic-celexa.cf/#5353");
INSERT INTO `wp_postmeta` VALUES("3953","2317","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3954","2317","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3946","2316","_bbp_anonymous_website","http://buy-viagra-softtabs.tk/#6661");
INSERT INTO `wp_postmeta` VALUES("3947","2316","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3948","2316","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3949","2316","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3950","2317","_bbp_anonymous_name","buy generic celexa");
INSERT INTO `wp_postmeta` VALUES("3940","2315","_bbp_anonymous_website","http://order-viagra-online.tk/#6239");
INSERT INTO `wp_postmeta` VALUES("3941","2315","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3942","2315","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3943","2315","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3944","2316","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3945","2316","_bbp_anonymous_email","roqlmkuv@lnetoopf.com");
INSERT INTO `wp_postmeta` VALUES("3935","2314","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3936","2314","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3937","2314","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3938","2315","_bbp_anonymous_name","order viagra online");
INSERT INTO `wp_postmeta` VALUES("3939","2315","_bbp_anonymous_email","uutofbyd@iwqwrutt.com");
INSERT INTO `wp_postmeta` VALUES("3934","2314","_bbp_anonymous_website","http://vibramycin.tk/#2105");
INSERT INTO `wp_postmeta` VALUES("3915","2311","_bbp_anonymous_email","svunwksy@lszowvok.com");
INSERT INTO `wp_postmeta` VALUES("3916","2311","_bbp_anonymous_website","http://furosemide-medication.cf/#7291");
INSERT INTO `wp_postmeta` VALUES("3917","2311","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3918","2311","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3919","2311","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3920","2312","_bbp_anonymous_name","ventolin inhaler");
INSERT INTO `wp_postmeta` VALUES("3921","2312","_bbp_anonymous_email","anmqxkrt@kvpmkbfc.com");
INSERT INTO `wp_postmeta` VALUES("3922","2312","_bbp_anonymous_website","http://ventolininhaler.ga/#1401");
INSERT INTO `wp_postmeta` VALUES("3923","2312","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3924","2312","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3925","2312","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3926","2313","_bbp_anonymous_name","generic celebrex");
INSERT INTO `wp_postmeta` VALUES("3927","2313","_bbp_anonymous_email","auothzmu@kfmlejwt.com");
INSERT INTO `wp_postmeta` VALUES("3928","2313","_bbp_anonymous_website","http://genericcelebrex.tk/#3845");
INSERT INTO `wp_postmeta` VALUES("3929","2313","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3930","2313","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3931","2313","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3932","2314","_bbp_anonymous_name","vibramycin");
INSERT INTO `wp_postmeta` VALUES("3933","2314","_bbp_anonymous_email","efqbcwmn@icjdlmod.com");
INSERT INTO `wp_postmeta` VALUES("3901","2308","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3902","2309","_bbp_anonymous_name","cheap tadalafil 20mg");
INSERT INTO `wp_postmeta` VALUES("3903","2309","_bbp_anonymous_email","rllodoyh@ldmjbclf.com");
INSERT INTO `wp_postmeta` VALUES("3904","2309","_bbp_anonymous_website","http://cheap-tadalafil.tk/#4764");
INSERT INTO `wp_postmeta` VALUES("3905","2309","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3906","2309","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3907","2309","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3908","2310","_bbp_anonymous_name","cialis generic tadalafil");
INSERT INTO `wp_postmeta` VALUES("3909","2310","_bbp_anonymous_email","uwxfprmg@utgzdkdu.com");
INSERT INTO `wp_postmeta` VALUES("3910","2310","_bbp_anonymous_website","http://generic-tadalafil.biz/#7497");
INSERT INTO `wp_postmeta` VALUES("3911","2310","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3912","2310","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3913","2310","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3914","2311","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("3900","2308","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3899","2308","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5141","2515","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5140","2515","_bbp_anonymous_website","http://buycelebrex.se/#3021");
INSERT INTO `wp_postmeta` VALUES("47","734","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("48","734","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("49","734","_aviaLayoutBuilderCleanData","[av_layerslider id=\'1\']

[av_one_third first]
[av_icon_box icon=\'ue80c\' font=\'entypo-fontello\' position=\'left\' title=\'S‘inscrire à l’évènement\' link=\'page,1401\' linktarget=\'\' linkelement=\'both\']Inscrivez-vous dès maintenant en ligne aux prochaines 48h de la pige. La 4e édition se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres. Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'Découvrez le programme\' link=\'page,1722\' linktarget=\'\' linkelement=\'both\']Découvrez et téléchargez le programme de la prochaine édition. Les prochaine 48 h proposeront aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain. HORIZON 2030, un thème global et novateur afin d\'anticiper les évolutions de la presse et de se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue856\' font=\'entypo-fontello\' position=\'left\' title=\'Pratique\' link=\'page,821\' linktarget=\'\' linkelement=\'\']Pour anticiper tous les aspects pratiques de votre venue à Vichy, cliquez ici ! Que vous veniez en voiture, en co-voiturage, en train ou encore à pieds, passez donc par cette rubrique afin de connaître l\'indispensable sur les prochaines 48h de la pige. Un forum est à votre disposition afin de partager un transport ou encore un hébergement sur place !</strong>

[/av_icon_box]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']
[av_one_full first]

[av_textblock]
<a href=\"http://48h.pigiste.org/portfolio-item/les-48h-en-images/\" title=\"Les 48H en images\">
<h2 style=\"text-align: center;\">Découvrez la galerie photo des 48h</h2>
</a>
[/av_textblock]

[av_hr class=\'short\' height=\'70\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]
[/av_section]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']

[av_one_fifth first]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/audiens.png\' attachment=\'1916\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.audiens.org/pigiste/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/afdas.png\' attachment=\'1915\' align=\'center\' animation=\'no-animation\' link=\'manually,https://www.afdas.com/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/scam.png\' attachment=\'1917\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/pole-univ-01-footer.png\' attachment=\'1925\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2014/05/logos-allier-01.png\' attachment=\'2034\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][/av_section]");
INSERT INTO `wp_postmeta` VALUES("1088","1407","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1089","1407","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1090","1407","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1092","44","_edit_lock","1398426608:1");
INSERT INTO `wp_postmeta` VALUES("1093","1410","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1094","1410","_edit_lock","1398434055:1");
INSERT INTO `wp_postmeta` VALUES("1095","1410","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1096","1410","_aviaLayoutBuilderCleanData","[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Découvrez les 48H en images\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1097","1410","_avia_builder_shortcode_tree","a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("1240","1433","_thumbnail_id","1438");
INSERT INTO `wp_postmeta` VALUES("1098","1410","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1099","1410","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1100","1410","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1101","1410","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1102","1410","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1103","1410","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1104","1410","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1105","1410","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1106","1410","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1107","1410","header","yes");
INSERT INTO `wp_postmeta` VALUES("1108","1410","footer","");
INSERT INTO `wp_postmeta` VALUES("1109","1411","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1110","1411","_menu_item_menu_item_parent","1386");
INSERT INTO `wp_postmeta` VALUES("1111","1411","_menu_item_object_id","1410");
INSERT INTO `wp_postmeta` VALUES("1112","1411","_menu_item_object","portfolio");
INSERT INTO `wp_postmeta` VALUES("1113","1411","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1114","1411","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1115","1411","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1116","1411","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1121","1413","_wp_attached_file","2011/12/IMG_6092.jpg");
INSERT INTO `wp_postmeta` VALUES("1118","1411","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1119","1411","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1120","1411","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1122","1413","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1123","1414","_wp_attached_file","2011/12/IMG_6094.jpg");
INSERT INTO `wp_postmeta` VALUES("1124","1414","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6094.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6094-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6094-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6094-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6094-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6094-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6094-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6094-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6094-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("50","734","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("51","734","sidebar","");
INSERT INTO `wp_postmeta` VALUES("52","734","header","no");
INSERT INTO `wp_postmeta` VALUES("53","734","_avia_builder_shortcode_tree","a:6:{i:0;a:3:{s:3:\"tag\";s:14:\"av_layerslider\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:5;}i:4;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}i:2;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:8;}}s:5:\"index\";i:7;}i:5;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:5:{i:0;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:14;}}s:5:\"index\";i:13;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:15;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}}s:5:\"index\";i:17;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:20;}}s:5:\"index\";i:19;}i:4;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:21;}}s:5:\"index\";i:12;}}");
INSERT INTO `wp_postmeta` VALUES("1330","1496","_wp_attached_file","2011/12/BCR7704.jpg");
INSERT INTO `wp_postmeta` VALUES("1331","1496","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7704.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7704-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7704-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7704-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7704-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7704-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7704-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7704-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7704-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4419","2395","_bbp_anonymous_email","iwhjqocb@cmvbapno.com");
INSERT INTO `wp_postmeta` VALUES("4420","2395","_bbp_anonymous_website","http://mobic75mg.tk/#8936");
INSERT INTO `wp_postmeta` VALUES("1071","1401","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1072","1401","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1073","1401","_aviaLayoutBuilderCleanData","[av_fullscreen size=\'extra_large\' animation=\'fade\' autoplay=\'false\' interval=\'5\']
[av_fullscreen_slide id=\'1635\' position=\'Center Center\' title=\'\' caption_pos=\'caption_bottom\' link=\'\' link_target=\'\' link_apply=\'\' button_label=\'Click me\' button_color=\'light\'][/av_fullscreen_slide]
[/av_fullscreen]

[av_one_full first]
[av_heading heading=\'S‘inscrire à l’édition 2014 des 48h de la pige\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]
[/av_one_full]

[av_textblock ]
<p><strong> Les inscriptions sont closes pour l\'année 2014 ! Rendez-vous l\'année prochaine !</strong>

<em>L\'inscription aux 48h de la pige est gratuite. L\'évènement est ouvert à tous les journalistes pigistes.<br />Pour enregistrer votre inscription nous vous invitons à remplir ce formulaire. Il nous permettra de mieux vous accueillir et répondre à vos besoins en terme d\'hébergement, co-voiturage, restauration...</em></p>

[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("3677","2271","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3678","2271","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("1074","1401","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:13:\"av_fullscreen\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}");
INSERT INTO `wp_postmeta` VALUES("1075","1401","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1076","1401","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1077","1401","header","yes");
INSERT INTO `wp_postmeta` VALUES("1078","1401","footer","");
INSERT INTO `wp_postmeta` VALUES("1079","1407","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1080","1407","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1081","1407","_menu_item_object_id","1401");
INSERT INTO `wp_postmeta` VALUES("4349","2383","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4285","2372","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4286","2373","_bbp_anonymous_name","purchase zithromax online");
INSERT INTO `wp_postmeta` VALUES("4287","2373","_bbp_anonymous_email","tjoartez@apsdeqoj.com");
INSERT INTO `wp_postmeta` VALUES("4288","2373","_bbp_anonymous_website","http://buyzithromax.info/#3301");
INSERT INTO `wp_postmeta` VALUES("4289","2373","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4290","2373","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4291","2373","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4292","2374","_bbp_anonymous_name","neurontin");
INSERT INTO `wp_postmeta` VALUES("4293","2374","_bbp_anonymous_email","yyazsjsq@bhroqeid.com");
INSERT INTO `wp_postmeta` VALUES("4294","2374","_bbp_anonymous_website","http://neurontingabapentin.ga/#4129");
INSERT INTO `wp_postmeta` VALUES("4295","2374","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4296","2374","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4297","2374","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4298","2375","_bbp_anonymous_name","prednisone");
INSERT INTO `wp_postmeta` VALUES("4299","2375","_bbp_anonymous_email","zrzcqtav@mokffnjm.com");
INSERT INTO `wp_postmeta` VALUES("4300","2375","_bbp_anonymous_website","http://cheapprednisoneonline.ga/#3245");
INSERT INTO `wp_postmeta` VALUES("4301","2375","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4302","2375","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4303","2375","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4304","2376","_bbp_anonymous_name","where can i buy amoxicillin without prec");
INSERT INTO `wp_postmeta` VALUES("4305","2376","_bbp_anonymous_email","rznrbjwl@agcjrqne.com");
INSERT INTO `wp_postmeta` VALUES("4306","2376","_bbp_anonymous_website","http://buyamoxicillin.biz/#8169");
INSERT INTO `wp_postmeta` VALUES("4307","2376","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4308","2376","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4309","2376","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4310","2377","_bbp_anonymous_name","cialis 5 mg");
INSERT INTO `wp_postmeta` VALUES("4311","2377","_bbp_anonymous_email","gyhugrjz@yjcdwbwu.com");
INSERT INTO `wp_postmeta` VALUES("4312","2377","_bbp_anonymous_website","http://cialis5mg.tk/#4832");
INSERT INTO `wp_postmeta` VALUES("4313","2377","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4314","2377","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4315","2377","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4316","2378","_bbp_anonymous_name","alli 120 capsules");
INSERT INTO `wp_postmeta` VALUES("4317","2378","_bbp_anonymous_email","rdtehlbg@rsqrrwkk.com");
INSERT INTO `wp_postmeta` VALUES("4318","2378","_bbp_anonymous_website","http://alli-120.tk/#1346");
INSERT INTO `wp_postmeta` VALUES("4319","2378","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4320","2378","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4321","2378","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4322","2379","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4323","2379","_bbp_anonymous_email","tlonfunj@nfjqniwk.com");
INSERT INTO `wp_postmeta` VALUES("4324","2379","_bbp_anonymous_website","http://buycialisonline.ml/#3453");
INSERT INTO `wp_postmeta` VALUES("4325","2379","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4326","2379","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4327","2379","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4328","2380","_bbp_anonymous_name","order acyclovir online");
INSERT INTO `wp_postmeta` VALUES("4329","2380","_bbp_anonymous_email","iwhfywwf@sjicpuyo.com");
INSERT INTO `wp_postmeta` VALUES("4330","2380","_bbp_anonymous_website","http://orderacyclovir.ml/#5938");
INSERT INTO `wp_postmeta` VALUES("4331","2380","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4332","2380","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4333","2380","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4334","2381","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("4335","2381","_bbp_anonymous_email","qzxrgafy@pfldsttg.com");
INSERT INTO `wp_postmeta` VALUES("4336","2381","_bbp_anonymous_website","http://xenical-120-mg.cf/#4963");
INSERT INTO `wp_postmeta` VALUES("4337","2381","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4338","2381","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4339","2381","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4340","2382","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4341","2382","_bbp_anonymous_email","hyewnvab@iqczhuxc.com");
INSERT INTO `wp_postmeta` VALUES("4342","2382","_bbp_anonymous_website","http://cialus.tk/#2261");
INSERT INTO `wp_postmeta` VALUES("4343","2382","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4344","2382","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4345","2382","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4346","2383","_bbp_anonymous_name","where to purchase accutane");
INSERT INTO `wp_postmeta` VALUES("4347","2383","_bbp_anonymous_email","wguhvivk@dwibrijg.com");
INSERT INTO `wp_postmeta` VALUES("4348","2383","_bbp_anonymous_website","http://wheretopurchaseaccutane.cf/#4543");
INSERT INTO `wp_postmeta` VALUES("4284","2372","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4283","2372","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4263","2369","_bbp_anonymous_email","seydbqkt@goiucpfa.com");
INSERT INTO `wp_postmeta` VALUES("4264","2369","_bbp_anonymous_website","http://discountgenericcialis.tk/#1271");
INSERT INTO `wp_postmeta` VALUES("4265","2369","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4266","2369","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4267","2369","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4268","2370","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4269","2370","_bbp_anonymous_email","blejmacc@cqdmqgvk.com");
INSERT INTO `wp_postmeta` VALUES("4270","2370","_bbp_anonymous_website","http://cialistadalafil.cf/#2007");
INSERT INTO `wp_postmeta` VALUES("4271","2370","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4272","2370","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4273","2370","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4274","2371","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4275","2371","_bbp_anonymous_email","irfumpbt@dceznukv.com");
INSERT INTO `wp_postmeta` VALUES("4276","2371","_bbp_anonymous_website","http://accutanegeneric.pw/#3499");
INSERT INTO `wp_postmeta` VALUES("4277","2371","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4278","2371","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4279","2371","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4280","2372","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4281","2372","_bbp_anonymous_email","hlaoqeds@gvxnqokp.com");
INSERT INTO `wp_postmeta` VALUES("4282","2372","_bbp_anonymous_website","http://tadalafil.in/#9676");
INSERT INTO `wp_postmeta` VALUES("61","756","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("62","756","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("63","756","sidebar","");
INSERT INTO `wp_postmeta` VALUES("64","756","header","yes");
INSERT INTO `wp_postmeta` VALUES("65","756","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("66","756","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("67","756","_aviaLayoutBuilderCleanData","[av_portfolio columns=\'4\' items=\'16\' contents=\'title\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_textblock]
This is an example of a sortable, 4 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.

You can add Portfolio Grids to every Page you want or need, with the help of the fantastic and easy to use template builder that is built right into the theme.
[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("4248","2366","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4249","2366","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4250","2367","_bbp_anonymous_name","tadalafil cialis");
INSERT INTO `wp_postmeta` VALUES("4251","2367","_bbp_anonymous_email","qsiuavqi@cievpomm.com");
INSERT INTO `wp_postmeta` VALUES("4252","2367","_bbp_anonymous_website","http://tadalafil-cialis.ml/#9953");
INSERT INTO `wp_postmeta` VALUES("4253","2367","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4254","2367","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4255","2367","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4256","2368","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4257","2368","_bbp_anonymous_email","jsdlnpbn@wjlnyevo.com");
INSERT INTO `wp_postmeta` VALUES("4258","2368","_bbp_anonymous_website","http://buy-tadalafil.info/#2481");
INSERT INTO `wp_postmeta` VALUES("4259","2368","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4260","2368","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4247","2366","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4234","2364","_bbp_anonymous_website","http://genericabilify.biz/#2044");
INSERT INTO `wp_postmeta` VALUES("4235","2364","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4236","2364","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4237","2364","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4238","2365","_bbp_anonymous_name","this site");
INSERT INTO `wp_postmeta` VALUES("4239","2365","_bbp_anonymous_email","bgdgshny@zctagrqk.com");
INSERT INTO `wp_postmeta` VALUES("4240","2365","_bbp_anonymous_website","http://vardenafil-hcl.tk/#7692");
INSERT INTO `wp_postmeta` VALUES("4241","2365","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4242","2365","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4243","2365","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4244","2366","_bbp_anonymous_name","baclofen");
INSERT INTO `wp_postmeta` VALUES("4245","2366","_bbp_anonymous_email","axypkpdv@ybqdyysq.com");
INSERT INTO `wp_postmeta` VALUES("4246","2366","_bbp_anonymous_website","http://baclofen.ml/#3610");
INSERT INTO `wp_postmeta` VALUES("4233","2364","_bbp_anonymous_email","zotvcdvl@vzvcwhhp.com");
INSERT INTO `wp_postmeta` VALUES("4232","2364","_bbp_anonymous_name","wellbutrin abilify");
INSERT INTO `wp_postmeta` VALUES("4185","2356","_bbp_anonymous_email","zjiujopd@hevhkwmm.com");
INSERT INTO `wp_postmeta` VALUES("4186","2356","_bbp_anonymous_website","http://antibioticlevaquin.ml/#7740");
INSERT INTO `wp_postmeta` VALUES("4187","2356","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4188","2356","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4189","2356","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4190","2357","_bbp_anonymous_name","cialis generic viagra");
INSERT INTO `wp_postmeta` VALUES("4191","2357","_bbp_anonymous_email","grquypdz@czxrqctq.com");
INSERT INTO `wp_postmeta` VALUES("4192","2357","_bbp_anonymous_website","http://generic-cialis.se/#6707");
INSERT INTO `wp_postmeta` VALUES("4193","2357","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4194","2357","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4195","2357","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4196","2358","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("4197","2358","_bbp_anonymous_email","esvxsewf@bnnqrymp.com");
INSERT INTO `wp_postmeta` VALUES("4198","2358","_bbp_anonymous_website","http://alli-pill.ml/#4756");
INSERT INTO `wp_postmeta` VALUES("4199","2358","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4200","2358","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4201","2358","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4202","2359","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("4203","2359","_bbp_anonymous_email","wpxlgwql@pcbzhefw.com");
INSERT INTO `wp_postmeta` VALUES("4204","2359","_bbp_anonymous_website","http://amoxicillin875.ml/#5172");
INSERT INTO `wp_postmeta` VALUES("4205","2359","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4206","2359","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4207","2359","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4208","2360","_bbp_anonymous_name","flagyl");
INSERT INTO `wp_postmeta` VALUES("4209","2360","_bbp_anonymous_email","nhupvxet@szotedyd.com");
INSERT INTO `wp_postmeta` VALUES("4210","2360","_bbp_anonymous_website","http://buyflagyl.se/#3570");
INSERT INTO `wp_postmeta` VALUES("4211","2360","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4212","2360","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4213","2360","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4214","2361","_bbp_anonymous_name","generic valtrex online without perscription");
INSERT INTO `wp_postmeta` VALUES("4215","2361","_bbp_anonymous_email","oyugfavl@bewxolfd.com");
INSERT INTO `wp_postmeta` VALUES("4216","2361","_bbp_anonymous_website","http://genericforvaltrex.cf/#7695");
INSERT INTO `wp_postmeta` VALUES("4217","2361","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4218","2361","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4219","2361","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4220","2362","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4221","2362","_bbp_anonymous_email","lfwsgqpt@pkdinypo.com");
INSERT INTO `wp_postmeta` VALUES("4222","2362","_bbp_anonymous_website","http://accutane.ml/#4361");
INSERT INTO `wp_postmeta` VALUES("4223","2362","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4224","2362","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4225","2362","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4226","2363","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4227","2363","_bbp_anonymous_email","kqtdibjj@gsmlerjr.com");
INSERT INTO `wp_postmeta` VALUES("4228","2363","_bbp_anonymous_website","http://accutane.se/#3980");
INSERT INTO `wp_postmeta` VALUES("4229","2363","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4184","2356","_bbp_anonymous_name","antibiotic levaquin");
INSERT INTO `wp_postmeta` VALUES("4183","2355","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4085","2339","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4086","2339","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4087","2339","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4088","2340","_bbp_anonymous_name","alli for sale");
INSERT INTO `wp_postmeta` VALUES("4089","2340","_bbp_anonymous_email","bjbhgjrs@uyiptoly.com");
INSERT INTO `wp_postmeta` VALUES("4090","2340","_bbp_anonymous_website","http://alli.in/#3972");
INSERT INTO `wp_postmeta` VALUES("4091","2340","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4092","2340","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4093","2340","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4094","2341","_bbp_anonymous_name","bupropion sr 100mg");
INSERT INTO `wp_postmeta` VALUES("4095","2341","_bbp_anonymous_email","icnssjzy@ajohcani.com");
INSERT INTO `wp_postmeta` VALUES("4096","2341","_bbp_anonymous_website","http://bupropionsr100mg.cf/#2940");
INSERT INTO `wp_postmeta` VALUES("4097","2341","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4098","2341","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4099","2341","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4100","2342","_bbp_anonymous_name","diflucan");
INSERT INTO `wp_postmeta` VALUES("4101","2342","_bbp_anonymous_email","cjdtdmof@hcdblfnt.com");
INSERT INTO `wp_postmeta` VALUES("4102","2342","_bbp_anonymous_website","http://genericdiflucan.cf/#8503");
INSERT INTO `wp_postmeta` VALUES("4103","2342","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4104","2342","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4105","2342","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4106","2343","_bbp_anonymous_name","where to buy cialis over the counter");
INSERT INTO `wp_postmeta` VALUES("4107","2343","_bbp_anonymous_email","qubzomam@yecwlyzs.com");
INSERT INTO `wp_postmeta` VALUES("4108","2343","_bbp_anonymous_website","http://wheretobuycialis.ml/#3979");
INSERT INTO `wp_postmeta` VALUES("4109","2343","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4110","2343","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4111","2343","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4112","2344","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("4113","2344","_bbp_anonymous_email","vyxtesbb@zrdaxojn.com");
INSERT INTO `wp_postmeta` VALUES("4114","2344","_bbp_anonymous_website","http://sildenafil-100-mg.ml/#5221");
INSERT INTO `wp_postmeta` VALUES("4115","2344","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4116","2344","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4117","2344","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4118","2345","_bbp_anonymous_name","order neurontin online");
INSERT INTO `wp_postmeta` VALUES("4119","2345","_bbp_anonymous_email","fvegbrrt@hvqhuhrq.com");
INSERT INTO `wp_postmeta` VALUES("4120","2345","_bbp_anonymous_website","http://neurontin.biz/#5935");
INSERT INTO `wp_postmeta` VALUES("4121","2345","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4122","2345","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4123","2345","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4124","2346","_bbp_anonymous_name","viagra professional");
INSERT INTO `wp_postmeta` VALUES("4125","2346","_bbp_anonymous_email","xqsfvuhz@ullriocs.com");
INSERT INTO `wp_postmeta` VALUES("4126","2346","_bbp_anonymous_website","http://viagraprofessional.tk/#2304");
INSERT INTO `wp_postmeta` VALUES("4127","2346","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4128","2346","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4129","2346","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4130","2347","_bbp_anonymous_name","tadalafil without prescription");
INSERT INTO `wp_postmeta` VALUES("4131","2347","_bbp_anonymous_email","ryhuzmps@tuoxarqs.com");
INSERT INTO `wp_postmeta` VALUES("4132","2347","_bbp_anonymous_website","http://cialistadalafil.ml/#9075");
INSERT INTO `wp_postmeta` VALUES("4133","2347","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4134","2347","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4135","2347","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4136","2348","_bbp_anonymous_name","generic for propecia");
INSERT INTO `wp_postmeta` VALUES("4137","2348","_bbp_anonymous_email","armavkwk@kxfvdmen.com");
INSERT INTO `wp_postmeta` VALUES("4138","2348","_bbp_anonymous_website","http://buypropeciawithoutprescription.tk/#8964");
INSERT INTO `wp_postmeta` VALUES("4139","2348","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4140","2348","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4141","2348","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4142","2349","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4143","2349","_bbp_anonymous_email","ppsayohc@rgjedqrf.com");
INSERT INTO `wp_postmeta` VALUES("4144","2349","_bbp_anonymous_website","http://dailycialiscost.pw/#8082");
INSERT INTO `wp_postmeta` VALUES("4145","2349","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4146","2349","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4147","2349","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4148","2350","_bbp_anonymous_name","buy accutane");
INSERT INTO `wp_postmeta` VALUES("4149","2350","_bbp_anonymous_email","knmjliyc@qekrgofa.com");
INSERT INTO `wp_postmeta` VALUES("4150","2350","_bbp_anonymous_website","http://buy-accutane.nu/#1555");
INSERT INTO `wp_postmeta` VALUES("4151","2350","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4152","2350","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4153","2350","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4154","2351","_bbp_anonymous_name","alli 120 count");
INSERT INTO `wp_postmeta` VALUES("4155","2351","_bbp_anonymous_email","urzfakrk@rzjbrtpb.com");
INSERT INTO `wp_postmeta` VALUES("4156","2351","_bbp_anonymous_website","http://alli120.ml/#6279");
INSERT INTO `wp_postmeta` VALUES("4157","2351","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4158","2351","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4159","2351","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4160","2352","_bbp_anonymous_name","cheap tadalafil 20mg");
INSERT INTO `wp_postmeta` VALUES("4161","2352","_bbp_anonymous_email","vogxrrqx@rygwsnxv.com");
INSERT INTO `wp_postmeta` VALUES("4162","2352","_bbp_anonymous_website","http://tadalafilgeneric.ml/#2544");
INSERT INTO `wp_postmeta` VALUES("4163","2352","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4164","2352","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4165","2352","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4166","2353","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4167","2353","_bbp_anonymous_email","irgsqnrm@duwepnbe.com");
INSERT INTO `wp_postmeta` VALUES("4168","2353","_bbp_anonymous_website","http://buy-zithromax.se/#6306");
INSERT INTO `wp_postmeta` VALUES("4169","2353","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4170","2353","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4171","2353","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4172","2354","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("4173","2354","_bbp_anonymous_email","egdleria@orlssmva.com");
INSERT INTO `wp_postmeta` VALUES("4174","2354","_bbp_anonymous_website","http://buyviagrasofttabs.ml/#6145");
INSERT INTO `wp_postmeta` VALUES("4175","2354","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4176","2354","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4177","2354","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4178","2355","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("4179","2355","_bbp_anonymous_email","wammqydx@ksfzyjhq.com");
INSERT INTO `wp_postmeta` VALUES("4180","2355","_bbp_anonymous_website","http://buy-mobic.cf/#8776");
INSERT INTO `wp_postmeta` VALUES("4181","2355","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4182","2355","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4084","2339","_bbp_anonymous_website","http://disulfiramantabuse.tk/#4859");
INSERT INTO `wp_postmeta` VALUES("4082","2339","_bbp_anonymous_name","disulfiram antabuse");
INSERT INTO `wp_postmeta` VALUES("4081","2338","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4080","2338","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4079","2338","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4004","2326","_bbp_anonymous_name","alli diet pill");
INSERT INTO `wp_postmeta` VALUES("4005","2326","_bbp_anonymous_email","jayiazft@gypoxpiq.com");
INSERT INTO `wp_postmeta` VALUES("4006","2326","_bbp_anonymous_website","http://alli-diet-pill.ga/#5423");
INSERT INTO `wp_postmeta` VALUES("4007","2326","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4008","2326","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4009","2326","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4010","2327","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("4011","2327","_bbp_anonymous_email","exoxxcrk@rwyqoshw.com");
INSERT INTO `wp_postmeta` VALUES("4012","2327","_bbp_anonymous_website","http://buy-nexium.tk/#8895");
INSERT INTO `wp_postmeta` VALUES("4013","2327","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4014","2327","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4015","2327","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4016","2328","_bbp_anonymous_name","purchase cialis online");
INSERT INTO `wp_postmeta` VALUES("4017","2328","_bbp_anonymous_email","uyvqqxzl@upexhydd.com");
INSERT INTO `wp_postmeta` VALUES("4018","2328","_bbp_anonymous_website","http://cialispricing.ml/#4893");
INSERT INTO `wp_postmeta` VALUES("4019","2328","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4020","2328","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4021","2328","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4022","2329","_bbp_anonymous_name","cipro");
INSERT INTO `wp_postmeta` VALUES("4023","2329","_bbp_anonymous_email","pjwezbox@mqqenond.com");
INSERT INTO `wp_postmeta` VALUES("4024","2329","_bbp_anonymous_website","http://ciproiv.ml/#7889");
INSERT INTO `wp_postmeta` VALUES("4025","2329","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4026","2329","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4027","2329","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4028","2330","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4029","2330","_bbp_anonymous_email","ugyqjxmg@ccofdenh.com");
INSERT INTO `wp_postmeta` VALUES("4030","2330","_bbp_anonymous_website","http://cilias.cf/#2153");
INSERT INTO `wp_postmeta` VALUES("4031","2330","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4032","2330","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4033","2330","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4034","2331","_bbp_anonymous_name","wellbutrin drug");
INSERT INTO `wp_postmeta` VALUES("4035","2331","_bbp_anonymous_email","lbyejtmy@inpadzhx.com");
INSERT INTO `wp_postmeta` VALUES("4036","2331","_bbp_anonymous_website","http://wellbutrinxl150mg.ml/#3574");
INSERT INTO `wp_postmeta` VALUES("4037","2331","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4038","2331","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4039","2331","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4040","2332","_bbp_anonymous_name","advair");
INSERT INTO `wp_postmeta` VALUES("4041","2332","_bbp_anonymous_email","addkdecy@voqhadak.com");
INSERT INTO `wp_postmeta` VALUES("4042","2332","_bbp_anonymous_website","http://advair250.tk/#7292");
INSERT INTO `wp_postmeta` VALUES("4043","2332","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4044","2332","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4045","2332","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4046","2333","_bbp_anonymous_name","generic accutane cost");
INSERT INTO `wp_postmeta` VALUES("4047","2333","_bbp_anonymous_email","wqpyybsa@pabowpmv.com");
INSERT INTO `wp_postmeta` VALUES("4048","2333","_bbp_anonymous_website","http://accutane-cost.tk/#2375");
INSERT INTO `wp_postmeta` VALUES("4049","2333","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4050","2333","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4051","2333","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4052","2334","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("4053","2334","_bbp_anonymous_email","auwgjoem@icyvmgga.com");
INSERT INTO `wp_postmeta` VALUES("4054","2334","_bbp_anonymous_website","http://generic-sildenafil.cf/#5238");
INSERT INTO `wp_postmeta` VALUES("4055","2334","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4056","2334","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4057","2334","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4058","2335","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("4059","2335","_bbp_anonymous_email","tifbhsyy@wczdjlwp.com");
INSERT INTO `wp_postmeta` VALUES("4060","2335","_bbp_anonymous_website","http://vardenafil-hydrochloride.cf/#2359");
INSERT INTO `wp_postmeta` VALUES("4061","2335","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4062","2335","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4063","2335","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4064","2336","_bbp_anonymous_name","where can i buy tretinoin");
INSERT INTO `wp_postmeta` VALUES("4065","2336","_bbp_anonymous_email","vistcktg@uyayjzmb.com");
INSERT INTO `wp_postmeta` VALUES("4066","2336","_bbp_anonymous_website","http://tretinoin-cream.cf/#5839");
INSERT INTO `wp_postmeta` VALUES("4067","2336","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4068","2336","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4069","2336","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4070","2337","_bbp_anonymous_name","buy tretinoin cream");
INSERT INTO `wp_postmeta` VALUES("4071","2337","_bbp_anonymous_email","kgwmlcra@zwgdmpxn.com");
INSERT INTO `wp_postmeta` VALUES("4072","2337","_bbp_anonymous_website","http://tretinoin.ga/#5516");
INSERT INTO `wp_postmeta` VALUES("4073","2337","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4074","2337","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4075","2337","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4076","2338","_bbp_anonymous_name","prednisone");
INSERT INTO `wp_postmeta` VALUES("4077","2338","_bbp_anonymous_email","cmdznqif@ekgqahgr.com");
INSERT INTO `wp_postmeta` VALUES("4078","2338","_bbp_anonymous_website","http://prednisone20mgmedication.tk/#9794");
INSERT INTO `wp_postmeta` VALUES("3959","2318","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3960","2318","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3961","2318","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3962","2319","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("3963","2319","_bbp_anonymous_email","zuqxsspn@dnymjwor.com");
INSERT INTO `wp_postmeta` VALUES("3964","2319","_bbp_anonymous_website","http://meloxicam.cf/#4260");
INSERT INTO `wp_postmeta` VALUES("3965","2319","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3966","2319","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3967","2319","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3968","2320","_bbp_anonymous_name","buy vardenafil");
INSERT INTO `wp_postmeta` VALUES("3969","2320","_bbp_anonymous_email","skdzuirm@zpqntrli.com");
INSERT INTO `wp_postmeta` VALUES("3970","2320","_bbp_anonymous_website","http://buyvardenafil.biz/#1106");
INSERT INTO `wp_postmeta` VALUES("3971","2320","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3972","2320","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3973","2320","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3974","2321","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("3975","2321","_bbp_anonymous_email","vlvsyass@zzlsqnjw.com");
INSERT INTO `wp_postmeta` VALUES("3976","2321","_bbp_anonymous_website","http://buynexiumonline.ml/#2226");
INSERT INTO `wp_postmeta` VALUES("3977","2321","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3978","2321","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3979","2321","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3980","2322","_bbp_anonymous_name","get the facts");
INSERT INTO `wp_postmeta` VALUES("3981","2322","_bbp_anonymous_email","uiqlhoye@xkbczezj.com");
INSERT INTO `wp_postmeta` VALUES("3982","2322","_bbp_anonymous_website","http://genericeffexor.cf/#8027");
INSERT INTO `wp_postmeta` VALUES("3983","2322","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3984","2322","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3985","2322","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3986","2323","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("3987","2323","_bbp_anonymous_email","sjqnmuop@ctixpkwv.com");
INSERT INTO `wp_postmeta` VALUES("3988","2323","_bbp_anonymous_website","http://cheapmobic.cf/#2980");
INSERT INTO `wp_postmeta` VALUES("3989","2323","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3990","2323","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3991","2323","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3992","2324","_bbp_anonymous_name","generic synthroid");
INSERT INTO `wp_postmeta` VALUES("3993","2324","_bbp_anonymous_email","kydsjiex@tfrjbqkb.com");
INSERT INTO `wp_postmeta` VALUES("3994","2324","_bbp_anonymous_website","http://generic-synthroid.cf/#2475");
INSERT INTO `wp_postmeta` VALUES("3995","2324","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3996","2324","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3997","2324","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3998","2325","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3999","2325","_bbp_anonymous_email","xkqucmgu@bnpxnept.com");
INSERT INTO `wp_postmeta` VALUES("4000","2325","_bbp_anonymous_website","http://cheapcialisonline.tk/#7839");
INSERT INTO `wp_postmeta` VALUES("4001","2325","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4002","2325","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4003","2325","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3881","2305","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3882","2305","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3883","2305","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3884","2306","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3885","2306","_bbp_anonymous_email","fmactwof@qmczaefn.com");
INSERT INTO `wp_postmeta` VALUES("3886","2306","_bbp_anonymous_website","http://genericviagra.pw/#1789");
INSERT INTO `wp_postmeta` VALUES("3887","2306","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3888","2306","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3889","2306","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3890","2307","_bbp_anonymous_name","nexium dr 40 mg");
INSERT INTO `wp_postmeta` VALUES("3891","2307","_bbp_anonymous_email","hfifjlth@naaucvsi.com");
INSERT INTO `wp_postmeta` VALUES("3892","2307","_bbp_anonymous_website","http://nexium40.cf/#1126");
INSERT INTO `wp_postmeta` VALUES("3893","2307","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3894","2307","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3895","2307","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3896","2308","_bbp_anonymous_name","lisinopril 10mg");
INSERT INTO `wp_postmeta` VALUES("3897","2308","_bbp_anonymous_email","kceapoqk@blpxdeom.com");
INSERT INTO `wp_postmeta` VALUES("3880","2305","_bbp_anonymous_website","http://bestplacetobuyviagraonline.tk/#8476");
INSERT INTO `wp_postmeta` VALUES("3879","2305","_bbp_anonymous_email","luotzyfr@cxbwyfxm.com");
INSERT INTO `wp_postmeta` VALUES("3878","2305","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3877","2304","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3847","2299","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3848","2300","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("3849","2300","_bbp_anonymous_email","oaenftve@ljshwcbk.com");
INSERT INTO `wp_postmeta` VALUES("3850","2300","_bbp_anonymous_website","http://buyzithromax.se/#9025");
INSERT INTO `wp_postmeta` VALUES("3851","2300","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3852","2300","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3853","2300","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3854","2301","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("3855","2301","_bbp_anonymous_email","yzswtmkl@yomolzgs.com");
INSERT INTO `wp_postmeta` VALUES("3856","2301","_bbp_anonymous_website","http://alli120.pw/#1597");
INSERT INTO `wp_postmeta` VALUES("3857","2301","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3858","2301","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3859","2301","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3860","2302","_bbp_anonymous_name","neurontin");
INSERT INTO `wp_postmeta` VALUES("3861","2302","_bbp_anonymous_email","ifuzczba@evxitben.com");
INSERT INTO `wp_postmeta` VALUES("3862","2302","_bbp_anonymous_website","http://neurontingabapentin.tk/#4076");
INSERT INTO `wp_postmeta` VALUES("3863","2302","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3864","2302","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3865","2302","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3866","2303","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("3867","2303","_bbp_anonymous_email","lityzlhq@zumnvept.com");
INSERT INTO `wp_postmeta` VALUES("3868","2303","_bbp_anonymous_website","http://propeciacost.ml/#1264");
INSERT INTO `wp_postmeta` VALUES("3869","2303","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3870","2303","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3871","2303","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3872","2304","_bbp_anonymous_name","valtrex medication");
INSERT INTO `wp_postmeta` VALUES("3873","2304","_bbp_anonymous_email","grudjloq@feklzhjy.com");
INSERT INTO `wp_postmeta` VALUES("3874","2304","_bbp_anonymous_website","http://valtrex.se/#3006");
INSERT INTO `wp_postmeta` VALUES("3875","2304","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3876","2304","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3830","2297","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("3831","2297","_bbp_anonymous_email","zjmhuvau@rtvsltgx.com");
INSERT INTO `wp_postmeta` VALUES("3832","2297","_bbp_anonymous_website","http://keflex500.cf/#3557");
INSERT INTO `wp_postmeta` VALUES("3833","2297","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3834","2297","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3835","2297","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3836","2298","_bbp_anonymous_name","buystrattera");
INSERT INTO `wp_postmeta` VALUES("3837","2298","_bbp_anonymous_email","emuwzyfo@kigbaads.com");
INSERT INTO `wp_postmeta` VALUES("3838","2298","_bbp_anonymous_website","http://atomoxetine.cf/#2002");
INSERT INTO `wp_postmeta` VALUES("3839","2298","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3840","2298","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3841","2298","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3842","2299","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("3843","2299","_bbp_anonymous_email","gizwpzvg@lndzibgc.com");
INSERT INTO `wp_postmeta` VALUES("3844","2299","_bbp_anonymous_website","http://buy-doxycycline.ga/#4402");
INSERT INTO `wp_postmeta` VALUES("3829","2296","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3828","2296","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3827","2296","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3826","2296","_bbp_anonymous_website","http://howtoorderviagra.ml/#1251");
INSERT INTO `wp_postmeta` VALUES("3800","2292","_bbp_anonymous_name","tadalafil no prescription");
INSERT INTO `wp_postmeta` VALUES("3801","2292","_bbp_anonymous_email","cvdhccsx@rlwfapkd.com");
INSERT INTO `wp_postmeta` VALUES("3802","2292","_bbp_anonymous_website","http://tadalafilnoprescription.ga/#5105");
INSERT INTO `wp_postmeta` VALUES("3803","2292","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3804","2292","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3805","2292","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3806","2293","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("3807","2293","_bbp_anonymous_email","qtroxrxz@ddsggdro.com");
INSERT INTO `wp_postmeta` VALUES("3808","2293","_bbp_anonymous_website","http://genericcelebrex.nu/#8724");
INSERT INTO `wp_postmeta` VALUES("3809","2293","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3810","2293","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3811","2293","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3812","2294","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3813","2294","_bbp_anonymous_email","dxqiywuc@osctkwwx.com");
INSERT INTO `wp_postmeta` VALUES("3814","2294","_bbp_anonymous_website","http://ordercialis.ml/#3579");
INSERT INTO `wp_postmeta` VALUES("3815","2294","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3816","2294","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3817","2294","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3818","2295","_bbp_anonymous_name","mobic 7.5 mg");
INSERT INTO `wp_postmeta` VALUES("3819","2295","_bbp_anonymous_email","fmrlqdfb@qklwueyx.com");
INSERT INTO `wp_postmeta` VALUES("3820","2295","_bbp_anonymous_website","http://mobic75mg.pw/#6384");
INSERT INTO `wp_postmeta` VALUES("3821","2295","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3822","2295","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3823","2295","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3824","2296","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3825","2296","_bbp_anonymous_email","itootxlw@ojbdlzhk.com");
INSERT INTO `wp_postmeta` VALUES("3791","2290","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3792","2290","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3793","2290","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3794","2291","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("3795","2291","_bbp_anonymous_email","xnpeqjhc@liwpkjsf.com");
INSERT INTO `wp_postmeta` VALUES("3796","2291","_bbp_anonymous_website","http://amoxil-500.tk/#3245");
INSERT INTO `wp_postmeta` VALUES("3797","2291","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3790","2290","_bbp_anonymous_website","http://generic-lexapro.ml/#8757");
INSERT INTO `wp_postmeta` VALUES("3789","2290","_bbp_anonymous_email","ukhysmgr@zjrlftrd.com");
INSERT INTO `wp_postmeta` VALUES("3753","2284","_bbp_anonymous_email","wgwmjkyg@eiucfexo.com");
INSERT INTO `wp_postmeta` VALUES("3754","2284","_bbp_anonymous_website","http://buyviagra-soft-tabs.cf/#9988");
INSERT INTO `wp_postmeta` VALUES("3755","2284","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3756","2284","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3757","2284","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3758","2285","_bbp_anonymous_name","atenolol medication");
INSERT INTO `wp_postmeta` VALUES("3759","2285","_bbp_anonymous_email","gvmjojnw@xbcftajz.com");
INSERT INTO `wp_postmeta` VALUES("3760","2285","_bbp_anonymous_website","http://atenololmedication.tk/#2229");
INSERT INTO `wp_postmeta` VALUES("3761","2285","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3762","2285","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3763","2285","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3764","2286","_bbp_anonymous_name","viagra cialis levitra");
INSERT INTO `wp_postmeta` VALUES("3765","2286","_bbp_anonymous_email","ifwgsqql@mxseabez.com");
INSERT INTO `wp_postmeta` VALUES("3766","2286","_bbp_anonymous_website","http://viagracialislevitra.cf/#7245");
INSERT INTO `wp_postmeta` VALUES("3767","2286","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3768","2286","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3769","2286","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3770","2287","_bbp_anonymous_name","metformin generic");
INSERT INTO `wp_postmeta` VALUES("3771","2287","_bbp_anonymous_email","lmvogude@sbeswsaf.com");
INSERT INTO `wp_postmeta` VALUES("3772","2287","_bbp_anonymous_website","http://metformingeneric.ga/#2823");
INSERT INTO `wp_postmeta` VALUES("3773","2287","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3774","2287","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3775","2287","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3776","2288","_bbp_anonymous_name","doxycycline 100mg dogs");
INSERT INTO `wp_postmeta` VALUES("3777","2288","_bbp_anonymous_email","dtnxrkli@fieofjwl.com");
INSERT INTO `wp_postmeta` VALUES("3778","2288","_bbp_anonymous_website","http://doxycycline100mgdogs.ga/#4571");
INSERT INTO `wp_postmeta` VALUES("3779","2288","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3780","2288","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3781","2288","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3782","2289","_bbp_anonymous_name","more help");
INSERT INTO `wp_postmeta` VALUES("3783","2289","_bbp_anonymous_email","zjyiqcga@dsvjibml.com");
INSERT INTO `wp_postmeta` VALUES("3784","2289","_bbp_anonymous_website","http://levaquin500.pw/#6473");
INSERT INTO `wp_postmeta` VALUES("3785","2289","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3786","2289","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3787","2289","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3788","2290","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("115","821","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("116","821","sidebar","");
INSERT INTO `wp_postmeta` VALUES("117","821","header","yes");
INSERT INTO `wp_postmeta` VALUES("118","821","_dp_original","812");
INSERT INTO `wp_postmeta` VALUES("119","821","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("120","821","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("121","821","_aviaLayoutBuilderCleanData","[av_heading tag=\'h3\' padding=\'10\' heading=\'Anticipez tous les aspects pratiques de votre venue à Vichy !\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_one_half first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2014/04/P11705391-710x575.jpg\' attachment=\'1544\' align=\'center\' animation=\'left-to-right\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_textblock]
<h2>Bienvenue à Vichy !</h2>
[/av_textblock]

[av_textblock]
La 4e édition des 48 heures de la pige se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres
[/av_textblock]

[av_sidebar widget_area=\'Google Map\']
[/av_one_half]

[av_hr class=\'big\' height=\'50\' position=\'center\']

[av_one_fourth first]

[av_icon_box icon=\'ue8d7\' font=\'entypo-fontello\' position=\'left\' title=\'Comment venir ?\' link=\'page,1792\' linktarget=\'\' linkelement=\'both\']
<p>Pour connaître toutes les informations utiles concernant votre arrivée et les moyens de transport pour Vichy, c\'est par ici !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8b5\' font=\'entypo-fontello\' position=\'left\' title=\'Où dormir ?\' link=\'page,1801\' linktarget=\'\' linkelement=\'both\']
<p>Nous vous proposons plusieurs options pour vous loger sur place, découvrez ici les hôtels disponibles et renseignez la case hébergement lors de votre inscription !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8a9\' font=\'entypo-fontello\' position=\'left\' title=\'Que manger ?\' link=\'\' linktarget=\'\' linkelement=\'\']
<p>Si vous le désirez, vous pourrez vous restaurer sur place ! Renseignez simplement la case restauration lors de votre inscription à l\'événement</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue836\' font=\'entypo-fontello\' position=\'left\' title=\'Le forum\' link=\'page,1750\' linktarget=\'\' linkelement=\'both\']
<p>Pas envie de voyager ni de se loger seul(e) ? Partagez ici vos moyens de transport ou encore votre hébergement grâce à notre forum pratique !</p>

[/av_icon_box]

[/av_one_fourth][av_hr class=\'big\' height=\'50\' position=\'center\']

");
INSERT INTO `wp_postmeta` VALUES("3639","2265","_bbp_anonymous_email","fjppgkgr@tdtfendh.com");
INSERT INTO `wp_postmeta` VALUES("1586","1629","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1588","1630","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:21:\"2014/04/textvichy.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"textvichy-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"textvichy-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"textvichy-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"textvichy-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"textvichy-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"textvichy-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"textvichy-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"textvichy-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"textvichy-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("122","821","_avia_builder_shortcode_tree","a:9:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:1;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:2;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}i:4;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}}s:5:\"index\";i:8;}i:5;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:10;}i:6;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:7;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}}s:5:\"index\";i:14;}i:8;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}");
INSERT INTO `wp_postmeta` VALUES("3638","2265","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("1577","1629","_menu_item_object_id","821");
INSERT INTO `wp_postmeta` VALUES("1578","1629","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1579","1629","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1580","1629","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1581","1629","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1582","1629","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1587","1630","_wp_attached_file","2014/04/textvichy.png");
INSERT INTO `wp_postmeta` VALUES("1584","1629","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1585","1629","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("3748","2283","_bbp_anonymous_website","http://genericazithromycin.ml/#5029");
INSERT INTO `wp_postmeta` VALUES("3720","2278","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3721","2278","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3722","2279","_bbp_anonymous_name","sildenafil price");
INSERT INTO `wp_postmeta` VALUES("3723","2279","_bbp_anonymous_email","rarqvocq@hzbtirqd.com");
INSERT INTO `wp_postmeta` VALUES("3724","2279","_bbp_anonymous_website","http://sildenafilprice.ml/#7219");
INSERT INTO `wp_postmeta` VALUES("3725","2279","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3726","2279","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3727","2279","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3728","2280","_bbp_anonymous_name","bupropion sr 200 mg");
INSERT INTO `wp_postmeta` VALUES("3729","2280","_bbp_anonymous_email","nakjwifo@cphttkbv.com");
INSERT INTO `wp_postmeta` VALUES("3730","2280","_bbp_anonymous_website","http://genericbupropion.in/#7949");
INSERT INTO `wp_postmeta` VALUES("3731","2280","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3732","2280","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3733","2280","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3734","2281","_bbp_anonymous_name","acyclovir 800mg tablets");
INSERT INTO `wp_postmeta` VALUES("3735","2281","_bbp_anonymous_email","dupyadox@nbqjdoqs.com");
INSERT INTO `wp_postmeta` VALUES("3736","2281","_bbp_anonymous_website","http://valacyclovir.cf/#8199");
INSERT INTO `wp_postmeta` VALUES("3737","2281","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3738","2281","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3739","2281","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3740","2282","_bbp_anonymous_name","generic vardenafil");
INSERT INTO `wp_postmeta` VALUES("3741","2282","_bbp_anonymous_email","vbqjuxvw@nteqctlg.com");
INSERT INTO `wp_postmeta` VALUES("3742","2282","_bbp_anonymous_website","http://generic-vardenafil.se/#6448");
INSERT INTO `wp_postmeta` VALUES("3743","2282","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3744","2282","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3745","2282","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3746","2283","_bbp_anonymous_name","azithromycin generic");
INSERT INTO `wp_postmeta` VALUES("3747","2283","_bbp_anonymous_email","iudyosye@wvlvqsmn.com");
INSERT INTO `wp_postmeta` VALUES("3719","2278","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3702","2275","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3703","2275","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3704","2276","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3705","2276","_bbp_anonymous_email","chxqcbhy@kzjpcbmv.com");
INSERT INTO `wp_postmeta` VALUES("3706","2276","_bbp_anonymous_website","http://buycialisonlinenoprescription.cf/#4889");
INSERT INTO `wp_postmeta` VALUES("3707","2276","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3708","2276","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3709","2276","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3710","2277","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("3711","2277","_bbp_anonymous_email","ctzyvmlj@uaaklawz.com");
INSERT INTO `wp_postmeta` VALUES("3712","2277","_bbp_anonymous_website","http://strattera.in/#3671");
INSERT INTO `wp_postmeta` VALUES("3713","2277","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3714","2277","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3715","2277","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3716","2278","_bbp_anonymous_name","cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("3717","2278","_bbp_anonymous_email","dcipxgdl@wvcfepar.com");
INSERT INTO `wp_postmeta` VALUES("3718","2278","_bbp_anonymous_website","http://buycialisonlinewithoutprescription.tk/#7887");
INSERT INTO `wp_postmeta` VALUES("2370","1991","_wp_attached_file","2014/05/HUNTER-2013-original1.jpg");
INSERT INTO `wp_postmeta` VALUES("2371","1991","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:474;s:4:\"file\";s:33:\"2014/05/HUNTER-2013-original1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x474.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:474;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-705x427.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x273.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3673","2270","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3674","2271","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("3668","2270","_bbp_anonymous_name","where to get accutane");
INSERT INTO `wp_postmeta` VALUES("3669","2270","_bbp_anonymous_email","lhuxapba@nqjmdwin.com");
INSERT INTO `wp_postmeta` VALUES("3670","2270","_bbp_anonymous_website","http://buyaccutaneonline.ml/#6222");
INSERT INTO `wp_postmeta` VALUES("3661","2268","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3660","2268","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3659","2268","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3658","2268","_bbp_anonymous_website","http://genericzovirax.tk/#3826");
INSERT INTO `wp_postmeta` VALUES("3657","2268","_bbp_anonymous_email","uslklqji@fmasytlw.com");
INSERT INTO `wp_postmeta` VALUES("3648","2266","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3647","2266","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3640","2265","_bbp_anonymous_website","http://xenical120mg.tk/#1074");
INSERT INTO `wp_postmeta` VALUES("3371","2220","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3366","2219","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3367","2219","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3368","2220","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("3369","2220","_bbp_anonymous_email","zqdxxsup@bphlllgh.com");
INSERT INTO `wp_postmeta` VALUES("3370","2220","_bbp_anonymous_website","http://cheapestlevitra.tk/#3236");
INSERT INTO `wp_postmeta` VALUES("3527","2246","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3528","2246","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3529","2246","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3530","2247","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("3531","2247","_bbp_anonymous_email","nxikuqil@nmcwkrax.com");
INSERT INTO `wp_postmeta` VALUES("3532","2247","_bbp_anonymous_website","http://accutaneonline.tk/#9719");
INSERT INTO `wp_postmeta` VALUES("3533","2247","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3534","2247","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3535","2247","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3536","2248","_bbp_anonymous_name","vardenafil tablets 20 mg");
INSERT INTO `wp_postmeta` VALUES("3537","2248","_bbp_anonymous_email","zwxgpizv@jjzdxhfx.com");
INSERT INTO `wp_postmeta` VALUES("3538","2248","_bbp_anonymous_website","http://vardenafil-hcl.ml/#3021");
INSERT INTO `wp_postmeta` VALUES("3539","2248","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3540","2248","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3541","2248","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3542","2249","_bbp_anonymous_name","0.1 tretinoin cream");
INSERT INTO `wp_postmeta` VALUES("3543","2249","_bbp_anonymous_email","milcscpw@bayhgsvn.com");
INSERT INTO `wp_postmeta` VALUES("3544","2249","_bbp_anonymous_website","http://retinacream005.cf/#2785");
INSERT INTO `wp_postmeta` VALUES("3545","2249","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3546","2249","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3547","2249","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3548","2250","_bbp_anonymous_name","clomd");
INSERT INTO `wp_postmeta` VALUES("3549","2250","_bbp_anonymous_email","oburkvxh@eadhvyhg.com");
INSERT INTO `wp_postmeta` VALUES("2740","2069","_wp_attached_file","2014/05/logo-CMB.bmp");
INSERT INTO `wp_postmeta` VALUES("3601","2258","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3600","2258","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3599","2258","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3598","2258","_bbp_anonymous_website","http://propeciaonline.nu/#4083");
INSERT INTO `wp_postmeta` VALUES("3550","2250","_bbp_anonymous_website","http://buyclomidonlineusa.tk/#6010");
INSERT INTO `wp_postmeta` VALUES("3551","2250","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3552","2250","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3553","2250","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3554","2251","_bbp_anonymous_name","xenical 120 mg");
INSERT INTO `wp_postmeta` VALUES("3555","2251","_bbp_anonymous_email","lzxrgoff@lirveqcj.com");
INSERT INTO `wp_postmeta` VALUES("3556","2251","_bbp_anonymous_website","http://xenical120mg.pw/#6346");
INSERT INTO `wp_postmeta` VALUES("3557","2251","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3558","2251","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3559","2251","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3560","2252","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("3561","2252","_bbp_anonymous_email","citmizfg@yfqcfjms.com");
INSERT INTO `wp_postmeta` VALUES("3562","2252","_bbp_anonymous_website","http://generic-zoloft.pw/#3759");
INSERT INTO `wp_postmeta` VALUES("3563","2252","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3564","2252","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3565","2252","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3566","2253","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("3567","2253","_bbp_anonymous_email","gyogcmhv@quooicpa.com");
INSERT INTO `wp_postmeta` VALUES("3568","2253","_bbp_anonymous_website","http://atomoxetine.tk/#3854");
INSERT INTO `wp_postmeta` VALUES("3569","2253","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3570","2253","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3571","2253","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3572","2254","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("3573","2254","_bbp_anonymous_email","plubsbsd@ybdgxdbf.com");
INSERT INTO `wp_postmeta` VALUES("3574","2254","_bbp_anonymous_website","http://buylevitra.in/#9029");
INSERT INTO `wp_postmeta` VALUES("3575","2254","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3576","2254","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3577","2254","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3578","2255","_bbp_anonymous_name","generic nexium");
INSERT INTO `wp_postmeta` VALUES("3579","2255","_bbp_anonymous_email","gxodppzu@xwwcvfti.com");
INSERT INTO `wp_postmeta` VALUES("3580","2255","_bbp_anonymous_website","http://generic-nexium.pw/#9930");
INSERT INTO `wp_postmeta` VALUES("3581","2255","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3582","2255","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3583","2255","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3584","2256","_bbp_anonymous_name","augmentin");
INSERT INTO `wp_postmeta` VALUES("3585","2256","_bbp_anonymous_email","upemxorx@emynwgxs.com");
INSERT INTO `wp_postmeta` VALUES("3586","2256","_bbp_anonymous_website","http://generic-augmentin.cf/#3199");
INSERT INTO `wp_postmeta` VALUES("3587","2256","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3588","2256","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3589","2256","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3590","2257","_bbp_anonymous_name","more bonuses");
INSERT INTO `wp_postmeta` VALUES("3591","2257","_bbp_anonymous_email","cktnvngw@mvckytyb.com");
INSERT INTO `wp_postmeta` VALUES("3592","2257","_bbp_anonymous_website","http://buyviagrasoft-tabs.ga/#4942");
INSERT INTO `wp_postmeta` VALUES("3593","2257","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3594","2257","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3595","2257","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3596","2258","_bbp_anonymous_name","propecia online");
INSERT INTO `wp_postmeta` VALUES("3597","2258","_bbp_anonymous_email","qtdqahew@bgvsivkq.com");
INSERT INTO `wp_postmeta` VALUES("3007","2161","_bbp_reply_count","15464");
INSERT INTO `wp_postmeta` VALUES("3008","2161","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("3009","2161","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("3010","2162","_bbp_anonymous_name","eacrxrofs");
INSERT INTO `wp_postmeta` VALUES("3011","2162","_bbp_anonymous_email","nightetktk@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("3012","2162","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3013","2162","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3014","2162","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3015","2162","_bbp_author_ip","62.210.82.82");
INSERT INTO `wp_postmeta` VALUES("3016","2162","_oembed_028f9512a9d2b6990f7fd620815da9de","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3017","2162","_oembed_cb0b4b43a85795130b5c31170d5c33c5","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3018","2162","_oembed_ad12a603dc38d09145069ee2901d9911","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3019","2162","_oembed_0dcd9bf27162bb124be54b7d446d5a5d","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3020","2162","_oembed_c83eb83938528717158368a648750e74","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3021","2163","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3022","2163","_bbp_anonymous_email","thelastlooker@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3023","2163","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3024","2163","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3025","2163","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3026","2163","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3027","2164","_bbp_anonymous_name","Cheap Green Bay Packers Jerseys");
INSERT INTO `wp_postmeta` VALUES("3028","2164","_bbp_anonymous_email","didgrxzthbs@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3029","2164","_bbp_anonymous_website","http://www.fdlgroup.co.uk/images/Cheap-Green-Bay-Packers-Jerseys.asp");
INSERT INTO `wp_postmeta` VALUES("3030","2164","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3031","2164","_bbp_topic_id","2164");
INSERT INTO `wp_postmeta` VALUES("3032","2164","_bbp_author_ip","117.26.252.17");
INSERT INTO `wp_postmeta` VALUES("3033","2164","_bbp_last_reply_id","19692");
INSERT INTO `wp_postmeta` VALUES("3034","2164","_bbp_last_active_id","19692");
INSERT INTO `wp_postmeta` VALUES("3035","2164","_bbp_last_active_time","2015-03-30 12:34:22");
INSERT INTO `wp_postmeta` VALUES("3036","2164","_bbp_reply_count","1882");
INSERT INTO `wp_postmeta` VALUES("3037","2164","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("3038","2164","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("3039","2166","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3040","2166","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3041","2166","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3042","2166","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3043","2166","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("3044","2166","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3045","2167","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3046","2167","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3047","2167","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3048","2167","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3049","2167","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3050","2167","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3051","2168","_bbp_anonymous_name","eacruroud");
INSERT INTO `wp_postmeta` VALUES("3052","2168","_bbp_anonymous_email","nightetktk@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("3053","2168","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3054","2168","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3055","2168","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3056","2168","_bbp_author_ip","62.210.82.82");
INSERT INTO `wp_postmeta` VALUES("3057","2168","_oembed_b7c0fef6cbfb72bb968683fde5e0b848","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3058","2168","_oembed_c43b0d62b83ede06e39691f157682953","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3059","2168","_oembed_133c86495b5c8a9a703386d7c14694e4","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3060","2168","_oembed_713ea9d8519c876c00f02c4b1e7934b1","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3061","2168","_oembed_c9d17265f4d4e3d82a5b2aaf3dc6d6e4","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3062","2169","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3063","2169","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3064","2169","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3065","2169","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3066","2169","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("3067","2169","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3068","2170","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3069","2170","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3070","2170","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3071","2170","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3072","2170","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3073","2170","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3074","2171","_bbp_anonymous_name","nlaeqoxx");
INSERT INTO `wp_postmeta` VALUES("3075","2171","_bbp_anonymous_email","sxdfvh@hforpj.com");
INSERT INTO `wp_postmeta` VALUES("3076","2171","_bbp_anonymous_website","http://hhbdoa.com/");
INSERT INTO `wp_postmeta` VALUES("3077","2171","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3078","2171","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3079","2171","_bbp_author_ip","62.210.91.186");
INSERT INTO `wp_postmeta` VALUES("3080","2172","_bbp_anonymous_name","tlyqzm");
INSERT INTO `wp_postmeta` VALUES("3081","2172","_bbp_anonymous_email","fmcrvg@acpysr.com");
INSERT INTO `wp_postmeta` VALUES("3082","2172","_bbp_anonymous_website","http://ubhrsblcauak.com/");
INSERT INTO `wp_postmeta` VALUES("3083","2172","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3084","2172","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3085","2172","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3086","2173","_bbp_anonymous_name","fqayngf");
INSERT INTO `wp_postmeta` VALUES("3087","2173","_bbp_anonymous_email","liauln@znhxyw.com");
INSERT INTO `wp_postmeta` VALUES("3088","2173","_bbp_anonymous_website","http://ymvybvgthqjc.com/");
INSERT INTO `wp_postmeta` VALUES("3089","2173","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3090","2173","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3091","2173","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3092","2174","_bbp_anonymous_name","lolherzqkbc");
INSERT INTO `wp_postmeta` VALUES("3093","2174","_bbp_anonymous_email","ipivlp@tyqwqv.com");
INSERT INTO `wp_postmeta` VALUES("3094","2174","_bbp_anonymous_website","http://kixosebglfqn.com/");
INSERT INTO `wp_postmeta` VALUES("3095","2174","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3096","2174","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3097","2174","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3098","2175","_bbp_anonymous_name","nolvadex online");
INSERT INTO `wp_postmeta` VALUES("3099","2175","_bbp_anonymous_email","yavhtxuy@vidxcrss.com");
INSERT INTO `wp_postmeta` VALUES("3100","2175","_bbp_anonymous_website","http://buy-nolvadex.info/#9468");
INSERT INTO `wp_postmeta` VALUES("3101","2175","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3102","2175","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3103","2175","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3104","2176","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("3105","2176","_bbp_anonymous_email","hjsksjio@dtyzeuib.com");
INSERT INTO `wp_postmeta` VALUES("3106","2176","_bbp_anonymous_website","http://advair-diskus.cf/#8555");
INSERT INTO `wp_postmeta` VALUES("3107","2176","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3108","2176","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3109","2176","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3110","2177","_bbp_anonymous_name","generic propecia online");
INSERT INTO `wp_postmeta` VALUES("3111","2177","_bbp_anonymous_email","hkhogmzo@qwcqcmhj.com");
INSERT INTO `wp_postmeta` VALUES("3112","2177","_bbp_anonymous_website","http://buypropecia.in/#2693");
INSERT INTO `wp_postmeta` VALUES("3113","2177","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3114","2177","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3115","2177","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3116","2178","_bbp_anonymous_name","buy tretinoin gel");
INSERT INTO `wp_postmeta` VALUES("3117","2178","_bbp_anonymous_email","zavtdlrf@fbfnhbxp.com");
INSERT INTO `wp_postmeta` VALUES("3118","2178","_bbp_anonymous_website","http://tretinoincream.in/#8166");
INSERT INTO `wp_postmeta` VALUES("3119","2178","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3120","2178","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3121","2178","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3122","2179","_bbp_anonymous_name","buy viagra online");
INSERT INTO `wp_postmeta` VALUES("3123","2179","_bbp_anonymous_email","nrlvlvdm@uxzfmeee.com");
INSERT INTO `wp_postmeta` VALUES("3124","2179","_bbp_anonymous_website","http://buyviagraonline.ml/#9858");
INSERT INTO `wp_postmeta` VALUES("3125","2179","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3126","2179","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3127","2179","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3128","2180","_bbp_anonymous_name","hydrochlorothiazide");
INSERT INTO `wp_postmeta` VALUES("3129","2180","_bbp_anonymous_email","flsugobw@ouqlumem.com");
INSERT INTO `wp_postmeta` VALUES("3130","2180","_bbp_anonymous_website","http://hydrochlorothiazide.se/#4730");
INSERT INTO `wp_postmeta` VALUES("3131","2180","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3132","2180","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3133","2180","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3134","2181","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("3135","2181","_bbp_anonymous_email","jmtunfna@xvfthwel.com");
INSERT INTO `wp_postmeta` VALUES("3136","2181","_bbp_anonymous_website","http://genericaccutane.in/#8108");
INSERT INTO `wp_postmeta` VALUES("3137","2181","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3138","2181","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3139","2181","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3140","2182","_bbp_anonymous_name","cheap generic valtrex without prescription");
INSERT INTO `wp_postmeta` VALUES("3141","2182","_bbp_anonymous_email","qxcbmflz@tahajuax.com");
INSERT INTO `wp_postmeta` VALUES("3142","2182","_bbp_anonymous_website","http://valtrex.in/cheap-generic-valtrex-without-prescription.html#7763");
INSERT INTO `wp_postmeta` VALUES("3143","2182","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3470","2237","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("3471","2237","_bbp_anonymous_email","jvcjjjmz@vifkvukj.com");
INSERT INTO `wp_postmeta` VALUES("3472","2237","_bbp_anonymous_website","http://allipill.cf/#9773");
INSERT INTO `wp_postmeta` VALUES("3473","2237","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3474","2237","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3475","2237","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3476","2238","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("3477","2238","_bbp_anonymous_email","ocicduto@rznwzwoc.com");
INSERT INTO `wp_postmeta` VALUES("3478","2238","_bbp_anonymous_website","http://zithromaxstrepthroat.tk/#5413");
INSERT INTO `wp_postmeta` VALUES("3526","2246","_bbp_anonymous_website","http://genericcelebrex.biz/#3611");
INSERT INTO `wp_postmeta` VALUES("3479","2238","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3480","2238","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3481","2238","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3482","2239","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("3483","2239","_bbp_anonymous_email","zuppaapp@hcirumqc.com");
INSERT INTO `wp_postmeta` VALUES("3484","2239","_bbp_anonymous_website","http://vardenafilhydrochloride.ml/#1202");
INSERT INTO `wp_postmeta` VALUES("3485","2239","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3486","2239","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3487","2239","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3488","2240","_bbp_anonymous_name","more bonuses");
INSERT INTO `wp_postmeta` VALUES("3489","2240","_bbp_anonymous_email","mmhaydbr@egdmxjvv.com");
INSERT INTO `wp_postmeta` VALUES("3490","2240","_bbp_anonymous_website","http://buyfinasteride.tk/#1348");
INSERT INTO `wp_postmeta` VALUES("3491","2240","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3492","2240","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3493","2240","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3494","2241","_bbp_anonymous_name","full article");
INSERT INTO `wp_postmeta` VALUES("3495","2241","_bbp_anonymous_email","otdolxph@kitsjhdu.com");
INSERT INTO `wp_postmeta` VALUES("3496","2241","_bbp_anonymous_website","http://cialiscom.tk/#2477");
INSERT INTO `wp_postmeta` VALUES("3497","2241","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3498","2241","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3499","2241","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3500","2242","_bbp_anonymous_name","abilify");
INSERT INTO `wp_postmeta` VALUES("3501","2242","_bbp_anonymous_email","imilyzhk@ilnxbquw.com");
INSERT INTO `wp_postmeta` VALUES("3502","2242","_bbp_anonymous_website","http://abilify.in/#5454");
INSERT INTO `wp_postmeta` VALUES("3503","2242","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3504","2242","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3505","2242","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3506","2243","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("3507","2243","_bbp_anonymous_email","pxihkgmu@jyviycpw.com");
INSERT INTO `wp_postmeta` VALUES("3508","2243","_bbp_anonymous_website","http://ventolin-hfa.cf/#9459");
INSERT INTO `wp_postmeta` VALUES("3509","2243","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3510","2243","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3511","2243","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3512","2244","_bbp_anonymous_name","generic abilify");
INSERT INTO `wp_postmeta` VALUES("3513","2244","_bbp_anonymous_email","nabyyjte@vaqozled.com");
INSERT INTO `wp_postmeta` VALUES("3514","2244","_bbp_anonymous_website","http://genericabilify.nu/#1870");
INSERT INTO `wp_postmeta` VALUES("3515","2244","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3516","2244","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3517","2244","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3518","2245","_bbp_anonymous_name","lavetra");
INSERT INTO `wp_postmeta` VALUES("3519","2245","_bbp_anonymous_email","sgfsvqkf@dfqfhhta.com");
INSERT INTO `wp_postmeta` VALUES("3520","2245","_bbp_anonymous_website","http://levetra.cf/#4946");
INSERT INTO `wp_postmeta` VALUES("3521","2245","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3522","2245","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3523","2245","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3524","2246","_bbp_anonymous_name","generic celebrex");
INSERT INTO `wp_postmeta` VALUES("3525","2246","_bbp_anonymous_email","fwsmmgtr@pwlskoqh.com");
INSERT INTO `wp_postmeta` VALUES("3399","2225","_bbp_anonymous_email","yihfdnll@llojdzcw.com");
INSERT INTO `wp_postmeta` VALUES("3398","2225","_bbp_anonymous_name","zoloft 50mg");
INSERT INTO `wp_postmeta` VALUES("3397","2224","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3396","2224","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3395","2224","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3389","2223","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3390","2223","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3391","2223","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3392","2224","_bbp_anonymous_name","tadalafil 5 mg");
INSERT INTO `wp_postmeta` VALUES("3393","2224","_bbp_anonymous_email","zeiwtycs@sdpwgoob.com");
INSERT INTO `wp_postmeta` VALUES("3394","2224","_bbp_anonymous_website","http://onlinetadalafil.tk/#6712");
INSERT INTO `wp_postmeta` VALUES("3634","2264","_bbp_anonymous_website","http://vermox-500.tk/#6998");
INSERT INTO `wp_postmeta` VALUES("3633","2264","_bbp_anonymous_email","hierdfxa@vjdqxoow.com");
INSERT INTO `wp_postmeta` VALUES("3632","2264","_bbp_anonymous_name","vermox");
INSERT INTO `wp_postmeta` VALUES("3620","2262","_bbp_anonymous_name","augmentin oral");
INSERT INTO `wp_postmeta` VALUES("3621","2262","_bbp_anonymous_email","elxlwsge@kqujlnci.com");
INSERT INTO `wp_postmeta` VALUES("3622","2262","_bbp_anonymous_website","http://augmentin500.tk/#4015");
INSERT INTO `wp_postmeta` VALUES("3623","2262","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3624","2262","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3625","2262","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3626","2263","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("3627","2263","_bbp_anonymous_email","dmpmtjhy@tcjauwtt.com");
INSERT INTO `wp_postmeta` VALUES("3628","2263","_bbp_anonymous_website","http://howmuchispropecia.ml/#1222");
INSERT INTO `wp_postmeta` VALUES("3629","2263","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3630","2263","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3631","2263","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3256","2201","_bbp_anonymous_website","http://clomid.in/#6348");
INSERT INTO `wp_postmeta` VALUES("3255","2201","_bbp_anonymous_email","awwabrar@wsnlvdbc.com");
INSERT INTO `wp_postmeta` VALUES("3254","2201","_bbp_anonymous_name","clomid");
INSERT INTO `wp_postmeta` VALUES("3253","2200","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3252","2200","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3251","2200","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3273","2204","_bbp_anonymous_email","xmlexypl@abqjuisi.com");
INSERT INTO `wp_postmeta` VALUES("3272","2204","_bbp_anonymous_name","generic propecia online");
INSERT INTO `wp_postmeta` VALUES("3271","2203","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3270","2203","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3269","2203","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3257","2201","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3258","2201","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3259","2201","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3260","2202","_bbp_anonymous_name","buy generic propecia");
INSERT INTO `wp_postmeta` VALUES("3261","2202","_bbp_anonymous_email","phduhutr@opnvefgx.com");
INSERT INTO `wp_postmeta` VALUES("3262","2202","_bbp_anonymous_website","http://buypropecia.in/#6616");
INSERT INTO `wp_postmeta` VALUES("3263","2202","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3264","2202","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3265","2202","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3266","2203","_bbp_anonymous_name","chewable viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3267","2203","_bbp_anonymous_email","kuxqqumy@pmgmpqtr.com");
INSERT INTO `wp_postmeta` VALUES("3268","2203","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#1068");
INSERT INTO `wp_postmeta` VALUES("2443","2013","_wp_attached_file","2013/04/S.Daycard-Heid-12.jpg");
INSERT INTO `wp_postmeta` VALUES("2444","2013","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:680;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-12.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-705x572.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:572;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x365.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:365;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3427","2229","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3426","2229","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3425","2229","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3424","2229","_bbp_anonymous_website","http://buyretinaonline.cf/#1383");
INSERT INTO `wp_postmeta` VALUES("3423","2229","_bbp_anonymous_email","jzchfuqa@uvizdnmp.com");
INSERT INTO `wp_postmeta` VALUES("3422","2229","_bbp_anonymous_name","buying retin-a online");
INSERT INTO `wp_postmeta` VALUES("3421","2228","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3420","2228","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3419","2228","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3183","2189","_bbp_anonymous_email","rrkvkcxs@jhiwiyys.com");
INSERT INTO `wp_postmeta` VALUES("3182","2189","_bbp_anonymous_name","generic for advair diskus");
INSERT INTO `wp_postmeta` VALUES("3181","2188","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3180","2188","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3179","2188","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3165","2186","_bbp_anonymous_email","tvaajnkg@pucocrpq.com");
INSERT INTO `wp_postmeta` VALUES("3166","2186","_bbp_anonymous_website","http://allipills.tk/generic-alli.html#4436");
INSERT INTO `wp_postmeta` VALUES("3167","2186","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3168","2186","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3169","2186","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3170","2187","_bbp_anonymous_name","advair 250/50");
INSERT INTO `wp_postmeta` VALUES("3171","2187","_bbp_anonymous_email","vxlocpjj@phkpygcw.com");
INSERT INTO `wp_postmeta` VALUES("3172","2187","_bbp_anonymous_website","http://advair-diskus.cf/price-of-advair.html#3599");
INSERT INTO `wp_postmeta` VALUES("3173","2187","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3174","2187","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3175","2187","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3176","2188","_bbp_anonymous_name","tretinoin cream generic");
INSERT INTO `wp_postmeta` VALUES("3177","2188","_bbp_anonymous_email","tejayktl@huzoqnoi.com");
INSERT INTO `wp_postmeta` VALUES("3178","2188","_bbp_anonymous_website","http://tretinoin-cream.ga/tretinoin-cream-usp-0-025.html#1903");
INSERT INTO `wp_postmeta` VALUES("3447","2233","_bbp_anonymous_email","thdxxtze@zxjicmfv.com");
INSERT INTO `wp_postmeta` VALUES("3431","2230","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3430","2230","_bbp_anonymous_website","http://buy-viagra-soft-tabs.pw/#1515");
INSERT INTO `wp_postmeta` VALUES("3429","2230","_bbp_anonymous_email","ekhluqom@rxuqgmzc.com");
INSERT INTO `wp_postmeta` VALUES("3428","2230","_bbp_anonymous_name","cheapest viagra prices");
INSERT INTO `wp_postmeta` VALUES("3467","2236","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3468","2236","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3469","2236","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3466","2236","_bbp_anonymous_website","http://cheapclomidwithoutprescription.ga/#4460");
INSERT INTO `wp_postmeta` VALUES("3462","2235","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3463","2235","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3464","2236","_bbp_anonymous_name","clomid");
INSERT INTO `wp_postmeta` VALUES("3465","2236","_bbp_anonymous_email","zkywoioq@jqvcmrbt.com");
INSERT INTO `wp_postmeta` VALUES("3459","2235","_bbp_anonymous_email","lvinpzyf@moaetfrh.com");
INSERT INTO `wp_postmeta` VALUES("3458","2235","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3457","2234","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3456","2234","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3455","2234","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3448","2233","_bbp_anonymous_website","http://buytretinoincream.se/#7865");
INSERT INTO `wp_postmeta` VALUES("3449","2233","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3450","2233","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3451","2233","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3452","2234","_bbp_anonymous_name","atenolol");
INSERT INTO `wp_postmeta` VALUES("3453","2234","_bbp_anonymous_email","xrzafmmp@fslguzau.com");
INSERT INTO `wp_postmeta` VALUES("3454","2234","_bbp_anonymous_website","http://atenolol.ml/#2289");
INSERT INTO `wp_postmeta` VALUES("3605","2259","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3604","2259","_bbp_anonymous_website","http://lexapro5mg.cf/#5658");
INSERT INTO `wp_postmeta` VALUES("3603","2259","_bbp_anonymous_email","pqmpxyuc@ovbaglkv.com");
INSERT INTO `wp_postmeta` VALUES("3602","2259","_bbp_anonymous_name","generic for lexapro");
INSERT INTO `wp_postmeta` VALUES("3153","2184","_bbp_anonymous_email","ydzlonzq@xxftqhyo.com");
INSERT INTO `wp_postmeta` VALUES("3152","2184","_bbp_anonymous_name","cheap viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3151","2183","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3150","2183","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3149","2183","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3146","2183","_bbp_anonymous_name","clomid for men");
INSERT INTO `wp_postmeta` VALUES("3147","2183","_bbp_anonymous_email","mczullqu@hbjrxsrp.com");
INSERT INTO `wp_postmeta` VALUES("3148","2183","_bbp_anonymous_website","http://clomid.in/cheap-clomid-without-prescription.html#2787");
INSERT INTO `wp_postmeta` VALUES("3461","2235","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3460","2235","_bbp_anonymous_website","http://cialis.tk/#5244");
INSERT INTO `wp_postmeta` VALUES("2958","2156","_bbp_last_active_time","2014-12-14 10:26:45");
INSERT INTO `wp_postmeta` VALUES("2956","2156","_bbp_last_reply_id","2169");
INSERT INTO `wp_postmeta` VALUES("2957","2156","_bbp_last_active_id","2169");
INSERT INTO `wp_postmeta` VALUES("2955","2156","_bbp_author_ip","120.37.238.71");
INSERT INTO `wp_postmeta` VALUES("2954","2156","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("2953","2156","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2950","2156","_bbp_anonymous_name","Wholesale NFL Jerseys");
INSERT INTO `wp_postmeta` VALUES("2951","2156","_bbp_anonymous_email","rbbyrpq@gmail.com");
INSERT INTO `wp_postmeta` VALUES("2952","2156","_bbp_anonymous_website","http://www.abcindustrial.co.uk/News/nflcheapstore.asp");
INSERT INTO `wp_postmeta` VALUES("3672","2270","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3671","2270","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3646","2266","_bbp_anonymous_website","http://cialis-price.tk/#5192");
INSERT INTO `wp_postmeta` VALUES("3645","2266","_bbp_anonymous_email","lmzvadir@dmlsczzn.com");
INSERT INTO `wp_postmeta` VALUES("3644","2266","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3643","2265","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3642","2265","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3641","2265","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2549","2034","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:87;s:4:\"file\";s:27:\"2014/05/logos-allier-01.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-180x87.png\";s:5:\"width\";i:180;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-120x87.png\";s:5:\"width\";i:120;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2550","2037","_wp_attached_file","2014/05/Allier_le_Departement_bleu.png");
INSERT INTO `wp_postmeta` VALUES("2551","2037","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1687;s:6:\"height\";i:480;s:4:\"file\";s:38:\"2014/05/Allier_le_Departement_bleu.png\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Allier_le_Departement_bleu-300x85.png\";s:5:\"width\";i:300;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x293.png\";s:5:\"width\";i:1030;s:6:\"height\";i:293;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x430.png\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x426.png\";s:5:\"width\";i:1500;s:6:\"height\";i:426;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x480.png\";s:5:\"width\";i:710;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-705x200.png\";s:5:\"width\";i:705;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x128.png\";s:5:\"width\";i:450;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2352","1978","_wp_attached_file","2014/05/g.le_roux.jpg");
INSERT INTO `wp_postmeta` VALUES("3232","2197","_bbp_anonymous_website","http://generictadalafil.se/#5584");
INSERT INTO `wp_postmeta` VALUES("3221","2195","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3220","2195","_bbp_anonymous_website","http://buyviagraonline.ml/super-active-viagra.html#5100");
INSERT INTO `wp_postmeta` VALUES("3219","2195","_bbp_anonymous_email","rfpceaeg@vgkfsxwr.com");
INSERT INTO `wp_postmeta` VALUES("3218","2195","_bbp_anonymous_name","super active viagra");
INSERT INTO `wp_postmeta` VALUES("3217","2194","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3216","2194","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3215","2194","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3214","2194","_bbp_anonymous_website","http://buycelebrex.biz/buy-celebrex-without-prescription.html#3262");
INSERT INTO `wp_postmeta` VALUES("2278","1963","_wp_attached_file","2014/05/cistude_romain_riols.jpg");
INSERT INTO `wp_postmeta` VALUES("2279","1963","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:4:\"file\";s:32:\"2014/05/cistude_romain_riols.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:34:\"cistude_romain_riols-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3231","2197","_bbp_anonymous_email","scufoyvp@zupurulk.com");
INSERT INTO `wp_postmeta` VALUES("3230","2197","_bbp_anonymous_name","tadalafil cheap");
INSERT INTO `wp_postmeta` VALUES("3229","2196","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3228","2196","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3227","2196","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3226","2196","_bbp_anonymous_website","http://buy-levitra.ml/#9300");
INSERT INTO `wp_postmeta` VALUES("3225","2196","_bbp_anonymous_email","dnftaoxl@mwqhlvcj.com");
INSERT INTO `wp_postmeta` VALUES("3224","2196","_bbp_anonymous_name","buy levitra");
INSERT INTO `wp_postmeta` VALUES("3223","2195","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3222","2195","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3213","2194","_bbp_anonymous_email","gvaggsvg@kvvkeujz.com");
INSERT INTO `wp_postmeta` VALUES("3212","2194","_bbp_anonymous_name","buy celebrex without prescription");
INSERT INTO `wp_postmeta` VALUES("3211","2193","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3210","2193","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3209","2193","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3197","2191","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3198","2191","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3199","2191","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3200","2192","_bbp_anonymous_name","finasteride without prescription");
INSERT INTO `wp_postmeta` VALUES("3201","2192","_bbp_anonymous_email","hbtkujyc@jphjqule.com");
INSERT INTO `wp_postmeta` VALUES("3202","2192","_bbp_anonymous_website","http://genericpropecia.nu/generic-propecia-canada.html#8427");
INSERT INTO `wp_postmeta` VALUES("3203","2192","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3204","2192","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3205","2192","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3206","2193","_bbp_anonymous_name","levitra 40 mg pay with mastercard");
INSERT INTO `wp_postmeta` VALUES("3207","2193","_bbp_anonymous_email","goyoumfx@pijbtuis.com");
INSERT INTO `wp_postmeta` VALUES("3208","2193","_bbp_anonymous_website","http://buy-levitra.ml/how-much-is-levitra.html#8866");
INSERT INTO `wp_postmeta` VALUES("3246","2199","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3245","2199","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3244","2199","_bbp_anonymous_website","http://allipills.tk/#9518");
INSERT INTO `wp_postmeta` VALUES("3233","2197","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3234","2197","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3235","2197","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3236","2198","_bbp_anonymous_name","buy propecia");
INSERT INTO `wp_postmeta` VALUES("3237","2198","_bbp_anonymous_email","ybzvoawe@hcqdtizg.com");
INSERT INTO `wp_postmeta` VALUES("3238","2198","_bbp_anonymous_website","http://genericpropecia.nu/#8193");
INSERT INTO `wp_postmeta` VALUES("3239","2198","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3240","2198","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3241","2198","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3242","2199","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("3243","2199","_bbp_anonymous_email","nhnwnlau@xhnzifdr.com");
INSERT INTO `wp_postmeta` VALUES("3247","2199","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3248","2200","_bbp_anonymous_name","price of valtrex");
INSERT INTO `wp_postmeta` VALUES("3249","2200","_bbp_anonymous_email","lfjwmuhu@yzkbktru.com");
INSERT INTO `wp_postmeta` VALUES("3250","2200","_bbp_anonymous_website","http://valtrex.in/#4716");
INSERT INTO `wp_postmeta` VALUES("3382","2222","_bbp_anonymous_website","http://discountcialisonline.cf/#4087");
INSERT INTO `wp_postmeta` VALUES("3381","2222","_bbp_anonymous_email","emnntdmo@dyvhskmz.com");
INSERT INTO `wp_postmeta` VALUES("3380","2222","_bbp_anonymous_name","cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("3379","2221","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3378","2221","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3377","2221","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3372","2220","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3373","2220","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3374","2221","_bbp_anonymous_name","generic accutane");
INSERT INTO `wp_postmeta` VALUES("3375","2221","_bbp_anonymous_email","qcanrsey@fkdxiovi.com");
INSERT INTO `wp_postmeta` VALUES("3376","2221","_bbp_anonymous_website","http://genericaccutane.biz/#7963");
INSERT INTO `wp_postmeta` VALUES("3388","2223","_bbp_anonymous_website","http://buy-viagra-softtabs.cf/#9416");
INSERT INTO `wp_postmeta` VALUES("3387","2223","_bbp_anonymous_email","lomxfflz@sjjeetmj.com");
INSERT INTO `wp_postmeta` VALUES("3386","2223","_bbp_anonymous_name","best price viagra");
INSERT INTO `wp_postmeta` VALUES("3385","2222","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3384","2222","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3383","2222","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2353","1978","_wp_attachment_metadata","a:5:{s:5:\"width\";i:4592;s:6:\"height\";i:2576;s:4:\"file\";s:21:\"2014/05/g.le_roux.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"g.le_roux-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"g.le_roux-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x577.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:577;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"g.le_roux-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"g.le_roux-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x841.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:841;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"g.le_roux-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"g.le_roux-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"g.le_roux-705x395.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"g.le_roux-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x252.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996447286321199499070644378662109375;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DSLR-A290\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1344353630;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"300\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:9:\"0.0015625\";s:5:\"title\";s:8:\"SONY DSC\";}}");
INSERT INTO `wp_postmeta` VALUES("2354","1979","_wp_attached_file","2014/05/riols_romain_milan_noir.jpg");
INSERT INTO `wp_postmeta` VALUES("2355","1979","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:35:\"2014/05/riols_romain_milan_noir.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:37:\"riols_romain_milan_noir-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:3.70000000000000017763568394002504646778106689453125;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:29:\"Konica Digital Camera KD-310Z\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1049047227;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"14.2\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0156\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2356","1980","_wp_attached_file","2014/05/val_dallier_jean_jacques_lallemant.jpg");
INSERT INTO `wp_postmeta` VALUES("2357","1980","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2362;s:6:\"height\";i:1586;s:4:\"file\";s:46:\"2014/05/val_dallier_jean_jacques_lallemant.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x691.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:48:\"val_dallier_jean_jacques_lallemant-1500x1007.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1007;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-705x473.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x302.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:302;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2360","1986","_wp_attached_file","2014/05/HUNTER-20131.jpg");
INSERT INTO `wp_postmeta` VALUES("2361","1986","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1295;s:4:\"file\";s:24:\"2014/05/HUNTER-20131.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-795x1030.jpg\";s:5:\"width\";i:795;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2362","1987","_wp_attached_file","2014/05/HUNTER-20132.jpg");
INSERT INTO `wp_postmeta` VALUES("2363","1987","_wp_attachment_metadata","a:5:{s:5:\"width\";i:667;s:6:\"height\";i:864;s:4:\"file\";s:24:\"2014/05/HUNTER-20132.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x430.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x575.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x270.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x360.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2364","1988","_wp_attached_file","2014/05/HUNTER-20133.jpg");
INSERT INTO `wp_postmeta` VALUES("2365","1988","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2014/05/HUNTER-20133.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-205x300.jpg\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x575.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x655.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:655;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2366","1989","_wp_attached_file","2014/05/HUNTER-20134.jpg");
INSERT INTO `wp_postmeta` VALUES("2367","1989","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:473;s:4:\"file\";s:24:\"2014/05/HUNTER-20134.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-290x300.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x464.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:464;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2368","1990","_wp_attached_file","2014/05/HUNTER-2013-original.jpg");
INSERT INTO `wp_postmeta` VALUES("2369","1990","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:576;s:4:\"file\";s:32:\"2014/05/HUNTER-2013-original.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-300x221.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-705x519.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x331.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("307","44","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("308","44","_avia_elements_avia_options_propulsion","s:1046:\"a:6:{s:4:\"hero\";s:3:\"yes\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `wp_postmeta` VALUES("309","44","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("310","44","_avia_elements_avia_options_coherence","s:1436:\"a:13:{s:8:\"subtitle\";s:45:\"Donec pede justo, fringilla vel, aliquet nec!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:10:\"Flashlight\";s:16:\"portfolio-meta-3\";s:91:\"&lt;a href=&quot;http://www.kriesi.at/themes/flashlight/&quot;&gt;Flashlight Demo&lt;/a&gt;\";}\";");
INSERT INTO `wp_postmeta` VALUES("1139","44","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("312","44","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("313","44","_facebookcount-cache","0");
INSERT INTO `wp_postmeta` VALUES("314","44","_twittercount-cache","0");
INSERT INTO `wp_postmeta` VALUES("315","44","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("316","44","_aviaLayoutBuilderCleanData","[av_two_third first]

[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1490,1491,1492,1493,1494,1496,1497,1498,1499,1500\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']

[/av_two_third][av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1142","44","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1143","44","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1144","44","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1145","44","_preview_columns","8");
INSERT INTO `wp_postmeta` VALUES("1146","44","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1147","44","footer","");
INSERT INTO `wp_postmeta` VALUES("317","44","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1140","44","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1141","44","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("318","44","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("319","44","sidebar","");
INSERT INTO `wp_postmeta` VALUES("320","44","header","yes");
INSERT INTO `wp_postmeta` VALUES("6158","2685","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6159","2685","_bbp_anonymous_email","ykodecrf@apfvrqbm.com");
INSERT INTO `wp_postmeta` VALUES("6160","2685","_bbp_anonymous_website","http://propeciahairgrowth.tk/#7284");
INSERT INTO `wp_postmeta` VALUES("6161","2685","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6162","2685","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6163","2685","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6164","2686","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6165","2686","_bbp_anonymous_email","keqbfgvs@etkhoxuf.com");
INSERT INTO `wp_postmeta` VALUES("6166","2686","_bbp_anonymous_website","http://generic-sildenafil-citrate.ga/#6195");
INSERT INTO `wp_postmeta` VALUES("6167","2686","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6168","2686","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6169","2686","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6170","2687","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("6171","2687","_bbp_anonymous_email","riwisdht@avoetgvs.com");
INSERT INTO `wp_postmeta` VALUES("6172","2687","_bbp_anonymous_website","http://buy-tadalafil-online.cf/#3176");
INSERT INTO `wp_postmeta` VALUES("6173","2687","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6174","2687","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6142","2682","_bbp_anonymous_website","http://valtrex-500mg.ml/#3256");
INSERT INTO `wp_postmeta` VALUES("6143","2682","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6144","2682","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6145","2682","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6146","2683","_bbp_anonymous_name","generic vardenafil");
INSERT INTO `wp_postmeta` VALUES("6147","2683","_bbp_anonymous_email","yavuhoop@ehtmrynw.com");
INSERT INTO `wp_postmeta` VALUES("6148","2683","_bbp_anonymous_website","http://generic-vardenafil.tk/#7185");
INSERT INTO `wp_postmeta` VALUES("6149","2683","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6150","2683","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6151","2683","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6152","2684","_bbp_anonymous_name","alli pill");
INSERT INTO `wp_postmeta` VALUES("6153","2684","_bbp_anonymous_email","czfhixjr@axhtgneh.com");
INSERT INTO `wp_postmeta` VALUES("6154","2684","_bbp_anonymous_website","http://allipill.ml/#4767");
INSERT INTO `wp_postmeta` VALUES("6155","2684","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6156","2684","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6157","2684","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6125","2679","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6126","2679","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6127","2679","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6128","2680","_bbp_anonymous_name","bupropion hcl xl 300 mg");
INSERT INTO `wp_postmeta` VALUES("6129","2680","_bbp_anonymous_email","jusvyxyf@icqllihs.com");
INSERT INTO `wp_postmeta` VALUES("6130","2680","_bbp_anonymous_website","http://bupropionxl300.cf/#4519");
INSERT INTO `wp_postmeta` VALUES("6131","2680","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6132","2680","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6133","2680","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6134","2681","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6135","2681","_bbp_anonymous_email","cuodemja@ofbhzedg.com");
INSERT INTO `wp_postmeta` VALUES("6136","2681","_bbp_anonymous_website","http://buycialisonline.ml/#4659");
INSERT INTO `wp_postmeta` VALUES("6137","2681","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6138","2681","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6139","2681","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6140","2682","_bbp_anonymous_name","valtrex 500mg");
INSERT INTO `wp_postmeta` VALUES("6141","2682","_bbp_anonymous_email","gifilxlp@coywygmd.com");
INSERT INTO `wp_postmeta` VALUES("6124","2679","_bbp_anonymous_website","http://furosemide40mgdiuretic.pw/#4573");
INSERT INTO `wp_postmeta` VALUES("6105","2676","_bbp_anonymous_email","igflsihc@vdguhdzy.com");
INSERT INTO `wp_postmeta` VALUES("6106","2676","_bbp_anonymous_website","http://buy-propecia.cf/#1678");
INSERT INTO `wp_postmeta` VALUES("6107","2676","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6108","2676","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6109","2676","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6110","2677","_bbp_anonymous_name","advair diskus 250/50");
INSERT INTO `wp_postmeta` VALUES("6111","2677","_bbp_anonymous_email","ixppfrtf@rmcgqfiq.com");
INSERT INTO `wp_postmeta` VALUES("6112","2677","_bbp_anonymous_website","http://advair-diskus.ml/#8624");
INSERT INTO `wp_postmeta` VALUES("6113","2677","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6114","2677","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6115","2677","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6116","2678","_bbp_anonymous_name","levitra prices");
INSERT INTO `wp_postmeta` VALUES("6117","2678","_bbp_anonymous_email","roryrdoa@pjccewgk.com");
INSERT INTO `wp_postmeta` VALUES("6118","2678","_bbp_anonymous_website","http://levitracoupons.ga/#3625");
INSERT INTO `wp_postmeta` VALUES("6119","2678","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6120","2678","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6121","2678","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6122","2679","_bbp_anonymous_name","buy furesimide");
INSERT INTO `wp_postmeta` VALUES("6123","2679","_bbp_anonymous_email","opmkerzg@nfbwlyqb.com");
INSERT INTO `wp_postmeta` VALUES("6104","2676","_bbp_anonymous_name","continue reading");
INSERT INTO `wp_postmeta` VALUES("6086","2673","_bbp_anonymous_name","more helpful hints");
INSERT INTO `wp_postmeta` VALUES("6087","2673","_bbp_anonymous_email","nwuowwki@jkjfvwku.com");
INSERT INTO `wp_postmeta` VALUES("6088","2673","_bbp_anonymous_website","http://genericzithromax.se/#8334");
INSERT INTO `wp_postmeta` VALUES("6089","2673","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6090","2673","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6091","2673","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6092","2674","_bbp_anonymous_name","get more information");
INSERT INTO `wp_postmeta` VALUES("6093","2674","_bbp_anonymous_email","vcqrtwjo@hmjicbbx.com");
INSERT INTO `wp_postmeta` VALUES("6094","2674","_bbp_anonymous_website","http://levitracheap.cf/#8016");
INSERT INTO `wp_postmeta` VALUES("6095","2674","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6096","2674","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6097","2674","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6098","2675","_bbp_anonymous_name","generic prozac cost");
INSERT INTO `wp_postmeta` VALUES("6099","2675","_bbp_anonymous_email","lcvxahau@nfyycihc.com");
INSERT INTO `wp_postmeta` VALUES("6100","2675","_bbp_anonymous_website","http://generic-prozac.cf/#4635");
INSERT INTO `wp_postmeta` VALUES("6101","2675","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6102","2675","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6103","2675","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6085","2672","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6084","2672","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6045","2666","_bbp_anonymous_email","hoaxedfw@zvouvxgo.com");
INSERT INTO `wp_postmeta` VALUES("6046","2666","_bbp_anonymous_website","http://buymobic.se/#9996");
INSERT INTO `wp_postmeta` VALUES("6047","2666","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6048","2666","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6049","2666","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6050","2667","_bbp_anonymous_name","celebrex buy");
INSERT INTO `wp_postmeta` VALUES("6051","2667","_bbp_anonymous_email","dsqdqzxj@qyfntibt.com");
INSERT INTO `wp_postmeta` VALUES("6052","2667","_bbp_anonymous_website","http://buycelebrex.se/#8968");
INSERT INTO `wp_postmeta` VALUES("6053","2667","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6054","2667","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6055","2667","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6056","2668","_bbp_anonymous_name","clindamycin topical gel");
INSERT INTO `wp_postmeta` VALUES("6057","2668","_bbp_anonymous_email","selebhpk@zownkikf.com");
INSERT INTO `wp_postmeta` VALUES("6058","2668","_bbp_anonymous_website","http://cleocint.tk/#9271");
INSERT INTO `wp_postmeta` VALUES("6059","2668","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6060","2668","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6061","2668","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6062","2669","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6063","2669","_bbp_anonymous_email","kssreyxd@gbpwafcx.com");
INSERT INTO `wp_postmeta` VALUES("6064","2669","_bbp_anonymous_website","http://discountcialis.tk/#1050");
INSERT INTO `wp_postmeta` VALUES("6065","2669","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6066","2669","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6067","2669","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6068","2670","_bbp_anonymous_name","effexor xr 150mg");
INSERT INTO `wp_postmeta` VALUES("6069","2670","_bbp_anonymous_email","slxneiia@vwkrgmln.com");
INSERT INTO `wp_postmeta` VALUES("6070","2670","_bbp_anonymous_website","http://effexorxr150mg.pw/#9497");
INSERT INTO `wp_postmeta` VALUES("6071","2670","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6072","2670","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6073","2670","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6074","2671","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("6075","2671","_bbp_anonymous_email","zdmivklu@mskmzubj.com");
INSERT INTO `wp_postmeta` VALUES("6076","2671","_bbp_anonymous_website","http://zoloftgeneric.ml/#6748");
INSERT INTO `wp_postmeta` VALUES("6077","2671","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6078","2671","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6079","2671","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6080","2672","_bbp_anonymous_name","generic for effexor");
INSERT INTO `wp_postmeta` VALUES("6081","2672","_bbp_anonymous_email","dnhrrdrr@gawwwcwo.com");
INSERT INTO `wp_postmeta` VALUES("6082","2672","_bbp_anonymous_website","http://genericforeffexor.cf/#3088");
INSERT INTO `wp_postmeta` VALUES("6083","2672","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6028","2663","_bbp_anonymous_website","http://cheapprednisoneonline.tk/#7503");
INSERT INTO `wp_postmeta` VALUES("6029","2663","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6030","2663","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6031","2663","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6032","2664","_bbp_anonymous_name","augmentin generic");
INSERT INTO `wp_postmeta` VALUES("6033","2664","_bbp_anonymous_email","uncyhqet@iehatjkz.com");
INSERT INTO `wp_postmeta` VALUES("6034","2664","_bbp_anonymous_website","http://genericforaugmentin.pw/#7137");
INSERT INTO `wp_postmeta` VALUES("6035","2664","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6036","2664","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6037","2664","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6038","2665","_bbp_anonymous_name","viagra online sales");
INSERT INTO `wp_postmeta` VALUES("6039","2665","_bbp_anonymous_email","adgosgrs@nvvuudwk.com");
INSERT INTO `wp_postmeta` VALUES("6040","2665","_bbp_anonymous_website","http://viagraonlinesales.pw/#7854");
INSERT INTO `wp_postmeta` VALUES("6041","2665","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6042","2665","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6043","2665","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6044","2666","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6027","2663","_bbp_anonymous_email","iweodigk@yxzmnqnu.com");
INSERT INTO `wp_postmeta` VALUES("5122","2512","_bbp_anonymous_website","http://viagrabuyonline.ga/#1219");
INSERT INTO `wp_postmeta` VALUES("5098","2508","_bbp_anonymous_website","http://allipill.ml/#5325");
INSERT INTO `wp_postmeta` VALUES("5099","2508","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5100","2508","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5101","2508","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5102","2509","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5103","2509","_bbp_anonymous_email","gvkiiqsy@ejofketw.com");
INSERT INTO `wp_postmeta` VALUES("5104","2509","_bbp_anonymous_website","http://buy-cialis.se/#4890");
INSERT INTO `wp_postmeta` VALUES("5105","2509","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5106","2509","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5107","2509","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5108","2510","_bbp_anonymous_name","generic prozac");
INSERT INTO `wp_postmeta` VALUES("5109","2510","_bbp_anonymous_email","insjueuj@blplgkhx.com");
INSERT INTO `wp_postmeta` VALUES("5110","2510","_bbp_anonymous_website","http://generic-prozac.pw/#8140");
INSERT INTO `wp_postmeta` VALUES("5111","2510","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5112","2510","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5113","2510","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5114","2511","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5115","2511","_bbp_anonymous_email","enkbrmnh@ejmsxuno.com");
INSERT INTO `wp_postmeta` VALUES("5116","2511","_bbp_anonymous_website","http://propeciahairloss.cf/#1822");
INSERT INTO `wp_postmeta` VALUES("5117","2511","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5118","2511","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5119","2511","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5120","2512","_bbp_anonymous_name","india viagra online");
INSERT INTO `wp_postmeta` VALUES("5121","2512","_bbp_anonymous_email","uedqqvtd@smodxxmy.com");
INSERT INTO `wp_postmeta` VALUES("5097","2508","_bbp_anonymous_email","twgfsjyp@zdkllryv.com");
INSERT INTO `wp_postmeta` VALUES("5096","2508","_bbp_anonymous_name","alli pill");
INSERT INTO `wp_postmeta` VALUES("5056","2501","_bbp_anonymous_website","http://wellbutrin150mg.ga/#2137");
INSERT INTO `wp_postmeta` VALUES("5057","2501","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5058","2501","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5059","2501","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5060","2502","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("5061","2502","_bbp_anonymous_email","hhkowllk@nqpibhmp.com");
INSERT INTO `wp_postmeta` VALUES("5062","2502","_bbp_anonymous_website","http://buyviagra-softtabs.ga/#9156");
INSERT INTO `wp_postmeta` VALUES("5063","2502","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5064","2502","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5065","2502","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5066","2503","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5067","2503","_bbp_anonymous_email","ttipxfne@kynfdqog.com");
INSERT INTO `wp_postmeta` VALUES("5068","2503","_bbp_anonymous_website","http://finasteridemedication.tk/#4374");
INSERT INTO `wp_postmeta` VALUES("5069","2503","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5070","2503","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5071","2503","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5072","2504","_bbp_anonymous_name","order cialis online canada");
INSERT INTO `wp_postmeta` VALUES("5073","2504","_bbp_anonymous_email","uvqwxacx@xozjcqrt.com");
INSERT INTO `wp_postmeta` VALUES("5074","2504","_bbp_anonymous_website","http://ordercialisonline.ml/#9217");
INSERT INTO `wp_postmeta` VALUES("5075","2504","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5076","2504","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5077","2504","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5078","2505","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("5079","2505","_bbp_anonymous_email","ldmmdtkb@abincxzt.com");
INSERT INTO `wp_postmeta` VALUES("5080","2505","_bbp_anonymous_website","http://nexiumdrug.ga/#8307");
INSERT INTO `wp_postmeta` VALUES("5081","2505","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5082","2505","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5083","2505","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5084","2506","_bbp_anonymous_name","albuterol");
INSERT INTO `wp_postmeta` VALUES("5085","2506","_bbp_anonymous_email","zflbwxpp@ipsncgko.com");
INSERT INTO `wp_postmeta` VALUES("5086","2506","_bbp_anonymous_website","http://albuterol.in/#4987");
INSERT INTO `wp_postmeta` VALUES("5087","2506","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5088","2506","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5089","2506","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5090","2507","_bbp_anonymous_name","augmentin");
INSERT INTO `wp_postmeta` VALUES("5091","2507","_bbp_anonymous_email","zdpnhqbc@dkqwhuis.com");
INSERT INTO `wp_postmeta` VALUES("5092","2507","_bbp_anonymous_website","http://genericforaugmentin.pw/#1105");
INSERT INTO `wp_postmeta` VALUES("5093","2507","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5094","2507","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5095","2507","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5054","2501","_bbp_anonymous_name","buy wellbutrin xl");
INSERT INTO `wp_postmeta` VALUES("5040","2498","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5041","2498","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5042","2499","_bbp_anonymous_name","generic amitriptyline online");
INSERT INTO `wp_postmeta` VALUES("5043","2499","_bbp_anonymous_email","chvnpnjs@wmrucqvj.com");
INSERT INTO `wp_postmeta` VALUES("5044","2499","_bbp_anonymous_website","http://amitriptylinehcl25mgtab.cf/#5156");
INSERT INTO `wp_postmeta` VALUES("5045","2499","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5046","2499","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5047","2499","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5048","2500","_bbp_anonymous_name","generic for strattera");
INSERT INTO `wp_postmeta` VALUES("5049","2500","_bbp_anonymous_email","dafdpzfm@bkeuxuaw.com");
INSERT INTO `wp_postmeta` VALUES("5050","2500","_bbp_anonymous_website","http://purchasestattera.cf/#9429");
INSERT INTO `wp_postmeta` VALUES("5051","2500","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5052","2500","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5053","2500","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5039","2498","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5012","2494","_bbp_anonymous_name","zoloft generic");
INSERT INTO `wp_postmeta` VALUES("5013","2494","_bbp_anonymous_email","kosgxddr@aqzskijf.com");
INSERT INTO `wp_postmeta` VALUES("5014","2494","_bbp_anonymous_website","http://zoloftgeneric.ml/#5492");
INSERT INTO `wp_postmeta` VALUES("5015","2494","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5016","2494","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5017","2494","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5018","2495","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("5019","2495","_bbp_anonymous_email","vycokvyy@spooqlnd.com");
INSERT INTO `wp_postmeta` VALUES("5020","2495","_bbp_anonymous_website","http://lexapro5mg.ml/#1177");
INSERT INTO `wp_postmeta` VALUES("5021","2495","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5022","2495","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5023","2495","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5024","2496","_bbp_anonymous_name","nolvadex xt");
INSERT INTO `wp_postmeta` VALUES("5025","2496","_bbp_anonymous_email","hgjzqcgt@gmhlzpmc.com");
INSERT INTO `wp_postmeta` VALUES("5026","2496","_bbp_anonymous_website","http://nolvadex-xt.tk/#8189");
INSERT INTO `wp_postmeta` VALUES("5027","2496","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5028","2496","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5029","2496","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5030","2497","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("5031","2497","_bbp_anonymous_email","liglbgnt@joxkojst.com");
INSERT INTO `wp_postmeta` VALUES("5032","2497","_bbp_anonymous_website","http://mobic75mg.cf/#8592");
INSERT INTO `wp_postmeta` VALUES("5033","2497","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5034","2497","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5035","2497","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5036","2498","_bbp_anonymous_name","buy amoxicillin 500mg");
INSERT INTO `wp_postmeta` VALUES("5037","2498","_bbp_anonymous_email","fyhmxjuh@fxbxensw.com");
INSERT INTO `wp_postmeta` VALUES("5038","2498","_bbp_anonymous_website","http://buyamoxicillin500mg.ml/#8093");
INSERT INTO `wp_postmeta` VALUES("5009","2493","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4978","2488","_bbp_anonymous_website","http://tadalafil20mg.tk/#4051");
INSERT INTO `wp_postmeta` VALUES("4979","2488","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4980","2488","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4981","2488","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4982","2489","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4983","2489","_bbp_anonymous_email","gfkwwdgf@mvxzmmob.com");
INSERT INTO `wp_postmeta` VALUES("4984","2489","_bbp_anonymous_website","http://discountlevitra.cf/#7104");
INSERT INTO `wp_postmeta` VALUES("4985","2489","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4986","2489","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4987","2489","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4988","2490","_bbp_anonymous_name","visit website");
INSERT INTO `wp_postmeta` VALUES("4989","2490","_bbp_anonymous_email","wmspfxfk@vodhfewf.com");
INSERT INTO `wp_postmeta` VALUES("4990","2490","_bbp_anonymous_website","http://synthroid137mgwithoutprescription.ga/#1885");
INSERT INTO `wp_postmeta` VALUES("4991","2490","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4992","2490","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4993","2490","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4994","2491","_bbp_anonymous_name","alli tablets");
INSERT INTO `wp_postmeta` VALUES("4995","2491","_bbp_anonymous_email","ywipcsce@injahomg.com");
INSERT INTO `wp_postmeta` VALUES("4996","2491","_bbp_anonymous_website","http://allidrug.cf/#2013");
INSERT INTO `wp_postmeta` VALUES("4997","2491","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4998","2491","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4999","2491","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5000","2492","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("5001","2492","_bbp_anonymous_email","ouxbslfe@pqxmjeyy.com");
INSERT INTO `wp_postmeta` VALUES("5002","2492","_bbp_anonymous_website","http://cheapmobic.pw/#7021");
INSERT INTO `wp_postmeta` VALUES("5003","2492","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5004","2492","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5005","2492","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5006","2493","_bbp_anonymous_name","vermox");
INSERT INTO `wp_postmeta` VALUES("5007","2493","_bbp_anonymous_email","sffvchzt@zetqziuf.com");
INSERT INTO `wp_postmeta` VALUES("5008","2493","_bbp_anonymous_website","http://vermox.ml/#4299");
INSERT INTO `wp_postmeta` VALUES("4977","2488","_bbp_anonymous_email","wqmrutfl@jmfgwkug.com");
INSERT INTO `wp_postmeta` VALUES("4976","2488","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4917","2478","_bbp_anonymous_email","ldtjtxhh@ykcpzlgv.com");
INSERT INTO `wp_postmeta` VALUES("4918","2478","_bbp_anonymous_website","http://buy-doxycycline.tk/#2306");
INSERT INTO `wp_postmeta` VALUES("4919","2478","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4920","2478","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4921","2478","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4922","2479","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("4923","2479","_bbp_anonymous_email","sizihykr@lbnjtoil.com");
INSERT INTO `wp_postmeta` VALUES("4924","2479","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#9383");
INSERT INTO `wp_postmeta` VALUES("4925","2479","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4926","2479","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4927","2479","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4928","2480","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("4929","2480","_bbp_anonymous_email","lowkuiju@ssyozbxv.com");
INSERT INTO `wp_postmeta` VALUES("4930","2480","_bbp_anonymous_website","http://xenical-orlistat-120mg.cf/#8928");
INSERT INTO `wp_postmeta` VALUES("4931","2480","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4932","2480","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4933","2480","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4934","2481","_bbp_anonymous_name","diflucan");
INSERT INTO `wp_postmeta` VALUES("4935","2481","_bbp_anonymous_email","yngnaoym@wbsiiutw.com");
INSERT INTO `wp_postmeta` VALUES("4936","2481","_bbp_anonymous_website","http://diflucanfluconazole.tk/#2840");
INSERT INTO `wp_postmeta` VALUES("4937","2481","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4938","2481","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4939","2481","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4940","2482","_bbp_anonymous_name","hello");
INSERT INTO `wp_postmeta` VALUES("4941","2482","_bbp_anonymous_email","hmftzz@nkytcz.com");
INSERT INTO `wp_postmeta` VALUES("4942","2482","_bbp_anonymous_website","http://qzfzrr.com/");
INSERT INTO `wp_postmeta` VALUES("4943","2482","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4944","2482","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4945","2482","_bbp_author_ip","62.210.91.186");
INSERT INTO `wp_postmeta` VALUES("4946","2483","_bbp_anonymous_name","xenical where to buy");
INSERT INTO `wp_postmeta` VALUES("4947","2483","_bbp_anonymous_email","mllpuprx@mqnxfhwc.com");
INSERT INTO `wp_postmeta` VALUES("4948","2483","_bbp_anonymous_website","http://orlistat120mg.ga/#3043");
INSERT INTO `wp_postmeta` VALUES("4949","2483","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4950","2483","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4951","2483","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4952","2484","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("4953","2484","_bbp_anonymous_email","jlikpdzr@zqnnjohs.com");
INSERT INTO `wp_postmeta` VALUES("4954","2484","_bbp_anonymous_website","http://vardenafil.pw/#8154");
INSERT INTO `wp_postmeta` VALUES("4955","2484","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4956","2484","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4957","2484","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4958","2485","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4959","2485","_bbp_anonymous_email","jaakkuwd@nlqatbkq.com");
INSERT INTO `wp_postmeta` VALUES("4960","2485","_bbp_anonymous_website","http://levitracoupons.ga/#7458");
INSERT INTO `wp_postmeta` VALUES("4961","2485","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4962","2485","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4963","2485","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4964","2486","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4965","2486","_bbp_anonymous_email","wjleycbd@yxgfrbil.com");
INSERT INTO `wp_postmeta` VALUES("4966","2486","_bbp_anonymous_website","http://finasteride.ml/#3022");
INSERT INTO `wp_postmeta` VALUES("4967","2486","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4968","2486","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4969","2486","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4970","2487","_bbp_anonymous_name","effexor xr 150 mg");
INSERT INTO `wp_postmeta` VALUES("4971","2487","_bbp_anonymous_email","xmcjgoyw@luvzmtjm.com");
INSERT INTO `wp_postmeta` VALUES("4972","2487","_bbp_anonymous_website","http://effexorxr150mg.pw/#8218");
INSERT INTO `wp_postmeta` VALUES("4973","2487","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4974","2487","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4975","2487","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4911","2477","_bbp_anonymous_email","wfilotph@qniijmdh.com");
INSERT INTO `wp_postmeta` VALUES("4910","2477","_bbp_anonymous_name","men viagra");
INSERT INTO `wp_postmeta` VALUES("4846","2466","_bbp_anonymous_website","http://finasteride.ga/#2577");
INSERT INTO `wp_postmeta` VALUES("4847","2466","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4848","2466","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4849","2466","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4850","2467","_bbp_anonymous_name","furosemide");
INSERT INTO `wp_postmeta` VALUES("4851","2467","_bbp_anonymous_email","nppqedgp@itfqvsjs.com");
INSERT INTO `wp_postmeta` VALUES("4852","2467","_bbp_anonymous_website","http://furosemide40mgdiuretic.pw/#3077");
INSERT INTO `wp_postmeta` VALUES("4853","2467","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4854","2467","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4855","2467","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4856","2468","_bbp_anonymous_name","discount cialis");
INSERT INTO `wp_postmeta` VALUES("4857","2468","_bbp_anonymous_email","pdtbpnaa@boninmci.com");
INSERT INTO `wp_postmeta` VALUES("4858","2468","_bbp_anonymous_website","http://discountcialis.tk/#6516");
INSERT INTO `wp_postmeta` VALUES("4859","2468","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4860","2468","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4861","2468","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4862","2469","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("4863","2469","_bbp_anonymous_email","zwtavera@jvrhgjjh.com");
INSERT INTO `wp_postmeta` VALUES("4864","2469","_bbp_anonymous_website","http://lasixwaterpill.cf/#3073");
INSERT INTO `wp_postmeta` VALUES("4865","2469","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4866","2469","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4867","2469","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4868","2470","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4869","2470","_bbp_anonymous_email","ckocqwuc@dvsfoetg.com");
INSERT INTO `wp_postmeta` VALUES("4870","2470","_bbp_anonymous_website","http://buy-zithromax.info/#8152");
INSERT INTO `wp_postmeta` VALUES("4871","2470","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4872","2470","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4873","2470","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4874","2471","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("4875","2471","_bbp_anonymous_email","ethhiljt@lrnsvehk.com");
INSERT INTO `wp_postmeta` VALUES("4876","2471","_bbp_anonymous_website","http://amoxil-875.ml/#3052");
INSERT INTO `wp_postmeta` VALUES("4877","2471","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4878","2471","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4879","2471","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4880","2472","_bbp_anonymous_name","purchase levitra online");
INSERT INTO `wp_postmeta` VALUES("4881","2472","_bbp_anonymous_email","qplhrdps@gupnaszx.com");
INSERT INTO `wp_postmeta` VALUES("4882","2472","_bbp_anonymous_website","http://levitraprofessional20mg.tk/#7407");
INSERT INTO `wp_postmeta` VALUES("4883","2472","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4884","2472","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4885","2472","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4886","2473","_bbp_anonymous_name","cipro buy online");
INSERT INTO `wp_postmeta` VALUES("4887","2473","_bbp_anonymous_email","pqjjjqgu@tckegcqd.com");
INSERT INTO `wp_postmeta` VALUES("4888","2473","_bbp_anonymous_website","http://ciprocost.cf/#4711");
INSERT INTO `wp_postmeta` VALUES("4889","2473","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4890","2473","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4891","2473","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4892","2474","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("4893","2474","_bbp_anonymous_email","fjkjhvyx@pobsvvwr.com");
INSERT INTO `wp_postmeta` VALUES("4894","2474","_bbp_anonymous_website","http://genericsildenafil.us/#2165");
INSERT INTO `wp_postmeta` VALUES("4895","2474","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4896","2474","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4897","2474","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4898","2475","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("4899","2475","_bbp_anonymous_email","eapwxuyl@rarhvnyd.com");
INSERT INTO `wp_postmeta` VALUES("4900","2475","_bbp_anonymous_website","http://vardenafil-hydrochloride.ml/#3827");
INSERT INTO `wp_postmeta` VALUES("4901","2475","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4902","2475","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4903","2475","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4904","2476","_bbp_anonymous_name","cephalexin 500 mg capsules");
INSERT INTO `wp_postmeta` VALUES("4905","2476","_bbp_anonymous_email","molyjwwr@vwtxglew.com");
INSERT INTO `wp_postmeta` VALUES("4906","2476","_bbp_anonymous_website","http://keflexantibiotic.cf/#9800");
INSERT INTO `wp_postmeta` VALUES("4907","2476","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4908","2476","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4909","2476","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4845","2466","_bbp_anonymous_email","rpoamivw@pkigcqjy.com");
INSERT INTO `wp_postmeta` VALUES("4844","2466","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4823","2462","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4824","2462","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4825","2462","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4826","2463","_bbp_anonymous_name","generic sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("4827","2463","_bbp_anonymous_email","xudwyquj@cfglvfwu.com");
INSERT INTO `wp_postmeta` VALUES("4828","2463","_bbp_anonymous_website","http://generic-sildenafil-citrate.ga/#3882");
INSERT INTO `wp_postmeta` VALUES("4829","2463","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4830","2463","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4831","2463","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4832","2464","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("4833","2464","_bbp_anonymous_email","epdgkxdz@qgxtugbu.com");
INSERT INTO `wp_postmeta` VALUES("4834","2464","_bbp_anonymous_website","http://buyretinaonline.ml/#8235");
INSERT INTO `wp_postmeta` VALUES("4835","2464","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4836","2464","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4837","2464","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4838","2465","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("4839","2465","_bbp_anonymous_email","tozmeapd@bafufrsu.com");
INSERT INTO `wp_postmeta` VALUES("4840","2465","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#7310");
INSERT INTO `wp_postmeta` VALUES("4841","2465","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4842","2465","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4843","2465","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("2987","2160","_bbp_anonymous_email","$$$####*@gmail.com");
INSERT INTO `wp_postmeta` VALUES("2988","2160","_bbp_anonymous_website","http://www.fpggolfcenter.com.br/UserFiles/public/johnny-manziel-jersey-youth.html");
INSERT INTO `wp_postmeta` VALUES("2989","2160","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2990","2160","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("2991","2160","_bbp_author_ip","27.159.211.141");
INSERT INTO `wp_postmeta` VALUES("2992","2160","_bbp_last_reply_id","17153");
INSERT INTO `wp_postmeta` VALUES("2993","2160","_bbp_last_active_id","17153");
INSERT INTO `wp_postmeta` VALUES("2994","2160","_bbp_last_active_time","2015-03-27 04:19:09");
INSERT INTO `wp_postmeta` VALUES("2995","2160","_bbp_reply_count","173");
INSERT INTO `wp_postmeta` VALUES("2996","2160","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("2997","2160","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("2998","2161","_bbp_anonymous_name","Cheap NFL Jerseys Online");
INSERT INTO `wp_postmeta` VALUES("2999","2161","_bbp_anonymous_email","ecamfhtjw@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3000","2161","_bbp_anonymous_website","http://www.abcindustrial.co.uk/News/nflsaleonline.asp");
INSERT INTO `wp_postmeta` VALUES("3001","2161","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3002","2161","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3003","2161","_bbp_author_ip","27.159.211.141");
INSERT INTO `wp_postmeta` VALUES("3004","2161","_bbp_last_reply_id","19691");
INSERT INTO `wp_postmeta` VALUES("3005","2161","_bbp_last_active_id","19691");
INSERT INTO `wp_postmeta` VALUES("3006","2161","_bbp_last_active_time","2015-03-30 12:32:38");
INSERT INTO `wp_postmeta` VALUES("375","1167","header","yes");
INSERT INTO `wp_postmeta` VALUES("376","1167","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("377","1167","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("378","1167","_aviaLayoutBuilderCleanData","[av_sidebar widget_area=\'Contact\']

[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Contactez-nous !\' color=\'meta-heading\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_contact email=\'aurore.staiger@hotmail.fr\' button=\'Envoyer\' title=\'\' sent=\'Votre message a bien été envoyé!\' subject=\'\' autorespond=\'\' captcha=\'\']
[av_contact_field label=\'Nom\' type=\'text\' options=\'\' check=\'is_empty\' width=\'element_half\']
[av_contact_field label=\'E-Mail\' type=\'text\' options=\'\' check=\'is_email\' width=\'element_half\']
[av_contact_field label=\'Sujet de votre message\' type=\'text\' options=\'\' check=\'is_empty\' width=\'\']
[av_contact_field label=\'Message\' type=\'textarea\' options=\'\' check=\'is_empty\' width=\'\']
[/av_contact]

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1607","1639","_wp_attachment_metadata","a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:22:\"2013/04/favicon-01.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1063","734","_edit_lock","1429276061:5");
INSERT INTO `wp_postmeta` VALUES("379","1167","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("380","1167","sidebar","");
INSERT INTO `wp_postmeta` VALUES("381","1167","_avia_builder_shortcode_tree","a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:1;a:3:{s:3:\"tag\";s:10:\"av_contact\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:1;}}");
INSERT INTO `wp_postmeta` VALUES("1606","1639","_wp_attached_file","2013/04/favicon-01.png");
INSERT INTO `wp_postmeta` VALUES("1085","1407","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("6801","2792","_bbp_anonymous_email","qusskmzf@huhedpcf.com");
INSERT INTO `wp_postmeta` VALUES("6701","2775","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6702","2775","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6703","2775","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6704","2776","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("6705","2776","_bbp_anonymous_email","mdnnodai@owpkjmms.com");
INSERT INTO `wp_postmeta` VALUES("6706","2776","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#3872");
INSERT INTO `wp_postmeta` VALUES("6707","2776","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6708","2776","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6709","2776","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6710","2777","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("6711","2777","_bbp_anonymous_email","hwfsjzwk@bhzviamg.com");
INSERT INTO `wp_postmeta` VALUES("6712","2777","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#3929");
INSERT INTO `wp_postmeta` VALUES("6713","2777","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6714","2777","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6715","2777","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6716","2778","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("6717","2778","_bbp_anonymous_email","xrxrijtf@xmdmpbct.com");
INSERT INTO `wp_postmeta` VALUES("6718","2778","_bbp_anonymous_website","http://viagraonlinesales.pw/#6448");
INSERT INTO `wp_postmeta` VALUES("6719","2778","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6720","2778","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6721","2778","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6722","2779","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("6723","2779","_bbp_anonymous_email","avqfrpjq@cxyttkhb.com");
INSERT INTO `wp_postmeta` VALUES("6724","2779","_bbp_anonymous_website","http://buy-levitra.ga/#1079");
INSERT INTO `wp_postmeta` VALUES("6725","2779","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6726","2779","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6727","2779","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6728","2780","_bbp_anonymous_name","cheap cialis 5 mg");
INSERT INTO `wp_postmeta` VALUES("6729","2780","_bbp_anonymous_email","fwjnumeb@efqamwkt.com");
INSERT INTO `wp_postmeta` VALUES("6730","2780","_bbp_anonymous_website","http://cialis5mg.tk/#5748");
INSERT INTO `wp_postmeta` VALUES("6731","2780","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6732","2780","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6733","2780","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6734","2781","_bbp_anonymous_name","xenical 120mg");
INSERT INTO `wp_postmeta` VALUES("6735","2781","_bbp_anonymous_email","olqlxfsy@xkqdrcgb.com");
INSERT INTO `wp_postmeta` VALUES("6736","2781","_bbp_anonymous_website","http://xenical-120-mg.cf/#8264");
INSERT INTO `wp_postmeta` VALUES("6737","2781","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6738","2781","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6739","2781","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6740","2782","_bbp_anonymous_name","generic of accutane");
INSERT INTO `wp_postmeta` VALUES("6741","2782","_bbp_anonymous_email","jnvggtdl@ejvwdwkm.com");
INSERT INTO `wp_postmeta` VALUES("6742","2782","_bbp_anonymous_website","http://genericaccutane.nu/#8697");
INSERT INTO `wp_postmeta` VALUES("6743","2782","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6744","2782","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6745","2782","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6746","2783","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("6747","2783","_bbp_anonymous_email","cklalpeg@aeuijdbm.com");
INSERT INTO `wp_postmeta` VALUES("6748","2783","_bbp_anonymous_website","http://genericforcymbalta.ga/#1879");
INSERT INTO `wp_postmeta` VALUES("6749","2783","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6750","2783","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6751","2783","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6752","2784","_bbp_anonymous_name","tadalafil no prescription");
INSERT INTO `wp_postmeta` VALUES("6753","2784","_bbp_anonymous_email","wjocynmg@ukjnpmwi.com");
INSERT INTO `wp_postmeta` VALUES("6754","2784","_bbp_anonymous_website","http://tadalafil-no-prescription.cf/#8840");
INSERT INTO `wp_postmeta` VALUES("6755","2784","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6756","2784","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6757","2784","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6758","2785","_bbp_anonymous_name","lexapro 5mg");
INSERT INTO `wp_postmeta` VALUES("6759","2785","_bbp_anonymous_email","twnpqeid@ymcpsqng.com");
INSERT INTO `wp_postmeta` VALUES("6760","2785","_bbp_anonymous_website","http://lexapro5mg.ml/#5773");
INSERT INTO `wp_postmeta` VALUES("6761","2785","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6762","2785","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6763","2785","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6764","2786","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6765","2786","_bbp_anonymous_email","rnrpugml@rbloyixn.com");
INSERT INTO `wp_postmeta` VALUES("6766","2786","_bbp_anonymous_website","http://buy-mobic.tk/#6767");
INSERT INTO `wp_postmeta` VALUES("6767","2786","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6768","2786","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6769","2786","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6770","2787","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("6771","2787","_bbp_anonymous_email","zadycyzt@ealgzwic.com");
INSERT INTO `wp_postmeta` VALUES("6772","2787","_bbp_anonymous_website","http://cheapmobic.tk/#9700");
INSERT INTO `wp_postmeta` VALUES("6773","2787","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6774","2787","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6775","2787","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6776","2788","_bbp_anonymous_name","wellbutrin");
INSERT INTO `wp_postmeta` VALUES("6777","2788","_bbp_anonymous_email","yltcoqmn@kzbvvlks.com");
INSERT INTO `wp_postmeta` VALUES("6778","2788","_bbp_anonymous_website","http://wellbutrinmedication.cf/#4915");
INSERT INTO `wp_postmeta` VALUES("6779","2788","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6780","2788","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6781","2788","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6782","2789","_bbp_anonymous_name","cialus");
INSERT INTO `wp_postmeta` VALUES("6783","2789","_bbp_anonymous_email","jpkoawkq@jbjqmzcc.com");
INSERT INTO `wp_postmeta` VALUES("6784","2789","_bbp_anonymous_website","http://cialus.tk/#2740");
INSERT INTO `wp_postmeta` VALUES("6785","2789","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6786","2789","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6787","2789","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6788","2790","_bbp_anonymous_name","azithromycin zithromax");
INSERT INTO `wp_postmeta` VALUES("6789","2790","_bbp_anonymous_email","ossjdalk@ixlmxebl.com");
INSERT INTO `wp_postmeta` VALUES("6790","2790","_bbp_anonymous_website","http://buyzithromax.info/#4034");
INSERT INTO `wp_postmeta` VALUES("6791","2790","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6792","2790","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6793","2790","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6794","2791","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("6795","2791","_bbp_anonymous_email","xkbvghcm@jjpvogme.com");
INSERT INTO `wp_postmeta` VALUES("6796","2791","_bbp_anonymous_website","http://lasixwaterpill.cf/#3562");
INSERT INTO `wp_postmeta` VALUES("6797","2791","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6798","2791","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6799","2791","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6800","2792","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("6685","2772","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6686","2773","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6687","2773","_bbp_anonymous_email","xenkpmfm@qrudodqt.com");
INSERT INTO `wp_postmeta` VALUES("6688","2773","_bbp_anonymous_website","http://finasteridemedication.tk/#3326");
INSERT INTO `wp_postmeta` VALUES("6689","2773","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6690","2773","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6691","2773","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6692","2774","_bbp_anonymous_name","generic for augmentin");
INSERT INTO `wp_postmeta` VALUES("6693","2774","_bbp_anonymous_email","aggysrvk@xllwyqsx.com");
INSERT INTO `wp_postmeta` VALUES("6694","2774","_bbp_anonymous_website","http://genericforaugmentin.tk/#7947");
INSERT INTO `wp_postmeta` VALUES("6695","2774","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6696","2774","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6697","2774","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6698","2775","_bbp_anonymous_name","generic sildenafil citrate 100mg");
INSERT INTO `wp_postmeta` VALUES("6699","2775","_bbp_anonymous_email","hifptfvj@lzprhnne.com");
INSERT INTO `wp_postmeta` VALUES("6700","2775","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#2493");
INSERT INTO `wp_postmeta` VALUES("6684","2772","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4739","2448","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4740","2448","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4741","2448","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4742","2449","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4743","2449","_bbp_anonymous_email","egpswmsk@ugytnmlc.com");
INSERT INTO `wp_postmeta` VALUES("4744","2449","_bbp_anonymous_website","http://propeciahairgrowth.tk/#2519");
INSERT INTO `wp_postmeta` VALUES("4745","2449","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4746","2449","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4747","2449","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4748","2450","_bbp_anonymous_name","buy levitra online canada");
INSERT INTO `wp_postmeta` VALUES("4749","2450","_bbp_anonymous_email","tcrcfxbr@dijzvixx.com");
INSERT INTO `wp_postmeta` VALUES("4750","2450","_bbp_anonymous_website","http://buy-levitra.ga/#6560");
INSERT INTO `wp_postmeta` VALUES("4751","2450","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4752","2450","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4753","2450","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4754","2451","_bbp_anonymous_name","order generic viagra");
INSERT INTO `wp_postmeta` VALUES("4755","2451","_bbp_anonymous_email","wtmtzdgm@bwppocul.com");
INSERT INTO `wp_postmeta` VALUES("4756","2451","_bbp_anonymous_website","http://generic-viagra.info/#3832");
INSERT INTO `wp_postmeta` VALUES("4757","2451","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4758","2451","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4759","2451","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4760","2452","_bbp_anonymous_name","price of effexor");
INSERT INTO `wp_postmeta` VALUES("4761","2452","_bbp_anonymous_email","khndmbmy@bwapdqtn.com");
INSERT INTO `wp_postmeta` VALUES("4762","2452","_bbp_anonymous_website","http://venlafaxineeffexor.ml/#7436");
INSERT INTO `wp_postmeta` VALUES("4763","2452","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4764","2452","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4765","2452","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4766","2453","_bbp_anonymous_name","propecia hair growth");
INSERT INTO `wp_postmeta` VALUES("4767","2453","_bbp_anonymous_email","tawgrshj@shpfbrrm.com");
INSERT INTO `wp_postmeta` VALUES("4768","2453","_bbp_anonymous_website","http://propeciahairgrowth.ga/#7552");
INSERT INTO `wp_postmeta` VALUES("4769","2453","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4770","2453","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4771","2453","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4772","2454","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("4773","2454","_bbp_anonymous_email","iuuzwhvz@uvdhaklx.com");
INSERT INTO `wp_postmeta` VALUES("4774","2454","_bbp_anonymous_website","http://cheapmobic.tk/#5435");
INSERT INTO `wp_postmeta` VALUES("4775","2454","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4776","2454","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4777","2454","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4778","2455","_bbp_anonymous_name","purchase xenical");
INSERT INTO `wp_postmeta` VALUES("4779","2455","_bbp_anonymous_email","ftlhmtce@bwzghtne.com");
INSERT INTO `wp_postmeta` VALUES("4780","2455","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#9308");
INSERT INTO `wp_postmeta` VALUES("4781","2455","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4782","2455","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4783","2455","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4784","2456","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("4785","2456","_bbp_anonymous_email","ugxacoyf@lmjpikrn.com");
INSERT INTO `wp_postmeta` VALUES("4786","2456","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#9362");
INSERT INTO `wp_postmeta` VALUES("4787","2456","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4788","2456","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4789","2456","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4790","2457","_bbp_anonymous_name","buy cialis cheap online");
INSERT INTO `wp_postmeta` VALUES("4791","2457","_bbp_anonymous_email","uusteije@nlkfddic.com");
INSERT INTO `wp_postmeta` VALUES("4792","2457","_bbp_anonymous_website","http://buycialisonlinecheap.tk/#7788");
INSERT INTO `wp_postmeta` VALUES("4793","2457","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4794","2457","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4795","2457","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4796","2458","_bbp_anonymous_name","nexium drug");
INSERT INTO `wp_postmeta` VALUES("4797","2458","_bbp_anonymous_email","dweiajxq@mysmjlny.com");
INSERT INTO `wp_postmeta` VALUES("4798","2458","_bbp_anonymous_website","http://nexiumdrug.cf/#1281");
INSERT INTO `wp_postmeta` VALUES("4799","2458","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4800","2458","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4801","2458","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4802","2459","_bbp_anonymous_name","sildenafil generic");
INSERT INTO `wp_postmeta` VALUES("4803","2459","_bbp_anonymous_email","itererrc@goiiusgm.com");
INSERT INTO `wp_postmeta` VALUES("4804","2459","_bbp_anonymous_website","http://sildenafilgeneric.pw/#2208");
INSERT INTO `wp_postmeta` VALUES("4805","2459","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4806","2459","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4807","2459","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4808","2460","_bbp_anonymous_name","cymbalta generic");
INSERT INTO `wp_postmeta` VALUES("4809","2460","_bbp_anonymous_email","rzvmegth@fstlrrij.com");
INSERT INTO `wp_postmeta` VALUES("4810","2460","_bbp_anonymous_website","http://cymbaltageneric.ga/#9387");
INSERT INTO `wp_postmeta` VALUES("4811","2460","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4812","2460","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4813","2460","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4814","2461","_bbp_anonymous_name","viagr");
INSERT INTO `wp_postmeta` VALUES("4815","2461","_bbp_anonymous_email","hiabgdne@enyowvxd.com");
INSERT INTO `wp_postmeta` VALUES("4816","2461","_bbp_anonymous_website","http://viagr.ml/#7075");
INSERT INTO `wp_postmeta` VALUES("4817","2461","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4818","2461","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4819","2461","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4820","2462","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("4821","2462","_bbp_anonymous_email","xiblwmjn@gbzxddkt.com");
INSERT INTO `wp_postmeta` VALUES("4738","2448","_bbp_anonymous_website","http://retina005cream.ml/#7988");
INSERT INTO `wp_postmeta` VALUES("4737","2448","_bbp_anonymous_email","lphhenow@lklmqydr.com");
INSERT INTO `wp_postmeta` VALUES("4710","2443","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4711","2443","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4712","2444","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("4713","2444","_bbp_anonymous_email","sqkqqddk@qykwfrdi.com");
INSERT INTO `wp_postmeta` VALUES("4714","2444","_bbp_anonymous_website","http://generic-sildenafil.nu/#6432");
INSERT INTO `wp_postmeta` VALUES("4715","2444","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4716","2444","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4717","2444","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4718","2445","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("4719","2445","_bbp_anonymous_email","ccxykjhj@lxkfeqlu.com");
INSERT INTO `wp_postmeta` VALUES("4720","2445","_bbp_anonymous_website","http://alli-drug.cf/#7807");
INSERT INTO `wp_postmeta` VALUES("4721","2445","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4722","2445","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4723","2445","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4724","2446","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("4725","2446","_bbp_anonymous_email","fmthntwl@ziabntdw.com");
INSERT INTO `wp_postmeta` VALUES("4726","2446","_bbp_anonymous_website","http://generic-prozac.cf/#5404");
INSERT INTO `wp_postmeta` VALUES("4727","2446","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4728","2446","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4729","2446","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4730","2447","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4731","2447","_bbp_anonymous_email","tsmdjjhq@myiwvlgo.com");
INSERT INTO `wp_postmeta` VALUES("4732","2447","_bbp_anonymous_website","http://levitracheap.cf/#2338");
INSERT INTO `wp_postmeta` VALUES("4733","2447","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4734","2447","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4735","2447","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4736","2448","_bbp_anonymous_name","retin a 0.05 cream");
INSERT INTO `wp_postmeta` VALUES("4709","2443","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3418","2228","_bbp_anonymous_website","http://genericforcialis.ml/#5198");
INSERT INTO `wp_postmeta` VALUES("3417","2228","_bbp_anonymous_email","zulctxrc@lfemgxev.com");
INSERT INTO `wp_postmeta` VALUES("3411","2227","_bbp_anonymous_email","uaptfqwk@ooznhufs.com");
INSERT INTO `wp_postmeta` VALUES("3412","2227","_bbp_anonymous_website","http://buypropeciaonlinenorx.cf/#1947");
INSERT INTO `wp_postmeta` VALUES("3413","2227","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3414","2227","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3415","2227","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3416","2228","_bbp_anonymous_name","generic for cialis");
INSERT INTO `wp_postmeta` VALUES("2439","2009","_wp_attached_file","2013/04/S.Daycard-Heid-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2440","2009","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:1176;s:4:\"file\";s:28:\"2013/04/S.Daycard-Heid-1.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-1-733x1030.jpg\";s:5:\"width\";i:733;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-501x705.jpg\";s:5:\"width\";i:501;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x632.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:632;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2548","2034","_wp_attached_file","2014/05/logos-allier-01.png");
INSERT INTO `wp_postmeta` VALUES("2441","2011","_wp_attached_file","2013/04/S.Daycard-Heid-11.jpg");
INSERT INTO `wp_postmeta` VALUES("2442","2011","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:738;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-11.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-300x264.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-705x621.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:621;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x396.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3410","2227","_bbp_anonymous_name","cheap propecia for sale");
INSERT INTO `wp_postmeta` VALUES("3409","2226","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3408","2226","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3365","2219","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3364","2219","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#9720");
INSERT INTO `wp_postmeta` VALUES("3363","2219","_bbp_anonymous_email","tjrijtmc@ocumlkuq.com");
INSERT INTO `wp_postmeta` VALUES("3164","2186","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("3163","2185","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3162","2185","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3161","2185","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3154","2184","_bbp_anonymous_website","http://viagrasofttabs.nu/generic-viagra-soft-tabs.html#6519");
INSERT INTO `wp_postmeta` VALUES("3155","2184","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3156","2184","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3157","2184","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3158","2185","_bbp_anonymous_name","hydrochlorothiazide 25 mg for sale");
INSERT INTO `wp_postmeta` VALUES("3159","2185","_bbp_anonymous_email","hrqayepv@xxplmbdi.com");
INSERT INTO `wp_postmeta` VALUES("3160","2185","_bbp_anonymous_website","http://hydrochlorothiazide.se/hydrochlorothiazide-for-sale.html#4810");
INSERT INTO `wp_postmeta` VALUES("3407","2226","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3406","2226","_bbp_anonymous_website","http://vermox-500.cf/#1491");
INSERT INTO `wp_postmeta` VALUES("3400","2225","_bbp_anonymous_website","http://zoloftdrug.tk/#7500");
INSERT INTO `wp_postmeta` VALUES("3401","2225","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3402","2225","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3403","2225","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3404","2226","_bbp_anonymous_name","buy vermox");
INSERT INTO `wp_postmeta` VALUES("3405","2226","_bbp_anonymous_email","deeizvcs@cxeznies.com");
INSERT INTO `wp_postmeta` VALUES("3275","2204","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3276","2204","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3277","2204","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3278","2205","_bbp_anonymous_name","hydrochlorothiazide 37.5");
INSERT INTO `wp_postmeta` VALUES("3279","2205","_bbp_anonymous_email","lpqzwkzg@ruwusmic.com");
INSERT INTO `wp_postmeta` VALUES("3280","2205","_bbp_anonymous_website","http://hydrochlorothiazide.se/#4882");
INSERT INTO `wp_postmeta` VALUES("3281","2205","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3282","2205","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3283","2205","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3284","2206","_bbp_anonymous_name","cipro");
INSERT INTO `wp_postmeta` VALUES("3285","2206","_bbp_anonymous_email","nriqxeud@taxvnwdx.com");
INSERT INTO `wp_postmeta` VALUES("3286","2206","_bbp_anonymous_website","http://cipro.in/#8757");
INSERT INTO `wp_postmeta` VALUES("3287","2206","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3288","2206","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3289","2206","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3290","2207","_bbp_anonymous_name","buy nolvadex online");
INSERT INTO `wp_postmeta` VALUES("3291","2207","_bbp_anonymous_email","snxtdbvf@sduvfkvg.com");
INSERT INTO `wp_postmeta` VALUES("3292","2207","_bbp_anonymous_website","http://buy-nolvadex.info/#2160");
INSERT INTO `wp_postmeta` VALUES("3293","2207","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3294","2207","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3295","2207","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3296","2208","_bbp_anonymous_name","accutane cost");
INSERT INTO `wp_postmeta` VALUES("3297","2208","_bbp_anonymous_email","ceimbjrw@xibopduf.com");
INSERT INTO `wp_postmeta` VALUES("3298","2208","_bbp_anonymous_website","http://genericaccutane.in/#3874");
INSERT INTO `wp_postmeta` VALUES("3299","2208","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3300","2208","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3301","2208","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3302","2209","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("3303","2209","_bbp_anonymous_email","wcacazpw@nmyuunyr.com");
INSERT INTO `wp_postmeta` VALUES("3304","2209","_bbp_anonymous_website","http://genericsildenafil.nu/#8537");
INSERT INTO `wp_postmeta` VALUES("3305","2209","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3306","2209","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3307","2209","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3308","2210","_bbp_anonymous_name","viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3309","2210","_bbp_anonymous_email","dvjokltk@zsbiwzjs.com");
INSERT INTO `wp_postmeta` VALUES("3310","2210","_bbp_anonymous_website","http://viagrasofttabs.nu/#8988");
INSERT INTO `wp_postmeta` VALUES("3311","2210","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3312","2210","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3313","2210","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3314","2211","_bbp_anonymous_name","viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3315","2211","_bbp_anonymous_email","qrkcgcdy@pmgumalt.com");
INSERT INTO `wp_postmeta` VALUES("3316","2211","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#1414");
INSERT INTO `wp_postmeta` VALUES("3317","2211","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3318","2211","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3319","2211","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3320","2212","_bbp_anonymous_name","viagra online");
INSERT INTO `wp_postmeta` VALUES("3321","2212","_bbp_anonymous_email","ykgaomgv@lipxkejq.com");
INSERT INTO `wp_postmeta` VALUES("3322","2212","_bbp_anonymous_website","http://genericsildenafil.nu/#2714");
INSERT INTO `wp_postmeta` VALUES("3323","2212","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3324","2212","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3325","2212","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3326","2213","_bbp_anonymous_name","hydrochlorothiazide");
INSERT INTO `wp_postmeta` VALUES("3327","2213","_bbp_anonymous_email","xqmtbuwu@foreexzb.com");
INSERT INTO `wp_postmeta` VALUES("3328","2213","_bbp_anonymous_website","http://hydrochlorothiazide.se/#6806");
INSERT INTO `wp_postmeta` VALUES("3329","2213","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3330","2213","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3331","2213","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3332","2214","_bbp_anonymous_name","clomid online pharmacy");
INSERT INTO `wp_postmeta` VALUES("3333","2214","_bbp_anonymous_email","ordgadhb@jbthrrwm.com");
INSERT INTO `wp_postmeta` VALUES("3334","2214","_bbp_anonymous_website","http://clomid.in/#6173");
INSERT INTO `wp_postmeta` VALUES("3335","2214","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3336","2214","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3337","2214","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3338","2215","_bbp_anonymous_name","low cost generic viagra");
INSERT INTO `wp_postmeta` VALUES("3339","2215","_bbp_anonymous_email","snhngfsu@nqaipsha.com");
INSERT INTO `wp_postmeta` VALUES("3340","2215","_bbp_anonymous_website","http://buyviagraonline.ml/#8540");
INSERT INTO `wp_postmeta` VALUES("3341","2215","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3342","2215","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3343","2215","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3344","2216","_bbp_anonymous_name","accutane online");
INSERT INTO `wp_postmeta` VALUES("3345","2216","_bbp_anonymous_email","igyhcetk@nkkpdglk.com");
INSERT INTO `wp_postmeta` VALUES("3346","2216","_bbp_anonymous_website","http://genericaccutane.in/#5937");
INSERT INTO `wp_postmeta` VALUES("3347","2216","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3348","2216","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3349","2216","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3350","2217","_bbp_anonymous_name","buy propecia online");
INSERT INTO `wp_postmeta` VALUES("3351","2217","_bbp_anonymous_email","jqywwcjx@gajskpln.com");
INSERT INTO `wp_postmeta` VALUES("3352","2217","_bbp_anonymous_website","http://genericpropecia.nu/#7716");
INSERT INTO `wp_postmeta` VALUES("3353","2217","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3354","2217","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3355","2217","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3356","2218","_bbp_anonymous_name","generic alli");
INSERT INTO `wp_postmeta` VALUES("3357","2218","_bbp_anonymous_email","gwgoxwjm@bcjqzcqj.com");
INSERT INTO `wp_postmeta` VALUES("3358","2218","_bbp_anonymous_website","http://allipills.tk/#7960");
INSERT INTO `wp_postmeta` VALUES("3359","2218","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3360","2218","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3361","2218","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3362","2219","_bbp_anonymous_name","buy viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("422","1248","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("423","1248","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("424","1248","sidebar","");
INSERT INTO `wp_postmeta` VALUES("425","1248","header","yes");
INSERT INTO `wp_postmeta` VALUES("426","1248","_avia_builder_shortcode_tree","a:31:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:5;}i:3;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}}s:5:\"index\";i:8;}i:4;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}i:5;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:6;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:14;}i:7;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:19;}}s:5:\"index\";i:17;}i:8;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:21;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:20;}i:9;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:24;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:25;}}s:5:\"index\";i:23;}i:10;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:27;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:28;}}s:5:\"index\";i:26;}i:11;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:30;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:31;}}s:5:\"index\";i:29;}i:12;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:32;}i:13;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:34;}}s:5:\"index\";i:33;}i:14;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:35;}i:15;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:37;}}s:5:\"index\";i:36;}i:16;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:39;}}s:5:\"index\";i:38;}i:17;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:41;}}s:5:\"index\";i:40;}i:18;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:43;}}s:5:\"index\";i:42;}i:19;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:45;}}s:5:\"index\";i:44;}i:20;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:47;}}s:5:\"index\";i:46;}i:21;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:48;}i:22;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:50;}}s:5:\"index\";i:49;}i:23;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:51;}i:24;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:53;}}s:5:\"index\";i:52;}i:25;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:55;}}s:5:\"index\";i:54;}i:26;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:56;}i:27;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:58;}}s:5:\"index\";i:57;}i:28;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:59;}i:29;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:61;}}s:5:\"index\";i:60;}i:30;a:3:{s:3:\"tag\";s:9:\"av_button\";s:7:\"content\";a:0:{}s:5:\"index\";i:62;}}");
INSERT INTO `wp_postmeta` VALUES("1462","1248","footer","");
INSERT INTO `wp_postmeta` VALUES("1751","1734","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1752","1734","_menu_item_orphaned","1399370100");
INSERT INTO `wp_postmeta` VALUES("427","1248","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("428","1248","_aviaLayoutBuilderCleanData","[av_one_full first]
[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'JEUDI 2 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\']
Durant ces deux journée des jeunes “facilitateurs” polyglottes du CUEJ ou de European Youthpress seront présents accueillir et guider les participants.
[/av_icon_box]

[av_one_half first]
[av_heading heading=\'9h30 : Accueil et Ice breaker coffee\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\' attachment=\'1474\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_heading heading=\'10h30 : Réu de lancement Kick off meeting\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\' attachment=\'1485\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h00 : Ateliers flash partage de compétences Sharing skills\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'\' attachment=\'\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'L’apport du multimédia\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Laurent Gontier (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/GieffersHanna-2015-300x300.jpeg\' attachment=\'19703\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le webdocumentaire\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Hanna Gieffers (Allemagne)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/GuadagniTommaso-2015-300x300.jpg\' attachment=\'19702\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Datajournalisme\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Tommaso Guadagni

[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/MartiniereMathieu-2015-300x300.jpg\' attachment=\'19704\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réussir un crowfunding\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'2\']
Mathieu Martinière (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/StrassenburgRomy-2015-296x300.jpg\' attachment=\'19705\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Bien vendre ses piges\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Romy Strassenburg (Allemagne)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/SansonStern-2014-287x300.jpg\' attachment=\'19706\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réseaux sociaux\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Catherine Sanson-Stern (France)
[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/VallellianPatrick-2015-298x300.jpg\' attachment=\'19707\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le long format\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Patrick Vallelian (Suisse)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2015/04/WildNicolas-2015-300x300.jpg\' attachment=\'19710\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'La BD-reportage\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Nicolas Wild (France)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/BulligPaula-2015-300x299.jpg\' attachment=\'19709\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'La BD-reportage\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Paula Bullig (Allemagne)
[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'13h : Déjeuner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'14h30 : Workshop Créer un nouveau média en 2h ? C’est possible ! (Ou presque)\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
En mode « Media Lab », les participants se répartissent en 4 groupes thématiques à l’intérieur desquels ils s’organisent en équipes aux compétences complémentaires.
Guidés par des modérateurs de Profession Pigiste, avec Romain Saillet comme référent, chaque équipe élabore le squelette d’un projet éditorial.

[/av_heading]
[/av_one_full]

[av_one_fourth first]
[av_icon_box icon=\'ue80d\' font=\'entypo-fontello\' position=\'left\' title=\'Webdocumentaire\' link=\'\' linktarget=\'\' linkelement=\'\']Cliquer ici pour ajouter votre propre texte

[/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue83b\' font=\'entypo-fontello\' position=\'left\' title=\'Reportage\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue8ab\' font=\'entypo-fontello\' position=\'left\' title=\'Journalisme de données\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue833\' font=\'entypo-fontello\' position=\'left\' title=\'Long format\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h30 : Pause\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'17h : Présentation de l’Afdas\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'10\' heading=\'17h20 : Restitution des ateliers\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Chaque équipe a cinq minutes pour « pitcher » le projet sur lequel elle a travaillé et le présenter aux participants de son groupe. Chaque groupe élit le meilleur projet.
[/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'18h20 : Un moment de liberté\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'19h : Apéritif\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'20h30 : Dîner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec une intervention de Gabriele Bertolli, de la direction générale de la DG Connect à la Commission européenne.
[/av_heading]

[av_button label=\'Voir le programme du vendredi\' link=\'page,1720\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'right\' icon_select=\'yes\' icon=\'ue832\' font=\'entypo-fontello\']

");
INSERT INTO `wp_postmeta` VALUES("1475","1574","_wp_attached_file","2013/04/48hbyPP.png");
INSERT INTO `wp_postmeta` VALUES("1476","1574","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1146;s:6:\"height\";i:606;s:4:\"file\";s:19:\"2013/04/48hbyPP.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"48hbyPP-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"48hbyPP-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x544.png\";s:5:\"width\";i:1030;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"48hbyPP-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"48hbyPP-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1146x430.png\";s:5:\"width\";i:1146;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"48hbyPP-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"48hbyPP-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"48hbyPP-705x372.png\";s:5:\"width\";i:705;s:6:\"height\";i:372;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"48hbyPP-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x237.png\";s:5:\"width\";i:450;s:6:\"height\";i:237;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1750","1734","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1749","1734","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1748","1734","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("429","1248","_dp_original","1236");
INSERT INTO `wp_postmeta` VALUES("4706","2443","_bbp_anonymous_name","levitra 20 mg price");
INSERT INTO `wp_postmeta` VALUES("4705","2442","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4693","2440","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4694","2441","_bbp_anonymous_name","purchase vardenafil");
INSERT INTO `wp_postmeta` VALUES("4695","2441","_bbp_anonymous_email","kjdnktwz@muxklcqk.com");
INSERT INTO `wp_postmeta` VALUES("4696","2441","_bbp_anonymous_website","http://generic-vardenafil.tk/#9144");
INSERT INTO `wp_postmeta` VALUES("4697","2441","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4698","2441","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4699","2441","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4700","2442","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("4701","2442","_bbp_anonymous_email","toiyrnkh@omivxvls.com");
INSERT INTO `wp_postmeta` VALUES("4702","2442","_bbp_anonymous_website","http://allipills.pw/#9004");
INSERT INTO `wp_postmeta` VALUES("4703","2442","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4704","2442","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4692","2440","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4674","2437","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4675","2437","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4676","2438","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("4677","2438","_bbp_anonymous_email","yeudausw@dcfzqzdx.com");
INSERT INTO `wp_postmeta` VALUES("4678","2438","_bbp_anonymous_website","http://prozac.in/#4734");
INSERT INTO `wp_postmeta` VALUES("4679","2438","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4680","2438","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4681","2438","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4682","2439","_bbp_anonymous_name","wellbutrin no prescription");
INSERT INTO `wp_postmeta` VALUES("4683","2439","_bbp_anonymous_email","gmghflhv@nwsmywkb.com");
INSERT INTO `wp_postmeta` VALUES("4684","2439","_bbp_anonymous_website","http://wellbutrin150mg.tk/#6426");
INSERT INTO `wp_postmeta` VALUES("4685","2439","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4686","2439","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4687","2439","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4688","2440","_bbp_anonymous_name","generic celexa");
INSERT INTO `wp_postmeta` VALUES("4689","2440","_bbp_anonymous_email","wahxxaap@moqtbeeb.com");
INSERT INTO `wp_postmeta` VALUES("4690","2440","_bbp_anonymous_website","http://celexageneric.ml/#4641");
INSERT INTO `wp_postmeta` VALUES("4691","2440","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4673","2437","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4671","2437","_bbp_anonymous_email","ypzuuser@gntpdcex.com");
INSERT INTO `wp_postmeta` VALUES("4670","2437","_bbp_anonymous_name","cost of xenical");
INSERT INTO `wp_postmeta` VALUES("4551","2417","_bbp_anonymous_email","vqcsxegv@qkcjgqdh.com");
INSERT INTO `wp_postmeta` VALUES("4552","2417","_bbp_anonymous_website","http://accutaneforsale.ml/#8976");
INSERT INTO `wp_postmeta` VALUES("4553","2417","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4554","2417","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4555","2417","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4556","2418","_bbp_anonymous_name","order amoxil online");
INSERT INTO `wp_postmeta` VALUES("4557","2418","_bbp_anonymous_email","fyhuwmut@qoykcsxm.com");
INSERT INTO `wp_postmeta` VALUES("4558","2418","_bbp_anonymous_website","http://amoxil.in/#3051");
INSERT INTO `wp_postmeta` VALUES("4559","2418","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4560","2418","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4561","2418","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4562","2419","_bbp_anonymous_name","generic sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("4563","2419","_bbp_anonymous_email","bisubzhm@dqqsrzrm.com");
INSERT INTO `wp_postmeta` VALUES("4564","2419","_bbp_anonymous_website","http://genericsildenafilcitrate.ml/#2549");
INSERT INTO `wp_postmeta` VALUES("4565","2419","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4566","2419","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4567","2419","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4568","2420","_bbp_anonymous_name","viagra online sales");
INSERT INTO `wp_postmeta` VALUES("4569","2420","_bbp_anonymous_email","zrnpslcw@dpznvmmh.com");
INSERT INTO `wp_postmeta` VALUES("4570","2420","_bbp_anonymous_website","http://viagraonlinesales.pw/#8993");
INSERT INTO `wp_postmeta` VALUES("4571","2420","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4572","2420","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4573","2420","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4574","2421","_bbp_anonymous_name","sildenafil otc");
INSERT INTO `wp_postmeta` VALUES("4575","2421","_bbp_anonymous_email","mcplpfpt@kbywyykc.com");
INSERT INTO `wp_postmeta` VALUES("4576","2421","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#2951");
INSERT INTO `wp_postmeta` VALUES("4577","2421","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4578","2421","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4579","2421","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4580","2422","_bbp_anonymous_name","celebrex prices");
INSERT INTO `wp_postmeta` VALUES("4581","2422","_bbp_anonymous_email","zmzzzjzy@rxchsfsk.com");
INSERT INTO `wp_postmeta` VALUES("4582","2422","_bbp_anonymous_website","http://celebrexcost.ml/#1986");
INSERT INTO `wp_postmeta` VALUES("4583","2422","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4584","2422","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4585","2422","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4586","2423","_bbp_anonymous_name","buy cialis online cheap");
INSERT INTO `wp_postmeta` VALUES("4587","2423","_bbp_anonymous_email","nkikxrtu@elnyztvc.com");
INSERT INTO `wp_postmeta` VALUES("4588","2423","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#8558");
INSERT INTO `wp_postmeta` VALUES("4589","2423","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4590","2423","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4591","2423","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4592","2424","_bbp_anonymous_name","buy prednisone without a prescription");
INSERT INTO `wp_postmeta` VALUES("4593","2424","_bbp_anonymous_email","ekgxmvkj@yehibexn.com");
INSERT INTO `wp_postmeta` VALUES("4594","2424","_bbp_anonymous_website","http://prednisone20mgmedication.cf/#5157");
INSERT INTO `wp_postmeta` VALUES("4595","2424","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4596","2424","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4597","2424","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4598","2425","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("4599","2425","_bbp_anonymous_email","qyqelbft@efczagrq.com");
INSERT INTO `wp_postmeta` VALUES("4600","2425","_bbp_anonymous_website","http://advair-diskus.ml/#4940");
INSERT INTO `wp_postmeta` VALUES("4601","2425","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4602","2425","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4603","2425","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4604","2426","_bbp_anonymous_name","generic accutane");
INSERT INTO `wp_postmeta` VALUES("4605","2426","_bbp_anonymous_email","wsoitsgc@rdmvxfkn.com");
INSERT INTO `wp_postmeta` VALUES("4606","2426","_bbp_anonymous_website","http://genericaccutane.nu/#9592");
INSERT INTO `wp_postmeta` VALUES("4607","2426","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4608","2426","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4609","2426","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4610","2427","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4611","2427","_bbp_anonymous_email","upvpmkxu@acooexjj.com");
INSERT INTO `wp_postmeta` VALUES("4612","2427","_bbp_anonymous_website","http://zithromaxzpack.ml/#5163");
INSERT INTO `wp_postmeta` VALUES("4613","2427","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4614","2427","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4615","2427","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4616","2428","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4617","2428","_bbp_anonymous_email","doiojtlo@fczkmcht.com");
INSERT INTO `wp_postmeta` VALUES("4618","2428","_bbp_anonymous_website","http://cialisprescription.ml/#2064");
INSERT INTO `wp_postmeta` VALUES("4619","2428","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4620","2428","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4621","2428","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4622","2429","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("4623","2429","_bbp_anonymous_email","dteoouhv@rphwnlgl.com");
INSERT INTO `wp_postmeta` VALUES("4624","2429","_bbp_anonymous_website","http://buymobic.se/#6888");
INSERT INTO `wp_postmeta` VALUES("4625","2429","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4626","2429","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4627","2429","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4628","2430","_bbp_anonymous_name","clindamycin");
INSERT INTO `wp_postmeta` VALUES("4629","2430","_bbp_anonymous_email","pfurgqjh@qrlvnqks.com");
INSERT INTO `wp_postmeta` VALUES("4630","2430","_bbp_anonymous_website","http://cleocint.tk/#2865");
INSERT INTO `wp_postmeta` VALUES("4631","2430","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4632","2430","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4633","2430","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4634","2431","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4635","2431","_bbp_anonymous_email","bzzolrrf@dblbnfni.com");
INSERT INTO `wp_postmeta` VALUES("4636","2431","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#6562");
INSERT INTO `wp_postmeta` VALUES("4637","2431","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4638","2431","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4639","2431","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4640","2432","_bbp_anonymous_name","doxy 200");
INSERT INTO `wp_postmeta` VALUES("4641","2432","_bbp_anonymous_email","tqftblhv@tpcyuaoo.com");
INSERT INTO `wp_postmeta` VALUES("4642","2432","_bbp_anonymous_website","http://doxy.cf/#1974");
INSERT INTO `wp_postmeta` VALUES("4643","2432","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4644","2432","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4645","2432","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4646","2433","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("4647","2433","_bbp_anonymous_email","wtddbqrb@mplhjxhv.com");
INSERT INTO `wp_postmeta` VALUES("4648","2433","_bbp_anonymous_website","http://buyventolininhaler.cf/#3534");
INSERT INTO `wp_postmeta` VALUES("4649","2433","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4650","2433","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4651","2433","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4652","2434","_bbp_anonymous_name","alli 120");
INSERT INTO `wp_postmeta` VALUES("4653","2434","_bbp_anonymous_email","kymybnwe@tihythwh.com");
INSERT INTO `wp_postmeta` VALUES("4654","2434","_bbp_anonymous_website","http://alli-120.cf/#8219");
INSERT INTO `wp_postmeta` VALUES("4655","2434","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4656","2434","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4657","2434","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4658","2435","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("4659","2435","_bbp_anonymous_email","znzvtkpt@oncprzoa.com");
INSERT INTO `wp_postmeta` VALUES("4660","2435","_bbp_anonymous_website","http://celebrex200.cf/#7731");
INSERT INTO `wp_postmeta` VALUES("4661","2435","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4662","2435","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4663","2435","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4664","2436","_bbp_anonymous_name","alli buy");
INSERT INTO `wp_postmeta` VALUES("4665","2436","_bbp_anonymous_email","dekmwono@fmwdsqnm.com");
INSERT INTO `wp_postmeta` VALUES("4666","2436","_bbp_anonymous_website","http://alli-diet-pill.cf/#4584");
INSERT INTO `wp_postmeta` VALUES("4667","2436","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4668","2436","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4669","2436","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4550","2417","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4536","2414","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4537","2414","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4538","2415","_bbp_anonymous_name","how much is doxycycline");
INSERT INTO `wp_postmeta` VALUES("4539","2415","_bbp_anonymous_email","gtumhice@pfelativ.com");
INSERT INTO `wp_postmeta` VALUES("4540","2415","_bbp_anonymous_website","http://buy-doxycycline.us/#2960");
INSERT INTO `wp_postmeta` VALUES("4541","2415","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4542","2415","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4543","2415","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4544","2416","_bbp_anonymous_name","generic lexapro");
INSERT INTO `wp_postmeta` VALUES("4545","2416","_bbp_anonymous_email","lzblszit@napahgfc.com");
INSERT INTO `wp_postmeta` VALUES("4546","2416","_bbp_anonymous_website","http://generic-lexapro.cf/#3564");
INSERT INTO `wp_postmeta` VALUES("4547","2416","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4548","2416","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4549","2416","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4427","2396","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4428","2396","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4429","2396","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4430","2397","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("4431","2397","_bbp_anonymous_email","ewdrlgpm@pytkxrap.com");
INSERT INTO `wp_postmeta` VALUES("4432","2397","_bbp_anonymous_website","http://cheapnexium.tk/#6469");
INSERT INTO `wp_postmeta` VALUES("4433","2397","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4434","2397","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4435","2397","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4436","2398","_bbp_anonymous_name","accutane 30mg");
INSERT INTO `wp_postmeta` VALUES("4437","2398","_bbp_anonymous_email","rgjusuir@iqchnddz.com");
INSERT INTO `wp_postmeta` VALUES("4438","2398","_bbp_anonymous_website","http://buyaccutaneonline.tk/#3590");
INSERT INTO `wp_postmeta` VALUES("4439","2398","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4440","2398","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4441","2398","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4442","2399","_bbp_anonymous_name","more information");
INSERT INTO `wp_postmeta` VALUES("4443","2399","_bbp_anonymous_email","pdcsiobd@oaihwtnj.com");
INSERT INTO `wp_postmeta` VALUES("4444","2399","_bbp_anonymous_website","http://furosemide-40-mg-diuretic.cf/#1968");
INSERT INTO `wp_postmeta` VALUES("4445","2399","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4446","2399","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4447","2399","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4448","2400","_bbp_anonymous_name","purchase wellbutrin online");
INSERT INTO `wp_postmeta` VALUES("4449","2400","_bbp_anonymous_email","opjjhvkg@tlkbktdj.com");
INSERT INTO `wp_postmeta` VALUES("4450","2400","_bbp_anonymous_website","http://wellbutrinxl300mg.ml/#3334");
INSERT INTO `wp_postmeta` VALUES("4451","2400","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4452","2400","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4453","2400","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4454","2401","_bbp_anonymous_name","lexapro generic");
INSERT INTO `wp_postmeta` VALUES("4455","2401","_bbp_anonymous_email","crmshidx@izhjrlys.com");
INSERT INTO `wp_postmeta` VALUES("4456","2401","_bbp_anonymous_website","http://lexaprogeneric.ga/#5733");
INSERT INTO `wp_postmeta` VALUES("4457","2401","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4458","2401","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4459","2401","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4460","2402","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4461","2402","_bbp_anonymous_email","lrfkfryy@wrsajcqm.com");
INSERT INTO `wp_postmeta` VALUES("4462","2402","_bbp_anonymous_website","http://cialisforsaleonline.tk/#3201");
INSERT INTO `wp_postmeta` VALUES("4463","2402","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4464","2402","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4465","2402","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4466","2403","_bbp_anonymous_name","generic of augmentin");
INSERT INTO `wp_postmeta` VALUES("4467","2403","_bbp_anonymous_email","orhjgzcl@ubystdro.com");
INSERT INTO `wp_postmeta` VALUES("4468","2403","_bbp_anonymous_website","http://genericforaugmentin.tk/#3530");
INSERT INTO `wp_postmeta` VALUES("4469","2403","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4470","2403","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4471","2403","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4472","2404","_bbp_anonymous_name","where to get cialis online");
INSERT INTO `wp_postmeta` VALUES("4473","2404","_bbp_anonymous_email","yxokvfum@vecjiasr.com");
INSERT INTO `wp_postmeta` VALUES("4474","2404","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#1050");
INSERT INTO `wp_postmeta` VALUES("4475","2404","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4476","2404","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4477","2404","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4478","2405","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("4479","2405","_bbp_anonymous_email","graqnxfd@gtljoryj.com");
INSERT INTO `wp_postmeta` VALUES("4480","2405","_bbp_anonymous_website","http://cephalexin500.cf/#4328");
INSERT INTO `wp_postmeta` VALUES("4481","2405","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4482","2405","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4483","2405","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4484","2406","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("4485","2406","_bbp_anonymous_email","egyecibe@wuetkkwb.com");
INSERT INTO `wp_postmeta` VALUES("4486","2406","_bbp_anonymous_website","http://zoloft200mg.tk/#2572");
INSERT INTO `wp_postmeta` VALUES("4487","2406","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4488","2406","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4489","2406","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4490","2407","_bbp_anonymous_name","synthroid cost");
INSERT INTO `wp_postmeta` VALUES("4491","2407","_bbp_anonymous_email","nkqnuagf@uhsewwka.com");
INSERT INTO `wp_postmeta` VALUES("4492","2407","_bbp_anonymous_website","http://synthroid-generic.tk/#3175");
INSERT INTO `wp_postmeta` VALUES("4493","2407","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4494","2407","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4495","2407","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4496","2408","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4497","2408","_bbp_anonymous_email","mdoocasw@uggfwsou.com");
INSERT INTO `wp_postmeta` VALUES("4498","2408","_bbp_anonymous_website","http://buy-propecia.cf/#9340");
INSERT INTO `wp_postmeta` VALUES("4499","2408","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4500","2408","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4501","2408","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4502","2409","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("4503","2409","_bbp_anonymous_email","bnujiiyc@oikwleak.com");
INSERT INTO `wp_postmeta` VALUES("4504","2409","_bbp_anonymous_website","http://alli-pills.cf/#6505");
INSERT INTO `wp_postmeta` VALUES("4505","2409","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4506","2409","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4507","2409","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4508","2410","_bbp_anonymous_name","how to buy buproprion on line");
INSERT INTO `wp_postmeta` VALUES("4509","2410","_bbp_anonymous_email","isjefibv@vvwbkrfz.com");
INSERT INTO `wp_postmeta` VALUES("4510","2410","_bbp_anonymous_website","http://bupropionxl300.cf/#9625");
INSERT INTO `wp_postmeta` VALUES("4511","2410","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4512","2410","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4513","2410","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4514","2411","_bbp_anonymous_name","cheap prednisone online");
INSERT INTO `wp_postmeta` VALUES("4515","2411","_bbp_anonymous_email","tdxntmpp@ubxzwsdn.com");
INSERT INTO `wp_postmeta` VALUES("4516","2411","_bbp_anonymous_website","http://cheapprednisoneonline.tk/#4784");
INSERT INTO `wp_postmeta` VALUES("4517","2411","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4518","2411","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4519","2411","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4520","2412","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4521","2412","_bbp_anonymous_email","qgqwvpuo@ylsbyjqn.com");
INSERT INTO `wp_postmeta` VALUES("4522","2412","_bbp_anonymous_website","http://genericzithromax.se/#8608");
INSERT INTO `wp_postmeta` VALUES("4523","2412","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4524","2412","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4525","2412","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4526","2413","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4527","2413","_bbp_anonymous_email","irgscyzu@scoswriy.com");
INSERT INTO `wp_postmeta` VALUES("4528","2413","_bbp_anonymous_website","http://discountlevitra.pw/#1201");
INSERT INTO `wp_postmeta` VALUES("4529","2413","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4530","2413","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4531","2413","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4532","2414","_bbp_anonymous_name","effexor");
INSERT INTO `wp_postmeta` VALUES("4533","2414","_bbp_anonymous_email","oswqqylj@titndzqa.com");
INSERT INTO `wp_postmeta` VALUES("4534","2414","_bbp_anonymous_website","http://genericforeffexor.cf/#8801");
INSERT INTO `wp_postmeta` VALUES("4535","2414","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("1572","821","_edit_lock","1427966762:3");
INSERT INTO `wp_postmeta` VALUES("1573","821","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1575","1629","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1576","1629","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("6683","2772","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6682","2772","_bbp_anonymous_website","http://nolvadex-xt.tk/#4032");
INSERT INTO `wp_postmeta` VALUES("6622","2762","_bbp_anonymous_website","http://cheapaccutane.ml/#8666");
INSERT INTO `wp_postmeta` VALUES("6623","2762","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6624","2762","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6625","2762","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6626","2763","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("6627","2763","_bbp_anonymous_email","sfsdgmxx@osdxkdhn.com");
INSERT INTO `wp_postmeta` VALUES("6628","2763","_bbp_anonymous_website","http://genericsildenafil.us/#1243");
INSERT INTO `wp_postmeta` VALUES("6629","2763","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6630","2763","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6631","2763","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6632","2764","_bbp_anonymous_name","tadalafil 20 mg");
INSERT INTO `wp_postmeta` VALUES("6633","2764","_bbp_anonymous_email","ckiqasny@znhfeqzp.com");
INSERT INTO `wp_postmeta` VALUES("6634","2764","_bbp_anonymous_website","http://tadalafil20mg.tk/#2664");
INSERT INTO `wp_postmeta` VALUES("6635","2764","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6636","2764","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6637","2764","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6638","2765","_bbp_anonymous_name","find out more");
INSERT INTO `wp_postmeta` VALUES("6639","2765","_bbp_anonymous_email","xccwohbd@uqvilehe.com");
INSERT INTO `wp_postmeta` VALUES("6640","2765","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#6391");
INSERT INTO `wp_postmeta` VALUES("6641","2765","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6642","2765","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6643","2765","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6644","2766","_bbp_anonymous_name","celebrex 200");
INSERT INTO `wp_postmeta` VALUES("6645","2766","_bbp_anonymous_email","ellanmfi@kdvzrupa.com");
INSERT INTO `wp_postmeta` VALUES("6646","2766","_bbp_anonymous_website","http://celebrex200.cf/#3121");
INSERT INTO `wp_postmeta` VALUES("6647","2766","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6648","2766","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6649","2766","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6650","2767","_bbp_anonymous_name","lexapro no prescription");
INSERT INTO `wp_postmeta` VALUES("6651","2767","_bbp_anonymous_email","gamdaury@jklnycaf.com");
INSERT INTO `wp_postmeta` VALUES("6652","2767","_bbp_anonymous_website","http://generic-lexapro.cf/#8131");
INSERT INTO `wp_postmeta` VALUES("6653","2767","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6654","2767","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6655","2767","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6656","2768","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6657","2768","_bbp_anonymous_email","pqdtywzt@arsyomyx.com");
INSERT INTO `wp_postmeta` VALUES("6658","2768","_bbp_anonymous_website","http://generic-sildenafil.nu/#8470");
INSERT INTO `wp_postmeta` VALUES("6659","2768","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6660","2768","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6661","2768","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6662","2769","_bbp_anonymous_name","wow gold");
INSERT INTO `wp_postmeta` VALUES("6663","2769","_bbp_anonymous_email","gcggnnu@gmail.com");
INSERT INTO `wp_postmeta` VALUES("6664","2769","_bbp_anonymous_website","http://www.wowruler.com");
INSERT INTO `wp_postmeta` VALUES("6665","2769","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6666","2769","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("6667","2769","_bbp_author_ip","74.91.20.250");
INSERT INTO `wp_postmeta` VALUES("6668","2770","_bbp_anonymous_name","viagra by phone");
INSERT INTO `wp_postmeta` VALUES("6669","2770","_bbp_anonymous_email","vmtqxadv@zsbwbmxl.com");
INSERT INTO `wp_postmeta` VALUES("6670","2770","_bbp_anonymous_website","http://viagr.ml/#1906");
INSERT INTO `wp_postmeta` VALUES("6671","2770","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6672","2770","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6673","2770","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6674","2771","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("6675","2771","_bbp_anonymous_email","wzgsxnfp@vvfwbekt.com");
INSERT INTO `wp_postmeta` VALUES("6676","2771","_bbp_anonymous_website","http://tadalafil.in/#3767");
INSERT INTO `wp_postmeta` VALUES("6677","2771","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6678","2771","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6679","2771","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6680","2772","_bbp_anonymous_name","nolvadex xt");
INSERT INTO `wp_postmeta` VALUES("6681","2772","_bbp_anonymous_email","psfncbec@fxfovqtf.com");
INSERT INTO `wp_postmeta` VALUES("6621","2762","_bbp_anonymous_email","tcwtyrcg@ayftdztl.com");
INSERT INTO `wp_postmeta` VALUES("6485","2739","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6486","2739","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6487","2739","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6488","2740","_bbp_anonymous_name","cost of cipro");
INSERT INTO `wp_postmeta` VALUES("6489","2740","_bbp_anonymous_email","njgeuakq@cufsfgav.com");
INSERT INTO `wp_postmeta` VALUES("6490","2740","_bbp_anonymous_website","http://ciprocost.cf/#8302");
INSERT INTO `wp_postmeta` VALUES("6491","2740","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6492","2740","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6493","2740","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6494","2741","_bbp_anonymous_name","accutane generic");
INSERT INTO `wp_postmeta` VALUES("6495","2741","_bbp_anonymous_email","slrwwllz@aqaegeuv.com");
INSERT INTO `wp_postmeta` VALUES("6496","2741","_bbp_anonymous_website","http://accutanegeneric.pw/#2797");
INSERT INTO `wp_postmeta` VALUES("6497","2741","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6498","2741","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6499","2741","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6500","2742","_bbp_anonymous_name","aldeamentopeixinhosalentejo");
INSERT INTO `wp_postmeta` VALUES("6501","2742","_bbp_anonymous_email","ffjewrzf@gmail.com");
INSERT INTO `wp_postmeta` VALUES("6502","2742","_bbp_anonymous_website","http://www.aldeamentopeixinhosalentejo.com/");
INSERT INTO `wp_postmeta` VALUES("6503","2742","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6504","2742","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("6505","2742","_bbp_author_ip","222.77.203.168");
INSERT INTO `wp_postmeta` VALUES("6506","2743","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("6507","2743","_bbp_anonymous_email","anhpyekx@rlrhflue.com");
INSERT INTO `wp_postmeta` VALUES("6508","2743","_bbp_anonymous_website","http://alli-drug.cf/#3986");
INSERT INTO `wp_postmeta` VALUES("6509","2743","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6510","2743","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6511","2743","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6512","2744","_bbp_anonymous_name","check this out");
INSERT INTO `wp_postmeta` VALUES("6513","2744","_bbp_anonymous_email","bjmofjtc@bnpzodag.com");
INSERT INTO `wp_postmeta` VALUES("6514","2744","_bbp_anonymous_website","http://vermox.ml/#9729");
INSERT INTO `wp_postmeta` VALUES("6515","2744","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6516","2744","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6517","2744","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6518","2745","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("6519","2745","_bbp_anonymous_email","mvmemwqt@gkhvamef.com");
INSERT INTO `wp_postmeta` VALUES("6520","2745","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#5076");
INSERT INTO `wp_postmeta` VALUES("6521","2745","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6522","2745","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6523","2745","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6524","2746","_bbp_anonymous_name","zithromax buy");
INSERT INTO `wp_postmeta` VALUES("6525","2746","_bbp_anonymous_email","fnpbpavc@fpqqplaq.com");
INSERT INTO `wp_postmeta` VALUES("6526","2746","_bbp_anonymous_website","http://zithromaxzpack.ml/#5104");
INSERT INTO `wp_postmeta` VALUES("6527","2746","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6528","2746","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6529","2746","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6530","2747","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6531","2747","_bbp_anonymous_email","ypqtcsud@akvrzmst.com");
INSERT INTO `wp_postmeta` VALUES("6532","2747","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#6288");
INSERT INTO `wp_postmeta` VALUES("6533","2747","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6534","2747","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6535","2747","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6536","2748","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6537","2748","_bbp_anonymous_email","ultczhcn@rkludfid.com");
INSERT INTO `wp_postmeta` VALUES("6538","2748","_bbp_anonymous_website","http://cialisforsaleonline.tk/#2900");
INSERT INTO `wp_postmeta` VALUES("6539","2748","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6540","2748","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6541","2748","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6542","2749","_bbp_anonymous_name","generic cialis india");
INSERT INTO `wp_postmeta` VALUES("6543","2749","_bbp_anonymous_email","wzbjfrhm@uutxkktk.com");
INSERT INTO `wp_postmeta` VALUES("6544","2749","_bbp_anonymous_website","http://discountgenericcialis.tk/#4474");
INSERT INTO `wp_postmeta` VALUES("6545","2749","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6546","2749","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6547","2749","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6548","2750","_bbp_anonymous_name","amoxil 875");
INSERT INTO `wp_postmeta` VALUES("6549","2750","_bbp_anonymous_email","pnclnboz@jiaovtol.com");
INSERT INTO `wp_postmeta` VALUES("6550","2750","_bbp_anonymous_website","http://amoxil-875.ml/#9614");
INSERT INTO `wp_postmeta` VALUES("6551","2750","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6552","2750","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6553","2750","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6554","2751","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6555","2751","_bbp_anonymous_email","ywjrfdra@mkwyhxby.com");
INSERT INTO `wp_postmeta` VALUES("6556","2751","_bbp_anonymous_website","http://finasteride.ml/#5061");
INSERT INTO `wp_postmeta` VALUES("6557","2751","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6558","2751","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6559","2751","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6560","2752","_bbp_anonymous_name","viagra 30 pills");
INSERT INTO `wp_postmeta` VALUES("6561","2752","_bbp_anonymous_email","omsznygd@nsofvcwz.com");
INSERT INTO `wp_postmeta` VALUES("6562","2752","_bbp_anonymous_website","http://buyviagra-softtabs.ga/#8182");
INSERT INTO `wp_postmeta` VALUES("6563","2752","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6564","2752","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6565","2752","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6566","2753","_bbp_anonymous_name","cephalexin 500 mg capsule");
INSERT INTO `wp_postmeta` VALUES("6567","2753","_bbp_anonymous_email","ayayxfjz@raquuihp.com");
INSERT INTO `wp_postmeta` VALUES("6568","2753","_bbp_anonymous_website","http://cephalexin500.cf/#8939");
INSERT INTO `wp_postmeta` VALUES("6569","2753","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6570","2753","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6571","2753","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6572","2754","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6573","2754","_bbp_anonymous_email","blwiuqeo@smkqhnyq.com");
INSERT INTO `wp_postmeta` VALUES("6574","2754","_bbp_anonymous_website","http://buy-sildenafil-citrate.ml/#7281");
INSERT INTO `wp_postmeta` VALUES("6575","2754","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6576","2754","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6577","2754","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6578","2755","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("6579","2755","_bbp_anonymous_email","cgzxojqz@lfmpymgy.com");
INSERT INTO `wp_postmeta` VALUES("6580","2755","_bbp_anonymous_website","http://xenical-orlistat-120mg.cf/#8247");
INSERT INTO `wp_postmeta` VALUES("6581","2755","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6582","2755","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6583","2755","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6584","2756","_bbp_anonymous_name","levitra discount");
INSERT INTO `wp_postmeta` VALUES("6585","2756","_bbp_anonymous_email","waihrawk@xdnfowkv.com");
INSERT INTO `wp_postmeta` VALUES("6586","2756","_bbp_anonymous_website","http://discountlevitra.cf/#9881");
INSERT INTO `wp_postmeta` VALUES("6587","2756","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6588","2756","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6589","2756","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6590","2757","_bbp_anonymous_name","where to buy doxycycline online");
INSERT INTO `wp_postmeta` VALUES("6591","2757","_bbp_anonymous_email","mxnnzswz@ulyrvcky.com");
INSERT INTO `wp_postmeta` VALUES("6592","2757","_bbp_anonymous_website","http://buy-doxycycline.tk/#6883");
INSERT INTO `wp_postmeta` VALUES("6593","2757","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6594","2757","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6595","2757","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6596","2758","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6597","2758","_bbp_anonymous_email","albvopgp@gxurqbcu.com");
INSERT INTO `wp_postmeta` VALUES("6598","2758","_bbp_anonymous_website","http://propeciahairgrowth.ga/#2433");
INSERT INTO `wp_postmeta` VALUES("6599","2758","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6600","2758","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6601","2758","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6602","2759","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("6603","2759","_bbp_anonymous_email","sjlkswij@otsjjlxf.com");
INSERT INTO `wp_postmeta` VALUES("6604","2759","_bbp_anonymous_website","http://mobic75mg.cf/#3890");
INSERT INTO `wp_postmeta` VALUES("6605","2759","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6606","2759","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6607","2759","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6608","2760","_bbp_anonymous_name","levitra 20");
INSERT INTO `wp_postmeta` VALUES("6609","2760","_bbp_anonymous_email","frnavkcb@zhdlqlte.com");
INSERT INTO `wp_postmeta` VALUES("6610","2760","_bbp_anonymous_website","http://levitra20.tk/#7137");
INSERT INTO `wp_postmeta` VALUES("6611","2760","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6612","2760","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6613","2760","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6614","2761","_bbp_anonymous_name","cialis tadalafil");
INSERT INTO `wp_postmeta` VALUES("6615","2761","_bbp_anonymous_email","wjtcjugc@pizrxgqt.com");
INSERT INTO `wp_postmeta` VALUES("6616","2761","_bbp_anonymous_website","http://cialistadalafil.cf/#1323");
INSERT INTO `wp_postmeta` VALUES("6617","2761","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6618","2761","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6619","2761","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6620","2762","_bbp_anonymous_name","where to buy accutane online");
INSERT INTO `wp_postmeta` VALUES("5138","2515","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("5137","2514","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5136","2514","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5135","2514","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5133","2514","_bbp_anonymous_email","srcqpihj@bdcrjmdr.com");
INSERT INTO `wp_postmeta` VALUES("5134","2514","_bbp_anonymous_website","http://buyamoxicillin.se/#3086");
INSERT INTO `wp_postmeta` VALUES("5132","2514","_bbp_anonymous_name","can i buy amoxicillin over the counter");
INSERT INTO `wp_postmeta` VALUES("6279","2705","_bbp_anonymous_email","zuatklbl@txaccvhs.com");
INSERT INTO `wp_postmeta` VALUES("6280","2705","_bbp_anonymous_website","http://buy-doxycycline.pw/#4263");
INSERT INTO `wp_postmeta` VALUES("6281","2705","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6282","2705","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6283","2705","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6284","2706","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("6285","2706","_bbp_anonymous_email","axugkhyp@wsqzgdvg.com");
INSERT INTO `wp_postmeta` VALUES("6286","2706","_bbp_anonymous_website","http://amoxil.in/#1465");
INSERT INTO `wp_postmeta` VALUES("6287","2706","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6288","2706","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6289","2706","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6290","2707","_bbp_anonymous_name","order acyclovir online");
INSERT INTO `wp_postmeta` VALUES("6291","2707","_bbp_anonymous_email","mvxszckx@jfqevbin.com");
INSERT INTO `wp_postmeta` VALUES("6292","2707","_bbp_anonymous_website","http://orderacyclovir.ml/#7763");
INSERT INTO `wp_postmeta` VALUES("6293","2707","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6294","2707","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6295","2707","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6296","2708","_bbp_anonymous_name","online cialis pharmacy");
INSERT INTO `wp_postmeta` VALUES("6297","2708","_bbp_anonymous_email","peakfuap@jyitjmwu.com");
INSERT INTO `wp_postmeta` VALUES("6298","2708","_bbp_anonymous_website","http://onlinecialis.ml/#6082");
INSERT INTO `wp_postmeta` VALUES("6299","2708","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6300","2708","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6301","2708","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6302","2709","_bbp_anonymous_name","buy cialis online cheap");
INSERT INTO `wp_postmeta` VALUES("6303","2709","_bbp_anonymous_email","hmqowmak@cwymuoli.com");
INSERT INTO `wp_postmeta` VALUES("6304","2709","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#5070");
INSERT INTO `wp_postmeta` VALUES("6305","2709","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6269","2703","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6270","2703","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6271","2703","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6272","2704","_bbp_anonymous_name","cheap alli pills");
INSERT INTO `wp_postmeta` VALUES("6273","2704","_bbp_anonymous_email","menimgex@ivxanifc.com");
INSERT INTO `wp_postmeta` VALUES("6274","2704","_bbp_anonymous_website","http://alli-diet-pill.cf/#2755");
INSERT INTO `wp_postmeta` VALUES("6275","2704","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6276","2704","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6277","2704","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6278","2705","_bbp_anonymous_name","buy doxycycline");
INSERT INTO `wp_postmeta` VALUES("6268","2703","_bbp_anonymous_website","http://vardenafil-hydrochloride.ml/#3042");
INSERT INTO `wp_postmeta` VALUES("6250","2700","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#4033");
INSERT INTO `wp_postmeta` VALUES("6251","2700","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6252","2700","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6253","2700","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6254","2701","_bbp_anonymous_name","prozac online");
INSERT INTO `wp_postmeta` VALUES("6255","2701","_bbp_anonymous_email","hpkkybmm@mfjtmcro.com");
INSERT INTO `wp_postmeta` VALUES("6256","2701","_bbp_anonymous_website","http://prozac.in/#6291");
INSERT INTO `wp_postmeta` VALUES("6257","2701","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6258","2701","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6259","2701","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6260","2702","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6261","2702","_bbp_anonymous_email","txadsvrp@bxmaxppt.com");
INSERT INTO `wp_postmeta` VALUES("6262","2702","_bbp_anonymous_website","http://buymobic.se/#8750");
INSERT INTO `wp_postmeta` VALUES("6263","2702","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6264","2702","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6265","2702","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6266","2703","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("6267","2703","_bbp_anonymous_email","znvbyuhp@rplqrrac.com");
INSERT INTO `wp_postmeta` VALUES("6232","2697","_bbp_anonymous_website","http://doxy.cf/#5778");
INSERT INTO `wp_postmeta` VALUES("6233","2697","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6234","2697","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6235","2697","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6236","2698","_bbp_anonymous_name","amoxicillin tablets");
INSERT INTO `wp_postmeta` VALUES("6237","2698","_bbp_anonymous_email","kerxfpvv@uqhsnmat.com");
INSERT INTO `wp_postmeta` VALUES("6238","2698","_bbp_anonymous_website","http://buyamoxicillin.biz/#6803");
INSERT INTO `wp_postmeta` VALUES("6239","2698","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6240","2698","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6241","2698","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6242","2699","_bbp_anonymous_name","buy ventolin inhaler without prescription");
INSERT INTO `wp_postmeta` VALUES("6243","2699","_bbp_anonymous_email","ybhxhjkb@fhoerqul.com");
INSERT INTO `wp_postmeta` VALUES("6244","2699","_bbp_anonymous_website","http://buyventolininhaler.cf/#7669");
INSERT INTO `wp_postmeta` VALUES("6245","2699","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6246","2699","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6247","2699","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6248","2700","_bbp_anonymous_name","buy cialis/canada");
INSERT INTO `wp_postmeta` VALUES("6249","2700","_bbp_anonymous_email","dxkycksx@dexwnswq.com");
INSERT INTO `wp_postmeta` VALUES("6217","2694","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6218","2695","_bbp_anonymous_name","order retin a without a prescription");
INSERT INTO `wp_postmeta` VALUES("6219","2695","_bbp_anonymous_email","oeznuewj@czeenmmc.com");
INSERT INTO `wp_postmeta` VALUES("6220","2695","_bbp_anonymous_website","http://retina005cream.ml/#7761");
INSERT INTO `wp_postmeta` VALUES("6221","2695","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6222","2695","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6223","2695","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6224","2696","_bbp_anonymous_name","cheap albuterol");
INSERT INTO `wp_postmeta` VALUES("6225","2696","_bbp_anonymous_email","avyteqfm@ixtzpupj.com");
INSERT INTO `wp_postmeta` VALUES("6226","2696","_bbp_anonymous_website","http://albuterol.in/#2247");
INSERT INTO `wp_postmeta` VALUES("6227","2696","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6228","2696","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6229","2696","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6230","2697","_bbp_anonymous_name","doxy");
INSERT INTO `wp_postmeta` VALUES("6231","2697","_bbp_anonymous_email","bsraxtjh@edoqljvv.com");
INSERT INTO `wp_postmeta` VALUES("6199","2691","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6200","2692","_bbp_anonymous_name","mobic price");
INSERT INTO `wp_postmeta` VALUES("6201","2692","_bbp_anonymous_email","eaiznktt@fxxhuion.com");
INSERT INTO `wp_postmeta` VALUES("6202","2692","_bbp_anonymous_website","http://cheapmobic.pw/#7871");
INSERT INTO `wp_postmeta` VALUES("6203","2692","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6204","2692","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6205","2692","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6206","2693","_bbp_anonymous_name","valtrex pill");
INSERT INTO `wp_postmeta` VALUES("6207","2693","_bbp_anonymous_email","vpoayter@gwemttwb.com");
INSERT INTO `wp_postmeta` VALUES("6208","2693","_bbp_anonymous_website","http://valtrex-500-mg.ga/#6008");
INSERT INTO `wp_postmeta` VALUES("6209","2693","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6210","2693","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6211","2693","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6212","2694","_bbp_anonymous_name","bonuses");
INSERT INTO `wp_postmeta` VALUES("6213","2694","_bbp_anonymous_email","kkrhdcny@urkcnzys.com");
INSERT INTO `wp_postmeta` VALUES("6214","2694","_bbp_anonymous_website","http://furosemide-40-mg-diuretic.cf/#9032");
INSERT INTO `wp_postmeta` VALUES("6215","2694","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6216","2694","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6198","2691","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6197","2691","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6178","2688","_bbp_anonymous_website","http://buyamoxicillin500mg.ml/#9370");
INSERT INTO `wp_postmeta` VALUES("6179","2688","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6180","2688","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6181","2688","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6182","2689","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("6183","2689","_bbp_anonymous_email","qabwynht@txxwjlth.com");
INSERT INTO `wp_postmeta` VALUES("6184","2689","_bbp_anonymous_website","http://alli-pills.cf/#8944");
INSERT INTO `wp_postmeta` VALUES("6185","2689","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6186","2689","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6187","2689","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6188","2690","_bbp_anonymous_name","generic prozac");
INSERT INTO `wp_postmeta` VALUES("6189","2690","_bbp_anonymous_email","qgqvzawd@mmmpgyxs.com");
INSERT INTO `wp_postmeta` VALUES("6190","2690","_bbp_anonymous_website","http://generic-prozac.pw/#1115");
INSERT INTO `wp_postmeta` VALUES("6191","2690","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6192","2690","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6193","2690","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6194","2691","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("6195","2691","_bbp_anonymous_email","kisofrpq@lrhloexm.com");
INSERT INTO `wp_postmeta` VALUES("6196","2691","_bbp_anonymous_website","http://lasixdrug.tk/#6671");
INSERT INTO `wp_postmeta` VALUES("5205","2526","_bbp_anonymous_email","gsgyafgl@fkgflnbs.com");
INSERT INTO `wp_postmeta` VALUES("5206","2526","_bbp_anonymous_website","http://ordercialisonline.ml/#6443");
INSERT INTO `wp_postmeta` VALUES("5207","2526","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5208","2526","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5209","2526","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5210","2527","_bbp_anonymous_name","celebrex buy");
INSERT INTO `wp_postmeta` VALUES("5211","2527","_bbp_anonymous_email","uvtnpmtv@twvrgoqj.com");
INSERT INTO `wp_postmeta` VALUES("5212","2527","_bbp_anonymous_website","http://buycelebrex.se/#8593");
INSERT INTO `wp_postmeta` VALUES("5213","2527","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5214","2527","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5215","2527","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5216","2528","_bbp_anonymous_name","buy amoxicillin");
INSERT INTO `wp_postmeta` VALUES("5217","2528","_bbp_anonymous_email","ahflngni@inknrwye.com");
INSERT INTO `wp_postmeta` VALUES("5218","2528","_bbp_anonymous_website","http://buyamoxicillin.se/#7034");
INSERT INTO `wp_postmeta` VALUES("5219","2528","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5220","2528","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5221","2528","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5222","2529","_bbp_anonymous_name","effexor");
INSERT INTO `wp_postmeta` VALUES("5223","2529","_bbp_anonymous_email","pgjnrrjc@vbtjqdzj.com");
INSERT INTO `wp_postmeta` VALUES("5224","2529","_bbp_anonymous_website","http://effexorxr150mg.pw/#1230");
INSERT INTO `wp_postmeta` VALUES("5225","2529","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5226","2529","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5227","2529","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5228","2530","_bbp_anonymous_name","cephalexin 500");
INSERT INTO `wp_postmeta` VALUES("5229","2530","_bbp_anonymous_email","bpokjcfx@hzoctdtb.com");
INSERT INTO `wp_postmeta` VALUES("5230","2530","_bbp_anonymous_website","http://cephalexin500.cf/#7085");
INSERT INTO `wp_postmeta` VALUES("5231","2530","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5232","2530","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5233","2530","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5234","2531","_bbp_anonymous_name","mobic 15mg tab");
INSERT INTO `wp_postmeta` VALUES("5235","2531","_bbp_anonymous_email","ctdqedks@mpukvhqc.com");
INSERT INTO `wp_postmeta` VALUES("5236","2531","_bbp_anonymous_website","http://buy-mobic.tk/#9713");
INSERT INTO `wp_postmeta` VALUES("5237","2531","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5238","2531","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5239","2531","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5240","2532","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("5241","2532","_bbp_anonymous_email","wvukwdaj@jexadsst.com");
INSERT INTO `wp_postmeta` VALUES("5242","2532","_bbp_anonymous_website","http://lexaprogeneric.ga/#5075");
INSERT INTO `wp_postmeta` VALUES("5243","2532","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5244","2532","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5245","2532","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5246","2533","_bbp_anonymous_name","synthroid");
INSERT INTO `wp_postmeta` VALUES("5247","2533","_bbp_anonymous_email","impyzgxz@xdwlayfr.com");
INSERT INTO `wp_postmeta` VALUES("5248","2533","_bbp_anonymous_website","http://synthroid-generic.tk/#8591");
INSERT INTO `wp_postmeta` VALUES("5249","2533","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5250","2533","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5251","2533","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5252","2534","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5253","2534","_bbp_anonymous_email","oabfqjlg@ytekpvmz.com");
INSERT INTO `wp_postmeta` VALUES("5254","2534","_bbp_anonymous_website","http://cialus.tk/#3815");
INSERT INTO `wp_postmeta` VALUES("5255","2534","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5256","2534","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5257","2534","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5258","2535","_bbp_anonymous_name","fluconazole diflucan");
INSERT INTO `wp_postmeta` VALUES("5259","2535","_bbp_anonymous_email","fcsldkbl@jjgkhmvq.com");
INSERT INTO `wp_postmeta` VALUES("5260","2535","_bbp_anonymous_website","http://diflucanfluconazole.tk/#1460");
INSERT INTO `wp_postmeta` VALUES("5261","2535","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5262","2535","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5263","2535","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5264","2536","_bbp_anonymous_name","amoxicillin 500mg price");
INSERT INTO `wp_postmeta` VALUES("5265","2536","_bbp_anonymous_email","bayrslte@ytonmrnu.com");
INSERT INTO `wp_postmeta` VALUES("5266","2536","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#3517");
INSERT INTO `wp_postmeta` VALUES("5267","2536","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5268","2536","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5204","2526","_bbp_anonymous_name","buy cialis canada review");
INSERT INTO `wp_postmeta` VALUES("5200","2525","_bbp_anonymous_website","http://orlistat120mg.ga/#6292");
INSERT INTO `wp_postmeta` VALUES("5201","2525","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5202","2525","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5203","2525","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5199","2525","_bbp_anonymous_email","cngrraps@okjlarsb.com");
INSERT INTO `wp_postmeta` VALUES("5198","2525","_bbp_anonymous_name","xenical medication");
INSERT INTO `wp_postmeta` VALUES("5197","2524","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5179","2521","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5180","2522","_bbp_anonymous_name","doxy");
INSERT INTO `wp_postmeta` VALUES("5181","2522","_bbp_anonymous_email","dngoejpf@uzwhuyra.com");
INSERT INTO `wp_postmeta` VALUES("5182","2522","_bbp_anonymous_website","http://doxy.cf/#1843");
INSERT INTO `wp_postmeta` VALUES("5183","2522","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5184","2522","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5185","2522","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5186","2523","_bbp_anonymous_name","where to buy alli pills");
INSERT INTO `wp_postmeta` VALUES("5187","2523","_bbp_anonymous_email","hcsjhgwo@yomhdtdq.com");
INSERT INTO `wp_postmeta` VALUES("5188","2523","_bbp_anonymous_website","http://allipill.ml/#7908");
INSERT INTO `wp_postmeta` VALUES("5189","2523","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5190","2523","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5191","2523","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5192","2524","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("5193","2524","_bbp_anonymous_email","sfueznfq@ejpyigaa.com");
INSERT INTO `wp_postmeta` VALUES("5194","2524","_bbp_anonymous_website","http://buyventolininhaler.cf/#1802");
INSERT INTO `wp_postmeta` VALUES("5195","2524","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5196","2524","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5174","2521","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("5175","2521","_bbp_anonymous_email","ysdvgwvz@ngytwvfu.com");
INSERT INTO `wp_postmeta` VALUES("5176","2521","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#7718");
INSERT INTO `wp_postmeta` VALUES("5177","2521","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5178","2521","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5159","2518","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5160","2518","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5161","2518","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5162","2519","_bbp_anonymous_name","buy online viagra");
INSERT INTO `wp_postmeta` VALUES("5163","2519","_bbp_anonymous_email","plszbvlj@oiautpxq.com");
INSERT INTO `wp_postmeta` VALUES("5164","2519","_bbp_anonymous_website","http://viagrabuyonline.ga/#6496");
INSERT INTO `wp_postmeta` VALUES("5165","2519","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5166","2519","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5167","2519","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5168","2520","_bbp_anonymous_name","accutane canada 40mg");
INSERT INTO `wp_postmeta` VALUES("5169","2520","_bbp_anonymous_email","kszwosvx@bmvykxuj.com");
INSERT INTO `wp_postmeta` VALUES("5170","2520","_bbp_anonymous_website","http://cheapaccutane.ml/#3248");
INSERT INTO `wp_postmeta` VALUES("5171","2520","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5172","2520","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5173","2520","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5156","2518","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("5157","2518","_bbp_anonymous_email","csnmnoyb@izryozxb.com");
INSERT INTO `wp_postmeta` VALUES("5158","2518","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#6689");
INSERT INTO `wp_postmeta` VALUES("5155","2517","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5154","2517","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5149","2516","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5150","2517","_bbp_anonymous_name","online cialis");
INSERT INTO `wp_postmeta` VALUES("5151","2517","_bbp_anonymous_email","ojyprpor@xwpkpmjx.com");
INSERT INTO `wp_postmeta` VALUES("5152","2517","_bbp_anonymous_website","http://onlinecialis.ml/#7982");
INSERT INTO `wp_postmeta` VALUES("5153","2517","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5144","2516","_bbp_anonymous_name","doxycycline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("5145","2516","_bbp_anonymous_email","paqpceqo@bnqblpff.com");
INSERT INTO `wp_postmeta` VALUES("5146","2516","_bbp_anonymous_website","http://buy-doxycycline.pw/#7330");
INSERT INTO `wp_postmeta` VALUES("5147","2516","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5148","2516","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6484","2739","_bbp_anonymous_website","http://generic-viagra.info/#9493");
INSERT INTO `wp_postmeta` VALUES("5367","2553","_bbp_anonymous_email","zreptnbn@vmvdrssn.com");
INSERT INTO `wp_postmeta` VALUES("5366","2553","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5361","2552","_bbp_anonymous_email","jqzzvpkh@znlgnapn.com");
INSERT INTO `wp_postmeta` VALUES("5362","2552","_bbp_anonymous_website","http://wellbutrinmedication.cf/#1337");
INSERT INTO `wp_postmeta` VALUES("5363","2552","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5364","2552","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5365","2552","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5296","2541","_bbp_anonymous_website","http://wellbutrin150mg.ga/#4891");
INSERT INTO `wp_postmeta` VALUES("5297","2541","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5298","2541","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5299","2541","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5300","2542","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5301","2542","_bbp_anonymous_email","dewcnmra@lqljqxsd.com");
INSERT INTO `wp_postmeta` VALUES("5302","2542","_bbp_anonymous_website","http://buy-propecia.cf/#4573");
INSERT INTO `wp_postmeta` VALUES("5303","2542","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5304","2542","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5305","2542","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5306","2543","_bbp_anonymous_name","livitra");
INSERT INTO `wp_postmeta` VALUES("5307","2543","_bbp_anonymous_email","ugtyprjg@jodszkjm.com");
INSERT INTO `wp_postmeta` VALUES("5308","2543","_bbp_anonymous_website","http://levitra20.tk/#9826");
INSERT INTO `wp_postmeta` VALUES("5309","2543","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5310","2543","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5311","2543","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5312","2544","_bbp_anonymous_name","nexium drug");
INSERT INTO `wp_postmeta` VALUES("5313","2544","_bbp_anonymous_email","xchepycp@jjtqjpqc.com");
INSERT INTO `wp_postmeta` VALUES("5314","2544","_bbp_anonymous_website","http://nexiumdrug.ga/#9903");
INSERT INTO `wp_postmeta` VALUES("5315","2544","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5316","2544","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5317","2544","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5318","2545","_bbp_anonymous_name","retin a 0.05 cream");
INSERT INTO `wp_postmeta` VALUES("5319","2545","_bbp_anonymous_email","tkbvpwuh@yrgcrevq.com");
INSERT INTO `wp_postmeta` VALUES("5320","2545","_bbp_anonymous_website","http://retina005cream.ml/#1205");
INSERT INTO `wp_postmeta` VALUES("5321","2545","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5322","2545","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5323","2545","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5324","2546","_bbp_anonymous_name","buying cialis in canada");
INSERT INTO `wp_postmeta` VALUES("5325","2546","_bbp_anonymous_email","xjimwffz@iwppbqrn.com");
INSERT INTO `wp_postmeta` VALUES("5326","2546","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#4133");
INSERT INTO `wp_postmeta` VALUES("5327","2546","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5328","2546","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5329","2546","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5330","2547","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("5331","2547","_bbp_anonymous_email","oucibqoa@gfmviiau.com");
INSERT INTO `wp_postmeta` VALUES("5332","2547","_bbp_anonymous_website","http://purchasestattera.cf/#3534");
INSERT INTO `wp_postmeta` VALUES("5333","2547","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5334","2547","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5335","2547","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5336","2548","_bbp_anonymous_name","cipro cost");
INSERT INTO `wp_postmeta` VALUES("5337","2548","_bbp_anonymous_email","yebfcwat@sgfcddxi.com");
INSERT INTO `wp_postmeta` VALUES("5338","2548","_bbp_anonymous_website","http://ciprocost.cf/#3601");
INSERT INTO `wp_postmeta` VALUES("5339","2548","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5340","2548","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5341","2548","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5342","2549","_bbp_anonymous_name","elavil medication");
INSERT INTO `wp_postmeta` VALUES("5343","2549","_bbp_anonymous_email","nchofybs@kwilzkvb.com");
INSERT INTO `wp_postmeta` VALUES("5344","2549","_bbp_anonymous_website","http://amitriptylinehcl25mgtab.cf/#6573");
INSERT INTO `wp_postmeta` VALUES("5345","2549","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5346","2549","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5347","2549","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5348","2550","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("5349","2550","_bbp_anonymous_email","tsycpmdr@pyfuwxay.com");
INSERT INTO `wp_postmeta` VALUES("5350","2550","_bbp_anonymous_website","http://keflexantibiotic.cf/#8561");
INSERT INTO `wp_postmeta` VALUES("5351","2550","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5352","2550","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5353","2550","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5354","2551","_bbp_anonymous_name","livetra");
INSERT INTO `wp_postmeta` VALUES("5355","2551","_bbp_anonymous_email","latlqvtl@gxciumcu.com");
INSERT INTO `wp_postmeta` VALUES("5356","2551","_bbp_anonymous_website","http://discountlevitra.cf/#7034");
INSERT INTO `wp_postmeta` VALUES("5357","2551","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5358","2551","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5359","2551","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5360","2552","_bbp_anonymous_name","wellbutrin 75mg");
INSERT INTO `wp_postmeta` VALUES("5282","2539","_bbp_anonymous_name","buy sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("5283","2539","_bbp_anonymous_email","qsdbeink@lreffwuy.com");
INSERT INTO `wp_postmeta` VALUES("5284","2539","_bbp_anonymous_website","http://buy-sildenafil-citrate.ml/#9657");
INSERT INTO `wp_postmeta` VALUES("5285","2539","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5286","2539","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5287","2539","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5288","2540","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5289","2540","_bbp_anonymous_email","wlkgnloa@irdsehpw.com");
INSERT INTO `wp_postmeta` VALUES("5290","2540","_bbp_anonymous_website","http://tadalafil-no-prescription.cf/#7005");
INSERT INTO `wp_postmeta` VALUES("5291","2540","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5292","2540","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5293","2540","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5294","2541","_bbp_anonymous_name","wellbutrin 150 mg");
INSERT INTO `wp_postmeta` VALUES("5295","2541","_bbp_anonymous_email","cqlcbodo@obtqxgus.com");
INSERT INTO `wp_postmeta` VALUES("5277","2538","_bbp_anonymous_email","mvbeyoes@utvkdrjn.com");
INSERT INTO `wp_postmeta` VALUES("5278","2538","_bbp_anonymous_website","http://xenical-120-mg.cf/#9593");
INSERT INTO `wp_postmeta` VALUES("5279","2538","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5280","2538","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5281","2538","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5276","2538","_bbp_anonymous_name","xenical 120 mg");
INSERT INTO `wp_postmeta` VALUES("5271","2537","_bbp_anonymous_email","athzivqt@rnychlbj.com");
INSERT INTO `wp_postmeta` VALUES("5272","2537","_bbp_anonymous_website","http://keflex500.tk/#6646");
INSERT INTO `wp_postmeta` VALUES("5273","2537","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5274","2537","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5275","2537","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5514","2577","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5515","2577","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5516","2578","_bbp_anonymous_name","cheap xenical");
INSERT INTO `wp_postmeta` VALUES("5517","2578","_bbp_anonymous_email","bgojlurz@hwrmfshm.com");
INSERT INTO `wp_postmeta` VALUES("5518","2578","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#9632");
INSERT INTO `wp_postmeta` VALUES("5519","2578","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5520","2578","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5521","2578","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5522","2579","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("5523","2579","_bbp_anonymous_email","cyswkkpy@neuysoig.com");
INSERT INTO `wp_postmeta` VALUES("5524","2579","_bbp_anonymous_website","http://buy-viagra-soft-tabs.ga/#1315");
INSERT INTO `wp_postmeta` VALUES("5525","2579","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5526","2579","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5527","2579","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5509","2576","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5510","2577","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5511","2577","_bbp_anonymous_email","xrobnkiy@ubhfquno.com");
INSERT INTO `wp_postmeta` VALUES("5512","2577","_bbp_anonymous_website","http://cialis5mg.tk/#1103");
INSERT INTO `wp_postmeta` VALUES("5513","2577","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5422","2562","_bbp_anonymous_website","http://xenical-orlistat-120mg.tk/#4045");
INSERT INTO `wp_postmeta` VALUES("5423","2562","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5424","2562","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5425","2562","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5426","2563","_bbp_anonymous_name","buy prednisone online without a script");
INSERT INTO `wp_postmeta` VALUES("5427","2563","_bbp_anonymous_email","kzrlgdqi@cfarxbwu.com");
INSERT INTO `wp_postmeta` VALUES("5428","2563","_bbp_anonymous_website","http://prednisone20mgmedication.cf/#2466");
INSERT INTO `wp_postmeta` VALUES("5429","2563","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5430","2563","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5431","2563","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5432","2564","_bbp_anonymous_name","alli drug");
INSERT INTO `wp_postmeta` VALUES("5433","2564","_bbp_anonymous_email","kxgvfyue@vpjuwrdr.com");
INSERT INTO `wp_postmeta` VALUES("5434","2564","_bbp_anonymous_website","http://allidrug.cf/#2130");
INSERT INTO `wp_postmeta` VALUES("5435","2564","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5436","2564","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5437","2564","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5438","2565","_bbp_anonymous_name","effexor xr 150");
INSERT INTO `wp_postmeta` VALUES("5439","2565","_bbp_anonymous_email","onxguouk@kqdupboz.com");
INSERT INTO `wp_postmeta` VALUES("5440","2565","_bbp_anonymous_website","http://genericforeffexor.cf/#5161");
INSERT INTO `wp_postmeta` VALUES("5441","2565","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5442","2565","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5443","2565","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5444","2566","_bbp_anonymous_name","lexapro 5mg");
INSERT INTO `wp_postmeta` VALUES("5445","2566","_bbp_anonymous_email","ixiboaie@yqlysugu.com");
INSERT INTO `wp_postmeta` VALUES("5446","2566","_bbp_anonymous_website","http://lexapro5mg.ml/#6010");
INSERT INTO `wp_postmeta` VALUES("5447","2566","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5448","2566","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5449","2566","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5450","2567","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5451","2567","_bbp_anonymous_email","dhqrebuj@cuhjwqmm.com");
INSERT INTO `wp_postmeta` VALUES("5452","2567","_bbp_anonymous_website","http://genericsildenafilcitrate.ml/#9120");
INSERT INTO `wp_postmeta` VALUES("5453","2567","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5454","2567","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5455","2567","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5456","2568","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("5457","2568","_bbp_anonymous_email","iqvmwznj@knmifxxp.com");
INSERT INTO `wp_postmeta` VALUES("5458","2568","_bbp_anonymous_website","http://buy-levitra.ga/#2453");
INSERT INTO `wp_postmeta` VALUES("5459","2568","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5460","2568","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5461","2568","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5462","2569","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("5463","2569","_bbp_anonymous_email","nswhfrru@yvopzugy.com");
INSERT INTO `wp_postmeta` VALUES("5464","2569","_bbp_anonymous_website","http://buy-doxycycline.us/#7287");
INSERT INTO `wp_postmeta` VALUES("5465","2569","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5466","2569","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5467","2569","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5468","2570","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("5469","2570","_bbp_anonymous_email","vtdbogia@elymrtip.com");
INSERT INTO `wp_postmeta` VALUES("5470","2570","_bbp_anonymous_website","http://genericaccutane.nu/#8709");
INSERT INTO `wp_postmeta` VALUES("5471","2570","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5472","2570","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5473","2570","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5474","2571","_bbp_anonymous_name","propecia hair growth");
INSERT INTO `wp_postmeta` VALUES("5475","2571","_bbp_anonymous_email","uaetibdp@aomnzrfe.com");
INSERT INTO `wp_postmeta` VALUES("5476","2571","_bbp_anonymous_website","http://propeciahairgrowth.ga/#4973");
INSERT INTO `wp_postmeta` VALUES("5477","2571","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5478","2571","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5479","2571","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5480","2572","_bbp_anonymous_name","accutane without prescription");
INSERT INTO `wp_postmeta` VALUES("5481","2572","_bbp_anonymous_email","lbomeylz@tafmxhrv.com");
INSERT INTO `wp_postmeta` VALUES("5482","2572","_bbp_anonymous_website","http://buyaccutaneonline.tk/#6854");
INSERT INTO `wp_postmeta` VALUES("5483","2572","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5484","2572","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5485","2572","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5486","2573","_bbp_anonymous_name","mobic 7.5 mg");
INSERT INTO `wp_postmeta` VALUES("5487","2573","_bbp_anonymous_email","egxmthvd@enibwury.com");
INSERT INTO `wp_postmeta` VALUES("5488","2573","_bbp_anonymous_website","http://mobic75mg.tk/#3746");
INSERT INTO `wp_postmeta` VALUES("5489","2573","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5490","2573","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5491","2573","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5492","2574","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("5493","2574","_bbp_anonymous_email","mxlfqmbu@dbzivutz.com");
INSERT INTO `wp_postmeta` VALUES("5494","2574","_bbp_anonymous_website","http://celebrex200.cf/#5060");
INSERT INTO `wp_postmeta` VALUES("5495","2574","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5496","2574","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5497","2574","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5498","2575","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("5499","2575","_bbp_anonymous_email","kfglzntu@whfqbydd.com");
INSERT INTO `wp_postmeta` VALUES("5500","2575","_bbp_anonymous_website","http://buyretinaonline.ml/#1425");
INSERT INTO `wp_postmeta` VALUES("5501","2575","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5502","2575","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5503","2575","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5504","2576","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("5505","2576","_bbp_anonymous_email","vtdhmxhm@qltfgpqd.com");
INSERT INTO `wp_postmeta` VALUES("5506","2576","_bbp_anonymous_website","http://levitracoupons.ga/#1149");
INSERT INTO `wp_postmeta` VALUES("5507","2576","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5508","2576","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5421","2562","_bbp_anonymous_email","ajyupdoa@gcunrdow.com");
INSERT INTO `wp_postmeta` VALUES("5420","2562","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("5419","2561","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5418","2561","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5410","2560","_bbp_anonymous_website","http://cheapmobic.tk/#9561");
INSERT INTO `wp_postmeta` VALUES("5411","2560","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5412","2560","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5413","2560","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5414","2561","_bbp_anonymous_name","orlistat alli");
INSERT INTO `wp_postmeta` VALUES("5415","2561","_bbp_anonymous_email","skptedlh@hczqngbc.com");
INSERT INTO `wp_postmeta` VALUES("5416","2561","_bbp_anonymous_website","http://alli-120.tk/#6963");
INSERT INTO `wp_postmeta` VALUES("5417","2561","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5395","2557","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5396","2558","_bbp_anonymous_name","zithromax antibiotic");
INSERT INTO `wp_postmeta` VALUES("5397","2558","_bbp_anonymous_email","fhmnywkc@juvxixtg.com");
INSERT INTO `wp_postmeta` VALUES("5398","2558","_bbp_anonymous_website","http://buy-zithromax.info/#5611");
INSERT INTO `wp_postmeta` VALUES("5399","2558","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5400","2558","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5401","2558","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5402","2559","_bbp_anonymous_name","propecia hair loss");
INSERT INTO `wp_postmeta` VALUES("5403","2559","_bbp_anonymous_email","nrjzbqcb@ivvlexnm.com");
INSERT INTO `wp_postmeta` VALUES("5404","2559","_bbp_anonymous_website","http://propeciahairloss.cf/#8644");
INSERT INTO `wp_postmeta` VALUES("5405","2559","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5406","2559","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5407","2559","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5408","2560","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("5409","2560","_bbp_anonymous_email","pqzqmysu@bhasvrzk.com");
INSERT INTO `wp_postmeta` VALUES("5381","2555","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5382","2555","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5383","2555","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5384","2556","_bbp_anonymous_name","clindamycin purchase online");
INSERT INTO `wp_postmeta` VALUES("5385","2556","_bbp_anonymous_email","znpmymyy@yuevnvqv.com");
INSERT INTO `wp_postmeta` VALUES("5386","2556","_bbp_anonymous_website","http://cleocint.tk/#7819");
INSERT INTO `wp_postmeta` VALUES("5387","2556","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5388","2556","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5389","2556","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5390","2557","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5391","2557","_bbp_anonymous_email","wwirdyoo@cabnvlba.com");
INSERT INTO `wp_postmeta` VALUES("5392","2557","_bbp_anonymous_website","http://alli-120.cf/#1033");
INSERT INTO `wp_postmeta` VALUES("5393","2557","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5394","2557","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5380","2555","_bbp_anonymous_website","http://buy-doxycycline.pw/#5837");
INSERT INTO `wp_postmeta` VALUES("5376","2554","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5377","2554","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5378","2555","_bbp_anonymous_name","doxycycline prices");
INSERT INTO `wp_postmeta` VALUES("5379","2555","_bbp_anonymous_email","fmhyyiwb@wzyyhobl.com");
INSERT INTO `wp_postmeta` VALUES("5375","2554","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5369","2553","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5370","2553","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5371","2553","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5372","2554","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5373","2554","_bbp_anonymous_email","itdoffed@ihwenmvd.com");
INSERT INTO `wp_postmeta` VALUES("5374","2554","_bbp_anonymous_website","http://buy-cialis.se/#7503");
INSERT INTO `wp_postmeta` VALUES("6483","2739","_bbp_anonymous_email","eefmayvo@ryukxuyd.com");
INSERT INTO `wp_postmeta` VALUES("6370","2720","_bbp_anonymous_website","http://lisinopril-generic.ga/#9157");
INSERT INTO `wp_postmeta` VALUES("6371","2720","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6372","2720","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6373","2720","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6374","2721","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("6361","2718","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6362","2719","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("6363","2719","_bbp_anonymous_email","zwdfnkdk@lbihxxua.com");
INSERT INTO `wp_postmeta` VALUES("6364","2719","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#5055");
INSERT INTO `wp_postmeta` VALUES("6365","2719","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6366","2719","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6367","2719","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6368","2720","_bbp_anonymous_name","lisinopril");
INSERT INTO `wp_postmeta` VALUES("6369","2720","_bbp_anonymous_email","gxoqrvsh@dcbewzpx.com");
INSERT INTO `wp_postmeta` VALUES("6347","2716","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6348","2716","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6349","2716","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6350","2717","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("6351","2717","_bbp_anonymous_email","egvwwtfw@tdyzivvq.com");
INSERT INTO `wp_postmeta` VALUES("6352","2717","_bbp_anonymous_website","http://allidrug.cf/#5435");
INSERT INTO `wp_postmeta` VALUES("6353","2717","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6354","2717","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6355","2717","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6356","2718","_bbp_anonymous_name","alli 120 capsules");
INSERT INTO `wp_postmeta` VALUES("6357","2718","_bbp_anonymous_email","jfyrhlmq@ftltmjwc.com");
INSERT INTO `wp_postmeta` VALUES("6358","2718","_bbp_anonymous_website","http://alli-120.tk/#9766");
INSERT INTO `wp_postmeta` VALUES("6359","2718","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6360","2718","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6333","2714","_bbp_anonymous_email","toichijl@qhweghks.com");
INSERT INTO `wp_postmeta` VALUES("6334","2714","_bbp_anonymous_website","http://buyaccutaneonline.tk/#8465");
INSERT INTO `wp_postmeta` VALUES("6335","2714","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6336","2714","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6337","2714","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6338","2715","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("6339","2715","_bbp_anonymous_email","bvjgvits@kxalvsjo.com");
INSERT INTO `wp_postmeta` VALUES("6340","2715","_bbp_anonymous_website","http://keflex500.tk/#8739");
INSERT INTO `wp_postmeta` VALUES("6341","2715","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6342","2715","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6343","2715","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6344","2716","_bbp_anonymous_name","how do i get propecia");
INSERT INTO `wp_postmeta` VALUES("6345","2716","_bbp_anonymous_email","qzggacav@nryvmkur.com");
INSERT INTO `wp_postmeta` VALUES("6346","2716","_bbp_anonymous_website","http://propeciahairloss.cf/#8004");
INSERT INTO `wp_postmeta` VALUES("6332","2714","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("6328","2713","_bbp_anonymous_website","http://celebrexcost.ml/#9901");
INSERT INTO `wp_postmeta` VALUES("6329","2713","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6330","2713","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6331","2713","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6327","2713","_bbp_anonymous_email","wkrnfyko@kqzvuhmq.com");
INSERT INTO `wp_postmeta` VALUES("6322","2712","_bbp_anonymous_website","http://levitraprofessional20mg.tk/#9599");
INSERT INTO `wp_postmeta` VALUES("6323","2712","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6324","2712","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6325","2712","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6326","2713","_bbp_anonymous_name","celebrex international pharmacy no prescription");
INSERT INTO `wp_postmeta` VALUES("6308","2710","_bbp_anonymous_name","wellbutrin");
INSERT INTO `wp_postmeta` VALUES("6309","2710","_bbp_anonymous_email","lpxxyffc@dgsdvjeq.com");
INSERT INTO `wp_postmeta` VALUES("6310","2710","_bbp_anonymous_website","http://wellbutrinxl300mg.ml/#9206");
INSERT INTO `wp_postmeta` VALUES("6311","2710","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6312","2710","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6313","2710","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6314","2711","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("6315","2711","_bbp_anonymous_email","rnflrisb@lprxctgr.com");
INSERT INTO `wp_postmeta` VALUES("6316","2711","_bbp_anonymous_website","http://buyretinaonline.ml/#7054");
INSERT INTO `wp_postmeta` VALUES("6317","2711","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6318","2711","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6319","2711","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6320","2712","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("6321","2712","_bbp_anonymous_email","hogtqxvw@pnjjzofv.com");
INSERT INTO `wp_postmeta` VALUES("5622","2595","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5623","2595","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5624","2596","_bbp_anonymous_name","ipledge program accutane prescription for sale");
INSERT INTO `wp_postmeta` VALUES("5625","2596","_bbp_anonymous_email","wvggujrt@aamsimaj.com");
INSERT INTO `wp_postmeta` VALUES("5626","2596","_bbp_anonymous_website","http://accutaneforsale.ml/#3634");
INSERT INTO `wp_postmeta` VALUES("5627","2596","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5628","2596","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5629","2596","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5605","2592","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5606","2593","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5607","2593","_bbp_anonymous_email","qjudcomu@jzaituzq.com");
INSERT INTO `wp_postmeta` VALUES("5608","2593","_bbp_anonymous_website","http://buycialisonline.ml/#3838");
INSERT INTO `wp_postmeta` VALUES("5609","2593","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5610","2593","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5611","2593","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5612","2594","_bbp_anonymous_name","buy generic viagra no prescription");
INSERT INTO `wp_postmeta` VALUES("5613","2594","_bbp_anonymous_email","zecdmquo@ltfletfr.com");
INSERT INTO `wp_postmeta` VALUES("5614","2594","_bbp_anonymous_website","http://viagrasofttabs50mg.ml/#4023");
INSERT INTO `wp_postmeta` VALUES("5615","2594","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5616","2594","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5617","2594","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5618","2595","_bbp_anonymous_name","where to buy accutane");
INSERT INTO `wp_postmeta` VALUES("5619","2595","_bbp_anonymous_email","arxuzaci@sdosppht.com");
INSERT INTO `wp_postmeta` VALUES("5620","2595","_bbp_anonymous_website","http://wheretopurchaseaccutane.cf/#8194");
INSERT INTO `wp_postmeta` VALUES("5621","2595","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5587","2589","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5588","2590","_bbp_anonymous_name","cheapest levitra");
INSERT INTO `wp_postmeta` VALUES("5589","2590","_bbp_anonymous_email","ltxmziep@mzblhcol.com");
INSERT INTO `wp_postmeta` VALUES("5590","2590","_bbp_anonymous_website","http://discountlevitra.pw/#9901");
INSERT INTO `wp_postmeta` VALUES("5591","2590","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5592","2590","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5593","2590","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5594","2591","_bbp_anonymous_name","lexapro onlin3");
INSERT INTO `wp_postmeta` VALUES("5595","2591","_bbp_anonymous_email","uxsitsyl@zdaskayg.com");
INSERT INTO `wp_postmeta` VALUES("5596","2591","_bbp_anonymous_website","http://generic-lexapro.cf/#2907");
INSERT INTO `wp_postmeta` VALUES("5597","2591","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5598","2591","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5599","2591","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5600","2592","_bbp_anonymous_name","cialis otc");
INSERT INTO `wp_postmeta` VALUES("5601","2592","_bbp_anonymous_email","bnoiooqw@xqipqowo.com");
INSERT INTO `wp_postmeta` VALUES("5602","2592","_bbp_anonymous_website","http://discountgenericcialis.tk/#2448");
INSERT INTO `wp_postmeta` VALUES("5603","2592","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5604","2592","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5575","2587","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5576","2588","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5577","2588","_bbp_anonymous_email","gjbmfdqc@enbyejkr.com");
INSERT INTO `wp_postmeta` VALUES("5578","2588","_bbp_anonymous_website","http://buyzithromax.info/#1985");
INSERT INTO `wp_postmeta` VALUES("5579","2588","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5580","2588","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5581","2588","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5582","2589","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5583","2589","_bbp_anonymous_email","asehvdtn@fljocflm.com");
INSERT INTO `wp_postmeta` VALUES("5584","2589","_bbp_anonymous_website","http://cialistadalafil.cf/#2993");
INSERT INTO `wp_postmeta` VALUES("5585","2589","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5586","2589","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5561","2585","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5562","2585","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5563","2585","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5564","2586","_bbp_anonymous_name","buy sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("5565","2586","_bbp_anonymous_email","wyzjpwgn@jodddytj.com");
INSERT INTO `wp_postmeta` VALUES("5566","2586","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#8080");
INSERT INTO `wp_postmeta` VALUES("5567","2586","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5568","2586","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5569","2586","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5570","2587","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5571","2587","_bbp_anonymous_email","ancqutoz@tuyixicf.com");
INSERT INTO `wp_postmeta` VALUES("5572","2587","_bbp_anonymous_website","http://cialisforsaleonline.tk/#8221");
INSERT INTO `wp_postmeta` VALUES("5573","2587","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5574","2587","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5557","2584","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5558","2585","_bbp_anonymous_name","generic viagra");
INSERT INTO `wp_postmeta` VALUES("5559","2585","_bbp_anonymous_email","yidfdwwm@fezcdsnd.com");
INSERT INTO `wp_postmeta` VALUES("5560","2585","_bbp_anonymous_website","http://generic-viagra.info/#9856");
INSERT INTO `wp_postmeta` VALUES("5556","2584","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5555","2584","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5550","2583","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5551","2583","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5552","2584","_bbp_anonymous_name","effexor xr 75 mg");
INSERT INTO `wp_postmeta` VALUES("5553","2584","_bbp_anonymous_email","sgsgfmzr@sqrqvsly.com");
INSERT INTO `wp_postmeta` VALUES("5554","2584","_bbp_anonymous_website","http://venlafaxineeffexor.ml/#5620");
INSERT INTO `wp_postmeta` VALUES("5530","2580","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#5932");
INSERT INTO `wp_postmeta` VALUES("5531","2580","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5532","2580","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5533","2580","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5534","2581","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("5535","2581","_bbp_anonymous_email","flrvijdt@syiqojqz.com");
INSERT INTO `wp_postmeta` VALUES("5536","2581","_bbp_anonymous_website","http://advair-diskus.ml/#3353");
INSERT INTO `wp_postmeta` VALUES("5537","2581","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5538","2581","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5539","2581","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5540","2582","_bbp_anonymous_name","nexium capsules");
INSERT INTO `wp_postmeta` VALUES("5541","2582","_bbp_anonymous_email","rsdghtsu@kwiioopt.com");
INSERT INTO `wp_postmeta` VALUES("5542","2582","_bbp_anonymous_website","http://nexiumdrug.cf/#1723");
INSERT INTO `wp_postmeta` VALUES("5543","2582","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5544","2582","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5545","2582","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5546","2583","_bbp_anonymous_name","propecia from canada");
INSERT INTO `wp_postmeta` VALUES("5547","2583","_bbp_anonymous_email","frytyfri@rajscnvy.com");
INSERT INTO `wp_postmeta` VALUES("5548","2583","_bbp_anonymous_website","http://finasteride.ga/#3661");
INSERT INTO `wp_postmeta` VALUES("5549","2583","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("1012","1373","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:198;s:4:\"file\";s:26:\"2013/04/Logo48hcyan-01.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-300x106.png\";s:5:\"width\";i:300;s:6:\"height\";i:106;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-495x198.png\";s:5:\"width\";i:495;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x198.png\";s:5:\"width\";i:450;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x159.png\";s:5:\"width\";i:450;s:6:\"height\";i:159;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("6482","2739","_bbp_anonymous_name","order generic viagra");
INSERT INTO `wp_postmeta` VALUES("5739","2615","_bbp_anonymous_email","wwfouqlk@wvslpgkc.com");
INSERT INTO `wp_postmeta` VALUES("5722","2612","_bbp_anonymous_website","http://nolvadex-xt.tk/#4121");
INSERT INTO `wp_postmeta` VALUES("5723","2612","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5724","2612","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5725","2612","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5726","2613","_bbp_anonymous_name","buy prozac online");
INSERT INTO `wp_postmeta` VALUES("5727","2613","_bbp_anonymous_email","tsztcxdl@biprnkae.com");
INSERT INTO `wp_postmeta` VALUES("5728","2613","_bbp_anonymous_website","http://prozac.in/#5847");
INSERT INTO `wp_postmeta` VALUES("5729","2613","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5730","2613","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5731","2613","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5732","2614","_bbp_anonymous_name","bupropion");
INSERT INTO `wp_postmeta` VALUES("5733","2614","_bbp_anonymous_email","cecsajyi@ttrvmbzg.com");
INSERT INTO `wp_postmeta` VALUES("5734","2614","_bbp_anonymous_website","http://bupropionxl300.cf/#1310");
INSERT INTO `wp_postmeta` VALUES("5735","2614","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5736","2614","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5737","2614","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5738","2615","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("5704","2609","_bbp_anonymous_website","http://zoloft200mg.tk/#8978");
INSERT INTO `wp_postmeta` VALUES("5705","2609","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5706","2609","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5707","2609","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5708","2610","_bbp_anonymous_name","finasteride");
INSERT INTO `wp_postmeta` VALUES("5709","2610","_bbp_anonymous_email","dzpnnojo@pptbtyam.com");
INSERT INTO `wp_postmeta` VALUES("5710","2610","_bbp_anonymous_website","http://finasteride.ml/#4214");
INSERT INTO `wp_postmeta` VALUES("5711","2610","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5712","2610","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5713","2610","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5714","2611","_bbp_anonymous_name","valtrex");
INSERT INTO `wp_postmeta` VALUES("5715","2611","_bbp_anonymous_email","obzesvyd@ilrfevxz.com");
INSERT INTO `wp_postmeta` VALUES("5716","2611","_bbp_anonymous_website","http://valtrex-500-mg.ga/#8246");
INSERT INTO `wp_postmeta` VALUES("5717","2611","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5718","2611","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5719","2611","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5720","2612","_bbp_anonymous_name","where to buy nolvadex");
INSERT INTO `wp_postmeta` VALUES("5721","2612","_bbp_anonymous_email","yociqzag@azbqbhnh.com");
INSERT INTO `wp_postmeta` VALUES("5687","2606","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5688","2606","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5689","2606","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5690","2607","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5691","2607","_bbp_anonymous_email","zagqwiks@wgqrgafb.com");
INSERT INTO `wp_postmeta` VALUES("5692","2607","_bbp_anonymous_website","http://buy-tadalafil-online.cf/#2693");
INSERT INTO `wp_postmeta` VALUES("5693","2607","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5694","2607","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5695","2607","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5696","2608","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5697","2608","_bbp_anonymous_email","zbrjxcxu@jkxemobi.com");
INSERT INTO `wp_postmeta` VALUES("5698","2608","_bbp_anonymous_website","http://genericsildenafil.us/#3436");
INSERT INTO `wp_postmeta` VALUES("5699","2608","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5700","2608","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5701","2608","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5702","2609","_bbp_anonymous_name","zoloft buy");
INSERT INTO `wp_postmeta` VALUES("5703","2609","_bbp_anonymous_email","luumfozv@qzkuxtlg.com");
INSERT INTO `wp_postmeta` VALUES("5670","2603","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5671","2603","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5672","2604","_bbp_anonymous_name","Cartier love bracelet women 18k white gold");
INSERT INTO `wp_postmeta` VALUES("5673","2604","_bbp_anonymous_email","hfcsvbpqgy@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("5674","2604","_bbp_anonymous_website","http://cartierlovebraceletunisexwhitegold.blogspot.com/");
INSERT INTO `wp_postmeta` VALUES("5675","2604","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5676","2604","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("5677","2604","_bbp_author_ip","118.97.195.42");
INSERT INTO `wp_postmeta` VALUES("5678","2605","_bbp_anonymous_name","duloxetine cymbalta");
INSERT INTO `wp_postmeta` VALUES("5679","2605","_bbp_anonymous_email","eyolamte@msvluogc.com");
INSERT INTO `wp_postmeta` VALUES("5680","2605","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#6131");
INSERT INTO `wp_postmeta` VALUES("5681","2605","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5682","2605","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5683","2605","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5684","2606","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5685","2606","_bbp_anonymous_email","ssuomfyg@qxrsfrpa.com");
INSERT INTO `wp_postmeta` VALUES("5686","2606","_bbp_anonymous_website","http://genericzithromax.se/#1431");
INSERT INTO `wp_postmeta` VALUES("5659","2601","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5660","2602","_bbp_anonymous_name","view homepage");
INSERT INTO `wp_postmeta` VALUES("5661","2602","_bbp_anonymous_email","rlxgcvyr@ifxyzymx.com");
INSERT INTO `wp_postmeta` VALUES("5662","2602","_bbp_anonymous_website","http://wellbutrin150mg.tk/#6631");
INSERT INTO `wp_postmeta` VALUES("5663","2602","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5664","2602","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5665","2602","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5666","2603","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5667","2603","_bbp_anonymous_email","ldvnlkwn@vwxjgiev.com");
INSERT INTO `wp_postmeta` VALUES("5668","2603","_bbp_anonymous_website","http://buycialisonlinecheap.tk/#2505");
INSERT INTO `wp_postmeta` VALUES("5669","2603","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5645","2599","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5646","2599","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5647","2599","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5648","2600","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5649","2600","_bbp_anonymous_email","tboosfkx@ivduppwu.com");
INSERT INTO `wp_postmeta` VALUES("5650","2600","_bbp_anonymous_website","http://zithromaxzpack.ml/#4409");
INSERT INTO `wp_postmeta` VALUES("5651","2600","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5652","2600","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5653","2600","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5654","2601","_bbp_anonymous_name","buy cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("5655","2601","_bbp_anonymous_email","lnlkwdup@wmdipulk.com");
INSERT INTO `wp_postmeta` VALUES("5656","2601","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#2535");
INSERT INTO `wp_postmeta` VALUES("5657","2601","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5658","2601","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5644","2599","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#6515");
INSERT INTO `wp_postmeta` VALUES("5640","2598","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5641","2598","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5642","2599","_bbp_anonymous_name","doxycycline 100mg");
INSERT INTO `wp_postmeta` VALUES("5643","2599","_bbp_anonymous_email","tgcqagzg@ixremspp.com");
INSERT INTO `wp_postmeta` VALUES("5639","2598","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5633","2597","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5634","2597","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5635","2597","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5636","2598","_bbp_anonymous_name","celexa");
INSERT INTO `wp_postmeta` VALUES("5637","2598","_bbp_anonymous_email","mgvelpwg@xakfocfw.com");
INSERT INTO `wp_postmeta` VALUES("5638","2598","_bbp_anonymous_website","http://celexageneric.ml/#9197");
INSERT INTO `wp_postmeta` VALUES("3679","2271","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5977","2654","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5978","2655","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5979","2655","_bbp_anonymous_email","nsojlkst@ughrcdjn.com");
INSERT INTO `wp_postmeta` VALUES("5980","2655","_bbp_anonymous_website","http://alli-pills.cf/#5874");
INSERT INTO `wp_postmeta` VALUES("5981","2655","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5982","2655","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5983","2655","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5984","2656","_bbp_anonymous_name","generic for augmentin");
INSERT INTO `wp_postmeta` VALUES("5985","2656","_bbp_anonymous_email","cylvnrxp@xqgyxrxf.com");
INSERT INTO `wp_postmeta` VALUES("5986","2656","_bbp_anonymous_website","http://genericforaugmentin.tk/#5302");
INSERT INTO `wp_postmeta` VALUES("5987","2656","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5988","2656","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5989","2656","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5990","2657","_bbp_anonymous_name","acyclovir 5 cream");
INSERT INTO `wp_postmeta` VALUES("5991","2657","_bbp_anonymous_email","vxqyewlv@uduvoklg.com");
INSERT INTO `wp_postmeta` VALUES("5992","2657","_bbp_anonymous_website","http://orderacyclovir.ml/#8293");
INSERT INTO `wp_postmeta` VALUES("5993","2657","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5994","2657","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5995","2657","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5996","2658","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5997","2658","_bbp_anonymous_email","btyoamin@apgjelef.com");
INSERT INTO `wp_postmeta` VALUES("5998","2658","_bbp_anonymous_website","http://alli-drug.cf/#3705");
INSERT INTO `wp_postmeta` VALUES("5999","2658","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6000","2658","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6001","2658","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6002","2659","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("6003","2659","_bbp_anonymous_email","zjuutvwd@uoucmxtf.com");
INSERT INTO `wp_postmeta` VALUES("6004","2659","_bbp_anonymous_website","http://generic-prozac.cf/#5254");
INSERT INTO `wp_postmeta` VALUES("6005","2659","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6006","2659","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6007","2659","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6008","2660","_bbp_anonymous_name","generic viagra 100mg");
INSERT INTO `wp_postmeta` VALUES("6009","2660","_bbp_anonymous_email","kzzrtvlt@jbmludyq.com");
INSERT INTO `wp_postmeta` VALUES("6010","2660","_bbp_anonymous_website","http://viagr.ml/#2976");
INSERT INTO `wp_postmeta` VALUES("6011","2660","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6012","2660","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6013","2660","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6014","2661","_bbp_anonymous_name","finasteride medication");
INSERT INTO `wp_postmeta` VALUES("6015","2661","_bbp_anonymous_email","svndkjqd@xqjhhqua.com");
INSERT INTO `wp_postmeta` VALUES("6016","2661","_bbp_anonymous_website","http://finasteridemedication.tk/#8239");
INSERT INTO `wp_postmeta` VALUES("6017","2661","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6018","2661","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6019","2661","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6020","2662","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("5959","2651","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5960","2652","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("5961","2652","_bbp_anonymous_email","vcdyypxu@lgewgvmo.com");
INSERT INTO `wp_postmeta` VALUES("5962","2652","_bbp_anonymous_website","http://generic-vardenafil.tk/#3476");
INSERT INTO `wp_postmeta` VALUES("5963","2652","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5964","2652","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5965","2652","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5966","2653","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5967","2653","_bbp_anonymous_email","vgrbzzof@uburofux.com");
INSERT INTO `wp_postmeta` VALUES("5968","2653","_bbp_anonymous_website","http://tadalafil20mg.tk/#9638");
INSERT INTO `wp_postmeta` VALUES("5969","2653","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5970","2653","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5971","2653","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5972","2654","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5973","2654","_bbp_anonymous_email","cafsesjx@rejbwcce.com");
INSERT INTO `wp_postmeta` VALUES("5974","2654","_bbp_anonymous_website","http://propeciahairgrowth.tk/#6144");
INSERT INTO `wp_postmeta` VALUES("5975","2