<?php

class Ithemes_Sync_Verb_ITSEC_Get_Malware_Scan_Results extends Ithemes_Sync_Verb {

	public static $name = 'itsec-get-malware-scan-results';
	public static $description = '';

	public $default_arguments = array(
		'type'  => '', //Type of reports to filter, null for all, 'reports' or 'scans'
		'count' => 10, // The number of items to retun
	);

	public function run( $arguments ) {

		global $itsec_logger;

		$items                   = $itsec_logger->get_events( 'malware' );
		$scan_count              = 0;
		$report_count            = 0;
		$total_count             = 0;
		$return_array            = array();
		$return_array['reports'] = array();
		$return_array['scans']   = array();
		$end                     = false;

		foreach ( $items as $item ) { //loop through and group 404s

			if ( $end === true ) {
				break;
			}

			$log_data  = maybe_unserialize( $item['log_data'] );
			$action    = isset( $log_data['type'] ) ? sanitize_text_field( $log_data['type'] ) : '';
			$good_item = true;

			if ( $action == 'Malware Scan Report' ) {

				$array = 'reports';
				$count = $report_count;

			} elseif ( $action == 'Malware Scan Requested' ) {

				$array = 'scans';
				$count = $scan_count;

			} else {

				$good_item = false;

			}

			if ( $good_item === true ) {

				$return_array[$array][$count]['time'] = sanitize_text_field( $item['log_date'] );
				$return_array[$array][$count]['host'] = sanitize_text_field( $item['log_host'] );

				if ( strlen( trim( sanitize_text_field( $item['log_username'] ) ) ) > 0 ) {

					$return_array[$array][$count]['user'] = sanitize_text_field( $item['log_username'] );

				} elseif ( intval( $item['log_user'] ) > 0 && ITSEC_Lib::user_id_exists( $item['log_user'] ) ) {

					$user = get_user_by( 'id', $item['log_user'] );

					$return_array[$array][$count]['user'] = $user->data->user_login;

				} else {

					$return_array[$array][$count]['user'] = '';

				}

				if ( isset( $log_data['resource'] ) ) {
					$return_array[$array][$count]['report'] = array(
						'resource' => $log_data['resource'],
					);
				}

				if ( isset( $log_data['report'] ) ) {
					$return_array[$array][$count]['report']['results'] = $log_data['report'];
				}

				if ( $action == 'Malware Scan Report' ) {

					$report_count ++;

				} elseif ( $action == 'Malware Scan Requested' ) {
					$scan_count ++;

				}

			}

			if ( isset( $arguments['count'] ) ) {

				$count = absint( $arguments['count'] );

			} else {

				$count = 10;

			}

			if ( $count > 0 ) {

				$count = $count - 1;

				if ( isset( $arguments['type'] ) ) {

					$type = sanitize_text_field( $arguments['type'] );

				} else {

					$type = 'all';

				}

				switch ( $type ) {

					case 'reports':

						if ( $report_count == $count ) {
							$end = true;
						}
						break;

					case 'scans':

						if ( $scan_count == $count ) {
							$end = true;
						}
						break;

					default:

						if ( $total_count == $count - 1 ) {
							$end = true;
						}
						break;

				}

			}

			$total_count ++;

		}

		if ( isset( $arguments['type'] ) ) {

			switch ( $arguments['type'] ) {

				case 'reports':

					return $return_array['reports'];
					break;

				case 'scans':

					return $return_array['scans'];
					break;

				default:
					break;

			}

		}

		return $return_array;

	}

}
