(function($){
    $.fn.validationEngineLanguage = function(){
    };
    $.validationEngineLanguage = {
        newLang: function(){
            $.validationEngineLanguage.allRules = {
                "required": { // Add your regex rules here, you can take telephone as an example
                    "regex": "none",
                    "alertText": "* שדה זה הוא חובה",
                    "alertTextCheckboxMultiple": "* אנא בחר אפשרות",
                    "alertTextCheckboxe": "* תיבת הבחירה היא חובה",
                    "alertTextDateRange": "* שני תאריכי הטווח הם חובה"
                },
                "requiredInFunction": { 
                    "func": function(field, rules, i, options){
                        return (field.val() == "test") ? true : false;
                    },
                    "alertText": "* שדה חייב להיות שווה לבדיקה"
                },
                "dateRange": {
                    "regex": "none",
                    "alertText": "* טווח תאריכים ",
                    "alertText2": "לא תקין"
                },
                "dateTimeRange": {
                    "regex": "none",
                    "alertText": "* טווח תאריך-זמן ",
                    "alertText2": "לא תקין"
                },
                "minSize": {
                    "regex": "none",
                    "alertText": "* דרושים לפחות ",
                    "alertText2": " תוים"
                },
                "maxSize": {
                    "regex": "none",
                    "alertText": "* מותרים לכל היותר ",
                    "alertText2": " תוים"
                },
				"groupRequired": {
                    "regex": "none",
                    "alertText": "* חובה למלא אחד מהשדות"
                },
                "min": {
                    "regex": "none",
                    "alertText": "* הערך המינימלי הוא "
                },
                "max": {
                    "regex": "none",
                    "alertText": "* הערך המקסימלי הוא "
                },
                "past": {
                    "regex": "none",
                    "alertText": "* תאריך קודם ל "
                },
                "future": {
                    "regex": "none",
                    "alertText": "* תאריך מאוחר מ "
                },	
                "maxCheckbox": {
                    "regex": "none",
                    "alertText": "* מותרות לכל היותר ",
                    "alertText2": " אופציות"
                },
                "minCheckbox": {
                    "regex": "none",
                    "alertText": "* אנא בחר ",
                    "alertText2": " אופציות"
                },
                "equals": {
                    "regex": "none",
                    "alertText": "* השדות לא תואמים"
                },
                "creditCard": {
                    "regex": "none",
                    "alertText": "* מספר כרטיס אשראי לא תקין"
                },
                "phone": {
                    // credit: jquery.h5validate.js / orefalo
                    "regex": /^([\+][0-9]{1,3}[\ \.\-])?([\(]{1}[0-9]{2,6}[\)])?([0-9\ \.\-\/]{3,20})((x|ext|extension)[\ ]?[0-9]{1,4})?$/,
                    "alertText": "* מספר טלפון לא תקין"
                },
                "email": {
                    // HTML5 compatible email regex ( http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#    e-mail-state-%28type=email%29 )
                    "regex": /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
                    "alertText": "* תיבת דואר אלקטרוני לא תקינה"
                },
                "integer": {
                    "regex": /^[\-\+]?\d+$/,
                    "alertText": "* מספר שלם לא תקין"
                },
                "number": {
                    // Number, including positive, negative, and floating decimal. credit: orefalo
                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
                    "alertText": "* מספר בעל נקודה עשרונית לא תקין"
                },
                "date": {                    
                    //	Check if date is valid by leap year
			"func": function (field) {
					var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
					var match = pattern.exec(field.val());
					if (match == null)
					   return false;
	
					var year = match[1];
					var month = match[2]*1;
					var day = match[3]*1;					
					var date = new Date(year, month - 1, day); // because months starts from 0.
	
					return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
				},                		
			 "alertText": "* תאריך לא תקין, חייב ליות בתבנית YYYY-MM-DD"
                },
                "ipv4": {
                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
                    "alertText": "* כתובת IP לא תקינה"
                },
                "url": {
                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,
                    "alertText": "* קישור לא תקין"
                },
                "onlyNumberSp": {
                    "regex": /^[0-9\ ]+$/,
                    "alertText": "* מספרים בלבד"
                },
                "onlyLetterSp": {
                    "regex": /^[a-zA-Z\ \']+$/,
                    "alertText": "* אותיות באנגלית בלבד"
                },
                "onlyLetterNumber": {
                    "regex": /^[0-9a-zA-Z]+$/,
                    "alertText": "* אסורים תוים מיוחדים"
                }
            };
            
        }
    };

    $.validationEngineLanguage.newLang();
    
})(jQuery);
