DROP TABLE IF EXISTS `pwk_access`;

CREATE TABLE `pwk_access` (
  `login` varchar(100) NOT NULL,
  `idsite` int(10) unsigned NOT NULL,
  `access` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`login`,`idsite`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_archive_blob_2015_04`;

CREATE TABLE `pwk_archive_blob_2015_04` (
  `idarchive` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `idsite` int(10) unsigned DEFAULT NULL,
  `date1` date DEFAULT NULL,
  `date2` date DEFAULT NULL,
  `period` tinyint(3) unsigned DEFAULT NULL,
  `ts_archived` datetime DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`idarchive`,`name`),
  KEY `index_period_archived` (`period`,`ts_archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_archive_numeric_2015_04`;

CREATE TABLE `pwk_archive_numeric_2015_04` (
  `idarchive` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `idsite` int(10) unsigned DEFAULT NULL,
  `date1` date DEFAULT NULL,
  `date2` date DEFAULT NULL,
  `period` tinyint(3) unsigned DEFAULT NULL,
  `ts_archived` datetime DEFAULT NULL,
  `value` double DEFAULT NULL,
  PRIMARY KEY (`idarchive`,`name`),
  KEY `index_idsite_dates_period` (`idsite`,`date1`,`date2`,`period`,`ts_archived`),
  KEY `index_period_archived` (`period`,`ts_archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `pwk_archive_numeric_2015_04` VALUES("2","done","1","2015-04-17","2015-04-17","1","2015-04-18 09:22:55","1");
INSERT INTO `pwk_archive_numeric_2015_04` VALUES("10","done","1","2015-04-16","2015-04-16","1","2015-04-18 09:47:06","1");


DROP TABLE IF EXISTS `pwk_goal`;

CREATE TABLE `pwk_goal` (
  `idsite` int(11) NOT NULL,
  `idgoal` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `match_attribute` varchar(20) NOT NULL,
  `pattern` varchar(255) NOT NULL,
  `pattern_type` varchar(10) NOT NULL,
  `case_sensitive` tinyint(4) NOT NULL,
  `allow_multiple` tinyint(4) NOT NULL,
  `revenue` float NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idsite`,`idgoal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_log_action`;

CREATE TABLE `pwk_log_action` (
  `idaction` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text,
  `hash` int(10) unsigned NOT NULL,
  `type` tinyint(3) unsigned DEFAULT NULL,
  `url_prefix` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`idaction`),
  KEY `index_type_hash` (`type`,`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `pwk_log_action` VALUES("1","Les 48h de la pige | Un événement Profession : Pigiste","190890611","4","");
INSERT INTO `pwk_log_action` VALUES("2","48h.pigiste.org/","1508183575","1","0");
INSERT INTO `pwk_log_action` VALUES("3","Les 48h de la pige | Contact","3823947456","4","");
INSERT INTO `pwk_log_action` VALUES("4","48h.pigiste.org/contact/feed/","769270981","1","0");
INSERT INTO `pwk_log_action` VALUES("5","Les 48h de la pige | Le programme : vendredi","3965133318","4","");
INSERT INTO `pwk_log_action` VALUES("6","48h.pigiste.org/le-programme/le-programme-vendredi/feed/","3900886398","1","0");


DROP TABLE IF EXISTS `pwk_log_conversion`;

CREATE TABLE `pwk_log_conversion` (
  `idvisit` int(10) unsigned NOT NULL,
  `idsite` int(10) unsigned NOT NULL,
  `idvisitor` binary(8) NOT NULL,
  `server_time` datetime NOT NULL,
  `idaction_url` int(11) DEFAULT NULL,
  `idlink_va` int(11) DEFAULT NULL,
  `idgoal` int(10) NOT NULL,
  `buster` int(10) unsigned NOT NULL,
  `idorder` varchar(100) DEFAULT NULL,
  `items` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_region` char(2) DEFAULT NULL,
  `location_country` char(3) NOT NULL,
  `location_city` varchar(255) DEFAULT NULL,
  `visitor_returning` tinyint(1) NOT NULL,
  `visitor_days_since_order` smallint(5) unsigned NOT NULL,
  `visitor_count_visits` smallint(5) unsigned NOT NULL,
  `visitor_days_since_first` smallint(5) unsigned NOT NULL,
  `referer_type` tinyint(1) unsigned DEFAULT NULL,
  `referer_name` varchar(70) DEFAULT NULL,
  `referer_keyword` varchar(255) DEFAULT NULL,
  `revenue` float DEFAULT NULL,
  `revenue_discount` float DEFAULT NULL,
  `revenue_shipping` float DEFAULT NULL,
  `revenue_subtotal` float DEFAULT NULL,
  `revenue_tax` float DEFAULT NULL,
  `custom_var_k1` varchar(200) DEFAULT NULL,
  `custom_var_v1` varchar(200) DEFAULT NULL,
  `custom_var_k2` varchar(200) DEFAULT NULL,
  `custom_var_v2` varchar(200) DEFAULT NULL,
  `custom_var_k3` varchar(200) DEFAULT NULL,
  `custom_var_v3` varchar(200) DEFAULT NULL,
  `custom_var_k4` varchar(200) DEFAULT NULL,
  `custom_var_v4` varchar(200) DEFAULT NULL,
  `custom_var_k5` varchar(200) DEFAULT NULL,
  `custom_var_v5` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idvisit`,`idgoal`,`buster`),
  UNIQUE KEY `unique_idsite_idorder` (`idsite`,`idorder`),
  KEY `index_idsite_datetime` (`idsite`,`server_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_log_conversion_item`;

CREATE TABLE `pwk_log_conversion_item` (
  `idsite` int(10) unsigned NOT NULL,
  `idvisitor` binary(8) NOT NULL,
  `server_time` datetime NOT NULL,
  `idvisit` int(10) unsigned NOT NULL,
  `idorder` varchar(100) NOT NULL,
  `idaction_sku` int(10) unsigned NOT NULL,
  `idaction_name` int(10) unsigned NOT NULL,
  `idaction_category` int(10) unsigned NOT NULL,
  `idaction_category2` int(10) unsigned NOT NULL,
  `idaction_category3` int(10) unsigned NOT NULL,
  `idaction_category4` int(10) unsigned NOT NULL,
  `idaction_category5` int(10) unsigned NOT NULL,
  `price` float NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `deleted` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`idvisit`,`idorder`,`idaction_sku`),
  KEY `index_idsite_servertime` (`idsite`,`server_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_log_link_visit_action`;

CREATE TABLE `pwk_log_link_visit_action` (
  `idlink_va` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idsite` int(10) unsigned NOT NULL,
  `idvisitor` binary(8) NOT NULL,
  `idvisit` int(10) unsigned NOT NULL,
  `idaction_url_ref` int(10) unsigned DEFAULT '0',
  `idaction_name_ref` int(10) unsigned NOT NULL,
  `custom_float` float DEFAULT NULL,
  `server_time` datetime NOT NULL,
  `idaction_name` int(10) unsigned DEFAULT NULL,
  `idaction_url` int(10) unsigned DEFAULT NULL,
  `time_spent_ref_action` int(10) unsigned NOT NULL,
  `idaction_event_action` int(10) unsigned DEFAULT NULL,
  `idaction_event_category` int(10) unsigned DEFAULT NULL,
  `idaction_content_interaction` int(10) unsigned DEFAULT NULL,
  `idaction_content_name` int(10) unsigned DEFAULT NULL,
  `idaction_content_piece` int(10) unsigned DEFAULT NULL,
  `idaction_content_target` int(10) unsigned DEFAULT NULL,
  `custom_var_k1` varchar(200) DEFAULT NULL,
  `custom_var_v1` varchar(200) DEFAULT NULL,
  `custom_var_k2` varchar(200) DEFAULT NULL,
  `custom_var_v2` varchar(200) DEFAULT NULL,
  `custom_var_k3` varchar(200) DEFAULT NULL,
  `custom_var_v3` varchar(200) DEFAULT NULL,
  `custom_var_k4` varchar(200) DEFAULT NULL,
  `custom_var_v4` varchar(200) DEFAULT NULL,
  `custom_var_k5` varchar(200) DEFAULT NULL,
  `custom_var_v5` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idlink_va`),
  KEY `index_idvisit` (`idvisit`),
  KEY `index_idsite_servertime` (`idsite`,`server_time`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `pwk_log_link_visit_action` VALUES("1","1","&\0$","1","0","0","","2015-04-18 09:43:43","1","2","0","","","","","","","","","","","","","","","","");
INSERT INTO `pwk_log_link_visit_action` VALUES("2","1","ŊOn`","2","0","0","1411","2015-04-21 16:03:10","3","4","0","","","","","","","","","","","","","","","","");
INSERT INTO `pwk_log_link_visit_action` VALUES("3","1",";/{y>","3","0","0","551","2015-04-23 08:45:34","5","6","0","","","","","","","","","","","","","","","","");


DROP TABLE IF EXISTS `pwk_log_profiling`;

CREATE TABLE `pwk_log_profiling` (
  `query` text NOT NULL,
  `count` int(10) unsigned DEFAULT NULL,
  `sum_time_ms` float DEFAULT NULL,
  UNIQUE KEY `query` (`query`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_log_visit`;

CREATE TABLE `pwk_log_visit` (
  `idvisit` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idsite` int(10) unsigned NOT NULL,
  `idvisitor` binary(8) NOT NULL,
  `visit_last_action_time` datetime NOT NULL,
  `config_id` binary(8) NOT NULL,
  `location_ip` varbinary(16) NOT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_region` char(2) DEFAULT NULL,
  `visitor_localtime` time NOT NULL,
  `location_country` char(3) NOT NULL,
  `location_city` varchar(255) DEFAULT NULL,
  `config_device_type` tinyint(100) DEFAULT NULL,
  `config_device_model` varchar(100) DEFAULT NULL,
  `config_os` char(3) NOT NULL,
  `config_os_version` varchar(100) DEFAULT NULL,
  `visit_total_events` smallint(5) unsigned NOT NULL,
  `visitor_days_since_last` smallint(5) unsigned NOT NULL,
  `config_quicktime` tinyint(1) NOT NULL,
  `config_pdf` tinyint(1) NOT NULL,
  `config_realplayer` tinyint(1) NOT NULL,
  `config_silverlight` tinyint(1) NOT NULL,
  `config_windowsmedia` tinyint(1) NOT NULL,
  `config_java` tinyint(1) NOT NULL,
  `config_gears` tinyint(1) NOT NULL,
  `config_resolution` varchar(9) NOT NULL,
  `config_cookie` tinyint(1) NOT NULL,
  `config_director` tinyint(1) NOT NULL,
  `config_flash` tinyint(1) NOT NULL,
  `config_device_brand` varchar(100) DEFAULT NULL,
  `config_browser_version` varchar(20) NOT NULL,
  `visitor_returning` tinyint(1) NOT NULL,
  `visitor_days_since_order` smallint(5) unsigned NOT NULL,
  `visitor_count_visits` smallint(5) unsigned NOT NULL,
  `visit_entry_idaction_name` int(11) unsigned NOT NULL,
  `visit_entry_idaction_url` int(11) unsigned NOT NULL,
  `visit_first_action_time` datetime NOT NULL,
  `visitor_days_since_first` smallint(5) unsigned NOT NULL,
  `visit_total_time` smallint(5) unsigned NOT NULL,
  `user_id` varchar(200) DEFAULT NULL,
  `visit_goal_buyer` tinyint(1) NOT NULL,
  `visit_goal_converted` tinyint(1) NOT NULL,
  `visit_exit_idaction_name` int(11) unsigned NOT NULL,
  `visit_exit_idaction_url` int(11) unsigned DEFAULT '0',
  `referer_url` text NOT NULL,
  `location_browser_lang` varchar(20) NOT NULL,
  `config_browser_engine` varchar(10) NOT NULL,
  `config_browser_name` varchar(10) NOT NULL,
  `referer_type` tinyint(1) unsigned DEFAULT NULL,
  `referer_name` varchar(70) DEFAULT NULL,
  `visit_total_actions` smallint(5) unsigned NOT NULL,
  `visit_total_searches` smallint(5) unsigned NOT NULL,
  `referer_keyword` varchar(255) DEFAULT NULL,
  `location_provider` varchar(100) DEFAULT NULL,
  `custom_var_k1` varchar(200) DEFAULT NULL,
  `custom_var_v1` varchar(200) DEFAULT NULL,
  `custom_var_k2` varchar(200) DEFAULT NULL,
  `custom_var_v2` varchar(200) DEFAULT NULL,
  `custom_var_k3` varchar(200) DEFAULT NULL,
  `custom_var_v3` varchar(200) DEFAULT NULL,
  `custom_var_k4` varchar(200) DEFAULT NULL,
  `custom_var_v4` varchar(200) DEFAULT NULL,
  `custom_var_k5` varchar(200) DEFAULT NULL,
  `custom_var_v5` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idvisit`),
  KEY `index_idsite_config_datetime` (`idsite`,`config_id`,`visit_last_action_time`),
  KEY `index_idsite_datetime` (`idsite`,`visit_last_action_time`),
  KEY `index_idsite_idvisitor` (`idsite`,`idvisitor`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `pwk_log_visit` VALUES("1","1","&\0$","2015-04-18 09:43:43","ݖב0","P\0\0","","","","11:43:43","fr","","1","iPhone","IOS","8.1","0","0","0","0","0","0","0","0","0","750x1334","1","0","0","AP","8.0","0","0","1","1","2","2015-04-18 09:43:43","0","0","","0","0","1","2","http://pigiste.org/pigiste.org/apero-pigistes-a-paris-18-mars-la-com-et-nous/","fr-fr","WebKit","MF","3","pigiste.org","1","0","","Ip","","","","","","","","","","");
INSERT INTO `pwk_log_visit` VALUES("2","1","ŊOn`","2015-04-21 16:03:10"," P#","N\0\0","","","","18:03:10","fr","","0","","MAC","10.6","0","0","1","0","0","0","0","1","0","1920x1200","1","0","1","","37.0","0","0","1","3","4","2015-04-21 16:03:10","0","0","","0","0","3","4","http://www.google.fr/url?sa=t&rct=j&q=&esrc=s&source=web&cd=6&ved=0CD4QFjAF&url=http://48h.pigiste.org/contact/feed/&ei=oHQ2VbIs0spombeB2A8&usg=AFQjCNECGlGsgVtKQVScb5FJNIs08IuhGQ&bvm=bv.91071109,d.d2s","fr","Gecko","FF","2","Google","1","0","","proxad.net","","","","","","","","","","");
INSERT INTO `pwk_log_visit` VALUES("3","1",";/{y>","2015-04-23 08:45:34","K`fWC","Y\\\0\0","","","","10:45:34","fr","","0","","WIN","7","0","0","0","1","0","0","0","1","0","1366x768","1","0","1","","42.0","0","0","1","5","6","2015-04-23 08:45:34","0","0","","0","0","5","6","https://www.google.fr/","fr-fr","Blink","CH","2","Google","1","0","","bbox.fr","","","","","","","","","","");


DROP TABLE IF EXISTS `pwk_logger_message`;

CREATE TABLE `pwk_logger_message` (
  `idlogger_message` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) DEFAULT NULL,
  `timestamp` timestamp NULL DEFAULT NULL,
  `level` varchar(16) DEFAULT NULL,
  `message` text,
  PRIMARY KEY (`idlogger_message`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_option`;

CREATE TABLE `pwk_option` (
  `option_name` varchar(255) NOT NULL,
  `option_value` longtext NOT NULL,
  `autoload` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `pwk_option` VALUES("branding_use_custom_logo","0","1");
INSERT INTO `pwk_option` VALUES("enableBrowserTriggerArchiving","1","1");
INSERT INTO `pwk_option` VALUES("enableUpdateCommunicationPlugins","1","0");
INSERT INTO `pwk_option` VALUES("lastTrackerCronRun","1430038588","0");
INSERT INTO `pwk_option` VALUES("MobileMessaging_DelegatedManagement","false","0");
INSERT INTO `pwk_option` VALUES("piwikUrl","http://piwik.pigiste.org/","1");
INSERT INTO `pwk_option` VALUES("PrivacyManager.doNotTrackEnabled","1","0");
INSERT INTO `pwk_option` VALUES("PrivacyManager.ipAnonymizerEnabled","1","0");
INSERT INTO `pwk_option` VALUES("SitesManager_DefaultCurrency","EUR","0");
INSERT INTO `pwk_option` VALUES("SitesManager_DefaultTimezone","Europe/Paris","0");
INSERT INTO `pwk_option` VALUES("SitesManager_EnableSiteSpecificUserAgentExclude","","0");
INSERT INTO `pwk_option` VALUES("SitesManager_ExcludedIpsGlobal","78.206.68.131","0");
INSERT INTO `pwk_option` VALUES("SitesManager_ExcludedQueryParameters","","0");
INSERT INTO `pwk_option` VALUES("SitesManager_ExcludedUserAgentsGlobal","","0");
INSERT INTO `pwk_option` VALUES("SitesManager_KeepURLFragmentsGlobal","0","0");
INSERT INTO `pwk_option` VALUES("SitesManager_SearchCategoryParameters","","0");
INSERT INTO `pwk_option` VALUES("SitesManager_SearchKeywordParameters","q,query,s,search,searchword,k,keyword","0");
INSERT INTO `pwk_option` VALUES("TaskScheduler.timetable","a:11:{s:55:\"Piwik\\Plugins\\CoreAdminHome\\Tasks.purgeOutdatedArchives\";i:1430092829;s:59:\"Piwik\\Plugins\\ExamplePlugin\\Tasks.myTaskWithParam_anystring\";i:1430438444;s:40:\"Piwik\\Plugins\\ExamplePlugin\\Tasks.myTask\";i:1430038829;s:58:\"Piwik\\Plugins\\CoreAdminHome\\Tasks.purgeInvalidatedArchives\";i:1430092829;s:51:\"Piwik\\Plugins\\PrivacyManager\\Tasks.deleteReportData\";i:1430092829;s:48:\"Piwik\\Plugins\\PrivacyManager\\Tasks.deleteLogData\";i:1430092829;s:57:\"Piwik\\Plugins\\CorePluginsAdmin\\Tasks.clearAllCacheEntries\";i:1430092829;s:71:\"Piwik\\Plugins\\CorePluginsAdmin\\Tasks.sendNotificationIfUpdatesAvailable\";i:1430092829;s:54:\"Piwik\\Plugins\\CoreAdminHome\\Tasks.optimizeArchiveTable\";i:1430092829;s:49:\"Piwik\\Plugins\\UserCountry\\GeoIPAutoUpdater.update\";i:1430870445;s:65:\"Piwik\\Plugins\\CoreUpdater\\Tasks.sendNotificationIfUpdateAvailable\";i:1430092829;}","0");
INSERT INTO `pwk_option` VALUES("todayArchiveTimeToLive","150","1");
INSERT INTO `pwk_option` VALUES("UpdateCheck_LastTimeChecked","1430038588","1");
INSERT INTO `pwk_option` VALUES("UpdateCheck_LatestVersion","2.12.1","0");
INSERT INTO `pwk_option` VALUES("UsersManager.lastSeen.adm48","1429350462","1");
INSERT INTO `pwk_option` VALUES("UsersManager.lastSeen.super user was set","1430038588","1");
INSERT INTO `pwk_option` VALUES("version_Actions","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Annotations","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_API","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_BulkTracking","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Contents","0.1.0","1");
INSERT INTO `pwk_option` VALUES("version_core","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CoreAdminHome","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CoreConsole","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CoreHome","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CorePluginsAdmin","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CoreUpdater","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CoreVisualizations","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_CustomVariables","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Dashboard","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_DevicePlugins","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_DevicesDetection","1.14","1");
INSERT INTO `pwk_option` VALUES("version_Ecommerce","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Events","1.0","1");
INSERT INTO `pwk_option` VALUES("version_ExampleAPI","1.0","1");
INSERT INTO `pwk_option` VALUES("version_ExamplePlugin","0.1.0","1");
INSERT INTO `pwk_option` VALUES("version_ExampleRssWidget","1.0","1");
INSERT INTO `pwk_option` VALUES("version_Feedback","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Goals","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_ImageGraph","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Insights","0.1.0","1");
INSERT INTO `pwk_option` VALUES("version_Installation","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_LanguagesManager","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_LeftMenu","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Live","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Login","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_log_conversion.revenue","float default NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_conversion.revenue_discount","float default NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_conversion.revenue_shipping","float default NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_conversion.revenue_subtotal","float default NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_conversion.revenue_tax","float default NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_content_interaction","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_content_name","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_content_piece","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_content_target","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_event_action","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_event_category","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_name","INTEGER(10) UNSIGNED","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.idaction_url","INTEGER(10) UNSIGNED DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.server_time","DATETIME NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_link_visit_action.time_spent_ref_action","INTEGER(10) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_browser_engine","VARCHAR(10) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_browser_name","VARCHAR(10) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_browser_version","VARCHAR(20) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_cookie","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_device_brand","VARCHAR( 100 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_device_model","VARCHAR( 100 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_device_type","TINYINT( 100 ) NULL DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_director","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_flash","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_gears","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_java","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_os","CHAR(3) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_os_version","VARCHAR( 100 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_pdf","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_quicktime","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_realplayer","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_resolution","VARCHAR(9) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_silverlight","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.config_windowsmedia","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_browser_lang","VARCHAR(20) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_city","varchar(255) DEFAULT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_country","CHAR(3) NOT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_latitude","float(10, 6) DEFAULT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_longitude","float(10, 6) DEFAULT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.location_region","char(2) DEFAULT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.referer_keyword","VARCHAR(255) NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.referer_name","VARCHAR(70) NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.referer_type","TINYINT(1) UNSIGNED NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.referer_url","TEXT NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.user_id","VARCHAR(200) NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_count_visits","SMALLINT(5) UNSIGNED NOT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_days_since_first","SMALLINT(5) UNSIGNED NOT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_days_since_last","SMALLINT(5) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_days_since_order","SMALLINT(5) UNSIGNED NOT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_localtime","TIME NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visitor_returning","TINYINT(1) NOT NULL1","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_entry_idaction_name","INTEGER(11) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_entry_idaction_url","INTEGER(11) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_exit_idaction_name","INTEGER(11) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_exit_idaction_url","INTEGER(11) UNSIGNED NULL DEFAULT 0","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_first_action_time","DATETIME NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_goal_buyer","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_goal_converted","TINYINT(1) NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_total_actions","SMALLINT(5) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_total_events","SMALLINT(5) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_total_searches","SMALLINT(5) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_log_visit.visit_total_time","SMALLINT(5) UNSIGNED NOT NULL","1");
INSERT INTO `pwk_option` VALUES("version_MobileMessaging","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Monolog","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Morpheus","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_MultiSites","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Overlay","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_PrivacyManager","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Provider","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Proxy","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Referrers","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Resolution","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_ScheduledReports","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_SegmentEditor","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_SEO","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_SitesManager","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Transitions","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_UserCountry","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_UserCountryMap","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_UserLanguage","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_UserSettings","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_UsersManager","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_VisitFrequency","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_VisitorInterest","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_VisitsSummary","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_VisitTime","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_Widgetize","2.12.1","1");
INSERT INTO `pwk_option` VALUES("version_ZenMode","0.1","1");


DROP TABLE IF EXISTS `pwk_report`;

CREATE TABLE `pwk_report` (
  `idreport` int(11) NOT NULL AUTO_INCREMENT,
  `idsite` int(11) NOT NULL,
  `login` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `idsegment` int(11) DEFAULT NULL,
  `period` varchar(10) NOT NULL,
  `hour` tinyint(4) NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL,
  `format` varchar(10) NOT NULL,
  `reports` text NOT NULL,
  `parameters` text,
  `ts_created` timestamp NULL DEFAULT NULL,
  `ts_last_sent` timestamp NULL DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idreport`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_segment`;

CREATE TABLE `pwk_segment` (
  `idsegment` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `definition` text NOT NULL,
  `login` varchar(100) NOT NULL,
  `enable_all_users` tinyint(4) NOT NULL DEFAULT '0',
  `enable_only_idsite` int(11) DEFAULT NULL,
  `auto_archive` tinyint(4) NOT NULL DEFAULT '0',
  `ts_created` timestamp NULL DEFAULT NULL,
  `ts_last_edit` timestamp NULL DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idsegment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_sequence`;

CREATE TABLE `pwk_sequence` (
  `name` varchar(120) NOT NULL,
  `value` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `pwk_sequence` VALUES("pwk_archive_numeric_2015_04","10");


DROP TABLE IF EXISTS `pwk_session`;

CREATE TABLE `pwk_session` (
  `id` varchar(255) NOT NULL,
  `modified` int(11) DEFAULT NULL,
  `lifetime` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `pwk_session` VALUES("182fd76f21f988ba1079d4883e66c860","1429713627","1440","");
INSERT INTO `pwk_session` VALUES("353508c2f29d16ef2b6b1a8668ca02e2","1429908381","1440","Login.login|a:1:{s:5:\"nonce\";s:32:\"94dac4a7d6ea720aedff4df54bb2bddf\";}__ZF|a:1:{s:11:\"Login.login\";a:1:{s:4:\"ENVT\";a:1:{s:5:\"nonce\";i:1429908981;}}}");
INSERT INTO `pwk_session` VALUES("468e8a9a82d87ad5955efeb4422d9b18","1429587836","1440","Login.login|a:1:{s:5:\"nonce\";s:32:\"44a98bca2e49f008722e95a4f08b3e56\";}__ZF|a:1:{s:11:\"Login.login\";a:1:{s:4:\"ENVT\";a:1:{s:5:\"nonce\";i:1429588436;}}}");
INSERT INTO `pwk_session` VALUES("5c7ac7da1349a69df54302e3094cdd19","1429350463","1440","notification|a:1:{s:13:\"notifications\";a:0:{}}");
INSERT INTO `pwk_session` VALUES("6612f83b7b3791696b414c0ccd3d2392","1429393599","1440","");
INSERT INTO `pwk_session` VALUES("971dbd18a3c6c3938f665d5f8d90e61b","1429393595","1440","");
INSERT INTO `pwk_session` VALUES("a245c2ed3ebed418e325aafbc483d905","1429393599","1440","");
INSERT INTO `pwk_session` VALUES("e4fcc689775648b9cb95d092ef174347","1429649180","1440","Login.login|a:1:{s:5:\"nonce\";s:32:\"d81b90ce25603253328fceb9fa40f47f\";}__ZF|a:1:{s:11:\"Login.login\";a:1:{s:4:\"ENVT\";a:1:{s:5:\"nonce\";i:1429649779;}}}");


DROP TABLE IF EXISTS `pwk_site`;

CREATE TABLE `pwk_site` (
  `idsite` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `main_url` varchar(255) NOT NULL,
  `ts_created` timestamp NULL DEFAULT NULL,
  `ecommerce` tinyint(4) DEFAULT '0',
  `sitesearch` tinyint(4) DEFAULT '1',
  `sitesearch_keyword_parameters` text NOT NULL,
  `sitesearch_category_parameters` text NOT NULL,
  `timezone` varchar(50) NOT NULL,
  `currency` char(3) NOT NULL,
  `excluded_ips` text NOT NULL,
  `excluded_parameters` text NOT NULL,
  `excluded_user_agents` text NOT NULL,
  `group` varchar(250) NOT NULL,
  `type` varchar(255) NOT NULL,
  `keep_url_fragment` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idsite`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `pwk_site` VALUES("1","48h","http://48h.pigiste.org","2015-04-18 09:17:37","0","1","","","Europe/Paris","EUR","","","","","website","0");


DROP TABLE IF EXISTS `pwk_site_url`;

CREATE TABLE `pwk_site_url` (
  `idsite` int(10) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`idsite`,`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_user`;

CREATE TABLE `pwk_user` (
  `login` varchar(100) NOT NULL,
  `password` char(32) NOT NULL,
  `alias` varchar(45) NOT NULL,
  `email` varchar(100) NOT NULL,
  `token_auth` char(32) NOT NULL,
  `superuser_access` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `date_registered` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`login`),
  UNIQUE KEY `uniq_keytoken` (`token_auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `pwk_user` VALUES("adm48","7b2dbc34c3e9961e68291774ff32aa12","adm48","admin48@pigiste.org","f163552e3666f8d9aee17ad583dec6cb","1","2015-04-18 09:16:31");
INSERT INTO `pwk_user` VALUES("anonymous","","anonymous","anonymous@example.org","anonymous","0","2015-04-18 09:15:21");
INSERT INTO `pwk_user` VALUES("catherine","2009ef171ecc7be0949f07cfba8663a1","catherine","catherine@venerque.net","7f33069895757cfdc7042e33ad7a57e5","0","2015-04-18 09:46:52");


DROP TABLE IF EXISTS `pwk_user_dashboard`;

CREATE TABLE `pwk_user_dashboard` (
  `login` varchar(100) NOT NULL,
  `iddashboard` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `layout` text NOT NULL,
  PRIMARY KEY (`login`,`iddashboard`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `pwk_user_language`;

CREATE TABLE `pwk_user_language` (
  `login` varchar(100) NOT NULL,
  `language` varchar(10) NOT NULL,
  PRIMARY KEY (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_blc_filters`;

CREATE TABLE `wp_blc_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_blc_instances`;

CREATE TABLE `wp_blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL DEFAULT 'post',
  `link_text` varchar(250) NOT NULL DEFAULT '',
  `parser_type` varchar(40) NOT NULL DEFAULT 'link',
  `container_field` varchar(250) NOT NULL DEFAULT '',
  `link_context` varchar(250) NOT NULL DEFAULT '',
  `raw_url` text NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=MyISAM AUTO_INCREMENT=141 DEFAULT CHARSET=utf8;

INSERT INTO `wp_blc_instances` VALUES("91","14","821","page","Le forum","link","post_content","","http://dev48h.pigiste.org/forum/forum/envie-de-parler-boulot/");
INSERT INTO `wp_blc_instances` VALUES("89","13","1927","page","http://www.mij.allier.fr","link","post_content","","http://www.mij.allier.fr");
INSERT INTO `wp_blc_instances` VALUES("88","12","1927","page","http://www.lpo-auvergne.org/preserver-les-espaces-la-biodiversite/presentation-de-la-reserve","link","post_content","","http://www.lpo-auvergne.org/preserver-les-espaces-la-biodiversite/presentation-de-la-reserve");
INSERT INTO `wp_blc_instances` VALUES("87","11","1927","page","http://www.mab.allier.fr","link","post_content","","http://www.mab.allier.fr");
INSERT INTO `wp_blc_instances` VALUES("82","9","1836","page","Consulter le site internet de Profession : Pigiste","link","post_content","","http://www.pigiste.org");
INSERT INTO `wp_blc_instances` VALUES("86","10","1927","page","http://www.cncs.fr","link","post_content","","http://www.cncs.fr");
INSERT INTO `wp_blc_instances` VALUES("84","16","1722","page","VENDREDI 3 JUILLET","link","post_content","","http://48h.pigiste.org/le-programme/page");
INSERT INTO `wp_blc_instances` VALUES("83","16","1722","page","JEUDI 2 JUILLET","link","post_content","","http://48h.pigiste.org/le-programme/page");
INSERT INTO `wp_blc_instances` VALUES("138","25","1248","page","","image","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg");
INSERT INTO `wp_blc_instances` VALUES("137","24","1248","page","","image","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg");
INSERT INTO `wp_blc_instances` VALUES("136","23","1248","page","<img class=\" size-medium wp-image-1485 aligncenter\" src=\"https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\" alt=\"_BCR7667\" width=\"300\" height=\"199\" />","link","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667.jpg");
INSERT INTO `wp_blc_instances` VALUES("135","22","1248","page","<img class=\" size-medium wp-image-1474 aligncenter\" src=\"https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\" alt=\"_BCR7638\" width=\"300\" height=\"199\" />","link","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638.jpg");
INSERT INTO `wp_blc_instances` VALUES("94","21","39876","page","Le dazibao","link","post_content","","https://fr.wikipedia.org/wiki/Dazibao");
INSERT INTO `wp_blc_instances` VALUES("139","26","39921","post","<img class=\"alignnone size-medium wp-image-19720\" src=\"https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg\" alt=\"Fabio Lo Verso\" width=\"300\" height=\"300\" />","link","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151.jpg");
INSERT INTO `wp_blc_instances` VALUES("140","27","39921","post","","image","post_content","","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg");


DROP TABLE IF EXISTS `wp_blc_links`;

CREATE TABLE `wp_blc_links` (
  `link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int(4) unsigned NOT NULL DEFAULT '0',
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `log` text NOT NULL,
  `http_code` smallint(6) NOT NULL DEFAULT '0',
  `status_code` varchar(100) DEFAULT '',
  `status_text` varchar(250) DEFAULT '',
  `request_duration` float NOT NULL DEFAULT '0',
  `timeout` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `broken` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `warning` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `may_recheck` tinyint(1) NOT NULL DEFAULT '1',
  `being_checked` tinyint(1) NOT NULL DEFAULT '0',
  `result_hash` varchar(200) NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT '0',
  `dismissed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `wp_blc_links` VALUES("9","http://www.pigiste.org","0000-00-00 00:00:00","2015-04-23 20:26:32","2015-04-23 20:26:32","2015-04-23 20:26:32","0","http://pigiste.org/pigiste.org/","1","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 301 Moved Permanently
Date: Thu, 23 Apr 2015 20:26:32 GMT
Server: Apache
X-Powered-By: PHP/5.4.38
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Pragma: no-cache
X-Pingback: http://pigiste.org/pigiste.org/xmlrpc.php
X-UA-Compatible: IE=edge,chrome=1
Set-Cookie: PHPSESSID=29ntti0ou6rd37t2c4tsqbr2j3; path=/
Location: http://pigiste.org/pigiste.org/
Cache-Control: no-cache
Vary: Accept-Encoding
Connection: close
Content-Type: text/html; charset=UTF-8

HTTP/1.1 200 OK
Date: Thu, 23 Apr 2015 20:26:33 GMT
Server: Apache
X-Powered-By: PHP/5.4.38
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Pragma: no-cache
X-Pingback: http://pigiste.org/pigiste.org/xmlrpc.php
X-UA-Compatible: IE=edge,chrome=1
Set-Cookie: PHPSESSID=fi79i39oh8blslo15thj3i8v85; path=/
Cache-Control: no-cache
Vary: Accept-Encoding
Connection: close
Content-Type: text/html; charset=UTF-8

Request headers
================
HEAD /pigiste.org/ HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: pigiste.org
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close


Le lien est valide.","200","","","2.14371","0","0","0","1","0","200|0|0|http://pigiste.org/pigiste.org/","0","0");
INSERT INTO `wp_blc_links` VALUES("10","http://www.cncs.fr","0000-00-00 00:00:00","2015-04-23 20:26:34","2015-04-23 20:26:34","2015-04-23 20:26:34","0","http://www.cncs.fr","0","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 200 OK
Date: Thu, 23 Apr 2015 20:27:12 GMT
Server: Apache/2.2.22 (Debian)
X-Powered-By: PHP/5.4.36-0+deb7u1
X-Drupal-Cache: HIT
Etag: \"1429816021-0\"
Content-Language: fr
X-Generator: Drupal 7 (http://drupal.org)
Cache-Control: public, max-age=0
Last-Modified: Thu, 23 Apr 2015 19:07:01 GMT
Expires: Sun, 19 Nov 1978 05:00:00 GMT
Vary: Cookie,Accept-Encoding
Connection: close
Content-Type: text/html; charset=utf-8

Request headers
================
HEAD / HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: www.cncs.fr
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close


Le lien est valide.","200","","","0.026033","0","0","0","1","0","200|0|0|http://www.cncs.fr","0","0");
INSERT INTO `wp_blc_links` VALUES("11","http://www.mab.allier.fr","0000-00-00 00:00:00","2015-04-23 20:26:34","2015-04-23 20:26:34","2015-04-23 20:26:34","0","http://www.mab.allier.fr","0","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 200 OK
Date: Thu, 23 Apr 2015 20:26:34 GMT
Server: Apache/2.2.22 (Debian)
X-Powered-By: PHP/5.4.4-14+deb7u14
Set-Cookie: PHPSESSID=v9p3km405u0bhett4pf9ctr8bc5cn9pn; path=/; HttpOnly
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Pragma: no-cache
Content-script-type: text/javascript
Content-style-type: text/css
Content-language: fr
Set-Cookie: fontSize=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; path=/
Set-Cookie: style=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; path=/
Vary: Accept-Encoding
Connection: close
Content-Type: text/html; charset=utf-8

Request headers
================
HEAD / HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: www.mab.allier.fr
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close


Le lien est valide.","200","","","0.10955","0","0","0","1","0","200|0|0|http://www.mab.allier.fr","0","0");
INSERT INTO `wp_blc_links` VALUES("12","http://www.lpo-auvergne.org/preserver-les-espaces-la-biodiversite/presentation-de-la-reserve","0000-00-00 00:00:00","2015-04-23 20:26:34","2015-04-23 20:26:34","2015-04-23 20:26:34","0","http://www.lpo-auvergne.org/preserver-les-espaces-la-biodiversite/presentation-de-la-reserve","0","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 200 OK
Date: Thu, 23 Apr 2015 20:26:34 GMT
Server: Apache
X-Powered-By: PHP/5.3.3-7+squeeze23
X-Drupal-Cache: MISS
Etag: \"1429820794-0\"
Content-Language: fr
Link: </node/57>; rel=\"shortlink\",</preserver-les-espaces-la-biodiversite/presentation-de-la-reserve>; rel=\"canonical\"
X-Generator: Drupal 7 (http://drupal.org)
Cache-Control: public, max-age=900
Expires: Sun, 19 Nov 1978 05:00:00 GMT
Vary: Cookie,Accept-Encoding
Last-Modified: Thu, 23 Apr 2015 20:26:34 GMT
Connection: close
Content-Type: text/html; charset=utf-8

Request headers
================
HEAD /preserver-les-espaces-la-biodiversite/presentation-de-la-reserve HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: www.lpo-auvergne.org
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close


Le lien est valide.","200","","","0.459509","0","0","0","1","0","200|0|0|http://www.lpo-auvergne.org/preserver-les-espaces-la-biodiversite/presentation-de-la-reserve","0","0");
INSERT INTO `wp_blc_links` VALUES("13","http://www.mij.allier.fr","0000-00-00 00:00:00","2015-04-23 20:26:34","2015-04-23 20:26:34","2015-04-23 20:26:34","0","http://www.mij.allier.fr","0","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 200 OK
Date: Thu, 23 Apr 2015 20:26:34 GMT
Server: Apache/2.2.22 (Debian)
X-Powered-By: PHP/5.4.4-14+deb7u14
Set-Cookie: PHPSESSID=gm7i1huoiheocdcidrslhvont6gpsr5u; path=/; HttpOnly
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Pragma: no-cache
Content-script-type: text/javascript
Content-style-type: text/css
Content-language: fr
Set-Cookie: fontSize=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; path=/
Set-Cookie: style=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; path=/
Vary: Accept-Encoding
Connection: close
Content-Type: text/html; charset=utf-8

Request headers
================
HEAD / HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: www.mij.allier.fr
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close


Le lien est valide.","200","","","0.10602","0","0","0","1","0","200|0|0|http://www.mij.allier.fr","0","0");
INSERT INTO `wp_blc_links` VALUES("14","http://dev48h.pigiste.org/forum/forum/envie-de-parler-boulot/","2015-04-21 17:15:02","2015-04-24 17:48:58","0000-00-00 00:00:00","2015-04-24 17:48:58","3","http://dev48h.pigiste.org/forum/forum/envie-de-parler-boulot/","0","=== Code HTTP: 503 ===

Response headers
================
HTTP/1.1 503 Service Unavailable
Date: Fri, 24 Apr 2015 17:48:58 GMT
Server: Apache
X-Powered-By: PHP/5.5.22
Set-Cookie: pll_language=fr; expires=Sat, 23-Apr-2016 17:48:58 GMT; Max-Age=31536000; path=/
Expires: Wed, 11 Jan 1984 05:00:00 GMT
Cache-Control: no-cache, must-revalidate, max-age=0
Pragma: no-cache
Retry-After: 3600
Pragma: no-cache
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Vary: Accept-Encoding
Connection: close
Transfer-Encoding: chunked
Content-Type: text/html; charset=UTF-8

Request headers
================
GET /forum/forum/envie-de-parler-boulot/ HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: dev48h.pigiste.org
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close
Range: bytes=0-2048

Response HTML
================
&lt;!DOCTYPE html&gt;
&lt;html&gt;
    &lt;head&gt;
        &lt;title&gt;Mode Maintenance&lt;/title&gt;
        &lt;meta name=&quot;author&quot; content=&quot;Designmodo&quot; /&gt;
        &lt;meta name=&quot;description&quot; content=&quot;Les 48h de la pige - Un &eacute;v&eacute;nement Profession : Pigiste&quot; /&gt;
        &lt;meta name=&quot;keywords&quot; content=&quot;Maintenance Mode&quot; /&gt;
        &lt;meta name=&quot;robots&quot; content=&quot;index, follow&quot; /&gt;
                        &lt;link rel=&quot;stylesheet&quot; href=&quot;http://dev48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/css/style.css&quot;&gt;
                &lt;style&gt;.wrap h1 { color: #ffffff; }.wrap h2 { color: #1e73be; }.background { background: url(http://dev48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }&lt;/style&gt;    &lt;/head&gt;
    &lt;body class=&quot;background&quot;&gt;
        &lt;div class=&quot;wrap&quot;&gt;
            &lt;h1&gt;Mode Maintenance&lt;/h1&gt;            &lt;h2&gt;&lt;p&gt;Le site des 48h de la Pige fait peau neuve pour son &eacute;dition 2015 qui se tiendra les 2 et 3 juillet &agrave; Strasbourg.&lt;/p&gt;
&lt;p&gt;Tr&egrave;s bient&ocirc;t, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !&lt;/p&gt;&lt;/h2&gt;
            
            
                        
                
        &lt;/div&gt;

        &lt;script type=\'text/javascript\'&gt;
            var wpmm_vars = {&quot;ajax_url&quot;: &quot;https://dev48h.pigiste.org/wp-admin/admin-ajax.php&quot;};
        &lt;/script&gt;
                        &lt;script src=&quot;http://dev48h.pigiste.org/wp-includes/js/jquery/jquery.js&quot;&gt;&lt;/script&gt;
                                &lt;script src=&quot;http://dev48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/js/scripts.js&quot;&gt;&lt;/script&gt;
                    &lt;/body&gt;
&lt;/html&gt;

Le lien est cassé.","503","","","0.222706","0","1","0","1","0","503|broken|0|http://dev48h.pigiste.org/forum/forum/envie-de-parler-boulot/","0","0");
INSERT INTO `wp_blc_links` VALUES("16","http://48h.pigiste.org/le-programme/page","2015-04-23 10:28:26","2015-04-23 10:28:26","0000-00-00 00:00:00","2015-04-23 10:28:26","1","http://48h.pigiste.org/le-programme/page","0","=== Code HTTP: 503 ===

Response headers
================
HTTP/1.1 503 Service Unavailable
Date: Thu, 23 Apr 2015 10:28:27 GMT
Server: Apache
X-Powered-By: PHP/5.5.22
Expires: Wed, 11 Jan 1984 05:00:00 GMT
Cache-Control: no-cache, must-revalidate, max-age=0
Pragma: no-cache
Retry-After: 3600
Pragma: no-cache
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Vary: Accept-Encoding
Connection: close
Transfer-Encoding: chunked
Content-Type: text/html; charset=UTF-8

Request headers
================
GET /le-programme/page HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: 48h.pigiste.org
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close
Range: bytes=0-2048

Response HTML
================
&lt;!DOCTYPE html&gt;
&lt;html&gt;
    &lt;head&gt;
        &lt;title&gt;Mode Maintenance&lt;/title&gt;
        &lt;meta name=&quot;author&quot; content=&quot;Designmodo&quot; /&gt;
        &lt;meta name=&quot;description&quot; content=&quot;Les 48h de la pige - Un &eacute;v&eacute;nement Profession : Pigiste&quot; /&gt;
        &lt;meta name=&quot;keywords&quot; content=&quot;Maintenance Mode&quot; /&gt;
        &lt;meta name=&quot;robots&quot; content=&quot;index, follow&quot; /&gt;
                        &lt;link rel=&quot;stylesheet&quot; href=&quot;http://48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/css/style.css&quot;&gt;
                &lt;style&gt;.wrap h1 { color: #ffffff; }.wrap h2 { color: #1e73be; }.background { background: url(http://48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }&lt;/style&gt;    &lt;/head&gt;
    &lt;body class=&quot;background&quot;&gt;
        &lt;div class=&quot;wrap&quot;&gt;
            &lt;h1&gt;Mode Maintenance&lt;/h1&gt;            &lt;h2&gt;&lt;p&gt;Le site des 48h de la Pige fait peau neuve pour son &eacute;dition 2015 qui se tiendra les 2 et 3 juillet &agrave; Strasbourg.&lt;/p&gt;
&lt;p&gt;Tr&egrave;s bient&ocirc;t, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !&lt;/p&gt;&lt;/h2&gt;
            
            
                        
                
        &lt;/div&gt;

        &lt;script type=\'text/javascript\'&gt;
            var wpmm_vars = {&quot;ajax_url&quot;: &quot;http://48h.pigiste.org/wp-admin/admin-ajax.php&quot;};
        &lt;/script&gt;
                        &lt;script src=&quot;http://48h.pigiste.org/wp-includes/js/jquery/jquery.js&quot;&gt;&lt;/script&gt;
                                &lt;script src=&quot;http://48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/js/scripts.js&quot;&gt;&lt;/script&gt;
                    &lt;/body&gt;
&lt;/html&gt;

==========
Severity: Warning
Reason: HTTP error 503 usually means that the site is down due to high server load or a configuration problem. This error is often temporary and will go away after while.
==========

Le lien est cassé.","503","","","0.11779","0","0","1","1","0","503|broken|0|http://48h.pigiste.org/le-programme/page","0","0");
INSERT INTO `wp_blc_links` VALUES("26","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151.jpg","2015-04-23 21:44:00","2015-04-24 10:14:30","0000-00-00 00:00:00","2015-04-24 10:14:30","3","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","9e-05","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("27","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg","2015-04-23 21:44:00","2015-04-24 10:14:22","0000-00-00 00:00:00","2015-04-24 10:14:22","3","https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","8.9e-05","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("22","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638.jpg","2015-04-23 21:39:26","2015-04-24 10:14:20","0000-00-00 00:00:00","2015-04-24 10:14:20","3","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","0.000117","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("23","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667.jpg","2015-04-23 21:39:30","2015-04-24 10:14:24","0000-00-00 00:00:00","2015-04-24 10:14:24","3","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","9e-05","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("24","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg","2015-04-23 21:39:26","2015-04-24 10:14:26","0000-00-00 00:00:00","2015-04-24 10:14:26","3","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","9.1e-05","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("25","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg","2015-04-23 21:39:28","2015-04-24 10:14:20","0000-00-00 00:00:00","2015-04-24 10:14:20","3","https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg","0","error:140770FC:SSL routines:SSL23_GET_SERVER_HELLO:unknown protocol [Error #35]
=== (pas de r&eacute;ponse) ===

Response headers
================

Le lien est cassé.","0","warning","Erreur inconnue","9.6e-05","0","1","0","1","0","0|broken|0|https://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg","0","0");
INSERT INTO `wp_blc_links` VALUES("21","https://fr.wikipedia.org/wiki/Dazibao","0000-00-00 00:00:00","2015-04-23 15:15:18","2015-04-23 15:15:18","2015-04-23 15:15:18","0","https://fr.wikipedia.org/wiki/Dazibao","0","=== Code HTTP: 200 ===

Response headers
================
HTTP/1.1 200 OK
Server: nginx/1.6.2
Date: Thu, 23 Apr 2015 15:15:18 GMT
Content-Type: text/html; charset=UTF-8
Transfer-Encoding: chunked
Connection: close
X-Content-Type-Options: nosniff
Content-language: fr
X-UA-Compatible: IE=Edge
Vary: Accept-Encoding,Cookie
X-Powered-By: HHVM/3.3.1
Last-Modified: Thu, 23 Apr 2015 00:21:25 GMT
X-Varnish: 1795719706, 1082556938 1046162201, 2972289902 2962222111
Via: 1.1 varnish, 1.1 varnish, 1.1 varnish
Age: 49938
X-Cache: cp1055 miss (0), cp3005 hit (7), cp3031 frontend hit (1)
Cache-Control: private, s-maxage=0, max-age=0, must-revalidate
Set-Cookie: GeoIP=FR::48.8600:2.3500:v4; Path=/; Domain=.wikipedia.org
X-Analytics: page_id=136941;ns=0;https=1

Request headers
================
GET /wiki/Dazibao HTTP/1.1
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)
Host: fr.wikipedia.org
Accept: */*
Referer: http://dev48h.pigiste.org
Connection: close
Range: bytes=0-2048


Le lien est valide.","200","","","0.068244","0","0","0","1","0","200|0|0|https://fr.wikipedia.org/wiki/Dazibao","0","0");


DROP TABLE IF EXISTS `wp_blc_synch`;

CREATE TABLE `wp_blc_synch` (
  `container_id` int(20) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL,
  `synched` tinyint(2) unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `wp_blc_synch` VALUES("734","page","1","2015-04-23 16:50:32");
INSERT INTO `wp_blc_synch` VALUES("756","page","1","2015-04-23 16:59:22");
INSERT INTO `wp_blc_synch` VALUES("821","page","1","2015-04-23 17:16:09");
INSERT INTO `wp_blc_synch` VALUES("1167","page","1","2015-04-23 16:45:18");
INSERT INTO `wp_blc_synch` VALUES("1401","page","1","2015-04-23 17:59:42");
INSERT INTO `wp_blc_synch` VALUES("1750","page","1","2015-04-23 17:05:43");
INSERT INTO `wp_blc_synch` VALUES("1792","page","1","2015-04-23 16:48:14");
INSERT INTO `wp_blc_synch` VALUES("1801","page","1","2015-04-21 16:17:26");
INSERT INTO `wp_blc_synch` VALUES("1836","page","1","2015-04-23 16:53:46");
INSERT INTO `wp_blc_synch` VALUES("1859","page","1","2015-04-23 18:04:00");
INSERT INTO `wp_blc_synch` VALUES("1927","page","1","2015-04-23 17:04:13");
INSERT INTO `wp_blc_synch` VALUES("1248","page","1","2015-04-23 23:43:59");
INSERT INTO `wp_blc_synch` VALUES("1722","page","1","2015-04-23 16:54:16");
INSERT INTO `wp_blc_synch` VALUES("1720","page","1","2015-04-23 16:47:16");
INSERT INTO `wp_blc_synch` VALUES("39673","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39673","page","1","2015-04-23 17:05:00");
INSERT INTO `wp_blc_synch` VALUES("39675","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39675","page","1","2015-04-23 16:54:42");
INSERT INTO `wp_blc_synch` VALUES("39677","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39677","page","1","2015-04-23 17:04:35");
INSERT INTO `wp_blc_synch` VALUES("39679","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39679","page","1","2015-04-23 16:56:50");
INSERT INTO `wp_blc_synch` VALUES("39681","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39681","page","1","2015-04-23 16:55:26");
INSERT INTO `wp_blc_synch` VALUES("39683","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39683","page","1","2015-04-23 16:52:27");
INSERT INTO `wp_blc_synch` VALUES("39685","post","1","2015-04-21 15:17:32");
INSERT INTO `wp_blc_synch` VALUES("39685","page","1","2015-04-23 16:59:45");
INSERT INTO `wp_blc_synch` VALUES("19726","page","1","2015-04-23 16:52:53");
INSERT INTO `wp_blc_synch` VALUES("19728","page","1","2015-04-21 16:17:26");
INSERT INTO `wp_blc_synch` VALUES("19727","page","1","2015-04-21 16:17:26");
INSERT INTO `wp_blc_synch` VALUES("19730","page","1","2015-04-21 16:17:26");
INSERT INTO `wp_blc_synch` VALUES("19729","page","1","2015-04-21 16:17:26");
INSERT INTO `wp_blc_synch` VALUES("39777","page","1","2015-04-23 17:21:27");
INSERT INTO `wp_blc_synch` VALUES("39780","page","1","2015-04-23 17:04:13");
INSERT INTO `wp_blc_synch` VALUES("39782","page","1","2015-04-22 00:10:08");
INSERT INTO `wp_blc_synch` VALUES("39786","page","1","2015-04-22 00:12:35");
INSERT INTO `wp_blc_synch` VALUES("39788","page","1","2015-04-22 00:14:35");
INSERT INTO `wp_blc_synch` VALUES("39790","page","1","2015-04-22 00:15:46");
INSERT INTO `wp_blc_synch` VALUES("39864","page","1","2015-04-23 17:22:12");
INSERT INTO `wp_blc_synch` VALUES("39866","page","1","2015-04-23 16:58:38");
INSERT INTO `wp_blc_synch` VALUES("39872","page","1","2015-04-23 17:17:36");
INSERT INTO `wp_blc_synch` VALUES("39874","page","1","2015-04-23 17:18:19");
INSERT INTO `wp_blc_synch` VALUES("39876","page","1","2015-04-23 17:17:06");
INSERT INTO `wp_blc_synch` VALUES("39884","page","1","2015-04-23 18:00:16");
INSERT INTO `wp_blc_synch` VALUES("39887","page","1","2015-04-23 17:26:11");
INSERT INTO `wp_blc_synch` VALUES("39900","page","1","2015-04-23 18:24:27");
INSERT INTO `wp_blc_synch` VALUES("39921","post","1","2015-04-23 23:43:59");


DROP TABLE IF EXISTS `wp_cf7dbplugin_st`;

CREATE TABLE `wp_cf7dbplugin_st` (
  `submit_time` decimal(16,4) NOT NULL,
  PRIMARY KEY (`submit_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_cf7dbplugin_submits`;

CREATE TABLE `wp_cf7dbplugin_submits` (
  `submit_time` decimal(16,4) NOT NULL,
  `form_name` varchar(127) DEFAULT NULL,
  `field_name` varchar(127) DEFAULT NULL,
  `field_value` longtext,
  `field_order` int(11) DEFAULT NULL,
  `file` longblob,
  KEY `submit_time_idx` (`submit_time`),
  KEY `form_name_idx` (`form_name`),
  KEY `field_name_idx` (`field_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_duplicator_packages`;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_bookings`;

CREATE TABLE `wp_em_bookings` (
  `booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `person_id` bigint(20) unsigned NOT NULL,
  `booking_spaces` int(5) NOT NULL,
  `booking_comment` text,
  `booking_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `booking_status` tinyint(1) NOT NULL DEFAULT '1',
  `booking_price` decimal(14,4) unsigned NOT NULL DEFAULT '0.0000',
  `booking_tax_rate` decimal(7,4) DEFAULT NULL,
  `booking_taxes` decimal(14,4) DEFAULT NULL,
  `booking_meta` longtext,
  PRIMARY KEY (`booking_id`),
  KEY `event_id` (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_events`;

CREATE TABLE `wp_em_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `event_slug` varchar(200) DEFAULT NULL,
  `event_owner` bigint(20) unsigned DEFAULT NULL,
  `event_status` int(1) DEFAULT NULL,
  `event_name` text,
  `event_start_time` time DEFAULT NULL,
  `event_end_time` time DEFAULT NULL,
  `event_all_day` int(1) DEFAULT NULL,
  `event_start_date` date DEFAULT NULL,
  `event_end_date` date DEFAULT NULL,
  `post_content` longtext,
  `event_rsvp` tinyint(1) NOT NULL DEFAULT '0',
  `event_rsvp_date` date DEFAULT NULL,
  `event_rsvp_time` time DEFAULT NULL,
  `event_rsvp_spaces` int(5) DEFAULT NULL,
  `event_spaces` int(5) DEFAULT '0',
  `event_private` tinyint(1) NOT NULL DEFAULT '0',
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `recurrence_id` bigint(20) unsigned DEFAULT NULL,
  `event_category_id` bigint(20) unsigned DEFAULT NULL,
  `event_attributes` text,
  `event_date_created` datetime DEFAULT NULL,
  `event_date_modified` datetime DEFAULT NULL,
  `recurrence` tinyint(1) NOT NULL DEFAULT '0',
  `recurrence_interval` int(4) DEFAULT NULL,
  `recurrence_freq` tinytext,
  `recurrence_byday` tinytext,
  `recurrence_byweekno` int(4) DEFAULT NULL,
  `recurrence_days` int(4) DEFAULT NULL,
  `recurrence_rsvp_days` int(3) DEFAULT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `group_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event_status` (`event_status`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_locations`;

CREATE TABLE `wp_em_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `location_slug` varchar(200) DEFAULT NULL,
  `location_name` text,
  `location_owner` bigint(20) unsigned NOT NULL DEFAULT '0',
  `location_address` varchar(200) DEFAULT NULL,
  `location_town` varchar(200) DEFAULT NULL,
  `location_state` varchar(200) DEFAULT NULL,
  `location_postcode` varchar(10) DEFAULT NULL,
  `location_region` varchar(200) DEFAULT NULL,
  `location_country` char(2) DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `post_content` longtext,
  `location_status` int(1) DEFAULT NULL,
  `location_private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`),
  KEY `location_state` (`location_state`),
  KEY `location_region` (`location_region`),
  KEY `location_country` (`location_country`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_meta`;

CREATE TABLE `wp_em_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  `meta_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_tickets`;

CREATE TABLE `wp_em_tickets` (
  `ticket_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `ticket_name` tinytext NOT NULL,
  `ticket_description` text,
  `ticket_price` decimal(14,4) DEFAULT NULL,
  `ticket_start` datetime DEFAULT NULL,
  `ticket_end` datetime DEFAULT NULL,
  `ticket_min` int(10) DEFAULT NULL,
  `ticket_max` int(10) DEFAULT NULL,
  `ticket_spaces` int(11) DEFAULT NULL,
  `ticket_members` int(1) DEFAULT NULL,
  `ticket_members_roles` longtext,
  `ticket_guests` int(1) DEFAULT NULL,
  `ticket_required` int(1) DEFAULT NULL,
  `ticket_meta` longtext,
  PRIMARY KEY (`ticket_id`),
  KEY `event_id` (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_em_tickets_bookings`;

CREATE TABLE `wp_em_tickets_bookings` (
  `ticket_booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint(20) unsigned NOT NULL,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `ticket_booking_spaces` int(6) NOT NULL,
  `ticket_booking_price` decimal(14,4) NOT NULL,
  PRIMARY KEY (`ticket_booking_id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(20) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(20) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(20) DEFAULT NULL,
  `log_username` varchar(20) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(20) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_layerslider`;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_layerslider` VALUES("1","Slide Home page","{\"properties\":{\"title\":\"Slide Home page\",\"width\":\"100%\",\"height\":\"470\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"80\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2014\\/05\\/cistude_romain_riols.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2013\\/04\\/Logo48hcyan-01.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"900\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"20px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"900\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1450\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"250\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"187px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/le-programme\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"221px\",\"left\":\"671px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-02.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/sinscrire-aux-48h\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"299px\",\"left\":\"668px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-03.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/pratique\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"378px\",\"left\":\"666px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2015\\/03\\/48hVichy-juil14-bandeau1200.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/blancPP-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"450\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"119px\",\"left\":\"20px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"550\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"68\\\\\\\"}\",\"top\":\"348px\",\"left\":\"21px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1428671868","0","0");
INSERT INTO `wp_layerslider` VALUES("2","Why Enfold - Small Header","{\"properties\":{\"title\":\"Why Enfold - Small Header\",\"width\":\"100%\",\"height\":\"150\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"1\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"#aac98e\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1200\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"150\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-18px\",\"left\":\"800px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1300\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"842px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l17.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"350\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-279px\",\"left\":\"951px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"450\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"51px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-22px\",\"left\":\"-107px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Why you should choose\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"650\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"68px\",\"left\":\"214px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"684px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1398347374","0","0");


DROP TABLE IF EXISTS `wp_leafletmapsmarker_layers`;

CREATE TABLE `wp_leafletmapsmarker_layers` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `basemap` varchar(25) NOT NULL,
  `layerzoom` int(2) NOT NULL,
  `mapwidth` int(4) NOT NULL,
  `mapwidthunit` varchar(2) NOT NULL,
  `mapheight` int(4) NOT NULL,
  `panel` tinyint(1) NOT NULL,
  `layerviewlat` decimal(9,6) NOT NULL,
  `layerviewlon` decimal(9,6) NOT NULL,
  `createdby` varchar(30) NOT NULL,
  `createdon` datetime NOT NULL,
  `updatedby` varchar(30) DEFAULT NULL,
  `updatedon` datetime DEFAULT NULL,
  `controlbox` int(1) NOT NULL,
  `overlays_custom` int(1) NOT NULL,
  `overlays_custom2` int(1) NOT NULL,
  `overlays_custom3` int(1) NOT NULL,
  `overlays_custom4` int(1) NOT NULL,
  `wms` tinyint(1) NOT NULL,
  `wms2` tinyint(1) NOT NULL,
  `wms3` tinyint(1) NOT NULL,
  `wms4` tinyint(1) NOT NULL,
  `wms5` tinyint(1) NOT NULL,
  `wms6` tinyint(1) NOT NULL,
  `wms7` tinyint(1) NOT NULL,
  `wms8` tinyint(1) NOT NULL,
  `wms9` tinyint(1) NOT NULL,
  `wms10` tinyint(1) NOT NULL,
  `listmarkers` tinyint(1) NOT NULL,
  `multi_layer_map` tinyint(1) NOT NULL,
  `multi_layer_map_list` varchar(4000) DEFAULT NULL,
  `address` varchar(255) NOT NULL,
  `clustering` tinyint(1) unsigned NOT NULL,
  `gpx_url` varchar(2083) NOT NULL,
  `gpx_panel` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_leafletmapsmarker_layers` VALUES("0","markers not assigned to a layer","osm_mapnik","11","640","px","480","0","0.000000","0.000000","","0000-00-00 00:00:00","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","","0");
INSERT INTO `wp_leafletmapsmarker_layers` VALUES("1","participants","osm_mapnik","11","640","px","480","1","48.216038","16.378984","cyrille","2015-04-23 18:24:46","cyrille","2015-04-23 18:24:46","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","0","","","1","","0");


DROP TABLE IF EXISTS `wp_leafletmapsmarker_markers`;

CREATE TABLE `wp_leafletmapsmarker_markers` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `markername` varchar(255) NOT NULL,
  `basemap` varchar(25) NOT NULL,
  `layer` int(6) unsigned NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lon` decimal(9,6) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `popuptext` text NOT NULL,
  `zoom` int(2) NOT NULL,
  `openpopup` tinyint(1) NOT NULL,
  `mapwidth` int(4) NOT NULL,
  `mapwidthunit` varchar(2) NOT NULL,
  `mapheight` int(4) NOT NULL,
  `panel` tinyint(1) NOT NULL,
  `createdby` varchar(30) NOT NULL,
  `createdon` datetime NOT NULL,
  `updatedby` varchar(30) DEFAULT NULL,
  `updatedon` datetime DEFAULT NULL,
  `controlbox` int(1) NOT NULL,
  `overlays_custom` int(1) NOT NULL,
  `overlays_custom2` int(1) NOT NULL,
  `overlays_custom3` int(1) NOT NULL,
  `overlays_custom4` int(1) NOT NULL,
  `wms` tinyint(1) NOT NULL,
  `wms2` tinyint(1) NOT NULL,
  `wms3` tinyint(1) NOT NULL,
  `wms4` tinyint(1) NOT NULL,
  `wms5` tinyint(1) NOT NULL,
  `wms6` tinyint(1) NOT NULL,
  `wms7` tinyint(1) NOT NULL,
  `wms8` tinyint(1) NOT NULL,
  `wms9` tinyint(1) NOT NULL,
  `wms10` tinyint(1) NOT NULL,
  `kml_timestamp` datetime DEFAULT NULL,
  `address` varchar(255) NOT NULL,
  `gpx_url` varchar(2083) NOT NULL,
  `gpx_panel` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_leafletmapsmarker_markers` VALUES("1","Cuej - Centre Universitaire d’Enseignement du Journalisme","osm_mapnik","0","48.577944","7.762274","direction_down.png","Centre Universitaire d’Enseignement du Journalisme","14","0","640","px","480","1","cyrille","2015-04-21 17:56:11","cyrille","2015-04-21 17:59:46","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","11, rue du Maréchal Juin, Strasbourg, France","","0");
INSERT INTO `wp_leafletmapsmarker_markers` VALUES("2","Catherine","osm_mapnik","0","43.433943","1.442398","smiley_happy.png","","10","0","640","px","480","1","cyrille","2015-04-23 18:27:46","cyrille","2015-04-23 18:27:46","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","3 Rue Guillaume de Falgar, Venerque, France","","0");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_newsletter`;

CREATE TABLE `wp_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `sex` char(1) NOT NULL DEFAULT 'n',
  `status` char(1) NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(50) NOT NULL DEFAULT '',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `country` varchar(4) NOT NULL DEFAULT '',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) NOT NULL DEFAULT '',
  `profile_2` varchar(255) NOT NULL DEFAULT '',
  `profile_3` varchar(255) NOT NULL DEFAULT '',
  `profile_4` varchar(255) NOT NULL DEFAULT '',
  `profile_5` varchar(255) NOT NULL DEFAULT '',
  `profile_6` varchar(255) NOT NULL DEFAULT '',
  `profile_7` varchar(255) NOT NULL DEFAULT '',
  `profile_8` varchar(255) NOT NULL DEFAULT '',
  `profile_9` varchar(255) NOT NULL DEFAULT '',
  `profile_10` varchar(255) NOT NULL DEFAULT '',
  `profile_11` varchar(255) NOT NULL DEFAULT '',
  `profile_12` varchar(255) NOT NULL DEFAULT '',
  `profile_13` varchar(255) NOT NULL DEFAULT '',
  `profile_14` varchar(255) NOT NULL DEFAULT '',
  `profile_15` varchar(255) NOT NULL DEFAULT '',
  `profile_16` varchar(255) NOT NULL DEFAULT '',
  `profile_17` varchar(255) NOT NULL DEFAULT '',
  `profile_18` varchar(255) NOT NULL DEFAULT '',
  `profile_19` varchar(255) NOT NULL DEFAULT '',
  `profile_20` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(50) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  `flow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter` VALUES("1","paulineburguin@hotmail.fr ","Pauline","Burguin","f","C","2014-05-07 22:10:12","a6896fa250","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("2","jacson-christel@voila.fr ","","","n","C","2014-05-07 22:10:26","35897a25c8","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("3","henry.castelbou@numericable.fr ","","","n","C","2014-05-07 22:10:34","5fb9736511","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("4","nicolas.jaunet@argus-presse.fr","","","n","C","2014-05-07 22:10:44","6120a0dae4","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("5","manager@mtwevts.com ","","","n","C","2014-05-07 22:10:58","f3504d96fa","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("6","max.twa@gmail.com","","","n","C","2014-05-07 22:13:09","2379dc6e8e","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","1","0");


DROP TABLE IF EXISTS `wp_newsletter_emails`;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext,
  `message_text` longtext,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `send_on` int(11) NOT NULL DEFAULT '0',
  `track` tinyint(4) NOT NULL DEFAULT '0',
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` char(1) NOT NULL DEFAULT '',
  `query` text,
  `preferences` text,
  `options` longtext,
  `token` varchar(10) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_emails` VALUES("1","<!DOCTYPE html>
<html>
    <head>
        <title></title>
        <style>
            * {
                font-family: ;
                font-size: ;
            }
        </style>
    </head>
    <body style=\"font:normal 11px helvetica,sans-serif;\"><table style=\"background-color: #ffffff; width: 600px; background-position: initial initial; background-repeat: initial initial;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
<tbody>
<tr>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">Cet email a &eacute;t&eacute; envoy&eacute; &agrave; {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.</td>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">&nbsp;</td>
</tr>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">
<table style=\"height: 90px; width: 334px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"20\" align=\"center\">
<tbody>
<tr>
<td style=\"background: #ffffff;\"><a href=\"http://www.48h.pigiste.org\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/Logo48hPP-01.png\" alt=\"\" width=\"382\" height=\"211\" /></a></td>
<td style=\"background: #ffffff;\">
<p><a href=\"http://dev48h.pigiste.org/le-programme/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-01.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
<p><a href=\"http://dev48h.pigiste.org/sinscrire-aux-48h/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-02.png\" alt=\"\" width=\"223\" height=\"50\" /></a></p>
<p><a href=\"http://dev48h.pigiste.org/pratique/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-03.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
</td>
</tr>
</tbody>
</table>
</td>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">&nbsp;</td>
</tr>
</tbody>
</table></body></html>","This email requires a modern e-mail reader. You can view the email online here:

{email_url}.

Thank you, Les 48h de la pige
To change your subscription follow:
{profile_url}.","Le programme est enfin publié !","message","2014-05-07 22:04:24","sent","6","6","6","1399492800","1","0","","select * from wp_newsletter where status=\'C\'","","a:5:{s:18:\"preferences_status\";s:1:\"0\";s:11:\"preferences\";N;s:3:\"sex\";N;s:6:\"status\";s:1:\"C\";s:8:\"wp_users\";s:1:\"0\";}","52730d2b3d","0");


DROP TABLE IF EXISTS `wp_newsletter_stats`;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` int(11) NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) NOT NULL DEFAULT '',
  `anchor` varchar(200) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_stats` VALUES("1","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("2","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("3","6","1","0","2014-05-07 22:13:52","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("4","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("5","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("6","5","1","0","2014-05-07 22:17:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("7","6","1","0","2014-05-07 22:18:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("8","6","1","0","2014-05-07 22:18:14","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("9","5","1","0","2014-05-07 23:09:03","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("10","2","1","0","2014-05-08 08:57:32","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("11","2","1","0","2014-05-08 08:57:46","http://dev48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("12","2","1","0","2014-05-08 09:07:45","http://dev48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("13","5","1","0","2014-05-08 10:03:29","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("14","2","1","0","2014-05-08 10:28:31","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("15","2","1","0","2014-05-08 10:28:41","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("16","2","1","0","2014-05-08 10:34:35","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("17","1","1","0","2014-05-08 12:23:30","","","157.55.0.155","");
INSERT INTO `wp_newsletter_stats` VALUES("18","1","1","0","2014-05-08 12:23:31","http://dev48h.pigiste.org/le-programme/","","86.214.59.246","");
INSERT INTO `wp_newsletter_stats` VALUES("19","2","1","0","2014-05-08 13:11:18","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("20","5","1","0","2014-05-08 14:36:19","","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("21","5","1","0","2014-05-08 14:37:19","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("22","5","1","0","2014-05-08 14:37:22","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("23","5","1","0","2014-05-08 14:37:41","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("24","5","1","0","2014-05-08 14:39:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("25","5","1","0","2014-05-08 14:43:29","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("26","5","1","0","2014-05-08 14:45:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("27","2","1","0","2014-05-08 19:31:34","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("28","5","1","0","2014-05-09 00:40:29","http://dev48h.pigiste.org/le-programme/","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("29","2","1","0","2014-05-09 09:08:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("30","2","1","0","2014-05-09 09:29:42","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("31","2","1","0","2014-05-09 10:09:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("32","2","1","0","2014-06-01 12:08:09","","","90.9.60.51","");


DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=129525 DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` VALUES("1","siteurl","http://dev48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("2","blogname","Les 48h de la pige","yes");
INSERT INTO `wp_options` VALUES("3","blogdescription","Un événement Profession : Pigiste","yes");
INSERT INTO `wp_options` VALUES("4","users_can_register","1","yes");
INSERT INTO `wp_options` VALUES("5","admin_email","admin48@pigiste.org","yes");
INSERT INTO `wp_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("17","default_category","1","yes");
INSERT INTO `wp_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("22","date_format","j F Y","yes");
INSERT INTO `wp_options` VALUES("23","time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("24","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("165","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("166","widget_nav_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `wp_options` VALUES("32","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("34","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("35","active_plugins","a:25:{i:0;s:21:\"polylang/polylang.php\";i:1;s:19:\"bbpress/bbpress.php\";i:2;s:41:\"better-wp-security/better-wp-security.php\";i:3;s:43:\"broken-link-checker/broken-link-checker.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:31:\"cookie-notice/cookie-notice.php\";i:6;s:41:\"cr3ativ-conference/cr3ativ-conference.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:27:\"email-users/email-users.php\";i:9;s:45:\"events-manager-email-users/em-email-users.php\";i:10;s:33:\"events-manager/events-manager.php\";i:11;s:34:\"font-awesome-more-icons/plugin.php\";i:12;s:41:\"google-maps-widget/google-maps-widget.php\";i:13;s:43:\"leaflet-maps-marker/leaflet-maps-marker.php\";i:14;s:35:\"login-with-ajax/login-with-ajax.php\";i:15;s:33:\"nav-menu-roles/nav-menu-roles.php\";i:16;s:21:\"newsletter/plugin.php\";i:17;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:18;s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";i:19;s:39:\"svg-vector-icon-plugin/wp-svg-icons.php\";i:21;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:22;s:25:\"ultimate-member/index.php\";i:23;s:27:\"updraftplus/updraftplus.php\";i:24;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";i:25;s:27:\"wp-optimize/wp-optimize.php\";}","yes");
INSERT INTO `wp_options` VALUES("36","home","http://dev48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("37","category_base","","yes");
INSERT INTO `wp_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `wp_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("41","gmt_offset","1","yes");
INSERT INTO `wp_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("43","recently_edited","a:5:{i:0;s:74:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/includes/error404.php\";i:2;s:60:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/404.php\";i:3;s:62:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/style.css\";i:4;s:66:\"/homez.313/pigiste/48heures/wp-content/plugins/bbpress/bbpress.php\";i:5;s:63:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/footer.php\";}","no");
INSERT INTO `wp_options` VALUES("44","template","evolve","yes");
INSERT INTO `wp_options` VALUES("45","stylesheet","evolve","yes");
INSERT INTO `wp_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("52","db_version","31532","yes");
INSERT INTO `wp_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("54","upload_path","","yes");
INSERT INTO `wp_options` VALUES("55","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("57","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("58","tag_base","","yes");
INSERT INTO `wp_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("62","thumbnail_size_w","80","yes");
INSERT INTO `wp_options` VALUES("63","thumbnail_size_h","80","yes");
INSERT INTO `wp_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("68","large_size_w","1030","yes");
INSERT INTO `wp_options` VALUES("69","large_size_h","1030","yes");
INSERT INTO `wp_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `wp_options` VALUES("71","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("72","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("77","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("82","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("83","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("85","uninstall_plugins","a:4:{s:41:\"google-maps-widget/google-maps-widget.php\";a:2:{i:0;s:3:\"GMW\";i:1;s:9:\"uninstall\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}s:39:\"svg-vector-icon-plugin/wp-svg-icons.php\";s:22:\"uninstall_wp_svg_icons\";s:35:\"qtranslate-slug/qtranslate-slug.php\";s:13:\"qts_uninstall\";}","no");
INSERT INTO `wp_options` VALUES("86","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("88","page_on_front","1836","yes");
INSERT INTO `wp_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","26691","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:128:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:100:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:46:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:31:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"email_single_user\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:16:\"edit_tribe_event\";b:1;s:16:\"read_tribe_event\";b:1;s:18:\"delete_tribe_event\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:16:\"edit_tribe_venue\";b:1;s:16:\"read_tribe_venue\";b:1;s:18:\"delete_tribe_venue\";b:1;s:19:\"delete_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:20:\"edit_tribe_organizer\";b:1;s:20:\"read_tribe_organizer\";b:1;s:22:\"delete_tribe_organizer\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:15:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:16:\"read_tribe_event\";b:1;s:20:\"read_tribe_organizer\";b:1;s:16:\"read_tribe_venue\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:0:{}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("93","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("94","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("96","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("98","sidebars_widgets","a:11:{s:18:\"orphaned_widgets_2\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:18:\"orphaned_widgets_3\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:18:\"orphaned_widgets_6\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:2:{i:0;s:10:\"polylang-2\";i:1;s:22:\"oauth_twitter_widget-3\";}s:9:\"sidebar-2\";a:1:{i:0;s:21:\"loginwithajaxwidget-2\";}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("99","cron","a:16:{i:1430040122;a:1:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1430040297;a:1:{s:20:\"blc_cron_check_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1430040435;a:1:{s:26:\"um_hourly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1430055793;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430056993;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430058435;a:2:{s:25:\"um_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"um_twicedaily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1430072697;a:2:{s:28:\"blc_cron_email_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"blc_cron_check_news\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430073060;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1430081925;a:2:{s:14:\"updraft_backup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"updraft_backup_database\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430082441;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1430125352;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430231097;a:1:{s:29:\"blc_cron_database_maintenance\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"bimonthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:936000;}}}i:1430231235;a:1:{s:26:\"um_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1430337738;a:1:{s:25:\"newsletter_check_versions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"newsletter_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1430410172;a:1:{s:8:\"gmw_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"gmw_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("114272","updraft_dreamobjects","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("151","recently_activated","a:5:{s:43:\"the-events-calendar/the-events-calendar.php\";i:1429806085;s:38:\"smartifw/smart_icons_for_wordpress.php\";i:1429790369;s:35:\"qtranslate-slug/qtranslate-slug.php\";i:1429643052;s:27:\"qtranslate-x/qtranslate.php\";i:1429643050;s:58:\"contact-form-7-to-database-extension/contact-form-7-db.php\";i:1429629015;}","yes");
INSERT INTO `wp_options` VALUES("154","_bbp_private_forums","a:3:{i:0;i:1739;i:1;i:39758;i:2;i:39763;}","yes");
INSERT INTO `wp_options` VALUES("155","_bbp_hidden_forums","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("501","_bbp_forum_slug","forum","yes");
INSERT INTO `wp_options` VALUES("156","_bbp_db_version","250","yes");
INSERT INTO `wp_options` VALUES("157","widget_newsbox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("158","widget_portfoliobox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("159","widget_avia_socialcount","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("160","widget_avia_combo_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("161","widget_avia_partner_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("162","widget_avia_google_maps","a:3:{i:1;a:0:{}i:5;a:15:{s:5:\"title\";s:84:\"Cette année, rendez-vous sur le Campus Albert Londres à Vichy les 3 et 4 juillet !\";s:14:\"street-address\";s:36:\"Pôle technologique et universitaire\";s:4:\"city\";s:0:\"\";s:5:\"state\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:7:\"country\";s:5:\"VICHY\";s:3:\"lat\";s:8:\"46.11946\";s:3:\"lng\";s:16:\"3.42521320000003\";s:4:\"zoom\";s:2:\"15\";s:4:\"type\";s:7:\"ROADMAP\";s:12:\"directionsto\";s:0:\"\";s:7:\"content\";s:0:\"\";s:4:\"icon\";s:68:\"http://dev48h.pigiste.org/wp-content/uploads/2014/05/marqueur-01.png\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:5:\"280px\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("163","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("164","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("168","widget_bbp_login_widget","a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:12:\"Se connecter\";s:8:\"register\";s:0:\"\";s:8:\"lostpass\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("114285","updraft_split_every","500","yes");
INSERT INTO `wp_options` VALUES("114286","updraft_dir","updraft","yes");
INSERT INTO `wp_options` VALUES("502","_bbp_topic_slug","sujet","yes");
INSERT INTO `wp_options` VALUES("503","_bbp_topic_tag_slug","mot-clé","yes");
INSERT INTO `wp_options` VALUES("504","_bbp_view_slug","voir-le-sujet","yes");
INSERT INTO `wp_options` VALUES("505","_bbp_reply_slug","répondre","yes");
INSERT INTO `wp_options` VALUES("506","_bbp_search_slug","rechercher","yes");
INSERT INTO `wp_options` VALUES("507","_bbp_user_slug","utilisateurs","yes");
INSERT INTO `wp_options` VALUES("508","_bbp_topic_archive_slug","sujets","yes");
INSERT INTO `wp_options` VALUES("509","_bbp_reply_archive_slug","réponses","yes");
INSERT INTO `wp_options` VALUES("510","_bbp_user_favs_slug","favoris","yes");
INSERT INTO `wp_options` VALUES("511","_bbp_user_subs_slug","souscrire","yes");
INSERT INTO `wp_options` VALUES("101709","theme_mods_twentyfifteen","a:1:{i:0;b:0;}","yes");
INSERT INTO `wp_options` VALUES("116882","theme_switched_via_customizer","","yes");
INSERT INTO `wp_options` VALUES("127209","can_compress_scripts","0","yes");
INSERT INTO `wp_options` VALUES("127228","_site_transient_timeout_wordpress_credits_fr_FR","1429909859","yes");
INSERT INTO `wp_options` VALUES("127229","_site_transient_wordpress_credits_fr_FR","a:2:{s:6:\"groups\";a:8:{s:15:\"project-leaders\";a:4:{s:4:\"name\";s:15:\"Project Leaders\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:6:{s:4:\"matt\";a:4:{i:0;s:14:\"Matt Mullenweg\";i:1;s:32:\"767fc9c115a1b989744c755db47feb60\";i:2;s:4:\"matt\";i:3;s:23:\"Cofounder, Project Lead\";}s:5:\"nacin\";a:4:{i:0;s:12:\"Andrew Nacin\";i:1;s:32:\"01cfe9feaafb068590891bbd1f6a7f5a\";i:2;s:5:\"nacin\";i:3;s:14:\"Lead Developer\";}s:11:\"markjaquith\";a:4:{i:0;s:12:\"Mark Jaquith\";i:1;s:32:\"097a87a525e317519b5ee124820012fb\";i:2;s:11:\"markjaquith\";i:3;s:14:\"Lead Developer\";}s:6:\"azaozz\";a:4:{i:0;s:10:\"Andrew Ozz\";i:1;s:32:\"4e84843ebff0918d72ade21c6ee7b1e4\";i:2;s:6:\"azaozz\";i:3;s:14:\"Lead Developer\";}s:5:\"helen\";a:4:{i:0;s:16:\"Helen Hou-Sandí\";i:1;s:32:\"6506162ada6b700b151ad8a187f65842\";i:2;s:5:\"helen\";i:3;s:14:\"Lead Developer\";}s:4:\"dd32\";a:4:{i:0;s:10:\"Dion Hulse\";i:1;s:32:\"4af2825655b46fb1206b08d9041d8e3e\";i:2;s:4:\"dd32\";i:3;s:14:\"Lead Developer\";}}}s:15:\"core-developers\";a:4:{s:4:\"name\";s:23:\"Contributing Developers\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:0;s:4:\"data\";a:9:{s:12:\"DrewAPicture\";a:4:{i:0;s:11:\"Drew Jaynes\";i:1;s:32:\"95c934fa2c3362794bf62ff8c59ada08\";i:2;s:12:\"DrewAPicture\";i:3;s:12:\"Release Lead\";}s:7:\"ocean90\";a:4:{i:0;s:17:\"Dominik Schilling\";i:1;s:32:\"3e8e161d97d793bd8fc2dcd62583bb76\";i:2;s:7:\"ocean90\";i:3;s:14:\"Core Developer\";}s:14:\"SergeyBiryukov\";a:4:{i:0;s:15:\"Sergey Biryukov\";i:1;s:32:\"750b7b0fcd855389264c2b1294d61bd6\";i:2;s:14:\"SergeyBiryukov\";i:3;s:14:\"Core Developer\";}s:14:\"wonderboymusic\";a:4:{i:0;s:12:\"Scott Taylor\";i:1;s:32:\"112ca15732a80bb928c52caec9d2c8dd\";i:2;s:14:\"wonderboymusic\";i:3;s:14:\"Core Developer\";}s:11:\"johnbillion\";a:4:{i:0;s:15:\"John Blackbourn\";i:1;s:32:\"0000ba6dd1b089e1746abbfe6281ee3b\";i:2;s:11:\"johnbillion\";i:3;s:14:\"Core Developer\";}s:12:\"boonebgorges\";a:4:{i:0;s:15:\"Boone B. Gorges\";i:1;s:32:\"9cf7c4541a582729a5fc7ae484786c0c\";i:2;s:12:\"boonebgorges\";i:3;s:14:\"Core Developer\";}s:5:\"pento\";a:4:{i:0;s:15:\"Gary Pendergast\";i:1;s:32:\"1ad9e5c98d81c6815a65dab5b6e1f669\";i:2;s:5:\"pento\";i:3;s:14:\"Core Developer\";}s:4:\"ryan\";a:4:{i:0;s:10:\"Ryan Boren\";i:1;s:32:\"c22398fb9602c967d1dac8174f4a1a4e\";i:2;s:4:\"ryan\";i:3;s:0:\"\";}s:12:\"lancewillett\";a:4:{i:0;s:13:\"Lance Willett\";i:1;s:32:\"47976847383b324bd35e228a91eb1a0f\";i:2;s:12:\"lancewillett\";i:3;s:0:\"\";}}}s:23:\"contributing-developers\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:3:{s:7:\"iseulde\";a:4:{i:0;s:22:\"Ella Iseulde Van Dorpe\";i:1;s:32:\"fee611dacac99d496068e201d81650d6\";i:2;s:7:\"iseulde\";i:3;s:0:\"\";}s:6:\"jorbin\";a:4:{i:0;s:12:\"Aaron Jorbin\";i:1;s:32:\"b3e2b94eb305bf95a1bee11bc7705fb7\";i:2;s:6:\"jorbin\";i:3;s:0:\"\";}s:10:\"jeremyfelt\";a:4:{i:0;s:11:\"Jeremy Felt\";i:1;s:32:\"d1759b1c669981b7c52ec9a97d19e6bd\";i:2;s:10:\"jeremyfelt\";i:3;s:0:\"\";}}}s:16:\"recent-rockstars\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:9:{s:8:\"stephdau\";a:4:{i:0;s:14:\"Stephane Daury\";i:1;s:32:\"5b8d74a711e183850bd70ccdd440d15e\";i:2;s:8:\"stephdau\";i:3;s:0:\"\";}s:15:\"michael-arestad\";a:4:{i:0;s:15:\"Michael Arestad\";i:1;s:32:\"e8b4c8470f61ff15b9c98f7a1556c16b\";i:2;s:15:\"michael-arestad\";i:3;s:0:\"\";}s:7:\"kraftbj\";a:4:{i:0;s:13:\"Brandon Kraft\";i:1;s:32:\"6e238edcb0664c975ccb9e8e80abb307\";i:2;s:7:\"kraftbj\";i:3;s:0:\"\";}s:16:\"celloexpressions\";a:4:{i:0;s:11:\"Nick Halsey\";i:1;s:32:\"42e659bb8c86851c230e527f8ce1764b\";i:2;s:16:\"celloexpressions\";i:3;s:0:\"\";}s:11:\"westonruter\";a:4:{i:0;s:12:\"Weston Ruter\";i:1;s:32:\"22ed378fbf1d918ef43a45b2a1f34634\";i:2;s:11:\"westonruter\";i:3;s:0:\"\";}s:7:\"afercia\";a:4:{i:0;s:13:\"Andrea Fercia\";i:1;s:32:\"074af62ea5ff218b6a6eeab89104f616\";i:2;s:7:\"afercia\";i:3;s:0:\"\";}s:12:\"valendesigns\";a:4:{i:0;s:12:\"Derek Herman\";i:1;s:32:\"ca0dc28865ede5a2b2a9e22971b87993\";i:2;s:12:\"valendesigns\";i:3;s:0:\"\";}s:9:\"joedolson\";a:4:{i:0;s:10:\"Joe Dolson\";i:1;s:32:\"ee77adf6adc6fe90b388f97b0bd912b2\";i:2;s:9:\"joedolson\";i:3;s:0:\"\";}s:5:\"tyxla\";a:4:{i:0;s:14:\"Marin Atanasov\";i:1;s:32:\"cf58282ee2e95590510aaa24b734c186\";i:2;s:5:\"tyxla\";i:3;s:0:\"\";}}}s:5:\"props\";a:4:{s:4:\"name\";s:33:\"Core Contributors to WordPress %s\";s:12:\"placeholders\";a:1:{i:0;s:3:\"4.2\";}s:4:\"type\";s:4:\"list\";s:4:\"data\";a:257:{s:7:\"mercime\";s:8:\"@mercime\";s:10:\"a5hleyrich\";s:10:\"A5hleyRich\";s:13:\"aaroncampbell\";s:17:\"Aaron D. Campbell\";s:11:\"abhishekfdd\";s:11:\"abhishekfdd\";s:15:\"adamsilverstein\";s:16:\"Adam Silverstein\";s:12:\"mrahmadawais\";s:11:\"Ahmad Awais\";s:11:\"alexkingorg\";s:9:\"Alex King\";s:12:\"viper007bond\";s:25:\"Alex Mills (Viper007Bond)\";s:6:\"deconf\";s:10:\"Alin Marcu\";s:15:\"collinsinternet\";s:13:\"Allan Collins\";s:7:\"awbauer\";s:12:\"Andrew Bauer\";s:8:\"norcross\";s:15:\"Andrew Norcross\";s:18:\"ankitgadertcampcom\";s:10:\"Ankit Gade\";s:13:\"ankit-k-gupta\";s:13:\"Ankit K Gupta\";s:7:\"atimmer\";s:16:\"Anton Timmermans\";s:6:\"aramzs\";s:19:\"Aram Zucker-Scharff\";s:10:\"arminbraun\";s:10:\"ArminBraun\";s:7:\"ashfame\";s:7:\"Ashfame\";s:8:\"filosofo\";s:13:\"Austin Matzko\";s:5:\"avryl\";s:5:\"avryl\";s:10:\"barrykooij\";s:11:\"Barry Kooij\";s:10:\"beaulebens\";s:11:\"Beau Lebens\";s:6:\"bendoh\";s:24:\"Ben Doherty (Oomph, Inc)\";s:15:\"bananastalktome\";s:15:\"Billy Schneider\";s:9:\"krogsgard\";s:15:\"Brian Krogsgard\";s:8:\"bswatson\";s:12:\"Brian Watson\";s:8:\"calevans\";s:8:\"CalEvans\";s:13:\"carolinegeven\";s:13:\"carolinegeven\";s:20:\"caseypatrickdriscoll\";s:14:\"Casey Driscoll\";s:6:\"caspie\";s:6:\"Caspie\";s:4:\"cdog\";s:14:\"Catalin Dogaru\";s:11:\"chipbennett\";s:12:\"Chip Bennett\";s:7:\"chipx86\";s:7:\"chipx86\";s:6:\"chrico\";s:6:\"ChriCo\";s:11:\"cbaldelomar\";s:16:\"Chris Baldelomar\";s:10:\"c3mdigital\";s:14:\"Chris Olbekson\";s:10:\"cfoellmann\";s:19:\"Christian Foellmann\";s:6:\"cfinke\";s:17:\"Christopher Finke\";s:11:\"clifgriffin\";s:15:\"Clifton Griffin\";s:5:\"codix\";s:11:\"Code Master\";s:6:\"corphi\";s:6:\"Corphi\";s:12:\"couturefreak\";s:13:\"Courtney Ivey\";s:13:\"craig-ralston\";s:13:\"Craig Ralston\";s:7:\"cweiske\";s:7:\"cweiske\";s:11:\"extendwings\";s:17:\"Daisuke Takahashi\";s:8:\"timersys\";s:6:\"Damian\";s:15:\"danielbachhuber\";s:16:\"Daniel Bachhuber\";s:10:\"redsweater\";s:27:\"Daniel Jalkut (Red Sweater)\";s:7:\"dkotter\";s:12:\"Darin Kotter\";s:6:\"nerrad\";s:22:\"Darren Ethier (nerrad)\";s:4:\"dllh\";s:26:\"Daryl L. L. Houston (dllh)\";s:7:\"dmchale\";s:11:\"Dave McHale\";s:13:\"davidakennedy\";s:16:\"David A. Kennedy\";s:13:\"davidanderson\";s:14:\"David Anderson\";s:8:\"folletto\";s:24:\"Davide \'Folletto\' Casali\";s:16:\"davideugenepratt\";s:16:\"davideugenepratt\";s:14:\"davidhamiltron\";s:14:\"davidhamiltron\";s:3:\"dlh\";s:13:\"David Herrera\";s:17:\"denis-de-bernardy\";s:17:\"Denis de Bernardy\";s:6:\"dsmart\";s:11:\"Derek Smart\";s:12:\"designsimply\";s:12:\"designsimply\";s:14:\"dipeshkakadiya\";s:15:\"dipesh.kakadiya\";s:11:\"doublesharp\";s:11:\"doublesharp\";s:7:\"dzerycz\";s:7:\"DzeryCZ\";s:6:\"kucrut\";s:11:\"Dzikri Aziz\";s:12:\"emazovetskiy\";s:13:\"e.mazovetskiy\";s:10:\"oso96_2000\";s:15:\"Eduardo Reveles\";s:4:\"cais\";s:14:\"Edward Caissie\";s:10:\"eliorivero\";s:11:\"Elio Rivero\";s:14:\"elliottcarlson\";s:14:\"elliottcarlson\";s:4:\"enej\";s:4:\"enej\";s:8:\"ebinnion\";s:12:\"Eric Binnion\";s:8:\"ethitter\";s:12:\"Erick Hitter\";s:9:\"ericlewis\";s:10:\"Eric Lewis\";s:11:\"evansolomon\";s:12:\"Evan Solomon\";s:6:\"fab1en\";s:17:\"Fabien Quatravaux\";s:7:\"fhwebcs\";s:7:\"fhwebcs\";s:13:\"floriansimeth\";s:14:\"Florian Simeth\";s:7:\"bueltge\";s:5:\"Frank\";s:7:\"frankpw\";s:22:\"Frank P. Walentynowicz\";s:10:\"f-j-kaiser\";s:18:\"Franz Josef Kaiser\";s:7:\"garyc40\";s:8:\"Gary Cao\";s:5:\"garyj\";s:10:\"Gary Jones\";s:7:\"geertdd\";s:16:\"Geert De Deckere\";s:8:\"genkisan\";s:8:\"genkisan\";s:15:\"georgestephanis\";s:16:\"George Stephanis\";s:14:\"grahamarmfield\";s:15:\"Graham Armfield\";s:6:\"webord\";s:15:\"Gustavo Bordoni\";s:5:\"hakre\";s:5:\"hakre\";s:15:\"harishchaudhari\";s:16:\"Harish Chaudhari\";s:7:\"hauvong\";s:7:\"hauvong\";s:12:\"herbmillerjr\";s:12:\"herbmillerjr\";s:3:\"hew\";s:3:\"Hew\";s:6:\"horike\";s:6:\"horike\";s:11:\"hlashbrooke\";s:15:\"Hugh Lashbrooke\";s:9:\"hugobaeta\";s:10:\"Hugo Baeta\";s:7:\"iandunn\";s:8:\"Ian Dunn\";s:9:\"ianmjones\";s:9:\"ianmjones\";s:8:\"idealien\";s:8:\"idealien\";s:5:\"imath\";s:5:\"imath\";s:7:\"ipstenu\";s:22:\"Ipstenu (Mika Epstein)\";s:8:\"jdgrimes\";s:11:\"J.D. Grimes\";s:9:\"jacklenox\";s:10:\"Jack Lenox\";s:12:\"jamescollins\";s:13:\"James Collins\";s:11:\"janhenckens\";s:11:\"janhenckens\";s:9:\"cheffheid\";s:11:\"Jeff de Wit\";s:11:\"jfarthing84\";s:13:\"Jeff Farthing\";s:5:\"jesin\";s:7:\"Jesin A\";s:8:\"jipmoors\";s:8:\"jipmoors\";s:6:\"jartes\";s:10:\"Joan Artes\";s:8:\"yo-l1982\";s:14:\"Joel Bernerman\";s:9:\"joemcgill\";s:10:\"Joe McGill\";s:4:\"joen\";s:13:\"Joen Asmussen\";s:10:\"johneckman\";s:11:\"John Eckman\";s:15:\"johnjamesjacoby\";s:17:\"John James Jacoby\";s:12:\"jlevandowski\";s:16:\"John Levandowski\";s:7:\"desrosj\";s:19:\"Jonathan Desrosiers\";s:14:\"joostdekeijzer\";s:16:\"joost de keijzer\";s:11:\"joostdevalk\";s:13:\"Joost de Valk\";s:10:\"jcastaneda\";s:14:\"Jose Castaneda\";s:12:\"joshlevinson\";s:13:\"Josh Levinson\";s:6:\"jphase\";s:6:\"jphase\";s:8:\"juliobox\";s:12:\"Julio Potier\";s:9:\"kopepasah\";s:16:\"Justin Kopepasah\";s:11:\"jtsternberg\";s:16:\"Justin Sternberg\";s:11:\"justincwatt\";s:11:\"Justin Watt\";s:10:\"kadamwhite\";s:12:\"K.Adam White\";s:7:\"trepmal\";s:16:\"Kailey (trepmal)\";s:6:\"ryelle\";s:10:\"Kelly Dwan\";s:12:\"kevdotbadger\";s:12:\"Kevin Ruscoe\";s:8:\"kpdesign\";s:11:\"Kim Parsell\";s:7:\"ixkaito\";s:4:\"Kite\";s:9:\"kovshenin\";s:20:\"Konstantin Kovshenin\";s:8:\"obenland\";s:19:\"Konstantin Obenland\";s:7:\"mindrun\";s:7:\"Leonard\";s:6:\"leopeo\";s:16:\"Leonardo Giacone\";s:7:\"lgladdy\";s:11:\"Liam Gladdy\";s:9:\"maimairel\";s:9:\"maimairel\";s:6:\"mako09\";s:4:\"Mako\";s:11:\"funkatronic\";s:15:\"Manny Fleurmond\";s:12:\"marcelomazza\";s:12:\"marcelomazza\";s:11:\"marcochiesi\";s:12:\"Marco Chiesi\";s:4:\"mkaz\";s:18:\"Marcus Kazmierczak\";s:9:\"nofearinc\";s:12:\"Mario Peshev\";s:7:\"clorith\";s:16:\"Marius (Clorith)\";s:12:\"markoheijnen\";s:13:\"Marko Heijnen\";s:5:\"senff\";s:10:\"Mark Senff\";s:4:\"mzak\";s:4:\"Matt\";s:7:\"mboynes\";s:14:\"Matthew Boynes\";s:19:\"mattheweppelsheimer\";s:20:\"Matthew Eppelsheimer\";s:7:\"mattheu\";s:20:\"Matthew Haines-Young\";s:5:\"sivel\";s:10:\"Matt Martz\";s:9:\"mattwiebe\";s:10:\"Matt Wiebe\";s:8:\"mattyrob\";s:8:\"mattyrob\";s:9:\"maxcutler\";s:10:\"Max Cutler\";s:13:\"mehulkaklotar\";s:13:\"mehulkaklotar\";s:9:\"melchoyce\";s:10:\"Mel Choyce\";s:7:\"meloniq\";s:7:\"meloniq\";s:9:\"mgibbs189\";s:9:\"mgibbs189\";s:8:\"mdawaffe\";s:24:\"Michael Adams (mdawaffe)\";s:6:\"tw2113\";s:16:\"Michael Beckwith\";s:11:\"michalzuber\";s:11:\"michalzuber\";s:4:\"mdgl\";s:16:\"Mike Glendinning\";s:12:\"mikehansenme\";s:11:\"Mike Hansen\";s:9:\"thaicloud\";s:11:\"Mike Jordan\";s:12:\"mikengarrett\";s:12:\"MikeNGarrett\";s:12:\"mikeschinkel\";s:13:\"Mike Schinkel\";s:7:\"dimadin\";s:11:\"Milan Dinic\";s:5:\"mmn-o\";s:5:\"mmn-o\";s:6:\"batmoo\";s:15:\"Mohammad Jangda\";s:6:\"momdad\";s:6:\"MomDad\";s:11:\"morganestes\";s:12:\"Morgan Estes\";s:8:\"morpheu5\";s:8:\"Morpheu5\";s:3:\"Nao\";s:12:\"Naoko Takano\";s:13:\"nathan_dawson\";s:13:\"nathan_dawson\";s:8:\"neil_pie\";s:8:\"Neil Pie\";s:14:\"nicnicnicdevos\";s:14:\"nicnicnicdevos\";s:4:\"nikv\";s:12:\"Nikhil Vimal\";s:10:\"ninnypants\";s:10:\"ninnypants\";s:5:\"nitkr\";s:5:\"nitkr\";s:14:\"nunomorgadinho\";s:15:\"Nuno Morgadinho\";s:11:\"originalexe\";s:11:\"OriginalEXE\";s:16:\"pareshradadiya-1\";s:15:\"Paresh Radadiya\";s:8:\"pathawks\";s:9:\"Pat Hawks\";s:7:\"pbearne\";s:11:\"Paul Bearne\";s:13:\"paulschreiber\";s:14:\"Paul Schreiber\";s:9:\"paulwilde\";s:10:\"Paul Wilde\";s:9:\"pavelevap\";s:9:\"pavelevap\";s:10:\"sirbrillig\";s:12:\"Payton Swick\";s:8:\"petemall\";s:9:\"Pete Mall\";s:10:\"gungeekatx\";s:11:\"Pete Nelson\";s:13:\"peterwilsoncc\";s:12:\"Peter Wilson\";s:7:\"mordauk\";s:17:\"Pippin Williamson\";s:9:\"podpirate\";s:9:\"podpirate\";s:14:\"postpostmodern\";s:14:\"postpostmodern\";s:11:\"nprasath002\";s:17:\"Prasath Nadarajah\";s:11:\"prasoon2211\";s:11:\"prasoon2211\";s:5:\"cyman\";s:13:\"Primoz Cigler\";s:5:\"r-a-y\";s:5:\"r-a-y\";s:11:\"rachelbaker\";s:12:\"Rachel Baker\";s:13:\"rahulbhangale\";s:13:\"rahulbhangale\";s:5:\"ramiy\";s:14:\"Rami Yushuvaev\";s:7:\"lamosty\";s:15:\"Rastislav Lamos\";s:18:\"ravindra-pal-singh\";s:18:\"Ravindra Pal Singh\";s:12:\"rianrietveld\";s:13:\"Rian Rietveld\";s:12:\"ritteshpatel\";s:12:\"Ritesh Patel\";s:11:\"miqrogroove\";s:13:\"Robert Chapin\";s:13:\"rodrigosprimo\";s:13:\"Rodrigo Primo\";s:15:\"magicroundabout\";s:11:\"Ross Wintle\";s:6:\"rmarks\";s:10:\"Ryan Marks\";s:11:\"sagarjadhav\";s:11:\"sagarjadhav\";s:8:\"samo9789\";s:8:\"samo9789\";s:12:\"samuelsidler\";s:12:\"samuelsidler\";s:13:\"scottgonzalez\";s:14:\"scott.gonzalez\";s:6:\"sgrant\";s:11:\"Scott Grant\";s:11:\"coffee2code\";s:12:\"Scott Reilly\";s:8:\"greglone\";s:12:\"ScreenfeedFr\";s:6:\"scribu\";s:6:\"scribu\";s:10:\"seanchayes\";s:10:\"Sean Hayes\";s:13:\"sergejmueller\";s:13:\"Sergej Muller\";s:10:\"sevenspark\";s:10:\"sevenspark\";s:13:\"simonwheatley\";s:14:\"Simon Wheatley\";s:7:\"siobhan\";s:7:\"Siobhan\";s:6:\"sippis\";s:6:\"sippis\";s:13:\"slobodanmanic\";s:14:\"Slobodan Manic\";s:12:\"solarissmoke\";s:12:\"solarissmoke\";s:9:\"sillybean\";s:15:\"Stephanie Leary\";s:6:\"netweb\";s:13:\"Stephen Edgar\";s:13:\"stevegrunwell\";s:14:\"Steve Grunwell\";s:17:\"stevehickeydesign\";s:17:\"stevehickeydesign\";s:11:\"stevenkword\";s:11:\"Steven Word\";s:10:\"iamtakashi\";s:12:\"Takashi Irie\";s:5:\"hissy\";s:16:\"Takuro Hishikawa\";s:8:\"themiked\";s:8:\"theMikeD\";s:8:\"thomaswm\";s:8:\"thomaswm\";s:11:\"ipm-frommen\";s:16:\"Thorsten Frommen\";s:10:\"tillkruess\";s:4:\"Till\";s:17:\"timothyblynjacobs\";s:14:\"Timothy Jacobs\";s:6:\"tiqbiz\";s:6:\"tiqbiz\";s:8:\"tmatsuur\";s:8:\"tmatsuur\";s:8:\"tmeister\";s:8:\"tmeister\";s:8:\"tobiasbg\";s:8:\"TobiasBg\";s:9:\"tschutter\";s:15:\"Tobias Schutter\";s:6:\"tomdxw\";s:6:\"tomdxw\";s:15:\"travisnorthcutt\";s:16:\"Travis Northcutt\";s:11:\"trishasalas\";s:11:\"trishasalas\";s:7:\"tywayne\";s:10:\"Ty Carlson\";s:4:\"uamv\";s:4:\"UaMV\";s:10:\"desaiuditd\";s:10:\"Udit Desai\";s:8:\"sorich87\";s:13:\"Ulrich Sossou\";s:11:\"veritaserum\";s:11:\"Veritaserum\";s:14:\"voldemortensen\";s:14:\"voldemortensen\";s:10:\"volodymyrc\";s:10:\"VolodymyrC\";s:6:\"vortfu\";s:6:\"vortfu\";s:7:\"welcher\";s:7:\"welcher\";s:7:\"earnjam\";s:17:\"William Earnhardt\";s:13:\"wordpressorru\";s:11:\"WordPressor\";}}s:10:\"validators\";a:4:{s:4:\"name\";s:11:\"Translators\";s:4:\"type\";s:7:\"compact\";s:7:\"shuffle\";b:1;s:4:\"data\";a:4:{s:13:\"momo360modena\";a:3:{i:0;s:13:\"Amaury Balmer\";i:1;s:32:\"bd9516b368db97643f1cff5bf4c82123\";i:2;s:13:\"momo360modena\";}s:10:\"ben-kenobi\";a:3:{i:0;s:18:\"Benoit Catherineau\";i:1;s:32:\"7bb495a607f1f7e4a231404a42b81936\";i:2;s:10:\"ben-kenobi\";}s:5:\"danbp\";a:3:{i:0;s:5:\"danbp\";i:1;s:32:\"0deae2e7003027fbf153500cd3fa5501\";i:2;s:5:\"danbp\";}s:4:\"xibe\";a:3:{i:0;s:15:\"Xavier Borderie\";i:1;s:32:\"c16970a350d2de8ced3017a5a8514969\";i:2;s:4:\"xibe\";}}}s:11:\"translators\";a:3:{s:4:\"name\";b:0;s:4:\"type\";s:4:\"list\";s:4:\"data\";a:4:{s:4:\"fge0\";s:14:\"Franck Gervais\";s:8:\"fxbenard\";s:8:\"fxbenard\";s:8:\"nicochto\";s:8:\"nicochto\";s:10:\"trollivier\";s:10:\"Trollivier\";}}s:9:\"libraries\";a:3:{s:4:\"name\";s:18:\"External Libraries\";s:4:\"type\";s:9:\"libraries\";s:4:\"data\";a:29:{i:0;a:2:{i:0;s:11:\"Backbone.js\";i:1;s:22:\"http://backbonejs.org/\";}i:1;a:2:{i:0;s:10:\"Class POP3\";i:1;s:24:\"http://squirrelmail.org/\";}i:2;a:2:{i:0;s:16:\"Color Animations\";i:1;s:32:\"http://plugins.jquery.com/color/\";}i:3;a:2:{i:0;s:15:\"Horde Text Diff\";i:1;s:22:\"http://pear.horde.org/\";}i:4;a:2:{i:0;s:11:\"hoverIntent\";i:1;s:45:\"http://plugins.jquery.com/project/hoverIntent\";}i:5;a:2:{i:0;s:13:\"imgAreaSelect\";i:1;s:42:\"http://odyniec.net/projects/imgareaselect/\";}i:6;a:2:{i:0;s:4:\"Iris\";i:1;s:34:\"https://github.com/Automattic/Iris\";}i:7;a:2:{i:0;s:6:\"jQuery\";i:1;s:18:\"http://jquery.com/\";}i:8;a:2:{i:0;s:9:\"jQuery UI\";i:1;s:20:\"http://jqueryui.com/\";}i:9;a:2:{i:0;s:14:\"jQuery Hotkeys\";i:1;s:41:\"https://github.com/tzuryby/jquery.hotkeys\";}i:10;a:2:{i:0;s:22:\"jQuery serializeObject\";i:1;s:49:\"http://benalman.com/projects/jquery-misc-plugins/\";}i:11;a:2:{i:0;s:12:\"jQuery.query\";i:1;s:39:\"http://plugins.jquery.com/query-object/\";}i:12;a:2:{i:0;s:14:\"jQuery.suggest\";i:1;s:41:\"http://plugins.jquery.com/project/suggest\";}i:13;a:2:{i:0;s:21:\"jQuery UI Touch Punch\";i:1;s:27:\"http://touchpunch.furf.com/\";}i:14;a:2:{i:0;s:5:\"json2\";i:1;s:43:\"https://github.com/douglascrockford/JSON-js\";}i:15;a:2:{i:0;s:7:\"Masonry\";i:1;s:28:\"http://masonry.desandro.com/\";}i:16;a:2:{i:0;s:15:\"MediaElement.js\";i:1;s:26:\"http://mediaelementjs.com/\";}i:17;a:2:{i:0;s:6:\"PclZip\";i:1;s:33:\"http://www.phpconcept.net/pclzip/\";}i:18;a:2:{i:0;s:6:\"PemFTP\";i:1;s:50:\"http://www.phpclasses.org/browse/package/1743.html\";}i:19;a:2:{i:0;s:6:\"phpass\";i:1;s:31:\"http://www.openwall.com/phpass/\";}i:20;a:2:{i:0;s:9:\"PHPMailer\";i:1;s:55:\"http://code.google.com/a/apache-extras.org/p/phpmailer/\";}i:21;a:2:{i:0;s:8:\"Plupload\";i:1;s:24:\"http://www.plupload.com/\";}i:22;a:2:{i:0;s:9:\"SimplePie\";i:1;s:21:\"http://simplepie.org/\";}i:23;a:2:{i:0;s:27:\"The Incutio XML-RPC Library\";i:1;s:34:\"http://scripts.incutio.com/xmlrpc/\";}i:24;a:2:{i:0;s:8:\"Thickbox\";i:1;s:32:\"http://codylindley.com/thickbox/\";}i:25;a:2:{i:0;s:7:\"TinyMCE\";i:1;s:23:\"http://www.tinymce.com/\";}i:26;a:2:{i:0;s:7:\"Twemoji\";i:1;s:34:\"https://github.com/twitter/twemoji\";}i:27;a:2:{i:0;s:13:\"Underscore.js\";i:1;s:24:\"http://underscorejs.org/\";}i:28;a:2:{i:0;s:6:\"zxcvbn\";i:1;s:33:\"https://github.com/dropbox/zxcvbn\";}}}}s:4:\"data\";a:2:{s:8:\"profiles\";s:33:\"https://profiles.wordpress.org/%s\";s:7:\"version\";s:3:\"4.2\";}}","yes");
INSERT INTO `wp_options` VALUES("128694","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.2\";s:7:\"version\";s:3:\"4.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1430039245;s:15:\"version_checked\";s:3:\"4.2\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("128695","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1430039249;s:7:\"checked\";a:4:{s:6:\"enfold\";s:5:\"2.4.5\";s:6:\"evolve\";s:5:\"3.2.7\";s:13:\"twentyfifteen\";s:3:\"1.1\";s:14:\"twentythirteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("129328","itsec_global","a:24:{s:11:\"write_files\";b:1;s:18:\"notification_email\";a:1:{i:0;s:19:\"admin48@pigiste.org\";}s:12:\"backup_email\";a:1:{i:0;s:19:\"admin48@pigiste.org\";}s:15:\"lockout_message\";s:0:\"\";s:20:\"user_lockout_message\";s:0:\"\";s:25:\"community_lockout_message\";s:0:\"\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:1:{i:0;s:13:\"78.206.68.131\";}s:19:\"email_notifications\";b:1;s:8:\"log_type\";i:0;s:12:\"log_rotation\";i:14;s:12:\"log_location\";s:67:\"/home/pigiste/48heures_dev/wp-content/uploads/ithemes-security/logs\";s:14:\"proxy_override\";b:1;s:11:\"did_upgrade\";b:0;s:14:\"allow_tracking\";b:0;s:10:\"nginx_file\";s:37:\"/home/pigiste/48heures_dev/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:8:\"log_info\";s:24:\"les-48h-de-la-pige-s7GKf\";s:9:\"lock_file\";b:0;s:12:\"digest_email\";b:0;s:14:\"hide_admin_bar\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129330","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1430039247;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:29:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.1.zip\";}s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"520\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:7:\"2.2.6.2\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.zip\";}s:19:\"bbpress/bbpress.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11780\";s:4:\"slug\";s:7:\"bbpress\";s:6:\"plugin\";s:19:\"bbpress/bbpress.php\";s:11:\"new_version\";s:5:\"2.5.7\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/bbpress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.7.zip\";}s:43:\"broken-link-checker/broken-link-checker.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"1090\";s:4:\"slug\";s:19:\"broken-link-checker\";s:6:\"plugin\";s:43:\"broken-link-checker/broken-link-checker.php\";s:11:\"new_version\";s:6:\"1.10.7\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/broken-link-checker/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/broken-link-checker.1.10.7.zip\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"4.1.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.2.zip\";}s:58:\"contact-form-7-to-database-extension/contact-form-7-db.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"16507\";s:4:\"slug\";s:36:\"contact-form-7-to-database-extension\";s:6:\"plugin\";s:58:\"contact-form-7-to-database-extension/contact-form-7-db.php\";s:11:\"new_version\";s:6:\"2.8.36\";s:3:\"url\";s:67:\"https://wordpress.org/plugins/contact-form-7-to-database-extension/\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/plugin/contact-form-7-to-database-extension.2.8.36.zip\";}s:31:\"cookie-notice/cookie-notice.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"42123\";s:4:\"slug\";s:13:\"cookie-notice\";s:6:\"plugin\";s:31:\"cookie-notice/cookie-notice.php\";s:11:\"new_version\";s:6:\"1.2.21\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/cookie-notice/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/cookie-notice.1.2.21.zip\";s:14:\"upgrade_notice\";s:79:\"New: Plugin development moved to dFactory GitHub Repository
Tweak: Code cleanup\";}s:41:\"cr3ativ-conference/cr3ativ-conference.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"54155\";s:4:\"slug\";s:18:\"cr3ativ-conference\";s:6:\"plugin\";s:41:\"cr3ativ-conference/cr3ativ-conference.php\";s:11:\"new_version\";s:5:\"1.2.0\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/cr3ativ-conference/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/cr3ativ-conference.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.16\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.16.zip\";}s:27:\"email-users/email-users.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"580\";s:4:\"slug\";s:11:\"email-users\";s:6:\"plugin\";s:27:\"email-users/email-users.php\";s:11:\"new_version\";s:5:\"4.7.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/email-users/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/email-users.4.7.1.zip\";}s:33:\"events-manager/events-manager.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"4075\";s:4:\"slug\";s:14:\"events-manager\";s:6:\"plugin\";s:33:\"events-manager/events-manager.php\";s:11:\"new_version\";s:5:\"5.5.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/events-manager/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/events-manager.5.5.6.zip\";}s:45:\"events-manager-email-users/em-email-users.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"52901\";s:4:\"slug\";s:26:\"events-manager-email-users\";s:6:\"plugin\";s:45:\"events-manager-email-users/em-email-users.php\";s:11:\"new_version\";s:5:\"1.2.3\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/events-manager-email-users/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/events-manager-email-users.zip\";s:14:\"upgrade_notice\";s:94:\"Bug fix : the recipient list is no longer limited to the default 20 rows view for reservations\";}s:34:\"font-awesome-more-icons/plugin.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"40839\";s:4:\"slug\";s:23:\"font-awesome-more-icons\";s:6:\"plugin\";s:34:\"font-awesome-more-icons/plugin.php\";s:11:\"new_version\";s:3:\"3.5\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/font-awesome-more-icons/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/font-awesome-more-icons.3.5.zip\";s:14:\"upgrade_notice\";s:254:\"In preparation for the upcoming Font Awesome 4.0 release, this update removes the necessity to prefix shortcode options with &quot;icon-&quot;. Please use shortcode options instead of HTML where possible to maintain compatibility with the future release.\";}s:41:\"google-maps-widget/google-maps-widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33487\";s:4:\"slug\";s:18:\"google-maps-widget\";s:6:\"plugin\";s:41:\"google-maps-widget/google-maps-widget.php\";s:11:\"new_version\";s:4:\"2.30\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/google-maps-widget/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/google-maps-widget.2.30.zip\";}s:41:\"better-wp-security/better-wp-security.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"18308\";s:4:\"slug\";s:18:\"better-wp-security\";s:6:\"plugin\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"new_version\";s:6:\"4.6.13\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/better-wp-security/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/better-wp-security.4.6.13.zip\";}s:43:\"leaflet-maps-marker/leaflet-maps-marker.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"27667\";s:4:\"slug\";s:19:\"leaflet-maps-marker\";s:6:\"plugin\";s:43:\"leaflet-maps-marker/leaflet-maps-marker.php\";s:11:\"new_version\";s:5:\"3.9.7\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/leaflet-maps-marker/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/leaflet-maps-marker.3.9.7.zip\";}s:35:\"login-with-ajax/login-with-ajax.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"9425\";s:4:\"slug\";s:15:\"login-with-ajax\";s:6:\"plugin\";s:35:\"login-with-ajax/login-with-ajax.php\";s:11:\"new_version\";s:5:\"3.1.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/login-with-ajax/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/login-with-ajax.3.1.4.zip\";}s:33:\"nav-menu-roles/nav-menu-roles.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"34808\";s:4:\"slug\";s:14:\"nav-menu-roles\";s:6:\"plugin\";s:33:\"nav-menu-roles/nav-menu-roles.php\";s:11:\"new_version\";s:5:\"1.6.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/nav-menu-roles/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/nav-menu-roles.1.6.5.zip\";}s:21:\"newsletter/plugin.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8171\";s:4:\"slug\";s:10:\"newsletter\";s:6:\"plugin\";s:21:\"newsletter/plugin.php\";s:11:\"new_version\";s:5:\"3.7.7\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/newsletter/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/plugin/newsletter.zip\";}s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41825\";s:4:\"slug\";s:28:\"oauth-twitter-sidebar-widget\";s:6:\"plugin\";s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/oauth-twitter-sidebar-widget/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/oauth-twitter-sidebar-widget.zip\";}s:21:\"polylang/polylang.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25780\";s:4:\"slug\";s:8:\"polylang\";s:6:\"plugin\";s:21:\"polylang/polylang.php\";s:11:\"new_version\";s:5:\"1.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/polylang/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/polylang.1.7.3.zip\";}s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21713\";s:4:\"slug\";s:19:\"shortcodes-ultimate\";s:6:\"plugin\";s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";s:11:\"new_version\";s:5:\"4.9.6\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/shortcodes-ultimate/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/shortcodes-ultimate.zip\";}s:43:\"the-events-calendar/the-events-calendar.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11861\";s:4:\"slug\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:43:\"the-events-calendar/the-events-calendar.php\";s:11:\"new_version\";s:5:\"3.9.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/the-events-calendar/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.3.zip\";}s:37:\"tinymce-advanced/tinymce-advanced.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"731\";s:4:\"slug\";s:16:\"tinymce-advanced\";s:6:\"plugin\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:11:\"new_version\";s:5:\"4.1.9\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/tinymce-advanced.4.1.9.zip\";}s:25:\"ultimate-member/index.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"56989\";s:4:\"slug\";s:15:\"ultimate-member\";s:6:\"plugin\";s:25:\"ultimate-member/index.php\";s:11:\"new_version\";s:5:\"1.2.8\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/ultimate-member/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/ultimate-member.1.2.8.zip\";}s:27:\"updraftplus/updraftplus.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"31679\";s:4:\"slug\";s:11:\"updraftplus\";s:6:\"plugin\";s:27:\"updraftplus/updraftplus.php\";s:11:\"new_version\";s:6:\"1.9.64\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/updraftplus/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/updraftplus.1.9.64.zip\";}s:27:\"wp-optimize/wp-optimize.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"6250\";s:4:\"slug\";s:11:\"wp-optimize\";s:6:\"plugin\";s:27:\"wp-optimize/wp-optimize.php\";s:11:\"new_version\";s:8:\"1.8.9.10\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/wp-optimize/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-optimize.1.8.9.10.zip\";}s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"13204\";s:4:\"slug\";s:19:\"wp-maintenance-mode\";s:6:\"plugin\";s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-maintenance-mode/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-maintenance-mode.2.0.3.zip\";}s:39:\"svg-vector-icon-plugin/wp-svg-icons.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41424\";s:4:\"slug\";s:22:\"svg-vector-icon-plugin\";s:6:\"plugin\";s:39:\"svg-vector-icon-plugin/wp-svg-icons.php\";s:11:\"new_version\";s:5:\"3.1.7\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/svg-vector-icon-plugin/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/svg-vector-icon-plugin.3.1.7.zip\";}}}","yes");
INSERT INTO `wp_options` VALUES("116681","widget_qtranslate","a:4:{i:2;a:3:{s:5:\"title\";s:18:\"Choix de la langue\";s:4:\"type\";s:4:\"both\";s:10:\"widget-css\";s:835:\".qtranxs_widget ul { margin: 0; }
.qtranxs_widget ul li
{
display: inline; /* horizontal list, use \"list-item\" or other appropriate value for vertical list */
list-style-type: none; /* use \"initial\" or other to enable bullets */
margin: 0 5px 0 0; /* adjust spacing between items */
opacity: 0.5;
-o-transition: 1s ease opacity;
-moz-transition: 1s ease opacity;
-webkit-transition: 1s ease opacity;
transition: 1s ease opacity;
}
//.qtranxs_widget ul li span { margin: 0 5px 0 0; } /* other way to control spacing */
.qtranxs_widget ul li.active { opacity: 0.8; }
.qtranxs_widget ul li:hover { opacity: 1; }
.qtranxs_widget img { box-shadow: none; vertical-align: middle; }
.qtranxs_flag { height:12px; width:18px; display:block; }
.qtranxs_flag_and_text { padding-left:20px; }
.qtranxs_flag span { display:none; }
\";}i:3;a:3:{s:5:\"title\";s:6:\"Langue\";s:4:\"type\";s:4:\"both\";s:10:\"widget-css\";s:835:\".qtranxs_widget ul { margin: 0; }
.qtranxs_widget ul li
{
display: inline; /* horizontal list, use \"list-item\" or other appropriate value for vertical list */
list-style-type: none; /* use \"initial\" or other to enable bullets */
margin: 0 5px 0 0; /* adjust spacing between items */
opacity: 0.5;
-o-transition: 1s ease opacity;
-moz-transition: 1s ease opacity;
-webkit-transition: 1s ease opacity;
transition: 1s ease opacity;
}
//.qtranxs_widget ul li span { margin: 0 5px 0 0; } /* other way to control spacing */
.qtranxs_widget ul li.active { opacity: 0.8; }
.qtranxs_widget ul li:hover { opacity: 1; }
.qtranxs_widget img { box-shadow: none; vertical-align: middle; }
.qtranxs_flag { height:12px; width:18px; display:block; }
.qtranxs_flag_and_text { padding-left:20px; }
.qtranxs_flag span { display:none; }
\";}i:4;a:3:{s:5:\"title\";s:6:\"Langue\";s:4:\"type\";s:4:\"both\";s:10:\"widget-css\";s:835:\".qtranxs_widget ul { margin: 0; }
.qtranxs_widget ul li
{
display: inline; /* horizontal list, use \"list-item\" or other appropriate value for vertical list */
list-style-type: none; /* use \"initial\" or other to enable bullets */
margin: 0 5px 0 0; /* adjust spacing between items */
opacity: 0.5;
-o-transition: 1s ease opacity;
-moz-transition: 1s ease opacity;
-webkit-transition: 1s ease opacity;
transition: 1s ease opacity;
}
//.qtranxs_widget ul li span { margin: 0 5px 0 0; } /* other way to control spacing */
.qtranxs_widget ul li.active { opacity: 0.8; }
.qtranxs_widget ul li:hover { opacity: 1; }
.qtranxs_widget img { box-shadow: none; vertical-align: middle; }
.qtranxs_flag { height:12px; width:18px; display:block; }
.qtranxs_flag_and_text { padding-left:20px; }
.qtranxs_flag span { display:none; }
\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("116886","enfold_initial_version","2.4.5","yes");
INSERT INTO `wp_options` VALUES("116887","enfold_fixed_random","6","yes");
INSERT INTO `wp_options` VALUES("129306","_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c","1430044111","no");
INSERT INTO `wp_options` VALUES("129307","_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c","1430000911","no");
INSERT INTO `wp_options` VALUES("129308","_transient_timeout_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","1430044112","no");
INSERT INTO `wp_options` VALUES("129309","_transient_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Apr 2015 17:21:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"
		
		
		
		
		
				
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Sortie de WordPress 4.2 « Powell »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/6SJgIbh9aFk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Apr 2015 17:21:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7418\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"La version 4.2 de WordPress, baptisée “Powell” en honneur du pianiste de jazz Bud Powell, est disponible en téléchargement ou via le système de mise à jour, depuis le tableau de bord votre installation de WordPress. Ses nouvelles fonctionnalités vous simplifient la communication et le partage, à l&#8217;échelle mondiale. Une manière plus simple de partager [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7049:\"<p>La version 4.2 de WordPress, baptisée “Powell” en honneur du pianiste de jazz <a href=\"https://fr.wikipedia.org/wiki/Bud_Powell\">Bud Powell</a>, est disponible en <a href=\"https://fr.wordpress.org/\">téléchargement</a> ou via le système de mise à jour, depuis le tableau de bord votre installation de WordPress. Ses nouvelles fonctionnalités vous simplifient la communication et le partage, à l&rsquo;échelle mondiale.</p>
<p><a href=\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/\"><em>Cliquer ici pour voir la vidéo.</em></a></p>
<h3><img class=\"alignright  wp-image-7419\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-press-this-2-500x416.jpg\" alt=\"4.2-press-this-2\" width=\"327\" height=\"272\" />Une manière plus simple de partager votre contenu</h3>
<p>Sélectionnez, modifiez, publiez. Découvrez le nouveau Press This, largement amélioré. Depuis le menu <a href=\"http://xavier.borderie.net/blog/wp-admin/tools.php\">Outils</a>, ajoutez Press This à la barre de favoris de votre navigateur ou la page d&rsquo;accueil de votre appareil mobile. Une fois mis en place, vous pouvez partager votre contenu en ligne à la vitesse de la lumière. Il n’a jamais été aussi facile et rapide de partager vos vidéos, vos images ou vos contenus préférés !</p>
<div class=\"col\">
<h3><img class=\"  wp-image-7420 alignright\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-characters-500x416.png\" alt=\"4.2-characters\" width=\"296\" height=\"246\" />Reconnaissance des caractères étendus</h3>
<p>L’écriture dans WordPress a été améliorée pour toutes les langues. WordPress 4.2 peut utiliser une multitude de nouveaux caractères par défaut, y compris les caractères natifs des écritures chinoises, japonaises et coréennes, ainsi que les symboles musicaux et mathématiques et les hiéroglyphes.</p>
<p>Vous n’utilisez aucun de ces caractères ? Vous pouvez malgré tout vous amuser avec — les caractères emoji sont maintenant disponibles dans WordPress ! Soyez créatifs et agrémentez votre contenu avec <img src=\"http://s.w.org/images/core/emoji/72x72/1f499.png\" alt=\"&#x1f499;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f438.png\" alt=\"&#x1f438;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f412.png\" alt=\"&#x1f412;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f355.png\" alt=\"&#x1f355;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> ou n’importe quel autre <a href=\"https://codex.wordpress.org/Emoji\">emoji</a> !</p>
<h3><img class=\"alignright  wp-image-7421\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-theme-switcher-300x230.png\" alt=\"4.2-theme-switcher-300x230\" width=\"198\" height=\"152\" />Changez de thème dans l’outil de personnalisation</h3>
<p>Parcourez et prévisualisez vos thèmes installés avec l’outil de personnalisation. Assurez-vous que ce thème est adapté à <em>votre</em> contenu avant de l’activer sur votre site.</p>
<h3><img class=\"  wp-image-7422 alignleft\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-embeds-300x230.png\" alt=\"4.2-embeds-300x230\" width=\"198\" height=\"152\" />Encore plus contenus insérés</h3>
<p>Collez des liens vers Tumblr.com ou Kickstarter, et vous les verrez apparaître comme par magie directement dans l’éditeur. À chaque nouvelle version, votre approche de la publication et de la rédaction sont de plus en plus proches.</p>
<h3><img class=\"alignright  wp-image-7423\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-plugins-300x230.png\" alt=\"4.2-plugins-300x230\" width=\"203\" height=\"156\" />Mises à jour simplifiée des extensions</h3>
<p>Adieu, triste écran de chargement ; bienvenue aux mises à jour d’extensions simples et sans bavure ! Cliquez sur <em>Mettre à jour maintenant</em> et laissez la magie s’opérer.</p>
<h3>Sous le capot</h3>
<div class=\"feature-section col two-col\">
<div>
<h4>Prise en charge du codage utf8mb4</h4>
<p>Le codage de caractères de la base de données est passé de utf8 à utf8mb4, ce qui ajoute la possibilité d’utiliser tout un jeu de nouveaux caractères encodés sur 4 octets.</p>
<h4>Accessibilité de JavaScript</h4>
<p>Vous pouvez maintenant envoyer des notifications sonores aux lecteurs d&rsquo;écran avec JavaScript grâce à <code>wp.a11y.speak()</code>. Passez une chaîne en argument, et une mise à jour sera envoyée à une zone de notification ARIA en temps réel. Un système de lecture de chaine est utilisé, et en envoie une mise à jour à un espace dédié de notifications ARIA live.</p>
</div>
<div class=\"last-feature\">
<h4>Séparation des termes partagés</h4>
<p>Les termes partagés entre plusieurs taxinomies seront dissociés les uns des autres lorsque l’un d’entre eux est mis à jour. Pour en savoir plus, rendez-vous sur la page du <a href=\"https://developer.wordpress.org/plugins/taxonomy/working-with-split-terms-in-wp-4-2/\">Manuel du développeur d’extensions</a> (en anglais).</p>
<h4>Ordonnancement complexe des requêtes</h4>
<p><code>WP_Query</code>, <code>WP_Comment_Query</code> et <code>WP_User_Query</code> peuvent maintenant utiliser un ordre complexe avec les clauses nommées des requêtes méta.</p>
<h3>L&rsquo;équipe</h3>
<p>Le chef de projet de cette version était Drew Jaynes, avec l&rsquo;aide de plus de 283 contributeurs &#8212; un nouveau record ! Ils sont tous listés sur l&rsquo;<a href=\"https://wordpress.org/news/2015/04/powell/\">article original</a> (dont cet article est une traduction).</p>
<p><em>À noter pour la version française : le mot &laquo;&nbsp;tag&nbsp;&raquo; n&rsquo;est plus traduit par &laquo;&nbsp;mot-clé&nbsp;&raquo;, mais par &laquo;&nbsp;étiquette&nbsp;&raquo; !</em></p>
</div>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7rIEKuN8IbY:kosmtwYYAp4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7rIEKuN8IbY:kosmtwYYAp4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/7rIEKuN8IbY\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/6SJgIbh9aFk\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/7rIEKuN8IbY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/nhFl_mTTaWE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6597:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/nhFl_mTTaWE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/KJsEy-lwkw0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3044:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/KJsEy-lwkw0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/Nxk3eqWFjXU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3658:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/Nxk3eqWFjXU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/odATT589tL4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3638:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/odATT589tL4\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/TbIvObIyepg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3888:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/TbIvObIyepg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/A_tvnBn7-wc/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9052:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/A_tvnBn7-wc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/d4xirCr8u6U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4899:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/d4xirCr8u6U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/FwIaDMiQ8vo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5443:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/FwIaDMiQ8vo\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/dpw1jMQN_tw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2589:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/dpw1jMQN_tw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:15:\"feedburner/cjgl\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:18:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:96:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:21:\"Subscribe with Feedly\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:80:\"http://feedly.com/#subscription/feed/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:42:\"http://s3.feedly.com/feedburner/feedly.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:72:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:95:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:34:\"Subscribe with The Free Dictionary\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:103:\"http://www.thefreedictionary.com/_/hp/AddRSS.aspx?http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://img.tfd.com/hp/addToTheFreeDictionary.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:28:\"Subscribe with Bitty Browser\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:115:\"http://www.bitty.com/manual/?contenttype=rssfeed&contentvalue=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://www.bitty.com/img/bittychicklet_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:16;a:5:{s:4:\"data\";s:28:\"Subscribe with Podcast Ready\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:107:\"http://www.podcastready.com/oneclick_bookmark.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:58:\"http://www.podcastready.com/images/podcastready_button.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:17;a:5:{s:4:\"data\";s:29:\"Subscribe with Daily Rotation\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"http://www.dailyrotation.com/index.php?feed=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:40:\"http://www.dailyrotation.com/rss-dr2.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:43:\"http://feeds.feedburner.com/feedburner/cjgL\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Sat, 25 Apr 2015 22:27:55 GMT\";s:4:\"date\";s:29:\"Sat, 25 Apr 2015 22:28:32 GMT\";s:7:\"expires\";s:29:\"Sat, 25 Apr 2015 22:28:32 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:11:\"80:quic,p=1\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20150417135034\";}","no");
INSERT INTO `wp_options` VALUES("114268","updraft_encryptionphrase","","yes");
INSERT INTO `wp_options` VALUES("114269","updraft_service","ftp","yes");
INSERT INTO `wp_options` VALUES("114270","updraft_s3","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114271","updraft_ftp","a:4:{s:4:\"host\";s:22:\"ftp.cluster003.ovh.net\";s:4:\"user\";s:7:\"pigiste\";s:4:\"pass\";s:9:\"piges2014\";s:4:\"path\";s:36:\"48heures_sauvegardes/dev/UpdraftPlus\";}","yes");
INSERT INTO `wp_options` VALUES("114274","updraft_cloudfiles","a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114275","updraft_bitcasa","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114276","updraft_copycom","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114277","updraft_openstack","a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114278","updraft_googledrive","a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}","yes");
INSERT INTO `wp_options` VALUES("114279","updraft_sftp_settings","","yes");
INSERT INTO `wp_options` VALUES("114280","updraft_webdav_settings","","yes");
INSERT INTO `wp_options` VALUES("114281","updraft_ssl_nossl","0","yes");
INSERT INTO `wp_options` VALUES("114282","updraft_log_syslog","0","yes");
INSERT INTO `wp_options` VALUES("114283","updraft_ssl_useservercerts","0","yes");
INSERT INTO `wp_options` VALUES("114284","updraft_ssl_disableverify","0","yes");
INSERT INTO `wp_options` VALUES("480","_bbp_edit_lock","5","yes");
INSERT INTO `wp_options` VALUES("481","_bbp_throttle_time","10","yes");
INSERT INTO `wp_options` VALUES("482","_bbp_allow_anonymous","0","yes");
INSERT INTO `wp_options` VALUES("483","_bbp_allow_global_access","1","yes");
INSERT INTO `wp_options` VALUES("484","_bbp_default_role","bbp_participant","yes");
INSERT INTO `wp_options` VALUES("485","_bbp_allow_revisions","1","yes");
INSERT INTO `wp_options` VALUES("486","_bbp_enable_favorites","1","yes");
INSERT INTO `wp_options` VALUES("487","_bbp_enable_subscriptions","1","yes");
INSERT INTO `wp_options` VALUES("488","_bbp_allow_topic_tags","1","yes");
INSERT INTO `wp_options` VALUES("489","_bbp_allow_search","1","yes");
INSERT INTO `wp_options` VALUES("490","_bbp_use_wp_editor","1","yes");
INSERT INTO `wp_options` VALUES("491","_bbp_use_autoembed","1","yes");
INSERT INTO `wp_options` VALUES("492","_bbp_thread_replies_depth","2","yes");
INSERT INTO `wp_options` VALUES("493","_bbp_allow_threaded_replies","0","yes");
INSERT INTO `wp_options` VALUES("494","_bbp_topics_per_page","15","yes");
INSERT INTO `wp_options` VALUES("495","_bbp_replies_per_page","15","yes");
INSERT INTO `wp_options` VALUES("496","_bbp_topics_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("497","_bbp_replies_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("498","_bbp_root_slug","base","yes");
INSERT INTO `wp_options` VALUES("499","_bbp_include_root","1","yes");
INSERT INTO `wp_options` VALUES("500","_bbp_show_on_root","forums","yes");
INSERT INTO `wp_options` VALUES("147","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("861","widget_newsletterwidget","a:2:{i:2;a:2:{s:5:\"title\";s:36:\"Inscrivez vous à notre newsletter !\";s:4:\"text\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99276","newsletter_diagnostic_cron_calls","a:300:{i:0;i:1429617436;i:1;i:1429617728;i:2;i:1429618025;i:3;i:1429618331;i:4;i:1429618625;i:5;i:1429618931;i:6;i:1429619116;i:7;i:1429619236;i:8;i:1429619531;i:9;i:1429619835;i:10;i:1429620131;i:11;i:1429620425;i:12;i:1429620730;i:13;i:1429621036;i:14;i:1429621328;i:15;i:1429621643;i:16;i:1429621922;i:17;i:1429622232;i:18;i:1429622251;i:19;i:1429622531;i:20;i:1429622712;i:21;i:1429622833;i:22;i:1429623124;i:23;i:1429623426;i:24;i:1429623727;i:25;i:1429623772;i:26;i:1429623794;i:27;i:1429624027;i:28;i:1429624327;i:29;i:1429624622;i:30;i:1429624933;i:31;i:1429625001;i:32;i:1429625225;i:33;i:1429625522;i:34;i:1429625824;i:35;i:1429626125;i:36;i:1429626297;i:37;i:1429626425;i:38;i:1429626441;i:39;i:1429626728;i:40;i:1429627022;i:41;i:1429627322;i:42;i:1429627393;i:43;i:1429627623;i:44;i:1429627927;i:45;i:1429628233;i:46;i:1429628527;i:47;i:1429628827;i:48;i:1429629127;i:49;i:1429629428;i:50;i:1429629764;i:51;i:1429629908;i:52;i:1429630028;i:53;i:1429630038;i:54;i:1429630388;i:55;i:1429630628;i:56;i:1429630937;i:57;i:1429630998;i:58;i:1429631223;i:59;i:1429631533;i:60;i:1429631837;i:61;i:1429632124;i:62;i:1429632424;i:63;i:1429632722;i:64;i:1429633025;i:65;i:1429633323;i:66;i:1429633504;i:67;i:1429633624;i:68;i:1429633644;i:69;i:1429633923;i:70;i:1429634244;i:71;i:1429634538;i:72;i:1429634844;i:73;i:1429635126;i:74;i:1429635422;i:75;i:1429635732;i:76;i:1429636044;i:77;i:1429636324;i:78;i:1429636628;i:79;i:1429636922;i:80;i:1429636923;i:81;i:1429637099;i:82;i:1429637244;i:83;i:1429637539;i:84;i:1429637825;i:85;i:1429638149;i:86;i:1429638435;i:87;i:1429638734;i:88;i:1429639038;i:89;i:1429639325;i:90;i:1429639666;i:91;i:1429639925;i:92;i:1429640266;i:93;i:1429640525;i:94;i:1429640746;i:95;i:1429640866;i:96;i:1429641106;i:97;i:1429641125;i:98;i:1429641431;i:99;i:1429641726;i:100;i:1429642066;i:101;i:1429642326;i:102;i:1429642672;i:103;i:1429642972;i:104;i:1429643270;i:105;i:1429643522;i:106;i:1429643832;i:107;i:1429644122;i:108;i:1429644301;i:109;i:1429644422;i:110;i:1429644440;i:111;i:1429644739;i:112;i:1429645042;i:113;i:1429645339;i:114;i:1429645644;i:115;i:1429645939;i:116;i:1429646222;i:117;i:1429646527;i:118;i:1429646822;i:119;i:1429647139;i:120;i:1429647422;i:121;i:1429647739;i:122;i:1429647901;i:123;i:1429648022;i:124;i:1429648099;i:125;i:1429648332;i:126;i:1429648622;i:127;i:1429648939;i:128;i:1429649222;i:129;i:1429649539;i:130;i:1429649822;i:131;i:1429649941;i:132;i:1429650016;i:133;i:1429650061;i:134;i:1429650139;i:135;i:1429650422;i:136;i:1429650737;i:137;i:1429651022;i:138;i:1429651339;i:139;i:1429651502;i:140;i:1429651622;i:141;i:1429651661;i:142;i:1429651939;i:143;i:1429652222;i:144;i:1429652539;i:145;i:1429652822;i:146;i:1429653139;i:147;i:1429653422;i:148;i:1429653735;i:149;i:1429654022;i:150;i:1429654336;i:151;i:1429654626;i:152;i:1429683582;i:153;i:1429683582;i:154;i:1429683815;i:155;i:1429683935;i:156;i:1429684055;i:157;i:1429684295;i:158;i:1429684325;i:159;i:1429684640;i:160;i:1429684935;i:161;i:1429685227;i:162;i:1429685623;i:163;i:1429685863;i:164;i:1429686223;i:165;i:1429686472;i:166;i:1429686753;i:167;i:1429687072;i:168;i:1429687432;i:169;i:1429687552;i:170;i:1429687672;i:171;i:1429688016;i:172;i:1429688272;i:173;i:1429688632;i:174;i:1429688858;i:175;i:1429689232;i:176;i:1429689472;i:177;i:1429689832;i:178;i:1429690073;i:179;i:1429690433;i:180;i:1429690681;i:181;i:1429690963;i:182;i:1429691115;i:183;i:1429691297;i:184;i:1429691537;i:185;i:1429691898;i:186;i:1429692138;i:187;i:1429692498;i:188;i:1429692738;i:189;i:1429693068;i:190;i:1429693338;i:191;i:1429693458;i:192;i:1429693698;i:193;i:1429693938;i:194;i:1429694298;i:195;i:1429694538;i:196;i:1429694752;i:197;i:1429695173;i:198;i:1429695594;i:199;i:1429696015;i:200;i:1429696436;i:201;i:1429696857;i:202;i:1429697010;i:203;i:1429697265;i:204;i:1429697626;i:205;i:1429697866;i:206;i:1429698227;i:207;i:1429698346;i:208;i:1429698466;i:209;i:1429698791;i:210;i:1429699031;i:211;i:1429699389;i:212;i:1429699631;i:213;i:1429699991;i:214;i:1429700225;i:215;i:1429700826;i:216;i:1429701191;i:217;i:1429701431;i:218;i:1429701792;i:219;i:1429701910;i:220;i:1429702033;i:221;i:1429702330;i:222;i:1429702753;i:223;i:1429703172;i:224;i:1429703593;i:225;i:1429704014;i:226;i:1429704435;i:227;i:1429704856;i:228;i:1429705277;i:229;i:1429705655;i:230;i:1429706143;i:231;i:1429706540;i:232;i:1429706920;i:233;i:1429707151;i:234;i:1429707440;i:235;i:1429707784;i:236;i:1429708224;i:237;i:1429708397;i:238;i:1429708645;i:239;i:1429710156;i:240;i:1429710310;i:241;i:1429710648;i:242;i:1429710939;i:243;i:1429711273;i:244;i:1429711326;i:245;i:1429711397;i:246;i:1429722067;i:247;i:1429724008;i:248;i:1429730179;i:249;i:1429731104;i:250;i:1429734564;i:251;i:1429735197;i:252;i:1429735415;i:253;i:1429744634;i:254;i:1429752928;i:255;i:1429768121;i:256;i:1429769042;i:257;i:1429769646;i:258;i:1429777287;i:259;i:1429777554;i:260;i:1429777767;i:261;i:1429785520;i:262;i:1429791299;i:263;i:1429799815;i:264;i:1429820790;i:265;i:1429825274;i:266;i:1429941026;i:267;i:1429941162;i:268;i:1429941953;i:269;i:1429942168;i:270;i:1429945040;i:271;i:1429945040;i:272;i:1429945343;i:273;i:1429949445;i:274;i:1429949567;i:275;i:1429950831;i:276;i:1429953677;i:277;i:1429953738;i:278;i:1429957744;i:279;i:1429957959;i:280;i:1429958584;i:281;i:1429958584;i:282;i:1429959062;i:283;i:1429959345;i:284;i:1429962114;i:285;i:1429962177;i:286;i:1429979031;i:287;i:1430000435;i:288;i:1430000900;i:289;i:1430033579;i:290;i:1430036509;i:291;i:1430037498;i:292;i:1430037925;i:293;i:1430038346;i:294;i:1430038767;i:295;i:1430039117;i:296;i:1430039241;i:297;i:1430039529;i:298;i:1430039830;i:299;i:1430039832;}","no");
INSERT INTO `wp_options` VALUES("99285","wpmm_settings","a:3:{s:7:\"general\";a:10:{s:6:\"status\";i:1;s:11:\"bypass_bots\";i:0;s:12:\"backend_role\";s:13:\"administrator\";s:13:\"frontend_role\";s:13:\"administrator\";s:11:\"meta_robots\";i:0;s:11:\"redirection\";s:0:\"\";s:7:\"exclude\";a:3:{i:0;s:4:\"feed\";i:1;s:8:\"wp-login\";i:2;s:5:\"login\";}s:6:\"notice\";i:1;s:10:\"admin_link\";i:0;s:11:\"status_date\";s:19:\"2015-04-02 07:34:45\";}s:6:\"design\";a:10:{s:5:\"title\";s:16:\"Mode Maintenance\";s:7:\"heading\";s:16:\"Mode Maintenance\";s:13:\"heading_color\";s:7:\"#ffffff\";s:4:\"text\";s:223:\"<p>Le site des 48h de la Pige fait peau neuve pour son édition 2015 qui se tiendra les 2 et 3 juillet à Strasbourg.</p>
<p>Très bientôt, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !</p>\";s:10:\"text_color\";s:7:\"#1e73be\";s:7:\"bg_type\";s:10:\"predefined\";s:8:\"bg_color\";s:0:\"\";s:9:\"bg_custom\";s:0:\"\";s:13:\"bg_predefined\";s:7:\"bg4.jpg\";s:10:\"custom_css\";a:3:{s:13:\"heading_color\";s:28:\".wrap h1 { color: #ffffff; }\";s:10:\"text_color\";s:28:\".wrap h2 { color: #1e73be; }\";s:6:\"bg_url\";s:183:\".background { background: url(http://dev48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }\";}}s:7:\"modules\";a:22:{s:16:\"countdown_status\";i:0;s:15:\"countdown_start\";s:19:\"2015-03-30 11:34:16\";s:17:\"countdown_details\";a:3:{s:4:\"days\";s:2:\"10\";s:5:\"hours\";s:1:\"1\";s:7:\"minutes\";s:1:\"0\";}s:15:\"countdown_color\";s:0:\"\";s:16:\"subscribe_status\";i:0;s:14:\"subscribe_text\";s:30:\"Me notifier quand c\\\'est prêt\";s:20:\"subscribe_text_color\";s:0:\"\";s:13:\"social_status\";i:0;s:13:\"social_target\";i:1;s:13:\"social_github\";s:0:\"\";s:15:\"social_dribbble\";s:0:\"\";s:14:\"social_twitter\";s:0:\"\";s:15:\"social_facebook\";s:0:\"\";s:16:\"social_pinterest\";s:0:\"\";s:14:\"social_google+\";s:0:\"\";s:15:\"social_linkedin\";s:0:\"\";s:14:\"contact_status\";i:0;s:13:\"contact_email\";s:17:\"max.twa@gmail.com\";s:15:\"contact_effects\";s:20:\"move_top|move_bottom\";s:9:\"ga_status\";i:0;s:7:\"ga_code\";s:0:\"\";s:10:\"custom_css\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("167","widget_akismet_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("129","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1398350987;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("130","current_theme","evolve","yes");
INSERT INTO `wp_options` VALUES("131","theme_mods_enfold","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:5:\"avia3\";i:33;s:4:\"avia\";i:33;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1429621341;s:4:\"data\";a:12:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:1:{i:0;s:12:\"qtranslate-2\";}s:9:\"sidebar-6\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:9:\"sidebar-7\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:1:{i:0;s:18:\"avia_google_maps-5\";}s:10:\"sidebar-10\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("132","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("133","enfold_layerslider_activated","1","yes");
INSERT INTO `wp_options` VALUES("134","shop_catalog_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("135","shop_single_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("136","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("137","avia_woocommerce_column_count","3","yes");
INSERT INTO `wp_options` VALUES("138","avia_woocommerce_product_count","15","yes");
INSERT INTO `wp_options` VALUES("139","woocommerce_single_image_crop","no","yes");
INSERT INTO `wp_options` VALUES("142","enfold_woo_settings_enabled","1","yes");
INSERT INTO `wp_options` VALUES("143","avia_options_enfold","a:1:{s:4:\"avia\";a:94:{s:17:\"avia-nonce-import\";s:10:\"947b4125f1\";s:9:\"frontpage\";s:3:\"734\";s:9:\"undefined\";s:32:\"header_setting::{contains}social\";s:8:\"blogpage\";s:0:\"\";s:4:\"logo\";s:72:\"http://dev48h.pigiste.org/wp-content/uploads/2013/04/48hbyPP-300x158.png\";s:7:\"favicon\";s:67:\"http://dev48h.pigiste.org/wp-content/uploads/2013/04/favicon-01.png\";s:9:\"analytics\";s:0:\"\";s:12:\"color_scheme\";s:11:\"Black-White\";s:14:\"google_webfont\";s:17:\"Open Sans:400,600\";s:12:\"default_font\";s:17:\"Open Sans:400,600\";s:16:\"color-body_style\";s:9:\"stretched\";s:16:\"color-body_color\";s:7:\"#333333\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#1bbce9\";s:31:\"colorset-header_color-secondary\";s:7:\"#1bbce9\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#000000\";s:29:\"colorset-main_color-secondary\";s:7:\"#666666\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#111111\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#222222\";s:32:\"colorset-alternate_color-primary\";s:7:\"#000000\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#bdbdbd\";s:30:\"colorset-alternate_color-color\";s:7:\"#888888\";s:31:\"colorset-alternate_color-border\";s:7:\"#333333\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#000000\";s:25:\"colorset-footer_color-bg2\";s:7:\"#222222\";s:29:\"colorset-footer_color-primary\";s:7:\"#aaaaaa\";s:31:\"colorset-footer_color-secondary\";s:7:\"#ffffff\";s:27:\"colorset-footer_color-color\";s:7:\"#aaaaaa\";s:28:\"colorset-footer_color-border\";s:7:\"#555555\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:13:\"center center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#333333\";s:25:\"colorset-socket_color-bg2\";s:7:\"#000000\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#eeeeee\";s:27:\"colorset-socket_color-color\";s:7:\"#eeeeee\";s:28:\"colorset-socket_color-border\";s:7:\"#333333\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:9:\"quick_css\";s:8:\"[nolink]\";s:17:\"responsive_layout\";s:10:\"responsive\";s:15:\"websave_windows\";s:6:\"active\";s:10:\"blog_style\";s:10:\"single-big\";s:17:\"single_post_style\";s:10:\"single-big\";s:15:\"iconfont_upload\";s:0:\"\";s:14:\"header_setting\";s:12:\"fixed_header\";s:5:\"phone\";s:0:\"\";s:12:\"social_icons\";a:4:{i:0;a:2:{s:11:\"social_icon\";s:8:\"facebook\";s:16:\"social_icon_link\";s:34:\"https://www.facebook.com/kriesi.at\";}i:1;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:1:\"#\";}i:2;a:2:{s:11:\"social_icon\";s:5:\"skype\";s:16:\"social_icon_link\";s:0:\"\";}i:3;a:2:{s:11:\"social_icon\";s:4:\"mail\";s:16:\"social_icon_link\";s:0:\"\";}}s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:11:\"header_menu\";s:16:\"mobile_drop_down\";s:14:\"archive_layout\";s:8:\"fullsize\";s:11:\"blog_layout\";s:8:\"fullsize\";s:13:\"single_layout\";s:8:\"fullsize\";s:11:\"page_layout\";s:8:\"fullsize\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:8:\"disabled\";s:22:\"display_widgets_socket\";s:15:\"nofooterwidgets\";s:14:\"footer_columns\";s:1:\"2\";s:9:\"copyright\";s:89:\"&copy; Les 48h de la pige 2014 - Un &eacute;v&eacute;nement Profession : Pigiste [nolink]\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("202","avia_permalink_settings","a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}","yes");
INSERT INTO `wp_options` VALUES("204","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("145","avia_stylesheet_dir_writableenfold","true","yes");
INSERT INTO `wp_options` VALUES("146","avia_stylesheet_existsenfold","true","yes");
INSERT INTO `wp_options` VALUES("169","widget_bbp_views_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("170","widget_bbp_search_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("171","widget_bbp_forums_widget","a:3:{i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:6:\"Forums\";s:12:\"parent_forum\";s:3:\"any\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("172","widget_bbp_topics_widget","a:3:{i:1;a:0:{}i:2;a:6:{s:5:\"title\";s:15:\"Sujets récents\";s:8:\"order_by\";s:7:\"newness\";s:12:\"parent_forum\";s:3:\"any\";s:9:\"show_date\";b:0;s:9:\"show_user\";b:0;s:9:\"max_shown\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("173","widget_bbp_replies_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("174","widget_bbp_stats_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("194","shop_order_status_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114419","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("254","portfolio_entries_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("193","product_cat_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("203","avia_rewrite_flush","1","yes");
INSERT INTO `wp_options` VALUES("212","gmw_options","a:4:{s:13:\"first_version\";s:4:\"1.60\";s:13:\"first_install\";i:1398358539;s:13:\"last_tracking\";i:1429824396;s:14:\"allow_tracking\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("213","widget_googlemapswidget","a:2:{i:2;a:22:{s:5:\"title\";s:47:\"Rendez-vous au campus Albert Londres à Vichy !\";s:7:\"address\";s:43:\"Pôle technologique et universitaire, Vichy\";s:15:\"thumb_pin_color\";s:4:\"gray\";s:14:\"thumb_pin_size\";s:7:\"default\";s:11:\"thumb_width\";i:500;s:12:\"thumb_height\";i:300;s:10:\"thumb_zoom\";s:2:\"13\";s:10:\"thumb_type\";s:7:\"roadmap\";s:15:\"thumb_link_type\";s:8:\"lightbox\";s:10:\"thumb_link\";s:0:\"\";s:12:\"thumb_header\";s:0:\"\";s:12:\"thumb_footer\";s:0:\"\";s:16:\"thumb_new_colors\";b:1;s:14:\"lightbox_width\";i:600;s:15:\"lightbox_height\";i:400;s:13:\"lightbox_type\";s:1:\"m\";s:13:\"lightbox_zoom\";s:2:\"14\";s:15:\"lightbox_bubble\";b:1;s:14:\"lightbox_title\";b:0;s:15:\"lightbox_header\";s:0:\"\";s:15:\"lightbox_footer\";s:0:\"\";s:13:\"lightbox_skin\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("599","newsletter_main_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("600","newsletter","a:26:{s:12:\"profile_text\";s:104:\"{profile_form}<p>To cancel your subscription, <a href=\'{unsubscription_confirm_url}\'>click here</a>.</p>\";s:10:\"error_text\";s:173:\"<p>This subscription can\'t be completed, sorry. The email address is blocked or already subscribed. You should contact the owner to unlock that email address. Thank you.</p>\";s:22:\"already_confirmed_text\";s:99:\"<p>This email address is already subscribed, anyway a welcome email has been resent. Thank you.</p>\";s:18:\"subscribe_wp_users\";s:1:\"0\";s:17:\"subscription_text\";s:19:\"{subscription_form}\";s:17:\"confirmation_text\";s:167:\"<p>Votre demande d\'inscription est enregistr&eacute;e. Merci ! Un e-mail de confirmation vous a été envoyé. V&eacute;rifier &eacute;galement votre dossier spam.</p>\";s:20:\"confirmation_subject\";s:66:\"Inscription &agrave; la lettre d&prime;information de {blog_title}\";s:20:\"confirmation_message\";s:517:\"<p>Bonjour {name}!</p>
<p>Vous recevez cet e-mail car nous avons enregistr&eacute; une demande d&prime;inscription &agrave; la lettre d&prime;infrmation de {blog_title}.
Merci de confirmer votre inscription en cliquant sur le lien suivant : <a href=\"{subscription_confirm_url}\"><strong>je confirme mon inscription.</strong></a>.
Si le lien ne fonctionne pas, merci d\'utiliser cette adresse :</p>
<p>{subscription_confirm_url}</p>
<p>Ignorez ce message si vous n\'avez pas effectué de demande.</p>
<p>Merci !</p>\";s:14:\"confirmed_text\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:17:\"confirmed_subject\";s:17:\"Bienvenue, {name}\";s:17:\"confirmed_message\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:19:\"unsubscription_text\";s:160:\"<p>&Ecirc;tes-vous certain de vouloir vous d&eacute;sinscrire de la lettre d&prime;information de {blog_title} ? <a href=\"{unsubscription_confirm_url}\">Oui</a>.\";s:17:\"unsubscribed_text\";s:153:\"<p>Vous n&prime;&ecirc;tes plus abonn&eacute; &agrave; la lettre d\'information de {blog_title}. Merci de nous avoir suivi et &agrave; bient&ocirc;t !</p>\";s:20:\"unsubscribed_subject\";s:18:\"Au revoir {name} !\";s:20:\"unsubscribed_message\";s:108:\"<p>Cet email confirme votre désinscription à notre newsletter<br>
<a href=\'{blog_url}\'>{blog_url}</a></p>\";s:14:\"noconfirmation\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:8:\"novisual\";s:1:\"0\";s:6:\"notify\";s:1:\"0\";s:12:\"notify_email\";s:0:\"\";s:16:\"confirmation_url\";s:0:\"\";s:13:\"confirmed_url\";s:0:\"\";s:18:\"confirmed_tracking\";s:0:\"\";s:13:\"profile_saved\";s:0:\"\";s:24:\"subscribe_wp_users_label\";s:0:\"\";s:10:\"wp_welcome\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("214","avia_sidebars","a:5:{i:0;s:10:\"Google Map\";i:1;s:10:\"Live Tweet\";i:2;s:7:\"Contact\";i:3;s:11:\"Login forum\";i:4;s:13:\"Recent topics\";}","yes");
INSERT INTO `wp_options` VALUES("262","widget_oauth_twitter_widget","a:3:{i:2;a:12:{s:4:\"user\";s:6:\"pigist\";s:5:\"count\";s:0:\"\";s:11:\"widgetTitle\";s:0:\"\";s:12:\"widgetFooter\";s:0:\"\";s:16:\"oAuthAccessToken\";s:0:\"\";s:22:\"oAuthAccessTokenSecret\";s:0:\"\";s:11:\"consumerKey\";s:0:\"\";s:14:\"consumerSecret\";s:0:\"\";s:17:\"showTwitterIconTF\";b:0;s:16:\"showProfilePicTF\";b:0;s:15:\"showTweetTimeTF\";b:0;s:16:\"includeRepliesTF\";b:0;}i:3;a:12:{s:4:\"user\";s:0:\"\";s:5:\"count\";s:0:\"\";s:11:\"widgetTitle\";s:0:\"\";s:12:\"widgetFooter\";s:0:\"\";s:16:\"oAuthAccessToken\";s:0:\"\";s:22:\"oAuthAccessTokenSecret\";s:0:\"\";s:11:\"consumerKey\";s:0:\"\";s:14:\"consumerSecret\";s:0:\"\";s:17:\"showTwitterIconTF\";b:0;s:16:\"showProfilePicTF\";b:0;s:15:\"showTweetTimeTF\";b:0;s:16:\"includeRepliesTF\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99286","wpmm_version","2.0.3","yes");
INSERT INTO `wp_options` VALUES("114265","updraft_interval_increments","","yes");
INSERT INTO `wp_options` VALUES("114266","updraft_retain","8","yes");
INSERT INTO `wp_options` VALUES("114267","updraft_retain_db","20","yes");
INSERT INTO `wp_options` VALUES("597","newsletter_logger_secret","5180c642","yes");
INSERT INTO `wp_options` VALUES("598","newsletter_main","a:20:{s:12:\"sender_email\";s:26:\"newsletter@48h.pigiste.org\";s:11:\"sender_name\";s:18:\"Les 48h de la pige\";s:11:\"return_path\";N;s:8:\"reply_to\";s:23:\"raphaelbaldos@gmail.com\";s:12:\"contract_key\";s:0:\"\";s:13:\"scheduler_max\";s:3:\"100\";s:6:\"editor\";s:1:\"0\";s:7:\"api_key\";s:10:\"186aecbfd3\";s:3:\"css\";s:0:\"\";s:25:\"content_transfer_encoding\";s:0:\"\";s:12:\"smtp_enabled\";s:1:\"0\";s:9:\"smtp_host\";s:0:\"\";s:9:\"smtp_port\";s:0:\"\";s:11:\"smtp_secure\";s:0:\"\";s:9:\"smtp_user\";s:0:\"\";s:9:\"smtp_pass\";s:0:\"\";s:15:\"smtp_test_email\";s:0:\"\";s:8:\"lock_ids\";s:0:\"\";s:8:\"lock_url\";s:0:\"\";s:12:\"lock_message\";s:107:\"This content is protected, only newsletter subscribers can access it. Subscribe now!

{subscription_form}\";}","yes");
INSERT INTO `wp_options` VALUES("602","newsletter_subscription_version","1.1.3","yes");
INSERT INTO `wp_options` VALUES("603","newsletter_emails","a:12:{s:5:\"theme\";s:10:\"vimeo-like\";s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("604","newsletter_emails_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("605","newsletter_emails_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("606","newsletter_users","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("607","newsletter_users_version","1.0.4","yes");
INSERT INTO `wp_options` VALUES("608","newsletter_statistics","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("609","newsletter_statistics_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("610","newsletter_feed","a:2:{s:5:\"theme\";s:7:\"default\";s:12:\"subscription\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("611","newsletter_feed_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("612","newsletter_feed_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("601","newsletter_profile","a:61:{s:5:\"email\";s:5:\"Email\";s:11:\"email_error\";s:24:\"The email is not correct\";s:4:\"name\";s:4:\"Name\";s:10:\"name_error\";s:23:\"The name is not correct\";s:11:\"name_status\";i:0;s:10:\"name_rules\";i:0;s:7:\"surname\";s:9:\"Last name\";s:13:\"surname_error\";s:28:\"The last name is not correct\";s:14:\"surname_status\";i:0;s:3:\"sex\";s:3:\"I\'m\";s:7:\"privacy\";s:51:\"Subscribing I accept the privacy rules of this site\";s:13:\"privacy_error\";s:37:\"You must accept the privacy statement\";s:14:\"privacy_status\";i:0;s:9:\"subscribe\";s:9:\"Subscribe\";s:4:\"save\";s:4:\"Save\";s:12:\"title_female\";s:4:\"Mrs.\";s:10:\"title_male\";s:3:\"Mr.\";s:10:\"title_none\";s:4:\"Dear\";s:8:\"sex_male\";s:3:\"Man\";s:10:\"sex_female\";s:5:\"Woman\";s:8:\"sex_none\";s:4:\"None\";s:13:\"list_1_status\";i:0;s:13:\"list_2_status\";i:0;s:13:\"list_3_status\";i:0;s:13:\"list_4_status\";i:0;s:13:\"list_5_status\";i:0;s:13:\"list_6_status\";i:0;s:13:\"list_7_status\";i:0;s:13:\"list_8_status\";i:0;s:13:\"list_9_status\";i:0;s:14:\"list_10_status\";i:0;s:14:\"list_11_status\";i:0;s:14:\"list_12_status\";i:0;s:14:\"list_13_status\";i:0;s:14:\"list_14_status\";i:0;s:14:\"list_15_status\";i:0;s:14:\"list_16_status\";i:0;s:14:\"list_17_status\";i:0;s:14:\"list_18_status\";i:0;s:14:\"list_19_status\";i:0;s:14:\"list_20_status\";i:0;s:16:\"profile_1_status\";i:0;s:16:\"profile_2_status\";i:0;s:16:\"profile_3_status\";i:0;s:16:\"profile_4_status\";i:0;s:16:\"profile_5_status\";i:0;s:16:\"profile_6_status\";i:0;s:16:\"profile_7_status\";i:0;s:16:\"profile_8_status\";i:0;s:16:\"profile_9_status\";i:0;s:17:\"profile_10_status\";i:0;s:17:\"profile_11_status\";i:0;s:17:\"profile_12_status\";i:0;s:17:\"profile_13_status\";i:0;s:17:\"profile_14_status\";i:0;s:17:\"profile_15_status\";i:0;s:17:\"profile_16_status\";i:0;s:17:\"profile_17_status\";i:0;s:17:\"profile_18_status\";i:0;s:17:\"profile_19_status\";i:0;s:17:\"profile_20_status\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("624","newsletter_emails_theme_vimeo-like","a:11:{s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("617","newsletter_feed_available_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("616","newsletter_reports_available_version","1.0.7","yes");
INSERT INTO `wp_options` VALUES("618","newsletter_followup_available_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("619","newsletter_facebook_available_version","1.1.3","yes");
INSERT INTO `wp_options` VALUES("620","newsletter_sendgrid_available_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("621","newsletter_popup_available_version","1.0.5","yes");
INSERT INTO `wp_options` VALUES("622","newsletter_mandrill_available_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("623","newsletter_mailjet_available_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("919","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"admin48@pigiste.org\";s:7:\"version\";s:5:\"4.1.2\";s:9:\"timestamp\";i:1429631010;}","yes");
INSERT INTO `wp_options` VALUES("114264","updraft_interval_database","daily","yes");
INSERT INTO `wp_options` VALUES("114263","updraft_interval","daily","yes");
INSERT INTO `wp_options` VALUES("99262","WPLANG","fr_FR","yes");
INSERT INTO `wp_options` VALUES("114247","updraft_dropbox","a:5:{s:6:\"appkey\";N;s:6:\"secret\";N;s:6:\"folder\";N;s:16:\"tk_request_token\";N;s:15:\"tk_access_token\";N;}","yes");
INSERT INTO `wp_options` VALUES("114273","updraft_s3generic","a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("115399","lwa_notice","1","yes");
INSERT INTO `wp_options` VALUES("115060","cookie_notice_options","a:13:{s:8:\"position\";s:3:\"top\";s:12:\"message_text\";s:198:\"Nous utilisons des cookies pour vous garantir la meilleure expérience sur notre site. Si vous continuez à utiliser ce dernier, nous considérerons que vous acceptez l&#039;utilisation des cookies.\";s:9:\"css_style\";s:9:\"bootstrap\";s:11:\"accept_text\";s:2:\"Ok\";s:8:\"see_more\";s:2:\"no\";s:11:\"link_target\";s:6:\"_blank\";s:4:\"time\";s:5:\"month\";s:11:\"hide_effect\";s:4:\"fade\";s:6:\"colors\";a:2:{s:4:\"text\";s:4:\"#fff\";s:3:\"bar\";s:4:\"#000\";}s:12:\"see_more_opt\";a:4:{s:4:\"text\";s:14:\"En savoir plus\";s:9:\"link_type\";s:6:\"custom\";s:2:\"id\";s:5:\"empty\";s:4:\"link\";s:0:\"\";}s:16:\"script_placement\";s:6:\"header\";s:9:\"translate\";b:0;s:19:\"deactivation_delete\";s:2:\"no\";}","no");
INSERT INTO `wp_options` VALUES("115061","cookie_notice_version","1.2.21","no");
INSERT INTO `wp_options` VALUES("115063","wp-optimize-schedule","false","no");
INSERT INTO `wp_options` VALUES("115064","wp-optimize-last-optimized","Never","no");
INSERT INTO `wp_options` VALUES("115065","wp-optimize-schedule-type","wpo_weekly","no");
INSERT INTO `wp_options` VALUES("115066","wp-optimize-retention-enabled","false","no");
INSERT INTO `wp_options` VALUES("115067","wp-optimize-retention-period","2","no");
INSERT INTO `wp_options` VALUES("115068","wp-optimize-enable-admin-menu","false","no");
INSERT INTO `wp_options` VALUES("115069","wp-optimize-email","true","no");
INSERT INTO `wp_options` VALUES("115070","wp-optimize-total-cleaned","0","no");
INSERT INTO `wp_options` VALUES("115071","wp-optimize-auto","a:8:{s:9:\"revisions\";s:4:\"true\";s:6:\"drafts\";s:4:\"true\";s:5:\"spams\";s:4:\"true\";s:10:\"unapproved\";s:5:\"false\";s:9:\"transient\";s:5:\"false\";s:8:\"postmeta\";s:5:\"false\";s:4:\"tags\";s:5:\"false\";s:8:\"optimize\";s:4:\"true\";}","yes");
INSERT INTO `wp_options` VALUES("115072","wp-optimize-settings","a:6:{s:14:\"user-revisions\";s:4:\"true\";s:11:\"user-drafts\";s:4:\"true\";s:10:\"user-spams\";s:4:\"true\";s:15:\"user-unapproved\";s:4:\"true\";s:14:\"user-transient\";s:5:\"false\";s:13:\"user-optimize\";s:4:\"true\";}","yes");
INSERT INTO `wp_options` VALUES("125052","_smart_ifw_options","a:3:{s:9:\"switch_fa\";s:2:\"on\";s:10:\"switch_cdn\";s:2:\"on\";s:9:\"icon_code\";s:9:\"smarticon\";}","yes");
INSERT INTO `wp_options` VALUES("115403","tadv_settings","a:6:{s:7:\"options\";s:15:\"menubar,advlist\";s:9:\"toolbar_1\";s:117:\"bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,unlink,table,fullscreen,undo,redo,wp_adv\";s:9:\"toolbar_2\";s:121:\"formatselect,alignjustify,strikethrough,outdent,indent,pastetext,removeformat,charmap,wp_more,emoticons,forecolor,wp_help\";s:9:\"toolbar_3\";s:0:\"\";s:9:\"toolbar_4\";s:0:\"\";s:7:\"plugins\";s:107:\"anchor,code,insertdatetime,nonbreaking,print,searchreplace,table,visualblocks,visualchars,emoticons,advlist\";}","yes");
INSERT INTO `wp_options` VALUES("115404","tadv_admin_settings","a:1:{s:7:\"options\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("115405","tadv_version","4000","yes");
INSERT INTO `wp_options` VALUES("115074","dbem_events_page","19726","yes");
INSERT INTO `wp_options` VALUES("115075","dbem_locations_page","19727","yes");
INSERT INTO `wp_options` VALUES("115076","dbem_categories_page","19728","yes");
INSERT INTO `wp_options` VALUES("115077","dbem_tags_page","19729","yes");
INSERT INTO `wp_options` VALUES("115078","dbem_my_bookings_page","19730","yes");
INSERT INTO `wp_options` VALUES("115079","dbem_hello_to_user","0","yes");
INSERT INTO `wp_options` VALUES("115080","dbem_time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("115081","dbem_date_format","d/m/Y","yes");
INSERT INTO `wp_options` VALUES("115082","dbem_date_format_js","dd/mm/yy","yes");
INSERT INTO `wp_options` VALUES("115083","dbem_dates_separator"," - ","yes");
INSERT INTO `wp_options` VALUES("115084","dbem_times_separator"," - ","yes");
INSERT INTO `wp_options` VALUES("115085","dbem_default_category","0","yes");
INSERT INTO `wp_options` VALUES("115086","dbem_default_location","0","yes");
INSERT INTO `wp_options` VALUES("115087","dbem_events_default_orderby","event_start_date,event_start_time,event_name","yes");
INSERT INTO `wp_options` VALUES("115088","dbem_events_default_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115089","dbem_events_default_limit","10","yes");
INSERT INTO `wp_options` VALUES("115090","dbem_search_form_submit","Recherche","yes");
INSERT INTO `wp_options` VALUES("115091","dbem_search_form_advanced","1","yes");
INSERT INTO `wp_options` VALUES("115092","dbem_search_form_advanced_hidden","1","yes");
INSERT INTO `wp_options` VALUES("115093","dbem_search_form_advanced_show","Afficher la recherche avancée","yes");
INSERT INTO `wp_options` VALUES("115094","dbem_search_form_advanced_hide","Cacher la recherche avancée","yes");
INSERT INTO `wp_options` VALUES("115095","dbem_search_form_text","1","yes");
INSERT INTO `wp_options` VALUES("115096","dbem_search_form_text_label","Recherche","yes");
INSERT INTO `wp_options` VALUES("115097","dbem_search_form_geo","1","yes");
INSERT INTO `wp_options` VALUES("115098","dbem_search_form_geo_label","Proche de ...","yes");
INSERT INTO `wp_options` VALUES("115099","dbem_search_form_geo_units","1","yes");
INSERT INTO `wp_options` VALUES("115100","dbem_search_form_geo_units_label","a l\'intérieur de","yes");
INSERT INTO `wp_options` VALUES("115101","dbem_search_form_geo_unit_default","mi","yes");
INSERT INTO `wp_options` VALUES("115102","dbem_search_form_geo_distance_default","25","yes");
INSERT INTO `wp_options` VALUES("115103","dbem_search_form_geo_distance_options","5,10,25,50,100","yes");
INSERT INTO `wp_options` VALUES("115104","dbem_search_form_dates","1","yes");
INSERT INTO `wp_options` VALUES("115105","dbem_search_form_dates_label","Dates","yes");
INSERT INTO `wp_options` VALUES("115106","dbem_search_form_dates_separator","et","yes");
INSERT INTO `wp_options` VALUES("115107","dbem_search_form_categories","1","yes");
INSERT INTO `wp_options` VALUES("115108","dbem_search_form_categories_label","Toutes les catégories","yes");
INSERT INTO `wp_options` VALUES("115109","dbem_search_form_category_label","Catégorie","yes");
INSERT INTO `wp_options` VALUES("115110","dbem_search_form_countries","1","yes");
INSERT INTO `wp_options` VALUES("115111","dbem_search_form_default_country","","yes");
INSERT INTO `wp_options` VALUES("115112","dbem_search_form_countries_label","Tous les pays","yes");
INSERT INTO `wp_options` VALUES("115113","dbem_search_form_country_label","Pays","yes");
INSERT INTO `wp_options` VALUES("115114","dbem_search_form_regions","1","yes");
INSERT INTO `wp_options` VALUES("115115","dbem_search_form_regions_label","Toutes les régions","yes");
INSERT INTO `wp_options` VALUES("115116","dbem_search_form_region_label","Région","yes");
INSERT INTO `wp_options` VALUES("115117","dbem_search_form_states","1","yes");
INSERT INTO `wp_options` VALUES("115118","dbem_search_form_states_label","Tous les états / départements","yes");
INSERT INTO `wp_options` VALUES("115119","dbem_search_form_state_label","État/Pays","yes");
INSERT INTO `wp_options` VALUES("115120","dbem_search_form_towns","0","yes");
INSERT INTO `wp_options` VALUES("115121","dbem_search_form_towns_label","Toutes les villes / cités","yes");
INSERT INTO `wp_options` VALUES("115122","dbem_search_form_town_label","Ville","yes");
INSERT INTO `wp_options` VALUES("115123","dbem_events_form_editor","1","yes");
INSERT INTO `wp_options` VALUES("115124","dbem_events_form_reshow","1","yes");
INSERT INTO `wp_options` VALUES("115125","dbem_events_form_result_success","Vous avez soumis votre événement, celui-ci sera publié après approbation.","yes");
INSERT INTO `wp_options` VALUES("115126","dbem_events_form_result_success_updated","Vous avez mis à jour votre événement, celui-ci sera republié après approbation.","yes");
INSERT INTO `wp_options` VALUES("115127","dbem_events_anonymous_submissions","0","yes");
INSERT INTO `wp_options` VALUES("115128","dbem_events_anonymous_user","0","yes");
INSERT INTO `wp_options` VALUES("115129","dbem_events_anonymous_result_success","Vous avez soumis votre événement, celui-ci sera publié après approbation.","yes");
INSERT INTO `wp_options` VALUES("115130","dbem_event_submitted_email_admin","","yes");
INSERT INTO `wp_options` VALUES("115131","dbem_event_submitted_email_subject","Événement en attente d\'approbation","yes");
INSERT INTO `wp_options` VALUES("115132","dbem_event_submitted_email_body","Un nouvel événement vient d\'être soumis par #_CONTACTNAME.

Nom : #_EVENTNAME 

Date : #_EVENTDATES 

Heure : #_EVENTTIMES 

Veuillez visiter la page http://dev48h.pigiste.org/wp-admin/post.php?action=edit&post=#_EVENTPOSTID pour valider cet événement.


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115133","dbem_event_resubmitted_email_subject","Événement resoumis en attente d\'approbation","yes");
INSERT INTO `wp_options` VALUES("115134","dbem_event_resubmitted_email_body","Un événement déjà publié vient d\'être modifié par #_CONTACTNAME. et cet événement n\'est plus en ligne, il attend votre validation.<br /> Nom : #_EVENTNAME 

Date : #_EVENTDATES 

Heure : #_EVENTTIMES 

Veuillez visiter la page http://dev48h.pigiste.org/wp-admin/post.php?action=edit&post=#_EVENTPOSTID pour valider cet événement.


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115135","dbem_event_published_email_subject","Soumettre - #_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115136","dbem_event_published_email_body","Un nouvel événement vient d\'être publié par #_CONTACTNAME.

Nom : #_EVENTNAME 

Date : #_EVENTDATES 

Heure : #_EVENTTIMES 

Veuillez visiter la page http://dev48h.pigiste.org/wp-admin/post.php?action=edit&post=#_EVENTPOSTID pour valider cet événement.


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115137","dbem_event_approved_email_subject","Événement approuvé - #_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115138","dbem_event_approved_email_body","Cher/chère #_CONTACTNAME, 

Votre événement #_EVENTNAME le #_EVENTDATES a été approuvé.

Vous pouvez visualiser votre événement ici : #_EVENTURL


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115139","dbem_event_reapproved_email_subject","Événement approuvé - #_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115140","dbem_event_reapproved_email_body","Cher/chère #_CONTACTNAME, 

Votre événement #_EVENTNAME le #_EVENTDATES a été approuvé.

Vous pouvez visualiser votre événement ici : #_EVENTURL


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115141","dbem_events_page_title","Événements","yes");
INSERT INTO `wp_options` VALUES("115142","dbem_events_page_scope","future","yes");
INSERT INTO `wp_options` VALUES("115143","dbem_events_page_search_form","1","yes");
INSERT INTO `wp_options` VALUES("115144","dbem_event_list_item_format_header","<table cellpadding=\"0\" cellspacing=\"0\" class=\"events-table\" >
    <thead>
        <tr>
			<th class=\"event-time\" width=\"150\">Date / Heure</th>
			<th class=\"event-description\" width=\"*\">Événement</th>
		</tr>
   	</thead>
    <tbody>","yes");
INSERT INTO `wp_options` VALUES("115145","dbem_event_list_item_format","<tr>
			<td>
                #_EVENTDATES<br/>
                #_EVENTTIMES
            </td>
            <td>
                #_EVENTLINK
                {has_location}<br/><i>#_LOCATIONNAME, #_LOCATIONTOWN #_LOCATIONSTATE</i>{/has_location}
            </td>
        </tr>","yes");
INSERT INTO `wp_options` VALUES("115146","dbem_event_list_item_format_footer","</tbody></table>","yes");
INSERT INTO `wp_options` VALUES("115147","dbem_event_list_groupby","0","yes");
INSERT INTO `wp_options` VALUES("115148","dbem_event_list_groupby_format","","yes");
INSERT INTO `wp_options` VALUES("115149","dbem_event_list_groupby_header_format","<h2>#s</h2>","yes");
INSERT INTO `wp_options` VALUES("115150","dbem_display_calendar_in_events_page","0","yes");
INSERT INTO `wp_options` VALUES("115151","dbem_single_event_format","<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>
<p>
	<strong>Date / Heure</strong><br/>
	Date(s) - #_EVENTDATES<br /><i>#_EVENTTIMES</i>
</p>
{has_location}
<p>
	<strong>Emplacement</strong><br/>
	#_LOCATIONLINK
</p>
{/has_location}
<p>
	<strong>Catégories</strong>
	#_CATEGORIES
</p>
<br style=\"clear:both\" />
#_EVENTNOTES
{has_bookings}
<h3>Bookings</h3>
#_BOOKINGFORM
{/has_bookings}","yes");
INSERT INTO `wp_options` VALUES("115152","dbem_event_excerpt_format","#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT","yes");
INSERT INTO `wp_options` VALUES("115153","dbem_event_excerpt_alt_format","#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT{55}","yes");
INSERT INTO `wp_options` VALUES("115154","dbem_event_page_title_format","#_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115155","dbem_event_all_day_message","Toute la journée","yes");
INSERT INTO `wp_options` VALUES("115156","dbem_no_events_message","Pas de Événements","yes");
INSERT INTO `wp_options` VALUES("115157","dbem_locations_default_orderby","location_name","yes");
INSERT INTO `wp_options` VALUES("115158","dbem_locations_default_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115159","dbem_locations_default_limit","10","yes");
INSERT INTO `wp_options` VALUES("115160","dbem_locations_page_title","Événement Emplacements","yes");
INSERT INTO `wp_options` VALUES("115161","dbem_locations_page_search_form","1","yes");
INSERT INTO `wp_options` VALUES("115162","dbem_no_locations_message","Pas de Emplacements","yes");
INSERT INTO `wp_options` VALUES("115163","dbem_location_default_country","","yes");
INSERT INTO `wp_options` VALUES("115164","dbem_location_list_item_format_header","<ul class=\"em-locations-list\">","yes");
INSERT INTO `wp_options` VALUES("115165","dbem_location_list_item_format","<li>#_LOCATIONLINK<ul><li>#_LOCATIONFULLLINE</li></ul></li>","yes");
INSERT INTO `wp_options` VALUES("115166","dbem_location_list_item_format_footer","</ul>","yes");
INSERT INTO `wp_options` VALUES("115167","dbem_location_page_title_format","#_LOCATIONNAME","yes");
INSERT INTO `wp_options` VALUES("115168","dbem_single_location_format","<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>
<p>
	<strong>Adresse</strong><br/>
	#_LOCATIONADDRESS<br/>
	#_LOCATIONTOWN<br/>
	#_LOCATIONSTATE<br/>
	#_LOCATIONREGION<br/>
	#_LOCATIONPOSTCODE<br/>
	#_LOCATIONCOUNTRY
</p>
<br style=\"clear:both\" />
#_LOCATIONNOTES

<h3>Événements à venir</h3>
<p>#_LOCATIONNEXTEVENTS</p>","yes");
INSERT INTO `wp_options` VALUES("115169","dbem_location_excerpt_format","#_LOCATIONEXCERPT","yes");
INSERT INTO `wp_options` VALUES("115170","dbem_location_excerpt_alt_format","#_LOCATIONEXCERPT{55}","yes");
INSERT INTO `wp_options` VALUES("115171","dbem_location_no_events_message","<li>Aucun événement à cet emplacement</li>","yes");
INSERT INTO `wp_options` VALUES("115172","dbem_location_event_list_item_header_format","<ul>","yes");
INSERT INTO `wp_options` VALUES("115173","dbem_location_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes");
INSERT INTO `wp_options` VALUES("115174","dbem_location_event_list_item_footer_format","</ul>","yes");
INSERT INTO `wp_options` VALUES("115175","dbem_location_event_list_limit","20","yes");
INSERT INTO `wp_options` VALUES("115176","dbem_location_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes");
INSERT INTO `wp_options` VALUES("115177","dbem_location_no_event_message","Aucun événement à cet emplacement","yes");
INSERT INTO `wp_options` VALUES("115178","dbem_categories_default_limit","10","yes");
INSERT INTO `wp_options` VALUES("115179","dbem_categories_default_orderby","name","yes");
INSERT INTO `wp_options` VALUES("115180","dbem_categories_default_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115181","dbem_categories_list_item_format_header","<ul class=\"em-categories-list\">","yes");
INSERT INTO `wp_options` VALUES("115182","dbem_categories_list_item_format","<li>#_CATEGORYLINK</li>","yes");
INSERT INTO `wp_options` VALUES("115183","dbem_categories_list_item_format_footer","</ul>","yes");
INSERT INTO `wp_options` VALUES("115184","dbem_no_categories_message","Pas de Catégories","yes");
INSERT INTO `wp_options` VALUES("115185","dbem_category_page_title_format","#_CATEGORYNAME","yes");
INSERT INTO `wp_options` VALUES("115186","dbem_category_page_format","#_CATEGORYNOTES<h3>Événements à venir</h3>#_CATEGORYNEXTEVENTS","yes");
INSERT INTO `wp_options` VALUES("115187","dbem_category_no_events_message","<li>Aucun événement dans cette catégorie</li>","yes");
INSERT INTO `wp_options` VALUES("115188","dbem_category_event_list_item_header_format","<ul>","yes");
INSERT INTO `wp_options` VALUES("115189","dbem_category_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes");
INSERT INTO `wp_options` VALUES("115190","dbem_category_event_list_item_footer_format","</ul>","yes");
INSERT INTO `wp_options` VALUES("115191","dbem_category_event_list_limit","20","yes");
INSERT INTO `wp_options` VALUES("115192","dbem_category_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes");
INSERT INTO `wp_options` VALUES("115193","dbem_category_no_event_message","Aucun événement dans cette catégorie","yes");
INSERT INTO `wp_options` VALUES("115194","dbem_category_default_color","#a8d144","yes");
INSERT INTO `wp_options` VALUES("115195","dbem_tags_default_limit","10","yes");
INSERT INTO `wp_options` VALUES("115196","dbem_tags_default_orderby","name","yes");
INSERT INTO `wp_options` VALUES("115197","dbem_tags_default_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115198","dbem_tags_list_item_format_header","<ul class=\"em-tags-list\">","yes");
INSERT INTO `wp_options` VALUES("115199","dbem_tags_list_item_format","<li>#_TAGLINK</li>","yes");
INSERT INTO `wp_options` VALUES("115200","dbem_tags_list_item_format_footer","</ul>","yes");
INSERT INTO `wp_options` VALUES("115201","dbem_no_tags_message","Pas de Mots-clef","yes");
INSERT INTO `wp_options` VALUES("115202","dbem_tag_page_title_format","#_TAGNAME","yes");
INSERT INTO `wp_options` VALUES("115203","dbem_tag_page_format","<h3>Événements à venir</h3>#_TAGNEXTEVENTS","yes");
INSERT INTO `wp_options` VALUES("115204","dbem_tag_no_events_message","<li>Aucun événement dans cette catégorie</li>","yes");
INSERT INTO `wp_options` VALUES("115205","dbem_tag_event_list_item_header_format","<ul>","yes");
INSERT INTO `wp_options` VALUES("115206","dbem_tag_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes");
INSERT INTO `wp_options` VALUES("115207","dbem_tag_event_list_item_footer_format","</ul>","yes");
INSERT INTO `wp_options` VALUES("115208","dbem_tag_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes");
INSERT INTO `wp_options` VALUES("115209","dbem_tag_no_event_message","Aucun événement dans cette catégorie","yes");
INSERT INTO `wp_options` VALUES("115210","dbem_tag_event_list_limit","20","yes");
INSERT INTO `wp_options` VALUES("115211","dbem_rss_limit","0","yes");
INSERT INTO `wp_options` VALUES("115212","dbem_rss_scope","future","yes");
INSERT INTO `wp_options` VALUES("115213","dbem_rss_main_title","Les 48h de la pige - Événements","yes");
INSERT INTO `wp_options` VALUES("115214","dbem_rss_main_description","Un événement Profession : Pigiste - Événements","yes");
INSERT INTO `wp_options` VALUES("115215","dbem_rss_description_format","#_EVENTDATES - #_EVENTTIMES <br/>#_LOCATIONNAME <br/>#_LOCATIONADDRESS <br/>#_LOCATIONTOWN","yes");
INSERT INTO `wp_options` VALUES("115216","dbem_rss_title_format","#_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115217","dbem_rss_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115218","dbem_rss_orderby","event_start_date,event_start_time,event_name","yes");
INSERT INTO `wp_options` VALUES("115219","em_rss_pubdate","Fri, 17 Apr 2015 18:25:26 +0000","yes");
INSERT INTO `wp_options` VALUES("115220","dbem_ical_limit","0","yes");
INSERT INTO `wp_options` VALUES("115221","dbem_ical_scope","future","yes");
INSERT INTO `wp_options` VALUES("115222","dbem_ical_description_format","#_EVENTNAME - #_LOCATIONNAME - #_EVENTDATES - #_EVENTTIMES","yes");
INSERT INTO `wp_options` VALUES("115223","dbem_ical_real_description_format","#_EVENTEXCERPT","yes");
INSERT INTO `wp_options` VALUES("115224","dbem_ical_location_format","#_LOCATION","yes");
INSERT INTO `wp_options` VALUES("115225","dbem_gmap_is_active","1","yes");
INSERT INTO `wp_options` VALUES("115226","dbem_map_default_width","400px","yes");
INSERT INTO `wp_options` VALUES("115227","dbem_map_default_height","300px","yes");
INSERT INTO `wp_options` VALUES("115228","dbem_location_baloon_format","<strong>#_LOCATIONNAME</strong><br/>#_LOCATIONADDRESS - #_LOCATIONTOWN<br/><a href=\"#_LOCATIONPAGEURL\">Événements</a>","yes");
INSERT INTO `wp_options` VALUES("115229","dbem_map_text_format","<strong>#_LOCATIONNAME</strong><p>#_LOCATIONADDRESS</p><p>#_LOCATIONTOWN</p>","yes");
INSERT INTO `wp_options` VALUES("115230","dbem_email_disable_registration","0","yes");
INSERT INTO `wp_options` VALUES("115231","dbem_rsvp_mail_port","465","yes");
INSERT INTO `wp_options` VALUES("115232","dbem_smtp_host","localhost","yes");
INSERT INTO `wp_options` VALUES("115233","dbem_mail_sender_name","","yes");
INSERT INTO `wp_options` VALUES("115234","dbem_rsvp_mail_send_method","wp_mail","yes");
INSERT INTO `wp_options` VALUES("115235","dbem_rsvp_mail_SMTPAuth","1","yes");
INSERT INTO `wp_options` VALUES("115236","dbem_smtp_html","1","yes");
INSERT INTO `wp_options` VALUES("115237","dbem_smtp_html_br","1","yes");
INSERT INTO `wp_options` VALUES("115238","dbem_image_max_width","700","yes");
INSERT INTO `wp_options` VALUES("115239","dbem_image_max_height","700","yes");
INSERT INTO `wp_options` VALUES("115240","dbem_image_min_width","50","yes");
INSERT INTO `wp_options` VALUES("115241","dbem_image_min_height","50","yes");
INSERT INTO `wp_options` VALUES("115242","dbem_image_max_size","204800","yes");
INSERT INTO `wp_options` VALUES("115243","dbem_list_date_title","Événements - #j #M #y","yes");
INSERT INTO `wp_options` VALUES("115244","dbem_full_calendar_month_format","M Y","yes");
INSERT INTO `wp_options` VALUES("115245","dbem_full_calendar_event_format","<li>#_EVENTLINK</li>","yes");
INSERT INTO `wp_options` VALUES("115246","dbem_full_calendar_long_events","0","yes");
INSERT INTO `wp_options` VALUES("115247","dbem_full_calendar_initials_length","0","yes");
INSERT INTO `wp_options` VALUES("115248","dbem_full_calendar_abbreviated_weekdays","1","yes");
INSERT INTO `wp_options` VALUES("115249","dbem_display_calendar_day_single_yes","1","yes");
INSERT INTO `wp_options` VALUES("115250","dbem_small_calendar_month_format","M Y","yes");
INSERT INTO `wp_options` VALUES("115251","dbem_small_calendar_event_title_format","#_EVENTNAME","yes");
INSERT INTO `wp_options` VALUES("115252","dbem_small_calendar_event_title_separator",", ","yes");
INSERT INTO `wp_options` VALUES("115253","dbem_small_calendar_initials_length","1","yes");
INSERT INTO `wp_options` VALUES("115254","dbem_small_calendar_abbreviated_weekdays","","yes");
INSERT INTO `wp_options` VALUES("115255","dbem_display_calendar_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115256","dbem_display_calendar_orderby","event_name,event_start_time","yes");
INSERT INTO `wp_options` VALUES("115257","dbem_display_calendar_events_limit","3","yes");
INSERT INTO `wp_options` VALUES("115258","dbem_display_calendar_events_limit_msg","plus...","yes");
INSERT INTO `wp_options` VALUES("115259","dbem_calendar_direct_links","1","yes");
INSERT INTO `wp_options` VALUES("115260","dbem_require_location","0","yes");
INSERT INTO `wp_options` VALUES("115261","dbem_locations_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115262","dbem_use_select_for_locations","0","yes");
INSERT INTO `wp_options` VALUES("115263","dbem_attributes_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115264","dbem_recurrence_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115265","dbem_rsvp_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115266","dbem_categories_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115267","dbem_tags_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115268","dbem_placeholders_custom","","yes");
INSERT INTO `wp_options` VALUES("115269","dbem_location_attributes_enabled","1","yes");
INSERT INTO `wp_options` VALUES("115270","dbem_location_placeholders_custom","","yes");
INSERT INTO `wp_options` VALUES("115271","dbem_bookings_registration_disable","0","yes");
INSERT INTO `wp_options` VALUES("115272","dbem_bookings_registration_disable_user_emails","0","yes");
INSERT INTO `wp_options` VALUES("115273","dbem_bookings_registration_user","","yes");
INSERT INTO `wp_options` VALUES("115274","dbem_bookings_approval","1","yes");
INSERT INTO `wp_options` VALUES("115275","dbem_bookings_approval_reserved","0","yes");
INSERT INTO `wp_options` VALUES("115276","dbem_bookings_approval_overbooking","0","yes");
INSERT INTO `wp_options` VALUES("115277","dbem_bookings_double","0","yes");
INSERT INTO `wp_options` VALUES("115278","dbem_bookings_user_cancellation","1","yes");
INSERT INTO `wp_options` VALUES("115279","dbem_bookings_currency","USD","yes");
INSERT INTO `wp_options` VALUES("115280","dbem_bookings_currency_decimal_point",", ","yes");
INSERT INTO `wp_options` VALUES("115281","dbem_bookings_currency_thousands_sep"," ","yes");
INSERT INTO `wp_options` VALUES("115282","dbem_bookings_currency_format","@#","yes");
INSERT INTO `wp_options` VALUES("115283","dbem_bookings_tax","0","yes");
INSERT INTO `wp_options` VALUES("115284","dbem_bookings_tax_auto_add","0","yes");
INSERT INTO `wp_options` VALUES("115285","dbem_bookings_submit_button","Envoyer votre demande de réservation","yes");
INSERT INTO `wp_options` VALUES("115286","dbem_bookings_login_form","1","yes");
INSERT INTO `wp_options` VALUES("115287","dbem_bookings_anonymous","1","yes");
INSERT INTO `wp_options` VALUES("115288","dbem_bookings_form_max","20","yes");
INSERT INTO `wp_options` VALUES("115289","dbem_bookings_form_msg_disabled","Les réservations en ligne ne sont pas disponibles pour cet événement.","yes");
INSERT INTO `wp_options` VALUES("115290","dbem_bookings_form_msg_closed","Les réservations sont closes pour cet événement.","yes");
INSERT INTO `wp_options` VALUES("115291","dbem_bookings_form_msg_full","Cet événement est complet.","yes");
INSERT INTO `wp_options` VALUES("115292","dbem_bookings_form_msg_attending","Vous avez déjà effectué une réservation pour cet événement.","yes");
INSERT INTO `wp_options` VALUES("115293","dbem_bookings_form_msg_bookings_link","Gérer mes réservations","yes");
INSERT INTO `wp_options` VALUES("115294","dbem_booking_warning_cancel","Êtes-vous sûr de vouloir annuler votre réservation ?","yes");
INSERT INTO `wp_options` VALUES("115295","dbem_booking_feedback_cancelled","Réservation Annulé","yes");
INSERT INTO `wp_options` VALUES("115296","dbem_booking_feedback_pending","Réservation effectuée, en attente de confirmation (vous recevrez également un e-mail après confirmation).","yes");
INSERT INTO `wp_options` VALUES("115297","dbem_booking_feedback","Réservation effectuée.","yes");
INSERT INTO `wp_options` VALUES("115298","dbem_booking_feedback_full","La réservation ne peut être faite, plus de places disponibles !","yes");
INSERT INTO `wp_options` VALUES("115299","dbem_booking_feedback_log_in","Vous devez vous connecter ou vous enregistrer pour faire une réservation.","yes");
INSERT INTO `wp_options` VALUES("115300","dbem_booking_feedback_nomail","Cependant, des problèmes se sont produits lors de l\'envoi des e-mails de confirmation pour vous et / ou le point de contact de l\'événement. Vous pouvez le contacter directement.","yes");
INSERT INTO `wp_options` VALUES("115301","dbem_booking_feedback_error","La réservation n\'a pu être effectuée :","yes");
INSERT INTO `wp_options` VALUES("115302","dbem_booking_feedback_email_exists","Cette adresse e-mail existe déjà dans notre système, veuillez vous identifier avec votre compte pour procéder à votre réservation.","yes");
INSERT INTO `wp_options` VALUES("115303","dbem_booking_feedback_new_user","Un nouveau compte utilisateur a été créé pour vous. Veuillez consulter votre courrier électronique pour plus de détails concernant l\'accès à ce compte.","yes");
INSERT INTO `wp_options` VALUES("115304","dbem_booking_feedback_reg_error","Un problème s\'est produit lors de la création du compte utilisateur, veuillez contacter l\'administrateur du site.","yes");
INSERT INTO `wp_options` VALUES("115305","dbem_booking_feedback_already_booked","Vous avez déjà réservé une place à cet événement.","yes");
INSERT INTO `wp_options` VALUES("115306","dbem_booking_feedback_min_space","Vous devez demander au moins une place pour votre réservation.","yes");
INSERT INTO `wp_options` VALUES("115307","dbem_booking_feedback_spaces_limit","Vous ne pouvez pas réserver plus de %d places pour cet événement.","yes");
INSERT INTO `wp_options` VALUES("115308","dbem_booking_button_msg_book","Réservez maintenant","yes");
INSERT INTO `wp_options` VALUES("115309","dbem_booking_button_msg_booking","Réservation ...","yes");
INSERT INTO `wp_options` VALUES("115310","dbem_booking_button_msg_booked","Réservation soumis","yes");
INSERT INTO `wp_options` VALUES("115311","dbem_booking_button_msg_already_booked","Déjà réservé","yes");
INSERT INTO `wp_options` VALUES("115312","dbem_booking_button_msg_error","Réservation erreur. Réessayer?","yes");
INSERT INTO `wp_options` VALUES("115313","dbem_booking_button_msg_full","Complet","yes");
INSERT INTO `wp_options` VALUES("115314","dbem_booking_button_msg_cancel","Annuler","yes");
INSERT INTO `wp_options` VALUES("115315","dbem_booking_button_msg_canceling","Annuler...","yes");
INSERT INTO `wp_options` VALUES("115316","dbem_booking_button_msg_cancelled","Annulé","yes");
INSERT INTO `wp_options` VALUES("115317","dbem_booking_button_msg_cancel_error","Annulation erreur. Réessayer?","yes");
INSERT INTO `wp_options` VALUES("115318","dbem_bookings_notify_admin","0","yes");
INSERT INTO `wp_options` VALUES("115319","dbem_bookings_contact_email","1","yes");
INSERT INTO `wp_options` VALUES("115320","dbem_bookings_contact_email_pending_subject","Réservation en attente","yes");
INSERT INTO `wp_options` VALUES("115321","dbem_bookings_contact_email_pending_body","The following booking is en attente :

#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES

Now there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.

DéTAILS DE LA RéSERVATION

Nom : #_BOOKINGNAME
E-mail : #_BOOKINGEMAIL

#_BOOKINGSUMMARY


Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115322","dbem_bookings_contact_email_confirmed_subject","Réservation confirmée","yes");
INSERT INTO `wp_options` VALUES("115323","dbem_bookings_contact_email_confirmed_body","The following booking is confirmé :

#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES

Now there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.

DéTAILS DE LA RéSERVATION

Nom : #_BOOKINGNAME
E-mail : #_BOOKINGEMAIL

#_BOOKINGSUMMARY


Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115324","dbem_bookings_contact_email_rejected_subject","Réservation rejetée","yes");
INSERT INTO `wp_options` VALUES("115325","dbem_bookings_contact_email_rejected_body","The following booking is rejetée :

#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES

Now there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.

DéTAILS DE LA RéSERVATION

Nom : #_BOOKINGNAME
E-mail : #_BOOKINGEMAIL

#_BOOKINGSUMMARY


Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115326","dbem_bookings_contact_email_cancelled_subject","Réservation annulée","yes");
INSERT INTO `wp_options` VALUES("115327","dbem_bookings_contact_email_cancelled_body","The following booking is annulé :

#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES

Now there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.

DéTAILS DE LA RéSERVATION

Nom : #_BOOKINGNAME
E-mail : #_BOOKINGEMAIL

#_BOOKINGSUMMARY


Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115328","dbem_bookings_email_pending_subject","Réservation en attente","yes");
INSERT INTO `wp_options` VALUES("115329","dbem_bookings_email_pending_body","Cher/chère #_BOOKINGNAME,

Vous avez demandé à réserver #_BOOKINGSPACES place(s) pour #_EVENTNAME.

Quand : #_EVENTDATES à #_EVENTTIMES

Où : #_LOCATIONNAME - #_LOCATIONFULLLINE

Cette réservation est maintenant en attente d\'approbation par nos administrateurs : une fois approuvée vous recevrez un e-mail automatique de confirmation.

Cordialement,

#_CONTACTNAME


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115330","dbem_bookings_email_rejected_subject","Réservation rejetée","yes");
INSERT INTO `wp_options` VALUES("115331","dbem_bookings_email_rejected_body","Cher/chère #_BOOKINGNAME,


Votre réservation pour#_BOOKINGSPACES place(s) pour #_EVENTNAME le #_EVENTDATES a été rejetée. 

Cordialement,

#_CONTACTNAME


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115332","dbem_bookings_email_confirmed_subject","Réservation confirmée","yes");
INSERT INTO `wp_options` VALUES("115333","dbem_bookings_email_confirmed_body","Cher/chère #_BOOKINGNAME,

Vous avez réservé #_BOOKINGSPACES place(s) pour #_EVENTNAME.

Quand : #_EVENTDATES à #_EVENTTIMES

Où : #_LOCATIONNAME - #_LOCATIONFULLLINE

Cordialement,

#_CONTACTNAME


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115334","dbem_bookings_email_cancelled_subject","Réservation annulée","yes");
INSERT INTO `wp_options` VALUES("115335","dbem_bookings_email_cancelled_body","Cher/chère #_BOOKINGNAME,

Votre réservation de #_BOOKINGSPACES place(s) pour #_EVENTNAME le #_EVENTDATES a été annulée.

Cordialement,

#_CONTACTNAME


-------------------------------

Powered by Events Manager - http://wp-events-plugin.com","yes");
INSERT INTO `wp_options` VALUES("115336","dbem_bookings_email_registration_subject","[Les 48h de la pige] Vos nom d\'utilisateur et mot de passe","yes");
INSERT INTO `wp_options` VALUES("115337","dbem_bookings_email_registration_body","Vous avez créé un compte sur Les 48h de la pige

Vous pouvez vous connecter sur notre site ici : http://dev48h.pigiste.org/wp-login.php

Nom d\'Utilisateur : : %username%

Mot de passe : %password%

Pour voir vos réservations, merci de vous rendre ici http://dev48h.pigiste.org/evenements/mes-reservations/ après vous êtes connectés au site.","yes");
INSERT INTO `wp_options` VALUES("115338","dbem_bookings_tickets_orderby","ticket_price DESC, ticket_name ASC","yes");
INSERT INTO `wp_options` VALUES("115339","dbem_bookings_tickets_priority","0","yes");
INSERT INTO `wp_options` VALUES("115340","dbem_bookings_tickets_show_unavailable","0","yes");
INSERT INTO `wp_options` VALUES("115341","dbem_bookings_tickets_show_loggedout","1","yes");
INSERT INTO `wp_options` VALUES("115342","dbem_bookings_tickets_single","0","yes");
INSERT INTO `wp_options` VALUES("115343","dbem_bookings_tickets_single_form","0","yes");
INSERT INTO `wp_options` VALUES("115344","dbem_bookings_my_title_format","Mes réservations","yes");
INSERT INTO `wp_options` VALUES("115345","dbem_bp_events_list_format_header","<ul class=\"em-events-list\">","yes");
INSERT INTO `wp_options` VALUES("115346","dbem_bp_events_list_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES<ul><li>#_LOCATIONLINK - #_LOCATIONADDRESS, #_LOCATIONTOWN</li></ul></li>","yes");
INSERT INTO `wp_options` VALUES("115347","dbem_bp_events_list_format_footer","</ul>","yes");
INSERT INTO `wp_options` VALUES("115348","dbem_bp_events_list_none_format","<p class=\"em-events-list\">Aucun événement</p>","yes");
INSERT INTO `wp_options` VALUES("115349","dbem_css_editors","1","yes");
INSERT INTO `wp_options` VALUES("115350","dbem_css_rsvp","1","yes");
INSERT INTO `wp_options` VALUES("115351","dbem_css_rsvpadmin","1","yes");
INSERT INTO `wp_options` VALUES("115352","dbem_css_evlist","1","yes");
INSERT INTO `wp_options` VALUES("115353","dbem_css_search","1","yes");
INSERT INTO `wp_options` VALUES("115354","dbem_css_loclist","1","yes");
INSERT INTO `wp_options` VALUES("115355","dbem_css_catlist","1","yes");
INSERT INTO `wp_options` VALUES("115356","dbem_css_taglist","1","yes");
INSERT INTO `wp_options` VALUES("115357","dbem_cp_events_slug","events","yes");
INSERT INTO `wp_options` VALUES("115358","dbem_cp_locations_slug","locations","yes");
INSERT INTO `wp_options` VALUES("115359","dbem_taxonomy_category_slug","events/categories","yes");
INSERT INTO `wp_options` VALUES("115360","dbem_taxonomy_tag_slug","events/tags","yes");
INSERT INTO `wp_options` VALUES("115361","dbem_cp_events_template","","yes");
INSERT INTO `wp_options` VALUES("115362","dbem_cp_events_body_class","","yes");
INSERT INTO `wp_options` VALUES("115363","dbem_cp_events_post_class","","yes");
INSERT INTO `wp_options` VALUES("115364","dbem_cp_events_formats","1","yes");
INSERT INTO `wp_options` VALUES("115365","dbem_cp_events_has_archive","1","yes");
INSERT INTO `wp_options` VALUES("115366","dbem_events_default_archive_orderby","_start_ts","yes");
INSERT INTO `wp_options` VALUES("115367","dbem_events_default_archive_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115368","dbem_events_archive_scope","past","yes");
INSERT INTO `wp_options` VALUES("115369","dbem_cp_events_archive_formats","1","yes");
INSERT INTO `wp_options` VALUES("115370","dbem_cp_events_excerpt_formats","1","yes");
INSERT INTO `wp_options` VALUES("115371","dbem_cp_events_search_results","0","yes");
INSERT INTO `wp_options` VALUES("115372","dbem_cp_events_custom_fields","0","yes");
INSERT INTO `wp_options` VALUES("115373","dbem_cp_events_comments","1","yes");
INSERT INTO `wp_options` VALUES("115374","dbem_cp_locations_template","","yes");
INSERT INTO `wp_options` VALUES("115375","dbem_cp_locations_body_class","","yes");
INSERT INTO `wp_options` VALUES("115376","dbem_cp_locations_post_class","","yes");
INSERT INTO `wp_options` VALUES("115377","dbem_cp_locations_formats","1","yes");
INSERT INTO `wp_options` VALUES("115378","dbem_cp_locations_has_archive","1","yes");
INSERT INTO `wp_options` VALUES("115379","dbem_locations_default_archive_orderby","title","yes");
INSERT INTO `wp_options` VALUES("115380","dbem_locations_default_archive_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115381","dbem_cp_locations_archive_formats","1","yes");
INSERT INTO `wp_options` VALUES("115382","dbem_cp_locations_excerpt_formats","1","yes");
INSERT INTO `wp_options` VALUES("115383","dbem_cp_locations_search_results","0","yes");
INSERT INTO `wp_options` VALUES("115384","dbem_cp_locations_custom_fields","0","yes");
INSERT INTO `wp_options` VALUES("115385","dbem_cp_locations_comments","1","yes");
INSERT INTO `wp_options` VALUES("115386","dbem_cp_categories_formats","1","yes");
INSERT INTO `wp_options` VALUES("115387","dbem_categories_default_archive_orderby","event_start_date,event_start_time,event_name","yes");
INSERT INTO `wp_options` VALUES("115388","dbem_categories_default_archive_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115389","dbem_cp_tags_formats","1","yes");
INSERT INTO `wp_options` VALUES("115390","dbem_tags_default_archive_orderby","event_start_date,event_start_time,event_name","yes");
INSERT INTO `wp_options` VALUES("115391","dbem_tags_default_archive_order","ASC","yes");
INSERT INTO `wp_options` VALUES("115392","dbem_disable_thumbnails","","yes");
INSERT INTO `wp_options` VALUES("115393","dbem_feedback_reminder","1429295126","yes");
INSERT INTO `wp_options` VALUES("115394","dbem_credits","1","yes");
INSERT INTO `wp_options` VALUES("115395","dbem_time_24h","1","yes");
INSERT INTO `wp_options` VALUES("115396","dbem_version","5.55","yes");
INSERT INTO `wp_options` VALUES("117178","wpcf7","a:1:{s:7:\"version\";s:5:\"4.1.2\";}","yes");
INSERT INTO `wp_options` VALUES("118236","_site_transient_timeout_browser_48ce97d67f5c394f5ce1d5ccaf049307","1430231737","yes");
INSERT INTO `wp_options` VALUES("117183","redux-framework-tracking","a:3:{s:8:\"dev_mode\";b:0;s:4:\"hash\";s:32:\"e85e073c51d01641fc1417b0dc7a3fbc\";s:14:\"allow_tracking\";s:2:\"no\";}","yes");
INSERT INTO `wp_options` VALUES("117184","um_version","1.2.5","yes");
INSERT INTO `wp_options` VALUES("117185","um_cache_fonticons","a:1212:{i:0;s:13:\"um-icon-alert\";i:1;s:21:\"um-icon-alert-circled\";i:2;s:19:\"um-icon-android-add\";i:3;s:26:\"um-icon-android-add-circle\";i:4;s:27:\"um-icon-android-alarm-clock\";i:5;s:21:\"um-icon-android-alert\";i:6;s:20:\"um-icon-android-apps\";i:7;s:23:\"um-icon-android-archive\";i:8;s:26:\"um-icon-android-arrow-back\";i:9;s:26:\"um-icon-android-arrow-down\";i:10;s:30:\"um-icon-android-arrow-dropdown\";i:11;s:37:\"um-icon-android-arrow-dropdown-circle\";i:12;s:30:\"um-icon-android-arrow-dropleft\";i:13;s:37:\"um-icon-android-arrow-dropleft-circle\";i:14;s:31:\"um-icon-android-arrow-dropright\";i:15;s:38:\"um-icon-android-arrow-dropright-circle\";i:16;s:28:\"um-icon-android-arrow-dropup\";i:17;s:35:\"um-icon-android-arrow-dropup-circle\";i:18;s:29:\"um-icon-android-arrow-forward\";i:19;s:24:\"um-icon-android-arrow-up\";i:20;s:22:\"um-icon-android-attach\";i:21;s:19:\"um-icon-android-bar\";i:22;s:23:\"um-icon-android-bicycle\";i:23;s:20:\"um-icon-android-boat\";i:24;s:24:\"um-icon-android-bookmark\";i:25;s:20:\"um-icon-android-bulb\";i:26;s:19:\"um-icon-android-bus\";i:27;s:24:\"um-icon-android-calendar\";i:28;s:20:\"um-icon-android-call\";i:29;s:22:\"um-icon-android-camera\";i:30;s:22:\"um-icon-android-cancel\";i:31;s:19:\"um-icon-android-car\";i:32;s:20:\"um-icon-android-cart\";i:33;s:20:\"um-icon-android-chat\";i:34;s:24:\"um-icon-android-checkbox\";i:35;s:30:\"um-icon-android-checkbox-blank\";i:36;s:32:\"um-icon-android-checkbox-outline\";i:37;s:38:\"um-icon-android-checkbox-outline-blank\";i:38;s:32:\"um-icon-android-checkmark-circle\";i:39;s:25:\"um-icon-android-clipboard\";i:40;s:21:\"um-icon-android-close\";i:41;s:21:\"um-icon-android-cloud\";i:42;s:28:\"um-icon-android-cloud-circle\";i:43;s:26:\"um-icon-android-cloud-done\";i:44;s:29:\"um-icon-android-cloud-outline\";i:45;s:29:\"um-icon-android-color-palette\";i:46;s:23:\"um-icon-android-compass\";i:47;s:23:\"um-icon-android-contact\";i:48;s:24:\"um-icon-android-contacts\";i:49;s:24:\"um-icon-android-contract\";i:50;s:22:\"um-icon-android-create\";i:51;s:22:\"um-icon-android-delete\";i:52;s:23:\"um-icon-android-desktop\";i:53;s:24:\"um-icon-android-document\";i:54;s:20:\"um-icon-android-done\";i:55;s:24:\"um-icon-android-done-all\";i:56;s:24:\"um-icon-android-download\";i:57;s:22:\"um-icon-android-drafts\";i:58;s:20:\"um-icon-android-exit\";i:59;s:22:\"um-icon-android-expand\";i:60;s:24:\"um-icon-android-favorite\";i:61;s:32:\"um-icon-android-favorite-outline\";i:62;s:20:\"um-icon-android-film\";i:63;s:22:\"um-icon-android-folder\";i:64;s:27:\"um-icon-android-folder-open\";i:65;s:22:\"um-icon-android-funnel\";i:66;s:21:\"um-icon-android-globe\";i:67;s:20:\"um-icon-android-hand\";i:68;s:23:\"um-icon-android-hangout\";i:69;s:21:\"um-icon-android-happy\";i:70;s:20:\"um-icon-android-home\";i:71;s:21:\"um-icon-android-image\";i:72;s:22:\"um-icon-android-laptop\";i:73;s:20:\"um-icon-android-list\";i:74;s:22:\"um-icon-android-locate\";i:75;s:20:\"um-icon-android-lock\";i:76;s:20:\"um-icon-android-mail\";i:77;s:19:\"um-icon-android-map\";i:78;s:20:\"um-icon-android-menu\";i:79;s:26:\"um-icon-android-microphone\";i:80;s:30:\"um-icon-android-microphone-off\";i:81;s:31:\"um-icon-android-more-horizontal\";i:82;s:29:\"um-icon-android-more-vertical\";i:83;s:24:\"um-icon-android-navigate\";i:84;s:29:\"um-icon-android-notifications\";i:85;s:34:\"um-icon-android-notifications-none\";i:86;s:33:\"um-icon-android-notifications-off\";i:87;s:20:\"um-icon-android-open\";i:88;s:23:\"um-icon-android-options\";i:89;s:22:\"um-icon-android-people\";i:90;s:22:\"um-icon-android-person\";i:91;s:26:\"um-icon-android-person-add\";i:92;s:31:\"um-icon-android-phone-landscape\";i:93;s:30:\"um-icon-android-phone-portrait\";i:94;s:19:\"um-icon-android-pin\";i:95;s:21:\"um-icon-android-plane\";i:96;s:25:\"um-icon-android-playstore\";i:97;s:21:\"um-icon-android-print\";i:98;s:32:\"um-icon-android-radio-button-off\";i:99;s:31:\"um-icon-android-radio-button-on\";i:100;s:23:\"um-icon-android-refresh\";i:101;s:22:\"um-icon-android-remove\";i:102;s:29:\"um-icon-android-remove-circle\";i:103;s:26:\"um-icon-android-restaurant\";i:104;s:19:\"um-icon-android-sad\";i:105;s:22:\"um-icon-android-search\";i:106;s:20:\"um-icon-android-send\";i:107;s:24:\"um-icon-android-settings\";i:108;s:21:\"um-icon-android-share\";i:109;s:25:\"um-icon-android-share-alt\";i:110;s:20:\"um-icon-android-star\";i:111;s:25:\"um-icon-android-star-half\";i:112;s:28:\"um-icon-android-star-outline\";i:113;s:25:\"um-icon-android-stopwatch\";i:114;s:22:\"um-icon-android-subway\";i:115;s:21:\"um-icon-android-sunny\";i:116;s:20:\"um-icon-android-sync\";i:117;s:23:\"um-icon-android-textsms\";i:118;s:20:\"um-icon-android-time\";i:119;s:21:\"um-icon-android-train\";i:120;s:22:\"um-icon-android-unlock\";i:121;s:22:\"um-icon-android-upload\";i:122;s:27:\"um-icon-android-volume-down\";i:123;s:27:\"um-icon-android-volume-mute\";i:124;s:26:\"um-icon-android-volume-off\";i:125;s:25:\"um-icon-android-volume-up\";i:126;s:20:\"um-icon-android-walk\";i:127;s:23:\"um-icon-android-warning\";i:128;s:21:\"um-icon-android-watch\";i:129;s:20:\"um-icon-android-wifi\";i:130;s:16:\"um-icon-aperture\";i:131;s:15:\"um-icon-archive\";i:132;s:20:\"um-icon-arrow-down-a\";i:133;s:20:\"um-icon-arrow-down-b\";i:134;s:20:\"um-icon-arrow-down-c\";i:135;s:20:\"um-icon-arrow-expand\";i:136;s:29:\"um-icon-arrow-graph-down-left\";i:137;s:30:\"um-icon-arrow-graph-down-right\";i:138;s:27:\"um-icon-arrow-graph-up-left\";i:139;s:28:\"um-icon-arrow-graph-up-right\";i:140;s:20:\"um-icon-arrow-left-a\";i:141;s:20:\"um-icon-arrow-left-b\";i:142;s:20:\"um-icon-arrow-left-c\";i:143;s:18:\"um-icon-arrow-move\";i:144;s:20:\"um-icon-arrow-resize\";i:145;s:25:\"um-icon-arrow-return-left\";i:146;s:26:\"um-icon-arrow-return-right\";i:147;s:21:\"um-icon-arrow-right-a\";i:148;s:21:\"um-icon-arrow-right-b\";i:149;s:21:\"um-icon-arrow-right-c\";i:150;s:20:\"um-icon-arrow-shrink\";i:151;s:18:\"um-icon-arrow-swap\";i:152;s:18:\"um-icon-arrow-up-a\";i:153;s:18:\"um-icon-arrow-up-b\";i:154;s:18:\"um-icon-arrow-up-c\";i:155;s:16:\"um-icon-asterisk\";i:156;s:10:\"um-icon-at\";i:157;s:17:\"um-icon-backspace\";i:158;s:25:\"um-icon-backspace-outline\";i:159;s:11:\"um-icon-bag\";i:160;s:24:\"um-icon-battery-charging\";i:161;s:21:\"um-icon-battery-empty\";i:162;s:20:\"um-icon-battery-full\";i:163;s:20:\"um-icon-battery-half\";i:164;s:19:\"um-icon-battery-low\";i:165;s:14:\"um-icon-beaker\";i:166;s:12:\"um-icon-beer\";i:167;s:17:\"um-icon-bluetooth\";i:168;s:15:\"um-icon-bonfire\";i:169;s:16:\"um-icon-bookmark\";i:170;s:14:\"um-icon-bowtie\";i:171;s:17:\"um-icon-briefcase\";i:172;s:11:\"um-icon-bug\";i:173;s:18:\"um-icon-calculator\";i:174;s:16:\"um-icon-calendar\";i:175;s:14:\"um-icon-camera\";i:176;s:12:\"um-icon-card\";i:177;s:12:\"um-icon-cash\";i:178;s:15:\"um-icon-chatbox\";i:179;s:23:\"um-icon-chatbox-working\";i:180;s:17:\"um-icon-chatboxes\";i:181;s:18:\"um-icon-chatbubble\";i:182;s:26:\"um-icon-chatbubble-working\";i:183;s:19:\"um-icon-chatbubbles\";i:184;s:17:\"um-icon-checkmark\";i:185;s:25:\"um-icon-checkmark-circled\";i:186;s:23:\"um-icon-checkmark-round\";i:187;s:20:\"um-icon-chevron-down\";i:188;s:20:\"um-icon-chevron-left\";i:189;s:21:\"um-icon-chevron-right\";i:190;s:18:\"um-icon-chevron-up\";i:191;s:17:\"um-icon-clipboard\";i:192;s:13:\"um-icon-clock\";i:193;s:13:\"um-icon-close\";i:194;s:21:\"um-icon-close-circled\";i:195;s:19:\"um-icon-close-round\";i:196;s:25:\"um-icon-closed-captioning\";i:197;s:13:\"um-icon-cloud\";i:198;s:12:\"um-icon-code\";i:199;s:21:\"um-icon-code-download\";i:200;s:20:\"um-icon-code-working\";i:201;s:14:\"um-icon-coffee\";i:202;s:15:\"um-icon-compass\";i:203;s:15:\"um-icon-compose\";i:204;s:23:\"um-icon-connection-bars\";i:205;s:16:\"um-icon-contrast\";i:206;s:12:\"um-icon-crop\";i:207;s:12:\"um-icon-cube\";i:208;s:12:\"um-icon-disc\";i:209;s:16:\"um-icon-document\";i:210;s:21:\"um-icon-document-text\";i:211;s:12:\"um-icon-drag\";i:212;s:13:\"um-icon-earth\";i:213;s:13:\"um-icon-easel\";i:214;s:12:\"um-icon-edit\";i:215;s:11:\"um-icon-egg\";i:216;s:13:\"um-icon-eject\";i:217;s:13:\"um-icon-email\";i:218;s:20:\"um-icon-email-unread\";i:219;s:24:\"um-icon-erlenmeyer-flask\";i:220;s:32:\"um-icon-erlenmeyer-flask-bubbles\";i:221;s:11:\"um-icon-eye\";i:222;s:20:\"um-icon-eye-disabled\";i:223;s:14:\"um-icon-female\";i:224;s:14:\"um-icon-filing\";i:225;s:19:\"um-icon-film-marker\";i:226;s:16:\"um-icon-fireball\";i:227;s:12:\"um-icon-flag\";i:228;s:13:\"um-icon-flame\";i:229;s:13:\"um-icon-flash\";i:230;s:17:\"um-icon-flash-off\";i:231;s:14:\"um-icon-folder\";i:232;s:12:\"um-icon-fork\";i:233;s:17:\"um-icon-fork-repo\";i:234;s:15:\"um-icon-forward\";i:235;s:14:\"um-icon-funnel\";i:236;s:14:\"um-icon-gear-a\";i:237;s:14:\"um-icon-gear-b\";i:238;s:12:\"um-icon-grid\";i:239;s:14:\"um-icon-hammer\";i:240;s:13:\"um-icon-happy\";i:241;s:21:\"um-icon-happy-outline\";i:242;s:17:\"um-icon-headphone\";i:243;s:13:\"um-icon-heart\";i:244;s:20:\"um-icon-heart-broken\";i:245;s:12:\"um-icon-help\";i:246;s:17:\"um-icon-help-buoy\";i:247;s:20:\"um-icon-help-circled\";i:248;s:12:\"um-icon-home\";i:249;s:16:\"um-icon-icecream\";i:250;s:13:\"um-icon-image\";i:251;s:14:\"um-icon-images\";i:252;s:19:\"um-icon-information\";i:253;s:27:\"um-icon-information-circled\";i:254;s:13:\"um-icon-ionic\";i:255;s:17:\"um-icon-ios-alarm\";i:256;s:25:\"um-icon-ios-alarm-outline\";i:257;s:18:\"um-icon-ios-albums\";i:258;s:26:\"um-icon-ios-albums-outline\";i:259;s:28:\"um-icon-ios-americanfootball\";i:260;s:36:\"um-icon-ios-americanfootball-outline\";i:261;s:21:\"um-icon-ios-analytics\";i:262;s:29:\"um-icon-ios-analytics-outline\";i:263;s:22:\"um-icon-ios-arrow-back\";i:264;s:22:\"um-icon-ios-arrow-down\";i:265;s:25:\"um-icon-ios-arrow-forward\";i:266;s:22:\"um-icon-ios-arrow-left\";i:267;s:23:\"um-icon-ios-arrow-right\";i:268;s:27:\"um-icon-ios-arrow-thin-down\";i:269;s:27:\"um-icon-ios-arrow-thin-left\";i:270;s:28:\"um-icon-ios-arrow-thin-right\";i:271;s:25:\"um-icon-ios-arrow-thin-up\";i:272;s:20:\"um-icon-ios-arrow-up\";i:273;s:14:\"um-icon-ios-at\";i:274;s:22:\"um-icon-ios-at-outline\";i:275;s:19:\"um-icon-ios-barcode\";i:276;s:27:\"um-icon-ios-barcode-outline\";i:277;s:20:\"um-icon-ios-baseball\";i:278;s:28:\"um-icon-ios-baseball-outline\";i:279;s:22:\"um-icon-ios-basketball\";i:280;s:30:\"um-icon-ios-basketball-outline\";i:281;s:16:\"um-icon-ios-bell\";i:282;s:24:\"um-icon-ios-bell-outline\";i:283;s:16:\"um-icon-ios-body\";i:284;s:24:\"um-icon-ios-body-outline\";i:285;s:16:\"um-icon-ios-bolt\";i:286;s:24:\"um-icon-ios-bolt-outline\";i:287;s:16:\"um-icon-ios-book\";i:288;s:24:\"um-icon-ios-book-outline\";i:289;s:21:\"um-icon-ios-bookmarks\";i:290;s:29:\"um-icon-ios-bookmarks-outline\";i:291;s:15:\"um-icon-ios-box\";i:292;s:23:\"um-icon-ios-box-outline\";i:293;s:21:\"um-icon-ios-briefcase\";i:294;s:29:\"um-icon-ios-briefcase-outline\";i:295;s:20:\"um-icon-ios-browsers\";i:296;s:28:\"um-icon-ios-browsers-outline\";i:297;s:22:\"um-icon-ios-calculator\";i:298;s:30:\"um-icon-ios-calculator-outline\";i:299;s:20:\"um-icon-ios-calendar\";i:300;s:28:\"um-icon-ios-calendar-outline\";i:301;s:18:\"um-icon-ios-camera\";i:302;s:26:\"um-icon-ios-camera-outline\";i:303;s:16:\"um-icon-ios-cart\";i:304;s:24:\"um-icon-ios-cart-outline\";i:305;s:21:\"um-icon-ios-chatboxes\";i:306;s:29:\"um-icon-ios-chatboxes-outline\";i:307;s:22:\"um-icon-ios-chatbubble\";i:308;s:30:\"um-icon-ios-chatbubble-outline\";i:309;s:21:\"um-icon-ios-checkmark\";i:310;s:27:\"um-icon-ios-checkmark-empty\";i:311;s:29:\"um-icon-ios-checkmark-outline\";i:312;s:25:\"um-icon-ios-circle-filled\";i:313;s:26:\"um-icon-ios-circle-outline\";i:314;s:17:\"um-icon-ios-clock\";i:315;s:25:\"um-icon-ios-clock-outline\";i:316;s:17:\"um-icon-ios-close\";i:317;s:23:\"um-icon-ios-close-empty\";i:318;s:25:\"um-icon-ios-close-outline\";i:319;s:17:\"um-icon-ios-cloud\";i:320;s:26:\"um-icon-ios-cloud-download\";i:321;s:34:\"um-icon-ios-cloud-download-outline\";i:322;s:25:\"um-icon-ios-cloud-outline\";i:323;s:24:\"um-icon-ios-cloud-upload\";i:324;s:32:\"um-icon-ios-cloud-upload-outline\";i:325;s:18:\"um-icon-ios-cloudy\";i:326;s:24:\"um-icon-ios-cloudy-night\";i:327;s:32:\"um-icon-ios-cloudy-night-outline\";i:328;s:26:\"um-icon-ios-cloudy-outline\";i:329;s:15:\"um-icon-ios-cog\";i:330;s:23:\"um-icon-ios-cog-outline\";i:331;s:24:\"um-icon-ios-color-filter\";i:332;s:32:\"um-icon-ios-color-filter-outline\";i:333;s:22:\"um-icon-ios-color-wand\";i:334;s:30:\"um-icon-ios-color-wand-outline\";i:335;s:19:\"um-icon-ios-compose\";i:336;s:27:\"um-icon-ios-compose-outline\";i:337;s:19:\"um-icon-ios-contact\";i:338;s:27:\"um-icon-ios-contact-outline\";i:339;s:16:\"um-icon-ios-copy\";i:340;s:24:\"um-icon-ios-copy-outline\";i:341;s:16:\"um-icon-ios-crop\";i:342;s:23:\"um-icon-ios-crop-strong\";i:343;s:20:\"um-icon-ios-download\";i:344;s:28:\"um-icon-ios-download-outline\";i:345;s:16:\"um-icon-ios-drag\";i:346;s:17:\"um-icon-ios-email\";i:347;s:25:\"um-icon-ios-email-outline\";i:348;s:15:\"um-icon-ios-eye\";i:349;s:23:\"um-icon-ios-eye-outline\";i:350;s:23:\"um-icon-ios-fastforward\";i:351;s:31:\"um-icon-ios-fastforward-outline\";i:352;s:18:\"um-icon-ios-filing\";i:353;s:26:\"um-icon-ios-filing-outline\";i:354;s:16:\"um-icon-ios-film\";i:355;s:24:\"um-icon-ios-film-outline\";i:356;s:16:\"um-icon-ios-flag\";i:357;s:24:\"um-icon-ios-flag-outline\";i:358;s:17:\"um-icon-ios-flame\";i:359;s:25:\"um-icon-ios-flame-outline\";i:360;s:17:\"um-icon-ios-flask\";i:361;s:25:\"um-icon-ios-flask-outline\";i:362;s:18:\"um-icon-ios-flower\";i:363;s:26:\"um-icon-ios-flower-outline\";i:364;s:18:\"um-icon-ios-folder\";i:365;s:26:\"um-icon-ios-folder-outline\";i:366;s:20:\"um-icon-ios-football\";i:367;s:28:\"um-icon-ios-football-outline\";i:368;s:29:\"um-icon-ios-game-controller-a\";i:369;s:37:\"um-icon-ios-game-controller-a-outline\";i:370;s:29:\"um-icon-ios-game-controller-b\";i:371;s:37:\"um-icon-ios-game-controller-b-outline\";i:372;s:16:\"um-icon-ios-gear\";i:373;s:24:\"um-icon-ios-gear-outline\";i:374;s:19:\"um-icon-ios-glasses\";i:375;s:27:\"um-icon-ios-glasses-outline\";i:376;s:21:\"um-icon-ios-grid-view\";i:377;s:29:\"um-icon-ios-grid-view-outline\";i:378;s:17:\"um-icon-ios-heart\";i:379;s:25:\"um-icon-ios-heart-outline\";i:380;s:16:\"um-icon-ios-help\";i:381;s:22:\"um-icon-ios-help-empty\";i:382;s:24:\"um-icon-ios-help-outline\";i:383;s:16:\"um-icon-ios-home\";i:384;s:24:\"um-icon-ios-home-outline\";i:385;s:20:\"um-icon-ios-infinite\";i:386;s:28:\"um-icon-ios-infinite-outline\";i:387;s:23:\"um-icon-ios-information\";i:388;s:29:\"um-icon-ios-information-empty\";i:389;s:31:\"um-icon-ios-information-outline\";i:390;s:25:\"um-icon-ios-ionic-outline\";i:391;s:18:\"um-icon-ios-keypad\";i:392;s:26:\"um-icon-ios-keypad-outline\";i:393;s:21:\"um-icon-ios-lightbulb\";i:394;s:29:\"um-icon-ios-lightbulb-outline\";i:395;s:16:\"um-icon-ios-list\";i:396;s:24:\"um-icon-ios-list-outline\";i:397;s:20:\"um-icon-ios-location\";i:398;s:28:\"um-icon-ios-location-outline\";i:399;s:18:\"um-icon-ios-locked\";i:400;s:26:\"um-icon-ios-locked-outline\";i:401;s:16:\"um-icon-ios-loop\";i:402;s:23:\"um-icon-ios-loop-strong\";i:403;s:19:\"um-icon-ios-medical\";i:404;s:27:\"um-icon-ios-medical-outline\";i:405;s:18:\"um-icon-ios-medkit\";i:406;s:26:\"um-icon-ios-medkit-outline\";i:407;s:15:\"um-icon-ios-mic\";i:408;s:19:\"um-icon-ios-mic-off\";i:409;s:23:\"um-icon-ios-mic-outline\";i:410;s:17:\"um-icon-ios-minus\";i:411;s:23:\"um-icon-ios-minus-empty\";i:412;s:25:\"um-icon-ios-minus-outline\";i:413;s:19:\"um-icon-ios-monitor\";i:414;s:27:\"um-icon-ios-monitor-outline\";i:415;s:16:\"um-icon-ios-moon\";i:416;s:24:\"um-icon-ios-moon-outline\";i:417;s:16:\"um-icon-ios-more\";i:418;s:24:\"um-icon-ios-more-outline\";i:419;s:24:\"um-icon-ios-musical-note\";i:420;s:25:\"um-icon-ios-musical-notes\";i:421;s:20:\"um-icon-ios-navigate\";i:422;s:28:\"um-icon-ios-navigate-outline\";i:423;s:21:\"um-icon-ios-nutrition\";i:424;s:29:\"um-icon-ios-nutrition-outline\";i:425;s:17:\"um-icon-ios-paper\";i:426;s:25:\"um-icon-ios-paper-outline\";i:427;s:22:\"um-icon-ios-paperplane\";i:428;s:30:\"um-icon-ios-paperplane-outline\";i:429;s:23:\"um-icon-ios-partlysunny\";i:430;s:31:\"um-icon-ios-partlysunny-outline\";i:431;s:17:\"um-icon-ios-pause\";i:432;s:25:\"um-icon-ios-pause-outline\";i:433;s:15:\"um-icon-ios-paw\";i:434;s:23:\"um-icon-ios-paw-outline\";i:435;s:18:\"um-icon-ios-people\";i:436;s:26:\"um-icon-ios-people-outline\";i:437;s:18:\"um-icon-ios-person\";i:438;s:26:\"um-icon-ios-person-outline\";i:439;s:21:\"um-icon-ios-personadd\";i:440;s:29:\"um-icon-ios-personadd-outline\";i:441;s:18:\"um-icon-ios-photos\";i:442;s:26:\"um-icon-ios-photos-outline\";i:443;s:15:\"um-icon-ios-pie\";i:444;s:23:\"um-icon-ios-pie-outline\";i:445;s:16:\"um-icon-ios-pint\";i:446;s:24:\"um-icon-ios-pint-outline\";i:447;s:16:\"um-icon-ios-play\";i:448;s:24:\"um-icon-ios-play-outline\";i:449;s:16:\"um-icon-ios-plus\";i:450;s:22:\"um-icon-ios-plus-empty\";i:451;s:24:\"um-icon-ios-plus-outline\";i:452;s:20:\"um-icon-ios-pricetag\";i:453;s:28:\"um-icon-ios-pricetag-outline\";i:454;s:21:\"um-icon-ios-pricetags\";i:455;s:29:\"um-icon-ios-pricetags-outline\";i:456;s:19:\"um-icon-ios-printer\";i:457;s:27:\"um-icon-ios-printer-outline\";i:458;s:17:\"um-icon-ios-pulse\";i:459;s:24:\"um-icon-ios-pulse-strong\";i:460;s:17:\"um-icon-ios-rainy\";i:461;s:25:\"um-icon-ios-rainy-outline\";i:462;s:21:\"um-icon-ios-recording\";i:463;s:29:\"um-icon-ios-recording-outline\";i:464;s:16:\"um-icon-ios-redo\";i:465;s:24:\"um-icon-ios-redo-outline\";i:466;s:19:\"um-icon-ios-refresh\";i:467;s:25:\"um-icon-ios-refresh-empty\";i:468;s:27:\"um-icon-ios-refresh-outline\";i:469;s:18:\"um-icon-ios-reload\";i:470;s:26:\"um-icon-ios-reverse-camera\";i:471;s:34:\"um-icon-ios-reverse-camera-outline\";i:472;s:18:\"um-icon-ios-rewind\";i:473;s:26:\"um-icon-ios-rewind-outline\";i:474;s:16:\"um-icon-ios-rose\";i:475;s:24:\"um-icon-ios-rose-outline\";i:476;s:18:\"um-icon-ios-search\";i:477;s:25:\"um-icon-ios-search-strong\";i:478;s:20:\"um-icon-ios-settings\";i:479;s:27:\"um-icon-ios-settings-strong\";i:480;s:19:\"um-icon-ios-shuffle\";i:481;s:26:\"um-icon-ios-shuffle-strong\";i:482;s:24:\"um-icon-ios-skipbackward\";i:483;s:32:\"um-icon-ios-skipbackward-outline\";i:484;s:23:\"um-icon-ios-skipforward\";i:485;s:31:\"um-icon-ios-skipforward-outline\";i:486;s:17:\"um-icon-ios-snowy\";i:487;s:23:\"um-icon-ios-speedometer\";i:488;s:31:\"um-icon-ios-speedometer-outline\";i:489;s:16:\"um-icon-ios-star\";i:490;s:21:\"um-icon-ios-star-half\";i:491;s:24:\"um-icon-ios-star-outline\";i:492;s:21:\"um-icon-ios-stopwatch\";i:493;s:29:\"um-icon-ios-stopwatch-outline\";i:494;s:17:\"um-icon-ios-sunny\";i:495;s:25:\"um-icon-ios-sunny-outline\";i:496;s:21:\"um-icon-ios-telephone\";i:497;s:29:\"um-icon-ios-telephone-outline\";i:498;s:22:\"um-icon-ios-tennisball\";i:499;s:30:\"um-icon-ios-tennisball-outline\";i:500;s:24:\"um-icon-ios-thunderstorm\";i:501;s:32:\"um-icon-ios-thunderstorm-outline\";i:502;s:16:\"um-icon-ios-time\";i:503;s:24:\"um-icon-ios-time-outline\";i:504;s:17:\"um-icon-ios-timer\";i:505;s:25:\"um-icon-ios-timer-outline\";i:506;s:18:\"um-icon-ios-toggle\";i:507;s:26:\"um-icon-ios-toggle-outline\";i:508;s:17:\"um-icon-ios-trash\";i:509;s:25:\"um-icon-ios-trash-outline\";i:510;s:16:\"um-icon-ios-undo\";i:511;s:24:\"um-icon-ios-undo-outline\";i:512;s:20:\"um-icon-ios-unlocked\";i:513;s:28:\"um-icon-ios-unlocked-outline\";i:514;s:18:\"um-icon-ios-upload\";i:515;s:26:\"um-icon-ios-upload-outline\";i:516;s:20:\"um-icon-ios-videocam\";i:517;s:28:\"um-icon-ios-videocam-outline\";i:518;s:23:\"um-icon-ios-volume-high\";i:519;s:22:\"um-icon-ios-volume-low\";i:520;s:21:\"um-icon-ios-wineglass\";i:521;s:29:\"um-icon-ios-wineglass-outline\";i:522;s:17:\"um-icon-ios-world\";i:523;s:25:\"um-icon-ios-world-outline\";i:524;s:12:\"um-icon-ipad\";i:525;s:14:\"um-icon-iphone\";i:526;s:12:\"um-icon-ipod\";i:527;s:11:\"um-icon-jet\";i:528;s:11:\"um-icon-key\";i:529;s:13:\"um-icon-knife\";i:530;s:14:\"um-icon-laptop\";i:531;s:12:\"um-icon-leaf\";i:532;s:14:\"um-icon-levels\";i:533;s:17:\"um-icon-lightbulb\";i:534;s:12:\"um-icon-link\";i:535;s:14:\"um-icon-load-a\";i:536;s:14:\"um-icon-load-b\";i:537;s:14:\"um-icon-load-c\";i:538;s:14:\"um-icon-load-d\";i:539;s:16:\"um-icon-location\";i:540;s:24:\"um-icon-lock-combination\";i:541;s:14:\"um-icon-locked\";i:542;s:14:\"um-icon-log-in\";i:543;s:15:\"um-icon-log-out\";i:544;s:12:\"um-icon-loop\";i:545;s:14:\"um-icon-magnet\";i:546;s:12:\"um-icon-male\";i:547;s:11:\"um-icon-man\";i:548;s:11:\"um-icon-map\";i:549;s:14:\"um-icon-medkit\";i:550;s:13:\"um-icon-merge\";i:551;s:13:\"um-icon-mic-a\";i:552;s:13:\"um-icon-mic-b\";i:553;s:13:\"um-icon-mic-c\";i:554;s:13:\"um-icon-minus\";i:555;s:21:\"um-icon-minus-circled\";i:556;s:19:\"um-icon-minus-round\";i:557;s:15:\"um-icon-model-s\";i:558;s:15:\"um-icon-monitor\";i:559;s:12:\"um-icon-more\";i:560;s:13:\"um-icon-mouse\";i:561;s:18:\"um-icon-music-note\";i:562;s:15:\"um-icon-navicon\";i:563;s:21:\"um-icon-navicon-round\";i:564;s:16:\"um-icon-navigate\";i:565;s:15:\"um-icon-network\";i:566;s:18:\"um-icon-no-smoking\";i:567;s:15:\"um-icon-nuclear\";i:568;s:14:\"um-icon-outlet\";i:569;s:18:\"um-icon-paintbrush\";i:570;s:19:\"um-icon-paintbucket\";i:571;s:22:\"um-icon-paper-airplane\";i:572;s:17:\"um-icon-paperclip\";i:573;s:13:\"um-icon-pause\";i:574;s:14:\"um-icon-person\";i:575;s:18:\"um-icon-person-add\";i:576;s:22:\"um-icon-person-stalker\";i:577;s:17:\"um-icon-pie-graph\";i:578;s:11:\"um-icon-pin\";i:579;s:16:\"um-icon-pinpoint\";i:580;s:13:\"um-icon-pizza\";i:581;s:13:\"um-icon-plane\";i:582;s:14:\"um-icon-planet\";i:583;s:12:\"um-icon-play\";i:584;s:19:\"um-icon-playstation\";i:585;s:12:\"um-icon-plus\";i:586;s:20:\"um-icon-plus-circled\";i:587;s:18:\"um-icon-plus-round\";i:588;s:14:\"um-icon-podium\";i:589;s:13:\"um-icon-pound\";i:590;s:13:\"um-icon-power\";i:591;s:16:\"um-icon-pricetag\";i:592;s:17:\"um-icon-pricetags\";i:593;s:15:\"um-icon-printer\";i:594;s:20:\"um-icon-pull-request\";i:595;s:18:\"um-icon-qr-scanner\";i:596;s:13:\"um-icon-quote\";i:597;s:19:\"um-icon-radio-waves\";i:598;s:14:\"um-icon-record\";i:599;s:15:\"um-icon-refresh\";i:600;s:13:\"um-icon-reply\";i:601;s:17:\"um-icon-reply-all\";i:602;s:16:\"um-icon-ribbon-a\";i:603;s:16:\"um-icon-ribbon-b\";i:604;s:11:\"um-icon-sad\";i:605;s:19:\"um-icon-sad-outline\";i:606;s:16:\"um-icon-scissors\";i:607;s:14:\"um-icon-search\";i:608;s:16:\"um-icon-settings\";i:609;s:13:\"um-icon-share\";i:610;s:15:\"um-icon-shuffle\";i:611;s:21:\"um-icon-skip-backward\";i:612;s:20:\"um-icon-skip-forward\";i:613;s:22:\"um-icon-social-android\";i:614;s:30:\"um-icon-social-android-outline\";i:615;s:22:\"um-icon-social-angular\";i:616;s:30:\"um-icon-social-angular-outline\";i:617;s:20:\"um-icon-social-apple\";i:618;s:28:\"um-icon-social-apple-outline\";i:619;s:22:\"um-icon-social-bitcoin\";i:620;s:30:\"um-icon-social-bitcoin-outline\";i:621;s:21:\"um-icon-social-buffer\";i:622;s:29:\"um-icon-social-buffer-outline\";i:623;s:21:\"um-icon-social-chrome\";i:624;s:29:\"um-icon-social-chrome-outline\";i:625;s:22:\"um-icon-social-codepen\";i:626;s:30:\"um-icon-social-codepen-outline\";i:627;s:19:\"um-icon-social-css3\";i:628;s:27:\"um-icon-social-css3-outline\";i:629;s:27:\"um-icon-social-designernews\";i:630;s:35:\"um-icon-social-designernews-outline\";i:631;s:23:\"um-icon-social-dribbble\";i:632;s:31:\"um-icon-social-dribbble-outline\";i:633;s:22:\"um-icon-social-dropbox\";i:634;s:30:\"um-icon-social-dropbox-outline\";i:635;s:19:\"um-icon-social-euro\";i:636;s:27:\"um-icon-social-euro-outline\";i:637;s:23:\"um-icon-social-facebook\";i:638;s:31:\"um-icon-social-facebook-outline\";i:639;s:25:\"um-icon-social-foursquare\";i:640;s:33:\"um-icon-social-foursquare-outline\";i:641;s:28:\"um-icon-social-freebsd-devil\";i:642;s:21:\"um-icon-social-github\";i:643;s:29:\"um-icon-social-github-outline\";i:644;s:21:\"um-icon-social-google\";i:645;s:29:\"um-icon-social-google-outline\";i:646;s:25:\"um-icon-social-googleplus\";i:647;s:33:\"um-icon-social-googleplus-outline\";i:648;s:25:\"um-icon-social-hackernews\";i:649;s:33:\"um-icon-social-hackernews-outline\";i:650;s:20:\"um-icon-social-html5\";i:651;s:28:\"um-icon-social-html5-outline\";i:652;s:24:\"um-icon-social-instagram\";i:653;s:32:\"um-icon-social-instagram-outline\";i:654;s:25:\"um-icon-social-javascript\";i:655;s:33:\"um-icon-social-javascript-outline\";i:656;s:23:\"um-icon-social-linkedin\";i:657;s:31:\"um-icon-social-linkedin-outline\";i:658;s:23:\"um-icon-social-markdown\";i:659;s:21:\"um-icon-social-nodejs\";i:660;s:22:\"um-icon-social-octocat\";i:661;s:24:\"um-icon-social-pinterest\";i:662;s:32:\"um-icon-social-pinterest-outline\";i:663;s:21:\"um-icon-social-python\";i:664;s:21:\"um-icon-social-reddit\";i:665;s:29:\"um-icon-social-reddit-outline\";i:666;s:18:\"um-icon-social-rss\";i:667;s:26:\"um-icon-social-rss-outline\";i:668;s:19:\"um-icon-social-sass\";i:669;s:20:\"um-icon-social-skype\";i:670;s:28:\"um-icon-social-skype-outline\";i:671;s:23:\"um-icon-social-snapchat\";i:672;s:31:\"um-icon-social-snapchat-outline\";i:673;s:21:\"um-icon-social-tumblr\";i:674;s:29:\"um-icon-social-tumblr-outline\";i:675;s:18:\"um-icon-social-tux\";i:676;s:21:\"um-icon-social-twitch\";i:677;s:29:\"um-icon-social-twitch-outline\";i:678;s:22:\"um-icon-social-twitter\";i:679;s:30:\"um-icon-social-twitter-outline\";i:680;s:18:\"um-icon-social-usd\";i:681;s:26:\"um-icon-social-usd-outline\";i:682;s:20:\"um-icon-social-vimeo\";i:683;s:28:\"um-icon-social-vimeo-outline\";i:684;s:23:\"um-icon-social-whatsapp\";i:685;s:31:\"um-icon-social-whatsapp-outline\";i:686;s:22:\"um-icon-social-windows\";i:687;s:30:\"um-icon-social-windows-outline\";i:688;s:24:\"um-icon-social-wordpress\";i:689;s:32:\"um-icon-social-wordpress-outline\";i:690;s:20:\"um-icon-social-yahoo\";i:691;s:28:\"um-icon-social-yahoo-outline\";i:692;s:18:\"um-icon-social-yen\";i:693;s:26:\"um-icon-social-yen-outline\";i:694;s:22:\"um-icon-social-youtube\";i:695;s:30:\"um-icon-social-youtube-outline\";i:696;s:16:\"um-icon-soup-can\";i:697;s:24:\"um-icon-soup-can-outline\";i:698;s:20:\"um-icon-speakerphone\";i:699;s:19:\"um-icon-speedometer\";i:700;s:13:\"um-icon-spoon\";i:701;s:12:\"um-icon-star\";i:702;s:18:\"um-icon-stats-bars\";i:703;s:13:\"um-icon-steam\";i:704;s:12:\"um-icon-stop\";i:705;s:19:\"um-icon-thermometer\";i:706;s:18:\"um-icon-thumbsdown\";i:707;s:16:\"um-icon-thumbsup\";i:708;s:14:\"um-icon-toggle\";i:709;s:21:\"um-icon-toggle-filled\";i:710;s:19:\"um-icon-transgender\";i:711;s:15:\"um-icon-trash-a\";i:712;s:15:\"um-icon-trash-b\";i:713;s:14:\"um-icon-trophy\";i:714;s:14:\"um-icon-tshirt\";i:715;s:22:\"um-icon-tshirt-outline\";i:716;s:16:\"um-icon-umbrella\";i:717;s:18:\"um-icon-university\";i:718;s:16:\"um-icon-unlocked\";i:719;s:14:\"um-icon-upload\";i:720;s:11:\"um-icon-usb\";i:721;s:19:\"um-icon-videocamera\";i:722;s:19:\"um-icon-volume-high\";i:723;s:18:\"um-icon-volume-low\";i:724;s:21:\"um-icon-volume-medium\";i:725;s:19:\"um-icon-volume-mute\";i:726;s:12:\"um-icon-wand\";i:727;s:17:\"um-icon-waterdrop\";i:728;s:12:\"um-icon-wifi\";i:729;s:17:\"um-icon-wineglass\";i:730;s:13:\"um-icon-woman\";i:731;s:14:\"um-icon-wrench\";i:732;s:12:\"um-icon-xbox\";i:733;s:15:\"um-faicon-glass\";i:734;s:15:\"um-faicon-music\";i:735;s:16:\"um-faicon-search\";i:736;s:20:\"um-faicon-envelope-o\";i:737;s:15:\"um-faicon-heart\";i:738;s:14:\"um-faicon-star\";i:739;s:16:\"um-faicon-star-o\";i:740;s:14:\"um-faicon-user\";i:741;s:14:\"um-faicon-film\";i:742;s:18:\"um-faicon-th-large\";i:743;s:12:\"um-faicon-th\";i:744;s:17:\"um-faicon-th-list\";i:745;s:15:\"um-faicon-check\";i:746;s:15:\"um-faicon-times\";i:747;s:21:\"um-faicon-search-plus\";i:748;s:22:\"um-faicon-search-minus\";i:749;s:19:\"um-faicon-power-off\";i:750;s:16:\"um-faicon-signal\";i:751;s:13:\"um-faicon-cog\";i:752;s:17:\"um-faicon-trash-o\";i:753;s:14:\"um-faicon-home\";i:754;s:16:\"um-faicon-file-o\";i:755;s:17:\"um-faicon-clock-o\";i:756;s:14:\"um-faicon-road\";i:757;s:18:\"um-faicon-download\";i:758;s:29:\"um-faicon-arrow-circle-o-down\";i:759;s:27:\"um-faicon-arrow-circle-o-up\";i:760;s:15:\"um-faicon-inbox\";i:761;s:23:\"um-faicon-play-circle-o\";i:762;s:16:\"um-faicon-repeat\";i:763;s:17:\"um-faicon-refresh\";i:764;s:18:\"um-faicon-list-alt\";i:765;s:14:\"um-faicon-lock\";i:766;s:14:\"um-faicon-flag\";i:767;s:20:\"um-faicon-headphones\";i:768;s:20:\"um-faicon-volume-off\";i:769;s:21:\"um-faicon-volume-down\";i:770;s:19:\"um-faicon-volume-up\";i:771;s:16:\"um-faicon-qrcode\";i:772;s:17:\"um-faicon-barcode\";i:773;s:13:\"um-faicon-tag\";i:774;s:14:\"um-faicon-tags\";i:775;s:14:\"um-faicon-book\";i:776;s:18:\"um-faicon-bookmark\";i:777;s:15:\"um-faicon-print\";i:778;s:16:\"um-faicon-camera\";i:779;s:14:\"um-faicon-font\";i:780;s:14:\"um-faicon-bold\";i:781;s:16:\"um-faicon-italic\";i:782;s:21:\"um-faicon-text-height\";i:783;s:20:\"um-faicon-text-width\";i:784;s:20:\"um-faicon-align-left\";i:785;s:22:\"um-faicon-align-center\";i:786;s:21:\"um-faicon-align-right\";i:787;s:23:\"um-faicon-align-justify\";i:788;s:14:\"um-faicon-list\";i:789;s:17:\"um-faicon-outdent\";i:790;s:16:\"um-faicon-indent\";i:791;s:22:\"um-faicon-video-camera\";i:792;s:19:\"um-faicon-picture-o\";i:793;s:16:\"um-faicon-pencil\";i:794;s:20:\"um-faicon-map-marker\";i:795;s:16:\"um-faicon-adjust\";i:796;s:14:\"um-faicon-tint\";i:797;s:25:\"um-faicon-pencil-square-o\";i:798;s:24:\"um-faicon-share-square-o\";i:799;s:24:\"um-faicon-check-square-o\";i:800;s:16:\"um-faicon-arrows\";i:801;s:23:\"um-faicon-step-backward\";i:802;s:23:\"um-faicon-fast-backward\";i:803;s:18:\"um-faicon-backward\";i:804;s:14:\"um-faicon-play\";i:805;s:15:\"um-faicon-pause\";i:806;s:14:\"um-faicon-stop\";i:807;s:17:\"um-faicon-forward\";i:808;s:22:\"um-faicon-fast-forward\";i:809;s:22:\"um-faicon-step-forward\";i:810;s:15:\"um-faicon-eject\";i:811;s:22:\"um-faicon-chevron-left\";i:812;s:23:\"um-faicon-chevron-right\";i:813;s:21:\"um-faicon-plus-circle\";i:814;s:22:\"um-faicon-minus-circle\";i:815;s:22:\"um-faicon-times-circle\";i:816;s:22:\"um-faicon-check-circle\";i:817;s:25:\"um-faicon-question-circle\";i:818;s:21:\"um-faicon-info-circle\";i:819;s:20:\"um-faicon-crosshairs\";i:820;s:24:\"um-faicon-times-circle-o\";i:821;s:24:\"um-faicon-check-circle-o\";i:822;s:13:\"um-faicon-ban\";i:823;s:20:\"um-faicon-arrow-left\";i:824;s:21:\"um-faicon-arrow-right\";i:825;s:18:\"um-faicon-arrow-up\";i:826;s:20:\"um-faicon-arrow-down\";i:827;s:15:\"um-faicon-share\";i:828;s:16:\"um-faicon-expand\";i:829;s:18:\"um-faicon-compress\";i:830;s:14:\"um-faicon-plus\";i:831;s:15:\"um-faicon-minus\";i:832;s:18:\"um-faicon-asterisk\";i:833;s:28:\"um-faicon-exclamation-circle\";i:834;s:14:\"um-faicon-gift\";i:835;s:14:\"um-faicon-leaf\";i:836;s:14:\"um-faicon-fire\";i:837;s:13:\"um-faicon-eye\";i:838;s:19:\"um-faicon-eye-slash\";i:839;s:30:\"um-faicon-exclamation-triangle\";i:840;s:15:\"um-faicon-plane\";i:841;s:18:\"um-faicon-calendar\";i:842;s:16:\"um-faicon-random\";i:843;s:17:\"um-faicon-comment\";i:844;s:16:\"um-faicon-magnet\";i:845;s:20:\"um-faicon-chevron-up\";i:846;s:22:\"um-faicon-chevron-down\";i:847;s:17:\"um-faicon-retweet\";i:848;s:23:\"um-faicon-shopping-cart\";i:849;s:16:\"um-faicon-folder\";i:850;s:21:\"um-faicon-folder-open\";i:851;s:18:\"um-faicon-arrows-v\";i:852;s:18:\"um-faicon-arrows-h\";i:853;s:19:\"um-faicon-bar-chart\";i:854;s:24:\"um-faicon-twitter-square\";i:855;s:25:\"um-faicon-facebook-square\";i:856;s:22:\"um-faicon-camera-retro\";i:857;s:13:\"um-faicon-key\";i:858;s:14:\"um-faicon-cogs\";i:859;s:18:\"um-faicon-comments\";i:860;s:21:\"um-faicon-thumbs-o-up\";i:861;s:23:\"um-faicon-thumbs-o-down\";i:862;s:19:\"um-faicon-star-half\";i:863;s:17:\"um-faicon-heart-o\";i:864;s:18:\"um-faicon-sign-out\";i:865;s:25:\"um-faicon-linkedin-square\";i:866;s:20:\"um-faicon-thumb-tack\";i:867;s:23:\"um-faicon-external-link\";i:868;s:17:\"um-faicon-sign-in\";i:869;s:16:\"um-faicon-trophy\";i:870;s:23:\"um-faicon-github-square\";i:871;s:16:\"um-faicon-upload\";i:872;s:17:\"um-faicon-lemon-o\";i:873;s:15:\"um-faicon-phone\";i:874;s:18:\"um-faicon-square-o\";i:875;s:20:\"um-faicon-bookmark-o\";i:876;s:22:\"um-faicon-phone-square\";i:877;s:17:\"um-faicon-twitter\";i:878;s:18:\"um-faicon-facebook\";i:879;s:16:\"um-faicon-github\";i:880;s:16:\"um-faicon-unlock\";i:881;s:21:\"um-faicon-credit-card\";i:882;s:13:\"um-faicon-rss\";i:883;s:15:\"um-faicon-hdd-o\";i:884;s:18:\"um-faicon-bullhorn\";i:885;s:14:\"um-faicon-bell\";i:886;s:21:\"um-faicon-certificate\";i:887;s:22:\"um-faicon-hand-o-right\";i:888;s:21:\"um-faicon-hand-o-left\";i:889;s:19:\"um-faicon-hand-o-up\";i:890;s:21:\"um-faicon-hand-o-down\";i:891;s:27:\"um-faicon-arrow-circle-left\";i:892;s:28:\"um-faicon-arrow-circle-right\";i:893;s:25:\"um-faicon-arrow-circle-up\";i:894;s:27:\"um-faicon-arrow-circle-down\";i:895;s:15:\"um-faicon-globe\";i:896;s:16:\"um-faicon-wrench\";i:897;s:15:\"um-faicon-tasks\";i:898;s:16:\"um-faicon-filter\";i:899;s:19:\"um-faicon-briefcase\";i:900;s:20:\"um-faicon-arrows-alt\";i:901;s:15:\"um-faicon-users\";i:902;s:14:\"um-faicon-link\";i:903;s:15:\"um-faicon-cloud\";i:904;s:15:\"um-faicon-flask\";i:905;s:18:\"um-faicon-scissors\";i:906;s:17:\"um-faicon-files-o\";i:907;s:19:\"um-faicon-paperclip\";i:908;s:18:\"um-faicon-floppy-o\";i:909;s:16:\"um-faicon-square\";i:910;s:14:\"um-faicon-bars\";i:911;s:17:\"um-faicon-list-ul\";i:912;s:17:\"um-faicon-list-ol\";i:913;s:23:\"um-faicon-strikethrough\";i:914;s:19:\"um-faicon-underline\";i:915;s:15:\"um-faicon-table\";i:916;s:15:\"um-faicon-magic\";i:917;s:15:\"um-faicon-truck\";i:918;s:19:\"um-faicon-pinterest\";i:919;s:26:\"um-faicon-pinterest-square\";i:920;s:28:\"um-faicon-google-plus-square\";i:921;s:21:\"um-faicon-google-plus\";i:922;s:15:\"um-faicon-money\";i:923;s:20:\"um-faicon-caret-down\";i:924;s:18:\"um-faicon-caret-up\";i:925;s:20:\"um-faicon-caret-left\";i:926;s:21:\"um-faicon-caret-right\";i:927;s:17:\"um-faicon-columns\";i:928;s:14:\"um-faicon-sort\";i:929;s:19:\"um-faicon-sort-desc\";i:930;s:18:\"um-faicon-sort-asc\";i:931;s:18:\"um-faicon-envelope\";i:932;s:18:\"um-faicon-linkedin\";i:933;s:14:\"um-faicon-undo\";i:934;s:15:\"um-faicon-gavel\";i:935;s:20:\"um-faicon-tachometer\";i:936;s:19:\"um-faicon-comment-o\";i:937;s:20:\"um-faicon-comments-o\";i:938;s:14:\"um-faicon-bolt\";i:939;s:17:\"um-faicon-sitemap\";i:940;s:18:\"um-faicon-umbrella\";i:941;s:19:\"um-faicon-clipboard\";i:942;s:21:\"um-faicon-lightbulb-o\";i:943;s:18:\"um-faicon-exchange\";i:944;s:24:\"um-faicon-cloud-download\";i:945;s:22:\"um-faicon-cloud-upload\";i:946;s:17:\"um-faicon-user-md\";i:947;s:21:\"um-faicon-stethoscope\";i:948;s:18:\"um-faicon-suitcase\";i:949;s:16:\"um-faicon-bell-o\";i:950;s:16:\"um-faicon-coffee\";i:951;s:17:\"um-faicon-cutlery\";i:952;s:21:\"um-faicon-file-text-o\";i:953;s:20:\"um-faicon-building-o\";i:954;s:20:\"um-faicon-hospital-o\";i:955;s:19:\"um-faicon-ambulance\";i:956;s:16:\"um-faicon-medkit\";i:957;s:21:\"um-faicon-fighter-jet\";i:958;s:14:\"um-faicon-beer\";i:959;s:18:\"um-faicon-h-square\";i:960;s:21:\"um-faicon-plus-square\";i:961;s:27:\"um-faicon-angle-double-left\";i:962;s:28:\"um-faicon-angle-double-right\";i:963;s:25:\"um-faicon-angle-double-up\";i:964;s:27:\"um-faicon-angle-double-down\";i:965;s:20:\"um-faicon-angle-left\";i:966;s:21:\"um-faicon-angle-right\";i:967;s:18:\"um-faicon-angle-up\";i:968;s:20:\"um-faicon-angle-down\";i:969;s:17:\"um-faicon-desktop\";i:970;s:16:\"um-faicon-laptop\";i:971;s:16:\"um-faicon-tablet\";i:972;s:16:\"um-faicon-mobile\";i:973;s:18:\"um-faicon-circle-o\";i:974;s:20:\"um-faicon-quote-left\";i:975;s:21:\"um-faicon-quote-right\";i:976;s:17:\"um-faicon-spinner\";i:977;s:16:\"um-faicon-circle\";i:978;s:15:\"um-faicon-reply\";i:979;s:20:\"um-faicon-github-alt\";i:980;s:18:\"um-faicon-folder-o\";i:981;s:23:\"um-faicon-folder-open-o\";i:982;s:17:\"um-faicon-smile-o\";i:983;s:17:\"um-faicon-frown-o\";i:984;s:15:\"um-faicon-meh-o\";i:985;s:17:\"um-faicon-gamepad\";i:986;s:20:\"um-faicon-keyboard-o\";i:987;s:16:\"um-faicon-flag-o\";i:988;s:24:\"um-faicon-flag-checkered\";i:989;s:18:\"um-faicon-terminal\";i:990;s:14:\"um-faicon-code\";i:991;s:19:\"um-faicon-reply-all\";i:992;s:21:\"um-faicon-star-half-o\";i:993;s:24:\"um-faicon-location-arrow\";i:994;s:14:\"um-faicon-crop\";i:995;s:19:\"um-faicon-code-fork\";i:996;s:22:\"um-faicon-chain-broken\";i:997;s:18:\"um-faicon-question\";i:998;s:14:\"um-faicon-info\";i:999;s:21:\"um-faicon-exclamation\";i:1000;s:21:\"um-faicon-superscript\";i:1001;s:19:\"um-faicon-subscript\";i:1002;s:16:\"um-faicon-eraser\";i:1003;s:22:\"um-faicon-puzzle-piece\";i:1004;s:20:\"um-faicon-microphone\";i:1005;s:26:\"um-faicon-microphone-slash\";i:1006;s:16:\"um-faicon-shield\";i:1007;s:20:\"um-faicon-calendar-o\";i:1008;s:27:\"um-faicon-fire-extinguisher\";i:1009;s:16:\"um-faicon-rocket\";i:1010;s:16:\"um-faicon-maxcdn\";i:1011;s:29:\"um-faicon-chevron-circle-left\";i:1012;s:30:\"um-faicon-chevron-circle-right\";i:1013;s:27:\"um-faicon-chevron-circle-up\";i:1014;s:29:\"um-faicon-chevron-circle-down\";i:1015;s:15:\"um-faicon-html5\";i:1016;s:14:\"um-faicon-css3\";i:1017;s:16:\"um-faicon-anchor\";i:1018;s:20:\"um-faicon-unlock-alt\";i:1019;s:18:\"um-faicon-bullseye\";i:1020;s:20:\"um-faicon-ellipsis-h\";i:1021;s:20:\"um-faicon-ellipsis-v\";i:1022;s:20:\"um-faicon-rss-square\";i:1023;s:21:\"um-faicon-play-circle\";i:1024;s:16:\"um-faicon-ticket\";i:1025;s:22:\"um-faicon-minus-square\";i:1026;s:24:\"um-faicon-minus-square-o\";i:1027;s:18:\"um-faicon-level-up\";i:1028;s:20:\"um-faicon-level-down\";i:1029;s:22:\"um-faicon-check-square\";i:1030;s:23:\"um-faicon-pencil-square\";i:1031;s:30:\"um-faicon-external-link-square\";i:1032;s:22:\"um-faicon-share-square\";i:1033;s:17:\"um-faicon-compass\";i:1034;s:29:\"um-faicon-caret-square-o-down\";i:1035;s:27:\"um-faicon-caret-square-o-up\";i:1036;s:30:\"um-faicon-caret-square-o-right\";i:1037;s:13:\"um-faicon-eur\";i:1038;s:13:\"um-faicon-gbp\";i:1039;s:13:\"um-faicon-usd\";i:1040;s:13:\"um-faicon-inr\";i:1041;s:13:\"um-faicon-jpy\";i:1042;s:13:\"um-faicon-rub\";i:1043;s:13:\"um-faicon-krw\";i:1044;s:13:\"um-faicon-btc\";i:1045;s:14:\"um-faicon-file\";i:1046;s:19:\"um-faicon-file-text\";i:1047;s:24:\"um-faicon-sort-alpha-asc\";i:1048;s:25:\"um-faicon-sort-alpha-desc\";i:1049;s:25:\"um-faicon-sort-amount-asc\";i:1050;s:26:\"um-faicon-sort-amount-desc\";i:1051;s:26:\"um-faicon-sort-numeric-asc\";i:1052;s:27:\"um-faicon-sort-numeric-desc\";i:1053;s:19:\"um-faicon-thumbs-up\";i:1054;s:21:\"um-faicon-thumbs-down\";i:1055;s:24:\"um-faicon-youtube-square\";i:1056;s:17:\"um-faicon-youtube\";i:1057;s:14:\"um-faicon-xing\";i:1058;s:21:\"um-faicon-xing-square\";i:1059;s:22:\"um-faicon-youtube-play\";i:1060;s:17:\"um-faicon-dropbox\";i:1061;s:24:\"um-faicon-stack-overflow\";i:1062;s:19:\"um-faicon-instagram\";i:1063;s:16:\"um-faicon-flickr\";i:1064;s:13:\"um-faicon-adn\";i:1065;s:19:\"um-faicon-bitbucket\";i:1066;s:26:\"um-faicon-bitbucket-square\";i:1067;s:16:\"um-faicon-tumblr\";i:1068;s:23:\"um-faicon-tumblr-square\";i:1069;s:25:\"um-faicon-long-arrow-down\";i:1070;s:23:\"um-faicon-long-arrow-up\";i:1071;s:25:\"um-faicon-long-arrow-left\";i:1072;s:26:\"um-faicon-long-arrow-right\";i:1073;s:15:\"um-faicon-apple\";i:1074;s:17:\"um-faicon-windows\";i:1075;s:17:\"um-faicon-android\";i:1076;s:15:\"um-faicon-linux\";i:1077;s:18:\"um-faicon-dribbble\";i:1078;s:15:\"um-faicon-skype\";i:1079;s:20:\"um-faicon-foursquare\";i:1080;s:16:\"um-faicon-trello\";i:1081;s:16:\"um-faicon-female\";i:1082;s:14:\"um-faicon-male\";i:1083;s:16:\"um-faicon-gittip\";i:1084;s:15:\"um-faicon-sun-o\";i:1085;s:16:\"um-faicon-moon-o\";i:1086;s:17:\"um-faicon-archive\";i:1087;s:13:\"um-faicon-bug\";i:1088;s:12:\"um-faicon-vk\";i:1089;s:15:\"um-faicon-weibo\";i:1090;s:16:\"um-faicon-renren\";i:1091;s:19:\"um-faicon-pagelines\";i:1092;s:24:\"um-faicon-stack-exchange\";i:1093;s:30:\"um-faicon-arrow-circle-o-right\";i:1094;s:29:\"um-faicon-arrow-circle-o-left\";i:1095;s:29:\"um-faicon-caret-square-o-left\";i:1096;s:22:\"um-faicon-dot-circle-o\";i:1097;s:20:\"um-faicon-wheelchair\";i:1098;s:22:\"um-faicon-vimeo-square\";i:1099;s:13:\"um-faicon-try\";i:1100;s:23:\"um-faicon-plus-square-o\";i:1101;s:23:\"um-faicon-space-shuttle\";i:1102;s:15:\"um-faicon-slack\";i:1103;s:25:\"um-faicon-envelope-square\";i:1104;s:19:\"um-faicon-wordpress\";i:1105;s:16:\"um-faicon-openid\";i:1106;s:20:\"um-faicon-university\";i:1107;s:24:\"um-faicon-graduation-cap\";i:1108;s:15:\"um-faicon-yahoo\";i:1109;s:16:\"um-faicon-google\";i:1110;s:16:\"um-faicon-reddit\";i:1111;s:23:\"um-faicon-reddit-square\";i:1112;s:28:\"um-faicon-stumbleupon-circle\";i:1113;s:21:\"um-faicon-stumbleupon\";i:1114;s:19:\"um-faicon-delicious\";i:1115;s:14:\"um-faicon-digg\";i:1116;s:20:\"um-faicon-pied-piper\";i:1117;s:24:\"um-faicon-pied-piper-alt\";i:1118;s:16:\"um-faicon-drupal\";i:1119;s:16:\"um-faicon-joomla\";i:1120;s:18:\"um-faicon-language\";i:1121;s:13:\"um-faicon-fax\";i:1122;s:18:\"um-faicon-building\";i:1123;s:15:\"um-faicon-child\";i:1124;s:13:\"um-faicon-paw\";i:1125;s:15:\"um-faicon-spoon\";i:1126;s:14:\"um-faicon-cube\";i:1127;s:15:\"um-faicon-cubes\";i:1128;s:17:\"um-faicon-behance\";i:1129;s:24:\"um-faicon-behance-square\";i:1130;s:15:\"um-faicon-steam\";i:1131;s:22:\"um-faicon-steam-square\";i:1132;s:17:\"um-faicon-recycle\";i:1133;s:13:\"um-faicon-car\";i:1134;s:14:\"um-faicon-taxi\";i:1135;s:14:\"um-faicon-tree\";i:1136;s:17:\"um-faicon-spotify\";i:1137;s:20:\"um-faicon-deviantart\";i:1138;s:20:\"um-faicon-soundcloud\";i:1139;s:18:\"um-faicon-database\";i:1140;s:20:\"um-faicon-file-pdf-o\";i:1141;s:21:\"um-faicon-file-word-o\";i:1142;s:22:\"um-faicon-file-excel-o\";i:1143;s:27:\"um-faicon-file-powerpoint-o\";i:1144;s:22:\"um-faicon-file-image-o\";i:1145;s:24:\"um-faicon-file-archive-o\";i:1146;s:22:\"um-faicon-file-audio-o\";i:1147;s:22:\"um-faicon-file-video-o\";i:1148;s:21:\"um-faicon-file-code-o\";i:1149;s:14:\"um-faicon-vine\";i:1150;s:17:\"um-faicon-codepen\";i:1151;s:18:\"um-faicon-jsfiddle\";i:1152;s:19:\"um-faicon-life-ring\";i:1153;s:24:\"um-faicon-circle-o-notch\";i:1154;s:15:\"um-faicon-rebel\";i:1155;s:16:\"um-faicon-empire\";i:1156;s:20:\"um-faicon-git-square\";i:1157;s:13:\"um-faicon-git\";i:1158;s:21:\"um-faicon-hacker-news\";i:1159;s:23:\"um-faicon-tencent-weibo\";i:1160;s:12:\"um-faicon-qq\";i:1161;s:16:\"um-faicon-weixin\";i:1162;s:21:\"um-faicon-paper-plane\";i:1163;s:23:\"um-faicon-paper-plane-o\";i:1164;s:17:\"um-faicon-history\";i:1165;s:21:\"um-faicon-circle-thin\";i:1166;s:16:\"um-faicon-header\";i:1167;s:19:\"um-faicon-paragraph\";i:1168;s:17:\"um-faicon-sliders\";i:1169;s:19:\"um-faicon-share-alt\";i:1170;s:26:\"um-faicon-share-alt-square\";i:1171;s:14:\"um-faicon-bomb\";i:1172;s:18:\"um-faicon-futbol-o\";i:1173;s:13:\"um-faicon-tty\";i:1174;s:20:\"um-faicon-binoculars\";i:1175;s:14:\"um-faicon-plug\";i:1176;s:20:\"um-faicon-slideshare\";i:1177;s:16:\"um-faicon-twitch\";i:1178;s:14:\"um-faicon-yelp\";i:1179;s:21:\"um-faicon-newspaper-o\";i:1180;s:14:\"um-faicon-wifi\";i:1181;s:20:\"um-faicon-calculator\";i:1182;s:16:\"um-faicon-paypal\";i:1183;s:23:\"um-faicon-google-wallet\";i:1184;s:17:\"um-faicon-cc-visa\";i:1185;s:23:\"um-faicon-cc-mastercard\";i:1186;s:21:\"um-faicon-cc-discover\";i:1187;s:17:\"um-faicon-cc-amex\";i:1188;s:19:\"um-faicon-cc-paypal\";i:1189;s:19:\"um-faicon-cc-stripe\";i:1190;s:20:\"um-faicon-bell-slash\";i:1191;s:22:\"um-faicon-bell-slash-o\";i:1192;s:15:\"um-faicon-trash\";i:1193;s:19:\"um-faicon-copyright\";i:1194;s:12:\"um-faicon-at\";i:1195;s:20:\"um-faicon-eyedropper\";i:1196;s:21:\"um-faicon-paint-brush\";i:1197;s:23:\"um-faicon-birthday-cake\";i:1198;s:20:\"um-faicon-area-chart\";i:1199;s:19:\"um-faicon-pie-chart\";i:1200;s:20:\"um-faicon-line-chart\";i:1201;s:16:\"um-faicon-lastfm\";i:1202;s:23:\"um-faicon-lastfm-square\";i:1203;s:20:\"um-faicon-toggle-off\";i:1204;s:19:\"um-faicon-toggle-on\";i:1205;s:17:\"um-faicon-bicycle\";i:1206;s:13:\"um-faicon-bus\";i:1207;s:17:\"um-faicon-ioxhost\";i:1208;s:19:\"um-faicon-angellist\";i:1209;s:12:\"um-faicon-cc\";i:1210;s:13:\"um-faicon-ils\";i:1211;s:18:\"um-faicon-meanpath\";}","yes");
INSERT INTO `wp_options` VALUES("115669","qtranslate_next_update_mo","1429959886","yes");
INSERT INTO `wp_options` VALUES("115670","qtranslate_admin_notices","a:1:{s:26:\"survey-translation-service\";i:1429355066;}","yes");
INSERT INTO `wp_options` VALUES("115671","qtranslate_language_names","a:23:{s:2:\"de\";s:7:\"Deutsch\";s:2:\"en\";s:7:\"English\";s:2:\"zh\";s:6:\"中文\";s:2:\"ru\";s:14:\"Русский\";s:2:\"fi\";s:5:\"suomi\";s:2:\"fr\";s:9:\"Français\";s:2:\"nl\";s:10:\"Nederlands\";s:2:\"sv\";s:7:\"Svenska\";s:2:\"it\";s:8:\"Italiano\";s:2:\"ro\";s:8:\"Română\";s:2:\"hu\";s:6:\"Magyar\";s:2:\"ja\";s:9:\"日本語\";s:2:\"es\";s:8:\"Español\";s:2:\"vi\";s:14:\"Tiếng Việt\";s:2:\"ar\";s:14:\"العربية\";s:2:\"pt\";s:10:\"Português\";s:5:\"pt-br\";s:20:\"Português do Brasil\";s:2:\"pl\";s:6:\"Polski\";s:2:\"gl\";s:6:\"galego\";s:2:\"tr\";s:7:\"Turkish\";s:2:\"et\";s:5:\"Eesti\";s:2:\"hr\";s:8:\"Hrvatski\";s:2:\"eu\";s:7:\"Euskera\";}","yes");
INSERT INTO `wp_options` VALUES("115672","qtranslate_enabled_languages","a:2:{i:0;s:2:\"fr\";i:1;s:2:\"en\";}","yes");
INSERT INTO `wp_options` VALUES("115673","qtranslate_default_language","fr","yes");
INSERT INTO `wp_options` VALUES("115674","qtranslate_flags","a:23:{s:2:\"en\";s:6:\"gb.png\";s:2:\"de\";s:6:\"de.png\";s:2:\"zh\";s:6:\"cn.png\";s:2:\"ru\";s:6:\"ru.png\";s:2:\"fi\";s:6:\"fi.png\";s:2:\"fr\";s:6:\"fr.png\";s:2:\"nl\";s:6:\"nl.png\";s:2:\"sv\";s:6:\"se.png\";s:2:\"it\";s:6:\"it.png\";s:2:\"ro\";s:6:\"ro.png\";s:2:\"hu\";s:6:\"hu.png\";s:2:\"ja\";s:6:\"jp.png\";s:2:\"es\";s:6:\"es.png\";s:2:\"vi\";s:6:\"vn.png\";s:2:\"ar\";s:8:\"arle.png\";s:2:\"pt\";s:6:\"pt.png\";s:5:\"pt-br\";s:6:\"br.png\";s:2:\"pl\";s:6:\"pl.png\";s:2:\"gl\";s:10:\"galego.png\";s:2:\"tr\";s:6:\"tr.png\";s:2:\"et\";s:6:\"ee.png\";s:2:\"hr\";s:6:\"hr.png\";s:2:\"eu\";s:9:\"eu_ES.png\";}","yes");
INSERT INTO `wp_options` VALUES("115675","qtranslate_locales","a:23:{s:2:\"de\";s:5:\"de_DE\";s:2:\"en\";s:5:\"en_US\";s:2:\"zh\";s:5:\"zh_CN\";s:2:\"ru\";s:5:\"ru_RU\";s:2:\"fi\";s:5:\"fi_FI\";s:2:\"fr\";s:5:\"fr_FR\";s:2:\"nl\";s:5:\"nl_NL\";s:2:\"sv\";s:5:\"sv_SE\";s:2:\"it\";s:5:\"it_IT\";s:2:\"ro\";s:5:\"ro_RO\";s:2:\"hu\";s:5:\"hu_HU\";s:2:\"ja\";s:2:\"ja\";s:2:\"es\";s:5:\"es_ES\";s:2:\"vi\";s:2:\"vi\";s:2:\"ar\";s:2:\"ar\";s:2:\"pt\";s:5:\"pt_PT\";s:5:\"pt-br\";s:5:\"pt_BR\";s:2:\"pl\";s:5:\"pl_PL\";s:2:\"gl\";s:5:\"gl_ES\";s:2:\"tr\";s:5:\"tr_TR\";s:2:\"et\";s:5:\"et_ET\";s:2:\"hr\";s:5:\"hr_HR\";s:2:\"eu\";s:5:\"eu_ES\";}","yes");
INSERT INTO `wp_options` VALUES("115676","qtranslate_na_messages","a:23:{s:2:\"de\";s:58:\"Leider ist der Eintrag nur auf %LANG:, : und % verfügbar.\";s:2:\"en\";s:55:\"Sorry, this entry is only available in %LANG:, : and %.\";s:2:\"zh\";s:50:\"对不起，此内容只适用于%LANG:，:和%。\";s:2:\"ru\";s:84:\"Извините, этот техт доступен только в %LANG:, : и %.\";s:2:\"fi\";s:92:\"Anteeksi, mutta tämä kirjoitus on saatavana ainoastaan näillä kielillä: %LANG:, : ja %.\";s:2:\"fr\";s:65:\"Désolé, cet article est seulement disponible en %LANG:, : et %.\";s:2:\"nl\";s:78:\"Onze verontschuldigingen, dit bericht is alleen beschikbaar in %LANG:, : en %.\";s:2:\"sv\";s:66:\"Tyvärr är denna artikel enbart tillgänglig på %LANG:, : och %.\";s:2:\"it\";s:71:\"Ci spiace, ma questo articolo è disponibile soltanto in %LANG:, : e %.\";s:2:\"ro\";s:67:\"Din păcate acest articol este disponibil doar în %LANG:, : și %.\";s:2:\"hu\";s:73:\"Sajnos ennek a bejegyzésnek csak %LANG:, : és % nyelvű változata van.\";s:2:\"ja\";s:97:\"申し訳ありません、このコンテンツはただ今　%LANG:、 :と %　のみです。\";s:2:\"es\";s:68:\"Disculpa, pero esta entrada está disponible sólo en %LANG:, : y %.\";s:2:\"vi\";s:63:\"Rất tiếc, mục này chỉ tồn tại ở %LANG:, : và %.\";s:2:\"ar\";s:73:\"عفوا، هذه المدخلة موجودة فقط في %LANG:, : و %.\";s:2:\"pt\";s:64:\"Desculpe, este conteúdo só está disponível em %LANG:, : e %.\";s:5:\"pt-br\";s:70:\"Desculpe-nos, mas este texto esta apenas disponível em %LANG:, : y %.\";s:2:\"pl\";s:68:\"Przepraszamy, ten wpis jest dostępny tylko w języku %LANG:, : i %.\";s:2:\"gl\";s:66:\"Sentímolo moito, ista entrada atopase unicamente en %LANG;,: e %.\";s:2:\"tr\";s:55:\"Sorry, this entry is only available in %LANG:, : and %.\";s:2:\"et\";s:53:\"Vabandame, see kanne on saadaval ainult %LANG : ja %.\";s:2:\"hr\";s:85:\"Žao nam je, ne postoji prijevod na raspolaganju za ovaj proizvod još %LANG:, : i %.\";s:2:\"eu\";s:66:\"Sentitzen dugu, baina sarrera hau %LANG-z:, : eta % bakarrik dago.\";}","yes");
INSERT INTO `wp_options` VALUES("115677","qtranslate_date_formats","a:23:{s:2:\"en\";s:14:\"%A %B %e%q, %Y\";s:2:\"de\";s:17:\"%A, der %e. %B %Y\";s:2:\"zh\";s:5:\"%x %A\";s:2:\"ru\";s:14:\"%A %B %e%q, %Y\";s:2:\"fi\";s:8:\"%e.&m.%C\";s:2:\"fr\";s:11:\"%A %e %B %Y\";s:2:\"nl\";s:8:\"%d/%m/%y\";s:2:\"sv\";s:8:\"%Y-%m-%d\";s:2:\"it\";s:8:\"%e %B %Y\";s:2:\"ro\";s:12:\"%A, %e %B %Y\";s:2:\"hu\";s:12:\"%Y %B %e, %A\";s:2:\"ja\";s:15:\"%Y年%m月%d日\";s:2:\"es\";s:14:\"%d de %B de %Y\";s:2:\"vi\";s:8:\"%d/%m/%Y\";s:2:\"ar\";s:8:\"%d/%m/%Y\";s:2:\"pt\";s:17:\"%A,%e de %B de %Y\";s:5:\"pt-br\";s:14:\"%d de %B de %Y\";s:2:\"pl\";s:8:\"%d/%m/%y\";s:2:\"gl\";s:14:\"%d de %B de %Y\";s:2:\"tr\";s:14:\"%A %B %e%q, %Y\";s:2:\"et\";s:14:\"%A %B %e%q, %Y\";s:2:\"hr\";s:8:\"%d/%m/%Y\";s:2:\"eu\";s:12:\"%Y %B %e, %A\";}","yes");
INSERT INTO `wp_options` VALUES("115678","qtranslate_time_formats","a:23:{s:2:\"en\";s:8:\"%I:%M %p\";s:2:\"de\";s:5:\"%H:%M\";s:2:\"zh\";s:7:\"%I:%M%p\";s:2:\"ru\";s:5:\"%H:%M\";s:2:\"fi\";s:5:\"%H:%M\";s:2:\"fr\";s:5:\"%H:%M\";s:2:\"nl\";s:5:\"%H:%M\";s:2:\"sv\";s:5:\"%H:%M\";s:2:\"it\";s:5:\"%H:%M\";s:2:\"ro\";s:5:\"%H:%M\";s:2:\"hu\";s:5:\"%H:%M\";s:2:\"ja\";s:5:\"%H:%M\";s:2:\"es\";s:10:\"%H:%M hrs.\";s:2:\"vi\";s:5:\"%H:%M\";s:2:\"ar\";s:5:\"%H:%M\";s:2:\"pt\";s:5:\"%H:%M\";s:5:\"pt-br\";s:10:\"%H:%M hrs.\";s:2:\"pl\";s:5:\"%H:%M\";s:2:\"gl\";s:10:\"%H:%M hrs.\";s:2:\"tr\";s:5:\"%H:%M\";s:2:\"et\";s:5:\"%H:%M\";s:2:\"hr\";s:5:\"%H:%M\";s:2:\"eu\";s:5:\"%H:%M\";}","yes");
INSERT INTO `wp_options` VALUES("115679","qtranslate_ignore_file_types","gif,jpg,jpeg,png,pdf,swf,tif,rar,zip,7z,mpg,divx,mpeg,avi,css,js","yes");
INSERT INTO `wp_options` VALUES("115680","qtranslate_url_mode","2","yes");
INSERT INTO `wp_options` VALUES("115681","qtranslate_term_name","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("115682","qtranslate_use_strftime","3","yes");
INSERT INTO `wp_options` VALUES("115683","qtranslate_detect_browser_language","1","yes");
INSERT INTO `wp_options` VALUES("115684","qtranslate_hide_untranslated","0","yes");
INSERT INTO `wp_options` VALUES("115685","qtranslate_show_displayed_language_prefix","1","yes");
INSERT INTO `wp_options` VALUES("115686","qtranslate_auto_update_mo","1","yes");
INSERT INTO `wp_options` VALUES("115687","qtranslate_hide_default_language","1","yes");
INSERT INTO `wp_options` VALUES("115688","qtranslate_qtrans_compatibility","0","yes");
INSERT INTO `wp_options` VALUES("115689","qtranslate_use_secure_cookie","0","yes");
INSERT INTO `wp_options` VALUES("115690","qtranslate_disable_client_cookies","0","yes");
INSERT INTO `wp_options` VALUES("115691","qtranslate_header_css_on","1","yes");
INSERT INTO `wp_options` VALUES("115692","qtranslate_next_thanks","1442142291","yes");
INSERT INTO `wp_options` VALUES("116116","updraftplus_dismissedautobackup","1436652102","yes");
INSERT INTO `wp_options` VALUES("129304","_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c","1430044111","no");
INSERT INTO `wp_options` VALUES("129305","_transient_feed_66a70e9599b658d5cc038e8074597e7c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Apr 2015 17:21:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"
		
		
		
		
		
				
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Sortie de WordPress 4.2 « Powell »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/7rIEKuN8IbY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Apr 2015 17:21:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7418\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"La version 4.2 de WordPress, baptisée “Powell” en honneur du pianiste de jazz Bud Powell, est disponible en téléchargement ou via le système de mise à jour, depuis le tableau de bord votre installation de WordPress. Ses nouvelles fonctionnalités vous simplifient la communication et le partage, à l&#8217;échelle mondiale. Une manière plus simple de partager [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6947:\"<p>La version 4.2 de WordPress, baptisée “Powell” en honneur du pianiste de jazz <a href=\"https://fr.wikipedia.org/wiki/Bud_Powell\">Bud Powell</a>, est disponible en <a href=\"https://fr.wordpress.org/\">téléchargement</a> ou via le système de mise à jour, depuis le tableau de bord votre installation de WordPress. Ses nouvelles fonctionnalités vous simplifient la communication et le partage, à l&rsquo;échelle mondiale.</p>
<p><a href=\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/\"><em>Cliquer ici pour voir la vidéo.</em></a></p>
<h3><img class=\"alignright  wp-image-7419\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-press-this-2-500x416.jpg\" alt=\"4.2-press-this-2\" width=\"327\" height=\"272\" />Une manière plus simple de partager votre contenu</h3>
<p>Sélectionnez, modifiez, publiez. Découvrez le nouveau Press This, largement amélioré. Depuis le menu <a href=\"http://xavier.borderie.net/blog/wp-admin/tools.php\">Outils</a>, ajoutez Press This à la barre de favoris de votre navigateur ou la page d&rsquo;accueil de votre appareil mobile. Une fois mis en place, vous pouvez partager votre contenu en ligne à la vitesse de la lumière. Il n’a jamais été aussi facile et rapide de partager vos vidéos, vos images ou vos contenus préférés !</p>
<div class=\"col\">
<h3><img class=\"  wp-image-7420 alignright\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-characters-500x416.png\" alt=\"4.2-characters\" width=\"296\" height=\"246\" />Reconnaissance des caractères étendus</h3>
<p>L’écriture dans WordPress a été améliorée pour toutes les langues. WordPress 4.2 peut utiliser une multitude de nouveaux caractères par défaut, y compris les caractères natifs des écritures chinoises, japonaises et coréennes, ainsi que les symboles musicaux et mathématiques et les hiéroglyphes.</p>
<p>Vous n’utilisez aucun de ces caractères ? Vous pouvez malgré tout vous amuser avec — les caractères emoji sont maintenant disponibles dans WordPress ! Soyez créatifs et agrémentez votre contenu avec <img src=\"http://s.w.org/images/core/emoji/72x72/1f499.png\" alt=\"&#x1f499;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f438.png\" alt=\"&#x1f438;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f412.png\" alt=\"&#x1f412;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />, <img src=\"http://s.w.org/images/core/emoji/72x72/1f355.png\" alt=\"&#x1f355;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> ou n’importe quel autre <a href=\"https://codex.wordpress.org/Emoji\">emoji</a> !</p>
<h3><img class=\"alignright  wp-image-7421\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-theme-switcher-300x230.png\" alt=\"4.2-theme-switcher-300x230\" width=\"198\" height=\"152\" />Changez de thème dans l’outil de personnalisation</h3>
<p>Parcourez et prévisualisez vos thèmes installés avec l’outil de personnalisation. Assurez-vous que ce thème est adapté à <em>votre</em> contenu avant de l’activer sur votre site.</p>
<h3><img class=\"  wp-image-7422 alignleft\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-embeds-300x230.png\" alt=\"4.2-embeds-300x230\" width=\"198\" height=\"152\" />Encore plus contenus insérés</h3>
<p>Collez des liens vers Tumblr.com ou Kickstarter, et vous les verrez apparaître comme par magie directement dans l’éditeur. À chaque nouvelle version, votre approche de la publication et de la rédaction sont de plus en plus proches.</p>
<h3><img class=\"alignright  wp-image-7423\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/04/4.2-plugins-300x230.png\" alt=\"4.2-plugins-300x230\" width=\"203\" height=\"156\" />Mises à jour simplifiée des extensions</h3>
<p>Adieu, triste écran de chargement ; bienvenue aux mises à jour d’extensions simples et sans bavure ! Cliquez sur <em>Mettre à jour maintenant</em> et laissez la magie s’opérer.</p>
<h3>Sous le capot</h3>
<div class=\"feature-section col two-col\">
<div>
<h4>Prise en charge du codage utf8mb4</h4>
<p>Le codage de caractères de la base de données est passé de utf8 à utf8mb4, ce qui ajoute la possibilité d’utiliser tout un jeu de nouveaux caractères encodés sur 4 octets.</p>
<h4>Accessibilité de JavaScript</h4>
<p>Vous pouvez maintenant envoyer des notifications sonores aux lecteurs d&rsquo;écran avec JavaScript grâce à <code>wp.a11y.speak()</code>. Passez une chaîne en argument, et une mise à jour sera envoyée à une zone de notification ARIA en temps réel. Un système de lecture de chaine est utilisé, et en envoie une mise à jour à un espace dédié de notifications ARIA live.</p>
</div>
<div class=\"last-feature\">
<h4>Séparation des termes partagés</h4>
<p>Les termes partagés entre plusieurs taxinomies seront dissociés les uns des autres lorsque l’un d’entre eux est mis à jour. Pour en savoir plus, rendez-vous sur la page du <a href=\"https://developer.wordpress.org/plugins/taxonomy/working-with-split-terms-in-wp-4-2/\">Manuel du développeur d’extensions</a> (en anglais).</p>
<h4>Ordonnancement complexe des requêtes</h4>
<p><code>WP_Query</code>, <code>WP_Comment_Query</code> et <code>WP_User_Query</code> peuvent maintenant utiliser un ordre complexe avec les clauses nommées des requêtes méta.</p>
<h3>L&rsquo;équipe</h3>
<p>Le chef de projet de cette version était Drew Jaynes, avec l&rsquo;aide de plus de 283 contributeurs &#8212; un nouveau record ! Ils sont tous listés sur l&rsquo;<a href=\"https://wordpress.org/news/2015/04/powell/\">article original</a> (dont cet article est une traduction).</p>
<p><em>À noter pour la version française : le mot &laquo;&nbsp;tag&nbsp;&raquo; n&rsquo;est plus traduit par &laquo;&nbsp;mot-clé&nbsp;&raquo;, mais par &laquo;&nbsp;étiquette&nbsp;&raquo; !</em></p>
</div>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7rIEKuN8IbY:kosmtwYYAp4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7rIEKuN8IbY:kosmtwYYAp4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7rIEKuN8IbY:kosmtwYYAp4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/7rIEKuN8IbY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/04/24/sortie-de-wordpress-4-2-powell/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6495:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2942:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3556:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3536:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3786:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8950:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4797:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5341:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:48:\"http://feeds.feedburner.com/WordpressFrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:9:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Sat, 25 Apr 2015 22:17:37 GMT\";s:4:\"date\";s:29:\"Sat, 25 Apr 2015 22:28:31 GMT\";s:7:\"expires\";s:29:\"Sat, 25 Apr 2015 22:28:31 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:11:\"80:quic,p=1\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20150417135034\";}","no");
INSERT INTO `wp_options` VALUES("129189","_site_transient_timeout_itsec_upload_dir","1430086628","yes");
INSERT INTO `wp_options` VALUES("129190","_site_transient_itsec_upload_dir","a:6:{s:4:\"path\";s:53:\"/home/pigiste/48heures_dev/wp-content/uploads/2015/04\";s:3:\"url\";s:52:\"http://dev48h.pigiste.org/wp-content/uploads/2015/04\";s:6:\"subdir\";s:8:\"/2015/04\";s:7:\"basedir\";s:45:\"/home/pigiste/48heures_dev/wp-content/uploads\";s:7:\"baseurl\";s:44:\"http://dev48h.pigiste.org/wp-content/uploads\";s:5:\"error\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114986","duplicator_version_plugin","0.5.16","yes");
INSERT INTO `wp_options` VALUES("114287","updraft_email","","yes");
INSERT INTO `wp_options` VALUES("114288","updraft_report_warningsonly","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114289","updraft_report_wholebackup","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114290","updraft_autobackup_default","0","yes");
INSERT INTO `wp_options` VALUES("114291","updraft_delete_local","1","yes");
INSERT INTO `wp_options` VALUES("114292","updraft_debug_mode","0","yes");
INSERT INTO `wp_options` VALUES("114293","updraft_extradbs","","yes");
INSERT INTO `wp_options` VALUES("114294","updraft_backupdb_nonwp","0","yes");
INSERT INTO `wp_options` VALUES("114295","updraft_include_plugins","1","yes");
INSERT INTO `wp_options` VALUES("114296","updraft_include_themes","1","yes");
INSERT INTO `wp_options` VALUES("114297","updraft_include_uploads","1","yes");
INSERT INTO `wp_options` VALUES("114298","updraft_include_others","1","yes");
INSERT INTO `wp_options` VALUES("114299","updraft_include_wpcore","0","yes");
INSERT INTO `wp_options` VALUES("114300","updraft_include_wpcore_exclude","","yes");
INSERT INTO `wp_options` VALUES("114301","updraft_include_more","0","yes");
INSERT INTO `wp_options` VALUES("114302","updraft_include_more_path","","yes");
INSERT INTO `wp_options` VALUES("114303","updraft_include_uploads_exclude","backup*,*backups,backwpup*,wp-clone","yes");
INSERT INTO `wp_options` VALUES("114304","updraft_include_others_exclude","upgrade,cache,updraft,backup*,*backups","yes");
INSERT INTO `wp_options` VALUES("114305","updraft_starttime_files","09:22","yes");
INSERT INTO `wp_options` VALUES("114306","updraft_starttime_db","09:22","yes");
INSERT INTO `wp_options` VALUES("114307","updraft_startday_files","0","yes");
INSERT INTO `wp_options` VALUES("114308","updraft_startday_db","0","yes");
INSERT INTO `wp_options` VALUES("114322","updraft_backup_history","a:9:{i:1430000441;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-plugins.zip\";}s:12:\"plugins-size\";i:38785102;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-themes.zip\";}s:11:\"themes-size\";i:12345217;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-uploads.zip\";}s:12:\"uploads-size\";i:184542539;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-others.zip\";}s:11:\"others-size\";i:1650384;s:2:\"db\";s:60:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-db.gz\";s:7:\"db-size\";i:320516;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"f1aeeaae59b73bce23f4b5c018af504d983dee11\";s:7:\"themes0\";s:40:\"e7720e5f107acd94fba1e2a955ed8a9cd26366cf\";s:8:\"uploads0\";s:40:\"79b04ce0e3ff2c549f411d472abd8e429c080444\";s:7:\"others0\";s:40:\"1175a8d9f7a1bc2c3f17bd163189af9744b9cb26\";s:3:\"db0\";s:40:\"825914b71cc2c0b284b3b9b716e401645647254b\";}}s:5:\"nonce\";s:12:\"3a26d9ba3954\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429941044;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-25-0650_Les_48h_de_la_pige_0b5de3b0c5f2-plugins.zip\";}s:12:\"plugins-size\";i:38784518;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-25-0650_Les_48h_de_la_pige_0b5de3b0c5f2-themes.zip\";}s:11:\"themes-size\";i:12345217;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-25-0650_Les_48h_de_la_pige_0b5de3b0c5f2-uploads.zip\";}s:12:\"uploads-size\";i:184542124;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-25-0650_Les_48h_de_la_pige_0b5de3b0c5f2-others.zip\";}s:11:\"others-size\";i:1650384;s:2:\"db\";s:60:\"backup_2015-04-25-0650_Les_48h_de_la_pige_0b5de3b0c5f2-db.gz\";s:7:\"db-size\";i:325475;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"65644502582438d6d0769bc6116c258e11246204\";s:7:\"themes0\";s:40:\"e24555c0bbe5ece2514fc5114bcdf5584c63a391\";s:8:\"uploads0\";s:40:\"b0e919baee574e6a58a608f613723aeb2b1acf8c\";s:7:\"others0\";s:40:\"c9ad52384196cb0dee183e4ac8ed0e0335fa7df8\";s:3:\"db0\";s:40:\"ad3fe7f8fe9051101aab3c334bc068056c30cd90\";}}s:5:\"nonce\";s:12:\"0b5de3b0c5f2\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429825275;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-23-2241_Les_48h_de_la_pige_0216d331e9b5-plugins.zip\";}s:12:\"plugins-size\";i:38756936;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-23-2241_Les_48h_de_la_pige_0216d331e9b5-themes.zip\";}s:11:\"themes-size\";i:12345217;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-23-2241_Les_48h_de_la_pige_0216d331e9b5-uploads.zip\";}s:12:\"uploads-size\";i:184542124;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-23-2241_Les_48h_de_la_pige_0216d331e9b5-others.zip\";}s:11:\"others-size\";i:1650391;s:2:\"db\";s:60:\"backup_2015-04-23-2241_Les_48h_de_la_pige_0216d331e9b5-db.gz\";s:7:\"db-size\";i:326102;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"cbdd0874292785fa3d0d2b77c8e1c2bcceef7118\";s:7:\"themes0\";s:40:\"df124f9279134493c709389fb64e3441dc516680\";s:8:\"uploads0\";s:40:\"39f1ca7314a6b20a539b5d42f7c428e0feff9866\";s:7:\"others0\";s:40:\"44339637df639cd0918fb28c5ecf5d2b8324b035\";s:3:\"db0\";s:40:\"979e89dfb7ab542c474954e4ee425f6146e11670\";}}s:5:\"nonce\";s:12:\"0216d331e9b5\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429744635;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-23-0017_Les_48h_de_la_pige_855ebd08bc2f-plugins.zip\";}s:12:\"plugins-size\";i:39009749;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-23-0017_Les_48h_de_la_pige_855ebd08bc2f-themes.zip\";}s:11:\"themes-size\";i:12343975;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-23-0017_Les_48h_de_la_pige_855ebd08bc2f-uploads.zip\";}s:12:\"uploads-size\";i:184486346;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-23-0017_Les_48h_de_la_pige_855ebd08bc2f-others.zip\";}s:11:\"others-size\";i:1620431;s:2:\"db\";s:60:\"backup_2015-04-23-0017_Les_48h_de_la_pige_855ebd08bc2f-db.gz\";s:7:\"db-size\";i:403887;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"d7d06133eca18fe584ad368c49302bedde295cd2\";s:7:\"themes0\";s:40:\"80f401307284605f835e2783f79e137f1eb6f10e\";s:8:\"uploads0\";s:40:\"441c6f164ecab2e23ab5f224f40826dc5ab100c4\";s:7:\"others0\";s:40:\"7b828f614e2185d3e27f3a880aa3d5c535c47dfe\";s:3:\"db0\";s:40:\"f5bc442a67c3a741e93491aab7bf7666662216ad\";}}s:5:\"nonce\";s:12:\"855ebd08bc2f\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429649941;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-21-2159_Les_48h_de_la_pige_15028bc537da-plugins.zip\";}s:12:\"plugins-size\";i:39009502;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-21-2159_Les_48h_de_la_pige_15028bc537da-themes.zip\";}s:11:\"themes-size\";i:8117635;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-21-2159_Les_48h_de_la_pige_15028bc537da-uploads.zip\";}s:12:\"uploads-size\";i:178309269;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-21-2159_Les_48h_de_la_pige_15028bc537da-others.zip\";}s:11:\"others-size\";i:1599770;s:2:\"db\";s:60:\"backup_2015-04-21-2159_Les_48h_de_la_pige_15028bc537da-db.gz\";s:7:\"db-size\";i:355916;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"7e9c40ee105243c551ff196a932f8c85c5647012\";s:7:\"themes0\";s:40:\"5f821ae85f83de46e1cb62915789a6425bcfca0b\";s:8:\"uploads0\";s:40:\"c4979fd1f42afa4a3e90519a41a74f2b2404e928\";s:7:\"others0\";s:40:\"4ea946e5f63c371aa72fb1e89f2e0d3a6b5a7464\";s:3:\"db0\";s:40:\"042072116a2cc90436a1877bb28971e6af685b13\";}}s:5:\"nonce\";s:12:\"15028bc537da\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429563590;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-20-2159_Les_48h_de_la_pige_fb5a3e280f40-plugins.zip\";}s:12:\"plugins-size\";i:23719700;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-20-2159_Les_48h_de_la_pige_fb5a3e280f40-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-20-2159_Les_48h_de_la_pige_fb5a3e280f40-uploads.zip\";}s:12:\"uploads-size\";i:177746450;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-20-2159_Les_48h_de_la_pige_fb5a3e280f40-others.zip\";}s:11:\"others-size\";i:1614008;s:2:\"db\";s:60:\"backup_2015-04-20-2159_Les_48h_de_la_pige_fb5a3e280f40-db.gz\";s:7:\"db-size\";i:287981;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"610f0208075d2da24e83b9e2228198361823efc0\";s:7:\"themes0\";s:40:\"c941be996f54de48f983e6c8332e1709cdfcccab\";s:8:\"uploads0\";s:40:\"95e7276b4a7b44694e576227ef913e924ffe4a3e\";s:7:\"others0\";s:40:\"8519ae07ceacb3c513eb37fa76d851b8f7494490\";s:3:\"db0\";s:40:\"6dbb34dfb7dd62e2ea6c98a6582b6b5def2c0839\";}}s:5:\"nonce\";s:12:\"fb5a3e280f40\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429477143;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-19-2159_Les_48h_de_la_pige_268fbb26d418-plugins.zip\";}s:12:\"plugins-size\";i:23659610;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-19-2159_Les_48h_de_la_pige_268fbb26d418-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-19-2159_Les_48h_de_la_pige_268fbb26d418-uploads.zip\";}s:12:\"uploads-size\";i:177746450;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-19-2159_Les_48h_de_la_pige_268fbb26d418-others.zip\";}s:11:\"others-size\";i:1614008;s:2:\"db\";s:60:\"backup_2015-04-19-2159_Les_48h_de_la_pige_268fbb26d418-db.gz\";s:7:\"db-size\";i:215079;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"accc90f33e8e101940b2f87a0d5b82c45552d3f8\";s:7:\"themes0\";s:40:\"c8314d60826500666425c112c9124cbd00ca216a\";s:8:\"uploads0\";s:40:\"6724770d091411d0b188cd489bb00515fdeb658b\";s:7:\"others0\";s:40:\"b79fbe5e2da83eb677fdd1bd02e01535578a0651\";s:3:\"db0\";s:40:\"01804c12439defcf39b351e4d64265c1af3d8ea5\";}}s:5:\"nonce\";s:12:\"268fbb26d418\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429390897;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-18-2201_Les_48h_de_la_pige_2d977e619fd3-plugins.zip\";}s:12:\"plugins-size\";i:23659569;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-18-2201_Les_48h_de_la_pige_2d977e619fd3-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-18-2201_Les_48h_de_la_pige_2d977e619fd3-uploads.zip\";}s:12:\"uploads-size\";i:177746450;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-18-2201_Les_48h_de_la_pige_2d977e619fd3-others.zip\";}s:11:\"others-size\";i:1614008;s:2:\"db\";s:60:\"backup_2015-04-18-2201_Les_48h_de_la_pige_2d977e619fd3-db.gz\";s:7:\"db-size\";i:215141;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"ef9c835d2cf92db40cc9e0cc01a2ae992056da3f\";s:7:\"themes0\";s:40:\"5638b0ca1b8d2e7813468bd5b38171534c20ad6e\";s:8:\"uploads0\";s:40:\"f48f47f4fdd66ef1cbe4ace017c71936b5d616e1\";s:7:\"others0\";s:40:\"6b422ad9b5a3590c5a9f7d21098c793bf99a656e\";s:3:\"db0\";s:40:\"b2a69e4b419c18642a602194a83853dd1aec26ac\";}}s:5:\"nonce\";s:12:\"2d977e619fd3\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429304406;a:9:{s:12:\"plugins-size\";i:22328622;s:11:\"themes-size\";i:7796814;s:12:\"uploads-size\";i:177745588;s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-17-2200_Les_48h_de_la_pige_7be830919904-db.gz\";s:7:\"db-size\";i:3720834;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"382a0e1acb64742395bc6e3c8255ec6c336357c2\";s:7:\"themes0\";s:40:\"c04895fd897df3c9a74a2d8259addb1f49a62982\";s:8:\"uploads0\";s:40:\"bd14bf779bc2da2670f2f4d81f000a1582df37fd\";s:7:\"others0\";s:40:\"c27dc12961c7ea1e009a4de9152bb2017c10e3b1\";s:3:\"db0\";s:40:\"1908697d9833983b515eff4f8a2cd196f9d1c8de\";}}s:5:\"nonce\";s:12:\"7be830919904\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}}","yes");
INSERT INTO `wp_options` VALUES("114314","updraft_lastmessage","La sauvegarde s\'est correctement effectué et est complète (avr 25 23:22:03)","yes");
INSERT INTO `wp_options` VALUES("114315","updraftplus_unlocked_fd","1","yes");
INSERT INTO `wp_options` VALUES("114316","updraftplus_last_lock_time_fd","2015-04-25 22:20:41","yes");
INSERT INTO `wp_options` VALUES("114317","updraftplus_semaphore_fd","0","yes");
INSERT INTO `wp_options` VALUES("114344","mailusers_copy_sender","false","yes");
INSERT INTO `wp_options` VALUES("114345","mailusers_add_x_mailer_header","false","yes");
INSERT INTO `wp_options` VALUES("114346","mailusers_omit_display_names","false","yes");
INSERT INTO `wp_options` VALUES("114347","mailusers_footer","<h5 style=\"border-top: 1px solid #eee;\">Powered by <a href=\"http://wordpress.org/plugins/email-users/\">Email Users</a>.</h5>","yes");
INSERT INTO `wp_options` VALUES("114348","mailusers_debug","false","yes");
INSERT INTO `wp_options` VALUES("114349","mailusers_base64_encode","false","yes");
INSERT INTO `wp_options` VALUES("114350","mailusers_dashboard_widgets","true","yes");
INSERT INTO `wp_options` VALUES("114342","mailusers_shortcode_processing","false","yes");
INSERT INTO `wp_options` VALUES("114343","mailusers_from_sender_exclude","true","yes");
INSERT INTO `wp_options` VALUES("114321","updraftplus_semaphore_","0","yes");
INSERT INTO `wp_options` VALUES("114341","mailusers_no_role_filter","false","yes");
INSERT INTO `wp_options` VALUES("114319","updraftplus_unlocked_","1","yes");
INSERT INTO `wp_options` VALUES("114320","updraftplus_last_lock_time_","2015-04-16 20:58:50","yes");
INSERT INTO `wp_options` VALUES("114331","mailusers_default_mail_format","html","yes");
INSERT INTO `wp_options` VALUES("114332","mailusers_default_sort_users_by","none","yes");
INSERT INTO `wp_options` VALUES("114333","mailusers_max_bcc_recipients","0","yes");
INSERT INTO `wp_options` VALUES("114334","mailusers_from_sender_name_override","","yes");
INSERT INTO `wp_options` VALUES("114335","mailusers_from_sender_address_override","","yes");
INSERT INTO `wp_options` VALUES("114336","mailusers_send_bounces_to_address_override","","yes");
INSERT INTO `wp_options` VALUES("114337","mailusers_user_settings_table_rows","20","yes");
INSERT INTO `wp_options` VALUES("114338","mailusers_default_notifications","true","yes");
INSERT INTO `wp_options` VALUES("114339","mailusers_default_mass_email","true","yes");
INSERT INTO `wp_options` VALUES("114340","mailusers_default_user_control","true","yes");
INSERT INTO `wp_options` VALUES("114323","updraft_last_backup","a:5:{s:11:\"backup_time\";i:1430000441;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-plugins.zip\";}s:12:\"plugins-size\";i:38785102;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-themes.zip\";}s:11:\"themes-size\";i:12345217;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-uploads.zip\";}s:12:\"uploads-size\";i:184542539;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-others.zip\";}s:11:\"others-size\";i:1650384;s:2:\"db\";s:60:\"backup_2015-04-25-2320_Les_48h_de_la_pige_3a26d9ba3954-db.gz\";s:7:\"db-size\";i:320516;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"f1aeeaae59b73bce23f4b5c018af504d983dee11\";s:7:\"themes0\";s:40:\"e7720e5f107acd94fba1e2a955ed8a9cd26366cf\";s:8:\"uploads0\";s:40:\"79b04ce0e3ff2c549f411d472abd8e429c080444\";s:7:\"others0\";s:40:\"1175a8d9f7a1bc2c3f17bd163189af9744b9cb26\";s:3:\"db0\";s:40:\"825914b71cc2c0b284b3b9b716e401645647254b\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"3a26d9ba3954\";}","yes");
INSERT INTO `wp_options` VALUES("114330","mailusers_default_body","<p>Bonjour, </p><p>J\'aimerais attirer votre attention sur un nouvel article publi&eacute; sur le blog (voir infos ci-dessous). J\'esp&egrave;re que vous le trouverez int&eacute;ressant.</p><p>Cordialement,</p><p>%FROM_NAME%</p><hr><p><strong>%POST_TITLE%</strong></p><p>%POST_EXCERPT%</p><ul><li>Lien vers l\'article : <a href=\"%POST_URL%\">%POST_URL%</a></li><li>Lien vers %BLOG_NAME%: <a href=\"%BLOG_URL%\">%BLOG_URL%</a></li></ul>","yes");
INSERT INTO `wp_options` VALUES("114329","mailusers_default_subject","[%BLOG_NAME%] A post of interest: \"%POST_TITLE%\"","yes");
INSERT INTO `wp_options` VALUES("114397","polylang","a:13:{s:7:\"browser\";i:1;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:0;s:10:\"force_lang\";i:1;s:13:\"redirect_lang\";i:1;s:13:\"media_support\";i:1;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:2:{i:0;s:5:\"forum\";i:1;s:5:\"topic\";}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"1.7.3\";s:12:\"default_lang\";s:2:\"fr\";s:9:\"nav_menus\";a:2:{s:14:\"twentythirteen\";a:1:{s:7:\"primary\";a:1:{s:2:\"fr\";i:33;}}s:6:\"evolve\";a:1:{s:12:\"primary-menu\";a:2:{s:2:\"fr\";i:33;s:2:\"en\";i:64;}}}}","yes");
INSERT INTO `wp_options` VALUES("114328","mailusers_version","4.7.1","yes");
INSERT INTO `wp_options` VALUES("128490","_site_transient_timeout_itsec_random_version","1429980769","yes");
INSERT INTO `wp_options` VALUES("128491","_site_transient_itsec_random_version","142","yes");
INSERT INTO `wp_options` VALUES("115016","duplicator_settings","a:10:{s:7:\"version\";s:6:\"0.5.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129351","_site_transient_timeout_theme_roots","1430039300","yes");
INSERT INTO `wp_options` VALUES("129352","_site_transient_theme_roots","a:4:{s:6:\"enfold\";s:7:\"/themes\";s:6:\"evolve\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";}","yes");
INSERT INTO `wp_options` VALUES("115028","_transient_random_seed","12ac9cbb399b5bf94093750c6e160ca2","yes");
INSERT INTO `wp_options` VALUES("115041","_transient_timeout_avia_theme_latest_version","1429899012","no");
INSERT INTO `wp_options` VALUES("115042","_transient_avia_theme_latest_version","<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<notifier version=\"1.0\">
 <LatestVersion>
  <version>1.3</version>
 </LatestVersion>
 <PreviousVersions>
 </PreviousVersions>
</notifier>
","no");
INSERT INTO `wp_options` VALUES("129298","_site_transient_timeout_browser_4e23a6000876e66a7ec0dd24366f9a45","1430605707","yes");
INSERT INTO `wp_options` VALUES("129299","_site_transient_browser_4e23a6000876e66a7ec0dd24366f9a45","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129317","_transient_timeout_plugin_slugs","1430087313","no");
INSERT INTO `wp_options` VALUES("129318","_transient_plugin_slugs","a:29:{i:0;s:19:\"akismet/akismet.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:19:\"bbpress/bbpress.php\";i:3;s:43:\"broken-link-checker/broken-link-checker.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:58:\"contact-form-7-to-database-extension/contact-form-7-db.php\";i:6;s:31:\"cookie-notice/cookie-notice.php\";i:7;s:41:\"cr3ativ-conference/cr3ativ-conference.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:27:\"email-users/email-users.php\";i:10;s:33:\"events-manager/events-manager.php\";i:11;s:45:\"events-manager-email-users/em-email-users.php\";i:12;s:34:\"font-awesome-more-icons/plugin.php\";i:13;s:41:\"google-maps-widget/google-maps-widget.php\";i:14;s:42:\"better-wp-security2/better-wp-security.php\";i:15;s:43:\"leaflet-maps-marker/leaflet-maps-marker.php\";i:16;s:35:\"login-with-ajax/login-with-ajax.php\";i:17;s:33:\"nav-menu-roles/nav-menu-roles.php\";i:18;s:21:\"newsletter/plugin.php\";i:19;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:20;s:21:\"polylang/polylang.php\";i:21;s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";i:22;s:43:\"the-events-calendar/the-events-calendar.php\";i:23;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:24;s:25:\"ultimate-member/index.php\";i:25;s:27:\"updraftplus/updraftplus.php\";i:26;s:27:\"wp-optimize/wp-optimize.php\";i:27;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";i:28;s:39:\"svg-vector-icon-plugin/wp-svg-icons.php\";}","no");
INSERT INTO `wp_options` VALUES("115053","duplicator_ui_view_state","a:1:{s:14:\"dup-wpnotice01\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("115057","wsblc_options","{\"max_execution_time\":420,\"check_threshold\":72,\"recheck_count\":3,\"recheck_threshold\":1800,\"run_in_dashboard\":true,\"run_via_cron\":true,\"mark_broken_links\":true,\"broken_link_css\":\".broken_link, a.broken_link {\\n\\ttext-decoration: line-through;\\n}\",\"nofollow_broken_links\":false,\"mark_removed_links\":false,\"removed_link_css\":\".removed_link, a.removed_link {\\n\\ttext-decoration: line-through;\\n}\",\"exclusion_list\":[],\"send_email_notifications\":true,\"send_authors_email_notifications\":false,\"notification_email_address\":\"\",\"notification_schedule\":\"daily\",\"last_notification_sent\":1429941043,\"suggestions_enabled\":true,\"warnings_enabled\":true,\"server_load_limit\":7,\"enable_load_limit\":true,\"custom_fields\":[],\"enabled_post_statuses\":[\"publish\"],\"autoexpand_widget\":true,\"dashboard_widget_capability\":\"edit_others_posts\",\"show_link_count_bubble\":true,\"table_layout\":\"flexible\",\"table_compact\":true,\"table_visible_columns\":[\"new-url\",\"status\",\"used-in\",\"new-link-text\"],\"table_links_per_page\":30,\"table_color_code_status\":true,\"need_resynch\":false,\"current_db_version\":8,\"timeout\":30,\"highlight_permanent_failures\":false,\"failure_duration_threshold\":3,\"logging_enabled\":false,\"log_file\":\"\",\"custom_log_file_enabled\":false,\"installation_complete\":true,\"installation_flag_cleared_on\":\"2015-04-17T18:24:57+00:00 (1429295097.2679)\",\"installation_flag_set_on\":\"2015-04-17T18:24:57+00:00 (1429295097.3862)\",\"user_has_donated\":false,\"donation_flag_fixed\":false,\"show_link_actions\":{\"blc-deredirect-action\":false},\"first_installation_timestamp\":1429295097,\"active_modules\":{\"http\":{\"ModuleID\":\"http\",\"ModuleCategory\":\"checker\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcHttpChecker\",\"ModulePriority\":-1,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"Basic HTTP\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"Check all links that have the HTTP\\/HTTPS protocol.\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"Basic HTTP\",\"AuthorName\":\"Janis Elsts\",\"file\":\"checkers\\/http.php\"},\"link\":{\"ModuleID\":\"link\",\"ModuleCategory\":\"parser\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcHTMLLink\",\"ModulePriority\":1000,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"HTML links\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"Example : <code>&lt;a href=\\\"http:\\/\\/example.com\\/\\\"&gt;link text&lt;\\/a&gt;<\\/code>\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"HTML links\",\"AuthorName\":\"Janis Elsts\",\"file\":\"parsers\\/html_link.php\"},\"image\":{\"ModuleID\":\"image\",\"ModuleCategory\":\"parser\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcHTMLImage\",\"ModulePriority\":900,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"HTML images\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"e.g. <code>&lt;img src=\\\"http:\\/\\/example.com\\/fluffy.jpg\\\"&gt;<\\/code>\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"HTML images\",\"AuthorName\":\"Janis Elsts\",\"file\":\"parsers\\/image.php\"},\"metadata\":{\"ModuleID\":\"metadata\",\"ModuleCategory\":\"parser\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcMetadataParser\",\"ModulePriority\":0,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":true,\"ModuleAlwaysActive\":true,\"ModuleRequiresPro\":false,\"Name\":\"Metadata\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"Parses metadata (AKA custom fields)\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"Metadata\",\"AuthorName\":\"Janis Elsts\",\"file\":\"parsers\\/metadata.php\"},\"url_field\":{\"ModuleID\":\"url_field\",\"ModuleCategory\":\"parser\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcUrlField\",\"ModulePriority\":0,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":true,\"ModuleAlwaysActive\":true,\"ModuleRequiresPro\":false,\"Name\":\"URL fields\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"Parses data fields that contain a single, plaintext URL.\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"URL fields\",\"AuthorName\":\"Janis Elsts\",\"file\":\"parsers\\/url_field.php\"},\"comment\":{\"ModuleID\":\"comment\",\"ModuleCategory\":\"container\",\"ModuleContext\":\"all\",\"ModuleLazyInit\":false,\"ModuleClassName\":\"blcCommentManager\",\"ModulePriority\":0,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"Comments\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"Comments\",\"AuthorName\":\"Janis Elsts\",\"file\":\"containers\\/comment.php\"},\"post\":{\"Name\":\"Articles\",\"ModuleCategory\":\"container\",\"ModuleContext\":\"all\",\"ModuleClassName\":\"blcAnyPostContainerManager\",\"ModuleID\":\"post\",\"file\":\"\",\"ModuleLazyInit\":false,\"ModulePriority\":0,\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"TextDomain\":\"broken-link-checker\",\"virtual\":true},\"page\":{\"Name\":\"Pages\",\"ModuleCategory\":\"container\",\"ModuleContext\":\"all\",\"ModuleClassName\":\"blcAnyPostContainerManager\",\"ModuleID\":\"page\",\"file\":\"\",\"ModuleLazyInit\":false,\"ModulePriority\":0,\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"TextDomain\":\"broken-link-checker\",\"virtual\":true},\"youtube-checker\":{\"ModuleID\":\"youtube-checker\",\"ModuleCategory\":\"checker\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcYouTubeChecker\",\"ModulePriority\":100,\"ModuleCheckerUrlPattern\":\"@^https?:\\/\\/(?:([\\\\w\\\\d]+\\\\.)*youtube\\\\.[^\\/]+\\/watch\\\\?.*v=[^\\/#]|youtu\\\\.be\\/[^\\/#\\\\?]+|(?:[\\\\w\\\\d]+\\\\.)*?youtube\\\\.[^\\/]+\\/(playlist|view_play_list)\\\\?[^\\/#]{15,}?)@i\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"YouTube API\",\"PluginURI\":\"\",\"Version\":\"1.1\",\"Description\":\"Check links to YouTube videos and playlists using the YouTube API.\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"YouTube API\",\"AuthorName\":\"Janis Elsts\",\"file\":\"extras\\/youtube.php\"},\"youtube-iframe\":{\"ModuleID\":\"youtube-iframe\",\"ModuleCategory\":\"parser\",\"ModuleContext\":\"on-demand\",\"ModuleLazyInit\":true,\"ModuleClassName\":\"blcYouTubeIframe\",\"ModulePriority\":120,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":false,\"ModuleAlwaysActive\":false,\"ModuleRequiresPro\":false,\"Name\":\"Embedded YouTube videos\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"Parse embedded videos from YouTube\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"Embedded YouTube videos\",\"AuthorName\":\"Janis Elsts\",\"file\":\"extras\\/youtube-iframe.php\"},\"dummy\":{\"ModuleID\":\"dummy\",\"ModuleCategory\":\"container\",\"ModuleContext\":\"all\",\"ModuleLazyInit\":false,\"ModuleClassName\":\"blcDummyManager\",\"ModulePriority\":0,\"ModuleCheckerUrlPattern\":\"\",\"ModuleHidden\":true,\"ModuleAlwaysActive\":true,\"ModuleRequiresPro\":false,\"Name\":\"Dummy\",\"PluginURI\":\"\",\"Version\":\"1.0\",\"Description\":\"\",\"Author\":\"Janis Elsts\",\"AuthorURI\":\"\",\"TextDomain\":\"broken-link-checker\",\"DomainPath\":\"\",\"Network\":false,\"Title\":\"Dummy\",\"AuthorName\":\"Janis Elsts\",\"file\":\"containers\\/dummy.php\"}},\"module_deactivated_when\":{\"custom_field\":1429298697},\"plugin_news\":[\"Admin Menu Editor\",\"http:\\/\\/wordpress.org\\/extend\\/plugins\\/admin-menu-editor\\/\"],\"last_email\":{\"subject\":\"[Les 48h de la pige] liens cass&eacute;s trouv&eacute;s\",\"timestamp\":1429941043,\"success\":true}}","yes");
INSERT INTO `wp_options` VALUES("115058","blc_installation_log","a:63:{i:0;a:3:{i:0;i:1;i:1;s:40:\"Plugin activated at 2015-04-17 19:24:57.\";i:2;N;}i:1;a:3:{i:0;i:1;i:1;s:27:\"Installation/update begins.\";i:2;N;}i:2;a:3:{i:0;i:1;i:1;s:25:\"Upgrading the database...\";i:2;N;}i:3;a:3:{i:0;i:1;i:1;s:31:\"... SHOW TABLES (0.001 seconds)\";i:2;N;}i:4;a:3:{i:0;i:1;i:1;s:238:\" [OK] 	
	CREATE TABLE IF NOT EXISTS `wp_blc_filters` (
		`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`name` varchar(100) NOT NULL,
		`params` text NOT NULL,
		
		PRIMARY KEY (`id`)
	) DEFAULT CHARACTER SET utf8 (0.006 seconds)\";i:2;N;}i:5;a:3:{i:0;i:1;i:1;s:705:\" [OK] 
	
	CREATE TABLE IF NOT EXISTS `wp_blc_instances` (
		`instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`link_id` int(10) unsigned NOT NULL,
		`container_id` int(10) unsigned NOT NULL,
		`container_type` varchar(40) NOT NULL DEFAULT \'post\',
		`link_text` varchar(250) NOT NULL DEFAULT \'\',
		`parser_type` varchar(40) NOT NULL DEFAULT \'link\',
		`container_field` varchar(250) NOT NULL DEFAULT \'\',
		`link_context` varchar(250) NOT NULL DEFAULT \'\',
		`raw_url` text NOT NULL,
		  
		PRIMARY KEY (`instance_id`),
		KEY `link_id` (`link_id`),
		KEY `source_id` (`container_type`, `container_id`),
		KEY `parser_type` (`parser_type`)
	) DEFAULT CHARACTER SET utf8 (0.021 seconds)\";i:2;N;}i:6;a:3:{i:0;i:1;i:1;s:1471:\" [OK] 
	
	CREATE TABLE IF NOT EXISTS `wp_blc_links` (
		`link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
		`url` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
		`first_failure` datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\',
		`last_check` datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\',
		`last_success` datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\',
		`last_check_attempt` datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\',
		`check_count` int(4) unsigned NOT NULL DEFAULT \'0\',
		`final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
		`redirect_count` smallint(5) unsigned NOT NULL DEFAULT \'0\',
		`log` text NOT NULL,
		`http_code` smallint(6) NOT NULL DEFAULT \'0\',
		`status_code` varchar(100) DEFAULT \'\',
		`status_text` varchar(250) DEFAULT \'\',
		`request_duration` float NOT NULL DEFAULT \'0\',
		`timeout` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
		`broken` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
		`warning` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
		`may_recheck` tinyint(1) NOT NULL DEFAULT \'1\',
		`being_checked` tinyint(1) NOT NULL DEFAULT \'0\',

		`result_hash` varchar(200) NOT NULL DEFAULT \'\',
		`false_positive` tinyint(1) NOT NULL DEFAULT \'0\',
		`dismissed` tinyint(1) NOT NULL DEFAULT \'0\',
		
		PRIMARY KEY (`link_id`),
		KEY `url` (`url`(150)),
		KEY `final_url` (`final_url`(150)),
		KEY `http_code` (`http_code`),
		KEY `broken` (`broken`)
	) DEFAULT CHARACTER SET utf8 (0.003 seconds)\";i:2;N;}i:7;a:3:{i:0;i:1;i:1;s:380:\" [OK] 
	
	CREATE TABLE IF NOT EXISTS `wp_blc_synch` (
		`container_id` int(20) unsigned NOT NULL,
		`container_type` varchar(40) NOT NULL,
		`synched` tinyint(2) unsigned NOT NULL,
		`last_synch` datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\',
		
		PRIMARY KEY (`container_type`,`container_id`),
		KEY `synched` (`synched`)
	) DEFAULT CHARACTER SET utf8 (0.003 seconds)\";i:2;N;}i:8;a:3:{i:0;i:1;i:1;s:32:\"Schema update took 0.035 seconds\";i:2;N;}i:9;a:3:{i:0;i:1;i:1;s:24:\"Database schema updated.\";i:2;N;}i:10;a:3:{i:0;i:1;i:1;s:31:\"Database successfully upgraded.\";i:2;N;}i:11;a:3:{i:0;i:1;i:1;s:24:\"--- Total: 0.039 seconds\";i:2;N;}i:12;a:3:{i:0;i:1;i:1;s:27:\"Cleaning up the database...\";i:2;N;}i:13;a:3:{i:0;i:1;i:1;s:38:\"... Deleting invalid container records\";i:2;N;}i:14;a:3:{i:0;i:0;i:1;s:44:\"... 0 synch records deleted in 0.001 seconds\";i:2;N;}i:15;a:3:{i:0;i:1;i:1;s:35:\"... Deleting invalid link instances\";i:2;N;}i:16;a:3:{i:0;i:0;i:1;s:40:\"... 0 instances deleted in 0.001 seconds\";i:2;N;}i:17;a:3:{i:0;i:0;i:1;s:45:\"... 0 more instances deleted in 0.000 seconds\";i:2;N;}i:18;a:3:{i:0;i:1;i:1;s:27:\"... Deleting orphaned links\";i:2;N;}i:19;a:3:{i:0;i:0;i:1;s:36:\"... 0 links deleted in 0.001 seconds\";i:2;N;}i:20;a:3:{i:0;i:1;i:1;s:24:\"--- Total: 0.005 seconds\";i:2;N;}i:21;a:3:{i:0;i:1;i:1;s:20:\"Notifying modules...\";i:2;N;}i:22;a:3:{i:0;i:0;i:1;s:25:\"... Updating module cache\";i:2;N;}i:23;a:3:{i:0;i:1;i:1;s:36:\"... Cache refresh took 0.000 seconds\";i:2;N;}i:24;a:3:{i:0;i:0;i:1;s:19:\"... Loading modules\";i:2;N;}i:25;a:3:{i:0;i:1;i:1;s:37:\"... 5 modules loaded in 0.001 seconds\";i:2;N;}i:26;a:3:{i:0;i:0;i:1;s:27:\"... Notifying module \"http\"\";i:2;N;}i:27;a:3:{i:0;i:0;i:1;s:27:\"... Notifying module \"link\"\";i:2;N;}i:28;a:3:{i:0;i:0;i:1;s:28:\"... Notifying module \"image\"\";i:2;N;}i:29;a:3:{i:0;i:0;i:1;s:31:\"... Notifying module \"metadata\"\";i:2;N;}i:30;a:3:{i:0;i:0;i:1;s:32:\"... Notifying module \"url_field\"\";i:2;N;}i:31;a:3:{i:0;i:0;i:1;s:30:\"... Notifying module \"comment\"\";i:2;N;}i:32;a:3:{i:0;i:0;i:1;s:51:\"...... Deleting synch. records for removed comments\";i:2;N;}i:33;a:3:{i:0;i:0;i:1;s:38:\"...... 0 rows deleted in 0.000 seconds\";i:2;N;}i:34;a:3:{i:0;i:0;i:1;s:47:\"...... Creating synch. records for new comments\";i:2;N;}i:35;a:3:{i:0;i:0;i:1;s:39:\"...... 0 rows inserted in 0.000 seconds\";i:2;N;}i:36;a:3:{i:0;i:0;i:1;s:27:\"... Notifying module \"post\"\";i:2;N;}i:37;a:3:{i:0;i:0;i:1;s:47:\"...... Deleting synch records for removed posts\";i:2;N;}i:38;a:3:{i:0;i:0;i:1;s:207:\"DELETE synch.*
				  FROM 
					 wp_blc_synch AS synch LEFT JOIN wp_posts AS posts
					 ON posts.ID = synch.container_id
				  WHERE 
					 synch.container_type IN (\'page\', \'post\') AND posts.ID IS NULL\";i:2;N;}i:39;a:3:{i:0;i:0;i:1;s:38:\"...... 0 rows deleted in 0.000 seconds\";i:2;N;}i:40;a:3:{i:0;i:0;i:1;s:69:\"...... Deleting synch records for posts that have a disallowed status\";i:2;N;}i:41;a:3:{i:0;i:0;i:1;s:232:\"DELETE synch.*
				  FROM
					 wp_blc_synch AS synch
					 LEFT JOIN wp_posts AS posts
					 ON (synch.container_id = posts.ID and synch.container_type = posts.post_type)
				  WHERE
					 posts.post_status NOT IN (\'publish\')\";i:2;N;}i:42;a:3:{i:0;i:0;i:1;s:38:\"...... 0 rows deleted in 0.000 seconds\";i:2;N;}i:43;a:3:{i:0;i:0;i:1;s:41:\"...... Marking changed posts as unsynched\";i:2;N;}i:44;a:3:{i:0;i:0;i:1;s:227:\"UPDATE
					wp_blc_synch AS synch
					JOIN wp_posts AS posts ON (synch.container_id = posts.ID and synch.container_type=posts.post_type)
				  SET 
					synched = 0
				  WHERE
					synch.last_synch < posts.post_modified\";i:2;N;}i:45;a:3:{i:0;i:0;i:1;s:38:\"...... 0 rows updated in 0.000 seconds\";i:2;N;}i:46;a:3:{i:0;i:0;i:1;s:43:\"...... Creating synch records for new posts\";i:2;N;}i:47;a:3:{i:0;i:0;i:1;s:400:\"INSERT INTO wp_blc_synch(container_id, container_type, synched)
				  SELECT posts.id, posts.post_type, 0
				  FROM 
				    wp_posts AS posts LEFT JOIN wp_blc_synch AS synch
					ON (synch.container_id = posts.ID and synch.container_type=posts.post_type)  
				  WHERE
				  	posts.post_status IN (\'publish\')
	 				AND posts.post_type IN (\'page\', \'post\')
					AND synch.container_id IS NULL\";i:2;N;}i:48;a:3:{i:0;i:0;i:1;s:40:\"...... 14 rows inserted in 0.001 seconds\";i:2;N;}i:49;a:3:{i:0;i:0;i:1;s:27:\"... Notifying module \"page\"\";i:2;N;}i:50;a:3:{i:0;i:0;i:1;s:74:\"...... Skipping \"page\" resyncyh since all post types were already synched.\";i:2;N;}i:51;a:3:{i:0;i:0;i:1;s:38:\"... Notifying module \"youtube-checker\"\";i:2;N;}i:52;a:3:{i:0;i:0;i:1;s:37:\"... Notifying module \"youtube-iframe\"\";i:2;N;}i:53;a:3:{i:0;i:0;i:1;s:28:\"... Notifying module \"dummy\"\";i:2;N;}i:54;a:3:{i:0;i:1;i:1;s:24:\"--- Total: 0.009 seconds\";i:2;N;}i:55;a:3:{i:0;i:1;i:1;s:38:\"Updating server load limit settings...\";i:2;N;}i:56;a:3:{i:0;i:1;i:1;s:59:\"Set server load limit to 7.00. Current load average is 5.05\";i:2;N;}i:57;a:3:{i:0;i:1;i:1;s:26:\"Optimizing the database...\";i:2;N;}i:58;a:3:{i:0;i:1;i:1;s:24:\"--- Total: 0.001 seconds\";i:2;N;}i:59;a:3:{i:0;i:1;i:1;s:26:\"Completing installation...\";i:2;N;}i:60;a:3:{i:0;i:1;i:1;s:20:\"Configuration saved.\";i:2;N;}i:61;a:3:{i:0;i:1;i:1;s:78:\"Installation/update completed at 2015-04-17 19:24:57 with 24 queries executed.\";i:2;N;}i:62;a:3:{i:0;i:1;i:1;s:25:\"Total time: 0.119 seconds\";i:2;N;}}","yes");
INSERT INTO `wp_options` VALUES("122038","theme_mods_evolve","a:4:{i:0;b:0;s:12:\"header_image\";s:13:\"remove-header\";s:16:\"background_image\";s:0:\"\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:33;}}","yes");
INSERT INTO `wp_options` VALUES("117079","theme_mods_twentythirteen","a:5:{i:0;b:0;s:12:\"header_image\";s:92:\"http://dev48h.pigiste.org/wp-content/uploads/2015/03/cropped-48hVichy-juil14-bandeau1200.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:39666;s:3:\"url\";s:92:\"http://dev48h.pigiste.org/wp-content/uploads/2015/03/cropped-48hVichy-juil14-bandeau1200.jpg\";s:13:\"thumbnail_url\";s:92:\"http://dev48h.pigiste.org/wp-content/uploads/2015/03/cropped-48hVichy-juil14-bandeau1200.jpg\";s:6:\"height\";i:230;s:5:\"width\";i:1600;}s:16:\"header_textcolor\";s:6:\"ffffff\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:33;}}","yes");
INSERT INTO `wp_options` VALUES("122034","evolve","a:2:{s:2:\"id\";s:12:\"evolve-theme\";s:12:\"knownoptions\";a:1:{i:0;s:12:\"evolve-theme\";}}","yes");
INSERT INTO `wp_options` VALUES("122037","evolve-theme","a:217:{s:11:\"evl_favicon\";s:67:\"http://dev48h.pigiste.org/wp-content/uploads/2013/04/favicon-01.png\";s:10:\"evl_layout\";s:3:\"2cl\";s:16:\"evl_width_layout\";s:5:\"fluid\";s:12:\"evl_width_px\";s:4:\"1600\";s:15:\"evl_post_layout\";s:5:\"three\";s:21:\"evl_excerpt_thumbnail\";s:0:\"\";s:19:\"evl_featured_images\";s:1:\"1\";s:23:\"evl_blog_featured_image\";s:0:\"\";s:28:\"evl_thumbnail_default_images\";s:0:\"\";s:17:\"evl_author_avatar\";s:0:\"\";s:30:\"evl_posts_excerpt_title_length\";s:2:\"40\";s:15:\"evl_header_meta\";s:14:\"single_archive\";s:23:\"evl_category_page_title\";s:1:\"1\";s:14:\"evl_share_this\";s:6:\"single\";s:14:\"evl_post_links\";s:5:\"after\";s:17:\"evl_similar_posts\";s:7:\"disable\";s:19:\"evl_pagination_type\";s:10:\"pagination\";s:20:\"evl_sharing_facebook\";s:0:\"\";s:19:\"evl_sharing_twitter\";s:0:\"\";s:18:\"evl_sharing_reddit\";s:0:\"\";s:20:\"evl_sharing_linkedin\";s:0:\"\";s:18:\"evl_sharing_google\";s:0:\"\";s:18:\"evl_sharing_tumblr\";s:0:\"\";s:21:\"evl_sharing_pinterest\";s:0:\"\";s:17:\"evl_sharing_email\";s:0:\"\";s:16:\"evl_social_links\";s:1:\"1\";s:23:\"evl_social_color_scheme\";s:7:\"#999999\";s:21:\"evl_social_icons_size\";s:6:\"normal\";s:12:\"evl_show_rss\";s:1:\"1\";s:12:\"evl_rss_feed\";s:0:\"\";s:14:\"evl_newsletter\";s:0:\"\";s:12:\"evl_facebook\";s:0:\"\";s:14:\"evl_twitter_id\";s:0:\"\";s:13:\"evl_instagram\";s:0:\"\";s:9:\"evl_skype\";s:0:\"\";s:11:\"evl_youtube\";s:0:\"\";s:10:\"evl_flickr\";s:0:\"\";s:12:\"evl_linkedin\";s:0:\"\";s:14:\"evl_googleplus\";s:0:\"\";s:13:\"evl_pinterest\";s:0:\"\";s:10:\"evl_tumblr\";s:0:\"\";s:16:\"evl_header_image\";s:5:\"cover\";s:15:\"evl_header_logo\";s:68:\"http://dev48h.pigiste.org/wp-content/uploads/2014/05/marqueur-01.png\";s:12:\"evl_pos_logo\";s:4:\"left\";s:14:\"evl_blog_title\";s:0:\"\";s:15:\"evl_tagline_pos\";s:4:\"next\";s:13:\"evl_main_menu\";s:0:\"\";s:26:\"evl_main_menu_hover_effect\";s:0:\"\";s:17:\"evl_sticky_header\";s:1:\"1\";s:13:\"evl_searchbox\";s:1:\"1\";s:18:\"evl_widgets_header\";s:3:\"two\";s:28:\"evl_header_widgets_placement\";s:4:\"home\";s:15:\"evl_widgets_num\";s:5:\"three\";s:18:\"evl_footer_content\";s:237:\"<p id=\"copyright\"><span class=\"credits\"><a href=\"http://theme4press.com/evolve-multipurpose-wordpress-theme/\">evolve</a> theme by Theme4Press&nbsp;&nbsp;&bull;&nbsp;&nbsp;Powered by <a href=\"http://wordpress.org\">WordPress</a></span></p>\";s:14:\"evl_title_font\";a:4:{s:4:\"size\";s:4:\"39px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:4:\"bold\";s:5:\"color\";s:0:\"\";}s:16:\"evl_tagline_font\";a:4:{s:4:\"size\";s:4:\"13px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:7:\"#828282\";}s:13:\"evl_menu_font\";a:4:{s:4:\"size\";s:4:\"14px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:13:\"evl_post_font\";a:4:{s:4:\"size\";s:4:\"28px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:16:\"evl_content_font\";a:4:{s:4:\"size\";s:4:\"16px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:16:\"evl_heading_font\";a:4:{s:4:\"size\";s:3:\"9px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:22:\"evl_testimonials_speed\";s:0:\"\";s:25:\"evl_nofollow_social_links\";s:0:\"\";s:15:\"evl_breadcrumbs\";s:1:\"1\";s:13:\"evl_nav_links\";s:5:\"after\";s:14:\"evl_pos_button\";s:5:\"right\";s:16:\"evl_plugins_only\";s:0:\"\";s:14:\"evl_flexslider\";s:0:\"\";s:27:\"evl_parallax_slider_support\";s:1:\"1\";s:19:\"evl_carousel_slider\";s:1:\"1\";s:15:\"evl_status_gmap\";s:1:\"1\";s:14:\"evl_animatecss\";s:1:\"1\";s:13:\"evl_status_yt\";s:0:\"\";s:16:\"evl_status_vimeo\";s:0:\"\";s:16:\"evl_content_back\";s:5:\"light\";s:13:\"evl_menu_back\";s:5:\"light\";s:19:\"evl_menu_back_color\";s:0:\"\";s:21:\"evl_disable_menu_back\";s:0:\"\";s:28:\"evl_header_footer_back_color\";s:0:\"\";s:11:\"evl_pattern\";s:13:\"pattern_8.png\";s:18:\"evl_scheme_widgets\";s:7:\"#595959\";s:21:\"evl_scheme_background\";s:0:\"\";s:25:\"evl_scheme_background_100\";s:0:\"\";s:28:\"evl_scheme_background_repeat\";s:9:\"no-repeat\";s:16:\"evl_general_link\";s:7:\"#7a9cad\";s:12:\"evl_button_1\";s:0:\"\";s:12:\"evl_button_2\";s:0:\"\";s:21:\"evl_widget_background\";s:0:\"\";s:27:\"evl_widget_background_image\";s:0:\"\";s:15:\"evl_css_content\";s:0:\"\";s:19:\"evl_parallax_slider\";s:4:\"post\";s:18:\"evl_parallax_speed\";s:4:\"4000\";s:29:\"evl_parallax_slide_title_font\";a:4:{s:4:\"size\";s:4:\"36px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:28:\"evl_parallax_slide_desc_font\";a:4:{s:4:\"size\";s:4:\"18px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:15:\"evl_show_slide1\";s:0:\"\";s:14:\"evl_slide1_img\";s:87:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/parallax/6.png\";s:16:\"evl_slide1_title\";s:22:\"Super Awesome WP Theme\";s:15:\"evl_slide1_desc\";s:103:\"Absolutely free of cost theme with amazing design and premium features which will impress your visitors\";s:17:\"evl_slide1_button\";s:42:\"<a class=\"da-link\" href=\"#\">Learn more</a>\";s:15:\"evl_show_slide2\";s:0:\"\";s:14:\"evl_slide2_img\";s:0:\"\";s:16:\"evl_slide2_title\";s:32:\"Bootstrap and Font Awesome Ready\";s:15:\"evl_slide2_desc\";s:88:\"Built-in Bootstrap Elements and Font Awesome let you do amazing things with your website\";s:17:\"evl_slide2_button\";s:42:\"<a class=\"da-link\" href=\"#\">Learn more</a>\";s:15:\"evl_show_slide3\";s:0:\"\";s:14:\"evl_slide3_img\";s:87:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/parallax/4.png\";s:16:\"evl_slide3_title\";s:25:\"Easy to use control panel\";s:15:\"evl_slide3_desc\";s:80:\"Select of 500+ Google Fonts, choose layout as you need, set up your social links\";s:17:\"evl_slide3_button\";s:42:\"<a class=\"da-link\" href=\"#\">Learn more</a>\";s:15:\"evl_show_slide4\";s:0:\"\";s:14:\"evl_slide4_img\";s:87:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/parallax/1.png\";s:16:\"evl_slide4_title\";s:22:\"Fully responsive theme\";s:15:\"evl_slide4_desc\";s:74:\"Adaptive to any screen depending on the device being used to view the site\";s:17:\"evl_slide4_button\";s:42:\"<a class=\"da-link\" href=\"#\">Learn more</a>\";s:15:\"evl_show_slide5\";s:0:\"\";s:14:\"evl_slide5_img\";s:87:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/parallax/3.png\";s:16:\"evl_slide5_title\";s:23:\"Unlimited color schemes\";s:15:\"evl_slide5_desc\";s:107:\"Upload your own logo, change background color or images, select links color which you love - it\'s limitless\";s:17:\"evl_slide5_button\";s:42:\"<a class=\"da-link\" href=\"#\">Learn more</a>\";s:16:\"evl_posts_slider\";s:4:\"post\";s:16:\"evl_posts_number\";s:1:\"5\";s:24:\"evl_posts_slider_content\";s:6:\"recent\";s:19:\"evl_posts_slider_id\";s:0:\"\";s:18:\"evl_carousel_speed\";s:4:\"7000\";s:29:\"evl_carousel_slide_title_font\";a:4:{s:4:\"size\";s:4:\"36px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:28:\"evl_carousel_slide_desc_font\";a:4:{s:4:\"size\";s:4:\"18px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:22:\"evl_slideshow_autoplay\";s:0:\"\";s:19:\"evl_slideshow_speed\";s:0:\"\";s:21:\"evl_flexslider_number\";s:0:\"\";s:26:\"evl_pagination_video_slide\";s:0:\"\";s:13:\"evl_woo_items\";s:0:\"\";s:31:\"evl_woocommerce_evolve_ordering\";s:0:\"\";s:33:\"evl_woocommerce_one_page_checkout\";s:0:\"\";s:34:\"evl_woocommerce_enable_order_notes\";s:0:\"\";s:33:\"evl_woocommerce_acc_link_main_nav\";s:0:\"\";s:34:\"evl_woocommerce_cart_link_main_nav\";s:0:\"\";s:28:\"evl_woocommerce_social_links\";s:0:\"\";s:17:\"evl_woo_acc_msg_1\";s:0:\"\";s:17:\"evl_woo_acc_msg_2\";s:0:\"\";s:28:\"evl_lightbox_animation_speed\";s:0:\"\";s:20:\"evl_lightbox_gallery\";s:0:\"\";s:21:\"evl_lightbox_autoplay\";s:0:\"\";s:28:\"evl_lightbox_slideshow_speed\";s:0:\"\";s:20:\"evl_lightbox_opacity\";s:0:\"\";s:18:\"evl_lightbox_title\";s:0:\"\";s:17:\"evl_lightbox_desc\";s:0:\"\";s:19:\"evl_lightbox_social\";s:0:\"\";s:24:\"evl_lightbox_post_images\";s:0:\"\";s:13:\"evl_gmap_type\";s:6:\"hybrid\";s:14:\"evl_gmap_width\";s:4:\"100%\";s:15:\"evl_gmap_height\";s:5:\"415px\";s:16:\"evl_gmap_address\";s:37:\"11, rue du Maréchal Juin, Strasbourg\";s:21:\"evl_sent_email_header\";s:18:\"Les 48h de la pige\";s:17:\"evl_email_address\";s:0:\"\";s:18:\"evl_map_zoom_level\";s:2:\"18\";s:11:\"evl_map_pin\";s:0:\"\";s:13:\"evl_map_popup\";s:0:\"\";s:19:\"evl_map_scrollwheel\";s:0:\"\";s:13:\"evl_map_scale\";s:0:\"\";s:19:\"evl_map_zoomcontrol\";s:0:\"\";s:18:\"evl_captcha_plugin\";s:0:\"\";s:20:\"evl_recaptcha_public\";s:0:\"\";s:21:\"evl_recaptcha_private\";s:0:\"\";s:20:\"evl_bootstrap_slider\";s:8:\"homepage\";s:17:\"evl_bootstrap_100\";s:0:\"\";s:19:\"evl_bootstrap_speed\";s:4:\"7000\";s:30:\"evl_bootstrap_slide_title_font\";a:4:{s:4:\"size\";s:4:\"36px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:29:\"evl_bootstrap_slide_desc_font\";a:4:{s:4:\"size\";s:4:\"18px\";s:4:\"face\";s:6:\"Roboto\";s:5:\"style\";s:6:\"normal\";s:5:\"color\";s:0:\"\";}s:20:\"evl_bootstrap_slide1\";s:1:\"1\";s:24:\"evl_bootstrap_slide1_img\";s:90:\"http://dev48h.pigiste.org/wp-content/uploads/2015/04/48hVichy-juil14-bandeau-1200x2701.png\";s:26:\"evl_bootstrap_slide1_title\";s:24:\"Les 48 heures de la pige\";s:25:\"evl_bootstrap_slide1_desc\";s:13:\"édition 2015\";s:27:\"evl_bootstrap_slide1_button\";s:103:\"<a class=\"button\" href=\"http://dev48h.pigiste.org/fr/presentation/les-partenaires/\">Les partenaires</a>\";s:20:\"evl_bootstrap_slide2\";s:1:\"1\";s:24:\"evl_bootstrap_slide2_img\";s:73:\"http://dev48h.pigiste.org/wp-content/uploads/2015/04/BCR7711-1200x270.png\";s:26:\"evl_bootstrap_slide2_title\";s:14:\"Venez nombreux\";s:25:\"evl_bootstrap_slide2_desc\";s:12:\"A Strasbourg\";s:27:\"evl_bootstrap_slide2_button\";s:93:\"<a class=\"button\" href=\"http://dev48h.pigiste.org/fr/pratique/comment-venir/\">C\'est où ?</a>\";s:20:\"evl_bootstrap_slide3\";s:1:\"1\";s:24:\"evl_bootstrap_slide3_img\";s:86:\"http://dev48h.pigiste.org/wp-content/uploads/2015/04/cistude_romain_riols-1200x270.png\";s:26:\"evl_bootstrap_slide3_title\";s:11:\"En pratique\";s:25:\"evl_bootstrap_slide3_desc\";s:30:\"Venir, se loger, se nourrir...\";s:27:\"evl_bootstrap_slide3_button\";s:91:\"<a class=\"button\" href=\"http://dev48h.pigiste.org/fr/pratique/ou-dormir/\">On s\'organise</a>\";s:20:\"evl_bootstrap_slide4\";s:0:\"\";s:24:\"evl_bootstrap_slide4_img\";s:95:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/bootstrap-slider/4.jpg\";s:26:\"evl_bootstrap_slide4_title\";s:22:\"Fully responsive theme\";s:25:\"evl_bootstrap_slide4_desc\";s:74:\"Adaptive to any screen depending on the device being used to view the site\";s:27:\"evl_bootstrap_slide4_button\";s:41:\"<a class=\"button\" href=\"#\">Learn more</a>\";s:20:\"evl_bootstrap_slide5\";s:0:\"\";s:24:\"evl_bootstrap_slide5_img\";s:95:\"https://dev48h.pigiste.org/wp-content/themes/evolve/library/media/images/bootstrap-slider/5.jpg\";s:26:\"evl_bootstrap_slide5_title\";s:23:\"Unlimited color schemes\";s:25:\"evl_bootstrap_slide5_desc\";s:107:\"Upload your own logo, change background color or images, select links color which you love - it\'s limitless\";s:27:\"evl_bootstrap_slide5_button\";s:41:\"<a class=\"button\" href=\"#\">Learn more</a>\";s:17:\"evl_content_boxes\";s:1:\"1\";s:23:\"evl_content_box1_enable\";s:1:\"1\";s:22:\"evl_content_box1_title\";s:31:\"S‘inscrire à l’évènement\";s:21:\"evl_content_box1_icon\";s:8:\"fa-group\";s:27:\"evl_content_box1_icon_color\";s:7:\"#82a4fa\";s:21:\"evl_content_box1_desc\";s:408:\"<p style=\"text-align: justify\">Inscrivez-vous dès maintenant en ligne aux prochaines 48h de la pige. La 4e édition se tiendra à Vichy, les 2 et 3 juillet sur le campus Albert Londres. Toute l’équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l’évolutions de la presse et se positionner sur les compétences à acquérir.</p>
<br />\";s:23:\"evl_content_box1_button\";s:95:\"<a class=\"read-more btn\" href=\"http://dev48h.pigiste.org/fr/sinscrire-aux-48h/\">Inscription</a>\";s:23:\"evl_content_box2_enable\";s:1:\"1\";s:22:\"evl_content_box2_title\";s:23:\"Découvrez le programme\";s:21:\"evl_content_box2_icon\";s:11:\"fa-calendar\";s:27:\"evl_content_box2_icon_color\";s:7:\"#8fb859\";s:21:\"evl_content_box2_desc\";s:421:\"<p style=\"text-align: justify\">Découvrez et téléchargez le programme de la prochaine édition. Les prochaine 48 h proposeront aux participants un partage de la situation actuelle et l’élaboration d’une réflexion collective pour imaginer des réponses de demain. HORIZON 2030, un thème global et novateur afin d’anticiper les évolutions de la presse et de se positionner sur les compétences à acquérir.</p>\";s:23:\"evl_content_box2_button\";s:47:\"<a class=\"read-more btn\" href=\"#\">Programme</a>\";s:23:\"evl_content_box3_enable\";s:1:\"1\";s:22:\"evl_content_box3_title\";s:8:\"Pratique\";s:21:\"evl_content_box3_icon\";s:8:\"fa-gears\";s:27:\"evl_content_box3_icon_color\";s:7:\"#78665e\";s:21:\"evl_content_box3_desc\";s:402:\"<p style=\"text-align: justify\">Pour anticiper tous les aspects pratiques de votre venue à Vichy, cliquez ici ! Que vous veniez en voiture, en co-voiturage, en train ou encore à pieds, passez donc par cette rubrique afin de connaître l’indispensable sur les prochaines 48h de la pige. Un forum est à votre disposition afin de partager un transport ou encore un hébergement sur place !</p>
<br />\";s:23:\"evl_content_box3_button\";s:46:\"<a class=\"read-more btn\" href=\"#\">Pratique</a>\";s:23:\"evl_content_box4_enable\";s:0:\"\";s:22:\"evl_content_box4_title\";s:12:\"Hébergement\";s:21:\"evl_content_box4_icon\";s:7:\"fa-plug\";s:27:\"evl_content_box4_icon_color\";s:7:\"#dd9933\";s:21:\"evl_content_box4_desc\";s:0:\"\";s:23:\"evl_content_box4_button\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("125029","wp_svg_icons_enqueue_defualt_icon_pack","1","yes");
INSERT INTO `wp_options` VALUES("125030","wp_svg_icons_defualt_icon_container","h2","yes");
INSERT INTO `wp_options` VALUES("125031","wp_svg_icons_clear_all_data_on_uninstall","1","yes");
INSERT INTO `wp_options` VALUES("118237","_site_transient_browser_48ce97d67f5c394f5ce1d5ccaf049307","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("117186","um_cached_role_member","a:15:{s:4:\"core\";s:6:\"member\";s:18:\"can_access_wpadmin\";i:0;s:20:\"can_not_see_adminbar\";i:1;s:17:\"can_edit_everyone\";i:0;s:19:\"can_delete_everyone\";i:0;s:16:\"can_edit_profile\";i:1;s:18:\"can_delete_profile\";i:1;s:12:\"can_view_all\";i:1;s:24:\"can_make_private_profile\";i:0;s:26:\"can_access_private_profile\";i:0;s:16:\"default_homepage\";i:1;s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:11:\"after_login\";s:16:\"redirect_profile\";s:12:\"after_logout\";s:13:\"redirect_home\";}","yes");
INSERT INTO `wp_options` VALUES("117187","__ultimatemember_sitekey","dev48h.pigiste.org-JlQ9A5r0bsbZ2SpARTiw","yes");
INSERT INTO `wp_options` VALUES("117188","um_is_installed","1","yes");
INSERT INTO `wp_options` VALUES("117189","um_core_forms","a:3:{i:39669;i:39669;i:39670;i:39670;i:39671;i:39671;}","yes");
INSERT INTO `wp_options` VALUES("117190","um_core_directories","a:1:{i:39672;i:39672;}","yes");
INSERT INTO `wp_options` VALUES("117207","um_tracking_last_send","1429941043","yes");
INSERT INTO `wp_options` VALUES("117208","__ultimatemember_coupon_sent","1","yes");
INSERT INTO `wp_options` VALUES("117191","um_core_pages","a:7:{s:4:\"user\";i:39673;s:5:\"login\";i:39675;s:8:\"register\";i:39677;s:7:\"members\";i:39679;s:6:\"logout\";i:39681;s:7:\"account\";i:39683;s:14:\"password-reset\";i:39685;}","yes");
INSERT INTO `wp_options` VALUES("117192","um_first_setup_roles","1","yes");
INSERT INTO `wp_options` VALUES("117193","um_hashed_passwords_fix","1","yes");
INSERT INTO `wp_options` VALUES("117194","um_options","a:170:{s:8:\"last_tab\";s:0:\"\";s:12:\"default_role\";s:6:\"member\";s:14:\"permalink_base\";s:7:\"user_id\";s:12:\"display_name\";s:9:\"full_name\";s:18:\"display_name_field\";s:0:\"\";s:15:\"author_redirect\";s:1:\"0\";s:12:\"members_page\";s:1:\"1\";s:13:\"use_gravatars\";s:1:\"1\";s:24:\"reset_require_strongpass\";s:1:\"1\";s:20:\"account_tab_password\";s:1:\"1\";s:19:\"account_tab_privacy\";s:1:\"1\";s:25:\"account_tab_notifications\";s:1:\"1\";s:18:\"account_tab_delete\";s:1:\"0\";s:19:\"delete_account_text\";s:150:\"Are you sure you want to delete your account? This will erase all of your account data from the site. To delete your account enter your password below\";s:12:\"account_name\";s:1:\"1\";s:26:\"account_require_strongpass\";s:1:\"0\";s:9:\"panic_key\";s:10:\"mbsfsUGvau\";s:10:\"accessible\";s:1:\"2\";s:15:\"access_redirect\";s:47:\"http://dev48h.pigiste.org/fr/sinscrire-aux-48h/\";s:22:\"exclude_from_main_loop\";s:1:\"1\";s:24:\"exclude_from_search_loop\";s:1:\"1\";s:25:\"exclude_from_archive_loop\";s:1:\"1\";s:13:\"wpadmin_login\";s:1:\"0\";s:22:\"wpadmin_login_redirect\";s:13:\"um_login_page\";s:26:\"wpadmin_login_redirect_url\";s:0:\"\";s:16:\"wpadmin_register\";s:1:\"0\";s:25:\"wpadmin_register_redirect\";s:10:\"custom_url\";s:29:\"wpadmin_register_redirect_url\";s:47:\"http://dev48h.pigiste.org/fr/sinscrire-aux-48h/\";s:24:\"access_widget_admin_only\";s:1:\"1\";s:17:\"wpadmin_allow_ips\";s:0:\"\";s:11:\"blocked_ips\";s:0:\"\";s:14:\"blocked_emails\";s:0:\"\";s:13:\"blocked_words\";s:47:\"admin
administrator
webmaster
support
staff\";s:9:\"mail_from\";s:18:\"Les 48h de la pige\";s:14:\"mail_from_addr\";s:17:\"max.twa@gmail.com\";s:10:\"email_html\";s:1:\"0\";s:16:\"welcome_email_on\";s:1:\"1\";s:17:\"welcome_email_sub\";s:23:\"Welcome to {site_name}!\";s:13:\"welcome_email\";s:341:\"Hi {display_name},

Thank you for signing up with {site_name}! Your account is now active.

To login please visit the following url:

{login_url}

Your account e-mail: {email}
Your account username: {username}
Your account password: {password}

If you have any problems, please contact us at {admin_email}

Thanks,
{site_name}\";s:18:\"checkmail_email_on\";s:1:\"1\";s:19:\"checkmail_email_sub\";s:28:\"Please activate your account\";s:15:\"checkmail_email\";s:266:\"Hi {display_name},

Thank you for signing up with {site_name}! To activate your account, please click the link below to confirm your email address:

{account_activation_link}

If you have any problems, please contact us at {admin_email}

Thanks,
{site_name}\";s:16:\"pending_email_on\";s:1:\"1\";s:17:\"pending_email_sub\";s:30:\"Your account is pending review\";s:13:\"pending_email\";s:272:\"Hi {display_name},

Thank you for signing up with {site_name}! Your account is currently being reviewed by a member of our team.

Please allow us some time to process your request.

If you have any problems, please contact us at {admin_email}

Thanks,
{site_name}\";s:17:\"approved_email_on\";s:1:\"1\";s:18:\"approved_email_sub\";s:41:\"Your account at {site_name} is now active\";s:14:\"approved_email\";s:363:\"Hi {display_name},

Thank you for signing up with {site_name}! Your account has been approved and is now active.

To login please visit the following url:

{login_url}

Your account e-mail: {email}
Your account username: {username}
Your account password: {password}

If you have any problems, please contact us at {admin_email}

Thanks,
{site_name}\";s:17:\"rejected_email_on\";s:1:\"1\";s:18:\"rejected_email_sub\";s:30:\"Your account has been rejected\";s:14:\"rejected_email\";s:260:\"Hi {display_name},

Thank you for applying for membership to {site_name}! We have reviewed your information and unfortunately we are unable to accept you as a member at this moment.

Please feel free to apply again at a future date.

Thanks,
{site_name}\";s:17:\"inactive_email_on\";s:1:\"1\";s:18:\"inactive_email_sub\";s:33:\"Your account has been deactivated\";s:14:\"inactive_email\";s:222:\"Hi {display_name},

This is an automated email to let you know your {site_name} account has been deactivated.

If you would like your account to be reactivated please contact us at {admin_email}

Thanks,
{site_name}\";s:17:\"deletion_email_on\";s:1:\"1\";s:18:\"deletion_email_sub\";s:29:\"Your account has been deleted\";s:14:\"deletion_email\";s:332:\"Hi {display_name},

This is an automated email to let you know your {site_name} account has been deleted. All of your personal information has been permanently deleted and you will no longer be able to login to {site_name}.

If your account has been deleted by accident please contact us at {admin_email}

Thanks,
{site_name}\";s:16:\"resetpw_email_on\";s:1:\"1\";s:17:\"resetpw_email_sub\";s:19:\"Reset your password\";s:13:\"resetpw_email\";s:266:\"Hi {display_name},

We received a request to reset the password for your account. If you made this request, click the link below to change your password:

{password_reset_link}

If you didn\'t make this request, you can ignore this email

Thanks,
{site_name}\";s:18:\"changedpw_email_on\";s:1:\"1\";s:19:\"changedpw_email_sub\";s:42:\"Your {site_name} password has been changed\";s:15:\"changedpw_email\";s:279:\"Hi {display_name},

You recently changed the password associated with your {site_name} account.

If you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}

Thanks,
{site_name}\";s:11:\"admin_email\";s:17:\"max.twa@gmail.com\";s:24:\"notification_new_user_on\";s:1:\"1\";s:25:\"notification_new_user_sub\";s:30:\"[{site_name}] New user account\";s:21:\"notification_new_user\";s:187:\"{display_name} has just created an account on {site_name}. To view their profile click here:

{user_profile_link}

Here is the submitted registration form:

{submitted_registration}\";s:22:\"notification_review_on\";s:1:\"0\";s:23:\"notification_review_sub\";s:38:\"[{site_name}] New user awaiting review\";s:19:\"notification_review\";s:245:\"{display_name} has just applied for membership to {site_name} and is waiting to be reviewed.

To review this member please click the following link:

{user_profile_link}

Here is the submitted registration form:

{submitted_registration}\";s:24:\"notification_deletion_on\";s:1:\"0\";s:25:\"notification_deletion_sub\";s:29:\"[{site_name}] Account deleted\";s:21:\"notification_deletion\";s:58:\"{display_name} has just deleted their {site_name} account.\";s:22:\"profile_photo_max_size\";s:0:\"\";s:20:\"cover_photo_max_size\";s:0:\"\";s:17:\"photo_thumb_sizes\";a:3:{i:0;s:2:\"40\";i:1;s:2:\"80\";i:2;s:3:\"190\";}s:17:\"cover_thumb_sizes\";a:2:{i:0;s:3:\"300\";i:1;s:3:\"600\";}s:17:\"image_compression\";s:2:\"60\";s:15:\"image_max_width\";s:4:\"1000\";s:15:\"cover_min_width\";s:4:\"1000\";s:13:\"profile_title\";s:35:\"{display_name} | Les 48h de la pige\";s:12:\"profile_desc\";s:83:\"{display_name} is on {site_name}. Join {site_name} to view {display_name}\'s profile\";s:18:\"directory_template\";s:7:\"members\";s:12:\"active_color\";s:7:\"#3ba1da\";s:15:\"secondary_color\";s:7:\"#44b0ec\";s:17:\"primary_btn_color\";s:7:\"#3ba1da\";s:17:\"primary_btn_hover\";s:7:\"#44b0ec\";s:16:\"primary_btn_text\";s:7:\"#ffffff\";s:19:\"secondary_btn_color\";s:7:\"#eeeeee\";s:19:\"secondary_btn_hover\";s:7:\"#e5e5e5\";s:18:\"secondary_btn_text\";s:7:\"#666666\";s:14:\"help_tip_color\";s:7:\"#cccccc\";s:16:\"form_field_label\";s:7:\"#555555\";s:11:\"form_border\";s:14:\"2px solid #ddd\";s:17:\"form_border_hover\";s:14:\"2px solid #bbb\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:19:\"form_bg_color_focus\";s:7:\"#ffffff\";s:15:\"form_text_color\";s:7:\"#666666\";s:16:\"form_placeholder\";s:7:\"#aaaaaa\";s:15:\"form_icon_color\";s:7:\"#aaaaaa\";s:13:\"form_asterisk\";s:1:\"0\";s:19:\"form_asterisk_color\";s:7:\"#aaaaaa\";s:16:\"profile_template\";s:7:\"profile\";s:17:\"profile_max_width\";s:6:\"1000px\";s:22:\"profile_area_max_width\";s:5:\"600px\";s:13:\"profile_align\";s:6:\"center\";s:13:\"profile_icons\";s:5:\"label\";s:24:\"profile_primary_btn_word\";s:14:\"Update Profile\";s:21:\"profile_secondary_btn\";s:1:\"1\";s:26:\"profile_secondary_btn_word\";s:6:\"Cancel\";s:12:\"profile_role\";s:1:\"0\";s:15:\"profile_main_bg\";s:0:\"\";s:17:\"profile_header_bg\";s:0:\"\";s:14:\"default_avatar\";a:5:{s:3:\"url\";s:90:\"http://dev48h.pigiste.org/wp-content/plugins/ultimate-member/assets/img/default_avatar.jpg\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"default_cover\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:17:\"profile_photosize\";s:5:\"190px\";s:19:\"profile_photocorner\";s:1:\"1\";s:21:\"profile_cover_enabled\";s:1:\"1\";s:19:\"profile_cover_ratio\";s:5:\"2.7:1\";s:21:\"profile_show_metaicon\";s:1:\"0\";s:19:\"profile_header_text\";s:7:\"#999999\";s:25:\"profile_header_link_color\";s:7:\"#555555\";s:26:\"profile_header_link_hcolor\";s:7:\"#444444\";s:25:\"profile_header_icon_color\";s:7:\"#aaaaaa\";s:26:\"profile_header_icon_hcolor\";s:7:\"#3ba1da\";s:17:\"profile_show_name\";s:1:\"1\";s:25:\"profile_show_social_links\";s:1:\"0\";s:16:\"profile_show_bio\";s:1:\"1\";s:20:\"profile_bio_maxchars\";s:3:\"180\";s:19:\"profile_header_menu\";s:2:\"bc\";s:18:\"profile_empty_text\";s:1:\"1\";s:22:\"profile_empty_text_emo\";s:1:\"1\";s:12:\"profile_menu\";s:1:\"1\";s:16:\"profile_tab_main\";s:1:\"1\";s:17:\"profile_tab_posts\";s:1:\"1\";s:20:\"profile_tab_comments\";s:1:\"1\";s:24:\"profile_menu_default_tab\";s:4:\"main\";s:18:\"profile_menu_icons\";s:1:\"1\";s:19:\"profile_menu_counts\";s:1:\"1\";s:17:\"register_template\";s:8:\"register\";s:18:\"register_max_width\";s:5:\"450px\";s:14:\"register_align\";s:6:\"center\";s:14:\"register_icons\";s:5:\"label\";s:25:\"register_primary_btn_word\";s:8:\"Register\";s:22:\"register_secondary_btn\";s:1:\"1\";s:27:\"register_secondary_btn_word\";s:5:\"Login\";s:26:\"register_secondary_btn_url\";s:0:\"\";s:13:\"register_role\";s:1:\"0\";s:14:\"login_template\";s:5:\"login\";s:15:\"login_max_width\";s:5:\"450px\";s:11:\"login_align\";s:6:\"center\";s:11:\"login_icons\";s:5:\"label\";s:22:\"login_primary_btn_word\";s:5:\"Login\";s:19:\"login_secondary_btn\";s:1:\"1\";s:24:\"login_secondary_btn_word\";s:8:\"Register\";s:23:\"login_secondary_btn_url\";s:0:\"\";s:22:\"login_forgot_pass_link\";s:1:\"1\";s:21:\"login_show_rememberme\";s:1:\"1\";s:21:\"advanced_denied_roles\";s:0:\"\";s:14:\"enable_timebot\";s:1:\"1\";s:14:\"disable_minify\";s:1:\"0\";s:12:\"disable_menu\";s:1:\"0\";s:19:\"js_css_exlcude_home\";s:1:\"0\";s:17:\"enable_custom_css\";s:1:\"0\";s:14:\"allow_tracking\";s:1:\"1\";s:20:\"addon_multi_language\";s:0:\"\";s:24:\"addon_bp_avatar_transfer\";s:0:\"\";s:19:\"access_exclude_uris\";a:0:{}s:14:\"js_css_exclude\";a:0:{}s:14:\"js_css_include\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("117195","um_options-transients","a:2:{s:14:\"changed_values\";a:2:{s:10:\"accessible\";s:1:\"0\";s:15:\"access_redirect\";s:0:\"\";}s:9:\"last_save\";i:1429800292;}","yes");
INSERT INTO `wp_options` VALUES("117196","um_cached_role_admin","a:17:{s:4:\"role\";s:5:\"admin\";s:9:\"role_name\";s:5:\"Admin\";s:4:\"core\";s:5:\"admin\";s:18:\"can_access_wpadmin\";s:1:\"1\";s:20:\"can_not_see_adminbar\";s:1:\"0\";s:17:\"can_edit_everyone\";s:1:\"1\";s:19:\"can_delete_everyone\";s:1:\"1\";s:16:\"can_edit_profile\";s:1:\"1\";s:18:\"can_delete_profile\";s:1:\"1\";s:12:\"can_view_all\";s:1:\"1\";s:24:\"can_make_private_profile\";s:1:\"1\";s:26:\"can_access_private_profile\";s:1:\"1\";s:16:\"default_homepage\";s:1:\"1\";s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:11:\"after_login\";s:14:\"redirect_admin\";s:12:\"after_logout\";s:13:\"redirect_home\";}","yes");
INSERT INTO `wp_options` VALUES("117206","um_tracking_notice","1","yes");
INSERT INTO `wp_options` VALUES("129521","rewrite_rules","a:356:{s:15:\"(fr|en)/base/?$\";s:42:\"index.php?lang=$matches[1]&post_type=forum\";s:45:\"(fr|en)/base/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&post_type=forum&feed=$matches[2]\";s:40:\"(fr|en)/base/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&post_type=forum&feed=$matches[2]\";s:32:\"(fr|en)/base/page/([0-9]{1,})/?$\";s:60:\"index.php?lang=$matches[1]&post_type=forum&paged=$matches[2]\";s:17:\"(fr|en)/sujets/?$\";s:42:\"index.php?lang=$matches[1]&post_type=topic\";s:47:\"(fr|en)/sujets/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&post_type=topic&feed=$matches[2]\";s:42:\"(fr|en)/sujets/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&post_type=topic&feed=$matches[2]\";s:34:\"(fr|en)/sujets/page/([0-9]{1,})/?$\";s:60:\"index.php?lang=$matches[1]&post_type=topic&paged=$matches[2]\";s:34:\"fr/evenements/(\\d{4}-\\d{2}-\\d{2})$\";s:58:\"index.php?pagename=fr/evenements/&calendar_day=$matches[1]\";s:20:\"fr/evenements/rss/?$\";s:35:\"index.php?post_type=event&feed=feed\";s:21:\"fr/evenements/feed/?$\";s:35:\"index.php?post_type=event&feed=feed\";s:25:\"fr/evenements/event/(.+)$\";s:70:\"index.php?pagename=fr/evenements/&em_redirect=1&event_slug=$matches[1]\";s:28:\"fr/evenements/location/(.+)$\";s:73:\"index.php?pagename=fr/evenements/&em_redirect=1&location_slug=$matches[1]\";s:28:\"fr/evenements/category/(.+)$\";s:73:\"index.php?pagename=fr/evenements/&em_redirect=1&category_slug=$matches[1]\";s:16:\"fr/evenements/?$\";s:32:\"index.php?pagename=fr/evenements\";s:22:\"events/([^/]+)/ical/?$\";s:34:\"index.php?event=$matches[1]&ical=1\";s:25:\"locations/([^/]+)/ical/?$\";s:37:\"index.php?location=$matches[1]&ical=1\";s:33:\"events/categories/([^/]+)/ical/?$\";s:45:\"index.php?event-categories=$matches[1]&ical=1\";s:27:\"events/tags/([^/]+)/ical/?$\";s:39:\"index.php?event-tags=$matches[1]&ical=1\";s:24:\"locations/([^/]+)/rss/?$\";s:36:\"index.php?location=$matches[1]&rss=1\";s:26:\"base/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:26:\"base/sujet/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:30:\"base/répondre/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:29:\"base/mot-clé/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:53:\"base/utilisateurs/([^/]+)/sujets/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:56:\"base/utilisateurs/([^/]+)/réponses/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:54:\"base/utilisateurs/([^/]+)/favoris/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:56:\"base/utilisateurs/([^/]+)/souscrire/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:35:\"base/utilisateurs/([^/]+)/sujets/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:38:\"base/utilisateurs/([^/]+)/réponses/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:36:\"base/utilisateurs/([^/]+)/favoris/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:38:\"base/utilisateurs/([^/]+)/souscrire/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:33:\"base/utilisateurs/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:28:\"base/utilisateurs/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:47:\"base/voir-le-sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:34:\"base/voir-le-sujet/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:29:\"base/voir-le-sujet/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:36:\"base/rechercher/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:18:\"base/rechercher/?$\";s:20:\"index.php?bbp_search\";s:12:\"locations/?$\";s:28:\"index.php?post_type=location\";s:42:\"locations/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=location&feed=$matches[1]\";s:37:\"locations/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=location&feed=$matches[1]\";s:29:\"locations/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=location&paged=$matches[1]\";s:9:\"events/?$\";s:25:\"index.php?post_type=event\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:14:\"^user/([^/]*)$\";s:43:\"index.php?page_id=39673&um_user=$matches[1]\";s:17:\"^account/([^/]*)$\";s:42:\"index.php?page_id=39683&um_tab=$matches[1]\";s:55:\"(fr|en)/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[2]&feed=$matches[3]\";s:50:\"(fr|en)/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[2]&feed=$matches[3]\";s:43:\"(fr|en)/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[2]&paged=$matches[3]\";s:25:\"(fr|en)/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:52:\"(fr|en)/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[2]&feed=$matches[3]\";s:47:\"(fr|en)/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[2]&feed=$matches[3]\";s:40:\"(fr|en)/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[2]&paged=$matches[3]\";s:22:\"(fr|en)/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[2]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:53:\"(fr|en)/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:48:\"(fr|en)/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:41:\"(fr|en)/type/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&post_format=$matches[2]&paged=$matches[3]\";s:23:\"(fr|en)/type/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&post_format=$matches[2]\";s:44:\"(fr|en)/base/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:54:\"(fr|en)/base/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:74:\"(fr|en)/base/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:69:\"(fr|en)/base/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:69:\"(fr|en)/base/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:37:\"(fr|en)/base/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[2]&tb=1\";s:57:\"(fr|en)/base/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[2]&feed=$matches[3]\";s:52:\"(fr|en)/base/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[2]&feed=$matches[3]\";s:45:\"(fr|en)/base/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[2]&paged=$matches[3]\";s:52:\"(fr|en)/base/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[2]&cpage=$matches[3]\";s:37:\"(fr|en)/base/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[2]&page=$matches[3]\";s:36:\"base/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"base/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"base/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"base/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"base/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"base/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:49:\"base/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:44:\"base/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:37:\"base/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:44:\"base/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:29:\"base/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:46:\"(fr|en)/base/sujet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:56:\"(fr|en)/base/sujet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:76:\"(fr|en)/base/sujet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:71:\"(fr|en)/base/sujet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:71:\"(fr|en)/base/sujet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:39:\"(fr|en)/base/sujet/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[2]&tb=1\";s:59:\"(fr|en)/base/sujet/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[2]&feed=$matches[3]\";s:54:\"(fr|en)/base/sujet/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[2]&feed=$matches[3]\";s:47:\"(fr|en)/base/sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[2]&paged=$matches[3]\";s:54:\"(fr|en)/base/sujet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[2]&cpage=$matches[3]\";s:39:\"(fr|en)/base/sujet/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[2]&page=$matches[3]\";s:35:\"(fr|en)/base/sujet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:45:\"(fr|en)/base/sujet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:65:\"(fr|en)/base/sujet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/base/sujet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/base/sujet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:38:\"base/sujet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"base/sujet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"base/sujet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"base/sujet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"base/sujet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"base/sujet/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:51:\"base/sujet/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:46:\"base/sujet/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:39:\"base/sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:46:\"base/sujet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:31:\"base/sujet/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:27:\"base/sujet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"base/sujet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"base/sujet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"base/sujet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"base/sujet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"base/répondre/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"base/répondre/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"base/répondre/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"base/répondre/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"base/répondre/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"base/répondre/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:43:\"base/répondre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:50:\"base/répondre/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:35:\"base/répondre/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:31:\"base/répondre/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"base/répondre/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"base/répondre/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"base/répondre/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"base/répondre/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"base/mot-clé/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:49:\"base/mot-clé/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:42:\"base/mot-clé/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:24:\"base/mot-clé/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:44:\"base/rechercher/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:26:\"base/rechercher/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:60:\"cr3ativconfcategory/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?cr3ativconfcategory=$matches[1]&feed=$matches[2]\";s:55:\"cr3ativconfcategory/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?cr3ativconfcategory=$matches[1]&feed=$matches[2]\";s:48:\"cr3ativconfcategory/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?cr3ativconfcategory=$matches[1]&paged=$matches[2]\";s:30:\"cr3ativconfcategory/([^/]+)/?$\";s:41:\"index.php?cr3ativconfcategory=$matches[1]\";s:52:\"events/tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event-tags=$matches[1]&feed=$matches[2]\";s:47:\"events/tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event-tags=$matches[1]&feed=$matches[2]\";s:40:\"events/tags/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?event-tags=$matches[1]&paged=$matches[2]\";s:22:\"events/tags/([^/]+)/?$\";s:32:\"index.php?event-tags=$matches[1]\";s:56:\"events/categories/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?event-categories=$matches[1]&feed=$matches[2]\";s:51:\"events/categories/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?event-categories=$matches[1]&feed=$matches[2]\";s:44:\"events/categories/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?event-categories=$matches[1]&paged=$matches[2]\";s:26:\"events/categories/(.+?)/?$\";s:38:\"index.php?event-categories=$matches[1]\";s:37:\"locations/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"locations/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"locations/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"locations/([^/]+)/trackback/?$\";s:35:\"index.php?location=$matches[1]&tb=1\";s:50:\"locations/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?location=$matches[1]&feed=$matches[2]\";s:45:\"locations/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?location=$matches[1]&feed=$matches[2]\";s:38:\"locations/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?location=$matches[1]&paged=$matches[2]\";s:45:\"locations/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?location=$matches[1]&cpage=$matches[2]\";s:30:\"locations/([^/]+)(/[0-9]+)?/?$\";s:47:\"index.php?location=$matches[1]&page=$matches[2]\";s:26:\"locations/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"locations/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"locations/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"events/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"events/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"events/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"events/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:47:\"events/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:42:\"events/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:35:\"events/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:42:\"events/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:27:\"events/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:23:\"events/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"events/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"events/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"events-recurring/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"events-recurring/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"events-recurring/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"events-recurring/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"events-recurring/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"events-recurring/([^/]+)/trackback/?$\";s:42:\"index.php?event-recurring=$matches[1]&tb=1\";s:45:\"events-recurring/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?event-recurring=$matches[1]&paged=$matches[2]\";s:52:\"events-recurring/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?event-recurring=$matches[1]&cpage=$matches[2]\";s:37:\"events-recurring/([^/]+)(/[0-9]+)?/?$\";s:54:\"index.php?event-recurring=$matches[1]&page=$matches[2]\";s:33:\"events-recurring/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"events-recurring/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"events-recurring/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"events-recurring/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"events-recurring/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"um_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"um_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"um_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"um_form/([^/]+)/trackback/?$\";s:34:\"index.php?um_form=$matches[1]&tb=1\";s:36:\"um_form/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&paged=$matches[2]\";s:43:\"um_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&cpage=$matches[2]\";s:28:\"um_form/([^/]+)(/[0-9]+)?/?$\";s:46:\"index.php?um_form=$matches[1]&page=$matches[2]\";s:24:\"um_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"um_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"um_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"um_role/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"um_role/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"um_role/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_role/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_role/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"um_role/([^/]+)/trackback/?$\";s:34:\"index.php?um_role=$matches[1]&tb=1\";s:36:\"um_role/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?um_role=$matches[1]&paged=$matches[2]\";s:43:\"um_role/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?um_role=$matches[1]&cpage=$matches[2]\";s:28:\"um_role/([^/]+)(/[0-9]+)?/?$\";s:46:\"index.php?um_role=$matches[1]&page=$matches[2]\";s:24:\"um_role/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"um_role/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"um_role/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_role/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_role/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"um_directory/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"um_directory/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"um_directory/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"um_directory/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"um_directory/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"um_directory/([^/]+)/trackback/?$\";s:39:\"index.php?um_directory=$matches[1]&tb=1\";s:41:\"um_directory/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?um_directory=$matches[1]&paged=$matches[2]\";s:48:\"um_directory/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?um_directory=$matches[1]&cpage=$matches[2]\";s:33:\"um_directory/([^/]+)(/[0-9]+)?/?$\";s:51:\"index.php?um_directory=$matches[1]&page=$matches[2]\";s:29:\"um_directory/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"um_directory/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"um_directory/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"um_directory/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"um_directory/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"prog/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"prog/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"prog/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"prog/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"prog/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:25:\"prog/([^/]+)/trackback/?$\";s:44:\"index.php?cr3ativconference=$matches[1]&tb=1\";s:33:\"prog/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?cr3ativconference=$matches[1]&paged=$matches[2]\";s:40:\"prog/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?cr3ativconference=$matches[1]&cpage=$matches[2]\";s:25:\"prog/([^/]+)(/[0-9]+)?/?$\";s:56:\"index.php?cr3ativconference=$matches[1]&page=$matches[2]\";s:21:\"prog/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"prog/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"prog/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"prog/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"prog/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"inter/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"inter/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"inter/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"inter/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"inter/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"inter/([^/]+)/trackback/?$\";s:41:\"index.php?cr3ativspeaker=$matches[1]&tb=1\";s:34:\"inter/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?cr3ativspeaker=$matches[1]&paged=$matches[2]\";s:41:\"inter/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?cr3ativspeaker=$matches[1]&cpage=$matches[2]\";s:26:\"inter/([^/]+)(/[0-9]+)?/?$\";s:53:\"index.php?cr3ativspeaker=$matches[1]&page=$matches[2]\";s:22:\"inter/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"inter/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"inter/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"inter/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"inter/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:40:\"(fr|en)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:35:\"(fr|en)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:28:\"(fr|en)/page/?([0-9]{1,})/?$\";s:45:\"index.php?lang=$matches[1]&&paged=$matches[2]\";s:35:\"(fr|en)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?lang=$matches[1]&&page_id=1836&cpage=$matches[2]\";s:10:\"(fr|en)/?$\";s:26:\"index.php?lang=$matches[1]\";s:49:\"(fr|en)/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:44:\"(fr|en)/comments/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:52:\"(fr|en)/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:47:\"(fr|en)/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:40:\"(fr|en)/search/(.+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?lang=$matches[1]&s=$matches[2]&paged=$matches[3]\";s:22:\"(fr|en)/search/(.+)/?$\";s:40:\"index.php?lang=$matches[1]&s=$matches[2]\";s:55:\"(fr|en)/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:50:\"(fr|en)/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:43:\"(fr|en)/author/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&author_name=$matches[2]&paged=$matches[3]\";s:25:\"(fr|en)/author/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&author_name=$matches[2]\";s:77:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:72:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:65:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:98:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&paged=$matches[5]\";s:47:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:80:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]\";s:64:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:59:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:52:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:82:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&paged=$matches[4]\";s:34:\"(fr|en)/([0-9]{4})/([0-9]{1,2})/?$\";s:64:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]\";s:51:\"(fr|en)/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:46:\"(fr|en)/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:39:\"(fr|en)/([0-9]{4})/page/?([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&year=$matches[2]&paged=$matches[3]\";s:21:\"(fr|en)/([0-9]{4})/?$\";s:43:\"index.php?lang=$matches[1]&year=$matches[2]\";s:35:\"(fr|en)/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:45:\"(fr|en)/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:65:\"(fr|en)/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:28:\"(fr|en)/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[2]&tb=1\";s:48:\"(fr|en)/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[2]&feed=$matches[3]\";s:43:\"(fr|en)/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[2]&feed=$matches[3]\";s:36:\"(fr|en)/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[2]&paged=$matches[3]\";s:43:\"(fr|en)/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[2]&cpage=$matches[3]\";s:28:\"(fr|en)/(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[2]&page=$matches[3]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:35:\"(fr|en)/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:45:\"(fr|en)/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:65:\"(fr|en)/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:60:\"(fr|en)/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:28:\"(fr|en)/([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[2]&tb=1\";s:48:\"(fr|en)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[2]&feed=$matches[3]\";s:43:\"(fr|en)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[2]&feed=$matches[3]\";s:36:\"(fr|en)/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[2]&paged=$matches[3]\";s:43:\"(fr|en)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[2]&cpage=$matches[3]\";s:28:\"(fr|en)/([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[2]&page=$matches[3]\";s:24:\"(fr|en)/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[2]\";s:34:\"(fr|en)/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[2]&tb=1\";s:54:\"(fr|en)/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:49:\"(fr|en)/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[2]&feed=$matches[3]\";s:49:\"(fr|en)/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[2]&cpage=$matches[3]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO `wp_options` VALUES("117870","um_existing_rows_39669","a:1:{i:0;s:9:\"_um_row_1\";}","yes");
INSERT INTO `wp_options` VALUES("117871","um_form_rowdata_39669","a:1:{s:9:\"_um_row_1\";a:5:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"5\";s:4:\"cols\";s:9:\"2:2:1:2:1\";s:6:\"origin\";s:9:\"_um_row_1\";}}","yes");
INSERT INTO `wp_options` VALUES("118089","um_fields","a:2:{s:8:\"site_web\";a:13:{s:4:\"type\";s:3:\"url\";s:7:\"metakey\";s:8:\"site_web\";s:5:\"title\";s:8:\"Site web\";s:10:\"visibility\";s:3:\"all\";s:5:\"label\";s:8:\"Site web\";s:11:\"placeholder\";s:16:\"Faites votre pub\";s:10:\"url_target\";s:6:\"_blank\";s:7:\"url_rel\";s:6:\"follow\";s:6:\"public\";s:1:\"1\";s:8:\"required\";s:1:\"0\";s:8:\"editable\";s:1:\"1\";s:4:\"icon\";s:25:\"um-icon-ios-world-outline\";s:17:\"conditional_value\";s:1:\"0\";}s:5:\"ville\";a:9:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:5:\"Ville\";s:7:\"metakey\";s:5:\"ville\";s:10:\"visibility\";s:3:\"all\";s:5:\"label\";s:5:\"Ville\";s:6:\"public\";s:1:\"1\";s:8:\"required\";s:1:\"1\";s:8:\"editable\";s:1:\"1\";s:17:\"conditional_value\";s:1:\"0\";}}","yes");
INSERT INTO `wp_options` VALUES("125858","um_flush_rules","1","yes");
INSERT INTO `wp_options` VALUES("117926","um_existing_rows_39717","a:1:{i:0;s:9:\"_um_row_1\";}","yes");
INSERT INTO `wp_options` VALUES("117387","widget_loginwithajaxwidget","a:2:{i:2;a:6:{s:5:\"title\";s:9:\"Connexion\";s:14:\"title_loggedin\";s:18:\"Bonjour %username%\";s:8:\"remember\";s:1:\"1\";s:8:\"template\";s:7:\"default\";s:12:\"profile_link\";b:0;s:12:\"registration\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("117927","um_form_rowdata_39717","a:1:{s:9:\"_um_row_1\";a:5:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"1\";s:4:\"cols\";s:1:\"1\";s:6:\"origin\";s:9:\"_um_row_1\";}}","yes");
INSERT INTO `wp_options` VALUES("118776","su_option_custom-formatting","on","yes");
INSERT INTO `wp_options` VALUES("118777","su_option_skip","on","yes");
INSERT INTO `wp_options` VALUES("118778","su_option_prefix","su_","yes");
INSERT INTO `wp_options` VALUES("118779","su_option_hotkey","alt+i","yes");
INSERT INTO `wp_options` VALUES("118780","su_option_skin","default","yes");
INSERT INTO `wp_options` VALUES("118781","su_option_custom-css","","yes");
INSERT INTO `wp_options` VALUES("118782","sunrise_defaults_su","1","yes");
INSERT INTO `wp_options` VALUES("118380","tribe_events_calendar_options","a:10:{s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:19:\"tribeEventsTemplate\";s:0:\"\";s:21:\"tribeEventsBeforeHTML\";s:0:\"\";s:20:\"tribeEventsAfterHTML\";s:0:\"\";s:21:\"previous_ecp_versions\";a:2:{i:0;s:1:\"0\";i:1;s:5:\"3.9.1\";}s:18:\"latest_ecp_version\";s:5:\"3.9.2\";s:19:\"last-update-message\";s:5:\"3.9.1\";s:13:\"earliest_date\";s:19:\"2015-07-02 09:30:00\";s:11:\"latest_date\";s:19:\"2015-07-02 10:30:00\";s:10:\"viewOption\";s:4:\"list\";}","yes");
INSERT INTO `wp_options` VALUES("118381","tribe_events_db_version","3.0.0","yes");
INSERT INTO `wp_options` VALUES("120473","widget_polylang","a:2:{i:2;a:7:{s:5:\"title\";s:0:\"\";s:8:\"dropdown\";i:0;s:10:\"show_names\";i:1;s:10:\"show_flags\";i:1;s:10:\"force_home\";i:0;s:12:\"hide_current\";i:0;s:22:\"hide_if_no_translation\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("120357","polylang_wpml_strings","a:3:{i:0;a:5:{s:7:\"context\";s:13:\"Cookie Notice\";s:4:\"name\";s:21:\"Message in the notice\";s:6:\"string\";s:198:\"Nous utilisons des cookies pour vous garantir la meilleure expérience sur notre site. Si vous continuez à utiliser ce dernier, nous considérerons que vous acceptez l&#039;utilisation des cookies.\";s:9:\"multiline\";b:0;s:3:\"icl\";b:1;}i:1;a:5:{s:7:\"context\";s:13:\"Cookie Notice\";s:4:\"name\";s:11:\"Button text\";s:6:\"string\";s:2:\"Ok\";s:9:\"multiline\";b:0;s:3:\"icl\";b:1;}i:2;a:5:{s:7:\"context\";s:13:\"Cookie Notice\";s:4:\"name\";s:14:\"Read more text\";s:6:\"string\";s:14:\"En savoir plus\";s:9:\"multiline\";b:0;s:3:\"icl\";b:1;}}","yes");
INSERT INTO `wp_options` VALUES("129314","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1430044113","no");
INSERT INTO `wp_options` VALUES("129315","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1430000913","no");
INSERT INTO `wp_options` VALUES("129319","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1430044113","no");
INSERT INTO `wp_options` VALUES("129320","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/7rIEKuN8IbY/\'>Sortie de WordPress 4.2 « Powell »</a> <span class=\"rss-date\">24 avril 2015</span><div class=\"rssSummary\">La version 4.2 de WordPress, baptisée “Powell” en honneur du pianiste de jazz Bud Powell, est disponible en téléchargement ou via le système de mise à jour, depuis le tableau de bord votre installation de WordPress. Ses nouvelles fonctionnalités vous simplifient la communication et le partage, à l’échelle mondiale. Une manière plus simple de partager [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/6SJgIbh9aFk/\'>Sortie de WordPress 4.2 « Powell »</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/nhFl_mTTaWE/\'>La problématique des traductions officielles</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/KJsEy-lwkw0/\'>L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\' class=\'dashboard-news-plugin-link\'>Google Analytics Dashboard for WP</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=google-analytics-dashboard-for-wp&amp;_wpnonce=a774382bfc&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Google Analytics Dashboard for WP\'>Installer</a>)</span></li></ul></div>","no");
INSERT INTO `wp_options` VALUES("118383","tribe_events_suite_versions","a:1:{s:19:\"TribeEventsCalendar\";s:5:\"3.9.2\";}","yes");
INSERT INTO `wp_options` VALUES("118539","CF7DBPlugin_NoSaveFields","/.*wpcf7.*/,_wpnonce","yes");
INSERT INTO `wp_options` VALUES("118540","CF7DBPlugin__version","2.8.36","yes");
INSERT INTO `wp_options` VALUES("118541","CF7DBPlugin__installed","1","yes");
INSERT INTO `wp_options` VALUES("124902","wp_svg_icons_activation_date","1429789555","yes");
INSERT INTO `wp_options` VALUES("118773","su_installed","1429631538","yes");
INSERT INTO `wp_options` VALUES("118774","su_option_version","4.9.6","yes");
INSERT INTO `wp_options` VALUES("126228","_transient_timeout_feed_2b16a4f9a2b7110ce37a7c1a0e3bbb94","1429847299","no");
INSERT INTO `wp_options` VALUES("129300","_transient_pll_languages_list","a:2:{i:0;a:20:{s:7:\"term_id\";i:44;s:4:\"name\";s:9:\"Français\";s:4:\"slug\";s:2:\"fr\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:44;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"fr_FR\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:238;s:10:\"tl_term_id\";i:45;s:19:\"tl_term_taxonomy_id\";i:45;s:8:\"tl_count\";i:14;s:6:\"locale\";R:9;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:69:\"http://dev48h.pigiste.org/wp-content/plugins/polylang/flags/fr_FR.png\";s:4:\"flag\";s:798:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGzSURBVHjaYiyeepkBBv79+Zfnx/f379+fP38CyT9//jAyMiq5GP77wvDnJ8MfoAIGBoAAYgGqC7STApL///3/9++/pCTv////Qdz/QO4/IMna0vf/z+9/v379//37bUUTQACBNDD8Z/j87fffvyAVX79+/Q8GQDbQeKA9fM+e/Pv18/+vnwzCIkBLAAKQOAY5AIAwCEv4/4PddNUm3ji0QJyxW3rgzE0iLfqDGr2oYuu0l54AYvnz5x9Q6d+/QPQfyAQqAin9B3EOyG1A1UDj//36zfjr1y8GBoAAFI9BDgAwCMIw+P8Ho3GDO6XQ0l4MN8b2kUwYaLszqgKM/KHcDXwBxAJUD3TJ779A8h9Q5D8SAHoARP36+Rfo41+/mcA2AAQQy49ff0Cu//MPpAeI/0FdA1QNYYNVA/3wmwEYVgwMAAHE8uPHH5BqoD1//gJJLADoJKDS378Z//wFhhJAALF8A3rizz8uTmYg788fJkj4QOKREQyYxSWBhjEC/fcXZANAALF8+/anbcHlHz9+ffvx58uPX9KckkCn/gby/wLd8uvHjx96k+cD1UGiGQgAAgwA7q17ZpsMdUQAAAAASUVORK5CYII=\" title=\"Français\" alt=\"Français\" />\";s:8:\"home_url\";s:29:\"http://dev48h.pigiste.org/fr/\";s:10:\"search_url\";s:29:\"http://dev48h.pigiste.org/fr/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19724\";}i:1;a:20:{s:7:\"term_id\";i:60;s:4:\"name\";s:7:\"English\";s:4:\"slug\";s:2:\"en\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:60;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"en_GB\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:5;s:10:\"tl_term_id\";i:61;s:19:\"tl_term_taxonomy_id\";i:61;s:8:\"tl_count\";i:1;s:6:\"locale\";R:29;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:69:\"http://dev48h.pigiste.org/wp-content/plugins/polylang/flags/en_GB.png\";s:4:\"flag\";s:866:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAflJREFUeNpinDRzn5qN3uFDt16+YWBg+Pv339+KGN0rbVP+//2rW5tf0Hfy/2+mr99+yKpyOl3Ydt8njEWIn8f9zj639NC7j78eP//8739GVUUhNUNuhl8//ysKeZrJ/v7z10Zb2PTQTIY1XZO2Xmfad+f7XgkXxuUrVB6cjPVXef78JyMjA8PFuwyX7gAZj97+T2e9o3d4BWNp84K1NzubTjAB3fH0+fv6N3qP/ir9bW6ozNQCijB8/8zw/TuQ7r4/ndvN5mZgkpPXiis3Pv34+ZPh5t23//79Rwehof/9/NDEgMrOXHvJcrllgpoRN8PFOwy/fzP8+gUlgZI/f/5xcPj/69e/37//AUX+/mXRkN555gsOG2xt/5hZQMwF4r9///75++f3nz8nr75gSms82jfvQnT6zqvXPjC8e/srJQHo9P9fvwNtAHmG4f8zZ6dDc3bIyM2LTNlsbtfM9OPHH3FhtqUz3eXX9H+cOy9ZMB2o6t/Pn0DHMPz/b+2wXGTvPlPGFxdcD+mZyjP8+8MUE6sa7a/xo6Pykn1s4zdzIZ6///8zMGpKM2pKAB0jqy4UE7/msKat6Jw5mafrsxNtWZ6/fjvNLW29qv25pQd///n+5+/fxDDVbcc//P/zx/36m5Ub9zL8+7t66yEROcHK7q5bldMBAgwADcRBCuVLfoEAAAAASUVORK5CYII=\" title=\"English\" alt=\"English\" />\";s:8:\"home_url\";s:29:\"http://dev48h.pigiste.org/en/\";s:10:\"search_url\";s:29:\"http://dev48h.pigiste.org/en/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19725\";}}","yes");
INSERT INTO `wp_options` VALUES("127621","su_presets_post","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:7:{s:5:\"field\";s:12:\"post_content\";s:7:\"default\";s:0:\"\";s:6:\"before\";s:0:\"\";s:5:\"after\";s:0:\"\";s:7:\"post_id\";s:5:\"39921\";s:6:\"filter\";s:0:\"\";s:7:\"content\";s:5:\"false\";}}}","yes");
INSERT INTO `wp_options` VALUES("118886","su_presets_tabs","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:5:{s:5:\"style\";s:7:\"default\";s:6:\"active\";s:1:\"1\";s:8:\"vertical\";s:2:\"no\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:128:\"[su_tab title=\"Title 1\"]Content 1[/su_tab]
[su_tab title=\"Title 2\"]Content 2[/su_tab]
[su_tab title=\"Title 3\"]Content 3[/su_tab]\";}}}","yes");
INSERT INTO `wp_options` VALUES("118863","su_presets_list","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:4:{s:4:\"icon\";s:0:\"\";s:10:\"icon_color\";s:7:\"#333333\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:61:\"<ul>
<li>Contenu</li>
<li>Contenu</li>
<li>Contenu</li>
</ul>\";}}}","yes");
INSERT INTO `wp_options` VALUES("118904","su_presets_service","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Sur place\";s:4:\"icon\";s:10:\"icon: home\";s:10:\"icon_color\";s:7:\"#333333\";s:4:\"size\";s:2:\"32\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:245:\"Les 48h se dérouleront à Strasbourg, dans les locaux du Cuej (Centre Universitaire d’Enseignement du Journalisme) situé 11, rue du Maréchal Juin, à proximité de l’arrêt de tramway Esplanade, sur les lignes C (reliée à la gare) et E.\";}}}","yes");
INSERT INTO `wp_options` VALUES("119506","leafletmapsmarker_options","a:594:{s:16:\"standard_basemap\";s:10:\"osm_mapnik\";s:31:\"default_basemap_name_osm_mapnik\";s:13:\"OpenStreetMap\";s:33:\"default_basemap_name_mapquest_osm\";s:14:\"Mapquest (OSM)\";s:36:\"default_basemap_name_mapquest_aerial\";s:17:\"Mapquest (Aerial)\";s:40:\"default_basemap_name_googleLayer_roadmap\";s:21:\"Google Maps (Routier)\";s:42:\"default_basemap_name_googleLayer_satellite\";s:23:\"Google Maps (Satellite)\";s:39:\"default_basemap_name_googleLayer_hybrid\";s:21:\"Google Maps (Hybride)\";s:40:\"default_basemap_name_googleLayer_terrain\";s:21:\"Google Maps (Terrain)\";s:31:\"default_basemap_name_bingaerial\";s:26:\"Carte Bing (vue aérienne)\";s:41:\"default_basemap_name_bingaerialwithlabels\";s:36:\"Carte Bing (vue aérienne et textes)\";s:29:\"default_basemap_name_bingroad\";s:18:\"Carte Bing (route)\";s:36:\"default_basemap_name_ogdwien_basemap\";s:18:\"OGD Vienna basemap\";s:38:\"default_basemap_name_ogdwien_satellite\";s:20:\"OGD Vienna satellite\";s:11:\"mapbox_name\";s:22:\"Blue Marble Topography\";s:12:\"mapbox2_name\";s:15:\"Geography Class\";s:12:\"mapbox3_name\";s:15:\"Natural Earth I\";s:19:\"custom_basemap_name\";s:14:\"Open Cycle Map\";s:20:\"custom_basemap2_name\";s:17:\"Stamen Watercolor\";s:20:\"custom_basemap3_name\";s:13:\"Transport Map\";s:18:\"empty_basemap_name\";s:13:\"empty basemap\";s:21:\"controlbox_osm_mapnik\";i:1;s:23:\"controlbox_mapquest_osm\";i:1;s:26:\"controlbox_mapquest_aerial\";i:1;s:30:\"controlbox_googleLayer_roadmap\";i:1;s:32:\"controlbox_googleLayer_satellite\";i:1;s:29:\"controlbox_googleLayer_hybrid\";i:1;s:30:\"controlbox_googleLayer_terrain\";i:1;s:21:\"controlbox_bingaerial\";i:0;s:31:\"controlbox_bingaerialwithlabels\";i:0;s:19:\"controlbox_bingroad\";i:0;s:26:\"controlbox_ogdwien_basemap\";i:0;s:28:\"controlbox_ogdwien_satellite\";i:0;s:17:\"controlbox_mapbox\";i:0;s:18:\"controlbox_mapbox2\";i:0;s:18:\"controlbox_mapbox3\";i:0;s:25:\"controlbox_custom_basemap\";i:1;s:26:\"controlbox_custom_basemap2\";i:1;s:26:\"controlbox_custom_basemap3\";i:1;s:24:\"controlbox_empty_basemap\";i:0;s:19:\"defaults_marker_lat\";s:9:\"48.216038\";s:19:\"defaults_marker_lon\";s:9:\"16.378984\";s:20:\"defaults_marker_zoom\";s:2:\"11\";s:24:\"defaults_marker_mapwidth\";s:3:\"640\";s:28:\"defaults_marker_mapwidthunit\";s:2:\"px\";s:25:\"defaults_marker_mapheight\";s:3:\"480\";s:29:\"defaults_marker_default_layer\";s:1:\"0\";s:25:\"defaults_marker_openpopup\";s:1:\"0\";s:26:\"defaults_marker_controlbox\";s:1:\"1\";s:38:\"defaults_marker_overlays_custom_active\";i:0;s:39:\"defaults_marker_overlays_custom2_active\";i:0;s:39:\"defaults_marker_overlays_custom3_active\";i:0;s:39:\"defaults_marker_overlays_custom4_active\";i:0;s:21:\"defaults_marker_panel\";s:1:\"1\";s:32:\"defaults_marker_panel_directions\";i:1;s:25:\"defaults_marker_panel_kml\";i:1;s:32:\"defaults_marker_panel_fullscreen\";i:1;s:29:\"defaults_marker_panel_qr_code\";i:1;s:29:\"defaults_marker_panel_geojson\";i:1;s:28:\"defaults_marker_panel_georss\";i:1;s:30:\"defaults_marker_panel_wikitude\";i:0;s:38:\"defaults_marker_panel_background_color\";s:7:\"#efefef\";s:35:\"defaults_marker_panel_paneltext_css\";s:31:\"font-weight:bold;color:#373737;\";s:26:\"defaults_marker_wms_active\";i:0;s:27:\"defaults_marker_wms2_active\";i:0;s:27:\"defaults_marker_wms3_active\";i:0;s:27:\"defaults_marker_wms4_active\";i:0;s:27:\"defaults_marker_wms5_active\";i:0;s:27:\"defaults_marker_wms6_active\";i:0;s:27:\"defaults_marker_wms7_active\";i:0;s:27:\"defaults_marker_wms8_active\";i:0;s:27:\"defaults_marker_wms9_active\";i:0;s:28:\"defaults_marker_wms10_active\";i:0;s:20:\"defaults_marker_icon\";s:0:\"\";s:38:\"defaults_marker_icon_shadow_url_status\";s:7:\"default\";s:31:\"defaults_marker_icon_shadow_url\";s:102:\"http://dev48h.pigiste.org/wp-content/plugins/leaflet-maps-marker/leaflet-dist/images/marker-shadow.png\";s:26:\"defaults_marker_icon_title\";s:4:\"show\";s:28:\"defaults_marker_icon_opacity\";s:3:\"1.0\";s:31:\"defaults_marker_icon_iconsize_x\";s:2:\"32\";s:31:\"defaults_marker_icon_iconsize_y\";s:2:\"37\";s:33:\"defaults_marker_icon_iconanchor_x\";s:2:\"17\";s:33:\"defaults_marker_icon_iconanchor_y\";s:2:\"36\";s:34:\"defaults_marker_icon_popupanchor_x\";s:2:\"-1\";s:34:\"defaults_marker_icon_popupanchor_y\";s:3:\"-32\";s:33:\"defaults_marker_icon_shadowsize_x\";s:2:\"41\";s:33:\"defaults_marker_icon_shadowsize_y\";s:2:\"41\";s:35:\"defaults_marker_icon_shadowanchor_x\";s:2:\"16\";s:35:\"defaults_marker_icon_shadowanchor_y\";s:2:\"43\";s:31:\"defaults_marker_popups_maxwidth\";s:3:\"300\";s:31:\"defaults_marker_popups_minwidth\";s:3:\"250\";s:32:\"defaults_marker_popups_maxheight\";s:3:\"160\";s:32:\"defaults_marker_popups_image_css\";s:63:\"max-width:234px !important; height:auto; width:auto !important;\";s:30:\"defaults_marker_popups_autopan\";s:4:\"true\";s:34:\"defaults_marker_popups_closebutton\";s:4:\"true\";s:39:\"defaults_marker_popups_autopanpadding_x\";s:1:\"5\";s:39:\"defaults_marker_popups_autopanpadding_y\";s:1:\"5\";s:33:\"defaults_marker_shortcode_basemap\";s:10:\"osm_mapnik\";s:30:\"defaults_marker_shortcode_zoom\";s:2:\"11\";s:34:\"defaults_marker_shortcode_mapwidth\";s:3:\"640\";s:38:\"defaults_marker_shortcode_mapwidthunit\";s:2:\"px\";s:35:\"defaults_marker_shortcode_mapheight\";s:3:\"480\";s:36:\"defaults_marker_shortcode_controlbox\";s:1:\"1\";s:48:\"defaults_marker_shortcode_overlays_custom_active\";i:0;s:49:\"defaults_marker_shortcode_overlays_custom2_active\";i:0;s:49:\"defaults_marker_shortcode_overlays_custom3_active\";i:0;s:49:\"defaults_marker_shortcode_overlays_custom4_active\";i:0;s:36:\"defaults_marker_shortcode_wms_active\";i:0;s:37:\"defaults_marker_shortcode_wms2_active\";i:0;s:37:\"defaults_marker_shortcode_wms3_active\";i:0;s:37:\"defaults_marker_shortcode_wms4_active\";i:0;s:37:\"defaults_marker_shortcode_wms5_active\";i:0;s:37:\"defaults_marker_shortcode_wms6_active\";i:0;s:37:\"defaults_marker_shortcode_wms7_active\";i:0;s:37:\"defaults_marker_shortcode_wms8_active\";i:0;s:37:\"defaults_marker_shortcode_wms9_active\";i:0;s:38:\"defaults_marker_shortcode_wms10_active\";i:0;s:18:\"defaults_layer_lat\";s:9:\"48.216038\";s:18:\"defaults_layer_lon\";s:9:\"16.378984\";s:19:\"defaults_layer_zoom\";s:2:\"11\";s:23:\"defaults_layer_mapwidth\";s:3:\"640\";s:27:\"defaults_layer_mapwidthunit\";s:2:\"px\";s:24:\"defaults_layer_mapheight\";s:3:\"480\";s:25:\"defaults_layer_controlbox\";s:1:\"1\";s:37:\"defaults_layer_overlays_custom_active\";i:0;s:38:\"defaults_layer_overlays_custom2_active\";i:0;s:38:\"defaults_layer_overlays_custom3_active\";i:0;s:38:\"defaults_layer_overlays_custom4_active\";i:0;s:20:\"defaults_layer_panel\";s:1:\"1\";s:24:\"defaults_layer_panel_kml\";i:1;s:31:\"defaults_layer_panel_fullscreen\";i:1;s:28:\"defaults_layer_panel_qr_code\";i:1;s:28:\"defaults_layer_panel_geojson\";i:1;s:27:\"defaults_layer_panel_georss\";i:1;s:29:\"defaults_layer_panel_wikitude\";i:0;s:37:\"defaults_layer_panel_background_color\";s:7:\"#efefef\";s:34:\"defaults_layer_panel_paneltext_css\";s:31:\"font-weight:bold;color:#373737;\";s:25:\"defaults_layer_wms_active\";i:0;s:26:\"defaults_layer_wms2_active\";i:0;s:26:\"defaults_layer_wms3_active\";i:0;s:26:\"defaults_layer_wms4_active\";i:0;s:26:\"defaults_layer_wms5_active\";i:0;s:26:\"defaults_layer_wms6_active\";i:0;s:26:\"defaults_layer_wms7_active\";i:0;s:26:\"defaults_layer_wms8_active\";i:0;s:26:\"defaults_layer_wms9_active\";i:0;s:27:\"defaults_layer_wms10_active\";i:0;s:26:\"defaults_layer_listmarkers\";s:1:\"1\";s:36:\"defaults_layer_listmarkers_show_icon\";i:1;s:42:\"defaults_layer_listmarkers_show_markername\";i:1;s:41:\"defaults_layer_listmarkers_show_popuptext\";i:1;s:39:\"defaults_layer_listmarkers_show_address\";i:1;s:35:\"defaults_layer_listmarkers_order_by\";s:4:\"m.id\";s:37:\"defaults_layer_listmarkers_sort_order\";s:3:\"ASC\";s:32:\"defaults_layer_listmarkers_limit\";s:3:\"100\";s:41:\"defaults_layer_listmarkers_api_directions\";i:1;s:34:\"defaults_layer_listmarkers_api_kml\";i:1;s:41:\"defaults_layer_listmarkers_api_fullscreen\";i:1;s:38:\"defaults_layer_listmarkers_api_qr_code\";i:0;s:38:\"defaults_layer_listmarkers_api_geojson\";i:0;s:37:\"defaults_layer_listmarkers_api_georss\";i:0;s:39:\"defaults_layer_listmarkers_api_wikitude\";i:0;s:17:\"misc_map_dragging\";s:4:\"true\";s:18:\"misc_map_touchzoom\";s:4:\"true\";s:24:\"misc_map_scrollwheelzoom\";s:4:\"true\";s:24:\"misc_map_doubleclickzoom\";s:4:\"true\";s:31:\"map_interaction_options_boxzoom\";s:4:\"true\";s:20:\"misc_map_trackresize\";s:4:\"true\";s:37:\"map_interaction_options_worldcopyjump\";s:4:\"true\";s:26:\"misc_map_closepopuponclick\";s:4:\"true\";s:21:\"misc_map_osm_editlink\";s:4:\"show\";s:28:\"misc_map_osm_editlink_editor\";s:2:\"id\";s:40:\"map_keyboard_navigation_options_keyboard\";s:4:\"true\";s:49:\"map_keyboard_navigation_options_keyboardpanoffset\";s:2:\"80\";s:50:\"map_keyboard_navigation_options_keyboardzoomoffset\";s:1:\"1\";s:35:\"map_panning_inertia_options_inertia\";s:4:\"true\";s:47:\"map_panning_inertia_options_inertiadeceleration\";s:4:\"3000\";s:43:\"map_panning_inertia_options_inertiamaxspeed\";s:4:\"1500\";s:20:\"misc_map_zoomcontrol\";s:4:\"true\";s:17:\"map_scale_control\";s:7:\"enabled\";s:26:\"map_scale_control_position\";s:10:\"bottomleft\";s:26:\"map_scale_control_maxwidth\";s:3:\"100\";s:24:\"map_scale_control_metric\";s:4:\"true\";s:26:\"map_scale_control_imperial\";s:4:\"true\";s:32:\"map_scale_control_updatewhenidle\";s:5:\"false\";s:20:\"map_retina_detection\";s:4:\"true\";s:11:\"mapbox_user\";s:6:\"mapbox\";s:10:\"mapbox_map\";s:20:\"blue-marble-topo-jul\";s:14:\"mapbox_minzoom\";s:1:\"0\";s:14:\"mapbox_maxzoom\";s:1:\"8\";s:18:\"mapbox_attribution\";s:106:\"MapBox/NASA, <a href=&quot;http://www.mapbox.com&quot; target=&quot;_blank&quot;>http://www.mapbox.com</a>\";s:12:\"mapbox2_user\";s:6:\"mapbox\";s:11:\"mapbox2_map\";s:15:\"geography-class\";s:15:\"mapbox2_minzoom\";s:1:\"0\";s:15:\"mapbox2_maxzoom\";s:1:\"8\";s:19:\"mapbox2_attribution\";s:101:\"MapBox, <a href=&quot;http://www.mapbox.com&quot; target=&quot;_blank&quot;>http://www.mapbox.com</a>\";s:12:\"mapbox3_user\";s:6:\"mapbox\";s:11:\"mapbox3_map\";s:15:\"natural-earth-1\";s:15:\"mapbox3_minzoom\";s:1:\"0\";s:15:\"mapbox3_maxzoom\";s:1:\"6\";s:19:\"mapbox3_attribution\";s:101:\"MapBox, <a href=&quot;http://www.mapbox.com&quot; target=&quot;_blank&quot;>http://www.mapbox.com</a>\";s:22:\"custom_basemap_tileurl\";s:50:\"http://tile.opencyclemap.org/cycle/{z}/{x}/{y}.png\";s:26:\"custom_basemap_attribution\";s:216:\"&copy; <a href=&quot;http://openstreetmap.org/&quot; target=&quot;_blank&quot;>OpenStreetMap contributors</a>, <a href=&quot;http://creativecommons.org/licenses/by-sa/2.0/&quot; target=&quot;_blank&quot;>CC-BY-SA</a>\";s:22:\"custom_basemap_minzoom\";s:1:\"1\";s:22:\"custom_basemap_maxzoom\";s:2:\"17\";s:18:\"custom_basemap_tms\";s:5:\"false\";s:33:\"custom_basemap_subdomains_enabled\";s:2:\"no\";s:31:\"custom_basemap_subdomains_names\";s:43:\"&quot;a&quot;, &quot;b&quot;, &quot;c&quot;\";s:38:\"custom_basemap_continuousworld_enabled\";s:5:\"false\";s:29:\"custom_basemap_nowrap_enabled\";s:5:\"false\";s:27:\"custom_basemap_errortileurl\";s:4:\"true\";s:23:\"custom_basemap2_tileurl\";s:49:\"http://tile.stamen.com/watercolor/{z}/{x}/{y}.jpg\";s:27:\"custom_basemap2_attribution\";s:398:\"Map tiles: <a href=&quot;http://stamen.com&quot; target=&quot;_blank&quot;>Stamen Design</a>, <a href=&quot;http://creativecommons.org/licenses/by/3.0&quot; target=&quot;_blank&quot;>CC BY 3.0</a>. Data: <a href=&quot;http://openstreetmap.org&quot; target=&quot;_blank&quot;>OpenStreetMap</a>, <a href=&quot;http://creativecommons.org/licenses/by-sa/3.0&quot; target=&quot;_blank&quot;>CC BY SA</a>\";s:23:\"custom_basemap2_minzoom\";s:1:\"1\";s:23:\"custom_basemap2_maxzoom\";s:2:\"17\";s:19:\"custom_basemap2_tms\";s:5:\"false\";s:34:\"custom_basemap2_subdomains_enabled\";s:2:\"no\";s:32:\"custom_basemap2_subdomains_names\";s:43:\"&quot;a&quot;, &quot;b&quot;, &quot;c&quot;\";s:39:\"custom_basemap2_continuousworld_enabled\";s:5:\"false\";s:30:\"custom_basemap2_nowrap_enabled\";s:5:\"false\";s:28:\"custom_basemap2_errortileurl\";s:4:\"true\";s:23:\"custom_basemap3_tileurl\";s:59:\"http://{s}.tile2.opencyclemap.org/transport/{z}/{x}/{y}.png\";s:27:\"custom_basemap3_attribution\";s:117:\"&copy; Gravitystorm Ltd. <a href=&quot;http://www.thunderforest.com&quot; target=&quot;_blank&quot;>Thunderforest</a>\";s:23:\"custom_basemap3_minzoom\";s:1:\"1\";s:23:\"custom_basemap3_maxzoom\";s:2:\"18\";s:19:\"custom_basemap3_tms\";s:5:\"false\";s:34:\"custom_basemap3_subdomains_enabled\";s:3:\"yes\";s:32:\"custom_basemap3_subdomains_names\";s:43:\"&quot;a&quot;, &quot;b&quot;, &quot;c&quot;\";s:39:\"custom_basemap3_continuousworld_enabled\";s:5:\"false\";s:30:\"custom_basemap3_nowrap_enabled\";s:5:\"false\";s:28:\"custom_basemap3_errortileurl\";s:4:\"true\";s:15:\"overlays_custom\";i:0;s:16:\"overlays_custom2\";i:0;s:16:\"overlays_custom3\";i:0;s:16:\"overlays_custom4\";i:0;s:20:\"overlays_custom_name\";s:19:\"Adresses OGD Vienne\";s:23:\"overlays_custom_tileurl\";s:73:\"http://{s}.wien.gv.at/wmts/beschriftung/normal/google3857/{z}/{y}/{x}.png\";s:27:\"overlays_custom_attribution\";s:111:\"Addresses: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>open.wien.at</a>)\";s:23:\"overlays_custom_minzoom\";s:1:\"1\";s:23:\"overlays_custom_maxzoom\";s:2:\"19\";s:23:\"overlays_custom_opacity\";s:3:\"1.0\";s:19:\"overlays_custom_tms\";s:5:\"false\";s:34:\"overlays_custom_subdomains_enabled\";s:3:\"yes\";s:32:\"overlays_custom_subdomains_names\";s:73:\"&quot;maps&quot;, &quot;maps1&quot;, &quot;maps2&quot;, &quot;maps3&quot;\";s:28:\"overlays_custom_errortileurl\";s:4:\"true\";s:21:\"overlays_custom2_name\";s:7:\"Custom2\";s:24:\"overlays_custom2_tileurl\";s:73:\"http://{s}.wien.gv.at/wmts/beschriftung/normal/google3857/{z}/{y}/{x}.png\";s:28:\"overlays_custom2_attribution\";s:111:\"Addresses: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>open.wien.at</a>)\";s:24:\"overlays_custom2_minzoom\";s:1:\"1\";s:24:\"overlays_custom2_maxzoom\";s:2:\"17\";s:24:\"overlays_custom2_opacity\";s:3:\"1.0\";s:20:\"overlays_custom2_tms\";s:5:\"false\";s:35:\"overlays_custom2_subdomains_enabled\";s:3:\"yes\";s:33:\"overlays_custom2_subdomains_names\";s:73:\"&quot;maps&quot;, &quot;maps1&quot;, &quot;maps2&quot;, &quot;maps3&quot;\";s:29:\"overlays_custom2_errortileurl\";s:4:\"true\";s:21:\"overlays_custom3_name\";s:7:\"Custom3\";s:24:\"overlays_custom3_tileurl\";s:73:\"http://{s}.wien.gv.at/wmts/beschriftung/normal/google3857/{z}/{y}/{x}.png\";s:28:\"overlays_custom3_attribution\";s:111:\"Addresses: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>open.wien.at</a>)\";s:24:\"overlays_custom3_minzoom\";s:1:\"1\";s:24:\"overlays_custom3_maxzoom\";s:2:\"17\";s:24:\"overlays_custom3_opacity\";s:3:\"1.0\";s:20:\"overlays_custom3_tms\";s:5:\"false\";s:35:\"overlays_custom3_subdomains_enabled\";s:3:\"yes\";s:33:\"overlays_custom3_subdomains_names\";s:73:\"&quot;maps&quot;, &quot;maps1&quot;, &quot;maps2&quot;, &quot;maps3&quot;\";s:29:\"overlays_custom3_errortileurl\";s:4:\"true\";s:21:\"overlays_custom4_name\";s:7:\"Custom4\";s:24:\"overlays_custom4_tileurl\";s:73:\"http://{s}.wien.gv.at/wmts/beschriftung/normal/google3857/{z}/{y}/{x}.png\";s:28:\"overlays_custom4_attribution\";s:111:\"Addresses: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>open.wien.at</a>)\";s:24:\"overlays_custom4_minzoom\";s:1:\"1\";s:24:\"overlays_custom4_maxzoom\";s:2:\"17\";s:24:\"overlays_custom4_opacity\";s:3:\"1.0\";s:20:\"overlays_custom4_tms\";s:5:\"false\";s:35:\"overlays_custom4_subdomains_enabled\";s:3:\"yes\";s:33:\"overlays_custom4_subdomains_names\";s:73:\"&quot;maps&quot;, &quot;maps1&quot;, &quot;maps2&quot;, &quot;maps3&quot;\";s:29:\"overlays_custom4_errortileurl\";s:4:\"true\";s:17:\"wms_wms_available\";i:1;s:18:\"wms_wms2_available\";i:1;s:18:\"wms_wms3_available\";i:1;s:18:\"wms_wms4_available\";i:1;s:18:\"wms_wms5_available\";i:1;s:18:\"wms_wms6_available\";i:1;s:18:\"wms_wms7_available\";i:1;s:18:\"wms_wms8_available\";i:1;s:18:\"wms_wms9_available\";i:1;s:19:\"wms_wms10_available\";i:1;s:12:\"wms_wms_name\";s:98:\"<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>OGD Vienna - Public Toilets</a>\";s:15:\"wms_wms_baseurl\";s:33:\"https://data.wien.gv.at/daten/wms\";s:14:\"wms_wms_layers\";s:11:\"WCANLAGEOGD\";s:14:\"wms_wms_styles\";s:0:\"\";s:14:\"wms_wms_format\";s:9:\"image/gif\";s:19:\"wms_wms_transparent\";s:4:\"TRUE\";s:15:\"wms_wms_version\";s:5:\"1.1.1\";s:19:\"wms_wms_attribution\";s:108:\"WMS: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>open.wien.gv.at</a>)\";s:22:\"wms_wms_legend_enabled\";s:3:\"yes\";s:14:\"wms_wms_legend\";s:0:\"\";s:26:\"wms_wms_subdomains_enabled\";s:2:\"no\";s:24:\"wms_wms_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:19:\"wms_wms_kml_support\";s:3:\"yes\";s:16:\"wms_wms_kml_href\";s:213:\"https://data.wien.gv.at/daten/geo?version=1.3.0&service=WMS&request=GetMap&crs=EPSG:4326&bbox=48.10,16.16,48.34,16.59&width=1&height=1&layers=ogdwien:WCANLAGEOGD&styles=&format=application/vnd.google-earth.kml+xml\";s:23:\"wms_wms_kml_refreshMode\";s:8:\"onChange\";s:27:\"wms_wms_kml_refreshInterval\";s:2:\"30\";s:27:\"wms_wms_kml_viewRefreshMode\";s:5:\"never\";s:27:\"wms_wms_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms2_name\";s:105:\"<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>OGD Vienna - Elevators at stations</a>\";s:16:\"wms_wms2_baseurl\";s:33:\"https://data.wien.gv.at/daten/wms\";s:15:\"wms_wms2_layers\";s:9:\"AUFZUGOGD\";s:15:\"wms_wms2_styles\";s:0:\"\";s:15:\"wms_wms2_format\";s:9:\"image/gif\";s:20:\"wms_wms2_transparent\";s:4:\"TRUE\";s:16:\"wms_wms2_version\";s:5:\"1.1.1\";s:20:\"wms_wms2_attribution\";s:112:\"WMS: City of Vienna (<a href=&quot;https://open.wien.at&quot; target=&quot;_blank&quot;>http://open.wien.at</a>)\";s:23:\"wms_wms2_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms2_legend\";s:0:\"\";s:27:\"wms_wms2_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms2_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms2_kml_support\";s:3:\"yes\";s:17:\"wms_wms2_kml_href\";s:211:\"https://data.wien.gv.at/daten/geo?version=1.3.0&service=WMS&request=GetMap&crs=EPSG:4326&bbox=48.10,16.16,48.34,16.59&width=1&height=1&layers=ogdwien:AUFZUGOGD&styles=&format=application/vnd.google-earth.kml+xml\";s:24:\"wms_wms2_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms2_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms2_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms2_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms3_name\";s:182:\"<a href=&quot;http://discomap.eea.europa.eu/ArcGIS/rest/services/Air/EPRTRDiffuseAir_Dyna_WGS84/MapServer/7&quot; target=&quot;_blank&quot;>EEA - CO emissions from road transport</a>\";s:16:\"wms_wms3_baseurl\";s:96:\"http://discomap.eea.europa.eu/ArcGIS/services/Air/EPRTRDiffuseAir_Dyna_WGS84/MapServer/WMSServer\";s:15:\"wms_wms3_layers\";s:2:\"24\";s:15:\"wms_wms3_styles\";s:0:\"\";s:15:\"wms_wms3_format\";s:9:\"image/png\";s:20:\"wms_wms3_transparent\";s:4:\"TRUE\";s:20:\"wms_wms3_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms3_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms3_legend\";s:166:\"http://discomap.eea.europa.eu/ArcGIS/services/Air/EPRTRDiffuseAir_Dyna_WGS84/MapServer/WMSServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=1\";s:16:\"wms_wms3_version\";s:5:\"1.3.0\";s:27:\"wms_wms3_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms3_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms3_kml_support\";s:3:\"yes\";s:17:\"wms_wms3_kml_href\";s:156:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Air/EPRTRDiffuseAir_Dyna_WGS84/MapServer/generatekml?docName=&l%3A7=on&layers=7&layerOptions=nonComposite\";s:24:\"wms_wms3_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms3_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms3_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms3_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms4_name\";s:156:\"<a href=&quot;http://discomap.eea.europa.eu/ArcGIS/rest/services/Land/CLC2006_Dyna_WM/MapServer&quot; target=&quot;_blank&quot;>EEA - Agricultural areas</a>\";s:16:\"wms_wms4_baseurl\";s:86:\"http://discomap.eea.europa.eu/ArcGIS/services/Land/CLC2006_Dyna_WM/MapServer/WMSServer\";s:15:\"wms_wms4_layers\";s:2:\"10\";s:15:\"wms_wms4_styles\";s:0:\"\";s:15:\"wms_wms4_format\";s:9:\"image/png\";s:20:\"wms_wms4_transparent\";s:4:\"TRUE\";s:16:\"wms_wms4_version\";s:5:\"1.3.0\";s:20:\"wms_wms4_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms4_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms4_legend\";s:157:\"http://discomap.eea.europa.eu/ArcGIS/services/Land/CLC2000_Cach_WM/MapServer/WMSServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=11\";s:27:\"wms_wms4_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms4_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms4_kml_support\";s:3:\"yes\";s:17:\"wms_wms4_kml_href\";s:146:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Land/CLC2006_Dyna_WM/MapServer/generatekml?docName=&l%3A5=on&layers=5&layerOptions=nonComposite\";s:24:\"wms_wms4_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms4_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms4_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms4_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms5_name\";s:173:\"<a href=&quot;http://discomap.eea.europa.eu/arcgis/rest/services/Land/LandscapeFragmentation_LAEA/MapServer&quot; target=&quot;_blank&quot;>EEA - Landscape fragmentation</a>\";s:16:\"wms_wms5_baseurl\";s:99:\"http://discomap.eea.europa.eu/arcgis/services/Land/LandscapeFragmentation_LAEA/MapServer/WmsServer?\";s:15:\"wms_wms5_layers\";s:1:\"0\";s:15:\"wms_wms5_styles\";s:0:\"\";s:15:\"wms_wms5_format\";s:9:\"image/png\";s:20:\"wms_wms5_transparent\";s:4:\"TRUE\";s:16:\"wms_wms5_version\";s:5:\"1.3.0\";s:20:\"wms_wms5_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms5_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms5_legend\";s:168:\"http://discomap.eea.europa.eu/arcgis/services/Land/LandscapeFragmentation_LAEA/MapServer/WmsServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=0\";s:27:\"wms_wms5_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms5_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms5_kml_support\";s:2:\"no\";s:17:\"wms_wms5_kml_href\";s:151:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Noise/Noise_Dyna_LAEA/MapServer/generatekml?docName=&l%3A460=on&layers=460&layerOptions=nonComposite\";s:24:\"wms_wms5_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms5_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms5_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms5_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms6_name\";s:149:\"<a href=&quot;http://discomap.eea.europa.eu/ArcGIS/rest/services/Land/CLC2006_Dyna_WM/MapServer&quot; target=&quot;_blank&quot;>EEA - WaterBodies</a>\";s:16:\"wms_wms6_baseurl\";s:86:\"http://discomap.eea.europa.eu/ArcGIS/services/Land/CLC2006_Dyna_WM/MapServer/WMSServer\";s:15:\"wms_wms6_layers\";s:1:\"2\";s:15:\"wms_wms6_styles\";s:0:\"\";s:15:\"wms_wms6_format\";s:9:\"image/png\";s:20:\"wms_wms6_transparent\";s:4:\"TRUE\";s:16:\"wms_wms6_version\";s:5:\"1.3.0\";s:20:\"wms_wms6_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms6_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms6_legend\";s:156:\"http://discomap.eea.europa.eu/ArcGIS/services/Land/CLC2006_Dyna_WM/MapServer/WMSServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=2\";s:27:\"wms_wms6_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms6_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms6_kml_support\";s:3:\"yes\";s:17:\"wms_wms6_kml_href\";s:148:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Land/CLC2006_Dyna_WM/MapServer/generatekml?docName=&l%3A14=on&layers=14&layerOptions=nonComposite\";s:24:\"wms_wms6_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms6_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms6_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms6_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms7_name\";s:180:\"<a href=&quot;http://discomap.eea.europa.eu/ArcGIS/rest/services/Water/RiverAndLakes_Dyna_WM/MapServer&quot; target=&quot;_blank&quot;>EEA - Mean annual nitrates in rivers 2008</a>\";s:16:\"wms_wms7_baseurl\";s:93:\"http://discomap.eea.europa.eu/ArcGIS/services/Water/RiverAndLakes_Dyna_WM/MapServer/WMSServer\";s:15:\"wms_wms7_layers\";s:2:\"14\";s:15:\"wms_wms7_styles\";s:0:\"\";s:15:\"wms_wms7_format\";s:9:\"image/png\";s:20:\"wms_wms7_transparent\";s:4:\"TRUE\";s:16:\"wms_wms7_version\";s:5:\"1.3.0\";s:20:\"wms_wms7_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms7_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms7_legend\";s:164:\"http://discomap.eea.europa.eu/ArcGIS/services/Water/RiverAndLakes_Dyna_WM/MapServer/WMSServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=14\";s:27:\"wms_wms7_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms7_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms7_kml_support\";s:3:\"yes\";s:17:\"wms_wms7_kml_href\";s:153:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Water/RiverAndLakes_Dyna_WM/MapServer/generatekml?docName=&l%3A9=on&layers=9&layerOptions=nonComposite\";s:24:\"wms_wms7_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms7_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms7_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms7_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms8_name\";s:170:\"<a href=&quot;http://discomap.eea.europa.eu/ArcGIS/rest/services/Reports2010/Reports2008_Dyna_WGS84/MapServer&quot; target=&quot;_blank&quot;>EEA - Temperature Change</a>\";s:16:\"wms_wms8_baseurl\";s:100:\"http://discomap.eea.europa.eu/ArcGIS/services/Reports2010/Reports2008_Dyna_WGS84/MapServer/WMSServer\";s:15:\"wms_wms8_layers\";s:1:\"5\";s:15:\"wms_wms8_styles\";s:0:\"\";s:15:\"wms_wms8_format\";s:9:\"image/png\";s:20:\"wms_wms8_transparent\";s:4:\"TRUE\";s:16:\"wms_wms8_version\";s:5:\"1.3.0\";s:20:\"wms_wms8_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms8_legend_enabled\";s:3:\"yes\";s:15:\"wms_wms8_legend\";s:152:\"http://cow6/ArcGIS/services/Reports2010/Reports2008_Dyna_WGS84/MapServer/WMSServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=5\";s:27:\"wms_wms8_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms8_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms8_kml_support\";s:3:\"yes\";s:17:\"wms_wms8_kml_href\";s:162:\"http://discomap.eea.europa.eu/ArcGIS/rest/services/Reports2010/Reports2008_Dyna_WGS84/MapServer/generatekml?docName=&l%3A26=on&layers=26&layerOptions=nonComposite\";s:24:\"wms_wms8_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms8_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms8_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms8_kml_viewRefreshTime\";s:1:\"1\";s:13:\"wms_wms9_name\";s:152:\"<a href=&quot;http://discomap.eea.europa.eu/arcgis/rest/services/Land/UrbanAtlas_LAEA/MapServer&quot; target=&quot;_blank&quot;>EEA - Urban Outlines</a>\";s:16:\"wms_wms9_baseurl\";s:87:\"http://discomap.eea.europa.eu/arcgis/services/Land/UrbanAtlas_LAEA/MapServer/WmsServer?\";s:15:\"wms_wms9_layers\";s:1:\"4\";s:15:\"wms_wms9_styles\";s:0:\"\";s:15:\"wms_wms9_format\";s:9:\"image/png\";s:20:\"wms_wms9_transparent\";s:4:\"TRUE\";s:16:\"wms_wms9_version\";s:5:\"1.3.0\";s:20:\"wms_wms9_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:23:\"wms_wms9_legend_enabled\";s:2:\"no\";s:15:\"wms_wms9_legend\";s:156:\"http://discomap.eea.europa.eu/arcgis/services/Land/UrbanAtlas_LAEA/MapServer/WmsServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=4\";s:27:\"wms_wms9_subdomains_enabled\";s:2:\"no\";s:25:\"wms_wms9_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:20:\"wms_wms9_kml_support\";s:2:\"no\";s:17:\"wms_wms9_kml_href\";s:0:\"\";s:24:\"wms_wms9_kml_refreshMode\";s:8:\"onChange\";s:28:\"wms_wms9_kml_refreshInterval\";s:2:\"30\";s:28:\"wms_wms9_kml_viewRefreshMode\";s:5:\"never\";s:28:\"wms_wms9_kml_viewRefreshTime\";s:1:\"1\";s:14:\"wms_wms10_name\";s:163:\"<a href=&quot;http://discomap.eea.europa.eu/arcgis/rest/services/Bio/Article17_Dyna_WM/MapServer&quot; target=&quot;_blank&quot;>EEA - Bieogeographical Regions</a>\";s:17:\"wms_wms10_baseurl\";s:88:\"http://discomap.eea.europa.eu/arcgis/services/Bio/Article17_Dyna_WM/MapServer/WmsServer?\";s:16:\"wms_wms10_layers\";s:1:\"1\";s:16:\"wms_wms10_styles\";s:0:\"\";s:16:\"wms_wms10_format\";s:9:\"image/png\";s:21:\"wms_wms10_transparent\";s:4:\"TRUE\";s:17:\"wms_wms10_version\";s:5:\"1.3.0\";s:21:\"wms_wms10_attribution\";s:116:\"WMS: <a href=&quot;http://www.eea.europa.eu/code/gis&quot; target=&quot;_blank&quot;>European Environment Agency</a>\";s:24:\"wms_wms10_legend_enabled\";s:3:\"yes\";s:16:\"wms_wms10_legend\";s:157:\"http://discomap.eea.europa.eu/arcgis/services/Bio/Article17_Dyna_WM/MapServer/WmsServer?request=GetLegendGraphic%26version=1.3.0%26format=image/png%26layer=2\";s:28:\"wms_wms10_subdomains_enabled\";s:2:\"no\";s:26:\"wms_wms10_subdomains_names\";s:70:\"&quot;subdomain1&quot;, &quot;subdomain2&quot;, &quot;subdomain3&quot;\";s:21:\"wms_wms10_kml_support\";s:2:\"no\";s:18:\"wms_wms10_kml_href\";s:0:\"\";s:25:\"wms_wms10_kml_refreshMode\";s:8:\"onChange\";s:29:\"wms_wms10_kml_refreshInterval\";s:2:\"30\";s:29:\"wms_wms10_kml_viewRefreshMode\";s:5:\"never\";s:29:\"wms_wms10_kml_viewRefreshTime\";s:1:\"1\";s:19:\"google_maps_api_key\";s:0:\"\";s:33:\"google_maps_language_localization\";s:15:\"browser_setting\";s:23:\"google_maps_base_domain\";s:15:\"maps.google.com\";s:30:\"google_maps_base_domain_custom\";s:0:\"\";s:27:\"google_places_bounds_status\";s:8:\"disabled\";s:25:\"google_places_bounds_lat1\";s:9:\"48.326583\";s:25:\"google_places_bounds_lon1\";s:8:\"16.55056\";s:25:\"google_places_bounds_lat2\";s:9:\"48.114308\";s:25:\"google_places_bounds_lon2\";s:9:\"16.187325\";s:34:\"google_places_search_prefix_status\";s:8:\"disabled\";s:27:\"google_places_search_prefix\";s:6:\"Wien, \";s:16:\"bingmaps_api_key\";s:0:\"\";s:16:\"bingmaps_culture\";s:9:\"automatic\";s:19:\"directions_provider\";s:10:\"googlemaps\";s:26:\"directions_popuptext_panel\";s:3:\"yes\";s:30:\"directions_googlemaps_map_type\";s:1:\"m\";s:29:\"directions_googlemaps_traffic\";s:1:\"1\";s:36:\"directions_googlemaps_distance_units\";s:3:\"ptk\";s:41:\"directions_googlemaps_route_type_highways\";i:0;s:38:\"directions_googlemaps_route_type_tolls\";i:0;s:49:\"directions_googlemaps_route_type_public_transport\";i:0;s:40:\"directions_googlemaps_route_type_walking\";i:0;s:34:\"directions_googlemaps_overview_map\";s:1:\"0\";s:34:\"directions_yours_type_of_transport\";s:8:\"motorcar\";s:27:\"directions_yours_route_type\";s:1:\"1\";s:22:\"directions_yours_layer\";s:6:\"mapnik\";s:24:\"directions_osrm_language\";s:2:\"en\";s:21:\"directions_osrm_units\";s:1:\"0\";s:32:\"directions_ors_route_preferences\";s:8:\"Shortest\";s:23:\"directions_ors_language\";s:2:\"en\";s:27:\"directions_ors_no_motorways\";s:5:\"false\";s:26:\"directions_ors_no_tollways\";s:5:\"false\";s:25:\"ar_wikitude_provider_name\";s:18:\"www_mapsmarker_com\";s:21:\"ar_wikitude_shortname\";s:18:\"www.mapsmarker.com\";s:25:\"ar_wikitude_promotiontext\";s:42:\"Wikitude API powered by www.mapsmarker.com\";s:28:\"ar_wikitude_promotiongraphic\";s:110:\"http://dev48h.pigiste.org/wp-content/plugins/leaflet-maps-marker/inc/img/wikitude-promotiongraphic-180x200.png\";s:18:\"ar_wikitude_optout\";s:5:\"false\";s:26:\"ar_wikitude_featuregraphic\";s:109:\"http://dev48h.pigiste.org/wp-content/plugins/leaflet-maps-marker/inc/img/wikitude-featuregraphic-1024x500.png\";s:24:\"ar_wikitude_provider_url\";s:25:\"http://www.mapsmarker.com\";s:16:\"ar_wikitude_logo\";s:96:\"http://dev48h.pigiste.org/wp-content/plugins/leaflet-maps-marker/inc/img/wikitude-logo-96x96.png\";s:16:\"ar_wikitude_icon\";s:96:\"http://dev48h.pigiste.org/wp-content/plugins/leaflet-maps-marker/inc/img/wikitude-icon-32x32.png\";s:21:\"ar_wikitude_hiresicon\";s:0:\"\";s:16:\"ar_wikitude_tags\";s:10:\"mapsmarker\";s:17:\"ar_wikitude_email\";s:0:\"\";s:17:\"ar_wikitude_phone\";s:0:\"\";s:22:\"ar_wikitude_attachment\";s:0:\"\";s:18:\"ar_wikitude_radius\";s:6:\"100000\";s:25:\"ar_wikitude_maxnumberpois\";s:2:\"50\";s:12:\"affiliate_id\";s:0:\"\";s:17:\"capabilities_edit\";s:10:\"edit_posts\";s:19:\"capabilities_delete\";s:10:\"edit_posts\";s:16:\"markers_per_page\";s:2:\"30\";s:9:\"shortcode\";s:10:\"mapsmarker\";s:19:\"misc_tinymce_button\";s:7:\"enabled\";s:23:\"misc_add_georss_to_head\";s:7:\"enabled\";s:21:\"admin_bar_integration\";s:7:\"enabled\";s:27:\"misc_admin_dashboard_widget\";s:7:\"enabled\";s:13:\"misc_pointers\";s:7:\"enabled\";s:16:\"misc_projections\";s:14:\"L.CRS.EPSG3857\";s:29:\"misc_javascript_header_footer\";s:6:\"footer\";s:28:\"misc_conditional_css_loading\";s:7:\"enabled\";s:23:\"misc_responsive_support\";s:7:\"enabled\";s:25:\"misc_global_admin_notices\";s:4:\"show\";s:20:\"misc_plugin_language\";s:9:\"automatic\";s:25:\"misc_plugin_language_area\";s:7:\"backend\";s:8:\"misc_kml\";s:4:\"show\";s:30:\"misc_marker_listing_columns_id\";i:1;s:32:\"misc_marker_listing_columns_icon\";i:1;s:38:\"misc_marker_listing_columns_markername\";i:1;s:35:\"misc_marker_listing_columns_address\";i:1;s:37:\"misc_marker_listing_columns_popuptext\";i:1;s:37:\"misc_marker_listing_columns_layername\";i:1;s:35:\"misc_marker_listing_columns_basemap\";i:0;s:33:\"misc_marker_listing_columns_layer\";i:1;s:39:\"misc_marker_listing_columns_coordinates\";i:0;s:32:\"misc_marker_listing_columns_zoom\";i:0;s:37:\"misc_marker_listing_columns_openpopup\";i:0;s:39:\"misc_marker_listing_columns_panelstatus\";i:0;s:35:\"misc_marker_listing_columns_mapsize\";i:0;s:37:\"misc_marker_listing_columns_createdby\";i:0;s:37:\"misc_marker_listing_columns_createdon\";i:0;s:37:\"misc_marker_listing_columns_updatedby\";i:0;s:37:\"misc_marker_listing_columns_updatedon\";i:0;s:38:\"misc_marker_listing_columns_controlbox\";i:0;s:37:\"misc_marker_listing_columns_shortcode\";i:1;s:31:\"misc_marker_listing_columns_kml\";i:0;s:38:\"misc_marker_listing_columns_fullscreen\";i:0;s:35:\"misc_marker_listing_columns_qr_code\";i:0;s:35:\"misc_marker_listing_columns_geojson\";i:0;s:34:\"misc_marker_listing_columns_georss\";i:0;s:36:\"misc_marker_listing_columns_wikitude\";i:0;s:33:\"misc_marker_listing_sort_order_by\";s:4:\"m.id\";s:35:\"misc_marker_listing_sort_sort_order\";s:3:\"ASC\";s:29:\"misc_layer_listing_columns_id\";i:1;s:31:\"misc_layer_listing_columns_type\";i:1;s:36:\"misc_layer_listing_columns_layername\";i:1;s:34:\"misc_layer_listing_columns_address\";i:1;s:38:\"misc_layer_listing_columns_markercount\";i:1;s:34:\"misc_layer_listing_columns_basemap\";i:0;s:38:\"misc_layer_listing_columns_layercenter\";i:0;s:31:\"misc_layer_listing_columns_zoom\";i:0;s:34:\"misc_layer_listing_columns_mapsize\";i:0;s:38:\"misc_layer_listing_columns_panelstatus\";i:0;s:36:\"misc_layer_listing_columns_createdby\";i:0;s:36:\"misc_layer_listing_columns_createdon\";i:0;s:36:\"misc_layer_listing_columns_updatedby\";i:0;s:36:\"misc_layer_listing_columns_updatedon\";i:0;s:37:\"misc_layer_listing_columns_controlbox\";i:0;s:36:\"misc_layer_listing_columns_shortcode\";i:1;s:30:\"misc_layer_listing_columns_kml\";i:0;s:37:\"misc_layer_listing_columns_fullscreen\";i:0;s:34:\"misc_layer_listing_columns_qr_code\";i:0;s:34:\"misc_layer_listing_columns_geojson\";i:0;s:33:\"misc_layer_listing_columns_georss\";i:0;s:35:\"misc_layer_listing_columns_wikitude\";i:0;s:32:\"misc_layer_listing_sort_order_by\";s:2:\"id\";s:34:\"misc_layer_listing_sort_sort_order\";s:3:\"ASC\";s:15:\"qrcode_provider\";s:9:\"visualead\";s:16:\"misc_qrcode_size\";s:3:\"150\";s:10:\"api_status\";s:8:\"disabled\";s:18:\"api_default_format\";s:4:\"json\";s:17:\"api_json_callback\";s:5:\"jsonp\";s:7:\"api_key\";s:0:\"\";s:15:\"api_key_private\";s:0:\"\";s:20:\"api_permissions_view\";i:1;s:19:\"api_permissions_add\";i:1;s:14:\"api_allowed_ip\";s:0:\"\";s:19:\"api_allowed_referer\";s:0:\"\";s:20:\"api_request_type_get\";i:1;s:21:\"api_request_type_post\";i:1;s:14:\"reset_settings\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("119019","su_presets_column","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:4:{s:4:\"size\";s:3:\"1/2\";s:6:\"center\";s:2:\"no\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:411:\" En avion

L’aéroport de Strasbourg dessert quotidiennement, en France, Bordeaux, Lille, Lyon, Marseille, Nantes, Nice et Toulouse, en Europe Amsterdam, Bruxelles et Londres (Stansted ou Gatwick). Les jeudis, un vol arrive de Madrid. A proximité, les aéroports de Frankfort et Stuttgart desservent plusieurs capitales européennes (Dublin, Berlin, Londres, Bruxelles, Vienne, Zagreb, Copenhague, Sofia…).\";}}}","yes");
INSERT INTO `wp_options` VALUES("119089","su_presets_box","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:7:{s:5:\"title\";s:8:\"En avion\";s:5:\"style\";s:7:\"default\";s:9:\"box_color\";s:7:\"#333333\";s:11:\"title_color\";s:7:\"#FFFFFF\";s:6:\"radius\";s:1:\"3\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:400:\"L’aéroport de Strasbourg dessert quotidiennement, en France, Bordeaux, Lille, Lyon, Marseille, Nantes, Nice et Toulouse, en Europe Amsterdam, Bruxelles et Londres (Stansted ou Gatwick). Les jeudis, un vol arrive de Madrid. A proximité, les aéroports de Frankfort et Stuttgart desservent plusieurs capitales européennes (Dublin, Berlin, Londres, Bruxelles, Vienne, Zagreb, Copenhague, Sofia…).\";}}}","yes");
INSERT INTO `wp_options` VALUES("119515","leafletmapsmarker_editor","advanced","yes");
INSERT INTO `wp_options` VALUES("119509","leafletmapsmarker_version","3.9.7","yes");
INSERT INTO `wp_options` VALUES("119510","leafletmapsmarker_version_before_update","0","yes");
INSERT INTO `wp_options` VALUES("119511","leafletmapsmarker_redirect","false","yes");
INSERT INTO `wp_options` VALUES("119514","leafletmapsmarker_update_info","hide","yes");
INSERT INTO `wp_options` VALUES("129175","_transient_timeout_leafletmapsmarker_install_update_cache_v397","1430086190","no");
INSERT INTO `wp_options` VALUES("129176","_transient_leafletmapsmarker_install_update_cache_v397","execute install and update-routine only once a day","no");
INSERT INTO `wp_options` VALUES("127326","su_presets_custom_gallery","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:9:{s:6:\"source\";s:12:\"media: 19708\";s:5:\"limit\";s:2:\"16\";s:4:\"link\";s:4:\"none\";s:6:\"target\";s:4:\"self\";s:5:\"width\";s:3:\"120\";s:6:\"height\";s:3:\"120\";s:5:\"title\";s:5:\"never\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:5:\"false\";}}}","yes");
INSERT INTO `wp_options` VALUES("127645","_transient_timeout_su/generator/popup","1429998237","no");
INSERT INTO `wp_options` VALUES("127646","_transient_su/generator/popup","		<div id=\"su-generator-wrap\" style=\"display:none\">
			<div id=\"su-generator\">
				<div id=\"su-generator-header\">
					<div id=\"su-generator-tools\"><a href=\"https://dev48h.pigiste.org/wp-admin/admin.php?page=shortcodes-ultimate#tab-1\" target=\"_blank\" title=\"Réglages\">Réglages du plugin</a> <span></span> <a href=\"http://gndev.info/shortcodes-ultimate/\" target=\"_blank\" title=\"Page d\'accueil du plugin\">Page d\'accueil du plugin</a> <span></span> <a href=\"http://wordpress.org/support/plugin/shortcodes-ultimate/\" target=\"_blank\" title=\"Forum\">Forum</a> <span></span> <a href=\"https://dev48h.pigiste.org/wp-admin/admin.php?page=shortcodes-ultimate-addons\" target=\"_blank\" title=\"Add-ons\" class=\"su-add-ons\">Add-ons</a></div>
					<input type=\"text\" name=\"su_generator_search\" id=\"su-generator-search\" value=\"\" placeholder=\"Rechercher un shortcode\" />
					<p id=\"su-generator-search-pro-tip\"><strong>Pro Tip:</strong> Hit enter to select highlighted shortcode, while searching</p>
					<div id=\"su-generator-filter\">
						<strong>Filtrer par type</strong>
						<a href=\"#\" data-filter=\"all\">Tout</a><a href=\"#\" data-filter=\"content\">Contenu</a><a href=\"#\" data-filter=\"box\">Zone</a><a href=\"#\" data-filter=\"media\">Media</a><a href=\"#\" data-filter=\"gallery\">Galerie</a><a href=\"#\" data-filter=\"data\">Data</a><a href=\"#\" data-filter=\"other\">Autres</a>					</div>
					<div id=\"su-generator-choices\" class=\"su-generator-clearfix\">
						<span data-name=\"Heading\" data-shortcode=\"heading\" title=\"Styled heading\" data-desc=\"Styled heading\" data-group=\"content\"><i class=\"fa fa-h-square\"></i>Heading</span>
<span data-name=\"Tabs\" data-shortcode=\"tabs\" title=\"Tabs container\" data-desc=\"Tabs container\" data-group=\"box\"><i class=\"fa fa-list-alt\"></i>Tabs</span>
<span data-name=\"Tab\" data-shortcode=\"tab\" title=\"Une seule tab\" data-desc=\"Une seule tab\" data-group=\"box\"><i class=\"fa fa-list-alt\"></i>Tab</span>
<span data-name=\"Spoiler\" data-shortcode=\"spoiler\" title=\"Spoiler avec contenu caché\" data-desc=\"Spoiler avec contenu caché\" data-group=\"box\"><i class=\"fa fa-list-ul\"></i>Spoiler</span>
<span data-name=\"Accordéon\" data-shortcode=\"accordion\" title=\"Accordéon avec spoilers\" data-desc=\"Accordéon avec spoilers\" data-group=\"box\"><i class=\"fa fa-list\"></i>Accordéon</span>
<span data-name=\"Divider\" data-shortcode=\"divider\" title=\"Contenu du diviseur avec un lien TOP optionel\" data-desc=\"Contenu du diviseur avec un lien TOP optionel\" data-group=\"content\"><i class=\"fa fa-ellipsis-h\"></i>Divider</span>
<span data-name=\"Spacer\" data-shortcode=\"spacer\" title=\"Espace vide avec hauteur ajustable\" data-desc=\"Espace vide avec hauteur ajustable\" data-group=\"content other\"><i class=\"fa fa-arrows-v\"></i>Spacer</span>
<span data-name=\"Surlignage\" data-shortcode=\"highlight\" title=\"Texte surligné\" data-desc=\"Texte surligné\" data-group=\"content\"><i class=\"fa fa-pencil\"></i>Surlignage</span>
<span data-name=\"Label\" data-shortcode=\"label\" title=\"Label stylisé\" data-desc=\"Label stylisé\" data-group=\"content\"><i class=\"fa fa-tag\"></i>Label</span>
<span data-name=\"Citation\" data-shortcode=\"quote\" title=\"Blockquote alternatif\" data-desc=\"Blockquote alternatif\" data-group=\"box\"><i class=\"fa fa-quote-right\"></i>Citation</span>
<span data-name=\"Pullquote\" data-shortcode=\"pullquote\" title=\"Pullquote\" data-desc=\"Pullquote\" data-group=\"box\"><i class=\"fa fa-quote-left\"></i>Pullquote</span>
<span data-name=\"Dropcap\" data-shortcode=\"dropcap\" title=\"Dropcap\" data-desc=\"Dropcap\" data-group=\"content\"><i class=\"fa fa-bold\"></i>Dropcap</span>
<span data-name=\"Frame\" data-shortcode=\"frame\" title=\"Styled image frame\" data-desc=\"Styled image frame\" data-group=\"content\"><i class=\"fa fa-picture-o\"></i>Frame</span>
<span data-name=\"Ligne\" data-shortcode=\"row\" title=\"Ligne pour colonnes flexibles\" data-desc=\"Ligne pour colonnes flexibles\" data-group=\"box\"><i class=\"fa fa-columns\"></i>Ligne</span>
<span data-name=\"Colonnes\" data-shortcode=\"column\" title=\"Colonne flexible et responsive\" data-desc=\"Colonne flexible et responsive\" data-group=\"box\"><i class=\"fa fa-columns\"></i>Colonnes</span>
<span data-name=\"Liste\" data-shortcode=\"list\" title=\"Liste non ordonnée stylisée\" data-desc=\"Liste non ordonnée stylisée\" data-group=\"content\"><i class=\"fa fa-list-ol\"></i>Liste</span>
<span data-name=\"Bouton\" data-shortcode=\"button\" title=\"Bouton stylisé\" data-desc=\"Bouton stylisé\" data-group=\"content\"><i class=\"fa fa-heart\"></i>Bouton</span>
<span data-name=\"Service\" data-shortcode=\"service\" title=\"Zone de service avec\" data-desc=\"Zone de service avec\" data-group=\"box\"><i class=\"fa fa-check-square-o\"></i>Service</span>
<span data-name=\"Zone\" data-shortcode=\"box\" title=\"Zone colorée avec légende\" data-desc=\"Zone colorée avec légende\" data-group=\"box\"><i class=\"fa fa-list-alt\"></i>Zone</span>
<span data-name=\"Note\" data-shortcode=\"note\" title=\"Zone colorée\" data-desc=\"Zone colorée\" data-group=\"box\"><i class=\"fa fa-list-alt\"></i>Note</span>
<span data-name=\"Expand\" data-shortcode=\"expand\" title=\"Expandable text block\" data-desc=\"Expandable text block\" data-group=\"box\"><i class=\"fa fa-sort-amount-asc\"></i>Expand</span>
<span data-name=\"Lightbox\" data-shortcode=\"lightbox\" title=\"Lightbox window with custom content\" data-desc=\"Lightbox window with custom content\" data-group=\"gallery\"><i class=\"fa fa-external-link\"></i>Lightbox</span>
<span data-name=\"Lightbox content\" data-shortcode=\"lightbox_content\" title=\"Inline content for lightbox\" data-desc=\"Inline content for lightbox\" data-group=\"gallery\"><i class=\"fa fa-external-link\"></i>Lightbox content</span>
<span data-name=\"Tooltip\" data-shortcode=\"tooltip\" title=\"Tooltip window with custom content\" data-desc=\"Tooltip window with custom content\" data-group=\"other\"><i class=\"fa fa-comment-o\"></i>Tooltip</span>
<span data-name=\"Privé\" data-shortcode=\"private\" title=\"Note privée pour les auteurs d&#039;articles\" data-desc=\"Note privée pour les auteurs d&#039;articles\" data-group=\"other\"><i class=\"fa fa-lock\"></i>Privé</span>
<span data-name=\"YouTube\" data-shortcode=\"youtube\" title=\"Vidéo YouTube\" data-desc=\"Vidéo YouTube\" data-group=\"media\"><i class=\"fa fa-youtube-play\"></i>YouTube</span>
<span data-name=\"YouTube Advanced\" data-shortcode=\"youtube_advanced\" title=\"YouTube video player with advanced settings\" data-desc=\"YouTube video player with advanced settings\" data-group=\"media\"><i class=\"fa fa-youtube-play\"></i>YouTube Advanced</span>
<span data-name=\"Vimeo\" data-shortcode=\"vimeo\" title=\"Vidéo\" data-desc=\"Vidéo\" data-group=\"media\"><i class=\"fa fa-youtube-play\"></i>Vimeo</span>
<span data-name=\"Screenr\" data-shortcode=\"screenr\" title=\"Screenr video\" data-desc=\"Screenr video\" data-group=\"media\"><i class=\"fa fa-youtube-play\"></i>Screenr</span>
<span data-name=\"Dailymotion\" data-shortcode=\"dailymotion\" title=\"Dailymotion video\" data-desc=\"Dailymotion video\" data-group=\"media\"><i class=\"fa fa-youtube-play\"></i>Dailymotion</span>
<span data-name=\"Audio\" data-shortcode=\"audio\" title=\"Lecteur audio personnalisé\" data-desc=\"Lecteur audio personnalisé\" data-group=\"media\"><i class=\"fa fa-play-circle\"></i>Audio</span>
<span data-name=\"Video\" data-shortcode=\"video\" title=\"Lecteur video personnalisé\" data-desc=\"Lecteur video personnalisé\" data-group=\"media\"><i class=\"fa fa-play-circle\"></i>Video</span>
<span data-name=\"Tableau\" data-shortcode=\"table\" title=\"Tableau stylisé avec du HTML ou des fichiers CSV\" data-desc=\"Tableau stylisé avec du HTML ou des fichiers CSV\" data-group=\"content\"><i class=\"fa fa-table\"></i>Tableau</span>
<span data-name=\"Permaliens\" data-shortcode=\"permalink\" title=\"Permalien pour article/page spécifié\" data-desc=\"Permalien pour article/page spécifié\" data-group=\"content other\"><i class=\"fa fa-link\"></i>Permaliens</span>
<span data-name=\"Membres\" data-shortcode=\"members\" title=\"Contenu pour les membres identifiés uniquement\" data-desc=\"Contenu pour les membres identifiés uniquement\" data-group=\"other\"><i class=\"fa fa-lock\"></i>Membres</span>
<span data-name=\"Invités\" data-shortcode=\"guests\" title=\"Contenu pour les invités seulement\" data-desc=\"Contenu pour les invités seulement\" data-group=\"other\"><i class=\"fa fa-user\"></i>Invités</span>
<span data-name=\"Flux RSS\" data-shortcode=\"feed\" title=\"Feed grabber\" data-desc=\"Feed grabber\" data-group=\"content other\"><i class=\"fa fa-rss\"></i>Flux RSS</span>
<span data-name=\"Menu\" data-shortcode=\"menu\" title=\"Menu personnalisé par nom\" data-desc=\"Menu personnalisé par nom\" data-group=\"other\"><i class=\"fa fa-bars\"></i>Menu</span>
<span data-name=\"Sous-pages\" data-shortcode=\"subpages\" title=\"Liste des sous-pages\" data-desc=\"Liste des sous-pages\" data-group=\"other\"><i class=\"fa fa-bars\"></i>Sous-pages</span>
<span data-name=\"Soeurs\" data-shortcode=\"siblings\" title=\"List of cureent page siblings\" data-desc=\"List of cureent page siblings\" data-group=\"other\"><i class=\"fa fa-bars\"></i>Soeurs</span>
<span data-name=\"Document\" data-shortcode=\"document\" title=\"Visualisateur de document par Google\" data-desc=\"Visualisateur de document par Google\" data-group=\"media\"><i class=\"fa fa-file-text\"></i>Document</span>
<span data-name=\"Gmap\" data-shortcode=\"gmap\" title=\"Carte par google\" data-desc=\"Carte par google\" data-group=\"media\"><i class=\"fa fa-globe\"></i>Gmap</span>
<span data-name=\"Slider\" data-shortcode=\"slider\" title=\"Slider personnalisé\" data-desc=\"Slider personnalisé\" data-group=\"gallery\"><i class=\"fa fa-picture-o\"></i>Slider</span>
<span data-name=\"Carousel\" data-shortcode=\"carousel\" title=\"Image personnalisable du carousel\" data-desc=\"Image personnalisable du carousel\" data-group=\"gallery\"><i class=\"fa fa-picture-o\"></i>Carousel</span>
<span data-name=\"Galerie\" data-shortcode=\"custom_gallery\" title=\"Galerie d&#039;images personnalisées\" data-desc=\"Galerie d&#039;images personnalisées\" data-group=\"gallery\"><i class=\"fa fa-picture-o\"></i>Galerie</span>
<span data-name=\"Articles\" data-shortcode=\"posts\" title=\"Custom posts query with customizable template\" data-desc=\"Custom posts query with customizable template\" data-group=\"other\"><i class=\"fa fa-th-list\"></i>Articles</span>
<span data-name=\"Dummy text\" data-shortcode=\"dummy_text\" title=\"Text placeholder\" data-desc=\"Text placeholder\" data-group=\"content\"><i class=\"fa fa-text-height\"></i>Dummy text</span>
<span data-name=\"Dummy image\" data-shortcode=\"dummy_image\" title=\"Image placeholder with random image\" data-desc=\"Image placeholder with random image\" data-group=\"content\"><i class=\"fa fa-picture-o\"></i>Dummy image</span>
<span data-name=\"Animation\" data-shortcode=\"animate\" title=\"Wrapper for animation. Any nested element will be animated\" data-desc=\"Wrapper for animation. Any nested element will be animated\" data-group=\"other\"><i class=\"fa fa-bolt\"></i>Animation</span>
<span data-name=\"Meta\" data-shortcode=\"meta\" title=\"Post meta\" data-desc=\"Post meta\" data-group=\"data\"><i class=\"fa fa-info-circle\"></i>Meta</span>
<span data-name=\"User\" data-shortcode=\"user\" title=\"User data\" data-desc=\"User data\" data-group=\"data\"><i class=\"fa fa-info-circle\"></i>User</span>
<span data-name=\"Post\" data-shortcode=\"post\" title=\"Post data\" data-desc=\"Post data\" data-group=\"data\"><i class=\"fa fa-info-circle\"></i>Post</span>
<span data-name=\"Template\" data-shortcode=\"template\" title=\"Theme template\" data-desc=\"Theme template\" data-group=\"other\"><i class=\"fa fa-puzzle-piece\"></i>Template</span>
<span data-name=\"QR code\" data-shortcode=\"qrcode\" title=\"Advanced QR code generator\" data-desc=\"Advanced QR code generator\" data-group=\"content\"><i class=\"fa fa-qrcode\"></i>QR code</span>
<span data-name=\"Scheduler\" data-shortcode=\"scheduler\" title=\"Allows to show the content only at the specified time period\" data-desc=\"Allows to show the content only at the specified time period\" data-group=\"other\"><i class=\"fa fa-clock-o\"></i>Scheduler</span>
					</div>
				</div>
				<div id=\"su-generator-settings\"></div>
				<input type=\"hidden\" name=\"su-generator-selected\" id=\"su-generator-selected\" value=\"https://dev48h.pigiste.org/wp-content/plugins/shortcodes-ultimate\" />
				<input type=\"hidden\" name=\"su-generator-url\" id=\"su-generator-url\" value=\"https://dev48h.pigiste.org/wp-content/plugins/shortcodes-ultimate\" />
				<input type=\"hidden\" name=\"su-compatibility-mode-prefix\" id=\"su-compatibility-mode-prefix\" value=\"su_\" />
				<div id=\"su-generator-result\" style=\"display:none\"></div>
			</div>
		</div>
	","no");
INSERT INTO `wp_options` VALUES("124429","su_presets_label","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:3:{s:4:\"type\";s:7:\"default\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:5:\"Label\";}}}","yes");
INSERT INTO `wp_options` VALUES("129395","itsec_brute_force","a:5:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129396","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:13:\"administrator\";}","yes");
INSERT INTO `wp_options` VALUES("129399","itsec_tweaks","a:22:{s:13:\"generator_tag\";b:1;s:18:\"wlwmanifest_header\";b:1;s:14:\"disable_xmlrpc\";i:0;s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:13:\"protect_files\";b:0;s:18:\"directory_browsing\";b:0;s:15:\"request_methods\";b:0;s:24:\"suspicious_query_strings\";b:0;s:22:\"non_english_characters\";b:0;s:16:\"long_url_strings\";b:0;s:17:\"write_permissions\";b:0;s:14:\"edituri_header\";b:0;s:13:\"theme_updates\";b:0;s:14:\"plugin_updates\";b:0;s:12:\"core_updates\";b:0;s:12:\"comment_spam\";b:0;s:14:\"random_version\";b:0;s:11:\"file_editor\";b:0;s:11:\"uploads_php\";b:0;s:11:\"safe_jquery\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129416","itsec_ipcheck","a:4:{s:17:\"optin-brute-force\";s:1:\"1\";s:7:\"api_ban\";b:1;s:7:\"api_key\";s:32:\"33Fiv1Yw3Vv1f2ihn0l6ShHoFp56PFdj\";s:5:\"api_s\";s:128:\"4o9plyM1ALA07YOe9Z4n2k29y5ejG106735wR1W5exGduIAO9YukcIbm1689g1KQxSWA9OZH0r5964ZuO8s0hAGFL96l1TlOvE74C3YI753nUE2b6Y8RkQUEU40Q0zg5\";}","yes");
INSERT INTO `wp_options` VALUES("129417","itsec_four_oh_four","a:5:{s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:4:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}s:7:\"enabled\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129418","itsec_away_mode","a:4:{s:7:\"enabled\";b:1;s:4:\"type\";i:1;s:5:\"start\";i:1430094600;s:3:\"end\";i:1430204400;}","yes");
INSERT INTO `wp_options` VALUES("129420","itsec_ban_users","a:4:{s:7:\"default\";b:1;s:7:\"enabled\";b:1;s:9:\"host_list\";a:0:{}s:10:\"agent_list\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("129421","itsec_backup","a:9:{s:9:\"all_sites\";b:1;s:6:\"method\";i:0;s:8:\"location\";s:46:\"/home/pigiste/48heures_sauvegardes/dev/iThemes\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:0;s:7:\"exclude\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("129422","itsec_file_change","a:9:{s:6:\"method\";b:0;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:7:\"enabled\";b:0;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";i:1429957280;}","yes");
INSERT INTO `wp_options` VALUES("129423","itsec_hide_backend","a:7:{s:4:\"slug\";s:0:\"\";s:8:\"register\";s:0:\"\";s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:7:\"enabled\";b:0;s:12:\"theme_compat\";b:0;s:12:\"show-tooltip\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129424","itsec_malware","a:2:{s:7:\"enabled\";b:1;s:7:\"api_key\";s:64:\"41989a8a898c77c889af9274298782a51133e7532f6075a5ddcf630bb245f642\";}","yes");
INSERT INTO `wp_options` VALUES("129426","itsec_ssl","a:3:{s:8:\"frontend\";i:0;s:5:\"login\";b:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("129523","_transient_timeout_settings_errors","1430039978","no");
INSERT INTO `wp_options` VALUES("129524","_transient_settings_errors","a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:22:\"Options enregistrées.\";s:4:\"type\";s:7:\"updated\";}}","no");
INSERT INTO `wp_options` VALUES("129310","_transient_timeout_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1430044112","no");
INSERT INTO `wp_options` VALUES("129311","_transient_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1430000912","no");
INSERT INTO `wp_options` VALUES("129312","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1430044113","no");
INSERT INTO `wp_options` VALUES("129313","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
	
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"
		
		
		
		
		
		
				

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		

	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Apr 2015 22:04:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Broken Link Checker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/broken-link-checker/#post-2441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Oct 2007 21:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2441@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"This plugin will check your posts, comments and other content for broken links and missing images, and notify you if any are found.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Janis Elsts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WP Smush\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-smushit/#post-7936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Dec 2008 00:00:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"7936@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Reduce image file sizes, improve performance and boost your SEO using the free WPMU DEV WordPress Smush API.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Dunae\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WPtouch Mobile Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wptouch/#post-5468\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 May 2008 04:58:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5468@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Make your WordPress website mobile-friendly with just a few clicks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"BraveNewCode Inc.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 12 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"ManageWP Worker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/worker/#post-24528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Feb 2011 13:06:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"24528@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"ManageWP is the ultimate WordPress productivity tool, allowing you to efficiently manage your websites.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vladimir Prelovac\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"MailChimp for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/mailchimp-for-wp/#post-54377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Jun 2013 17:32:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"54377@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The best MailChimp plugin to get more email subscribers. Easily add MailChimp sign-up forms and sign-up checkboxes to your WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Danny van Kooten\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/buddypress/#post-10314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Apr 2009 17:48:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"10314@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"BuddyPress helps you run any kind of social network on your WordPress, with member profiles, activity streams, user groups, messaging, and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andy Peatling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"P3 (Plugin Performance Profiler)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/p3-profiler/#post-32894\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Dec 2011 23:11:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"32894@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"See which plugins are slowing down your site.  This plugin creates a performance report for your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"GoDaddy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"EWWW Image Optimizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/ewww-image-optimizer/#post-38780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jun 2012 19:30:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38780@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Reduce file sizes for images in WordPress including NextGEN, GRAND FlAGallery and more using lossless/lossy methods and image format conversion.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"nosilver4u\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/bbpress/#post-14709\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 13 Dec 2009 00:05:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"14709@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"bbPress is forum software, made the WordPress way.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 25 Apr 2015 22:28:33 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Sat, 25 Apr 2015 22:39:25 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Sat, 25 Apr 2015 22:04:25 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150417135034\";}","no");
INSERT INTO `wp_options` VALUES("124552","su_presets_divider","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:9:{s:3:\"top\";s:2:\"no\";s:4:\"text\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:13:\"divider_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#999999\";s:4:\"size\";s:1:\"3\";s:6:\"margin\";s:2:\"15\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:5:\"false\";}}}","yes");
INSERT INTO `wp_options` VALUES("124318","su_presets_frame","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:3:{s:5:\"align\";s:4:\"left\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:46:\"<img src=\"http://lorempixel.com/g/400/200/\" />\";}}}","yes");
INSERT INTO `wp_options` VALUES("124346","su_presets_table","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:3:{s:3:\"url\";s:0:\"\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:110:\"<table>
<tr>
	<td>Contenu</td>
	<td>Contenu</td>
</tr>
<tr>
	<td>Contenu</td>
	<td>Contenu</td>
</tr>
</table>\";}}}","yes");
INSERT INTO `wp_options` VALUES("124778","su_presets_lightbox","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:4:{s:4:\"type\";s:6:\"iframe\";s:3:\"src\";s:0:\"\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:54:\"[su_button] Click Here to Watch the Video [/su_button]\";}}}","yes");
INSERT INTO `wp_options` VALUES("129327","itsec_data","a:5:{s:5:\"build\";i:4036;s:20:\"activation_timestamp\";i:1430000953;s:17:\"already_supported\";b:0;s:15:\"setup_completed\";b:1;s:18:\"tooltips_dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("126229","_transient_feed_2b16a4f9a2b7110ce37a7c1a0e3bbb94","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Ultimate Member » Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://ultimatemember.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"A Free Community & User Profile WordPress Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Apr 2015 14:51:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://wordpress.org/?v=4.1.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Introducing the core extensions bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://ultimatemember.com/introducing-core-extensions-bundle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://ultimatemember.com/introducing-core-extensions-bundle/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Apr 2015 10:30:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=30660\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:519:\"<p>Over the weekend we made a big change to our extensions and it&#8217;s something I think you&#8217;ll like. We&#8217;ve launched our core extensions bundle, and you can now get our extensions at a significant discount. Instead of buying extensions individually you can...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/introducing-core-extensions-bundle/\">Introducing the core extensions bundle</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2920:\"<p>Over the weekend we made a big change to our extensions and it&#8217;s something I think you&#8217;ll like. We&#8217;ve launched our <a href=\"https://ultimatemember.com/core-extensions-bundle/\">core extensions bundle</a>, and you can now get our extensions at a significant discount.</p>
<p>Instead of buying extensions individually you can purchase all of our core extensions and save 70%. That&#8217;s a saving of over $400!</p>
<p>What&#8217;s more the bundle allows you to use the extensions on as many sites as you like.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">What&#8217;s included in the bundle</span></p>
<p>At the moment the bundle comes with eight extensions: <a href=\"https://ultimatemember.com/extensions/social-login/\">Social Login</a>, <a href=\"https://ultimatemember.com/extensions/bbpress/\">bbPress</a>, <a href=\"https://ultimatemember.com/extensions/mailchimp/\">MailChimp</a>, <a href=\"https://ultimatemember.com/extensions/user-reviews/\">User Reviews</a>, <a href=\"https://ultimatemember.com/extensions/real-time-notifications/\">Real-time Notifications</a>, <a href=\"https://ultimatemember.com/extensions/notices/\">Notices</a>, <a href=\"https://ultimatemember.com/extensions/mycred/\">myCRED</a> and <a href=\"https://ultimatemember.com/extensions/profile-completeness/\">Profile Completeness</a>.</p>
<p>However, the best thing about the bundle is that it does not just include our current extensions. Rather, if you buy now you will also get access to all extensions we build in the future (as long as you have an active license).</p>
<p>A lot of great extensions are getting built and are planned for the future including: private messaging, paid memberships, front-end publishing and much more.</p>
<p>You can follow all of our developments on our <a href=\"https://trello.com/b/30quaczv/ultimate-member\">public roadmap</a>.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">What it costs?</span></p>
<p>The bundle costs $149. This gives you a 1 year license for new releases, updates and support. As long as your license is active you will get access to new extensions. Once the license expires you can renew the bundle (or individual extensions if you prefer) at a 30% discount.</p>
<p>If you want to get the bundle for the cheapest possible price then now is the time to buy it. The bundle is only going to get more expensive in the future as we release more extensions so by getting your hands on it now you will get the biggest bargain.</p>
<p>Interested in the bundle? You can learn more about it <a href=\"https://ultimatemember.com/core-extensions-bundle/\">here</a>.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/introducing-core-extensions-bundle/\">Introducing the core extensions bundle</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://ultimatemember.com/introducing-core-extensions-bundle/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"How to display online users on your WordPress site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://ultimatemember.com/how-to-display-online-users-on-your-wordpress-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://ultimatemember.com/how-to-display-online-users-on-your-wordpress-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Apr 2015 16:47:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=26554\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:499:\"<p>If you&#8217;re looking for a way to let users see which other users are online then you&#8217;ll be happy to know that we have created a free extension that will allow you to do just that. With our online users extension...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/how-to-display-online-users-on-your-wordpress-site/\">How to display online users on your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3126:\"<p>If you&#8217;re looking for a way to let users see which other users are online then you&#8217;ll be happy to know that we have created a free extension that will allow you to do just that.</p>
<p><img class=\"aligncenter size-full wp-image-26545\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-06-at-21.41.58-1.png\" alt=\"Profile pics are displayed on front-end of site\" width=\"425\" height=\"99\" /></p>
<p>With our <a href=\"https://ultimatemember.com/extensions/online-users/\">online users extension</a> you can add easily display the users who are currently on your site. The extension allows you to show online users anywhere on your site via a shortcode or you can quickly display online users in your sidebar or footer using the online user widget.</p>
<p><img class=\"aligncenter size-full wp-image-26543\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-06-at-18.32.08.png\" alt=\"Extension creates a widget where you can display online users in your sidebar\" width=\"371\" height=\"433\" /></p>
<p>The widget allows you to display all user roles or you can decide to only show one user role in the widget.</p>
<p><img class=\"aligncenter size-full wp-image-26544\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-06-at-18.32.25.png\" alt=\"You can choose to show all user roles in widget or only one specific role\" width=\"367\" height=\"431\" /></p>
<p>Users can also see if a user is online or not by looking at their profile. If a user is online a green dot will appear next to their name. It is also possible to show a user&#8217;s online status by adding the online status field to the user meta on the profile header or on member directories.</p>
<p><img class=\"aligncenter size-full wp-image-26549\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-07-at-17.32.46.png\" alt=\"Green dot indicates a user is online. Also possible to display online status as user meta.\" width=\"1025\" height=\"621\" /></p>
<p>Another important feature of the extension is the privacy controls we&#8217;ve added. When activated the extension adds an option to the privacy tab on the user account page that allows users to decide whether they want to be shown as online or not.</p>
<p><img class=\"aligncenter size-full wp-image-26551\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-07-at-17.36.11.png\" alt=\"Users can decide whether they want to be shown as online or not\" width=\"328\" height=\"174\" /></p>
<p>Finally, if you&#8217;re worried about the performance of this extension then you shouldn&#8217;t be. We&#8217;ve utilised WordPress cron tasks to make this extension as performant efficient as possible, so as long as you&#8217;re not using dirt cheap shared hosting then you should have no issues with this extension.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/how-to-display-online-users-on-your-wordpress-site/\">How to display online users on your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://ultimatemember.com/how-to-display-online-users-on-your-wordpress-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Inside Ultimate Member: March 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://ultimatemember.com/inside-ultimate-member-march-2015/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://ultimatemember.com/inside-ultimate-member-march-2015/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Apr 2015 15:10:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=17232\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:471:\"<p>What a month we&#8217;ve had for Ultimate Member. March has been a huge and important milestone for us as we have finally started bringing in some revenue for the plugin after many months of developement and hard work. Here are...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/inside-ultimate-member-march-2015/\">Inside Ultimate Member: March 2015</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9101:\"<p>What a month we&#8217;ve had for Ultimate Member. March has been a huge and important milestone for us as we have finally started bringing in some revenue for the plugin after many months of developement and hard work. Here are some of the highlights from the month:</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Extensions Released</span></p>
<p style=\"text-align: left;\">March saw the release our first extensions which provide extra functionality and allow us to generate some income. We released our first batch of extensions on the 11th of March which included: <a href=\"https://ultimatemember.com/extensions/social-login/\">social login</a>, <a href=\"https://ultimatemember.com/extensions/bbpress/\">bbpress</a>, <a href=\"https://ultimatemember.com/extensions/mailchimp/\">Mailchimp</a>, <a href=\"https://ultimatemember.com/extensions/mycred/\">myCRED</a> and <a href=\"https://ultimatemember.com/extensions/google-recaptcha/\">Google reCAPTCHA</a>.</p>
<p style=\"text-align: left;\">We also released two further extensions (<a href=\"https://ultimatemember.com/extensions/notices/\">notices</a>, <a href=\"https://ultimatemember.com/extensions/user-reviews/\">user reviews</a>) later in March bringing our total extensions for the end of the month to seven.</p>
<p style=\"text-align: left;\">When it came to deciding what extensions to build we made the decision to focus on building not the most complex ones but to instead focus on ones we could build in a shorter time. This allowed us to release our first extensions sooner and bring in some much-needed revenue (Ultimate Member started getting built 8 months ago).</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">E-commerce Figures</span></p>
<p style=\"text-align: left;\">The month of March (11th-31st) saw us bring is a total revenue of $6363 from 141 orders. Our two most popular extensions were: social login and bbPress which brought in over half of the revenue. We also had an average spend per customer of $53 and an average order value of $45.</p>
<p style=\"text-align: left;\"><img class=\" size-full wp-image-25021 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Figures.png\" alt=\"Figures\" width=\"945\" height=\"647\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">WP Tavern</span></p>
<p style=\"text-align: left;\">A big boost for us this month was Ultimate Member being featured on <a href=\"http://wptavern.com/ultimate-member-a-new-free-community-and-user-profile-plugin-for-wordpress\">WP Tavern</a>. The post written by Sarah Gooding (<a class=\"ProfileHeaderCard-screennameLink u-linkComplex js-nav\" href=\"https://twitter.com/pollyplummer\" rel=\"nofollow\">@<span class=\"u-linkComplex-target\">pollyplummer</span></a>) brought in a lot of visitors to our site and ultimately led to people using our plugin and becoming paid customers.</p>
<p style=\"text-align: left;\"><img class=\"alignnone size-full wp-image-24213\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/analytics1.png\" alt=\"analytics1\" width=\"1175\" height=\"242\" /></p>
<p style=\"text-align: left;\">When you create a new WordPress product it is natural to want to get the word out about it straight away, especially if the product is going to be your full-time business.</p>
<p style=\"text-align: left;\">However, we decided not to reach out to WP Tavern as soon as we launched Ultimate Member at the end of January. Instead we made the decision to wait until the plugin had been on the repo a little while and we had an interesting story to share.</p>
<p style=\"text-align: left;\">Unless you are already an established name/brand in the WordPress community or are introducing a product that is truly revolutionary then I would advise against trying to get featured on the Tavern and other blogs straight away.</p>
<p style=\"text-align: left;\">If we had done this I am pretty sure Ultimate Member would not have been featured on the Tavern. The fact that we waited allowed us to share some useful info when we reached out to them.</p>
<p style=\"text-align: left;\">By waiting Sarah was able to gauge the quality of the plugin by looking at our <a href=\"https://wordpress.org/support/view/plugin-reviews/ultimate-member\">plugin reviews</a> and active install stats and we were able to share insightful business data about our extension sales.</p>
<p style=\"text-align: left;\">Indeed if you look at the <a href=\"http://wptavern.com/ultimate-member-a-new-free-community-and-user-profile-plugin-for-wordpress\">post</a> you will see that the majority of the post is not to do with what features the plugin provides but rather the business of the plugin.</p>
<p>So if you are a WordPress product owner and you are wondering how to give yourself the best chance of being featured on WP Tavern I would highly recommend you do not focus on the features of your plugin but rather have an interesting story to share.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Open Metrics</span></p>
<p style=\"text-align: left;\">One of our favorite things we implemented in March was our <a href=\"https://ultimatemember.com/open-metrics/\">open metrics dashboard</a> that publicly displays our e-commerce metrics in real-time on our site.</p>
<p style=\"text-align: left;\">Ever since I came across Buffer I have been inspired by their transparency culture and we truly believe in running an open and transparent plugin business.</p>
<p style=\"text-align: left;\">In the WordPress world we have found it very important and inspiring to be able to see how other plugin businesses are doing. Without being able to see the revenue figures of plugins such as EDD and Ninja Forms and seeing how successful they are, then deciding to start a new full-time plugin business would definitely have been a harder decision.</p>
<p style=\"text-align: left;\"><img class=\" size-full wp-image-25029 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-04-03-at-15.25.23.png\" alt=\"Screen Shot 2015-04-03 at 15.25.23\" width=\"697\" height=\"510\" /></p>
<p style=\"text-align: left;\">So in an open-source World we felt it was only right to open up our metrics for everyone to see and learn from. Whilst the main reason we created the open metrics dashboard was because of our belief in openness, being transparent also has a marketing benefit.</p>
<p style=\"text-align: left;\">Because we use the EDD API for creating our metrics I thought I would tweet Pippin and let him see what we had created. What I didn&#8217;t expect was for him to tweet it out to his 10,000+ followers which would result in retweets, favorites and replies from well-known members of the WordPress community such as <span class=\"screen-name\"><a class=\"pretty-link js-nav\" dir=\"ltr\" href=\"https://twitter.com/syedbalkhi\" data-send-impression-cookie=\"true\">@syedbalkhi</a>, <a class=\"ProfileHeaderCard-screennameLink u-linkComplex js-nav\" href=\"https://twitter.com/Krogsgard\">@<span class=\"u-linkComplex-target\">Krogsgard</span></a> and <a class=\"ProfileHeaderCard-screennameLink u-linkComplex js-nav\" href=\"https://twitter.com/jameslaws\">@<span class=\"u-linkComplex-target\">jameslaws</span></a>.</span></p>
<blockquote class=\"twitter-tweet tw-align-center\" lang=\"en-gb\" data-cards=\"hidden\"><p>This is one of my favorite real-world examples of how the EDD REST API is being used: <a href=\"https://t.co/GsIf7Xzf7R\">https://t.co/GsIf7Xzf7R</a> <a href=\"https://twitter.com/umplugin\">@umplugin</a></p>
<p>— Pippinsplugins (@pippinsplugins) <a href=\"https://twitter.com/pippinsplugins/status/580085685673177089\">March 23, 2015</a></p></blockquote>
<p><script src=\"//platform.twitter.com/widgets.js\" async=\"\" charset=\"utf-8\"></script></p>
<p>Whilst this may not seem like much, it is small things like this that allow us to spread the word about Ultimate Member and expose the plugin to more people in the WordPress community. So if I was to recommend one thing to new WordPress business owners it would be to run an open and transparent business. It helps the community by providing useful insights and it can also provide you with a marketing benefit. A win win situation!</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Summary</span></p>
<p style=\"text-align: left;\">Overall March has been a relatively successful month for us. I will be honest and say our monthly revenue is not where we would like or need it to be long-term but considering we have only released a few extensions so far, then it is not too bad a start. Hopefully as we release more extensions we will see our revenue and other e-commerce metrics improve.</p>
<p style=\"text-align: left;\">Feel free to leave a comment if you have any questions about Ultimate Member in March.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/inside-ultimate-member-march-2015/\">Inside Ultimate Member: March 2015</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://ultimatemember.com/inside-ultimate-member-march-2015/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Add a real-time notification system for users to your WordPress site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://ultimatemember.com/add-real-time-notification-system-users-wordpress-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://ultimatemember.com/add-real-time-notification-system-users-wordpress-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Apr 2015 11:20:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=25903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:524:\"<p>When it comes to creating sites with user to user interaction it is important to keep users on your site and make sure they are engaged. High levels of user engagement and interaction are vital for the long-term success of a...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/add-real-time-notification-system-users-wordpress-site/\">Add a real-time notification system for users to your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4984:\"<p>When it comes to creating sites with user to user interaction it is important to keep users on your site and make sure they are engaged. High levels of user engagement and interaction are vital for the long-term success of a community site so it is important you do everything to encourage engagement and interaction amongst users.</p>
<p>You want to make sure people are returning and spending time on your site. Email notifications are an effective way of getting people back to your site but once on your site you need a method for keeping users informed and engaged. This is where a notification system on your website can help.</p>
<p>Online notification systems allow users to be alerted to actions that directly affect them in real-time. Without an online notification system users will find it much more difficult to keep track of their interactions. That is why many popular user based sites such as Facebook, Twitter, Medium etc provide a notification system.</p>
<p style=\"text-align: center;\"> <span style=\"font-size: 28px; font-weight: 600;\">Real-time Notifications</span></p>
<p style=\"text-align: left;\">To ensure that your site&#8217;s users can effectively keep up with interactions we have created a <a href=\"https://ultimatemember.com/extensions/real-time-notifications/\">real-time notification extension</a> which alerts users on your site when an action occurs that is related to them.</p>
<p style=\"text-align: left;\">The extension works by adding a notification button to your site in the bottom-right corner. When a user receives a notification the button will briefly expand and turn red alerting the user that they have received a new notification.</p>
<p style=\"text-align: left;\"><img class=\"aligncenter size-full wp-image-25074\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-03-at-19.45.53.png\" alt=\"You can make it so notifications popup on the bottom left of screen\" width=\"1440\" height=\"900\" /></p>
<p style=\"text-align: left;\">The user then clicks the notification button which will display the notification pop-up.</p>
<p style=\"text-align: left;\"><img class=\"aligncenter size-full wp-image-25077\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-03-at-19.46.40.png\" alt=\"User can see notifications via the notification button/popup or by going to the notifications page\" width=\"1440\" height=\"900\" /></p>
<p style=\"text-align: left;\">The pop-up displays the most recent notifications and also contains a link to view all notifications on the notifications page that is installed with the extension.</p>
<p style=\"text-align: left;\"><img class=\"aligncenter size-full wp-image-25078\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-03-at-19.46.46.png\" alt=\"Extension creates a notification page which shows a user\'s past notifications\" width=\"1055\" height=\"554\" /></p>
<p style=\"text-align: left;\">The extension also enables users to control which notifications they receive which is important as it allows users to have more control over their experience on your site.</p>
<p style=\"text-align: left;\"><img class=\"aligncenter size-full wp-image-25079\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-03-at-19.47.32.png\" alt=\"User can control what notifications they want to receive from their account page\" width=\"788\" height=\"592\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Notification types</span></p>
<p style=\"text-align: left;\">The real-time notification extension works as a stand alone extension with Ultimate Member core and WordPress and provides several interactions. It can alert users when someone views their profile, leaves a comment on their post, replies to their bbPress topic or when their user role is changed by an admin.</p>
<p style=\"text-align: left;\"><img class=\"aligncenter size-full wp-image-25080\" src=\"https://ultimatemember.com/wp-content/uploads/2015/04/Screen-Shot-2015-04-03-at-19.48.20.png\" alt=\"Close up of notifications popup\" width=\"299\" height=\"702\" /></p>
<p style=\"text-align: left;\">However, where this extension really excels is in its integration with current and future Ultimate Member extensions. In the future as the number of extensions we offer increases the notifications extension will be able to alert users to almost any action such as when users receive a friend request or get a new follower; when they receive a new private message and much more.</p>
<p style=\"text-align: left;\">If you want to increase user engagement and interaction on your site then this is definitely an extension you should consider for your site.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/add-real-time-notification-system-users-wordpress-site/\">Add a real-time notification system for users to your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://ultimatemember.com/add-real-time-notification-system-users-wordpress-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Instagram Social Login for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://ultimatemember.com/instagram-social-login-for-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://ultimatemember.com/instagram-social-login-for-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Mar 2015 21:23:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=24451\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:476:\"<p>If you want to let users signup to your site using their instagram account you can now do this with Ultimate Member. We have added support for Instagram to our social login extension which will allow you to add a retina ready...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/instagram-social-login-for-wordpress/\">Instagram Social Login for WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1249:\"<p>If you want to let users signup to your site using their instagram account you can now do this with Ultimate Member.</p>
<p>We have added support for <a href=\"https://instagram.com/\" rel=\"nofollow\">Instagram</a> to our <a href=\"https://ultimatemember.com/extensions/social-login/\">social login extension</a> which will allow you to add a retina ready and fully mobile responsive instagram social login button to your site&#8217;s login and registration forms.</p>
<p><img class=\" size-full wp-image-24443 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-31-at-21.46.21-1.png\" alt=\"Vkontakte (VK.com) Social Login for WordPress\" width=\"521\" height=\"560\" /></p>
<p>You can also display an instagram login button anywhere on your site using our easy to use shortcode builder.</p>
<p>If you have any questions about instagram or our <a href=\"https://ultimatemember.com/extensions/social-login/\">social login extension</a> in general then leave a comment below.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/instagram-social-login-for-wordpress/\">Instagram Social Login for WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://ultimatemember.com/instagram-social-login-for-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Vkontakte (VK.com) Social Login for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://ultimatemember.com/vkontakte-vk-com-social-login-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://ultimatemember.com/vkontakte-vk-com-social-login-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Mar 2015 19:44:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=24412\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:490:\"<p>If you are creating a site for Russian users and you want to let them effortlessly sign-up to your site via Russia&#8217;s most popular social network, you can now do this with Ultimate Member. We have added support for Vkontakte...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/vkontakte-vk-com-social-login-wordpress/\">Vkontakte (VK.com) Social Login for WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1492:\"<p>If you are creating a site for Russian users and you want to let them effortlessly sign-up to your site via Russia&#8217;s most popular social network, you can now do this with Ultimate Member.</p>
<p>We have added support for Vkontakte (<a href=\"https://vk.com/\" rel=\"nofollow\">VK.com</a>) to our <a href=\"https://ultimatemember.com/extensions/social-login/\">social login extension</a> which will help sites targeting Russian users to increase their sign-up rates.</p>
<p>With this latest addition to our social login extension you can add a retina ready and fully mobile responsive Vkontakte (VK.com) social login button to your site&#8217;s login and registration forms.</p>
<p><img class=\" size-full wp-image-24443 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-31-at-21.46.21-1.png\" alt=\"Vkontakte (VK.com) Social Login for WordPress\" width=\"521\" height=\"560\" /></p>
<p>You can also display a Vkontakte (VK.com) login button anywhere on your site using our easy to use shortcode builder.</p>
<p>If you have any questions about Vkontakte (VK.com) or our <a href=\"https://ultimatemember.com/extensions/social-login/\">social login extension</a> in general then leave a comment below.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/vkontakte-vk-com-social-login-wordpress/\">Vkontakte (VK.com) Social Login for WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://ultimatemember.com/vkontakte-vk-com-social-login-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Changes to support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ultimatemember.com/changes-support/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://ultimatemember.com/changes-support/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Mar 2015 12:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=17832\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:463:\"<p>Since we launched Ultimate Member over two months ago we have been providing a high level of support for every user of the plugin. This has included: debugging individual sites, making the plugin compatible with premium themes/plugins and providing code...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/changes-support/\">Changes to support</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5241:\"<p>Since we launched Ultimate Member over two months ago we have been providing a high level of support for every user of the plugin. This has included: debugging individual sites, making the plugin compatible with premium themes/plugins and providing code customizations.</p>
<p>In the vast majority of cases we have replied within just a few hours and we have even provided support over the weekends. Comparing this to many other free plugins who will either offer no support whatsoever or can take up to a week to respond, we feel that we have tried our hardest to provide the best possible support.</p>
<p>Whilst we would love to be able to provide this level of support forever, Ultimate Member has grown a lot over the last two months which has resulted in the number of support requests increasing dramatically (Over 1100 topics since 21st Jan 2015).</p>
<p>Because of this we are having to implement some changes to our support in order for us to continue developing the plugin and making it better. Without these changes it would become very difficult for us to continue developing the plugin at a decent rate.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">What&#8217;s Changing?</span></p>
<p style=\"text-align: left;\">We are making two main changes to the way support is handled for Ultimate Member. The first is the introduction of<a href=\"https://ultimatemember.com/support/\"> paid priority ticketed support</a> which will allow users of the plugin to pay for support if they need more in-depth support including: help with setup; css and minor code customizations, theme/plugin compatibility testing and us logging into their site to help debug issues.</p>
<p style=\"text-align: left;\">As well as more in-depth support the other main benefit of priority support is that response times will be very fast. We are committed to providing fantastic support to users who sign-up to priority support and we will respond to tickets before any other tasks.</p>
<p style=\"text-align: left;\">The second change being made is the introduction of our <a href=\"https://ultimatemember.com/ambassador/\">ambassador programme</a> which is aimed at encouraging more of a community spirit in the forums. The purpose of the ambassador programme is to recognise special users of the community who are contributing to the success of the plugin.</p>
<p style=\"text-align: left;\">We are introducing this programme because for any open-source software to be successful it requires community involvement. Take WordPress itself as an example. Support for WordPress is handled 100% by volunteers and without the massive community behind WordPress it would not be as good as it is today.</p>
<p style=\"text-align: left;\">We will still be providing help and assistance on the forum but our hope is the ambassador programme will result in more users helping each other out on the forum which will ease our support burden.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">What to expect</span></p>
<p>Over the coming days and weeks you should start to see more community involvement on the forums. This will primarily be from Ultimate Member ambassadors who are passionate about the plugin and what to contribute to the success of the plugin by helping out on the forums.</p>
<p>Ambassadors will usually be the first people to respond to topics. If an ambassador is unable to help then we will come onto the forum and see if we can give you an answer. Depending on the support request we may be able to provide you with an answer or if your request is beyond the scope of free support then we will ask you to sign-up for priority support if you want us to help.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Why we are making these changes</span></p>
<p>We are implementing these changes as the level of support we are currently providing is simply not sustainable and is now having a significant impact on our development progress.</p>
<p>Without making these changes we would be spending the majority of our time on the forums instead of building new features. Our hope is by making these changes we will see more users helping each other out but with us still being there to help out when ambassadors are unable to answer a question.</p>
<p>We feel that a community support forum driven by the ambassadors and backed up by us will provide the right balance between you getting answers to the questions you have and allowing us to spend more time developing the plugin and its extensions so we can make Ultimate Member the best community/membership plugin available.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Got a question?</span></p>
<p>We hope you will see these changes as being the best solution for the continued success of Ultimate Member and we are more than happy to answer any questions you have about these changes or the ambassador programmes in the comments below or via the forum.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/changes-support/\">Changes to support</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://ultimatemember.com/changes-support/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Say hello to Ultimate Member Open Metrics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://ultimatemember.com/say-hello-ultimate-member-open-metrics/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://ultimatemember.com/say-hello-ultimate-member-open-metrics/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Mar 2015 11:33:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=15456\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:534:\"<p>Over the weekend we&#8217;ve been working on a cool addition to our site and it&#8217;s something we&#8217;re very excited about. We&#8217;d like to introduce you to Open Metrics &#8211; our real-time business metrics dashboard which publicly displays important metrics such as...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/say-hello-ultimate-member-open-metrics/\">Say hello to Ultimate Member Open Metrics</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5093:\"<p>Over the weekend we&#8217;ve been working on a cool addition to our site and it&#8217;s something we&#8217;re very excited about. We&#8217;d like to introduce you to <a href=\"https://ultimatemember.com/open-metrics/\">Open Metrics</a> &#8211; our real-time business metrics dashboard which publicly displays important metrics such as total revenue, number of sales, average order value and much more. If you&#8217;re wondering why we display this information then read on&#8230;</p>
<p><img class=\" size-full wp-image-15498 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-22-at-12.42.48.png\" alt=\"Screen Shot 2015-03-22 at 12.42.48\" width=\"696\" height=\"479\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Open Metrics</span></p>
<p>Our open metrics provide real-time insights into our business and allows you to see exactly how our business is performing on various fronts. Our metrics show important e-commerce metrics including: revenue, customers, average spend per customer, average order per customer, sales, orders, average order value and more.</p>
<p><a href=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-22-at-12.40.47.png\"><img class=\" size-full wp-image-15495 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-22-at-12.40.47.png\" alt=\"Screen Shot 2015-03-22 at 12.40.47\" width=\"945\" height=\"653\" /></a></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Live sales stream</span></p>
<p>Taking inspiration from <a href=\"https://blog.bufferapp.com/\" rel=\"nofollow\">Buffer</a>&#8216;s transparency culture and in particular their <a href=\"https://buffer.baremetrics.com/\" rel=\"nofollow\">Baremetrics live dashboard</a> we have added a live sales stream to our metrics dashboard. Our sales stream allow you to see exactly when a sale is made, what the person bought, the order value and whether a discount has been applied.</p>
<p><img class=\" size-full wp-image-15496 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-22-at-12.41.01.png\" alt=\"Screen Shot 2015-03-22 at 12.41.01\" width=\"466\" height=\"621\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Charts</span></p>
<p>We&#8217;ve also added a couple of charts to the metrics dashboard which show the total sales for each extension and also shows our daily revenue figures for the current month. We plan on adding more charts to the dashboard as more data becomes available.</p>
<p><img class=\" size-full wp-image-15497 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/03/Screen-Shot-2015-03-22-at-12.41.18.png\" alt=\"Screen Shot 2015-03-22 at 12.41.18\" width=\"706\" height=\"516\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Why we are publicly displaying our metrics</span></p>
<p>Ultimate Member has always had a business model behind it from the day the plugin was conceived. We knew from the beginning that we would monetize the business through extension sales. We felt that the market was lacking a plugin such as Ultimate Member so we decided to build it but when it came to evaluating the market it was harder to see how financially succesful other plugins were.</p>
<p>The majority of WordPress businesses do not reveal their figures but thankfully some businesses do and we were especially lucky some of the plugins that revealed their figures also used the free core version + paid extensions model (<a href=\"https://pippinsplugins.com/2014-review/\" rel=\"nofollow\">EDD</a>, <a href=\"http://wpninjas.com/2014-review/\" rel=\"nofollow\">Ninja Forms</a>). These plugin&#8217;s figures were of massive help when it came to deciding whether or not to proceed with building Ultimate Member as they showed it is possible to run a successful and sustainable WordPress plugin business.</p>
<p>Deciding to display our metrics to the whole World was not a tough decision. We&#8217;re big believers in openness and transparency and we feel 100% comfortable sharing them with our paying customers, free users and the WordPress community.</p>
<p>We hope by publicly displaying our metrics it will provide useful insights for other entrepreneurs, developers and business owners and enable them to make more informed decisions when it comes to building a WordPress plugin business.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Thoughts?</span></p>
<p>We&#8217;re trying to take openness and transparency within the WordPress community to a new level. We&#8217;d love to hear your thoughts on our Open Metrics Dashboard. If you have any questions or want to see some more data added then post a comment below.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/say-hello-ultimate-member-open-metrics/\">Say hello to Ultimate Member Open Metrics</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://ultimatemember.com/say-hello-ultimate-member-open-metrics/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Introducing Ultimate Member extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://ultimatemember.com/introducing-ultimate-member-extensions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://ultimatemember.com/introducing-ultimate-member-extensions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Mar 2015 11:42:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=12391\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:523:\"<p>Today, I am excited to announce that after two months of development the first extensions for Ultimate Member are now available for purchase. The first extensions we have built are: Social login, MailChimp, bbPress, myCRED and Google reCAPTCHA. Social login The social...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/introducing-ultimate-member-extensions/\">Introducing Ultimate Member extensions</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8635:\"<p>Today, I am excited to announce that after two months of development the first extensions for Ultimate Member are now available for purchase. The first extensions we have built are: <a href=\"https://ultimatemember.com/extensions/social-login/\">Social login</a>, <a href=\"https://ultimatemember.com/extensions/mailchimp/\">MailChimp</a>, <a href=\"https://ultimatemember.com/extensions/bbpress/\">bbPress</a>, <a href=\"https://ultimatemember.com/extensions/mycred/\">myCRED</a> and <a href=\"https://ultimatemember.com/extensions/google-recaptcha/\">Google reCAPTCHA</a>.</p>
<p><img class=\" size-full wp-image-11157 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/sociallogin.png\" alt=\"Social Login\" width=\"800\" height=\"300\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Social login</span></p>
<p>The <a href=\"https://ultimatemember.com/extensions/social-login/\">social login</a> extension enables you to add social login to your site so users can register/login via their social network accounts rather than having to sign-up for a new account and remember the login details.</p>
<p><img class=\" size-full wp-image-9972 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/mailchimp-01-copy.png\" alt=\"MailChimp\" width=\"800\" height=\"300\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">MailChimp</span></p>
<p>The <a href=\"https://ultimatemember.com/extensions/mailchimp/\">MailChimp</a> extension allows users to subscribe to your mailing lists when signing up. Users can also subscribe/unsubscribe from your mailing lists directly from their account page.</p>
<p><img class=\" size-full wp-image-9975 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/bbpress-copy.png\" alt=\"bbPress\" width=\"800\" height=\"300\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">bbPress</span></p>
<p>The <a href=\"https://ultimatemember.com/extensions/bbpress/\">bbPress</a> extension integrates bbPress with Ultimate Member and displays a user&#8217;s bbPress stats on their Ultimate Member profile rather than the default bbPress profile. The extension also provides content restrict features on a user role basis.</p>
<p><img class=\" size-full wp-image-11767 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/mycred1.png\" alt=\"myCRED\" width=\"800\" height=\"300\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">myCRED</span></p>
<p>The <a href=\"https://ultimatemember.com/extensions/mycred/\">myCRED</a> extension integrates the popular points management plugin myCRED with Ultimate Member and allows you to display a user points, ranking and badges directly on user profiles.</p>
<p><img class=\" size-full wp-image-9973 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/recaptcha-01-copy.png\" alt=\"Google reCAPTCHA\" width=\"800\" height=\"300\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Google reCAPTCHA (Free)</span></p>
<p>The free <a href=\"https://ultimatemember.com/extensions/google-recaptcha/\">Google reCAPTCHA </a>extension allows you to add the new Google reCAPTCHA to your register and login forms to provide even more protection against spam bots.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Why the extensions model?</span></p>
<p>When we first started building Ultimate Member we always planned on generating revenue from the plugin so we were able to run a sustainable business. Whilst many different business models exist for plugins such as: Free plugin with support only provided to paying customers; free lite version + paid pro version; premium only plugins; SAAS plugins we decided that a free core version + paid extensions was the best model for us to use. We chose this for several reasons which I have outlined below.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Sustainable business model</span></p>
<p>One of the biggest fears users of WordPress plugins have is using a plugin or theme on their site then one day finding out that the plugin they built their website around is no longer actively supported or developed. By using the extension model it provides us with the most sustainable business model which will ensure that Ultimate Member is supported and developed for many years to come.</p>
<p>A sustainable business model for our plugin means charging prices that ensures the business brings in enough revenue to support us and our families now and also factors in the potential for future growth as the user base for Ultimate Member grows. It also means selling annual licenses rather than lifetime licenses. Running a sustainable business model is one of the main reasons we chose this model for Ultimate Member.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">It&#8217;s a successful model</span></p>
<p>Part of the reason we chose the free core + paid extensions model is that there are already a lot of other plugins using this model to run successful and sustainable plugin businesses. Many of the plugins using this model have been around for many years and are still actively supported and developed proving core + extensions is a successful model to use.</p>
<p>The most well-known plugin using this model is WooCommerce. The company behind WooCommerce now has over 30 staff and without having the right plugin business model in place WooCommerce would not be the plugin it is today and be able to pay the wages of over 30 staff.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Plugin feature bloat</span></p>
<p>One of the reasons this model is the best model for Ultimate Member is that it keeps the core version lightweight, makes the codebase more manageable and reduces the potential for bugs/conflicts. When we built the core version of Ultimate Member we wanted to create a great plugin that people would love and find very useful. The plugin is very robust by itself and includes advanced features such as conditional logic for fields that you will struggle to find in many free dedicated form plugins.</p>
<p>What we have always wanted to avoid with the core version is adding more and more features to it that will make it heavier, slow it down and also make it more complicated for users to learn how to use. The extensions model allows us to offer additional features that not everyone wants or needs on their site whilst keeping the core version lightweight.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Better features</span></p>
<p>One of the biggest benefits of the free core + extensions models over the lite + pro version model is that because extensions are sold separately, generally the features offered in an extension will go much further and be more advanced than the same features if they were offered in a pro version.</p>
<p>This is because each extension is judged on its own merit so when we make an extension we make sure that the features offered in the extension are the best they can be otherwise no one would buy the extension. On the other hand developers using the lite + pro model have less incentive to offer the same depth of coding for each feature as their &#8216;pro&#8217; version is judged as a bundle of features rather than being judged on every component.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Summary</span></p>
<p>Whilst I understand it is nice when everything is free, the reality is that the plugin would never have been built-in the first place and we would not be able to support/develop the plugin in the long-term without a sustainable business model in place. So I hope the reasons I have outlined above will give you a better insight and understanding into why we have chosen this model and prices and with your support we look forward to building Ultimate Member into the best ever community/user/member based WordPress plugin.</p>
<p>If you have any questions about the extensions we have a <a href=\"https://ultimatemember.com/forums/forum/pre-purchase-questions/\">pre-purchase questions</a> forum where you can ask us about the extensions.</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/introducing-ultimate-member-extensions/\">Introducing Ultimate Member extensions</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://ultimatemember.com/introducing-ultimate-member-extensions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"How to manually approve new user registrations on your WordPress site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://ultimatemember.com/how-to-manually-approve-new-user-registrations-wordpress-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://ultimatemember.com/how-to-manually-approve-new-user-registrations-wordpress-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Feb 2015 13:47:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ultimatemember.com/?p=10933\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:541:\"<p>If you&#8217;ve ever wondered how to manually approve new user registrations on your WordPress site or have been looking for a plugin that allows you to do this then Ultimate Member may be the plugin for you. With Ultimate Member you...</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/how-to-manually-approve-new-user-registrations-wordpress-site/\">How to manually approve new user registrations on your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Calum Allison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6201:\"<p>If you&#8217;ve ever wondered how to manually approve new user registrations on your WordPress site or have been looking for a plugin that allows you to do this then Ultimate Member may be the plugin for you.</p>
<p>With Ultimate Member you can set up your site so that when a user registers they must be manually approved before they can login. Below I will show you how you can do this.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Turn on require admin review</span></p>
<p>By default new user registrations are automatically approved, meaning that as soon as a user successfully registers they become a member and are immediately logged into your site. So the first thing you need to do is turn on require admin review for users signing up. To do this you need to edit the user role and navigate to the registration options widget:</p>
<p><img class=\" size-full wp-image-10941 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-13.57.08.png\" alt=\"Screen Shot 2015-02-26 at 13.57.08\" width=\"944\" height=\"136\" /></p>
<p>The first option you will see is registration status which you need to change to &#8220;Require Admin Review&#8221;. Once you do this the options below will change and you will see that the default action taken after registration changes to &#8220;Show Custom Message&#8221;. You can either keep this action as it is (you can customize the message text below) or you can decide to redirect the user to a custom url.</p>
<p><img class=\" wp-image-10942 size-full aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-14.02.19.png\" alt=\"Screen Shot 2015-02-26 at 14.02.19\" width=\"942\" height=\"246\" /></p>
<p>Once you have set the registration status and decided upon the action you can then save the changes and now anyone registering on your site will have to be reviewed by an admin before they can be approved.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Setting up the registration form</span></p>
<p>When creating a site where an admin needs to approve registration it is normal for there to be certain criteria a user must meet for them to be approved (e.g must be male or female or above a certain age). So the next step is to add fields to your registration form that will enable you to collect the required information that will allow you to make a decision on whether to approve a member or not.</p>
<p>For example if creating a job site for graduates you could add fields to your register form asking sign ups if they have a degree, what degree result they got and the title of their degree. The user then completes the registration form and clicks the register button.</p>
<p><a href=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-14.18.20.png\"><img class=\" size-full wp-image-10947 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-14.18.20.png\" alt=\"Screen Shot 2015-02-26 at 14.18.20\" width=\"471\" height=\"545\" /></a></p>
<p>Once the user submits the form, the register form will disappear and they will be shown the custom message set on the user role page.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Reviewing the member</span></p>
<p>As soon as a member completes the registration form the user will show up on the users overview widget on the UM dashboard page which gives an overview of your site&#8217;s users.</p>
<p><img class=\" wp-image-10951 size-full aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-14.30.52.png\" alt=\"Screen Shot 2015-02-26 at 14.30.52\" width=\"612\" height=\"143\" /></p>
<p>If you click on the pending review link you will be taken to the users page where it will show a list of all the users requiring admin review. To review a member you need to hover the mouse over the user and click on the info link which will open up a modal containing that user&#8217;s submitted information.</p>
<p>Once you have reviewed the information you then need to either approve or reject the member. To do this all you need to do is select the checkbox next to the user, choose approve membership or reject membership from the take action dropdown and click apply. Depending on what action you take the user will either become a fully approved member or will be moved to the rejected list.</p>
<p><img class=\" size-full wp-image-10954 aligncenter\" src=\"https://ultimatemember.com/wp-content/uploads/2015/02/Screen-Shot-2015-02-26-at-14.36.23.png\" alt=\"Screen Shot 2015-02-26 at 14.36.23\" width=\"1248\" height=\"254\" /></p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Emails</span></p>
<p>When manually approving new users on your site it is important to keep users updated on the process and alert the admin to new pending users. Because of this Ultimate Member provides several customizable email templates which are automatically sent depending on user actions.</p>
<p>For the user they will receive an email letting them know that their application for membership is being reviewed and will also receive an approved or rejected email depending on whether the admin has approved their application or not.</p>
<p>The site admin also receives an email each time a new user registers which will allow the admin to quickly review the member and approve/reject their membership.</p>
<p style=\"text-align: center;\"><span style=\"font-size: 28px; font-weight: 600;\">Got a question?</span></p>
<p>If you have a question about manual admin approval for new users or Ultimate Member in general feel free to post on our <a title=\"Community Forums\" href=\"https://ultimatemember.com/forums/\">community forum</a> where I will be more than happy to answer any questions you have!</p>
<p>The post <a rel=\"nofollow\" href=\"https://ultimatemember.com/how-to-manually-approve-new-user-registrations-wordpress-site/\">How to manually approve new user registrations on your WordPress site</a> appeared first on <a rel=\"nofollow\" href=\"https://ultimatemember.com\">Ultimate Member</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://ultimatemember.com/how-to-manually-approve-new-user-registrations-wordpress-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:37:\"https://ultimatemember.com/blog/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:18:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 23 Apr 2015 15:48:19 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:14:\"content-length\";s:5:\"14523\";s:10:\"connection\";s:5:\"close\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:10:\"set-cookie\";a:2:{i:0;s:44:\"PHPSESSID=tcap2vq3pk9hc5d8qgt5gdu0r1; path=/\";i:1;s:72:\"edd_items_in_cart=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; path=/\";}s:7:\"expires\";s:29:\"Thu, 19 Nov 1981 08:52:00 GMT\";s:13:\"cache-control\";s:70:\"no-store, no-cache, must-revalidate, post-check=0, pre-check=0, public\";s:6:\"pragma\";s:8:\"no-cache\";s:10:\"x-pingback\";s:37:\"https://ultimatemember.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 23 Apr 2015 13:54:16 GMT\";s:4:\"etag\";s:34:\"\"acdb88b81597d0edc7cf56aaef8a04e9\"\";s:12:\"x-robots-tag\";s:14:\"noindex,follow\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";}s:5:\"build\";s:14:\"20150417135034\";}","no");
INSERT INTO `wp_options` VALUES("124455","su_presets_tooltip","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:10:{s:5:\"style\";s:6:\"yellow\";s:8:\"position\";s:5:\"north\";s:6:\"shadow\";s:2:\"no\";s:7:\"rounded\";s:2:\"no\";s:4:\"size\";s:7:\"default\";s:5:\"title\";s:0:\"\";s:7:\"content\";s:49:\"[su_button] Hover me to open tooltip [/su_button]\";s:8:\"behavior\";s:5:\"hover\";s:5:\"close\";s:2:\"no\";s:5:\"class\";s:0:\"\";}}}","yes");
INSERT INTO `wp_options` VALUES("124691","su_presets_row","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:2:{s:5:\"class\";s:0:\"\";s:7:\"content\";s:125:\"[su_column size=\"1/3\"]Content[/su_column]
[su_column size=\"1/3\"]Content[/su_column]
[su_column size=\"1/3\"]Content[/su_column]\";}}}","yes");
INSERT INTO `wp_options` VALUES("124797","su_presets_lightbox_content","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:10:{s:2:\"id\";s:0:\"\";s:5:\"width\";s:3:\"50%\";s:6:\"margin\";s:2:\"40\";s:7:\"padding\";s:2:\"40\";s:10:\"text_align\";s:6:\"center\";s:10:\"background\";s:7:\"#FFFFFF\";s:5:\"color\";s:7:\"#333333\";s:6:\"shadow\";s:20:\"0px 0px 15px #333333\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:14:\"Inline content\";}}}","yes");
INSERT INTO `wp_options` VALUES("124479","su_presets_button","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:17:{s:3:\"url\";s:0:\"\";s:6:\"target\";s:4:\"self\";s:5:\"style\";s:7:\"default\";s:10:\"background\";s:7:\"#000000\";s:5:\"color\";s:7:\"#FFFFFF\";s:4:\"size\";s:1:\"2\";s:4:\"wide\";s:2:\"no\";s:6:\"center\";s:2:\"no\";s:6:\"radius\";s:4:\"auto\";s:4:\"icon\";s:13:\"icon: clock-o\";s:10:\"icon_color\";s:7:\"#FFFFFF\";s:11:\"text_shadow\";s:4:\"none\";s:4:\"desc\";s:0:\"\";s:7:\"onclick\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:0:\"\";}}}","yes");
INSERT INTO `wp_options` VALUES("126230","_transient_timeout_feed_mod_2b16a4f9a2b7110ce37a7c1a0e3bbb94","1429847299","no");
INSERT INTO `wp_options` VALUES("126231","_transient_feed_mod_2b16a4f9a2b7110ce37a7c1a0e3bbb94","1429804099","no");
INSERT INTO `wp_options` VALUES("126267","um_cached_role_organisateur","a:29:{s:4:\"role\";s:12:\"organisateur\";s:9:\"role_name\";s:12:\"Organisateur\";s:18:\"can_access_wpadmin\";s:1:\"1\";s:20:\"can_not_see_adminbar\";s:1:\"0\";s:17:\"can_edit_everyone\";s:1:\"1\";s:19:\"can_delete_everyone\";s:1:\"0\";s:16:\"can_edit_profile\";s:1:\"1\";s:18:\"can_delete_profile\";s:1:\"0\";s:12:\"can_view_all\";s:1:\"1\";s:24:\"can_make_private_profile\";s:1:\"0\";s:26:\"can_access_private_profile\";s:1:\"1\";s:16:\"default_homepage\";s:1:\"1\";s:17:\"redirect_homepage\";s:0:\"\";s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:16:\"auto_approve_url\";s:0:\"\";s:16:\"checkmail_action\";s:12:\"show_message\";s:17:\"checkmail_message\";s:179:\"Merci pour votre inscription. Avant que vous puissiez vous connecter vous devez activer votre compte en cliquant sur le lien d\'activation que nous venons de vous envoyer par mail.\";s:13:\"checkmail_url\";s:0:\"\";s:18:\"url_email_activate\";s:0:\"\";s:14:\"pending_action\";s:12:\"show_message\";s:15:\"pending_message\";s:165:\"Merci d\'avoir souhaité l\'adhésion à notre site. Nous allons examiner vos détails et vous envoyer un mail pour vous informer de la suite donnée à votre demande.\";s:11:\"pending_url\";s:0:\"\";s:11:\"after_login\";s:16:\"redirect_profile\";s:18:\"login_redirect_url\";s:0:\"\";s:12:\"after_logout\";s:13:\"redirect_home\";s:19:\"logout_redirect_url\";s:0:\"\";s:12:\"after_delete\";s:13:\"redirect_home\";s:19:\"delete_redirect_url\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("126287","um_cached_role_webmestre","a:29:{s:4:\"role\";s:9:\"webmestre\";s:9:\"role_name\";s:9:\"Webmestre\";s:18:\"can_access_wpadmin\";s:1:\"1\";s:20:\"can_not_see_adminbar\";s:1:\"0\";s:17:\"can_edit_everyone\";s:1:\"1\";s:19:\"can_delete_everyone\";s:1:\"1\";s:16:\"can_edit_profile\";s:1:\"1\";s:18:\"can_delete_profile\";s:1:\"1\";s:12:\"can_view_all\";s:1:\"1\";s:24:\"can_make_private_profile\";s:1:\"1\";s:26:\"can_access_private_profile\";s:1:\"1\";s:16:\"default_homepage\";s:1:\"1\";s:17:\"redirect_homepage\";s:0:\"\";s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:16:\"auto_approve_url\";s:0:\"\";s:16:\"checkmail_action\";s:12:\"show_message\";s:17:\"checkmail_message\";s:179:\"Merci pour votre inscription. Avant que vous puissiez vous connecter vous devez activer votre compte en cliquant sur le lien d\'activation que nous venons de vous envoyer par mail.\";s:13:\"checkmail_url\";s:0:\"\";s:18:\"url_email_activate\";s:0:\"\";s:14:\"pending_action\";s:12:\"show_message\";s:15:\"pending_message\";s:165:\"Merci d\'avoir souhaité l\'adhésion à notre site. Nous allons examiner vos détails et vous envoyer un mail pour vous informer de la suite donnée à votre demande.\";s:11:\"pending_url\";s:0:\"\";s:11:\"after_login\";s:16:\"redirect_profile\";s:18:\"login_redirect_url\";s:0:\"\";s:12:\"after_logout\";s:13:\"redirect_home\";s:19:\"logout_redirect_url\";s:0:\"\";s:12:\"after_delete\";s:13:\"redirect_home\";s:19:\"delete_redirect_url\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("126366","um_cached_role_organisatrice","a:29:{s:4:\"role\";s:13:\"organisatrice\";s:9:\"role_name\";s:13:\"Organisatrice\";s:18:\"can_access_wpadmin\";s:1:\"1\";s:20:\"can_not_see_adminbar\";s:1:\"0\";s:17:\"can_edit_everyone\";s:1:\"1\";s:19:\"can_delete_everyone\";s:1:\"0\";s:16:\"can_edit_profile\";s:1:\"1\";s:18:\"can_delete_profile\";s:1:\"0\";s:12:\"can_view_all\";s:1:\"1\";s:24:\"can_make_private_profile\";s:1:\"0\";s:26:\"can_access_private_profile\";s:1:\"1\";s:16:\"default_homepage\";s:1:\"1\";s:17:\"redirect_homepage\";s:0:\"\";s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:16:\"auto_approve_url\";s:0:\"\";s:16:\"checkmail_action\";s:12:\"show_message\";s:17:\"checkmail_message\";s:179:\"Merci pour votre inscription. Avant que vous puissiez vous connecter vous devez activer votre compte en cliquant sur le lien d\'activation que nous venons de vous envoyer par mail.\";s:13:\"checkmail_url\";s:0:\"\";s:18:\"url_email_activate\";s:0:\"\";s:14:\"pending_action\";s:12:\"show_message\";s:15:\"pending_message\";s:165:\"Merci d\'avoir souhaité l\'adhésion à notre site. Nous allons examiner vos détails et vous envoyer un mail pour vous informer de la suite donnée à votre demande.\";s:11:\"pending_url\";s:0:\"\";s:11:\"after_login\";s:16:\"redirect_profile\";s:18:\"login_redirect_url\";s:0:\"\";s:12:\"after_logout\";s:13:\"redirect_home\";s:19:\"logout_redirect_url\";s:0:\"\";s:12:\"after_delete\";s:13:\"redirect_home\";s:19:\"delete_redirect_url\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("126741","cr3ativconfcategory_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("126650","cr3_conferencesettings_options","a:3:{s:18:\"authorbox_template\";s:4:\"prog\";s:19:\"authorbox_template2\";s:0:\"\";s:19:\"authorbox_template3\";s:5:\"inter\";}","yes");
INSERT INTO `wp_options` VALUES("126553","tribe_last_save_post","1429805787","yes");


DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=151212 DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` VALUES("5","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"1-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"1-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"1-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"1-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4","313","_wp_attached_file","2012/04/1.jpg");
INSERT INTO `wp_postmeta` VALUES("6","313","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("7","314","_wp_attached_file","2012/04/013.jpg");
INSERT INTO `wp_postmeta` VALUES("8","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/013.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"013-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"013-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"013-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"013-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"013-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"013-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"013-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"013-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"013-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"013-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"013-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"013-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("9","314","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("10","315","_wp_attached_file","2012/04/014.jpg");
INSERT INTO `wp_postmeta` VALUES("11","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/014.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"014-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"014-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"014-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"014-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"014-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"014-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"014-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"014-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"014-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"014-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"014-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"014-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"014-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("12","315","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("13","316","_wp_attached_file","2012/04/2.jpg");
INSERT INTO `wp_postmeta` VALUES("14","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/2.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"2-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"2-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"2-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"2-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"2-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"2-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"2-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("15","316","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("16","745","_wp_attached_file","2011/12/imac_big_demo.png");
INSERT INTO `wp_postmeta` VALUES("17","745","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2011/12/imac_big_demo.png\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x360.png\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x430.png\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x270.png\";s:5:\"width\";i:450;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("18","751","_avia_builder_template_single_portfolio_-_slider_two_third","{{{Single Portfolio - Slider Two Third}}}[av_two_third first]
[av_slideshow size=\'gallery\' animation=\'slide\' autoplay=\'true\' interval=\'5\']
[av_slide id=\'316\']
[av_slide id=\'315\']
[av_slide id=\'314\']
[av_slide id=\'313\']
[/av_slideshow]
[/av_two_third]

[av_one_third]
[av_textblock]
<h3>Portfolio Entry!</h3>
Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.
[/av_textblock]

[av_toggle_container initial=\'1\' mode=\'accordion\']
[av_toggle title=\'Client\']
<strong>XY Media</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

<strong>XY Media</strong> Website: <a href=\"http://www.wikipedia.com\">http://www.wikipedia.com</a>
[/av_toggle]
[av_toggle title=\'Our Task\']
<strong>Task</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu.
[/av_toggle]
[av_toggle title=\'Skills Involved\']
<strong>Skills</strong>
<ul>
	<li>Photoshop</li>
	<li>Indesign</li>
	<li>HTML</li>
	<li>CSS</li>
</ul>
[/av_toggle]
[/av_toggle_container]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_textblock]
<h4 style=\"text-align: center;\">Most Recent Entries</h4>
[/av_textblock]

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("47","734","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("48","734","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("49","734","_aviaLayoutBuilderCleanData","[av_layerslider id=\'1\']

[av_one_third first]
[av_icon_box icon=\'ue80c\' font=\'entypo-fontello\' position=\'left\' title=\'S‘inscrire à l’évènement\' link=\'page,1401\' linktarget=\'\' linkelement=\'both\']Inscrivez-vous dès maintenant en ligne aux prochaines 48h de la pige. La 4e édition se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres. Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'Découvrez le programme\' link=\'page,1722\' linktarget=\'\' linkelement=\'both\']Découvrez et téléchargez le programme de la prochaine édition. Les prochaine 48 h proposeront aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain. HORIZON 2030, un thème global et novateur afin d\'anticiper les évolutions de la presse et de se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue856\' font=\'entypo-fontello\' position=\'left\' title=\'Pratique\' link=\'page,821\' linktarget=\'\' linkelement=\'\']Pour anticiper tous les aspects pratiques de votre venue à Vichy, cliquez ici ! Que vous veniez en voiture, en co-voiturage, en train ou encore à pieds, passez donc par cette rubrique afin de connaître l\'indispensable sur les prochaines 48h de la pige. Un forum est à votre disposition afin de partager un transport ou encore un hébergement sur place !</strong>

[/av_icon_box]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']
[av_one_full first]

[av_textblock]
<a href=\"http://dev48h.pigiste.org/portfolio-item/les-48h-en-images/\" title=\"Les 48H en images\">
<h2 style=\"text-align: center;\">Découvrez la galerie photo des 48h</h2>
</a>
[/av_textblock]

[av_hr class=\'short\' height=\'70\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]
[/av_section]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']

[av_one_fifth first]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/audiens.png\' attachment=\'1916\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.audiens.org/pigiste/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/afdas.png\' attachment=\'1915\' align=\'center\' animation=\'no-animation\' link=\'manually,https://www.afdas.com/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/scam.png\' attachment=\'1917\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/pole-univ-01-footer.png\' attachment=\'1925\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2014/05/logos-allier-01.png\' attachment=\'2034\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][/av_section]");
INSERT INTO `wp_postmeta` VALUES("1088","1407","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1089","1407","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1090","1407","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1092","44","_edit_lock","1398426608:1");
INSERT INTO `wp_postmeta` VALUES("1093","1410","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1094","1410","_edit_lock","1429352496:5");
INSERT INTO `wp_postmeta` VALUES("1095","1410","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1096","1410","_aviaLayoutBuilderCleanData","[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Découvrez les 48H en images\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1097","1410","_avia_builder_shortcode_tree","a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("1240","1433","_thumbnail_id","1438");
INSERT INTO `wp_postmeta` VALUES("1098","1410","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1099","1410","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1100","1410","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1101","1410","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1102","1410","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1103","1410","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1104","1410","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1105","1410","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1106","1410","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1107","1410","header","yes");
INSERT INTO `wp_postmeta` VALUES("1108","1410","footer","");
INSERT INTO `wp_postmeta` VALUES("150147","39668","_mail","a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:42:\"[your-name] <wordpress@dev48h.pigiste.org>\";s:4:\"body\";s:199:\"De : [your-name] <[your-email]>
Sujet : [your-subject]

Corps du message :
[your-message]

--
Cet email a été envoyé via le formulaire de contact de Les 48h de la pige (http://dev48h.pigiste.org)\";s:9:\"recipient\";s:17:\"max.twa@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("1121","1413","_wp_attached_file","2011/12/IMG_6092.jpg");
INSERT INTO `wp_postmeta` VALUES("150146","39668","_form","<p>Votre nom (obligatoire)<br />
    [text* your-name] </p>

<p>Votre email (obligatoire)<br />
    [email* your-email] </p>

<p>Sujet<br />
    [text your-subject] </p>

<p>Votre message<br />
    [textarea your-message] </p>

<p>[submit \"Envoyer\"]</p>");
INSERT INTO `wp_postmeta` VALUES("1122","1413","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1123","1414","_wp_attached_file","2011/12/IMG_6094.jpg");
INSERT INTO `wp_postmeta` VALUES("1124","1414","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6094.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6094-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6094-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6094-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6094-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6094-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6094-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6094-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6094-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("50","734","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("51","734","sidebar","");
INSERT INTO `wp_postmeta` VALUES("52","734","header","no");
INSERT INTO `wp_postmeta` VALUES("53","734","_avia_builder_shortcode_tree","a:6:{i:0;a:3:{s:3:\"tag\";s:14:\"av_layerslider\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:5;}i:4;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}i:2;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:8;}}s:5:\"index\";i:7;}i:5;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:5:{i:0;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:14;}}s:5:\"index\";i:13;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:15;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}}s:5:\"index\";i:17;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:20;}}s:5:\"index\";i:19;}i:4;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:21;}}s:5:\"index\";i:12;}}");
INSERT INTO `wp_postmeta` VALUES("1330","1496","_wp_attached_file","2011/12/BCR7704.jpg");
INSERT INTO `wp_postmeta` VALUES("1331","1496","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7704.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7704-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7704-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7704-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7704-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7704-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7704-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7704-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7704-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1071","1401","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1072","1401","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1073","1401","_aviaLayoutBuilderCleanData","[av_fullscreen size=\'extra_large\' animation=\'fade\' autoplay=\'false\' interval=\'5\']
[av_fullscreen_slide id=\'1635\' position=\'Center Center\' title=\'\' caption_pos=\'caption_bottom\' link=\'\' link_target=\'\' link_apply=\'\' button_label=\'Click me\' button_color=\'light\'][/av_fullscreen_slide]
[/av_fullscreen]

[av_one_full first]
[av_heading heading=\'S‘inscrire à l’édition 2014 des 48h de la pige\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]
[/av_one_full]

[av_textblock ]
<p><strong> Les inscriptions sont closes pour l\'année 2014 ! Rendez-vous l\'année prochaine !</strong>

<em>L\'inscription aux 48h de la pige est gratuite. L\'évènement est ouvert à tous les journalistes pigistes.<br />Pour enregistrer votre inscription nous vous invitons à remplir ce formulaire. Il nous permettra de mieux vous accueillir et répondre à vos besoins en terme d\'hébergement, co-voiturage, restauration...</em></p>

[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("1074","1401","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:13:\"av_fullscreen\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}");
INSERT INTO `wp_postmeta` VALUES("1075","1401","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1076","1401","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1077","1401","header","yes");
INSERT INTO `wp_postmeta` VALUES("1078","1401","footer","");
INSERT INTO `wp_postmeta` VALUES("1079","1407","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1080","1407","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1081","1407","_menu_item_object_id","1401");
INSERT INTO `wp_postmeta` VALUES("61","756","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("62","756","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("63","756","sidebar","");
INSERT INTO `wp_postmeta` VALUES("64","756","header","yes");
INSERT INTO `wp_postmeta` VALUES("65","756","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("66","756","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("67","756","_aviaLayoutBuilderCleanData","[av_portfolio columns=\'4\' items=\'16\' contents=\'title\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_textblock]
This is an example of a sortable, 4 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.

You can add Portfolio Grids to every Page you want or need, with the help of the fantastic and easy to use template builder that is built right into the theme.
[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("115","821","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("116","821","sidebar","");
INSERT INTO `wp_postmeta` VALUES("117","821","header","yes");
INSERT INTO `wp_postmeta` VALUES("118","821","_dp_original","812");
INSERT INTO `wp_postmeta` VALUES("119","821","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("120","821","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("121","821","_aviaLayoutBuilderCleanData","[av_heading tag=\'h3\' padding=\'10\' heading=\'Anticipez tous les aspects pratiques de votre venue à Vichy !\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_one_half first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2014/04/P11705391-710x575.jpg\' attachment=\'1544\' align=\'center\' animation=\'left-to-right\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_textblock]
<h2>Bienvenue à Vichy !</h2>
[/av_textblock]

[av_textblock]
La 4e édition des 48 heures de la pige se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres
[/av_textblock]

[av_sidebar widget_area=\'Google Map\']
[/av_one_half]

[av_hr class=\'big\' height=\'50\' position=\'center\']

[av_one_fourth first]

[av_icon_box icon=\'ue8d7\' font=\'entypo-fontello\' position=\'left\' title=\'Comment venir ?\' link=\'page,1792\' linktarget=\'\' linkelement=\'both\']
<p>Pour connaître toutes les informations utiles concernant votre arrivée et les moyens de transport pour Vichy, c\'est par ici !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8b5\' font=\'entypo-fontello\' position=\'left\' title=\'Où dormir ?\' link=\'page,1801\' linktarget=\'\' linkelement=\'both\']
<p>Nous vous proposons plusieurs options pour vous loger sur place, découvrez ici les hôtels disponibles et renseignez la case hébergement lors de votre inscription !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8a9\' font=\'entypo-fontello\' position=\'left\' title=\'Que manger ?\' link=\'\' linktarget=\'\' linkelement=\'\']
<p>Si vous le désirez, vous pourrez vous restaurer sur place ! Renseignez simplement la case restauration lors de votre inscription à l\'événement</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue836\' font=\'entypo-fontello\' position=\'left\' title=\'Le forum\' link=\'page,1750\' linktarget=\'\' linkelement=\'both\']
<p>Pas envie de voyager ni de se loger seul(e) ? Partagez ici vos moyens de transport ou encore votre hébergement grâce à notre forum pratique !</p>

[/av_icon_box]

[/av_one_fourth][av_hr class=\'big\' height=\'50\' position=\'center\']

");
INSERT INTO `wp_postmeta` VALUES("1586","1629","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1588","1630","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:21:\"2014/04/textvichy.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"textvichy-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"textvichy-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"textvichy-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"textvichy-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"textvichy-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"textvichy-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"textvichy-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"textvichy-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"textvichy-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("122","821","_avia_builder_shortcode_tree","a:9:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:1;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:2;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}i:4;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}}s:5:\"index\";i:8;}i:5;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:10;}i:6;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:7;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}}s:5:\"index\";i:14;}i:8;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}");
INSERT INTO `wp_postmeta` VALUES("1577","1629","_menu_item_object_id","821");
INSERT INTO `wp_postmeta` VALUES("1578","1629","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1579","1629","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1580","1629","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1581","1629","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1582","1629","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1587","1630","_wp_attached_file","2014/04/textvichy.png");
INSERT INTO `wp_postmeta` VALUES("1584","1629","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1585","1629","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("2370","1991","_wp_attached_file","2014/05/HUNTER-2013-original1.jpg");
INSERT INTO `wp_postmeta` VALUES("2371","1991","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:474;s:4:\"file\";s:33:\"2014/05/HUNTER-2013-original1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x474.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:474;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-705x427.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x273.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2740","2069","_wp_attached_file","2014/05/logo-CMB.bmp");
INSERT INTO `wp_postmeta` VALUES("2443","2013","_wp_attached_file","2013/04/S.Daycard-Heid-12.jpg");
INSERT INTO `wp_postmeta` VALUES("2444","2013","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:680;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-12.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-705x572.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:572;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x365.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:365;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2549","2034","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:87;s:4:\"file\";s:27:\"2014/05/logos-allier-01.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-180x87.png\";s:5:\"width\";i:180;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-120x87.png\";s:5:\"width\";i:120;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2550","2037","_wp_attached_file","2014/05/Allier_le_Departement_bleu.png");
INSERT INTO `wp_postmeta` VALUES("2551","2037","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1687;s:6:\"height\";i:480;s:4:\"file\";s:38:\"2014/05/Allier_le_Departement_bleu.png\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Allier_le_Departement_bleu-300x85.png\";s:5:\"width\";i:300;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x293.png\";s:5:\"width\";i:1030;s:6:\"height\";i:293;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x430.png\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x426.png\";s:5:\"width\";i:1500;s:6:\"height\";i:426;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x480.png\";s:5:\"width\";i:710;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-705x200.png\";s:5:\"width\";i:705;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x128.png\";s:5:\"width\";i:450;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2352","1978","_wp_attached_file","2014/05/g.le_roux.jpg");
INSERT INTO `wp_postmeta` VALUES("2278","1963","_wp_attached_file","2014/05/cistude_romain_riols.jpg");
INSERT INTO `wp_postmeta` VALUES("2279","1963","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:4:\"file\";s:32:\"2014/05/cistude_romain_riols.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:34:\"cistude_romain_riols-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2353","1978","_wp_attachment_metadata","a:5:{s:5:\"width\";i:4592;s:6:\"height\";i:2576;s:4:\"file\";s:21:\"2014/05/g.le_roux.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"g.le_roux-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"g.le_roux-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x577.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:577;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"g.le_roux-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"g.le_roux-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x841.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:841;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"g.le_roux-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"g.le_roux-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"g.le_roux-705x395.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"g.le_roux-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x252.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DSLR-A290\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1344353630;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"300\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:9:\"0.0015625\";s:5:\"title\";s:8:\"SONY DSC\";}}");
INSERT INTO `wp_postmeta` VALUES("2354","1979","_wp_attached_file","2014/05/riols_romain_milan_noir.jpg");
INSERT INTO `wp_postmeta` VALUES("2355","1979","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:35:\"2014/05/riols_romain_milan_noir.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:37:\"riols_romain_milan_noir-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:3.7000000000000002;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:29:\"Konica Digital Camera KD-310Z\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1049047227;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"14.2\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0156\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2356","1980","_wp_attached_file","2014/05/val_dallier_jean_jacques_lallemant.jpg");
INSERT INTO `wp_postmeta` VALUES("2357","1980","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2362;s:6:\"height\";i:1586;s:4:\"file\";s:46:\"2014/05/val_dallier_jean_jacques_lallemant.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x691.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:48:\"val_dallier_jean_jacques_lallemant-1500x1007.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1007;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-705x473.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x302.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:302;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2360","1986","_wp_attached_file","2014/05/HUNTER-20131.jpg");
INSERT INTO `wp_postmeta` VALUES("2361","1986","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1295;s:4:\"file\";s:24:\"2014/05/HUNTER-20131.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-795x1030.jpg\";s:5:\"width\";i:795;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2362","1987","_wp_attached_file","2014/05/HUNTER-20132.jpg");
INSERT INTO `wp_postmeta` VALUES("2363","1987","_wp_attachment_metadata","a:5:{s:5:\"width\";i:667;s:6:\"height\";i:864;s:4:\"file\";s:24:\"2014/05/HUNTER-20132.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x430.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x575.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x270.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x360.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2364","1988","_wp_attached_file","2014/05/HUNTER-20133.jpg");
INSERT INTO `wp_postmeta` VALUES("2365","1988","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2014/05/HUNTER-20133.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-205x300.jpg\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x575.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x655.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:655;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2366","1989","_wp_attached_file","2014/05/HUNTER-20134.jpg");
INSERT INTO `wp_postmeta` VALUES("2367","1989","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:473;s:4:\"file\";s:24:\"2014/05/HUNTER-20134.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-290x300.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x464.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:464;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2368","1990","_wp_attached_file","2014/05/HUNTER-2013-original.jpg");
INSERT INTO `wp_postmeta` VALUES("2369","1990","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:576;s:4:\"file\";s:32:\"2014/05/HUNTER-2013-original.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-300x221.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-705x519.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x331.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("307","44","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("308","44","_avia_elements_avia_options_propulsion","s:1046:\"a:6:{s:4:\"hero\";s:3:\"yes\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `wp_postmeta` VALUES("309","44","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("310","44","_avia_elements_avia_options_coherence","s:1436:\"a:13:{s:8:\"subtitle\";s:45:\"Donec pede justo, fringilla vel, aliquet nec!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:10:\"Flashlight\";s:16:\"portfolio-meta-3\";s:91:\"&lt;a href=&quot;http://www.kriesi.at/themes/flashlight/&quot;&gt;Flashlight Demo&lt;/a&gt;\";}\";");
INSERT INTO `wp_postmeta` VALUES("1139","44","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("312","44","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("313","44","_facebookcount-cache","0");
INSERT INTO `wp_postmeta` VALUES("314","44","_twittercount-cache","0");
INSERT INTO `wp_postmeta` VALUES("315","44","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("316","44","_aviaLayoutBuilderCleanData","[av_two_third first]

[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1490,1491,1492,1493,1494,1496,1497,1498,1499,1500\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']

[/av_two_third][av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1142","44","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1143","44","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1144","44","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1145","44","_preview_columns","8");
INSERT INTO `wp_postmeta` VALUES("1146","44","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1147","44","footer","");
INSERT INTO `wp_postmeta` VALUES("317","44","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1140","44","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1141","44","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("318","44","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("319","44","sidebar","");
INSERT INTO `wp_postmeta` VALUES("320","44","header","yes");
INSERT INTO `wp_postmeta` VALUES("375","1167","header","yes");
INSERT INTO `wp_postmeta` VALUES("376","1167","_wp_page_template","contact.php");
INSERT INTO `wp_postmeta` VALUES("377","1167","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("378","1167","_aviaLayoutBuilderCleanData","[av_sidebar widget_area=\'Contact\']

[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Contactez-nous !\' color=\'meta-heading\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_contact email=\'aurore.staiger@hotmail.fr\' button=\'Envoyer\' title=\'\' sent=\'Votre message a bien été envoyé!\' subject=\'\' autorespond=\'\' captcha=\'\']
[av_contact_field label=\'Nom\' type=\'text\' options=\'\' check=\'is_empty\' width=\'element_half\']
[av_contact_field label=\'E-Mail\' type=\'text\' options=\'\' check=\'is_email\' width=\'element_half\']
[av_contact_field label=\'Sujet de votre message\' type=\'text\' options=\'\' check=\'is_empty\' width=\'\']
[av_contact_field label=\'Message\' type=\'textarea\' options=\'\' check=\'is_empty\' width=\'\']
[/av_contact]

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1607","1639","_wp_attachment_metadata","a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:22:\"2013/04/favicon-01.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1063","734","_edit_lock","1429800495:5");
INSERT INTO `wp_postmeta` VALUES("379","1167","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("380","1167","sidebar","");
INSERT INTO `wp_postmeta` VALUES("381","1167","_avia_builder_shortcode_tree","a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:1;a:3:{s:3:\"tag\";s:10:\"av_contact\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:1;}}");
INSERT INTO `wp_postmeta` VALUES("1606","1639","_wp_attached_file","2013/04/favicon-01.png");
INSERT INTO `wp_postmeta` VALUES("1085","1407","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("2439","2009","_wp_attached_file","2013/04/S.Daycard-Heid-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2440","2009","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:1176;s:4:\"file\";s:28:\"2013/04/S.Daycard-Heid-1.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-1-733x1030.jpg\";s:5:\"width\";i:733;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-501x705.jpg\";s:5:\"width\";i:501;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x632.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:632;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2548","2034","_wp_attached_file","2014/05/logos-allier-01.png");
INSERT INTO `wp_postmeta` VALUES("2441","2011","_wp_attached_file","2013/04/S.Daycard-Heid-11.jpg");
INSERT INTO `wp_postmeta` VALUES("2442","2011","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:738;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-11.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-300x264.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-705x621.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:621;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x396.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("422","1248","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("423","1248","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("424","1248","sidebar","");
INSERT INTO `wp_postmeta` VALUES("425","1248","header","yes");
INSERT INTO `wp_postmeta` VALUES("426","1248","_avia_builder_shortcode_tree","a:31:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:5;}i:3;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}}s:5:\"index\";i:8;}i:4;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}i:5;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:6;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:14;}i:7;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:19;}}s:5:\"index\";i:17;}i:8;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:21;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:20;}i:9;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:24;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:25;}}s:5:\"index\";i:23;}i:10;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:27;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:28;}}s:5:\"index\";i:26;}i:11;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:30;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:31;}}s:5:\"index\";i:29;}i:12;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:32;}i:13;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:34;}}s:5:\"index\";i:33;}i:14;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:35;}i:15;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:37;}}s:5:\"index\";i:36;}i:16;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:39;}}s:5:\"index\";i:38;}i:17;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:41;}}s:5:\"index\";i:40;}i:18;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:43;}}s:5:\"index\";i:42;}i:19;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:45;}}s:5:\"index\";i:44;}i:20;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:47;}}s:5:\"index\";i:46;}i:21;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:48;}i:22;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:50;}}s:5:\"index\";i:49;}i:23;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:51;}i:24;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:53;}}s:5:\"index\";i:52;}i:25;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:55;}}s:5:\"index\";i:54;}i:26;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:56;}i:27;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:58;}}s:5:\"index\";i:57;}i:28;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:59;}i:29;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:61;}}s:5:\"index\";i:60;}i:30;a:3:{s:3:\"tag\";s:9:\"av_button\";s:7:\"content\";a:0:{}s:5:\"index\";i:62;}}");
INSERT INTO `wp_postmeta` VALUES("1462","1248","footer","");
INSERT INTO `wp_postmeta` VALUES("150163","39671","_um_profile_use_globals","1");
INSERT INTO `wp_postmeta` VALUES("427","1248","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("428","1248","_aviaLayoutBuilderCleanData","[av_one_full first]
[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'JEUDI 2 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\']
Durant ces deux journée des jeunes “facilitateurs” polyglottes du CUEJ ou de European Youthpress seront présents accueillir et guider les participants.
[/av_icon_box]

[av_one_half first]
[av_heading heading=\'9h30 : Accueil et Ice breaker coffee\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\' attachment=\'1474\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_heading heading=\'10h30 : Réu de lancement Kick off meeting\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\' attachment=\'1485\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h00 : Ateliers flash partage de compétences Sharing skills\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'\' attachment=\'\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'L’apport du multimédia\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Laurent Gontier (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/GieffersHanna-2015-300x300.jpeg\' attachment=\'19703\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le webdocumentaire\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Hanna Gieffers (Allemagne)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/GuadagniTommaso-2015-300x300.jpg\' attachment=\'19702\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Datajournalisme\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Tommaso Guadagni

[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/MartiniereMathieu-2015-300x300.jpg\' attachment=\'19704\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réussir un crowfunding\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'2\']
Mathieu Martinière (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/StrassenburgRomy-2015-296x300.jpg\' attachment=\'19705\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Bien vendre ses piges\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Romy Strassenburg (Allemagne)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/SansonStern-2014-287x300.jpg\' attachment=\'19706\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réseaux sociaux\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Catherine Sanson-Stern (France)
[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/VallellianPatrick-2015-298x300.jpg\' attachment=\'19707\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le long format\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Patrick Vallelian (Suisse)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/WildNicolas-2015-300x300.jpg\' attachment=\'19710\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'La BD-reportage\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Nicolas Wild (France)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/BulligPaula-2015-300x299.jpg\' attachment=\'19709\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'La BD-reportage\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Paula Bullig (Allemagne)
[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'13h : Déjeuner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'14h30 : Workshop Créer un nouveau média en 2h ? C’est possible ! (Ou presque)\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
En mode « Media Lab », les participants se répartissent en 4 groupes thématiques à l’intérieur desquels ils s’organisent en équipes aux compétences complémentaires.
Guidés par des modérateurs de Profession Pigiste, avec Romain Saillet comme référent, chaque équipe élabore le squelette d’un projet éditorial.

[/av_heading]
[/av_one_full]

[av_one_fourth first]
[av_icon_box icon=\'ue80d\' font=\'entypo-fontello\' position=\'left\' title=\'Webdocumentaire\' link=\'\' linktarget=\'\' linkelement=\'\']Cliquer ici pour ajouter votre propre texte

[/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue83b\' font=\'entypo-fontello\' position=\'left\' title=\'Reportage\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue8ab\' font=\'entypo-fontello\' position=\'left\' title=\'Journalisme de données\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue833\' font=\'entypo-fontello\' position=\'left\' title=\'Long format\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h30 : Pause\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'17h : Présentation de l’Afdas\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'10\' heading=\'17h20 : Restitution des ateliers\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Chaque équipe a cinq minutes pour « pitcher » le projet sur lequel elle a travaillé et le présenter aux participants de son groupe. Chaque groupe élit le meilleur projet.
[/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'18h20 : Un moment de liberté\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'19h : Apéritif\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'20h30 : Dîner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec une intervention de Gabriele Bertolli, de la direction générale de la DG Connect à la Commission européenne.
[/av_heading]

[av_button label=\'Voir le programme du vendredi\' link=\'page,1720\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'right\' icon_select=\'yes\' icon=\'ue832\' font=\'entypo-fontello\']

");
INSERT INTO `wp_postmeta` VALUES("1475","1574","_wp_attached_file","2013/04/48hbyPP.png");
INSERT INTO `wp_postmeta` VALUES("1476","1574","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1146;s:6:\"height\";i:606;s:4:\"file\";s:19:\"2013/04/48hbyPP.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"48hbyPP-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"48hbyPP-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x544.png\";s:5:\"width\";i:1030;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"48hbyPP-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"48hbyPP-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1146x430.png\";s:5:\"width\";i:1146;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"48hbyPP-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"48hbyPP-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"48hbyPP-705x372.png\";s:5:\"width\";i:705;s:6:\"height\";i:372;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"48hbyPP-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x237.png\";s:5:\"width\";i:450;s:6:\"height\";i:237;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("150162","39671","_um_core","profile");
INSERT INTO `wp_postmeta` VALUES("150161","39671","_um_mode","profile");
INSERT INTO `wp_postmeta` VALUES("429","1248","_dp_original","1236");
INSERT INTO `wp_postmeta` VALUES("1572","821","_edit_lock","1429802300:5");
INSERT INTO `wp_postmeta` VALUES("1573","821","_edit_last","5");
INSERT INTO `wp_postmeta` VALUES("1575","1629","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1576","1629","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1012","1373","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:198;s:4:\"file\";s:26:\"2013/04/Logo48hcyan-01.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-300x106.png\";s:5:\"width\";i:300;s:6:\"height\";i:106;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-495x198.png\";s:5:\"width\";i:495;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x198.png\";s:5:\"width\";i:450;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x159.png\";s:5:\"width\";i:450;s:6:\"height\";i:159;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1011","1373","_wp_attached_file","2013/04/Logo48hcyan-01.png");
INSERT INTO `wp_postmeta` VALUES("1066","1401","_edit_last","5");
INSERT INTO `wp_postmeta` VALUES("1067","1401","_edit_lock","1429804641:5");
INSERT INTO `wp_postmeta` VALUES("1136","1420","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6159.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6159-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6159-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6159-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6159-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6159-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6159-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6159-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6159-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1135","1420","_wp_attached_file","2011/12/IMG_6159.jpg");
INSERT INTO `wp_postmeta` VALUES("1134","1419","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6157.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6157-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6157-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6157-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6157-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6157-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6157-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6157-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6157-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1133","1419","_wp_attached_file","2011/12/IMG_6157.jpg");
INSERT INTO `wp_postmeta` VALUES("1132","1418","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6115.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6115-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6115-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6115-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6115-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6115-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6115-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1131","1418","_wp_attached_file","2011/12/IMG_6115.jpg");
INSERT INTO `wp_postmeta` VALUES("1130","1417","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6114.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6114-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6114-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6114-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6114-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6114-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6114-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6114-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6114-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1129","1417","_wp_attached_file","2011/12/IMG_6114.jpg");
INSERT INTO `wp_postmeta` VALUES("1128","1416","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6111.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6111-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6111-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6111-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6111-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6111-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6111-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6111-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6111-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1127","1416","_wp_attached_file","2011/12/IMG_6111.jpg");
INSERT INTO `wp_postmeta` VALUES("1126","1415","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6097.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6097-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6097-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6097-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6097-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6097-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6097-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1125","1415","_wp_attached_file","2011/12/IMG_6097.jpg");
INSERT INTO `wp_postmeta` VALUES("1065","734","footer","");
INSERT INTO `wp_postmeta` VALUES("1083","1407","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1086","1407","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1060","1386","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1059","1386","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1058","1386","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1056","1386","_menu_item_url","http://dev48h.pigiste.org");
INSERT INTO `wp_postmeta` VALUES("1055","1386","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1054","1386","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1053","1386","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1052","1386","_menu_item_object","custom");
INSERT INTO `wp_postmeta` VALUES("1051","1386","_menu_item_object_id","1386");
INSERT INTO `wp_postmeta` VALUES("1050","1386","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1048","1385","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1047","1385","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1046","1385","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1064","734","_edit_last","5");
INSERT INTO `wp_postmeta` VALUES("1044","1385","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1043","1385","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1042","1385","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1041","1385","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1040","1385","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1037","1385","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1013","1373","av-custom-link","");
INSERT INTO `wp_postmeta` VALUES("1038","1385","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1039","1385","_menu_item_object_id","1167");
INSERT INTO `wp_postmeta` VALUES("1082","1407","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1049","1386","_menu_item_type","custom");
INSERT INTO `wp_postmeta` VALUES("1014","1374","_wp_attached_file","2014/04/Imac48h-01.png");
INSERT INTO `wp_postmeta` VALUES("1015","1374","_wp_attachment_metadata","a:5:{s:5:\"width\";i:284;s:6:\"height\";i:284;s:4:\"file\";s:22:\"2014/04/Imac48h-01.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-284x270.png\";s:5:\"width\";i:284;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1016","1375","_wp_attached_file","2014/04/ipad.png");
INSERT INTO `wp_postmeta` VALUES("1017","1375","_wp_attachment_metadata","a:5:{s:5:\"width\";i:257;s:6:\"height\";i:200;s:4:\"file\";s:16:\"2014/04/ipad.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"ipad-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:14:\"ipad-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:16:\"ipad-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:16:\"ipad-257x185.png\";s:5:\"width\";i:257;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1018","1376","_wp_attached_file","2014/04/ipad48h.png");
INSERT INTO `wp_postmeta` VALUES("1019","1376","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1069;s:6:\"height\";i:826;s:4:\"file\";s:19:\"2014/04/ipad48h.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ipad48h-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"ipad48h-300x231.png\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x795.png\";s:5:\"width\";i:1030;s:6:\"height\";i:795;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"ipad48h-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"ipad48h-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"ipad48h-1069x430.png\";s:5:\"width\";i:1069;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"ipad48h-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"ipad48h-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"ipad48h-705x544.png\";s:5:\"width\";i:705;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"ipad48h-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x347.png\";s:5:\"width\";i:450;s:6:\"height\";i:347;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1020","1377","_wp_attached_file","2014/04/ipad48h2.png");
INSERT INTO `wp_postmeta` VALUES("1021","1377","_wp_attachment_metadata","a:5:{s:5:\"width\";i:534;s:6:\"height\";i:413;s:4:\"file\";s:20:\"2014/04/ipad48h2.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48h2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"ipad48h2-300x232.png\";s:5:\"width\";i:300;s:6:\"height\";i:232;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"ipad48h2-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"ipad48h2-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"ipad48h2-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"ipad48h2-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x270.png\";s:5:\"width\";i:534;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x360.png\";s:5:\"width\";i:534;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"ipad48h2-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x413.png\";s:5:\"width\";i:450;s:6:\"height\";i:413;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x348.png\";s:5:\"width\";i:450;s:6:\"height\";i:348;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1022","1378","_wp_attached_file","2014/04/imac48.png");
INSERT INTO `wp_postmeta` VALUES("1023","1378","_wp_attachment_metadata","a:5:{s:5:\"width\";i:788;s:6:\"height\";i:633;s:4:\"file\";s:18:\"2014/04/imac48.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"imac48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"imac48-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"imac48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"imac48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:18:\"imac48-788x430.png\";s:5:\"width\";i:788;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"imac48-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"imac48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:18:\"imac48-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:18:\"imac48-705x566.png\";s:5:\"width\";i:705;s:6:\"height\";i:566;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-788x360.png\";s:5:\"width\";i:788;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"imac48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"imac48-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"imac48-450x361.png\";s:5:\"width\";i:450;s:6:\"height\";i:361;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1024","1379","_wp_attached_file","2014/04/imac48heures.png");
INSERT INTO `wp_postmeta` VALUES("1025","1379","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:24:\"2014/04/imac48heures.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"imac48heures-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"imac48heures-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"imac48heures-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"imac48heures-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"imac48heures-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"imac48heures-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"imac48heures-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1026","1380","_wp_attached_file","2014/04/imac48heures3.png");
INSERT INTO `wp_postmeta` VALUES("1027","1380","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:25:\"2014/04/imac48heures3.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac48heures3-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac48heures3-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac48heures3-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac48heures3-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac48heures3-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac48heures3-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac48heures3-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1028","1381","_wp_attached_file","2014/04/ipad48.png");
INSERT INTO `wp_postmeta` VALUES("1029","1381","_wp_attachment_metadata","a:5:{s:5:\"width\";i:320;s:6:\"height\";i:414;s:4:\"file\";s:18:\"2014/04/ipad48.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"ipad48-231x300.png\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"ipad48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"ipad48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"ipad48-320x400.png\";s:5:\"width\";i:320;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"ipad48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x270.png\";s:5:\"width\";i:320;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x360.png\";s:5:\"width\";i:320;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1030","1382","_wp_attached_file","2014/04/ipa.png");
INSERT INTO `wp_postmeta` VALUES("1031","1382","_wp_attachment_metadata","a:5:{s:5:\"width\";i:215;s:6:\"height\";i:278;s:4:\"file\";s:15:\"2014/04/ipa.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"ipa-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"ipa-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"ipa-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"ipa-215x185.png\";s:5:\"width\";i:215;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"ipa-215x270.png\";s:5:\"width\";i:215;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"ipa-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1032","1383","_wp_attached_file","2014/04/txt.png");
INSERT INTO `wp_postmeta` VALUES("1033","1383","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:15:\"2014/04/txt.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"txt-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"txt-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"txt-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:14:\"txt-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:14:\"txt-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:14:\"txt-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:14:\"txt-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:14:\"txt-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:14:\"txt-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1034","1167","_edit_lock","1429800333:5");
INSERT INTO `wp_postmeta` VALUES("1035","1167","_edit_last","5");
INSERT INTO `wp_postmeta` VALUES("1084","1407","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1036","1167","footer","nofooterwidgets");
INSERT INTO `wp_postmeta` VALUES("1137","1421","_wp_attached_file","2011/12/IMG_6167.jpg");
INSERT INTO `wp_postmeta` VALUES("1138","1421","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6167.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6167-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6167-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6167-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6167-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6167-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6167-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1148","44","_thumbnail_id","1420");
INSERT INTO `wp_postmeta` VALUES("1149","1422","_wp_attached_file","2011/12/IMG_5363.jpg");
INSERT INTO `wp_postmeta` VALUES("1150","1422","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5363.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5363-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5363-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5363-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5363-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5363-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5363-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5363-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5363-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1151","1423","_wp_attached_file","2011/12/IMG_5365.jpg");
INSERT INTO `wp_postmeta` VALUES("1152","1423","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5365.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5365-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5365-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5365-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5365-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5365-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5365-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5365-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5365-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1153","1424","_wp_attached_file","2011/12/IMG_5366.jpg");
INSERT INTO `wp_postmeta` VALUES("1154","1424","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5366.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5366-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5366-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5366-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5366-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5366-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5366-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5366-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5366-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1155","1425","_wp_attached_file","2011/12/IMG_5368.jpg");
INSERT INTO `wp_postmeta` VALUES("1156","1425","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5368.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5368-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5368-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5368-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5368-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5368-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5368-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5368-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5368-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1157","1426","_wp_attached_file","2011/12/IMG_5371.jpg");
INSERT INTO `wp_postmeta` VALUES("1158","1426","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5371.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5371-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5371-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5371-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5371-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5371-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5371-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5371-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5371-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1159","1427","_wp_attached_file","2011/12/IMG_5373.jpg");
INSERT INTO `wp_postmeta` VALUES("1160","1427","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5373.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5373-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5373-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5373-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5373-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5373-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5373-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5373-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5373-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1161","1428","_wp_attached_file","2011/12/IMG_5375.jpg");
INSERT INTO `wp_postmeta` VALUES("1162","1428","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5375.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5375-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5375-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5375-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5375-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5375-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5375-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5375-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5375-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5375-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1163","1429","_wp_attached_file","2011/12/IMG_8601.jpg");
INSERT INTO `wp_postmeta` VALUES("1164","1429","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8601.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8601-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8601-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8601-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8601-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8601-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8601-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8601-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8601-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8601-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1165","1430","_wp_attached_file","2011/12/IMG_8602.jpg");
INSERT INTO `wp_postmeta` VALUES("1166","1430","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8602.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8602-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8602-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8602-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8602-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8602-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8602-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8602-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8602-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8602-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1167","1431","_wp_attached_file","2011/12/IMG_8605.jpg");
INSERT INTO `wp_postmeta` VALUES("1168","1431","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_8605.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8605-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8605-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8605-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8605-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8605-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8605-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8605-705x705.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8605-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1169","1432","_wp_attached_file","2011/12/IMG_5358.jpg");
INSERT INTO `wp_postmeta` VALUES("1170","1432","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5358.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5358-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5358-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5358-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5358-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5358-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5358-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5358-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5358-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5358-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1171","751","_avia_builder_template_galerie_photo","{{{Galerie photo}}}[av_two_third first]
[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'portfolio\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("1172","1433","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1173","1433","_edit_lock","1429352373:5");
INSERT INTO `wp_postmeta` VALUES("1174","1434","_wp_attached_file","2014/04/IMG_4110.jpg");
INSERT INTO `wp_postmeta` VALUES("1175","1434","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4110.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4110-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4110-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4110-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s: