DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

INSERT INTO `wp_commentmeta` VALUES("63","34","_wp_trash_meta_status","0");
INSERT INTO `wp_commentmeta` VALUES("64","33","_wp_trash_meta_status","0");


DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

INSERT INTO `wp_comments` VALUES("33","2161","http://www.gp.se/fescvea","","http://www.gp.se/fescvea","191.101.243.42","2015-02-01 10:46:50","2015-02-01 09:46:50","<strong>http://www.gp.se/fescvea</strong>

[...]we came across a cool internet site that you just may love. Take a search if you want[...]","0","spam","Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 5.1; .NET CLR 1.1.4322; InfoPath.1)","trackback","0","0");
INSERT INTO `wp_comments` VALUES("34","2161","northface-outletstore.us","","http://www.northface-outletstore.us","36.250.174.6","2015-03-20 22:31:34","2015-03-20 21:31:34","<strong>northface-outletstore.us</strong>

Oh man, you have no theory what you just missed.","0","spam","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) )","trackback","0","0");


DROP TABLE IF EXISTS `wp_duplicator_packages`;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(20) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(20) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(20) DEFAULT NULL,
  `log_username` varchar(20) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(20) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_layerslider`;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_layerslider` VALUES("1","Slide Home page","{\"properties\":{\"title\":\"Slide Home page\",\"width\":\"100%\",\"height\":\"470\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"80\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2014\\/05\\/cistude_romain_riols.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2013\\/04\\/Logo48hcyan-01.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"900\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"20px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"900\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1450\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"250\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"187px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/le-programme\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"221px\",\"left\":\"671px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-02.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/sinscrire-aux-48h\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"299px\",\"left\":\"668px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-03.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/dev48h.pigiste.org\\/pratique\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"378px\",\"left\":\"666px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2015\\/03\\/48hVichy-juil14-bandeau1200.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/blancPP-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"450\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"119px\",\"left\":\"20px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"550\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"68\\\\\\\"}\",\"top\":\"348px\",\"left\":\"21px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1428671868","0","0");
INSERT INTO `wp_layerslider` VALUES("2","Why Enfold - Small Header","{\"properties\":{\"title\":\"Why Enfold - Small Header\",\"width\":\"100%\",\"height\":\"150\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"1\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"#aac98e\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1200\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"150\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-18px\",\"left\":\"800px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1300\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"842px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l17.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"350\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-279px\",\"left\":\"951px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"450\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"51px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-22px\",\"left\":\"-107px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Why you should choose\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"650\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"68px\",\"left\":\"214px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"img\",\"image\":\"http:\\/\\/dev48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"684px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1398347374","0","0");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_newsletter`;

CREATE TABLE `wp_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `sex` char(1) NOT NULL DEFAULT 'n',
  `status` char(1) NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(50) NOT NULL DEFAULT '',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `country` varchar(4) NOT NULL DEFAULT '',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) NOT NULL DEFAULT '',
  `profile_2` varchar(255) NOT NULL DEFAULT '',
  `profile_3` varchar(255) NOT NULL DEFAULT '',
  `profile_4` varchar(255) NOT NULL DEFAULT '',
  `profile_5` varchar(255) NOT NULL DEFAULT '',
  `profile_6` varchar(255) NOT NULL DEFAULT '',
  `profile_7` varchar(255) NOT NULL DEFAULT '',
  `profile_8` varchar(255) NOT NULL DEFAULT '',
  `profile_9` varchar(255) NOT NULL DEFAULT '',
  `profile_10` varchar(255) NOT NULL DEFAULT '',
  `profile_11` varchar(255) NOT NULL DEFAULT '',
  `profile_12` varchar(255) NOT NULL DEFAULT '',
  `profile_13` varchar(255) NOT NULL DEFAULT '',
  `profile_14` varchar(255) NOT NULL DEFAULT '',
  `profile_15` varchar(255) NOT NULL DEFAULT '',
  `profile_16` varchar(255) NOT NULL DEFAULT '',
  `profile_17` varchar(255) NOT NULL DEFAULT '',
  `profile_18` varchar(255) NOT NULL DEFAULT '',
  `profile_19` varchar(255) NOT NULL DEFAULT '',
  `profile_20` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(50) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  `flow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter` VALUES("1","paulineburguin@hotmail.fr ","","","n","C","2014-05-07 22:10:12","a6896fa250","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("2","jacson-christel@voila.fr ","","","n","C","2014-05-07 22:10:26","35897a25c8","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("3","henry.castelbou@numericable.fr ","","","n","C","2014-05-07 22:10:34","5fb9736511","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("4","nicolas.jaunet@argus-presse.fr","","","n","C","2014-05-07 22:10:44","6120a0dae4","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("5","manager@mtwevts.com ","","","n","C","2014-05-07 22:10:58","f3504d96fa","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("6","max.twa@gmail.com","","","n","C","2014-05-07 22:13:09","2379dc6e8e","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","1","0");


DROP TABLE IF EXISTS `wp_newsletter_emails`;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext,
  `message_text` longtext,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `send_on` int(11) NOT NULL DEFAULT '0',
  `track` tinyint(4) NOT NULL DEFAULT '0',
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` char(1) NOT NULL DEFAULT '',
  `query` text,
  `preferences` text,
  `options` longtext,
  `token` varchar(10) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_emails` VALUES("1","<!DOCTYPE html>
<html>
    <head>
        <title></title>
        <style>
            * {
                font-family: ;
                font-size: ;
            }
        </style>
    </head>
    <body style=\"font:normal 11px helvetica,sans-serif;\"><table style=\"background-color: #ffffff; width: 600px; background-position: initial initial; background-repeat: initial initial;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
<tbody>
<tr>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">Cet email a &eacute;t&eacute; envoy&eacute; &agrave; {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.</td>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">&nbsp;</td>
</tr>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">
<table style=\"height: 90px; width: 334px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"20\" align=\"center\">
<tbody>
<tr>
<td style=\"background: #ffffff;\"><a href=\"http://www.48h.pigiste.org\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/Logo48hPP-01.png\" alt=\"\" width=\"382\" height=\"211\" /></a></td>
<td style=\"background: #ffffff;\">
<p><a href=\"http://dev48h.pigiste.org/le-programme/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-01.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
<p><a href=\"http://dev48h.pigiste.org/sinscrire-aux-48h/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-02.png\" alt=\"\" width=\"223\" height=\"50\" /></a></p>
<p><a href=\"http://dev48h.pigiste.org/pratique/\"><img src=\"http://dev48h.pigiste.org/wp-content/uploads/2014/04/titres-03.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
</td>
</tr>
</tbody>
</table>
</td>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">&nbsp;</td>
</tr>
</tbody>
</table></body></html>","This email requires a modern e-mail reader. You can view the email online here:

{email_url}.

Thank you, Les 48h de la pige
To change your subscription follow:
{profile_url}.","Le programme est enfin publié !","message","2014-05-07 22:04:24","sent","6","6","6","1399492800","1","0","","select * from wp_newsletter where status=\'C\'","","a:5:{s:18:\"preferences_status\";s:1:\"0\";s:11:\"preferences\";N;s:3:\"sex\";N;s:6:\"status\";s:1:\"C\";s:8:\"wp_users\";s:1:\"0\";}","52730d2b3d","0");


DROP TABLE IF EXISTS `wp_newsletter_stats`;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` int(11) NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) NOT NULL DEFAULT '',
  `anchor` varchar(200) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_stats` VALUES("1","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("2","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("3","6","1","0","2014-05-07 22:13:52","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("4","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("5","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("6","5","1","0","2014-05-07 22:17:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("7","6","1","0","2014-05-07 22:18:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("8","6","1","0","2014-05-07 22:18:14","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("9","5","1","0","2014-05-07 23:09:03","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("10","2","1","0","2014-05-08 08:57:32","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("11","2","1","0","2014-05-08 08:57:46","http://dev48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("12","2","1","0","2014-05-08 09:07:45","http://dev48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("13","5","1","0","2014-05-08 10:03:29","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("14","2","1","0","2014-05-08 10:28:31","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("15","2","1","0","2014-05-08 10:28:41","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("16","2","1","0","2014-05-08 10:34:35","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("17","1","1","0","2014-05-08 12:23:30","","","157.55.0.155","");
INSERT INTO `wp_newsletter_stats` VALUES("18","1","1","0","2014-05-08 12:23:31","http://dev48h.pigiste.org/le-programme/","","86.214.59.246","");
INSERT INTO `wp_newsletter_stats` VALUES("19","2","1","0","2014-05-08 13:11:18","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("20","5","1","0","2014-05-08 14:36:19","","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("21","5","1","0","2014-05-08 14:37:19","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("22","5","1","0","2014-05-08 14:37:22","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("23","5","1","0","2014-05-08 14:37:41","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("24","5","1","0","2014-05-08 14:39:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("25","5","1","0","2014-05-08 14:43:29","http://dev48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("26","5","1","0","2014-05-08 14:45:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("27","2","1","0","2014-05-08 19:31:34","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("28","5","1","0","2014-05-09 00:40:29","http://dev48h.pigiste.org/le-programme/","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("29","2","1","0","2014-05-09 09:08:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("30","2","1","0","2014-05-09 09:29:42","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("31","2","1","0","2014-05-09 10:09:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("32","2","1","0","2014-06-01 12:08:09","","","90.9.60.51","");


DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=115020 DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` VALUES("1","siteurl","http://dev48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("2","blogname","Les 48h de la pige","yes");
INSERT INTO `wp_options` VALUES("3","blogdescription","Un événement Profession : Pigiste","yes");
INSERT INTO `wp_options` VALUES("4","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("5","admin_email","max.twa@gmail.com","yes");
INSERT INTO `wp_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("17","default_category","1","yes");
INSERT INTO `wp_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("22","date_format","j F Y","yes");
INSERT INTO `wp_options` VALUES("23","time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("24","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("165","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("166","widget_nav_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `wp_options` VALUES("32","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("34","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("35","active_plugins","a:9:{i:0;s:19:\"bbpress/bbpress.php\";i:1;s:41:\"better-wp-security/better-wp-security.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"email-users/email-users.php\";i:4;s:41:\"google-maps-widget/google-maps-widget.php\";i:5;s:21:\"newsletter/plugin.php\";i:6;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:7;s:27:\"updraftplus/updraftplus.php\";i:8;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";}","yes");
INSERT INTO `wp_options` VALUES("36","home","http://dev48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("37","category_base","","yes");
INSERT INTO `wp_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `wp_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("41","gmt_offset","1","yes");
INSERT INTO `wp_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("43","recently_edited","a:5:{i:0;s:74:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/includes/error404.php\";i:2;s:60:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/404.php\";i:3;s:62:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/style.css\";i:4;s:66:\"/homez.313/pigiste/48heures/wp-content/plugins/bbpress/bbpress.php\";i:5;s:63:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/footer.php\";}","no");
INSERT INTO `wp_options` VALUES("44","template","enfold","yes");
INSERT INTO `wp_options` VALUES("45","stylesheet","enfold","yes");
INSERT INTO `wp_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("52","db_version","30133","yes");
INSERT INTO `wp_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("54","upload_path","","yes");
INSERT INTO `wp_options` VALUES("55","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("57","show_on_front","posts","yes");
INSERT INTO `wp_options` VALUES("58","tag_base","","yes");
INSERT INTO `wp_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("62","thumbnail_size_w","80","yes");
INSERT INTO `wp_options` VALUES("63","thumbnail_size_h","80","yes");
INSERT INTO `wp_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("68","large_size_w","1030","yes");
INSERT INTO `wp_options` VALUES("69","large_size_h","1030","yes");
INSERT INTO `wp_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `wp_options` VALUES("71","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("72","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("77","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("82","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("83","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("85","uninstall_plugins","a:2:{s:41:\"google-maps-widget/google-maps-widget.php\";a:2:{i:0;s:3:\"GMW\";i:1;s:9:\"uninstall\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}}","no");
INSERT INTO `wp_options` VALUES("86","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("88","page_on_front","0","yes");
INSERT INTO `wp_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","26691","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:66:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:12:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:6:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"email_single_user\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:29:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:25:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("93","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("94","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("96","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("98","sidebars_widgets","a:13:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:9:\"sidebar-7\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:1:{i:0;s:18:\"avia_google_maps-5\";}s:10:\"sidebar-10\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("99","cron","a:10:{i:1429279022;a:1:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1429279393;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429295460;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429304325;a:2:{s:14:\"updraft_backup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"updraft_backup_database\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429321360;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429347752;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429364593;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429732938;a:1:{s:25:\"newsletter_check_versions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"newsletter_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1429805372;a:1:{s:8:\"gmw_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"gmw_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("114272","updraft_dreamobjects","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("151","recently_activated","a:2:{s:21:\"polylang/polylang.php\";i:1429220309;s:19:\"akismet/akismet.php\";i:1429218125;}","yes");
INSERT INTO `wp_options` VALUES("154","_bbp_private_forums","a:1:{i:0;i:1739;}","yes");
INSERT INTO `wp_options` VALUES("155","_bbp_hidden_forums","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("501","_bbp_forum_slug","forum","yes");
INSERT INTO `wp_options` VALUES("156","_bbp_db_version","250","yes");
INSERT INTO `wp_options` VALUES("157","widget_newsbox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("158","widget_portfoliobox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("159","widget_avia_socialcount","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("160","widget_avia_combo_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("161","widget_avia_partner_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("162","widget_avia_google_maps","a:3:{i:1;a:0:{}i:5;a:15:{s:5:\"title\";s:84:\"Cette année, rendez-vous sur le Campus Albert Londres à Vichy les 3 et 4 juillet !\";s:14:\"street-address\";s:36:\"Pôle technologique et universitaire\";s:4:\"city\";s:0:\"\";s:5:\"state\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:7:\"country\";s:5:\"VICHY\";s:3:\"lat\";s:8:\"46.11946\";s:3:\"lng\";s:16:\"3.42521320000003\";s:4:\"zoom\";s:2:\"15\";s:4:\"type\";s:7:\"ROADMAP\";s:12:\"directionsto\";s:0:\"\";s:7:\"content\";s:0:\"\";s:4:\"icon\";s:68:\"http://dev48h.pigiste.org/wp-content/uploads/2014/05/marqueur-01.png\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:5:\"280px\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("163","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("164","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("168","widget_bbp_login_widget","a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:12:\"Se connecter\";s:8:\"register\";s:0:\"\";s:8:\"lostpass\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("114285","updraft_split_every","500","yes");
INSERT INTO `wp_options` VALUES("114286","updraft_dir","updraft","yes");
INSERT INTO `wp_options` VALUES("502","_bbp_topic_slug","sujet","yes");
INSERT INTO `wp_options` VALUES("503","_bbp_topic_tag_slug","mot-cle","yes");
INSERT INTO `wp_options` VALUES("504","_bbp_view_slug","voir-le-sujet","yes");
INSERT INTO `wp_options` VALUES("505","_bbp_reply_slug","repondre","yes");
INSERT INTO `wp_options` VALUES("506","_bbp_search_slug","rechercher","yes");
INSERT INTO `wp_options` VALUES("507","_bbp_user_slug","utilisateurs","yes");
INSERT INTO `wp_options` VALUES("508","_bbp_topic_archive_slug","sujets","yes");
INSERT INTO `wp_options` VALUES("509","_bbp_reply_archive_slug","réponses","yes");
INSERT INTO `wp_options` VALUES("510","_bbp_user_favs_slug","favoris","yes");
INSERT INTO `wp_options` VALUES("511","_bbp_user_subs_slug","souscrire","yes");
INSERT INTO `wp_options` VALUES("101709","theme_mods_twentyfifteen","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1427960171;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:18:\"orphaned_widgets_3\";a:0:{}s:18:\"orphaned_widgets_4\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("114268","updraft_encryptionphrase","","yes");
INSERT INTO `wp_options` VALUES("114269","updraft_service","ftp","yes");
INSERT INTO `wp_options` VALUES("114270","updraft_s3","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114271","updraft_ftp","a:4:{s:4:\"host\";s:22:\"ftp.cluster003.ovh.net\";s:4:\"user\";s:7:\"pigiste\";s:4:\"pass\";s:9:\"piges2014\";s:4:\"path\";s:20:\"48heures_sauvegardes\";}","yes");
INSERT INTO `wp_options` VALUES("99268","can_compress_scripts","0","yes");
INSERT INTO `wp_options` VALUES("114274","updraft_cloudfiles","a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114275","updraft_bitcasa","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114276","updraft_copycom","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114277","updraft_openstack","a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114278","updraft_googledrive","a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}","yes");
INSERT INTO `wp_options` VALUES("114279","updraft_sftp_settings","","yes");
INSERT INTO `wp_options` VALUES("114280","updraft_webdav_settings","","yes");
INSERT INTO `wp_options` VALUES("114281","updraft_ssl_nossl","0","yes");
INSERT INTO `wp_options` VALUES("114282","updraft_log_syslog","0","yes");
INSERT INTO `wp_options` VALUES("114283","updraft_ssl_useservercerts","0","yes");
INSERT INTO `wp_options` VALUES("114284","updraft_ssl_disableverify","0","yes");
INSERT INTO `wp_options` VALUES("113906","itsec_data","a:5:{s:5:\"build\";i:4036;s:20:\"activation_timestamp\";i:1429192993;s:17:\"already_supported\";b:0;s:15:\"setup_completed\";b:1;s:18:\"tooltips_dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113907","itsec_global","a:24:{s:11:\"write_files\";b:1;s:18:\"notification_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:12:\"digest_email\";b:1;s:12:\"backup_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:15:\"lockout_message\";s:14:\"error - erreur\";s:20:\"user_lockout_message\";s:158:\"You have been locked out due to too many invalid login attempts.
Vous avez été bloquée suite à un trop grand nombre de tentatives de connexion invalides.\";s:25:\"community_lockout_message\";s:153:\"Your IP address has been flagged as a threat by the iThemes Security network.
Votre adresse IP a été marquée comme une menace par iThemes sécurité.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:1:{i:0;s:13:\"78.206.68.131\";}s:19:\"email_notifications\";b:1;s:8:\"log_type\";i:2;s:12:\"log_rotation\";i:14;s:12:\"log_location\";s:67:\"/home/pigiste/48heures_dev/wp-content/uploads/ithemes-security/logs\";s:14:\"allow_tracking\";b:1;s:11:\"did_upgrade\";b:0;s:10:\"nginx_file\";s:37:\"/home/pigiste/48heures_dev/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:8:\"log_info\";s:21:\"les-48h-de-la-pige-QJ\";s:9:\"lock_file\";b:0;s:14:\"proxy_override\";b:0;s:14:\"hide_admin_bar\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113908","itsec_initials","a:3:{s:5:\"login\";b:0;s:5:\"admin\";b:0;s:11:\"file_editor\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("480","_bbp_edit_lock","5","yes");
INSERT INTO `wp_options` VALUES("481","_bbp_throttle_time","10","yes");
INSERT INTO `wp_options` VALUES("482","_bbp_allow_anonymous","1","yes");
INSERT INTO `wp_options` VALUES("483","_bbp_allow_global_access","1","yes");
INSERT INTO `wp_options` VALUES("484","_bbp_default_role","bbp_participant","yes");
INSERT INTO `wp_options` VALUES("485","_bbp_allow_revisions","1","yes");
INSERT INTO `wp_options` VALUES("486","_bbp_enable_favorites","1","yes");
INSERT INTO `wp_options` VALUES("487","_bbp_enable_subscriptions","1","yes");
INSERT INTO `wp_options` VALUES("488","_bbp_allow_topic_tags","1","yes");
INSERT INTO `wp_options` VALUES("489","_bbp_allow_search","1","yes");
INSERT INTO `wp_options` VALUES("490","_bbp_use_wp_editor","1","yes");
INSERT INTO `wp_options` VALUES("491","_bbp_use_autoembed","1","yes");
INSERT INTO `wp_options` VALUES("492","_bbp_thread_replies_depth","2","yes");
INSERT INTO `wp_options` VALUES("493","_bbp_allow_threaded_replies","0","yes");
INSERT INTO `wp_options` VALUES("494","_bbp_topics_per_page","15","yes");
INSERT INTO `wp_options` VALUES("495","_bbp_replies_per_page","15","yes");
INSERT INTO `wp_options` VALUES("496","_bbp_topics_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("497","_bbp_replies_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("498","_bbp_root_slug","forum","yes");
INSERT INTO `wp_options` VALUES("499","_bbp_include_root","1","yes");
INSERT INTO `wp_options` VALUES("500","_bbp_show_on_root","forums","yes");
INSERT INTO `wp_options` VALUES("147","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("861","widget_newsletterwidget","a:2:{i:2;a:2:{s:5:\"title\";s:36:\"Inscrivez vous à notre newsletter !\";s:4:\"text\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99276","newsletter_diagnostic_cron_calls","a:300:{i:0;i:1429190859;i:1;i:1429191185;i:2;i:1429191347;i:3;i:1429191780;i:4;i:1429191805;i:5;i:1429192229;i:6;i:1429192433;i:7;i:1429192736;i:8;i:1429192993;i:9;i:1429193010;i:10;i:1429193315;i:11;i:1429193648;i:12;i:1429193928;i:13;i:1429194219;i:14;i:1429194640;i:15;i:1429194814;i:16;i:1429195122;i:17;i:1429195414;i:18;i:1429195769;i:19;i:1429196013;i:20;i:1429197424;i:21;i:1429197564;i:22;i:1429197830;i:23;i:1429198116;i:24;i:1429198434;i:25;i:1429198708;i:26;i:1429199012;i:27;i:1429199316;i:28;i:1429199613;i:29;i:1429199980;i:30;i:1429200246;i:31;i:1429200539;i:32;i:1429200576;i:33;i:1429200851;i:34;i:1429201358;i:35;i:1429201441;i:36;i:1429201809;i:37;i:1429202013;i:38;i:1429202404;i:39;i:1429202652;i:40;i:1429202981;i:41;i:1429203221;i:42;i:1429203544;i:43;i:1429203870;i:44;i:1429204140;i:45;i:1429204424;i:46;i:1429204425;i:47;i:1429204706;i:48;i:1429205011;i:49;i:1429205352;i:50;i:1429205744;i:51;i:1429205919;i:52;i:1429206300;i:53;i:1429206686;i:54;i:1429206928;i:55;i:1429207149;i:56;i:1429207459;i:57;i:1429207935;i:58;i:1429208010;i:59;i:1429208355;i:60;i:1429208650;i:61;i:1429209100;i:62;i:1429209215;i:63;i:1429209538;i:64;i:1429209911;i:65;i:1429210229;i:66;i:1429210427;i:67;i:1429210723;i:68;i:1429211053;i:69;i:1429211394;i:70;i:1429211613;i:71;i:1429211941;i:72;i:1429212206;i:73;i:1429212507;i:74;i:1429212807;i:75;i:1429213112;i:76;i:1429213434;i:77;i:1429213718;i:78;i:1429214076;i:79;i:1429214310;i:80;i:1429214687;i:81;i:1429214906;i:82;i:1429215208;i:83;i:1429215508;i:84;i:1429215806;i:85;i:1429216114;i:86;i:1429216325;i:87;i:1429216409;i:88;i:1429216535;i:89;i:1429216722;i:90;i:1429216745;i:91;i:1429216955;i:92;i:1429217021;i:93;i:1429217165;i:94;i:1429217333;i:95;i:1429217375;i:96;i:1429217585;i:97;i:1429217619;i:98;i:1429217795;i:99;i:1429217929;i:100;i:1429217930;i:101;i:1429217997;i:102;i:1429218016;i:103;i:1429218208;i:104;i:1429218226;i:105;i:1429218512;i:106;i:1429218819;i:107;i:1429219119;i:108;i:1429219435;i:109;i:1429219706;i:110;i:1429220017;i:111;i:1429220309;i:112;i:1429220611;i:113;i:1429221224;i:114;i:1429221534;i:115;i:1429221891;i:116;i:1429222289;i:117;i:1429222583;i:118;i:1429222805;i:119;i:1429223163;i:120;i:1429223484;i:121;i:1429223719;i:122;i:1429224032;i:123;i:1429224473;i:124;i:1429224521;i:125;i:1429224978;i:126;i:1429225127;i:127;i:1429225422;i:128;i:1429225755;i:129;i:1429226174;i:130;i:1429226439;i:131;i:1429226735;i:132;i:1429227289;i:133;i:1429227642;i:134;i:1429227829;i:135;i:1429228143;i:136;i:1429228423;i:137;i:1429228783;i:138;i:1429229074;i:139;i:1429229325;i:140;i:1429229611;i:141;i:1429229909;i:142;i:1429230237;i:143;i:1429230507;i:144;i:1429231011;i:145;i:1429231265;i:146;i:1429231779;i:147;i:1429232132;i:148;i:1429232344;i:149;i:1429232649;i:150;i:1429232907;i:151;i:1429233231;i:152;i:1429233630;i:153;i:1429234040;i:154;i:1429234299;i:155;i:1429234413;i:156;i:1429234729;i:157;i:1429235139;i:158;i:1429235340;i:159;i:1429235815;i:160;i:1429235930;i:161;i:1429236314;i:162;i:1429236684;i:163;i:1429237054;i:164;i:1429237129;i:165;i:1429237428;i:166;i:1429237711;i:167;i:1429238206;i:168;i:1429238444;i:169;i:1429238653;i:170;i:1429239001;i:171;i:1429239242;i:172;i:1429239566;i:173;i:1429239830;i:174;i:1429240204;i:175;i:1429240576;i:176;i:1429240874;i:177;i:1429241013;i:178;i:1429241355;i:179;i:1429241713;i:180;i:1429242008;i:181;i:1429242234;i:182;i:1429242532;i:183;i:1429242843;i:184;i:1429243234;i:185;i:1429243408;i:186;i:1429243720;i:187;i:1429244092;i:188;i:1429244322;i:189;i:1429244615;i:190;i:1429244907;i:191;i:1429245293;i:192;i:1429245584;i:193;i:1429246017;i:194;i:1429246106;i:195;i:1429246443;i:196;i:1429246727;i:197;i:1429247123;i:198;i:1429247589;i:199;i:1429247683;i:200;i:1429247906;i:201;i:1429248313;i:202;i:1429248508;i:203;i:1429248897;i:204;i:1429249136;i:205;i:1429249432;i:206;i:1429249781;i:207;i:1429250043;i:208;i:1429250405;i:209;i:1429250658;i:210;i:1429250949;i:211;i:1429251274;i:212;i:1429251607;i:213;i:1429251806;i:214;i:1429252208;i:215;i:1429252463;i:216;i:1429252737;i:217;i:1429253007;i:218;i:1429253372;i:219;i:1429253612;i:220;i:1429253920;i:221;i:1429254212;i:222;i:1429254551;i:223;i:1429254812;i:224;i:1429255170;i:225;i:1429255412;i:226;i:1429255772;i:227;i:1429256012;i:228;i:1429256348;i:229;i:1429256612;i:230;i:1429256952;i:231;i:1429257214;i:232;i:1429257577;i:233;i:1429257812;i:234;i:1429258053;i:235;i:1429258350;i:236;i:1429258653;i:237;i:1429258653;i:238;i:1429258938;i:239;i:1429259241;i:240;i:1429259547;i:241;i:1429259832;i:242;i:1429260140;i:243;i:1429260453;i:244;i:1429260729;i:245;i:1429261053;i:246;i:1429261352;i:247;i:1429261653;i:248;i:1429261950;i:249;i:1429262349;i:250;i:1429262560;i:251;i:1429262868;i:252;i:1429263313;i:253;i:1429263745;i:254;i:1429264027;i:255;i:1429264366;i:256;i:1429264644;i:257;i:1429264928;i:258;i:1429265310;i:259;i:1429265535;i:260;i:1429265823;i:261;i:1429266149;i:262;i:1429266512;i:263;i:1429266930;i:264;i:1429267053;i:265;i:1429267376;i:266;i:1429267760;i:267;i:1429268087;i:268;i:1429268405;i:269;i:1429268542;i:270;i:1429268972;i:271;i:1429269147;i:272;i:1429269599;i:273;i:1429269810;i:274;i:1429270098;i:275;i:1429270356;i:276;i:1429270717;i:277;i:1429270926;i:278;i:1429271247;i:279;i:1429271542;i:280;i:1429272160;i:281;i:1429272454;i:282;i:1429272775;i:283;i:1429273040;i:284;i:1429273431;i:285;i:1429273864;i:286;i:1429273933;i:287;i:1429274254;i:288;i:1429274524;i:289;i:1429275112;i:290;i:1429275164;i:291;i:1429275453;i:292;i:1429275814;i:293;i:1429276053;i:294;i:1429276332;i:295;i:1429276623;i:296;i:1429276718;i:297;i:1429276923;i:298;i:1429278812;i:299;i:1429288260;}","no");
INSERT INTO `wp_options` VALUES("99285","wpmm_settings","a:3:{s:7:\"general\";a:10:{s:6:\"status\";i:1;s:11:\"bypass_bots\";i:0;s:12:\"backend_role\";s:13:\"administrator\";s:13:\"frontend_role\";s:13:\"administrator\";s:11:\"meta_robots\";i:0;s:11:\"redirection\";s:0:\"\";s:7:\"exclude\";a:3:{i:0;s:4:\"feed\";i:1;s:8:\"wp-login\";i:2;s:5:\"login\";}s:6:\"notice\";i:1;s:10:\"admin_link\";i:0;s:11:\"status_date\";s:19:\"2015-04-02 07:34:45\";}s:6:\"design\";a:10:{s:5:\"title\";s:16:\"Mode Maintenance\";s:7:\"heading\";s:16:\"Mode Maintenance\";s:13:\"heading_color\";s:7:\"#ffffff\";s:4:\"text\";s:223:\"<p>Le site des 48h de la Pige fait peau neuve pour son édition 2015 qui se tiendra les 2 et 3 juillet à Strasbourg.</p>
<p>Très bientôt, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !</p>\";s:10:\"text_color\";s:7:\"#1e73be\";s:7:\"bg_type\";s:10:\"predefined\";s:8:\"bg_color\";s:0:\"\";s:9:\"bg_custom\";s:0:\"\";s:13:\"bg_predefined\";s:7:\"bg4.jpg\";s:10:\"custom_css\";a:3:{s:13:\"heading_color\";s:28:\".wrap h1 { color: #ffffff; }\";s:10:\"text_color\";s:28:\".wrap h2 { color: #1e73be; }\";s:6:\"bg_url\";s:183:\".background { background: url(http://dev48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }\";}}s:7:\"modules\";a:22:{s:16:\"countdown_status\";i:0;s:15:\"countdown_start\";s:19:\"2015-03-30 11:34:16\";s:17:\"countdown_details\";a:3:{s:4:\"days\";s:2:\"10\";s:5:\"hours\";s:1:\"1\";s:7:\"minutes\";s:1:\"0\";}s:15:\"countdown_color\";s:0:\"\";s:16:\"subscribe_status\";i:0;s:14:\"subscribe_text\";s:30:\"Me notifier quand c\\\'est prêt\";s:20:\"subscribe_text_color\";s:0:\"\";s:13:\"social_status\";i:0;s:13:\"social_target\";i:1;s:13:\"social_github\";s:0:\"\";s:15:\"social_dribbble\";s:0:\"\";s:14:\"social_twitter\";s:0:\"\";s:15:\"social_facebook\";s:0:\"\";s:16:\"social_pinterest\";s:0:\"\";s:14:\"social_google+\";s:0:\"\";s:15:\"social_linkedin\";s:0:\"\";s:14:\"contact_status\";i:0;s:13:\"contact_email\";s:17:\"max.twa@gmail.com\";s:15:\"contact_effects\";s:20:\"move_top|move_bottom\";s:9:\"ga_status\";i:0;s:7:\"ga_code\";s:0:\"\";s:10:\"custom_css\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("167","widget_akismet_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("129","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1398350987;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("130","current_theme","Enfold","yes");
INSERT INTO `wp_options` VALUES("131","theme_mods_enfold","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:5:\"avia3\";i:33;s:4:\"avia\";i:33;}}","yes");
INSERT INTO `wp_options` VALUES("132","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("133","enfold_layerslider_activated","1","yes");
INSERT INTO `wp_options` VALUES("134","shop_catalog_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("135","shop_single_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("136","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("137","avia_woocommerce_column_count","3","yes");
INSERT INTO `wp_options` VALUES("138","avia_woocommerce_product_count","15","yes");
INSERT INTO `wp_options` VALUES("139","woocommerce_single_image_crop","no","yes");
INSERT INTO `wp_options` VALUES("142","enfold_woo_settings_enabled","1","yes");
INSERT INTO `wp_options` VALUES("143","avia_options_enfold","a:1:{s:4:\"avia\";a:94:{s:17:\"avia-nonce-import\";s:10:\"947b4125f1\";s:9:\"frontpage\";s:3:\"734\";s:9:\"undefined\";s:32:\"header_setting::{contains}social\";s:8:\"blogpage\";s:0:\"\";s:4:\"logo\";s:72:\"http://dev48h.pigiste.org/wp-content/uploads/2013/04/48hbyPP-300x158.png\";s:7:\"favicon\";s:67:\"http://dev48h.pigiste.org/wp-content/uploads/2013/04/favicon-01.png\";s:9:\"analytics\";s:0:\"\";s:12:\"color_scheme\";s:11:\"Black-White\";s:14:\"google_webfont\";s:17:\"Open Sans:400,600\";s:12:\"default_font\";s:17:\"Open Sans:400,600\";s:16:\"color-body_style\";s:9:\"stretched\";s:16:\"color-body_color\";s:7:\"#333333\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#1bbce9\";s:31:\"colorset-header_color-secondary\";s:7:\"#1bbce9\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#000000\";s:29:\"colorset-main_color-secondary\";s:7:\"#666666\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#111111\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#222222\";s:32:\"colorset-alternate_color-primary\";s:7:\"#000000\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#bdbdbd\";s:30:\"colorset-alternate_color-color\";s:7:\"#888888\";s:31:\"colorset-alternate_color-border\";s:7:\"#333333\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#000000\";s:25:\"colorset-footer_color-bg2\";s:7:\"#222222\";s:29:\"colorset-footer_color-primary\";s:7:\"#aaaaaa\";s:31:\"colorset-footer_color-secondary\";s:7:\"#ffffff\";s:27:\"colorset-footer_color-color\";s:7:\"#aaaaaa\";s:28:\"colorset-footer_color-border\";s:7:\"#555555\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:13:\"center center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#333333\";s:25:\"colorset-socket_color-bg2\";s:7:\"#000000\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#eeeeee\";s:27:\"colorset-socket_color-color\";s:7:\"#eeeeee\";s:28:\"colorset-socket_color-border\";s:7:\"#333333\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:9:\"quick_css\";s:8:\"[nolink]\";s:17:\"responsive_layout\";s:10:\"responsive\";s:15:\"websave_windows\";s:6:\"active\";s:10:\"blog_style\";s:10:\"single-big\";s:17:\"single_post_style\";s:10:\"single-big\";s:15:\"iconfont_upload\";s:0:\"\";s:14:\"header_setting\";s:12:\"fixed_header\";s:5:\"phone\";s:0:\"\";s:12:\"social_icons\";a:4:{i:0;a:2:{s:11:\"social_icon\";s:8:\"facebook\";s:16:\"social_icon_link\";s:34:\"https://www.facebook.com/kriesi.at\";}i:1;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:1:\"#\";}i:2;a:2:{s:11:\"social_icon\";s:5:\"skype\";s:16:\"social_icon_link\";s:0:\"\";}i:3;a:2:{s:11:\"social_icon\";s:4:\"mail\";s:16:\"social_icon_link\";s:0:\"\";}}s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:11:\"header_menu\";s:16:\"mobile_drop_down\";s:14:\"archive_layout\";s:8:\"fullsize\";s:11:\"blog_layout\";s:8:\"fullsize\";s:13:\"single_layout\";s:8:\"fullsize\";s:11:\"page_layout\";s:8:\"fullsize\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:8:\"disabled\";s:22:\"display_widgets_socket\";s:15:\"nofooterwidgets\";s:14:\"footer_columns\";s:1:\"2\";s:9:\"copyright\";s:89:\"&copy; Les 48h de la pige 2014 - Un &eacute;v&eacute;nement Profession : Pigiste [nolink]\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("202","avia_permalink_settings","a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}","yes");
INSERT INTO `wp_options` VALUES("204","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("145","avia_stylesheet_dir_writableenfold","true","yes");
INSERT INTO `wp_options` VALUES("146","avia_stylesheet_existsenfold","true","yes");
INSERT INTO `wp_options` VALUES("169","widget_bbp_views_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("170","widget_bbp_search_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("171","widget_bbp_forums_widget","a:3:{i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:6:\"Forums\";s:12:\"parent_forum\";s:3:\"any\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("172","widget_bbp_topics_widget","a:3:{i:1;a:0:{}i:2;a:6:{s:5:\"title\";s:15:\"Sujets récents\";s:8:\"order_by\";s:7:\"newness\";s:12:\"parent_forum\";s:3:\"any\";s:9:\"show_date\";b:0;s:9:\"show_user\";b:0;s:9:\"max_shown\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("173","widget_bbp_replies_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("174","widget_bbp_stats_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("194","shop_order_status_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114419","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("254","portfolio_entries_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("193","product_cat_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("203","avia_rewrite_flush","1","yes");
INSERT INTO `wp_options` VALUES("114426","rewrite_rules","a:160:{s:8:\"forum/?$\";s:25:\"index.php?post_type=forum\";s:38:\"forum/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:33:\"forum/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:25:\"forum/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"sujets/?$\";s:25:\"index.php?post_type=topic\";s:39:\"sujets/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"sujets/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"sujets/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:27:\"forum/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:27:\"forum/sujet/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:30:\"forum/repondre/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:29:\"forum/mot-cle/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:54:\"forum/utilisateurs/([^/]+)/sujets/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/réponses/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:55:\"forum/utilisateurs/([^/]+)/favoris/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/souscrire/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:36:\"forum/utilisateurs/([^/]+)/sujets/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:39:\"forum/utilisateurs/([^/]+)/réponses/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:37:\"forum/utilisateurs/([^/]+)/favoris/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:39:\"forum/utilisateurs/([^/]+)/souscrire/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:34:\"forum/utilisateurs/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:29:\"forum/utilisateurs/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:48:\"forum/voir-le-sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:35:\"forum/voir-le-sujet/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:30:\"forum/voir-le-sujet/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:37:\"forum/rechercher/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:19:\"forum/rechercher/?$\";s:20:\"index.php?bbp_search\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"forum/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"forum/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"forum/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:50:\"forum/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:45:\"forum/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:38:\"forum/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:45:\"forum/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:39:\"forum/sujet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"forum/sujet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"forum/sujet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:52:\"forum/sujet/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:47:\"forum/sujet/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:40:\"forum/sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:47:\"forum/sujet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:28:\"forum/sujet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"forum/sujet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"forum/sujet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"forum/repondre/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"forum/repondre/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"forum/repondre/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"forum/repondre/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"forum/repondre/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forum/repondre/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:43:\"forum/repondre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:50:\"forum/repondre/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:35:\"forum/repondre/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:31:\"forum/repondre/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"forum/repondre/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"forum/repondre/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"forum/repondre/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"forum/repondre/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"forum/mot-cle/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:49:\"forum/mot-cle/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:42:\"forum/mot-cle/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:24:\"forum/mot-cle/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:45:\"forum/rechercher/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:27:\"forum/rechercher/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO `wp_options` VALUES("212","gmw_options","a:4:{s:13:\"first_version\";s:4:\"1.60\";s:13:\"first_install\";i:1398358539;s:13:\"last_tracking\";i:1429204176;s:14:\"allow_tracking\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("213","widget_googlemapswidget","a:2:{i:2;a:22:{s:5:\"title\";s:47:\"Rendez-vous au campus Albert Londres à Vichy !\";s:7:\"address\";s:43:\"Pôle technologique et universitaire, Vichy\";s:15:\"thumb_pin_color\";s:4:\"gray\";s:14:\"thumb_pin_size\";s:7:\"default\";s:11:\"thumb_width\";i:500;s:12:\"thumb_height\";i:300;s:10:\"thumb_zoom\";s:2:\"13\";s:10:\"thumb_type\";s:7:\"roadmap\";s:15:\"thumb_link_type\";s:8:\"lightbox\";s:10:\"thumb_link\";s:0:\"\";s:12:\"thumb_header\";s:0:\"\";s:12:\"thumb_footer\";s:0:\"\";s:16:\"thumb_new_colors\";b:1;s:14:\"lightbox_width\";i:600;s:15:\"lightbox_height\";i:400;s:13:\"lightbox_type\";s:1:\"m\";s:13:\"lightbox_zoom\";s:2:\"14\";s:15:\"lightbox_bubble\";b:1;s:14:\"lightbox_title\";b:0;s:15:\"lightbox_header\";s:0:\"\";s:15:\"lightbox_footer\";s:0:\"\";s:13:\"lightbox_skin\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("599","newsletter_main_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("600","newsletter","a:26:{s:12:\"profile_text\";s:104:\"{profile_form}<p>To cancel your subscription, <a href=\'{unsubscription_confirm_url}\'>click here</a>.</p>\";s:10:\"error_text\";s:173:\"<p>This subscription can\'t be completed, sorry. The email address is blocked or already subscribed. You should contact the owner to unlock that email address. Thank you.</p>\";s:22:\"already_confirmed_text\";s:99:\"<p>This email address is already subscribed, anyway a welcome email has been resent. Thank you.</p>\";s:18:\"subscribe_wp_users\";s:1:\"0\";s:17:\"subscription_text\";s:19:\"{subscription_form}\";s:17:\"confirmation_text\";s:167:\"<p>Votre demande d\'inscription est enregistr&eacute;e. Merci ! Un e-mail de confirmation vous a été envoyé. V&eacute;rifier &eacute;galement votre dossier spam.</p>\";s:20:\"confirmation_subject\";s:66:\"Inscription &agrave; la lettre d&prime;information de {blog_title}\";s:20:\"confirmation_message\";s:517:\"<p>Bonjour {name}!</p>
<p>Vous recevez cet e-mail car nous avons enregistr&eacute; une demande d&prime;inscription &agrave; la lettre d&prime;infrmation de {blog_title}.
Merci de confirmer votre inscription en cliquant sur le lien suivant : <a href=\"{subscription_confirm_url}\"><strong>je confirme mon inscription.</strong></a>.
Si le lien ne fonctionne pas, merci d\'utiliser cette adresse :</p>
<p>{subscription_confirm_url}</p>
<p>Ignorez ce message si vous n\'avez pas effectué de demande.</p>
<p>Merci !</p>\";s:14:\"confirmed_text\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:17:\"confirmed_subject\";s:17:\"Bienvenue, {name}\";s:17:\"confirmed_message\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:19:\"unsubscription_text\";s:160:\"<p>&Ecirc;tes-vous certain de vouloir vous d&eacute;sinscrire de la lettre d&prime;information de {blog_title} ? <a href=\"{unsubscription_confirm_url}\">Oui</a>.\";s:17:\"unsubscribed_text\";s:153:\"<p>Vous n&prime;&ecirc;tes plus abonn&eacute; &agrave; la lettre d\'information de {blog_title}. Merci de nous avoir suivi et &agrave; bient&ocirc;t !</p>\";s:20:\"unsubscribed_subject\";s:18:\"Au revoir {name} !\";s:20:\"unsubscribed_message\";s:108:\"<p>Cet email confirme votre désinscription à notre newsletter<br>
<a href=\'{blog_url}\'>{blog_url}</a></p>\";s:14:\"noconfirmation\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:8:\"novisual\";s:1:\"0\";s:6:\"notify\";s:1:\"0\";s:12:\"notify_email\";s:0:\"\";s:16:\"confirmation_url\";s:0:\"\";s:13:\"confirmed_url\";s:0:\"\";s:18:\"confirmed_tracking\";s:0:\"\";s:13:\"profile_saved\";s:0:\"\";s:24:\"subscribe_wp_users_label\";s:0:\"\";s:10:\"wp_welcome\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("214","avia_sidebars","a:5:{i:0;s:10:\"Google Map\";i:1;s:10:\"Live Tweet\";i:2;s:7:\"Contact\";i:3;s:11:\"Login forum\";i:4;s:13:\"Recent topics\";}","yes");
INSERT INTO `wp_options` VALUES("262","widget_oauth_twitter_widget","a:2:{i:2;a:12:{s:4:\"user\";s:6:\"pigist\";s:5:\"count\";s:0:\"\";s:11:\"widgetTitle\";s:0:\"\";s:12:\"widgetFooter\";s:0:\"\";s:16:\"oAuthAccessToken\";s:0:\"\";s:22:\"oAuthAccessTokenSecret\";s:0:\"\";s:11:\"consumerKey\";s:0:\"\";s:14:\"consumerSecret\";s:0:\"\";s:17:\"showTwitterIconTF\";b:0;s:16:\"showProfilePicTF\";b:0;s:15:\"showTweetTimeTF\";b:0;s:16:\"includeRepliesTF\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99286","wpmm_version","2.0.3","yes");
INSERT INTO `wp_options` VALUES("114265","updraft_interval_increments","","yes");
INSERT INTO `wp_options` VALUES("114266","updraft_retain","8","yes");
INSERT INTO `wp_options` VALUES("114267","updraft_retain_db","20","yes");
INSERT INTO `wp_options` VALUES("597","newsletter_logger_secret","5180c642","yes");
INSERT INTO `wp_options` VALUES("598","newsletter_main","a:20:{s:12:\"sender_email\";s:26:\"newsletter@48h.pigiste.org\";s:11:\"sender_name\";s:18:\"Les 48h de la pige\";s:11:\"return_path\";N;s:8:\"reply_to\";s:23:\"raphaelbaldos@gmail.com\";s:12:\"contract_key\";s:0:\"\";s:13:\"scheduler_max\";s:3:\"100\";s:6:\"editor\";s:1:\"0\";s:7:\"api_key\";s:10:\"186aecbfd3\";s:3:\"css\";s:0:\"\";s:25:\"content_transfer_encoding\";s:0:\"\";s:12:\"smtp_enabled\";s:1:\"0\";s:9:\"smtp_host\";s:0:\"\";s:9:\"smtp_port\";s:0:\"\";s:11:\"smtp_secure\";s:0:\"\";s:9:\"smtp_user\";s:0:\"\";s:9:\"smtp_pass\";s:0:\"\";s:15:\"smtp_test_email\";s:0:\"\";s:8:\"lock_ids\";s:0:\"\";s:8:\"lock_url\";s:0:\"\";s:12:\"lock_message\";s:107:\"This content is protected, only newsletter subscribers can access it. Subscribe now!

{subscription_form}\";}","yes");
INSERT INTO `wp_options` VALUES("602","newsletter_subscription_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("603","newsletter_emails","a:12:{s:5:\"theme\";s:10:\"vimeo-like\";s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("604","newsletter_emails_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("605","newsletter_emails_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("606","newsletter_users","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("607","newsletter_users_version","1.0.4","yes");
INSERT INTO `wp_options` VALUES("608","newsletter_statistics","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("609","newsletter_statistics_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("610","newsletter_feed","a:2:{s:5:\"theme\";s:7:\"default\";s:12:\"subscription\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("611","newsletter_feed_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("612","newsletter_feed_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("601","newsletter_profile","a:61:{s:5:\"email\";s:5:\"Email\";s:11:\"email_error\";s:24:\"The email is not correct\";s:4:\"name\";s:4:\"Name\";s:10:\"name_error\";s:23:\"The name is not correct\";s:11:\"name_status\";i:0;s:10:\"name_rules\";i:0;s:7:\"surname\";s:9:\"Last name\";s:13:\"surname_error\";s:28:\"The last name is not correct\";s:14:\"surname_status\";i:0;s:3:\"sex\";s:3:\"I\'m\";s:7:\"privacy\";s:51:\"Subscribing I accept the privacy rules of this site\";s:13:\"privacy_error\";s:37:\"You must accept the privacy statement\";s:14:\"privacy_status\";i:0;s:9:\"subscribe\";s:9:\"Subscribe\";s:4:\"save\";s:4:\"Save\";s:12:\"title_female\";s:4:\"Mrs.\";s:10:\"title_male\";s:3:\"Mr.\";s:10:\"title_none\";s:4:\"Dear\";s:8:\"sex_male\";s:3:\"Man\";s:10:\"sex_female\";s:5:\"Woman\";s:8:\"sex_none\";s:4:\"None\";s:13:\"list_1_status\";i:0;s:13:\"list_2_status\";i:0;s:13:\"list_3_status\";i:0;s:13:\"list_4_status\";i:0;s:13:\"list_5_status\";i:0;s:13:\"list_6_status\";i:0;s:13:\"list_7_status\";i:0;s:13:\"list_8_status\";i:0;s:13:\"list_9_status\";i:0;s:14:\"list_10_status\";i:0;s:14:\"list_11_status\";i:0;s:14:\"list_12_status\";i:0;s:14:\"list_13_status\";i:0;s:14:\"list_14_status\";i:0;s:14:\"list_15_status\";i:0;s:14:\"list_16_status\";i:0;s:14:\"list_17_status\";i:0;s:14:\"list_18_status\";i:0;s:14:\"list_19_status\";i:0;s:14:\"list_20_status\";i:0;s:16:\"profile_1_status\";i:0;s:16:\"profile_2_status\";i:0;s:16:\"profile_3_status\";i:0;s:16:\"profile_4_status\";i:0;s:16:\"profile_5_status\";i:0;s:16:\"profile_6_status\";i:0;s:16:\"profile_7_status\";i:0;s:16:\"profile_8_status\";i:0;s:16:\"profile_9_status\";i:0;s:17:\"profile_10_status\";i:0;s:17:\"profile_11_status\";i:0;s:17:\"profile_12_status\";i:0;s:17:\"profile_13_status\";i:0;s:17:\"profile_14_status\";i:0;s:17:\"profile_15_status\";i:0;s:17:\"profile_16_status\";i:0;s:17:\"profile_17_status\";i:0;s:17:\"profile_18_status\";i:0;s:17:\"profile_19_status\";i:0;s:17:\"profile_20_status\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("624","newsletter_emails_theme_vimeo-like","a:11:{s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("617","newsletter_feed_available_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("616","newsletter_reports_available_version","1.0.7","yes");
INSERT INTO `wp_options` VALUES("618","newsletter_followup_available_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("619","newsletter_facebook_available_version","1.1.3","yes");
INSERT INTO `wp_options` VALUES("620","newsletter_sendgrid_available_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("621","newsletter_popup_available_version","1.0.5","yes");
INSERT INTO `wp_options` VALUES("622","newsletter_mandrill_available_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("623","newsletter_mailjet_available_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("919","auto_core_update_notified","a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:17:\"max.twa@gmail.com\";s:7:\"version\";s:5:\"4.0.1\";s:9:\"timestamp\";i:1416530671;}","yes");
INSERT INTO `wp_options` VALUES("114264","updraft_interval_database","daily","yes");
INSERT INTO `wp_options` VALUES("114263","updraft_interval","daily","yes");
INSERT INTO `wp_options` VALUES("99262","WPLANG","fr_FR","yes");
INSERT INTO `wp_options` VALUES("114247","updraft_dropbox","a:5:{s:6:\"appkey\";N;s:6:\"secret\";N;s:6:\"folder\";N;s:16:\"tk_request_token\";N;s:15:\"tk_access_token\";N;}","yes");
INSERT INTO `wp_options` VALUES("114273","updraft_s3generic","a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("113910","itsec_ipcheck","a:4:{s:17:\"optin-brute-force\";s:1:\"1\";s:7:\"api_ban\";b:1;s:7:\"api_key\";s:32:\"F3VcyPwndUeR62i6lj6dEi54gny7K94o\";s:5:\"api_s\";s:128:\"uAZ92bmH9Q2Buj5l4z5eYSy3d4dvh1x2D502q7Z6k0kWfdFz3BGBXf0408M5QKcRWaJi7o0jqe77FL8h57rnRCeLzp0z24f5cWSq4T2MKmX3wr8Y1W40mCi4vhe9MJ0K\";}","yes");
INSERT INTO `wp_options` VALUES("113911","itsec_four_oh_four","a:5:{s:7:\"enabled\";b:1;s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}}","yes");
INSERT INTO `wp_options` VALUES("113912","itsec_away_mode","a:4:{s:7:\"enabled\";b:1;s:4:\"type\";i:1;s:5:\"start\";i:1429230600;s:3:\"end\";i:1429336800;}","yes");
INSERT INTO `wp_options` VALUES("113913","itsec_ban_users","a:4:{s:7:\"default\";b:1;s:7:\"enabled\";b:1;s:9:\"host_list\";a:0:{}s:10:\"agent_list\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("113915","itsec_brute_force","a:5:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113916","itsec_backup","a:9:{s:9:\"all_sites\";b:1;s:6:\"method\";i:0;s:8:\"location\";s:70:\"/home/pigiste/48heures_dev/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:20;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1429193724;}","yes");
INSERT INTO `wp_options` VALUES("113917","itsec_file_change","a:9:{s:6:\"method\";b:1;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:7:\"enabled\";b:0;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";i:1429116552;}","yes");
INSERT INTO `wp_options` VALUES("113918","itsec_hide_backend","a:7:{s:7:\"enabled\";b:1;s:4:\"slug\";s:5:\"porte\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:12:\"show-tooltip\";b:0;s:8:\"register\";s:15:\"wp-register.php\";}","yes");
INSERT INTO `wp_options` VALUES("113919","itsec_malware","a:2:{s:7:\"enabled\";b:1;s:7:\"api_key\";s:64:\"41989a8a898c77c889af9274298782a51133e7532f6075a5ddcf630bb245f642\";}","yes");
INSERT INTO `wp_options` VALUES("113920","itsec_ssl","a:3:{s:8:\"frontend\";i:0;s:5:\"login\";b:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113922","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:11:\"contributor\";}","yes");
INSERT INTO `wp_options` VALUES("113923","itsec_tweaks","a:22:{s:13:\"protect_files\";b:1;s:18:\"directory_browsing\";b:1;s:15:\"request_methods\";b:1;s:24:\"suspicious_query_strings\";b:1;s:17:\"write_permissions\";b:1;s:11:\"uploads_php\";b:1;s:13:\"generator_tag\";b:1;s:18:\"wlwmanifest_header\";b:1;s:14:\"edituri_header\";b:1;s:12:\"comment_spam\";b:1;s:14:\"random_version\";b:1;s:14:\"disable_xmlrpc\";i:2;s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:22:\"non_english_characters\";b:0;s:16:\"long_url_strings\";b:0;s:13:\"theme_updates\";b:0;s:14:\"plugin_updates\";b:0;s:12:\"core_updates\";b:0;s:11:\"file_editor\";b:0;s:11:\"safe_jquery\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113937","itsec_message_queue","a:2:{s:9:\"last_sent\";i:1429288260;s:8:\"messages\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("114014","itsec_jquery_version","1.11.1","yes");
INSERT INTO `wp_options` VALUES("114047","itsec_salts","1429199122","yes");
INSERT INTO `wp_options` VALUES("115003","_site_transient_timeout_itsec_upload_dir","1429365212","yes");
INSERT INTO `wp_options` VALUES("115004","_site_transient_itsec_upload_dir","a:6:{s:4:\"path\";s:53:\"/home/pigiste/48heures_dev/wp-content/uploads/2015/04\";s:3:\"url\";s:52:\"http://dev48h.pigiste.org/wp-content/uploads/2015/04\";s:6:\"subdir\";s:8:\"/2015/04\";s:7:\"basedir\";s:45:\"/home/pigiste/48heures_dev/wp-content/uploads\";s:7:\"baseurl\";s:44:\"http://dev48h.pigiste.org/wp-content/uploads\";s:5:\"error\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114986","duplicator_version_plugin","0.5.16","yes");
INSERT INTO `wp_options` VALUES("114287","updraft_email","","yes");
INSERT INTO `wp_options` VALUES("114288","updraft_report_warningsonly","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114289","updraft_report_wholebackup","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114290","updraft_autobackup_default","0","yes");
INSERT INTO `wp_options` VALUES("114291","updraft_delete_local","1","yes");
INSERT INTO `wp_options` VALUES("114292","updraft_debug_mode","0","yes");
INSERT INTO `wp_options` VALUES("114293","updraft_extradbs","","yes");
INSERT INTO `wp_options` VALUES("114294","updraft_backupdb_nonwp","0","yes");
INSERT INTO `wp_options` VALUES("114295","updraft_include_plugins","1","yes");
INSERT INTO `wp_options` VALUES("114296","updraft_include_themes","1","yes");
INSERT INTO `wp_options` VALUES("114297","updraft_include_uploads","1","yes");
INSERT INTO `wp_options` VALUES("114298","updraft_include_others","1","yes");
INSERT INTO `wp_options` VALUES("114299","updraft_include_wpcore","0","yes");
INSERT INTO `wp_options` VALUES("114300","updraft_include_wpcore_exclude","","yes");
INSERT INTO `wp_options` VALUES("114301","updraft_include_more","0","yes");
INSERT INTO `wp_options` VALUES("114302","updraft_include_more_path","","yes");
INSERT INTO `wp_options` VALUES("114303","updraft_include_uploads_exclude","backup*,*backups,backwpup*,wp-clone","yes");
INSERT INTO `wp_options` VALUES("114304","updraft_include_others_exclude","upgrade,cache,updraft,backup*,*backups","yes");
INSERT INTO `wp_options` VALUES("114305","updraft_starttime_files","13:20","yes");
INSERT INTO `wp_options` VALUES("114306","updraft_starttime_db","13:20","yes");
INSERT INTO `wp_options` VALUES("114307","updraft_startday_files","0","yes");
INSERT INTO `wp_options` VALUES("114308","updraft_startday_db","0","yes");
INSERT INTO `wp_options` VALUES("114322","updraft_backup_history","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114314","updraft_lastmessage","Remote archives deleted: 0 (avr 17 14:19:29)","yes");
INSERT INTO `wp_options` VALUES("114315","updraftplus_unlocked_fd","1","yes");
INSERT INTO `wp_options` VALUES("114316","updraftplus_last_lock_time_fd","2015-04-17 13:15:17","yes");
INSERT INTO `wp_options` VALUES("114317","updraftplus_semaphore_fd","0","yes");
INSERT INTO `wp_options` VALUES("114344","mailusers_copy_sender","false","yes");
INSERT INTO `wp_options` VALUES("114345","mailusers_add_x_mailer_header","false","yes");
INSERT INTO `wp_options` VALUES("114346","mailusers_omit_display_names","false","yes");
INSERT INTO `wp_options` VALUES("114347","mailusers_footer","<h5 style=\"border-top: 1px solid #eee;\">Powered by <a href=\"http://wordpress.org/plugins/email-users/\">Email Users</a>.</h5>","yes");
INSERT INTO `wp_options` VALUES("114348","mailusers_debug","false","yes");
INSERT INTO `wp_options` VALUES("114349","mailusers_base64_encode","false","yes");
INSERT INTO `wp_options` VALUES("114350","mailusers_dashboard_widgets","true","yes");
INSERT INTO `wp_options` VALUES("114342","mailusers_shortcode_processing","false","yes");
INSERT INTO `wp_options` VALUES("114343","mailusers_from_sender_exclude","true","yes");
INSERT INTO `wp_options` VALUES("114321","updraftplus_semaphore_","0","yes");
INSERT INTO `wp_options` VALUES("114341","mailusers_no_role_filter","false","yes");
INSERT INTO `wp_options` VALUES("114319","updraftplus_unlocked_","1","yes");
INSERT INTO `wp_options` VALUES("114320","updraftplus_last_lock_time_","2015-04-16 20:58:50","yes");
INSERT INTO `wp_options` VALUES("114331","mailusers_default_mail_format","html","yes");
INSERT INTO `wp_options` VALUES("114332","mailusers_default_sort_users_by","none","yes");
INSERT INTO `wp_options` VALUES("114333","mailusers_max_bcc_recipients","0","yes");
INSERT INTO `wp_options` VALUES("114334","mailusers_from_sender_name_override","","yes");
INSERT INTO `wp_options` VALUES("114335","mailusers_from_sender_address_override","","yes");
INSERT INTO `wp_options` VALUES("114336","mailusers_send_bounces_to_address_override","","yes");
INSERT INTO `wp_options` VALUES("114337","mailusers_user_settings_table_rows","20","yes");
INSERT INTO `wp_options` VALUES("114338","mailusers_default_notifications","true","yes");
INSERT INTO `wp_options` VALUES("114339","mailusers_default_mass_email","true","yes");
INSERT INTO `wp_options` VALUES("114340","mailusers_default_user_control","true","yes");
INSERT INTO `wp_options` VALUES("114323","updraft_last_backup","a:5:{s:11:\"backup_time\";i:1429276517;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-plugins.zip\";}s:12:\"plugins-size\";i:15076515;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-uploads.zip\";}s:12:\"uploads-size\";i:174946225;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-17-1415_Les_48h_de_la_pige_b7f423e5e98a-db.gz\";s:7:\"db-size\";i:2826836;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"89c9709b239707ff2ba8ada1eb6b6db2453c3d91\";s:7:\"themes0\";s:40:\"c79130bde557e35e5ec828184efd24f96e1655ad\";s:8:\"uploads0\";s:40:\"214fc5db2f078af39fec19cd638da727aa8194df\";s:7:\"others0\";s:40:\"89694a6a854f356db15719a4057355b11dab6900\";s:3:\"db0\";s:40:\"b56295004df74ecb16d93ac77fb5547a13ac8fe4\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"b7f423e5e98a\";}","yes");
INSERT INTO `wp_options` VALUES("114330","mailusers_default_body","<p>Bonjour, </p><p>J\'aimerais attirer votre attention sur un nouvel article publi&eacute; sur le blog (voir infos ci-dessous). J\'esp&egrave;re que vous le trouverez int&eacute;ressant.</p><p>Cordialement,</p><p>%FROM_NAME%</p><hr><p><strong>%POST_TITLE%</strong></p><p>%POST_EXCERPT%</p><ul><li>Lien vers l\'article : <a href=\"%POST_URL%\">%POST_URL%</a></li><li>Lien vers %BLOG_NAME%: <a href=\"%BLOG_URL%\">%BLOG_URL%</a></li></ul>","yes");
INSERT INTO `wp_options` VALUES("114329","mailusers_default_subject","[%BLOG_NAME%] A post of interest: \"%POST_TITLE%\"","yes");
INSERT INTO `wp_options` VALUES("114397","polylang","a:12:{s:7:\"browser\";i:1;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:0;s:10:\"force_lang\";i:0;s:13:\"redirect_lang\";i:0;s:13:\"media_support\";i:1;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"1.7.3\";s:12:\"default_lang\";s:2:\"fr\";}","yes");
INSERT INTO `wp_options` VALUES("114328","mailusers_version","4.7.1","yes");
INSERT INTO `wp_options` VALUES("115005","_site_transient_timeout_itsec_random_version","1429365212","yes");
INSERT INTO `wp_options` VALUES("115006","_site_transient_itsec_random_version","132","yes");
INSERT INTO `wp_options` VALUES("115016","duplicator_settings","a:10:{s:7:\"version\";s:6:\"0.5.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("115010","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.1.1\";s:7:\"version\";s:5:\"4.1.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1429278813;s:15:\"version_checked\";s:5:\"4.1.1\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("115012","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429278816;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.1.zip\";}s:19:\"bbpress/bbpress.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11780\";s:4:\"slug\";s:7:\"bbpress\";s:6:\"plugin\";s:19:\"bbpress/bbpress.php\";s:11:\"new_version\";s:5:\"2.5.6\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/bbpress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.16\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.16.zip\";}s:27:\"email-users/email-users.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"580\";s:4:\"slug\";s:11:\"email-users\";s:6:\"plugin\";s:27:\"email-users/email-users.php\";s:11:\"new_version\";s:5:\"4.7.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/email-users/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/email-users.4.7.1.zip\";}s:41:\"google-maps-widget/google-maps-widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33487\";s:4:\"slug\";s:18:\"google-maps-widget\";s:6:\"plugin\";s:41:\"google-maps-widget/google-maps-widget.php\";s:11:\"new_version\";s:4:\"2.30\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/google-maps-widget/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/google-maps-widget.2.30.zip\";}s:41:\"better-wp-security/better-wp-security.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"18308\";s:4:\"slug\";s:18:\"better-wp-security\";s:6:\"plugin\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"new_version\";s:6:\"4.6.13\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/better-wp-security/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/better-wp-security.4.6.13.zip\";}s:21:\"newsletter/plugin.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8171\";s:4:\"slug\";s:10:\"newsletter\";s:6:\"plugin\";s:21:\"newsletter/plugin.php\";s:11:\"new_version\";s:5:\"3.7.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/newsletter/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/plugin/newsletter.zip\";}s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41825\";s:4:\"slug\";s:28:\"oauth-twitter-sidebar-widget\";s:6:\"plugin\";s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/oauth-twitter-sidebar-widget/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/oauth-twitter-sidebar-widget.zip\";}s:21:\"polylang/polylang.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25780\";s:4:\"slug\";s:8:\"polylang\";s:6:\"plugin\";s:21:\"polylang/polylang.php\";s:11:\"new_version\";s:5:\"1.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/polylang/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/polylang.1.7.3.zip\";}s:27:\"updraftplus/updraftplus.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"31679\";s:4:\"slug\";s:11:\"updraftplus\";s:6:\"plugin\";s:27:\"updraftplus/updraftplus.php\";s:11:\"new_version\";s:6:\"1.9.63\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/updraftplus/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/updraftplus.1.9.63.zip\";}s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"13204\";s:4:\"slug\";s:19:\"wp-maintenance-mode\";s:6:\"plugin\";s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-maintenance-mode/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-maintenance-mode.2.0.3.zip\";}}}","yes");
INSERT INTO `wp_options` VALUES("115013","_site_transient_timeout_theme_roots","1429280614","yes");
INSERT INTO `wp_options` VALUES("115014","_site_transient_theme_roots","a:2:{s:6:\"enfold\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";}","yes");
INSERT INTO `wp_options` VALUES("115015","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429278817;s:7:\"checked\";a:2:{s:6:\"enfold\";s:5:\"2.4.5\";s:13:\"twentyfifteen\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("115017","_transient_doing_cron","1429288260.7059369087219238281250","yes");
INSERT INTO `wp_options` VALUES("115018","_site_transient_timeout_itsec_notification_running","1429291861","yes");
INSERT INTO `wp_options` VALUES("115019","_site_transient_itsec_notification_running","1","yes");
INSERT INTO `wp_options` VALUES("114999","updraft_jobdata_6d2bdde2587d","a:2:{s:8:\"job_type\";s:6:\"delete\";s:11:\"job_time_ms\";d:1429276769.608705;}","yes");
INSERT INTO `wp_options` VALUES("114998","updraft_jobdata_9a518246ab22","a:2:{s:8:\"job_type\";s:6:\"delete\";s:11:\"job_time_ms\";d:1429276766.5092449;}","yes");


DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=108230 DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` VALUES("5","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"1-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"1-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"1-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"1-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4","313","_wp_attached_file","2012/04/1.jpg");
INSERT INTO `wp_postmeta` VALUES("6","313","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("7","314","_wp_attached_file","2012/04/013.jpg");
INSERT INTO `wp_postmeta` VALUES("8","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/013.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"013-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"013-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"013-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"013-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"013-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"013-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"013-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"013-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"013-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"013-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"013-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"013-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("9","314","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("10","315","_wp_attached_file","2012/04/014.jpg");
INSERT INTO `wp_postmeta` VALUES("11","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/014.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"014-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"014-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"014-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"014-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"014-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"014-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"014-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"014-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"014-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"014-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"014-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"014-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"014-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("12","315","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("13","316","_wp_attached_file","2012/04/2.jpg");
INSERT INTO `wp_postmeta` VALUES("14","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/2.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"2-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"2-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"2-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"2-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"2-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"2-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"2-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("15","316","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("16","745","_wp_attached_file","2011/12/imac_big_demo.png");
INSERT INTO `wp_postmeta` VALUES("17","745","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2011/12/imac_big_demo.png\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x360.png\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x430.png\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x270.png\";s:5:\"width\";i:450;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("18","751","_avia_builder_template_single_portfolio_-_slider_two_third","{{{Single Portfolio - Slider Two Third}}}[av_two_third first]
[av_slideshow size=\'gallery\' animation=\'slide\' autoplay=\'true\' interval=\'5\']
[av_slide id=\'316\']
[av_slide id=\'315\']
[av_slide id=\'314\']
[av_slide id=\'313\']
[/av_slideshow]
[/av_two_third]

[av_one_third]
[av_textblock]
<h3>Portfolio Entry!</h3>
Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.
[/av_textblock]

[av_toggle_container initial=\'1\' mode=\'accordion\']
[av_toggle title=\'Client\']
<strong>XY Media</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

<strong>XY Media</strong> Website: <a href=\"http://www.wikipedia.com\">http://www.wikipedia.com</a>
[/av_toggle]
[av_toggle title=\'Our Task\']
<strong>Task</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu.
[/av_toggle]
[av_toggle title=\'Skills Involved\']
<strong>Skills</strong>
<ul>
	<li>Photoshop</li>
	<li>Indesign</li>
	<li>HTML</li>
	<li>CSS</li>
</ul>
[/av_toggle]
[/av_toggle_container]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_textblock]
<h4 style=\"text-align: center;\">Most Recent Entries</h4>
[/av_textblock]

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("3951","2317","_bbp_anonymous_email","dhgrygjv@rnexkaxo.com");
INSERT INTO `wp_postmeta` VALUES("3952","2317","_bbp_anonymous_website","http://generic-celexa.cf/#5353");
INSERT INTO `wp_postmeta` VALUES("3953","2317","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3954","2317","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3946","2316","_bbp_anonymous_website","http://buy-viagra-softtabs.tk/#6661");
INSERT INTO `wp_postmeta` VALUES("3947","2316","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3948","2316","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3949","2316","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3950","2317","_bbp_anonymous_name","buy generic celexa");
INSERT INTO `wp_postmeta` VALUES("3940","2315","_bbp_anonymous_website","http://order-viagra-online.tk/#6239");
INSERT INTO `wp_postmeta` VALUES("3941","2315","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3942","2315","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3943","2315","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3944","2316","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3945","2316","_bbp_anonymous_email","roqlmkuv@lnetoopf.com");
INSERT INTO `wp_postmeta` VALUES("3935","2314","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3936","2314","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3937","2314","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3938","2315","_bbp_anonymous_name","order viagra online");
INSERT INTO `wp_postmeta` VALUES("3939","2315","_bbp_anonymous_email","uutofbyd@iwqwrutt.com");
INSERT INTO `wp_postmeta` VALUES("3934","2314","_bbp_anonymous_website","http://vibramycin.tk/#2105");
INSERT INTO `wp_postmeta` VALUES("3915","2311","_bbp_anonymous_email","svunwksy@lszowvok.com");
INSERT INTO `wp_postmeta` VALUES("3916","2311","_bbp_anonymous_website","http://furosemide-medication.cf/#7291");
INSERT INTO `wp_postmeta` VALUES("3917","2311","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3918","2311","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3919","2311","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3920","2312","_bbp_anonymous_name","ventolin inhaler");
INSERT INTO `wp_postmeta` VALUES("3921","2312","_bbp_anonymous_email","anmqxkrt@kvpmkbfc.com");
INSERT INTO `wp_postmeta` VALUES("3922","2312","_bbp_anonymous_website","http://ventolininhaler.ga/#1401");
INSERT INTO `wp_postmeta` VALUES("3923","2312","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3924","2312","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3925","2312","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3926","2313","_bbp_anonymous_name","generic celebrex");
INSERT INTO `wp_postmeta` VALUES("3927","2313","_bbp_anonymous_email","auothzmu@kfmlejwt.com");
INSERT INTO `wp_postmeta` VALUES("3928","2313","_bbp_anonymous_website","http://genericcelebrex.tk/#3845");
INSERT INTO `wp_postmeta` VALUES("3929","2313","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3930","2313","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3931","2313","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3932","2314","_bbp_anonymous_name","vibramycin");
INSERT INTO `wp_postmeta` VALUES("3933","2314","_bbp_anonymous_email","efqbcwmn@icjdlmod.com");
INSERT INTO `wp_postmeta` VALUES("3901","2308","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3902","2309","_bbp_anonymous_name","cheap tadalafil 20mg");
INSERT INTO `wp_postmeta` VALUES("3903","2309","_bbp_anonymous_email","rllodoyh@ldmjbclf.com");
INSERT INTO `wp_postmeta` VALUES("3904","2309","_bbp_anonymous_website","http://cheap-tadalafil.tk/#4764");
INSERT INTO `wp_postmeta` VALUES("3905","2309","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3906","2309","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3907","2309","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3908","2310","_bbp_anonymous_name","cialis generic tadalafil");
INSERT INTO `wp_postmeta` VALUES("3909","2310","_bbp_anonymous_email","uwxfprmg@utgzdkdu.com");
INSERT INTO `wp_postmeta` VALUES("3910","2310","_bbp_anonymous_website","http://generic-tadalafil.biz/#7497");
INSERT INTO `wp_postmeta` VALUES("3911","2310","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3912","2310","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3913","2310","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3914","2311","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("3900","2308","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3899","2308","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5141","2515","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5140","2515","_bbp_anonymous_website","http://buycelebrex.se/#3021");
INSERT INTO `wp_postmeta` VALUES("47","734","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("48","734","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("49","734","_aviaLayoutBuilderCleanData","[av_layerslider id=\'1\']

[av_one_third first]
[av_icon_box icon=\'ue80c\' font=\'entypo-fontello\' position=\'left\' title=\'S‘inscrire à l’évènement\' link=\'page,1401\' linktarget=\'\' linkelement=\'both\']Inscrivez-vous dès maintenant en ligne aux prochaines 48h de la pige. La 4e édition se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres. Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'Découvrez le programme\' link=\'page,1722\' linktarget=\'\' linkelement=\'both\']Découvrez et téléchargez le programme de la prochaine édition. Les prochaine 48 h proposeront aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain. HORIZON 2030, un thème global et novateur afin d\'anticiper les évolutions de la presse et de se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue856\' font=\'entypo-fontello\' position=\'left\' title=\'Pratique\' link=\'page,821\' linktarget=\'\' linkelement=\'\']Pour anticiper tous les aspects pratiques de votre venue à Vichy, cliquez ici ! Que vous veniez en voiture, en co-voiturage, en train ou encore à pieds, passez donc par cette rubrique afin de connaître l\'indispensable sur les prochaines 48h de la pige. Un forum est à votre disposition afin de partager un transport ou encore un hébergement sur place !</strong>

[/av_icon_box]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']
[av_one_full first]

[av_textblock]
<a href=\"http://dev48h.pigiste.org/portfolio-item/les-48h-en-images/\" title=\"Les 48H en images\">
<h2 style=\"text-align: center;\">Découvrez la galerie photo des 48h</h2>
</a>
[/av_textblock]

[av_hr class=\'short\' height=\'70\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]
[/av_section]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']

[av_one_fifth first]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/audiens.png\' attachment=\'1916\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.audiens.org/pigiste/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/afdas.png\' attachment=\'1915\' align=\'center\' animation=\'no-animation\' link=\'manually,https://www.afdas.com/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/scam.png\' attachment=\'1917\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/pole-univ-01-footer.png\' attachment=\'1925\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2014/05/logos-allier-01.png\' attachment=\'2034\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][/av_section]");
INSERT INTO `wp_postmeta` VALUES("1088","1407","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1089","1407","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1090","1407","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1092","44","_edit_lock","1398426608:1");
INSERT INTO `wp_postmeta` VALUES("1093","1410","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1094","1410","_edit_lock","1398434055:1");
INSERT INTO `wp_postmeta` VALUES("1095","1410","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1096","1410","_aviaLayoutBuilderCleanData","[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Découvrez les 48H en images\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1097","1410","_avia_builder_shortcode_tree","a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("1240","1433","_thumbnail_id","1438");
INSERT INTO `wp_postmeta` VALUES("1098","1410","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1099","1410","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1100","1410","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1101","1410","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1102","1410","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1103","1410","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1104","1410","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1105","1410","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1106","1410","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1107","1410","header","yes");
INSERT INTO `wp_postmeta` VALUES("1108","1410","footer","");
INSERT INTO `wp_postmeta` VALUES("1109","1411","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1110","1411","_menu_item_menu_item_parent","1386");
INSERT INTO `wp_postmeta` VALUES("1111","1411","_menu_item_object_id","1410");
INSERT INTO `wp_postmeta` VALUES("1112","1411","_menu_item_object","portfolio");
INSERT INTO `wp_postmeta` VALUES("1113","1411","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1114","1411","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1115","1411","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1116","1411","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1121","1413","_wp_attached_file","2011/12/IMG_6092.jpg");
INSERT INTO `wp_postmeta` VALUES("1118","1411","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1119","1411","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1120","1411","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1122","1413","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1123","1414","_wp_attached_file","2011/12/IMG_6094.jpg");
INSERT INTO `wp_postmeta` VALUES("1124","1414","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6094.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6094-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6094-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6094-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6094-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6094-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6094-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6094-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6094-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("50","734","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("51","734","sidebar","");
INSERT INTO `wp_postmeta` VALUES("52","734","header","no");
INSERT INTO `wp_postmeta` VALUES("53","734","_avia_builder_shortcode_tree","a:6:{i:0;a:3:{s:3:\"tag\";s:14:\"av_layerslider\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:5;}i:4;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}i:2;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:8;}}s:5:\"index\";i:7;}i:5;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:5:{i:0;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:14;}}s:5:\"index\";i:13;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:15;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}}s:5:\"index\";i:17;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:20;}}s:5:\"index\";i:19;}i:4;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:21;}}s:5:\"index\";i:12;}}");
INSERT INTO `wp_postmeta` VALUES("1330","1496","_wp_attached_file","2011/12/BCR7704.jpg");
INSERT INTO `wp_postmeta` VALUES("1331","1496","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7704.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7704-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7704-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7704-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7704-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7704-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7704-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7704-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7704-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4419","2395","_bbp_anonymous_email","iwhjqocb@cmvbapno.com");
INSERT INTO `wp_postmeta` VALUES("4420","2395","_bbp_anonymous_website","http://mobic75mg.tk/#8936");
INSERT INTO `wp_postmeta` VALUES("1071","1401","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1072","1401","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1073","1401","_aviaLayoutBuilderCleanData","[av_fullscreen size=\'extra_large\' animation=\'fade\' autoplay=\'false\' interval=\'5\']
[av_fullscreen_slide id=\'1635\' position=\'Center Center\' title=\'\' caption_pos=\'caption_bottom\' link=\'\' link_target=\'\' link_apply=\'\' button_label=\'Click me\' button_color=\'light\'][/av_fullscreen_slide]
[/av_fullscreen]

[av_one_full first]
[av_heading heading=\'S‘inscrire à l’édition 2014 des 48h de la pige\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]
[/av_one_full]

[av_textblock ]
<p><strong> Les inscriptions sont closes pour l\'année 2014 ! Rendez-vous l\'année prochaine !</strong>

<em>L\'inscription aux 48h de la pige est gratuite. L\'évènement est ouvert à tous les journalistes pigistes.<br />Pour enregistrer votre inscription nous vous invitons à remplir ce formulaire. Il nous permettra de mieux vous accueillir et répondre à vos besoins en terme d\'hébergement, co-voiturage, restauration...</em></p>

[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("3677","2271","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3678","2271","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("1074","1401","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:13:\"av_fullscreen\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}");
INSERT INTO `wp_postmeta` VALUES("1075","1401","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1076","1401","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1077","1401","header","yes");
INSERT INTO `wp_postmeta` VALUES("1078","1401","footer","");
INSERT INTO `wp_postmeta` VALUES("1079","1407","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1080","1407","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1081","1407","_menu_item_object_id","1401");
INSERT INTO `wp_postmeta` VALUES("4349","2383","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4285","2372","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4286","2373","_bbp_anonymous_name","purchase zithromax online");
INSERT INTO `wp_postmeta` VALUES("4287","2373","_bbp_anonymous_email","tjoartez@apsdeqoj.com");
INSERT INTO `wp_postmeta` VALUES("4288","2373","_bbp_anonymous_website","http://buyzithromax.info/#3301");
INSERT INTO `wp_postmeta` VALUES("4289","2373","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4290","2373","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4291","2373","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4292","2374","_bbp_anonymous_name","neurontin");
INSERT INTO `wp_postmeta` VALUES("4293","2374","_bbp_anonymous_email","yyazsjsq@bhroqeid.com");
INSERT INTO `wp_postmeta` VALUES("4294","2374","_bbp_anonymous_website","http://neurontingabapentin.ga/#4129");
INSERT INTO `wp_postmeta` VALUES("4295","2374","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4296","2374","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4297","2374","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4298","2375","_bbp_anonymous_name","prednisone");
INSERT INTO `wp_postmeta` VALUES("4299","2375","_bbp_anonymous_email","zrzcqtav@mokffnjm.com");
INSERT INTO `wp_postmeta` VALUES("4300","2375","_bbp_anonymous_website","http://cheapprednisoneonline.ga/#3245");
INSERT INTO `wp_postmeta` VALUES("4301","2375","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4302","2375","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4303","2375","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4304","2376","_bbp_anonymous_name","where can i buy amoxicillin without prec");
INSERT INTO `wp_postmeta` VALUES("4305","2376","_bbp_anonymous_email","rznrbjwl@agcjrqne.com");
INSERT INTO `wp_postmeta` VALUES("4306","2376","_bbp_anonymous_website","http://buyamoxicillin.biz/#8169");
INSERT INTO `wp_postmeta` VALUES("4307","2376","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4308","2376","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4309","2376","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4310","2377","_bbp_anonymous_name","cialis 5 mg");
INSERT INTO `wp_postmeta` VALUES("4311","2377","_bbp_anonymous_email","gyhugrjz@yjcdwbwu.com");
INSERT INTO `wp_postmeta` VALUES("4312","2377","_bbp_anonymous_website","http://cialis5mg.tk/#4832");
INSERT INTO `wp_postmeta` VALUES("4313","2377","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4314","2377","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4315","2377","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4316","2378","_bbp_anonymous_name","alli 120 capsules");
INSERT INTO `wp_postmeta` VALUES("4317","2378","_bbp_anonymous_email","rdtehlbg@rsqrrwkk.com");
INSERT INTO `wp_postmeta` VALUES("4318","2378","_bbp_anonymous_website","http://alli-120.tk/#1346");
INSERT INTO `wp_postmeta` VALUES("4319","2378","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4320","2378","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4321","2378","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4322","2379","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4323","2379","_bbp_anonymous_email","tlonfunj@nfjqniwk.com");
INSERT INTO `wp_postmeta` VALUES("4324","2379","_bbp_anonymous_website","http://buycialisonline.ml/#3453");
INSERT INTO `wp_postmeta` VALUES("4325","2379","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4326","2379","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4327","2379","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4328","2380","_bbp_anonymous_name","order acyclovir online");
INSERT INTO `wp_postmeta` VALUES("4329","2380","_bbp_anonymous_email","iwhfywwf@sjicpuyo.com");
INSERT INTO `wp_postmeta` VALUES("4330","2380","_bbp_anonymous_website","http://orderacyclovir.ml/#5938");
INSERT INTO `wp_postmeta` VALUES("4331","2380","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4332","2380","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4333","2380","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4334","2381","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("4335","2381","_bbp_anonymous_email","qzxrgafy@pfldsttg.com");
INSERT INTO `wp_postmeta` VALUES("4336","2381","_bbp_anonymous_website","http://xenical-120-mg.cf/#4963");
INSERT INTO `wp_postmeta` VALUES("4337","2381","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4338","2381","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4339","2381","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4340","2382","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4341","2382","_bbp_anonymous_email","hyewnvab@iqczhuxc.com");
INSERT INTO `wp_postmeta` VALUES("4342","2382","_bbp_anonymous_website","http://cialus.tk/#2261");
INSERT INTO `wp_postmeta` VALUES("4343","2382","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4344","2382","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4345","2382","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4346","2383","_bbp_anonymous_name","where to purchase accutane");
INSERT INTO `wp_postmeta` VALUES("4347","2383","_bbp_anonymous_email","wguhvivk@dwibrijg.com");
INSERT INTO `wp_postmeta` VALUES("4348","2383","_bbp_anonymous_website","http://wheretopurchaseaccutane.cf/#4543");
INSERT INTO `wp_postmeta` VALUES("4284","2372","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4283","2372","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4263","2369","_bbp_anonymous_email","seydbqkt@goiucpfa.com");
INSERT INTO `wp_postmeta` VALUES("4264","2369","_bbp_anonymous_website","http://discountgenericcialis.tk/#1271");
INSERT INTO `wp_postmeta` VALUES("4265","2369","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4266","2369","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4267","2369","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4268","2370","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4269","2370","_bbp_anonymous_email","blejmacc@cqdmqgvk.com");
INSERT INTO `wp_postmeta` VALUES("4270","2370","_bbp_anonymous_website","http://cialistadalafil.cf/#2007");
INSERT INTO `wp_postmeta` VALUES("4271","2370","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4272","2370","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4273","2370","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4274","2371","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4275","2371","_bbp_anonymous_email","irfumpbt@dceznukv.com");
INSERT INTO `wp_postmeta` VALUES("4276","2371","_bbp_anonymous_website","http://accutanegeneric.pw/#3499");
INSERT INTO `wp_postmeta` VALUES("4277","2371","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4278","2371","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4279","2371","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4280","2372","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4281","2372","_bbp_anonymous_email","hlaoqeds@gvxnqokp.com");
INSERT INTO `wp_postmeta` VALUES("4282","2372","_bbp_anonymous_website","http://tadalafil.in/#9676");
INSERT INTO `wp_postmeta` VALUES("61","756","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("62","756","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("63","756","sidebar","");
INSERT INTO `wp_postmeta` VALUES("64","756","header","yes");
INSERT INTO `wp_postmeta` VALUES("65","756","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("66","756","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("67","756","_aviaLayoutBuilderCleanData","[av_portfolio columns=\'4\' items=\'16\' contents=\'title\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_textblock]
This is an example of a sortable, 4 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.

You can add Portfolio Grids to every Page you want or need, with the help of the fantastic and easy to use template builder that is built right into the theme.
[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("4248","2366","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4249","2366","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4250","2367","_bbp_anonymous_name","tadalafil cialis");
INSERT INTO `wp_postmeta` VALUES("4251","2367","_bbp_anonymous_email","qsiuavqi@cievpomm.com");
INSERT INTO `wp_postmeta` VALUES("4252","2367","_bbp_anonymous_website","http://tadalafil-cialis.ml/#9953");
INSERT INTO `wp_postmeta` VALUES("4253","2367","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4254","2367","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4255","2367","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4256","2368","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4257","2368","_bbp_anonymous_email","jsdlnpbn@wjlnyevo.com");
INSERT INTO `wp_postmeta` VALUES("4258","2368","_bbp_anonymous_website","http://buy-tadalafil.info/#2481");
INSERT INTO `wp_postmeta` VALUES("4259","2368","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4260","2368","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4247","2366","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4234","2364","_bbp_anonymous_website","http://genericabilify.biz/#2044");
INSERT INTO `wp_postmeta` VALUES("4235","2364","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4236","2364","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4237","2364","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4238","2365","_bbp_anonymous_name","this site");
INSERT INTO `wp_postmeta` VALUES("4239","2365","_bbp_anonymous_email","bgdgshny@zctagrqk.com");
INSERT INTO `wp_postmeta` VALUES("4240","2365","_bbp_anonymous_website","http://vardenafil-hcl.tk/#7692");
INSERT INTO `wp_postmeta` VALUES("4241","2365","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4242","2365","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4243","2365","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4244","2366","_bbp_anonymous_name","baclofen");
INSERT INTO `wp_postmeta` VALUES("4245","2366","_bbp_anonymous_email","axypkpdv@ybqdyysq.com");
INSERT INTO `wp_postmeta` VALUES("4246","2366","_bbp_anonymous_website","http://baclofen.ml/#3610");
INSERT INTO `wp_postmeta` VALUES("4233","2364","_bbp_anonymous_email","zotvcdvl@vzvcwhhp.com");
INSERT INTO `wp_postmeta` VALUES("4232","2364","_bbp_anonymous_name","wellbutrin abilify");
INSERT INTO `wp_postmeta` VALUES("4185","2356","_bbp_anonymous_email","zjiujopd@hevhkwmm.com");
INSERT INTO `wp_postmeta` VALUES("4186","2356","_bbp_anonymous_website","http://antibioticlevaquin.ml/#7740");
INSERT INTO `wp_postmeta` VALUES("4187","2356","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4188","2356","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4189","2356","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4190","2357","_bbp_anonymous_name","cialis generic viagra");
INSERT INTO `wp_postmeta` VALUES("4191","2357","_bbp_anonymous_email","grquypdz@czxrqctq.com");
INSERT INTO `wp_postmeta` VALUES("4192","2357","_bbp_anonymous_website","http://generic-cialis.se/#6707");
INSERT INTO `wp_postmeta` VALUES("4193","2357","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4194","2357","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4195","2357","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4196","2358","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("4197","2358","_bbp_anonymous_email","esvxsewf@bnnqrymp.com");
INSERT INTO `wp_postmeta` VALUES("4198","2358","_bbp_anonymous_website","http://alli-pill.ml/#4756");
INSERT INTO `wp_postmeta` VALUES("4199","2358","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4200","2358","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4201","2358","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4202","2359","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("4203","2359","_bbp_anonymous_email","wpxlgwql@pcbzhefw.com");
INSERT INTO `wp_postmeta` VALUES("4204","2359","_bbp_anonymous_website","http://amoxicillin875.ml/#5172");
INSERT INTO `wp_postmeta` VALUES("4205","2359","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4206","2359","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4207","2359","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4208","2360","_bbp_anonymous_name","flagyl");
INSERT INTO `wp_postmeta` VALUES("4209","2360","_bbp_anonymous_email","nhupvxet@szotedyd.com");
INSERT INTO `wp_postmeta` VALUES("4210","2360","_bbp_anonymous_website","http://buyflagyl.se/#3570");
INSERT INTO `wp_postmeta` VALUES("4211","2360","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4212","2360","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4213","2360","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4214","2361","_bbp_anonymous_name","generic valtrex online without perscription");
INSERT INTO `wp_postmeta` VALUES("4215","2361","_bbp_anonymous_email","oyugfavl@bewxolfd.com");
INSERT INTO `wp_postmeta` VALUES("4216","2361","_bbp_anonymous_website","http://genericforvaltrex.cf/#7695");
INSERT INTO `wp_postmeta` VALUES("4217","2361","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4218","2361","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4219","2361","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4220","2362","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4221","2362","_bbp_anonymous_email","lfwsgqpt@pkdinypo.com");
INSERT INTO `wp_postmeta` VALUES("4222","2362","_bbp_anonymous_website","http://accutane.ml/#4361");
INSERT INTO `wp_postmeta` VALUES("4223","2362","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4224","2362","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4225","2362","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4226","2363","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4227","2363","_bbp_anonymous_email","kqtdibjj@gsmlerjr.com");
INSERT INTO `wp_postmeta` VALUES("4228","2363","_bbp_anonymous_website","http://accutane.se/#3980");
INSERT INTO `wp_postmeta` VALUES("4229","2363","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4184","2356","_bbp_anonymous_name","antibiotic levaquin");
INSERT INTO `wp_postmeta` VALUES("4183","2355","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4085","2339","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4086","2339","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4087","2339","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4088","2340","_bbp_anonymous_name","alli for sale");
INSERT INTO `wp_postmeta` VALUES("4089","2340","_bbp_anonymous_email","bjbhgjrs@uyiptoly.com");
INSERT INTO `wp_postmeta` VALUES("4090","2340","_bbp_anonymous_website","http://alli.in/#3972");
INSERT INTO `wp_postmeta` VALUES("4091","2340","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4092","2340","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4093","2340","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4094","2341","_bbp_anonymous_name","bupropion sr 100mg");
INSERT INTO `wp_postmeta` VALUES("4095","2341","_bbp_anonymous_email","icnssjzy@ajohcani.com");
INSERT INTO `wp_postmeta` VALUES("4096","2341","_bbp_anonymous_website","http://bupropionsr100mg.cf/#2940");
INSERT INTO `wp_postmeta` VALUES("4097","2341","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4098","2341","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4099","2341","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4100","2342","_bbp_anonymous_name","diflucan");
INSERT INTO `wp_postmeta` VALUES("4101","2342","_bbp_anonymous_email","cjdtdmof@hcdblfnt.com");
INSERT INTO `wp_postmeta` VALUES("4102","2342","_bbp_anonymous_website","http://genericdiflucan.cf/#8503");
INSERT INTO `wp_postmeta` VALUES("4103","2342","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4104","2342","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4105","2342","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4106","2343","_bbp_anonymous_name","where to buy cialis over the counter");
INSERT INTO `wp_postmeta` VALUES("4107","2343","_bbp_anonymous_email","qubzomam@yecwlyzs.com");
INSERT INTO `wp_postmeta` VALUES("4108","2343","_bbp_anonymous_website","http://wheretobuycialis.ml/#3979");
INSERT INTO `wp_postmeta` VALUES("4109","2343","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4110","2343","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4111","2343","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4112","2344","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("4113","2344","_bbp_anonymous_email","vyxtesbb@zrdaxojn.com");
INSERT INTO `wp_postmeta` VALUES("4114","2344","_bbp_anonymous_website","http://sildenafil-100-mg.ml/#5221");
INSERT INTO `wp_postmeta` VALUES("4115","2344","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4116","2344","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4117","2344","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4118","2345","_bbp_anonymous_name","order neurontin online");
INSERT INTO `wp_postmeta` VALUES("4119","2345","_bbp_anonymous_email","fvegbrrt@hvqhuhrq.com");
INSERT INTO `wp_postmeta` VALUES("4120","2345","_bbp_anonymous_website","http://neurontin.biz/#5935");
INSERT INTO `wp_postmeta` VALUES("4121","2345","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4122","2345","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4123","2345","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4124","2346","_bbp_anonymous_name","viagra professional");
INSERT INTO `wp_postmeta` VALUES("4125","2346","_bbp_anonymous_email","xqsfvuhz@ullriocs.com");
INSERT INTO `wp_postmeta` VALUES("4126","2346","_bbp_anonymous_website","http://viagraprofessional.tk/#2304");
INSERT INTO `wp_postmeta` VALUES("4127","2346","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4128","2346","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4129","2346","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4130","2347","_bbp_anonymous_name","tadalafil without prescription");
INSERT INTO `wp_postmeta` VALUES("4131","2347","_bbp_anonymous_email","ryhuzmps@tuoxarqs.com");
INSERT INTO `wp_postmeta` VALUES("4132","2347","_bbp_anonymous_website","http://cialistadalafil.ml/#9075");
INSERT INTO `wp_postmeta` VALUES("4133","2347","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4134","2347","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4135","2347","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4136","2348","_bbp_anonymous_name","generic for propecia");
INSERT INTO `wp_postmeta` VALUES("4137","2348","_bbp_anonymous_email","armavkwk@kxfvdmen.com");
INSERT INTO `wp_postmeta` VALUES("4138","2348","_bbp_anonymous_website","http://buypropeciawithoutprescription.tk/#8964");
INSERT INTO `wp_postmeta` VALUES("4139","2348","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4140","2348","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4141","2348","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4142","2349","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4143","2349","_bbp_anonymous_email","ppsayohc@rgjedqrf.com");
INSERT INTO `wp_postmeta` VALUES("4144","2349","_bbp_anonymous_website","http://dailycialiscost.pw/#8082");
INSERT INTO `wp_postmeta` VALUES("4145","2349","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4146","2349","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4147","2349","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4148","2350","_bbp_anonymous_name","buy accutane");
INSERT INTO `wp_postmeta` VALUES("4149","2350","_bbp_anonymous_email","knmjliyc@qekrgofa.com");
INSERT INTO `wp_postmeta` VALUES("4150","2350","_bbp_anonymous_website","http://buy-accutane.nu/#1555");
INSERT INTO `wp_postmeta` VALUES("4151","2350","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4152","2350","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4153","2350","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4154","2351","_bbp_anonymous_name","alli 120 count");
INSERT INTO `wp_postmeta` VALUES("4155","2351","_bbp_anonymous_email","urzfakrk@rzjbrtpb.com");
INSERT INTO `wp_postmeta` VALUES("4156","2351","_bbp_anonymous_website","http://alli120.ml/#6279");
INSERT INTO `wp_postmeta` VALUES("4157","2351","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4158","2351","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4159","2351","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4160","2352","_bbp_anonymous_name","cheap tadalafil 20mg");
INSERT INTO `wp_postmeta` VALUES("4161","2352","_bbp_anonymous_email","vogxrrqx@rygwsnxv.com");
INSERT INTO `wp_postmeta` VALUES("4162","2352","_bbp_anonymous_website","http://tadalafilgeneric.ml/#2544");
INSERT INTO `wp_postmeta` VALUES("4163","2352","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4164","2352","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4165","2352","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4166","2353","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4167","2353","_bbp_anonymous_email","irgsqnrm@duwepnbe.com");
INSERT INTO `wp_postmeta` VALUES("4168","2353","_bbp_anonymous_website","http://buy-zithromax.se/#6306");
INSERT INTO `wp_postmeta` VALUES("4169","2353","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4170","2353","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4171","2353","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4172","2354","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("4173","2354","_bbp_anonymous_email","egdleria@orlssmva.com");
INSERT INTO `wp_postmeta` VALUES("4174","2354","_bbp_anonymous_website","http://buyviagrasofttabs.ml/#6145");
INSERT INTO `wp_postmeta` VALUES("4175","2354","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4176","2354","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4177","2354","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4178","2355","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("4179","2355","_bbp_anonymous_email","wammqydx@ksfzyjhq.com");
INSERT INTO `wp_postmeta` VALUES("4180","2355","_bbp_anonymous_website","http://buy-mobic.cf/#8776");
INSERT INTO `wp_postmeta` VALUES("4181","2355","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4182","2355","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4084","2339","_bbp_anonymous_website","http://disulfiramantabuse.tk/#4859");
INSERT INTO `wp_postmeta` VALUES("4082","2339","_bbp_anonymous_name","disulfiram antabuse");
INSERT INTO `wp_postmeta` VALUES("4081","2338","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4080","2338","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4079","2338","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4004","2326","_bbp_anonymous_name","alli diet pill");
INSERT INTO `wp_postmeta` VALUES("4005","2326","_bbp_anonymous_email","jayiazft@gypoxpiq.com");
INSERT INTO `wp_postmeta` VALUES("4006","2326","_bbp_anonymous_website","http://alli-diet-pill.ga/#5423");
INSERT INTO `wp_postmeta` VALUES("4007","2326","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4008","2326","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4009","2326","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4010","2327","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("4011","2327","_bbp_anonymous_email","exoxxcrk@rwyqoshw.com");
INSERT INTO `wp_postmeta` VALUES("4012","2327","_bbp_anonymous_website","http://buy-nexium.tk/#8895");
INSERT INTO `wp_postmeta` VALUES("4013","2327","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4014","2327","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4015","2327","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4016","2328","_bbp_anonymous_name","purchase cialis online");
INSERT INTO `wp_postmeta` VALUES("4017","2328","_bbp_anonymous_email","uyvqqxzl@upexhydd.com");
INSERT INTO `wp_postmeta` VALUES("4018","2328","_bbp_anonymous_website","http://cialispricing.ml/#4893");
INSERT INTO `wp_postmeta` VALUES("4019","2328","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4020","2328","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4021","2328","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4022","2329","_bbp_anonymous_name","cipro");
INSERT INTO `wp_postmeta` VALUES("4023","2329","_bbp_anonymous_email","pjwezbox@mqqenond.com");
INSERT INTO `wp_postmeta` VALUES("4024","2329","_bbp_anonymous_website","http://ciproiv.ml/#7889");
INSERT INTO `wp_postmeta` VALUES("4025","2329","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4026","2329","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4027","2329","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4028","2330","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4029","2330","_bbp_anonymous_email","ugyqjxmg@ccofdenh.com");
INSERT INTO `wp_postmeta` VALUES("4030","2330","_bbp_anonymous_website","http://cilias.cf/#2153");
INSERT INTO `wp_postmeta` VALUES("4031","2330","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4032","2330","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4033","2330","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4034","2331","_bbp_anonymous_name","wellbutrin drug");
INSERT INTO `wp_postmeta` VALUES("4035","2331","_bbp_anonymous_email","lbyejtmy@inpadzhx.com");
INSERT INTO `wp_postmeta` VALUES("4036","2331","_bbp_anonymous_website","http://wellbutrinxl150mg.ml/#3574");
INSERT INTO `wp_postmeta` VALUES("4037","2331","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4038","2331","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4039","2331","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4040","2332","_bbp_anonymous_name","advair");
INSERT INTO `wp_postmeta` VALUES("4041","2332","_bbp_anonymous_email","addkdecy@voqhadak.com");
INSERT INTO `wp_postmeta` VALUES("4042","2332","_bbp_anonymous_website","http://advair250.tk/#7292");
INSERT INTO `wp_postmeta` VALUES("4043","2332","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4044","2332","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4045","2332","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4046","2333","_bbp_anonymous_name","generic accutane cost");
INSERT INTO `wp_postmeta` VALUES("4047","2333","_bbp_anonymous_email","wqpyybsa@pabowpmv.com");
INSERT INTO `wp_postmeta` VALUES("4048","2333","_bbp_anonymous_website","http://accutane-cost.tk/#2375");
INSERT INTO `wp_postmeta` VALUES("4049","2333","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4050","2333","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4051","2333","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4052","2334","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("4053","2334","_bbp_anonymous_email","auwgjoem@icyvmgga.com");
INSERT INTO `wp_postmeta` VALUES("4054","2334","_bbp_anonymous_website","http://generic-sildenafil.cf/#5238");
INSERT INTO `wp_postmeta` VALUES("4055","2334","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4056","2334","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4057","2334","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4058","2335","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("4059","2335","_bbp_anonymous_email","tifbhsyy@wczdjlwp.com");
INSERT INTO `wp_postmeta` VALUES("4060","2335","_bbp_anonymous_website","http://vardenafil-hydrochloride.cf/#2359");
INSERT INTO `wp_postmeta` VALUES("4061","2335","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4062","2335","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4063","2335","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4064","2336","_bbp_anonymous_name","where can i buy tretinoin");
INSERT INTO `wp_postmeta` VALUES("4065","2336","_bbp_anonymous_email","vistcktg@uyayjzmb.com");
INSERT INTO `wp_postmeta` VALUES("4066","2336","_bbp_anonymous_website","http://tretinoin-cream.cf/#5839");
INSERT INTO `wp_postmeta` VALUES("4067","2336","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4068","2336","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4069","2336","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4070","2337","_bbp_anonymous_name","buy tretinoin cream");
INSERT INTO `wp_postmeta` VALUES("4071","2337","_bbp_anonymous_email","kgwmlcra@zwgdmpxn.com");
INSERT INTO `wp_postmeta` VALUES("4072","2337","_bbp_anonymous_website","http://tretinoin.ga/#5516");
INSERT INTO `wp_postmeta` VALUES("4073","2337","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4074","2337","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4075","2337","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4076","2338","_bbp_anonymous_name","prednisone");
INSERT INTO `wp_postmeta` VALUES("4077","2338","_bbp_anonymous_email","cmdznqif@ekgqahgr.com");
INSERT INTO `wp_postmeta` VALUES("4078","2338","_bbp_anonymous_website","http://prednisone20mgmedication.tk/#9794");
INSERT INTO `wp_postmeta` VALUES("3959","2318","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3960","2318","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3961","2318","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3962","2319","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("3963","2319","_bbp_anonymous_email","zuqxsspn@dnymjwor.com");
INSERT INTO `wp_postmeta` VALUES("3964","2319","_bbp_anonymous_website","http://meloxicam.cf/#4260");
INSERT INTO `wp_postmeta` VALUES("3965","2319","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3966","2319","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3967","2319","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3968","2320","_bbp_anonymous_name","buy vardenafil");
INSERT INTO `wp_postmeta` VALUES("3969","2320","_bbp_anonymous_email","skdzuirm@zpqntrli.com");
INSERT INTO `wp_postmeta` VALUES("3970","2320","_bbp_anonymous_website","http://buyvardenafil.biz/#1106");
INSERT INTO `wp_postmeta` VALUES("3971","2320","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3972","2320","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3973","2320","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3974","2321","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("3975","2321","_bbp_anonymous_email","vlvsyass@zzlsqnjw.com");
INSERT INTO `wp_postmeta` VALUES("3976","2321","_bbp_anonymous_website","http://buynexiumonline.ml/#2226");
INSERT INTO `wp_postmeta` VALUES("3977","2321","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3978","2321","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3979","2321","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3980","2322","_bbp_anonymous_name","get the facts");
INSERT INTO `wp_postmeta` VALUES("3981","2322","_bbp_anonymous_email","uiqlhoye@xkbczezj.com");
INSERT INTO `wp_postmeta` VALUES("3982","2322","_bbp_anonymous_website","http://genericeffexor.cf/#8027");
INSERT INTO `wp_postmeta` VALUES("3983","2322","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3984","2322","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3985","2322","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3986","2323","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("3987","2323","_bbp_anonymous_email","sjqnmuop@ctixpkwv.com");
INSERT INTO `wp_postmeta` VALUES("3988","2323","_bbp_anonymous_website","http://cheapmobic.cf/#2980");
INSERT INTO `wp_postmeta` VALUES("3989","2323","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3990","2323","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3991","2323","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3992","2324","_bbp_anonymous_name","generic synthroid");
INSERT INTO `wp_postmeta` VALUES("3993","2324","_bbp_anonymous_email","kydsjiex@tfrjbqkb.com");
INSERT INTO `wp_postmeta` VALUES("3994","2324","_bbp_anonymous_website","http://generic-synthroid.cf/#2475");
INSERT INTO `wp_postmeta` VALUES("3995","2324","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3996","2324","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3997","2324","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3998","2325","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3999","2325","_bbp_anonymous_email","xkqucmgu@bnpxnept.com");
INSERT INTO `wp_postmeta` VALUES("4000","2325","_bbp_anonymous_website","http://cheapcialisonline.tk/#7839");
INSERT INTO `wp_postmeta` VALUES("4001","2325","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4002","2325","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4003","2325","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3881","2305","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3882","2305","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3883","2305","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3884","2306","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3885","2306","_bbp_anonymous_email","fmactwof@qmczaefn.com");
INSERT INTO `wp_postmeta` VALUES("3886","2306","_bbp_anonymous_website","http://genericviagra.pw/#1789");
INSERT INTO `wp_postmeta` VALUES("3887","2306","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3888","2306","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3889","2306","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3890","2307","_bbp_anonymous_name","nexium dr 40 mg");
INSERT INTO `wp_postmeta` VALUES("3891","2307","_bbp_anonymous_email","hfifjlth@naaucvsi.com");
INSERT INTO `wp_postmeta` VALUES("3892","2307","_bbp_anonymous_website","http://nexium40.cf/#1126");
INSERT INTO `wp_postmeta` VALUES("3893","2307","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3894","2307","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3895","2307","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3896","2308","_bbp_anonymous_name","lisinopril 10mg");
INSERT INTO `wp_postmeta` VALUES("3897","2308","_bbp_anonymous_email","kceapoqk@blpxdeom.com");
INSERT INTO `wp_postmeta` VALUES("3880","2305","_bbp_anonymous_website","http://bestplacetobuyviagraonline.tk/#8476");
INSERT INTO `wp_postmeta` VALUES("3879","2305","_bbp_anonymous_email","luotzyfr@cxbwyfxm.com");
INSERT INTO `wp_postmeta` VALUES("3878","2305","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3877","2304","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3847","2299","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3848","2300","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("3849","2300","_bbp_anonymous_email","oaenftve@ljshwcbk.com");
INSERT INTO `wp_postmeta` VALUES("3850","2300","_bbp_anonymous_website","http://buyzithromax.se/#9025");
INSERT INTO `wp_postmeta` VALUES("3851","2300","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3852","2300","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3853","2300","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3854","2301","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("3855","2301","_bbp_anonymous_email","yzswtmkl@yomolzgs.com");
INSERT INTO `wp_postmeta` VALUES("3856","2301","_bbp_anonymous_website","http://alli120.pw/#1597");
INSERT INTO `wp_postmeta` VALUES("3857","2301","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3858","2301","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3859","2301","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3860","2302","_bbp_anonymous_name","neurontin");
INSERT INTO `wp_postmeta` VALUES("3861","2302","_bbp_anonymous_email","ifuzczba@evxitben.com");
INSERT INTO `wp_postmeta` VALUES("3862","2302","_bbp_anonymous_website","http://neurontingabapentin.tk/#4076");
INSERT INTO `wp_postmeta` VALUES("3863","2302","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3864","2302","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3865","2302","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3866","2303","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("3867","2303","_bbp_anonymous_email","lityzlhq@zumnvept.com");
INSERT INTO `wp_postmeta` VALUES("3868","2303","_bbp_anonymous_website","http://propeciacost.ml/#1264");
INSERT INTO `wp_postmeta` VALUES("3869","2303","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3870","2303","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3871","2303","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3872","2304","_bbp_anonymous_name","valtrex medication");
INSERT INTO `wp_postmeta` VALUES("3873","2304","_bbp_anonymous_email","grudjloq@feklzhjy.com");
INSERT INTO `wp_postmeta` VALUES("3874","2304","_bbp_anonymous_website","http://valtrex.se/#3006");
INSERT INTO `wp_postmeta` VALUES("3875","2304","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3876","2304","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3830","2297","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("3831","2297","_bbp_anonymous_email","zjmhuvau@rtvsltgx.com");
INSERT INTO `wp_postmeta` VALUES("3832","2297","_bbp_anonymous_website","http://keflex500.cf/#3557");
INSERT INTO `wp_postmeta` VALUES("3833","2297","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3834","2297","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3835","2297","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3836","2298","_bbp_anonymous_name","buystrattera");
INSERT INTO `wp_postmeta` VALUES("3837","2298","_bbp_anonymous_email","emuwzyfo@kigbaads.com");
INSERT INTO `wp_postmeta` VALUES("3838","2298","_bbp_anonymous_website","http://atomoxetine.cf/#2002");
INSERT INTO `wp_postmeta` VALUES("3839","2298","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3840","2298","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3841","2298","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3842","2299","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("3843","2299","_bbp_anonymous_email","gizwpzvg@lndzibgc.com");
INSERT INTO `wp_postmeta` VALUES("3844","2299","_bbp_anonymous_website","http://buy-doxycycline.ga/#4402");
INSERT INTO `wp_postmeta` VALUES("3829","2296","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3828","2296","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3827","2296","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3826","2296","_bbp_anonymous_website","http://howtoorderviagra.ml/#1251");
INSERT INTO `wp_postmeta` VALUES("3800","2292","_bbp_anonymous_name","tadalafil no prescription");
INSERT INTO `wp_postmeta` VALUES("3801","2292","_bbp_anonymous_email","cvdhccsx@rlwfapkd.com");
INSERT INTO `wp_postmeta` VALUES("3802","2292","_bbp_anonymous_website","http://tadalafilnoprescription.ga/#5105");
INSERT INTO `wp_postmeta` VALUES("3803","2292","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3804","2292","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3805","2292","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3806","2293","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("3807","2293","_bbp_anonymous_email","qtroxrxz@ddsggdro.com");
INSERT INTO `wp_postmeta` VALUES("3808","2293","_bbp_anonymous_website","http://genericcelebrex.nu/#8724");
INSERT INTO `wp_postmeta` VALUES("3809","2293","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3810","2293","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3811","2293","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3812","2294","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3813","2294","_bbp_anonymous_email","dxqiywuc@osctkwwx.com");
INSERT INTO `wp_postmeta` VALUES("3814","2294","_bbp_anonymous_website","http://ordercialis.ml/#3579");
INSERT INTO `wp_postmeta` VALUES("3815","2294","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3816","2294","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3817","2294","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3818","2295","_bbp_anonymous_name","mobic 7.5 mg");
INSERT INTO `wp_postmeta` VALUES("3819","2295","_bbp_anonymous_email","fmrlqdfb@qklwueyx.com");
INSERT INTO `wp_postmeta` VALUES("3820","2295","_bbp_anonymous_website","http://mobic75mg.pw/#6384");
INSERT INTO `wp_postmeta` VALUES("3821","2295","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3822","2295","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3823","2295","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3824","2296","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3825","2296","_bbp_anonymous_email","itootxlw@ojbdlzhk.com");
INSERT INTO `wp_postmeta` VALUES("3791","2290","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3792","2290","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3793","2290","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3794","2291","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("3795","2291","_bbp_anonymous_email","xnpeqjhc@liwpkjsf.com");
INSERT INTO `wp_postmeta` VALUES("3796","2291","_bbp_anonymous_website","http://amoxil-500.tk/#3245");
INSERT INTO `wp_postmeta` VALUES("3797","2291","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3790","2290","_bbp_anonymous_website","http://generic-lexapro.ml/#8757");
INSERT INTO `wp_postmeta` VALUES("3789","2290","_bbp_anonymous_email","ukhysmgr@zjrlftrd.com");
INSERT INTO `wp_postmeta` VALUES("3753","2284","_bbp_anonymous_email","wgwmjkyg@eiucfexo.com");
INSERT INTO `wp_postmeta` VALUES("3754","2284","_bbp_anonymous_website","http://buyviagra-soft-tabs.cf/#9988");
INSERT INTO `wp_postmeta` VALUES("3755","2284","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3756","2284","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3757","2284","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3758","2285","_bbp_anonymous_name","atenolol medication");
INSERT INTO `wp_postmeta` VALUES("3759","2285","_bbp_anonymous_email","gvmjojnw@xbcftajz.com");
INSERT INTO `wp_postmeta` VALUES("3760","2285","_bbp_anonymous_website","http://atenololmedication.tk/#2229");
INSERT INTO `wp_postmeta` VALUES("3761","2285","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3762","2285","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3763","2285","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3764","2286","_bbp_anonymous_name","viagra cialis levitra");
INSERT INTO `wp_postmeta` VALUES("3765","2286","_bbp_anonymous_email","ifwgsqql@mxseabez.com");
INSERT INTO `wp_postmeta` VALUES("3766","2286","_bbp_anonymous_website","http://viagracialislevitra.cf/#7245");
INSERT INTO `wp_postmeta` VALUES("3767","2286","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3768","2286","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3769","2286","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3770","2287","_bbp_anonymous_name","metformin generic");
INSERT INTO `wp_postmeta` VALUES("3771","2287","_bbp_anonymous_email","lmvogude@sbeswsaf.com");
INSERT INTO `wp_postmeta` VALUES("3772","2287","_bbp_anonymous_website","http://metformingeneric.ga/#2823");
INSERT INTO `wp_postmeta` VALUES("3773","2287","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3774","2287","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3775","2287","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3776","2288","_bbp_anonymous_name","doxycycline 100mg dogs");
INSERT INTO `wp_postmeta` VALUES("3777","2288","_bbp_anonymous_email","dtnxrkli@fieofjwl.com");
INSERT INTO `wp_postmeta` VALUES("3778","2288","_bbp_anonymous_website","http://doxycycline100mgdogs.ga/#4571");
INSERT INTO `wp_postmeta` VALUES("3779","2288","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3780","2288","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3781","2288","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3782","2289","_bbp_anonymous_name","more help");
INSERT INTO `wp_postmeta` VALUES("3783","2289","_bbp_anonymous_email","zjyiqcga@dsvjibml.com");
INSERT INTO `wp_postmeta` VALUES("3784","2289","_bbp_anonymous_website","http://levaquin500.pw/#6473");
INSERT INTO `wp_postmeta` VALUES("3785","2289","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3786","2289","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3787","2289","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3788","2290","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("115","821","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("116","821","sidebar","");
INSERT INTO `wp_postmeta` VALUES("117","821","header","yes");
INSERT INTO `wp_postmeta` VALUES("118","821","_dp_original","812");
INSERT INTO `wp_postmeta` VALUES("119","821","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("120","821","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("121","821","_aviaLayoutBuilderCleanData","[av_heading tag=\'h3\' padding=\'10\' heading=\'Anticipez tous les aspects pratiques de votre venue à Vichy !\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_one_half first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2014/04/P11705391-710x575.jpg\' attachment=\'1544\' align=\'center\' animation=\'left-to-right\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_textblock]
<h2>Bienvenue à Vichy !</h2>
[/av_textblock]

[av_textblock]
La 4e édition des 48 heures de la pige se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres
[/av_textblock]

[av_sidebar widget_area=\'Google Map\']
[/av_one_half]

[av_hr class=\'big\' height=\'50\' position=\'center\']

[av_one_fourth first]

[av_icon_box icon=\'ue8d7\' font=\'entypo-fontello\' position=\'left\' title=\'Comment venir ?\' link=\'page,1792\' linktarget=\'\' linkelement=\'both\']
<p>Pour connaître toutes les informations utiles concernant votre arrivée et les moyens de transport pour Vichy, c\'est par ici !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8b5\' font=\'entypo-fontello\' position=\'left\' title=\'Où dormir ?\' link=\'page,1801\' linktarget=\'\' linkelement=\'both\']
<p>Nous vous proposons plusieurs options pour vous loger sur place, découvrez ici les hôtels disponibles et renseignez la case hébergement lors de votre inscription !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8a9\' font=\'entypo-fontello\' position=\'left\' title=\'Que manger ?\' link=\'\' linktarget=\'\' linkelement=\'\']
<p>Si vous le désirez, vous pourrez vous restaurer sur place ! Renseignez simplement la case restauration lors de votre inscription à l\'événement</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue836\' font=\'entypo-fontello\' position=\'left\' title=\'Le forum\' link=\'page,1750\' linktarget=\'\' linkelement=\'both\']
<p>Pas envie de voyager ni de se loger seul(e) ? Partagez ici vos moyens de transport ou encore votre hébergement grâce à notre forum pratique !</p>

[/av_icon_box]

[/av_one_fourth][av_hr class=\'big\' height=\'50\' position=\'center\']

");
INSERT INTO `wp_postmeta` VALUES("3639","2265","_bbp_anonymous_email","fjppgkgr@tdtfendh.com");
INSERT INTO `wp_postmeta` VALUES("1586","1629","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1588","1630","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:21:\"2014/04/textvichy.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"textvichy-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"textvichy-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"textvichy-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"textvichy-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"textvichy-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"textvichy-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"textvichy-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"textvichy-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"textvichy-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("122","821","_avia_builder_shortcode_tree","a:9:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:1;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:2;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}i:4;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}}s:5:\"index\";i:8;}i:5;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:10;}i:6;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:7;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}}s:5:\"index\";i:14;}i:8;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}");
INSERT INTO `wp_postmeta` VALUES("3638","2265","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("1577","1629","_menu_item_object_id","821");
INSERT INTO `wp_postmeta` VALUES("1578","1629","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1579","1629","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1580","1629","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1581","1629","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1582","1629","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1587","1630","_wp_attached_file","2014/04/textvichy.png");
INSERT INTO `wp_postmeta` VALUES("1584","1629","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1585","1629","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("3748","2283","_bbp_anonymous_website","http://genericazithromycin.ml/#5029");
INSERT INTO `wp_postmeta` VALUES("3720","2278","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3721","2278","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3722","2279","_bbp_anonymous_name","sildenafil price");
INSERT INTO `wp_postmeta` VALUES("3723","2279","_bbp_anonymous_email","rarqvocq@hzbtirqd.com");
INSERT INTO `wp_postmeta` VALUES("3724","2279","_bbp_anonymous_website","http://sildenafilprice.ml/#7219");
INSERT INTO `wp_postmeta` VALUES("3725","2279","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3726","2279","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3727","2279","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3728","2280","_bbp_anonymous_name","bupropion sr 200 mg");
INSERT INTO `wp_postmeta` VALUES("3729","2280","_bbp_anonymous_email","nakjwifo@cphttkbv.com");
INSERT INTO `wp_postmeta` VALUES("3730","2280","_bbp_anonymous_website","http://genericbupropion.in/#7949");
INSERT INTO `wp_postmeta` VALUES("3731","2280","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3732","2280","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3733","2280","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3734","2281","_bbp_anonymous_name","acyclovir 800mg tablets");
INSERT INTO `wp_postmeta` VALUES("3735","2281","_bbp_anonymous_email","dupyadox@nbqjdoqs.com");
INSERT INTO `wp_postmeta` VALUES("3736","2281","_bbp_anonymous_website","http://valacyclovir.cf/#8199");
INSERT INTO `wp_postmeta` VALUES("3737","2281","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3738","2281","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3739","2281","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3740","2282","_bbp_anonymous_name","generic vardenafil");
INSERT INTO `wp_postmeta` VALUES("3741","2282","_bbp_anonymous_email","vbqjuxvw@nteqctlg.com");
INSERT INTO `wp_postmeta` VALUES("3742","2282","_bbp_anonymous_website","http://generic-vardenafil.se/#6448");
INSERT INTO `wp_postmeta` VALUES("3743","2282","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3744","2282","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3745","2282","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3746","2283","_bbp_anonymous_name","azithromycin generic");
INSERT INTO `wp_postmeta` VALUES("3747","2283","_bbp_anonymous_email","iudyosye@wvlvqsmn.com");
INSERT INTO `wp_postmeta` VALUES("3719","2278","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3702","2275","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3703","2275","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3704","2276","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3705","2276","_bbp_anonymous_email","chxqcbhy@kzjpcbmv.com");
INSERT INTO `wp_postmeta` VALUES("3706","2276","_bbp_anonymous_website","http://buycialisonlinenoprescription.cf/#4889");
INSERT INTO `wp_postmeta` VALUES("3707","2276","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3708","2276","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3709","2276","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3710","2277","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("3711","2277","_bbp_anonymous_email","ctzyvmlj@uaaklawz.com");
INSERT INTO `wp_postmeta` VALUES("3712","2277","_bbp_anonymous_website","http://strattera.in/#3671");
INSERT INTO `wp_postmeta` VALUES("3713","2277","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3714","2277","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3715","2277","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3716","2278","_bbp_anonymous_name","cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("3717","2278","_bbp_anonymous_email","dcipxgdl@wvcfepar.com");
INSERT INTO `wp_postmeta` VALUES("3718","2278","_bbp_anonymous_website","http://buycialisonlinewithoutprescription.tk/#7887");
INSERT INTO `wp_postmeta` VALUES("2370","1991","_wp_attached_file","2014/05/HUNTER-2013-original1.jpg");
INSERT INTO `wp_postmeta` VALUES("2371","1991","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:474;s:4:\"file\";s:33:\"2014/05/HUNTER-2013-original1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x474.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:474;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-705x427.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x273.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3673","2270","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3674","2271","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("3668","2270","_bbp_anonymous_name","where to get accutane");
INSERT INTO `wp_postmeta` VALUES("3669","2270","_bbp_anonymous_email","lhuxapba@nqjmdwin.com");
INSERT INTO `wp_postmeta` VALUES("3670","2270","_bbp_anonymous_website","http://buyaccutaneonline.ml/#6222");
INSERT INTO `wp_postmeta` VALUES("3661","2268","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3660","2268","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3659","2268","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3658","2268","_bbp_anonymous_website","http://genericzovirax.tk/#3826");
INSERT INTO `wp_postmeta` VALUES("3657","2268","_bbp_anonymous_email","uslklqji@fmasytlw.com");
INSERT INTO `wp_postmeta` VALUES("3648","2266","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3647","2266","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3640","2265","_bbp_anonymous_website","http://xenical120mg.tk/#1074");
INSERT INTO `wp_postmeta` VALUES("3371","2220","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3366","2219","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3367","2219","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3368","2220","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("3369","2220","_bbp_anonymous_email","zqdxxsup@bphlllgh.com");
INSERT INTO `wp_postmeta` VALUES("3370","2220","_bbp_anonymous_website","http://cheapestlevitra.tk/#3236");
INSERT INTO `wp_postmeta` VALUES("3527","2246","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3528","2246","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3529","2246","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3530","2247","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("3531","2247","_bbp_anonymous_email","nxikuqil@nmcwkrax.com");
INSERT INTO `wp_postmeta` VALUES("3532","2247","_bbp_anonymous_website","http://accutaneonline.tk/#9719");
INSERT INTO `wp_postmeta` VALUES("3533","2247","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3534","2247","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3535","2247","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3536","2248","_bbp_anonymous_name","vardenafil tablets 20 mg");
INSERT INTO `wp_postmeta` VALUES("3537","2248","_bbp_anonymous_email","zwxgpizv@jjzdxhfx.com");
INSERT INTO `wp_postmeta` VALUES("3538","2248","_bbp_anonymous_website","http://vardenafil-hcl.ml/#3021");
INSERT INTO `wp_postmeta` VALUES("3539","2248","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3540","2248","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3541","2248","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3542","2249","_bbp_anonymous_name","0.1 tretinoin cream");
INSERT INTO `wp_postmeta` VALUES("3543","2249","_bbp_anonymous_email","milcscpw@bayhgsvn.com");
INSERT INTO `wp_postmeta` VALUES("3544","2249","_bbp_anonymous_website","http://retinacream005.cf/#2785");
INSERT INTO `wp_postmeta` VALUES("3545","2249","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3546","2249","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3547","2249","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3548","2250","_bbp_anonymous_name","clomd");
INSERT INTO `wp_postmeta` VALUES("3549","2250","_bbp_anonymous_email","oburkvxh@eadhvyhg.com");
INSERT INTO `wp_postmeta` VALUES("2740","2069","_wp_attached_file","2014/05/logo-CMB.bmp");
INSERT INTO `wp_postmeta` VALUES("3601","2258","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3600","2258","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3599","2258","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3598","2258","_bbp_anonymous_website","http://propeciaonline.nu/#4083");
INSERT INTO `wp_postmeta` VALUES("3550","2250","_bbp_anonymous_website","http://buyclomidonlineusa.tk/#6010");
INSERT INTO `wp_postmeta` VALUES("3551","2250","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3552","2250","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3553","2250","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3554","2251","_bbp_anonymous_name","xenical 120 mg");
INSERT INTO `wp_postmeta` VALUES("3555","2251","_bbp_anonymous_email","lzxrgoff@lirveqcj.com");
INSERT INTO `wp_postmeta` VALUES("3556","2251","_bbp_anonymous_website","http://xenical120mg.pw/#6346");
INSERT INTO `wp_postmeta` VALUES("3557","2251","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3558","2251","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3559","2251","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3560","2252","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("3561","2252","_bbp_anonymous_email","citmizfg@yfqcfjms.com");
INSERT INTO `wp_postmeta` VALUES("3562","2252","_bbp_anonymous_website","http://generic-zoloft.pw/#3759");
INSERT INTO `wp_postmeta` VALUES("3563","2252","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3564","2252","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3565","2252","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3566","2253","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("3567","2253","_bbp_anonymous_email","gyogcmhv@quooicpa.com");
INSERT INTO `wp_postmeta` VALUES("3568","2253","_bbp_anonymous_website","http://atomoxetine.tk/#3854");
INSERT INTO `wp_postmeta` VALUES("3569","2253","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3570","2253","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3571","2253","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3572","2254","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("3573","2254","_bbp_anonymous_email","plubsbsd@ybdgxdbf.com");
INSERT INTO `wp_postmeta` VALUES("3574","2254","_bbp_anonymous_website","http://buylevitra.in/#9029");
INSERT INTO `wp_postmeta` VALUES("3575","2254","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3576","2254","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3577","2254","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3578","2255","_bbp_anonymous_name","generic nexium");
INSERT INTO `wp_postmeta` VALUES("3579","2255","_bbp_anonymous_email","gxodppzu@xwwcvfti.com");
INSERT INTO `wp_postmeta` VALUES("3580","2255","_bbp_anonymous_website","http://generic-nexium.pw/#9930");
INSERT INTO `wp_postmeta` VALUES("3581","2255","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3582","2255","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3583","2255","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3584","2256","_bbp_anonymous_name","augmentin");
INSERT INTO `wp_postmeta` VALUES("3585","2256","_bbp_anonymous_email","upemxorx@emynwgxs.com");
INSERT INTO `wp_postmeta` VALUES("3586","2256","_bbp_anonymous_website","http://generic-augmentin.cf/#3199");
INSERT INTO `wp_postmeta` VALUES("3587","2256","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3588","2256","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3589","2256","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3590","2257","_bbp_anonymous_name","more bonuses");
INSERT INTO `wp_postmeta` VALUES("3591","2257","_bbp_anonymous_email","cktnvngw@mvckytyb.com");
INSERT INTO `wp_postmeta` VALUES("3592","2257","_bbp_anonymous_website","http://buyviagrasoft-tabs.ga/#4942");
INSERT INTO `wp_postmeta` VALUES("3593","2257","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3594","2257","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3595","2257","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3596","2258","_bbp_anonymous_name","propecia online");
INSERT INTO `wp_postmeta` VALUES("3597","2258","_bbp_anonymous_email","qtdqahew@bgvsivkq.com");
INSERT INTO `wp_postmeta` VALUES("3007","2161","_bbp_reply_count","15464");
INSERT INTO `wp_postmeta` VALUES("3008","2161","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("3009","2161","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("3010","2162","_bbp_anonymous_name","eacrxrofs");
INSERT INTO `wp_postmeta` VALUES("3011","2162","_bbp_anonymous_email","nightetktk@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("3012","2162","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3013","2162","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3014","2162","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3015","2162","_bbp_author_ip","62.210.82.82");
INSERT INTO `wp_postmeta` VALUES("3016","2162","_oembed_028f9512a9d2b6990f7fd620815da9de","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3017","2162","_oembed_cb0b4b43a85795130b5c31170d5c33c5","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3018","2162","_oembed_ad12a603dc38d09145069ee2901d9911","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3019","2162","_oembed_0dcd9bf27162bb124be54b7d446d5a5d","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3020","2162","_oembed_c83eb83938528717158368a648750e74","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3021","2163","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3022","2163","_bbp_anonymous_email","thelastlooker@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3023","2163","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3024","2163","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3025","2163","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3026","2163","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3027","2164","_bbp_anonymous_name","Cheap Green Bay Packers Jerseys");
INSERT INTO `wp_postmeta` VALUES("3028","2164","_bbp_anonymous_email","didgrxzthbs@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3029","2164","_bbp_anonymous_website","http://www.fdlgroup.co.uk/images/Cheap-Green-Bay-Packers-Jerseys.asp");
INSERT INTO `wp_postmeta` VALUES("3030","2164","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3031","2164","_bbp_topic_id","2164");
INSERT INTO `wp_postmeta` VALUES("3032","2164","_bbp_author_ip","117.26.252.17");
INSERT INTO `wp_postmeta` VALUES("3033","2164","_bbp_last_reply_id","19692");
INSERT INTO `wp_postmeta` VALUES("3034","2164","_bbp_last_active_id","19692");
INSERT INTO `wp_postmeta` VALUES("3035","2164","_bbp_last_active_time","2015-03-30 12:34:22");
INSERT INTO `wp_postmeta` VALUES("3036","2164","_bbp_reply_count","1882");
INSERT INTO `wp_postmeta` VALUES("3037","2164","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("3038","2164","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("3039","2166","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3040","2166","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3041","2166","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3042","2166","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3043","2166","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("3044","2166","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3045","2167","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3046","2167","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3047","2167","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3048","2167","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3049","2167","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3050","2167","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3051","2168","_bbp_anonymous_name","eacruroud");
INSERT INTO `wp_postmeta` VALUES("3052","2168","_bbp_anonymous_email","nightetktk@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("3053","2168","_bbp_anonymous_website","");
INSERT INTO `wp_postmeta` VALUES("3054","2168","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3055","2168","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3056","2168","_bbp_author_ip","62.210.82.82");
INSERT INTO `wp_postmeta` VALUES("3057","2168","_oembed_b7c0fef6cbfb72bb968683fde5e0b848","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3058","2168","_oembed_c43b0d62b83ede06e39691f157682953","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3059","2168","_oembed_133c86495b5c8a9a703386d7c14694e4","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3060","2168","_oembed_713ea9d8519c876c00f02c4b1e7934b1","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3061","2168","_oembed_c9d17265f4d4e3d82a5b2aaf3dc6d6e4","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("3062","2169","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3063","2169","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3064","2169","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3065","2169","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3066","2169","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("3067","2169","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3068","2170","_bbp_anonymous_name","ewpsxigq");
INSERT INTO `wp_postmeta` VALUES("3069","2170","_bbp_anonymous_email","none@none.com");
INSERT INTO `wp_postmeta` VALUES("3070","2170","_bbp_anonymous_website","http://en.wikipedia.org/wiki/Insurance");
INSERT INTO `wp_postmeta` VALUES("3071","2170","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3072","2170","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3073","2170","_bbp_author_ip","94.23.59.169");
INSERT INTO `wp_postmeta` VALUES("3074","2171","_bbp_anonymous_name","nlaeqoxx");
INSERT INTO `wp_postmeta` VALUES("3075","2171","_bbp_anonymous_email","sxdfvh@hforpj.com");
INSERT INTO `wp_postmeta` VALUES("3076","2171","_bbp_anonymous_website","http://hhbdoa.com/");
INSERT INTO `wp_postmeta` VALUES("3077","2171","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3078","2171","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3079","2171","_bbp_author_ip","62.210.91.186");
INSERT INTO `wp_postmeta` VALUES("3080","2172","_bbp_anonymous_name","tlyqzm");
INSERT INTO `wp_postmeta` VALUES("3081","2172","_bbp_anonymous_email","fmcrvg@acpysr.com");
INSERT INTO `wp_postmeta` VALUES("3082","2172","_bbp_anonymous_website","http://ubhrsblcauak.com/");
INSERT INTO `wp_postmeta` VALUES("3083","2172","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3084","2172","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3085","2172","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3086","2173","_bbp_anonymous_name","fqayngf");
INSERT INTO `wp_postmeta` VALUES("3087","2173","_bbp_anonymous_email","liauln@znhxyw.com");
INSERT INTO `wp_postmeta` VALUES("3088","2173","_bbp_anonymous_website","http://ymvybvgthqjc.com/");
INSERT INTO `wp_postmeta` VALUES("3089","2173","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3090","2173","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3091","2173","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3092","2174","_bbp_anonymous_name","lolherzqkbc");
INSERT INTO `wp_postmeta` VALUES("3093","2174","_bbp_anonymous_email","ipivlp@tyqwqv.com");
INSERT INTO `wp_postmeta` VALUES("3094","2174","_bbp_anonymous_website","http://kixosebglfqn.com/");
INSERT INTO `wp_postmeta` VALUES("3095","2174","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3096","2174","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3097","2174","_bbp_author_ip","46.161.41.31");
INSERT INTO `wp_postmeta` VALUES("3098","2175","_bbp_anonymous_name","nolvadex online");
INSERT INTO `wp_postmeta` VALUES("3099","2175","_bbp_anonymous_email","yavhtxuy@vidxcrss.com");
INSERT INTO `wp_postmeta` VALUES("3100","2175","_bbp_anonymous_website","http://buy-nolvadex.info/#9468");
INSERT INTO `wp_postmeta` VALUES("3101","2175","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3102","2175","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3103","2175","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3104","2176","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("3105","2176","_bbp_anonymous_email","hjsksjio@dtyzeuib.com");
INSERT INTO `wp_postmeta` VALUES("3106","2176","_bbp_anonymous_website","http://advair-diskus.cf/#8555");
INSERT INTO `wp_postmeta` VALUES("3107","2176","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3108","2176","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3109","2176","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3110","2177","_bbp_anonymous_name","generic propecia online");
INSERT INTO `wp_postmeta` VALUES("3111","2177","_bbp_anonymous_email","hkhogmzo@qwcqcmhj.com");
INSERT INTO `wp_postmeta` VALUES("3112","2177","_bbp_anonymous_website","http://buypropecia.in/#2693");
INSERT INTO `wp_postmeta` VALUES("3113","2177","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3114","2177","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3115","2177","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3116","2178","_bbp_anonymous_name","buy tretinoin gel");
INSERT INTO `wp_postmeta` VALUES("3117","2178","_bbp_anonymous_email","zavtdlrf@fbfnhbxp.com");
INSERT INTO `wp_postmeta` VALUES("3118","2178","_bbp_anonymous_website","http://tretinoincream.in/#8166");
INSERT INTO `wp_postmeta` VALUES("3119","2178","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3120","2178","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3121","2178","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3122","2179","_bbp_anonymous_name","buy viagra online");
INSERT INTO `wp_postmeta` VALUES("3123","2179","_bbp_anonymous_email","nrlvlvdm@uxzfmeee.com");
INSERT INTO `wp_postmeta` VALUES("3124","2179","_bbp_anonymous_website","http://buyviagraonline.ml/#9858");
INSERT INTO `wp_postmeta` VALUES("3125","2179","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3126","2179","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3127","2179","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3128","2180","_bbp_anonymous_name","hydrochlorothiazide");
INSERT INTO `wp_postmeta` VALUES("3129","2180","_bbp_anonymous_email","flsugobw@ouqlumem.com");
INSERT INTO `wp_postmeta` VALUES("3130","2180","_bbp_anonymous_website","http://hydrochlorothiazide.se/#4730");
INSERT INTO `wp_postmeta` VALUES("3131","2180","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3132","2180","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3133","2180","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3134","2181","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("3135","2181","_bbp_anonymous_email","jmtunfna@xvfthwel.com");
INSERT INTO `wp_postmeta` VALUES("3136","2181","_bbp_anonymous_website","http://genericaccutane.in/#8108");
INSERT INTO `wp_postmeta` VALUES("3137","2181","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3138","2181","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3139","2181","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3140","2182","_bbp_anonymous_name","cheap generic valtrex without prescription");
INSERT INTO `wp_postmeta` VALUES("3141","2182","_bbp_anonymous_email","qxcbmflz@tahajuax.com");
INSERT INTO `wp_postmeta` VALUES("3142","2182","_bbp_anonymous_website","http://valtrex.in/cheap-generic-valtrex-without-prescription.html#7763");
INSERT INTO `wp_postmeta` VALUES("3143","2182","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3470","2237","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("3471","2237","_bbp_anonymous_email","jvcjjjmz@vifkvukj.com");
INSERT INTO `wp_postmeta` VALUES("3472","2237","_bbp_anonymous_website","http://allipill.cf/#9773");
INSERT INTO `wp_postmeta` VALUES("3473","2237","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3474","2237","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3475","2237","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3476","2238","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("3477","2238","_bbp_anonymous_email","ocicduto@rznwzwoc.com");
INSERT INTO `wp_postmeta` VALUES("3478","2238","_bbp_anonymous_website","http://zithromaxstrepthroat.tk/#5413");
INSERT INTO `wp_postmeta` VALUES("3526","2246","_bbp_anonymous_website","http://genericcelebrex.biz/#3611");
INSERT INTO `wp_postmeta` VALUES("3479","2238","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3480","2238","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3481","2238","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3482","2239","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("3483","2239","_bbp_anonymous_email","zuppaapp@hcirumqc.com");
INSERT INTO `wp_postmeta` VALUES("3484","2239","_bbp_anonymous_website","http://vardenafilhydrochloride.ml/#1202");
INSERT INTO `wp_postmeta` VALUES("3485","2239","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3486","2239","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3487","2239","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3488","2240","_bbp_anonymous_name","more bonuses");
INSERT INTO `wp_postmeta` VALUES("3489","2240","_bbp_anonymous_email","mmhaydbr@egdmxjvv.com");
INSERT INTO `wp_postmeta` VALUES("3490","2240","_bbp_anonymous_website","http://buyfinasteride.tk/#1348");
INSERT INTO `wp_postmeta` VALUES("3491","2240","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3492","2240","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3493","2240","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3494","2241","_bbp_anonymous_name","full article");
INSERT INTO `wp_postmeta` VALUES("3495","2241","_bbp_anonymous_email","otdolxph@kitsjhdu.com");
INSERT INTO `wp_postmeta` VALUES("3496","2241","_bbp_anonymous_website","http://cialiscom.tk/#2477");
INSERT INTO `wp_postmeta` VALUES("3497","2241","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3498","2241","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3499","2241","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3500","2242","_bbp_anonymous_name","abilify");
INSERT INTO `wp_postmeta` VALUES("3501","2242","_bbp_anonymous_email","imilyzhk@ilnxbquw.com");
INSERT INTO `wp_postmeta` VALUES("3502","2242","_bbp_anonymous_website","http://abilify.in/#5454");
INSERT INTO `wp_postmeta` VALUES("3503","2242","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3504","2242","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3505","2242","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3506","2243","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("3507","2243","_bbp_anonymous_email","pxihkgmu@jyviycpw.com");
INSERT INTO `wp_postmeta` VALUES("3508","2243","_bbp_anonymous_website","http://ventolin-hfa.cf/#9459");
INSERT INTO `wp_postmeta` VALUES("3509","2243","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3510","2243","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3511","2243","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3512","2244","_bbp_anonymous_name","generic abilify");
INSERT INTO `wp_postmeta` VALUES("3513","2244","_bbp_anonymous_email","nabyyjte@vaqozled.com");
INSERT INTO `wp_postmeta` VALUES("3514","2244","_bbp_anonymous_website","http://genericabilify.nu/#1870");
INSERT INTO `wp_postmeta` VALUES("3515","2244","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3516","2244","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3517","2244","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3518","2245","_bbp_anonymous_name","lavetra");
INSERT INTO `wp_postmeta` VALUES("3519","2245","_bbp_anonymous_email","sgfsvqkf@dfqfhhta.com");
INSERT INTO `wp_postmeta` VALUES("3520","2245","_bbp_anonymous_website","http://levetra.cf/#4946");
INSERT INTO `wp_postmeta` VALUES("3521","2245","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3522","2245","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3523","2245","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3524","2246","_bbp_anonymous_name","generic celebrex");
INSERT INTO `wp_postmeta` VALUES("3525","2246","_bbp_anonymous_email","fwsmmgtr@pwlskoqh.com");
INSERT INTO `wp_postmeta` VALUES("3399","2225","_bbp_anonymous_email","yihfdnll@llojdzcw.com");
INSERT INTO `wp_postmeta` VALUES("3398","2225","_bbp_anonymous_name","zoloft 50mg");
INSERT INTO `wp_postmeta` VALUES("3397","2224","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3396","2224","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3395","2224","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3389","2223","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3390","2223","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3391","2223","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3392","2224","_bbp_anonymous_name","tadalafil 5 mg");
INSERT INTO `wp_postmeta` VALUES("3393","2224","_bbp_anonymous_email","zeiwtycs@sdpwgoob.com");
INSERT INTO `wp_postmeta` VALUES("3394","2224","_bbp_anonymous_website","http://onlinetadalafil.tk/#6712");
INSERT INTO `wp_postmeta` VALUES("3634","2264","_bbp_anonymous_website","http://vermox-500.tk/#6998");
INSERT INTO `wp_postmeta` VALUES("3633","2264","_bbp_anonymous_email","hierdfxa@vjdqxoow.com");
INSERT INTO `wp_postmeta` VALUES("3632","2264","_bbp_anonymous_name","vermox");
INSERT INTO `wp_postmeta` VALUES("3620","2262","_bbp_anonymous_name","augmentin oral");
INSERT INTO `wp_postmeta` VALUES("3621","2262","_bbp_anonymous_email","elxlwsge@kqujlnci.com");
INSERT INTO `wp_postmeta` VALUES("3622","2262","_bbp_anonymous_website","http://augmentin500.tk/#4015");
INSERT INTO `wp_postmeta` VALUES("3623","2262","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3624","2262","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3625","2262","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3626","2263","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("3627","2263","_bbp_anonymous_email","dmpmtjhy@tcjauwtt.com");
INSERT INTO `wp_postmeta` VALUES("3628","2263","_bbp_anonymous_website","http://howmuchispropecia.ml/#1222");
INSERT INTO `wp_postmeta` VALUES("3629","2263","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3630","2263","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3631","2263","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3256","2201","_bbp_anonymous_website","http://clomid.in/#6348");
INSERT INTO `wp_postmeta` VALUES("3255","2201","_bbp_anonymous_email","awwabrar@wsnlvdbc.com");
INSERT INTO `wp_postmeta` VALUES("3254","2201","_bbp_anonymous_name","clomid");
INSERT INTO `wp_postmeta` VALUES("3253","2200","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3252","2200","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3251","2200","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3273","2204","_bbp_anonymous_email","xmlexypl@abqjuisi.com");
INSERT INTO `wp_postmeta` VALUES("3272","2204","_bbp_anonymous_name","generic propecia online");
INSERT INTO `wp_postmeta` VALUES("3271","2203","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3270","2203","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3269","2203","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3257","2201","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3258","2201","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3259","2201","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3260","2202","_bbp_anonymous_name","buy generic propecia");
INSERT INTO `wp_postmeta` VALUES("3261","2202","_bbp_anonymous_email","phduhutr@opnvefgx.com");
INSERT INTO `wp_postmeta` VALUES("3262","2202","_bbp_anonymous_website","http://buypropecia.in/#6616");
INSERT INTO `wp_postmeta` VALUES("3263","2202","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3264","2202","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3265","2202","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3266","2203","_bbp_anonymous_name","chewable viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3267","2203","_bbp_anonymous_email","kuxqqumy@pmgmpqtr.com");
INSERT INTO `wp_postmeta` VALUES("3268","2203","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#1068");
INSERT INTO `wp_postmeta` VALUES("2443","2013","_wp_attached_file","2013/04/S.Daycard-Heid-12.jpg");
INSERT INTO `wp_postmeta` VALUES("2444","2013","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:680;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-12.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-705x572.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:572;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x365.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:365;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3427","2229","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3426","2229","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3425","2229","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3424","2229","_bbp_anonymous_website","http://buyretinaonline.cf/#1383");
INSERT INTO `wp_postmeta` VALUES("3423","2229","_bbp_anonymous_email","jzchfuqa@uvizdnmp.com");
INSERT INTO `wp_postmeta` VALUES("3422","2229","_bbp_anonymous_name","buying retin-a online");
INSERT INTO `wp_postmeta` VALUES("3421","2228","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3420","2228","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3419","2228","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3183","2189","_bbp_anonymous_email","rrkvkcxs@jhiwiyys.com");
INSERT INTO `wp_postmeta` VALUES("3182","2189","_bbp_anonymous_name","generic for advair diskus");
INSERT INTO `wp_postmeta` VALUES("3181","2188","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3180","2188","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3179","2188","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3165","2186","_bbp_anonymous_email","tvaajnkg@pucocrpq.com");
INSERT INTO `wp_postmeta` VALUES("3166","2186","_bbp_anonymous_website","http://allipills.tk/generic-alli.html#4436");
INSERT INTO `wp_postmeta` VALUES("3167","2186","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3168","2186","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3169","2186","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3170","2187","_bbp_anonymous_name","advair 250/50");
INSERT INTO `wp_postmeta` VALUES("3171","2187","_bbp_anonymous_email","vxlocpjj@phkpygcw.com");
INSERT INTO `wp_postmeta` VALUES("3172","2187","_bbp_anonymous_website","http://advair-diskus.cf/price-of-advair.html#3599");
INSERT INTO `wp_postmeta` VALUES("3173","2187","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3174","2187","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3175","2187","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3176","2188","_bbp_anonymous_name","tretinoin cream generic");
INSERT INTO `wp_postmeta` VALUES("3177","2188","_bbp_anonymous_email","tejayktl@huzoqnoi.com");
INSERT INTO `wp_postmeta` VALUES("3178","2188","_bbp_anonymous_website","http://tretinoin-cream.ga/tretinoin-cream-usp-0-025.html#1903");
INSERT INTO `wp_postmeta` VALUES("3447","2233","_bbp_anonymous_email","thdxxtze@zxjicmfv.com");
INSERT INTO `wp_postmeta` VALUES("3431","2230","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3430","2230","_bbp_anonymous_website","http://buy-viagra-soft-tabs.pw/#1515");
INSERT INTO `wp_postmeta` VALUES("3429","2230","_bbp_anonymous_email","ekhluqom@rxuqgmzc.com");
INSERT INTO `wp_postmeta` VALUES("3428","2230","_bbp_anonymous_name","cheapest viagra prices");
INSERT INTO `wp_postmeta` VALUES("3467","2236","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3468","2236","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3469","2236","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3466","2236","_bbp_anonymous_website","http://cheapclomidwithoutprescription.ga/#4460");
INSERT INTO `wp_postmeta` VALUES("3462","2235","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3463","2235","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3464","2236","_bbp_anonymous_name","clomid");
INSERT INTO `wp_postmeta` VALUES("3465","2236","_bbp_anonymous_email","zkywoioq@jqvcmrbt.com");
INSERT INTO `wp_postmeta` VALUES("3459","2235","_bbp_anonymous_email","lvinpzyf@moaetfrh.com");
INSERT INTO `wp_postmeta` VALUES("3458","2235","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3457","2234","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3456","2234","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3455","2234","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3448","2233","_bbp_anonymous_website","http://buytretinoincream.se/#7865");
INSERT INTO `wp_postmeta` VALUES("3449","2233","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3450","2233","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3451","2233","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3452","2234","_bbp_anonymous_name","atenolol");
INSERT INTO `wp_postmeta` VALUES("3453","2234","_bbp_anonymous_email","xrzafmmp@fslguzau.com");
INSERT INTO `wp_postmeta` VALUES("3454","2234","_bbp_anonymous_website","http://atenolol.ml/#2289");
INSERT INTO `wp_postmeta` VALUES("3605","2259","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3604","2259","_bbp_anonymous_website","http://lexapro5mg.cf/#5658");
INSERT INTO `wp_postmeta` VALUES("3603","2259","_bbp_anonymous_email","pqmpxyuc@ovbaglkv.com");
INSERT INTO `wp_postmeta` VALUES("3602","2259","_bbp_anonymous_name","generic for lexapro");
INSERT INTO `wp_postmeta` VALUES("3153","2184","_bbp_anonymous_email","ydzlonzq@xxftqhyo.com");
INSERT INTO `wp_postmeta` VALUES("3152","2184","_bbp_anonymous_name","cheap viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3151","2183","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3150","2183","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3149","2183","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3146","2183","_bbp_anonymous_name","clomid for men");
INSERT INTO `wp_postmeta` VALUES("3147","2183","_bbp_anonymous_email","mczullqu@hbjrxsrp.com");
INSERT INTO `wp_postmeta` VALUES("3148","2183","_bbp_anonymous_website","http://clomid.in/cheap-clomid-without-prescription.html#2787");
INSERT INTO `wp_postmeta` VALUES("3461","2235","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3460","2235","_bbp_anonymous_website","http://cialis.tk/#5244");
INSERT INTO `wp_postmeta` VALUES("2958","2156","_bbp_last_active_time","2014-12-14 10:26:45");
INSERT INTO `wp_postmeta` VALUES("2956","2156","_bbp_last_reply_id","2169");
INSERT INTO `wp_postmeta` VALUES("2957","2156","_bbp_last_active_id","2169");
INSERT INTO `wp_postmeta` VALUES("2955","2156","_bbp_author_ip","120.37.238.71");
INSERT INTO `wp_postmeta` VALUES("2954","2156","_bbp_topic_id","2156");
INSERT INTO `wp_postmeta` VALUES("2953","2156","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2950","2156","_bbp_anonymous_name","Wholesale NFL Jerseys");
INSERT INTO `wp_postmeta` VALUES("2951","2156","_bbp_anonymous_email","rbbyrpq@gmail.com");
INSERT INTO `wp_postmeta` VALUES("2952","2156","_bbp_anonymous_website","http://www.abcindustrial.co.uk/News/nflcheapstore.asp");
INSERT INTO `wp_postmeta` VALUES("3672","2270","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3671","2270","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3646","2266","_bbp_anonymous_website","http://cialis-price.tk/#5192");
INSERT INTO `wp_postmeta` VALUES("3645","2266","_bbp_anonymous_email","lmzvadir@dmlsczzn.com");
INSERT INTO `wp_postmeta` VALUES("3644","2266","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("3643","2265","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3642","2265","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3641","2265","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2549","2034","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:87;s:4:\"file\";s:27:\"2014/05/logos-allier-01.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-180x87.png\";s:5:\"width\";i:180;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-120x87.png\";s:5:\"width\";i:120;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2550","2037","_wp_attached_file","2014/05/Allier_le_Departement_bleu.png");
INSERT INTO `wp_postmeta` VALUES("2551","2037","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1687;s:6:\"height\";i:480;s:4:\"file\";s:38:\"2014/05/Allier_le_Departement_bleu.png\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Allier_le_Departement_bleu-300x85.png\";s:5:\"width\";i:300;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x293.png\";s:5:\"width\";i:1030;s:6:\"height\";i:293;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x430.png\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x426.png\";s:5:\"width\";i:1500;s:6:\"height\";i:426;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x480.png\";s:5:\"width\";i:710;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-705x200.png\";s:5:\"width\";i:705;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x128.png\";s:5:\"width\";i:450;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2352","1978","_wp_attached_file","2014/05/g.le_roux.jpg");
INSERT INTO `wp_postmeta` VALUES("3232","2197","_bbp_anonymous_website","http://generictadalafil.se/#5584");
INSERT INTO `wp_postmeta` VALUES("3221","2195","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3220","2195","_bbp_anonymous_website","http://buyviagraonline.ml/super-active-viagra.html#5100");
INSERT INTO `wp_postmeta` VALUES("3219","2195","_bbp_anonymous_email","rfpceaeg@vgkfsxwr.com");
INSERT INTO `wp_postmeta` VALUES("3218","2195","_bbp_anonymous_name","super active viagra");
INSERT INTO `wp_postmeta` VALUES("3217","2194","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3216","2194","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3215","2194","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3214","2194","_bbp_anonymous_website","http://buycelebrex.biz/buy-celebrex-without-prescription.html#3262");
INSERT INTO `wp_postmeta` VALUES("2278","1963","_wp_attached_file","2014/05/cistude_romain_riols.jpg");
INSERT INTO `wp_postmeta` VALUES("2279","1963","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:4:\"file\";s:32:\"2014/05/cistude_romain_riols.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:34:\"cistude_romain_riols-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3231","2197","_bbp_anonymous_email","scufoyvp@zupurulk.com");
INSERT INTO `wp_postmeta` VALUES("3230","2197","_bbp_anonymous_name","tadalafil cheap");
INSERT INTO `wp_postmeta` VALUES("3229","2196","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3228","2196","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3227","2196","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3226","2196","_bbp_anonymous_website","http://buy-levitra.ml/#9300");
INSERT INTO `wp_postmeta` VALUES("3225","2196","_bbp_anonymous_email","dnftaoxl@mwqhlvcj.com");
INSERT INTO `wp_postmeta` VALUES("3224","2196","_bbp_anonymous_name","buy levitra");
INSERT INTO `wp_postmeta` VALUES("3223","2195","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3222","2195","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3213","2194","_bbp_anonymous_email","gvaggsvg@kvvkeujz.com");
INSERT INTO `wp_postmeta` VALUES("3212","2194","_bbp_anonymous_name","buy celebrex without prescription");
INSERT INTO `wp_postmeta` VALUES("3211","2193","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3210","2193","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3209","2193","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3197","2191","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3198","2191","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3199","2191","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3200","2192","_bbp_anonymous_name","finasteride without prescription");
INSERT INTO `wp_postmeta` VALUES("3201","2192","_bbp_anonymous_email","hbtkujyc@jphjqule.com");
INSERT INTO `wp_postmeta` VALUES("3202","2192","_bbp_anonymous_website","http://genericpropecia.nu/generic-propecia-canada.html#8427");
INSERT INTO `wp_postmeta` VALUES("3203","2192","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3204","2192","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3205","2192","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3206","2193","_bbp_anonymous_name","levitra 40 mg pay with mastercard");
INSERT INTO `wp_postmeta` VALUES("3207","2193","_bbp_anonymous_email","goyoumfx@pijbtuis.com");
INSERT INTO `wp_postmeta` VALUES("3208","2193","_bbp_anonymous_website","http://buy-levitra.ml/how-much-is-levitra.html#8866");
INSERT INTO `wp_postmeta` VALUES("3246","2199","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3245","2199","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3244","2199","_bbp_anonymous_website","http://allipills.tk/#9518");
INSERT INTO `wp_postmeta` VALUES("3233","2197","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3234","2197","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3235","2197","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3236","2198","_bbp_anonymous_name","buy propecia");
INSERT INTO `wp_postmeta` VALUES("3237","2198","_bbp_anonymous_email","ybzvoawe@hcqdtizg.com");
INSERT INTO `wp_postmeta` VALUES("3238","2198","_bbp_anonymous_website","http://genericpropecia.nu/#8193");
INSERT INTO `wp_postmeta` VALUES("3239","2198","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3240","2198","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3241","2198","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3242","2199","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("3243","2199","_bbp_anonymous_email","nhnwnlau@xhnzifdr.com");
INSERT INTO `wp_postmeta` VALUES("3247","2199","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3248","2200","_bbp_anonymous_name","price of valtrex");
INSERT INTO `wp_postmeta` VALUES("3249","2200","_bbp_anonymous_email","lfjwmuhu@yzkbktru.com");
INSERT INTO `wp_postmeta` VALUES("3250","2200","_bbp_anonymous_website","http://valtrex.in/#4716");
INSERT INTO `wp_postmeta` VALUES("3382","2222","_bbp_anonymous_website","http://discountcialisonline.cf/#4087");
INSERT INTO `wp_postmeta` VALUES("3381","2222","_bbp_anonymous_email","emnntdmo@dyvhskmz.com");
INSERT INTO `wp_postmeta` VALUES("3380","2222","_bbp_anonymous_name","cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("3379","2221","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3378","2221","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3377","2221","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3372","2220","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3373","2220","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3374","2221","_bbp_anonymous_name","generic accutane");
INSERT INTO `wp_postmeta` VALUES("3375","2221","_bbp_anonymous_email","qcanrsey@fkdxiovi.com");
INSERT INTO `wp_postmeta` VALUES("3376","2221","_bbp_anonymous_website","http://genericaccutane.biz/#7963");
INSERT INTO `wp_postmeta` VALUES("3388","2223","_bbp_anonymous_website","http://buy-viagra-softtabs.cf/#9416");
INSERT INTO `wp_postmeta` VALUES("3387","2223","_bbp_anonymous_email","lomxfflz@sjjeetmj.com");
INSERT INTO `wp_postmeta` VALUES("3386","2223","_bbp_anonymous_name","best price viagra");
INSERT INTO `wp_postmeta` VALUES("3385","2222","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3384","2222","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3383","2222","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2353","1978","_wp_attachment_metadata","a:5:{s:5:\"width\";i:4592;s:6:\"height\";i:2576;s:4:\"file\";s:21:\"2014/05/g.le_roux.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"g.le_roux-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"g.le_roux-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x577.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:577;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"g.le_roux-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"g.le_roux-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x841.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:841;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"g.le_roux-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"g.le_roux-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"g.le_roux-705x395.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"g.le_roux-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x252.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DSLR-A290\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1344353630;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"300\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:9:\"0.0015625\";s:5:\"title\";s:8:\"SONY DSC\";}}");
INSERT INTO `wp_postmeta` VALUES("2354","1979","_wp_attached_file","2014/05/riols_romain_milan_noir.jpg");
INSERT INTO `wp_postmeta` VALUES("2355","1979","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:35:\"2014/05/riols_romain_milan_noir.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:37:\"riols_romain_milan_noir-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:3.7000000000000002;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:29:\"Konica Digital Camera KD-310Z\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1049047227;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"14.2\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0156\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2356","1980","_wp_attached_file","2014/05/val_dallier_jean_jacques_lallemant.jpg");
INSERT INTO `wp_postmeta` VALUES("2357","1980","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2362;s:6:\"height\";i:1586;s:4:\"file\";s:46:\"2014/05/val_dallier_jean_jacques_lallemant.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x691.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:48:\"val_dallier_jean_jacques_lallemant-1500x1007.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1007;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-705x473.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x302.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:302;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2360","1986","_wp_attached_file","2014/05/HUNTER-20131.jpg");
INSERT INTO `wp_postmeta` VALUES("2361","1986","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1295;s:4:\"file\";s:24:\"2014/05/HUNTER-20131.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-795x1030.jpg\";s:5:\"width\";i:795;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2362","1987","_wp_attached_file","2014/05/HUNTER-20132.jpg");
INSERT INTO `wp_postmeta` VALUES("2363","1987","_wp_attachment_metadata","a:5:{s:5:\"width\";i:667;s:6:\"height\";i:864;s:4:\"file\";s:24:\"2014/05/HUNTER-20132.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x430.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x575.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x270.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x360.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2364","1988","_wp_attached_file","2014/05/HUNTER-20133.jpg");
INSERT INTO `wp_postmeta` VALUES("2365","1988","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2014/05/HUNTER-20133.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-205x300.jpg\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x575.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x655.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:655;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2366","1989","_wp_attached_file","2014/05/HUNTER-20134.jpg");
INSERT INTO `wp_postmeta` VALUES("2367","1989","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:473;s:4:\"file\";s:24:\"2014/05/HUNTER-20134.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-290x300.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x464.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:464;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2368","1990","_wp_attached_file","2014/05/HUNTER-2013-original.jpg");
INSERT INTO `wp_postmeta` VALUES("2369","1990","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:576;s:4:\"file\";s:32:\"2014/05/HUNTER-2013-original.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-300x221.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-705x519.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x331.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("307","44","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("308","44","_avia_elements_avia_options_propulsion","s:1046:\"a:6:{s:4:\"hero\";s:3:\"yes\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `wp_postmeta` VALUES("309","44","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("310","44","_avia_elements_avia_options_coherence","s:1436:\"a:13:{s:8:\"subtitle\";s:45:\"Donec pede justo, fringilla vel, aliquet nec!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:10:\"Flashlight\";s:16:\"portfolio-meta-3\";s:91:\"&lt;a href=&quot;http://www.kriesi.at/themes/flashlight/&quot;&gt;Flashlight Demo&lt;/a&gt;\";}\";");
INSERT INTO `wp_postmeta` VALUES("1139","44","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("312","44","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("313","44","_facebookcount-cache","0");
INSERT INTO `wp_postmeta` VALUES("314","44","_twittercount-cache","0");
INSERT INTO `wp_postmeta` VALUES("315","44","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("316","44","_aviaLayoutBuilderCleanData","[av_two_third first]

[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1490,1491,1492,1493,1494,1496,1497,1498,1499,1500\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']

[/av_two_third][av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1142","44","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1143","44","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1144","44","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1145","44","_preview_columns","8");
INSERT INTO `wp_postmeta` VALUES("1146","44","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1147","44","footer","");
INSERT INTO `wp_postmeta` VALUES("317","44","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1140","44","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1141","44","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("318","44","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("319","44","sidebar","");
INSERT INTO `wp_postmeta` VALUES("320","44","header","yes");
INSERT INTO `wp_postmeta` VALUES("6158","2685","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6159","2685","_bbp_anonymous_email","ykodecrf@apfvrqbm.com");
INSERT INTO `wp_postmeta` VALUES("6160","2685","_bbp_anonymous_website","http://propeciahairgrowth.tk/#7284");
INSERT INTO `wp_postmeta` VALUES("6161","2685","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6162","2685","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6163","2685","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6164","2686","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6165","2686","_bbp_anonymous_email","keqbfgvs@etkhoxuf.com");
INSERT INTO `wp_postmeta` VALUES("6166","2686","_bbp_anonymous_website","http://generic-sildenafil-citrate.ga/#6195");
INSERT INTO `wp_postmeta` VALUES("6167","2686","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6168","2686","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6169","2686","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6170","2687","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("6171","2687","_bbp_anonymous_email","riwisdht@avoetgvs.com");
INSERT INTO `wp_postmeta` VALUES("6172","2687","_bbp_anonymous_website","http://buy-tadalafil-online.cf/#3176");
INSERT INTO `wp_postmeta` VALUES("6173","2687","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6174","2687","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6142","2682","_bbp_anonymous_website","http://valtrex-500mg.ml/#3256");
INSERT INTO `wp_postmeta` VALUES("6143","2682","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6144","2682","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6145","2682","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6146","2683","_bbp_anonymous_name","generic vardenafil");
INSERT INTO `wp_postmeta` VALUES("6147","2683","_bbp_anonymous_email","yavuhoop@ehtmrynw.com");
INSERT INTO `wp_postmeta` VALUES("6148","2683","_bbp_anonymous_website","http://generic-vardenafil.tk/#7185");
INSERT INTO `wp_postmeta` VALUES("6149","2683","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6150","2683","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6151","2683","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6152","2684","_bbp_anonymous_name","alli pill");
INSERT INTO `wp_postmeta` VALUES("6153","2684","_bbp_anonymous_email","czfhixjr@axhtgneh.com");
INSERT INTO `wp_postmeta` VALUES("6154","2684","_bbp_anonymous_website","http://allipill.ml/#4767");
INSERT INTO `wp_postmeta` VALUES("6155","2684","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6156","2684","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6157","2684","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6125","2679","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6126","2679","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6127","2679","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6128","2680","_bbp_anonymous_name","bupropion hcl xl 300 mg");
INSERT INTO `wp_postmeta` VALUES("6129","2680","_bbp_anonymous_email","jusvyxyf@icqllihs.com");
INSERT INTO `wp_postmeta` VALUES("6130","2680","_bbp_anonymous_website","http://bupropionxl300.cf/#4519");
INSERT INTO `wp_postmeta` VALUES("6131","2680","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6132","2680","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6133","2680","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6134","2681","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6135","2681","_bbp_anonymous_email","cuodemja@ofbhzedg.com");
INSERT INTO `wp_postmeta` VALUES("6136","2681","_bbp_anonymous_website","http://buycialisonline.ml/#4659");
INSERT INTO `wp_postmeta` VALUES("6137","2681","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6138","2681","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6139","2681","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6140","2682","_bbp_anonymous_name","valtrex 500mg");
INSERT INTO `wp_postmeta` VALUES("6141","2682","_bbp_anonymous_email","gifilxlp@coywygmd.com");
INSERT INTO `wp_postmeta` VALUES("6124","2679","_bbp_anonymous_website","http://furosemide40mgdiuretic.pw/#4573");
INSERT INTO `wp_postmeta` VALUES("6105","2676","_bbp_anonymous_email","igflsihc@vdguhdzy.com");
INSERT INTO `wp_postmeta` VALUES("6106","2676","_bbp_anonymous_website","http://buy-propecia.cf/#1678");
INSERT INTO `wp_postmeta` VALUES("6107","2676","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6108","2676","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6109","2676","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6110","2677","_bbp_anonymous_name","advair diskus 250/50");
INSERT INTO `wp_postmeta` VALUES("6111","2677","_bbp_anonymous_email","ixppfrtf@rmcgqfiq.com");
INSERT INTO `wp_postmeta` VALUES("6112","2677","_bbp_anonymous_website","http://advair-diskus.ml/#8624");
INSERT INTO `wp_postmeta` VALUES("6113","2677","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6114","2677","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6115","2677","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6116","2678","_bbp_anonymous_name","levitra prices");
INSERT INTO `wp_postmeta` VALUES("6117","2678","_bbp_anonymous_email","roryrdoa@pjccewgk.com");
INSERT INTO `wp_postmeta` VALUES("6118","2678","_bbp_anonymous_website","http://levitracoupons.ga/#3625");
INSERT INTO `wp_postmeta` VALUES("6119","2678","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6120","2678","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6121","2678","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6122","2679","_bbp_anonymous_name","buy furesimide");
INSERT INTO `wp_postmeta` VALUES("6123","2679","_bbp_anonymous_email","opmkerzg@nfbwlyqb.com");
INSERT INTO `wp_postmeta` VALUES("6104","2676","_bbp_anonymous_name","continue reading");
INSERT INTO `wp_postmeta` VALUES("6086","2673","_bbp_anonymous_name","more helpful hints");
INSERT INTO `wp_postmeta` VALUES("6087","2673","_bbp_anonymous_email","nwuowwki@jkjfvwku.com");
INSERT INTO `wp_postmeta` VALUES("6088","2673","_bbp_anonymous_website","http://genericzithromax.se/#8334");
INSERT INTO `wp_postmeta` VALUES("6089","2673","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6090","2673","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6091","2673","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6092","2674","_bbp_anonymous_name","get more information");
INSERT INTO `wp_postmeta` VALUES("6093","2674","_bbp_anonymous_email","vcqrtwjo@hmjicbbx.com");
INSERT INTO `wp_postmeta` VALUES("6094","2674","_bbp_anonymous_website","http://levitracheap.cf/#8016");
INSERT INTO `wp_postmeta` VALUES("6095","2674","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6096","2674","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6097","2674","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6098","2675","_bbp_anonymous_name","generic prozac cost");
INSERT INTO `wp_postmeta` VALUES("6099","2675","_bbp_anonymous_email","lcvxahau@nfyycihc.com");
INSERT INTO `wp_postmeta` VALUES("6100","2675","_bbp_anonymous_website","http://generic-prozac.cf/#4635");
INSERT INTO `wp_postmeta` VALUES("6101","2675","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6102","2675","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6103","2675","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6085","2672","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6084","2672","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6045","2666","_bbp_anonymous_email","hoaxedfw@zvouvxgo.com");
INSERT INTO `wp_postmeta` VALUES("6046","2666","_bbp_anonymous_website","http://buymobic.se/#9996");
INSERT INTO `wp_postmeta` VALUES("6047","2666","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6048","2666","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6049","2666","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6050","2667","_bbp_anonymous_name","celebrex buy");
INSERT INTO `wp_postmeta` VALUES("6051","2667","_bbp_anonymous_email","dsqdqzxj@qyfntibt.com");
INSERT INTO `wp_postmeta` VALUES("6052","2667","_bbp_anonymous_website","http://buycelebrex.se/#8968");
INSERT INTO `wp_postmeta` VALUES("6053","2667","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6054","2667","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6055","2667","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6056","2668","_bbp_anonymous_name","clindamycin topical gel");
INSERT INTO `wp_postmeta` VALUES("6057","2668","_bbp_anonymous_email","selebhpk@zownkikf.com");
INSERT INTO `wp_postmeta` VALUES("6058","2668","_bbp_anonymous_website","http://cleocint.tk/#9271");
INSERT INTO `wp_postmeta` VALUES("6059","2668","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6060","2668","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6061","2668","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6062","2669","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6063","2669","_bbp_anonymous_email","kssreyxd@gbpwafcx.com");
INSERT INTO `wp_postmeta` VALUES("6064","2669","_bbp_anonymous_website","http://discountcialis.tk/#1050");
INSERT INTO `wp_postmeta` VALUES("6065","2669","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6066","2669","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6067","2669","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6068","2670","_bbp_anonymous_name","effexor xr 150mg");
INSERT INTO `wp_postmeta` VALUES("6069","2670","_bbp_anonymous_email","slxneiia@vwkrgmln.com");
INSERT INTO `wp_postmeta` VALUES("6070","2670","_bbp_anonymous_website","http://effexorxr150mg.pw/#9497");
INSERT INTO `wp_postmeta` VALUES("6071","2670","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6072","2670","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6073","2670","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6074","2671","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("6075","2671","_bbp_anonymous_email","zdmivklu@mskmzubj.com");
INSERT INTO `wp_postmeta` VALUES("6076","2671","_bbp_anonymous_website","http://zoloftgeneric.ml/#6748");
INSERT INTO `wp_postmeta` VALUES("6077","2671","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6078","2671","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6079","2671","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6080","2672","_bbp_anonymous_name","generic for effexor");
INSERT INTO `wp_postmeta` VALUES("6081","2672","_bbp_anonymous_email","dnhrrdrr@gawwwcwo.com");
INSERT INTO `wp_postmeta` VALUES("6082","2672","_bbp_anonymous_website","http://genericforeffexor.cf/#3088");
INSERT INTO `wp_postmeta` VALUES("6083","2672","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6028","2663","_bbp_anonymous_website","http://cheapprednisoneonline.tk/#7503");
INSERT INTO `wp_postmeta` VALUES("6029","2663","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6030","2663","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6031","2663","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6032","2664","_bbp_anonymous_name","augmentin generic");
INSERT INTO `wp_postmeta` VALUES("6033","2664","_bbp_anonymous_email","uncyhqet@iehatjkz.com");
INSERT INTO `wp_postmeta` VALUES("6034","2664","_bbp_anonymous_website","http://genericforaugmentin.pw/#7137");
INSERT INTO `wp_postmeta` VALUES("6035","2664","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6036","2664","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6037","2664","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6038","2665","_bbp_anonymous_name","viagra online sales");
INSERT INTO `wp_postmeta` VALUES("6039","2665","_bbp_anonymous_email","adgosgrs@nvvuudwk.com");
INSERT INTO `wp_postmeta` VALUES("6040","2665","_bbp_anonymous_website","http://viagraonlinesales.pw/#7854");
INSERT INTO `wp_postmeta` VALUES("6041","2665","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6042","2665","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6043","2665","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6044","2666","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6027","2663","_bbp_anonymous_email","iweodigk@yxzmnqnu.com");
INSERT INTO `wp_postmeta` VALUES("5122","2512","_bbp_anonymous_website","http://viagrabuyonline.ga/#1219");
INSERT INTO `wp_postmeta` VALUES("5098","2508","_bbp_anonymous_website","http://allipill.ml/#5325");
INSERT INTO `wp_postmeta` VALUES("5099","2508","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5100","2508","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5101","2508","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5102","2509","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5103","2509","_bbp_anonymous_email","gvkiiqsy@ejofketw.com");
INSERT INTO `wp_postmeta` VALUES("5104","2509","_bbp_anonymous_website","http://buy-cialis.se/#4890");
INSERT INTO `wp_postmeta` VALUES("5105","2509","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5106","2509","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5107","2509","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5108","2510","_bbp_anonymous_name","generic prozac");
INSERT INTO `wp_postmeta` VALUES("5109","2510","_bbp_anonymous_email","insjueuj@blplgkhx.com");
INSERT INTO `wp_postmeta` VALUES("5110","2510","_bbp_anonymous_website","http://generic-prozac.pw/#8140");
INSERT INTO `wp_postmeta` VALUES("5111","2510","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5112","2510","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5113","2510","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5114","2511","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5115","2511","_bbp_anonymous_email","enkbrmnh@ejmsxuno.com");
INSERT INTO `wp_postmeta` VALUES("5116","2511","_bbp_anonymous_website","http://propeciahairloss.cf/#1822");
INSERT INTO `wp_postmeta` VALUES("5117","2511","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5118","2511","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5119","2511","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5120","2512","_bbp_anonymous_name","india viagra online");
INSERT INTO `wp_postmeta` VALUES("5121","2512","_bbp_anonymous_email","uedqqvtd@smodxxmy.com");
INSERT INTO `wp_postmeta` VALUES("5097","2508","_bbp_anonymous_email","twgfsjyp@zdkllryv.com");
INSERT INTO `wp_postmeta` VALUES("5096","2508","_bbp_anonymous_name","alli pill");
INSERT INTO `wp_postmeta` VALUES("5056","2501","_bbp_anonymous_website","http://wellbutrin150mg.ga/#2137");
INSERT INTO `wp_postmeta` VALUES("5057","2501","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5058","2501","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5059","2501","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5060","2502","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("5061","2502","_bbp_anonymous_email","hhkowllk@nqpibhmp.com");
INSERT INTO `wp_postmeta` VALUES("5062","2502","_bbp_anonymous_website","http://buyviagra-softtabs.ga/#9156");
INSERT INTO `wp_postmeta` VALUES("5063","2502","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5064","2502","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5065","2502","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5066","2503","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5067","2503","_bbp_anonymous_email","ttipxfne@kynfdqog.com");
INSERT INTO `wp_postmeta` VALUES("5068","2503","_bbp_anonymous_website","http://finasteridemedication.tk/#4374");
INSERT INTO `wp_postmeta` VALUES("5069","2503","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5070","2503","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5071","2503","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5072","2504","_bbp_anonymous_name","order cialis online canada");
INSERT INTO `wp_postmeta` VALUES("5073","2504","_bbp_anonymous_email","uvqwxacx@xozjcqrt.com");
INSERT INTO `wp_postmeta` VALUES("5074","2504","_bbp_anonymous_website","http://ordercialisonline.ml/#9217");
INSERT INTO `wp_postmeta` VALUES("5075","2504","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5076","2504","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5077","2504","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5078","2505","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("5079","2505","_bbp_anonymous_email","ldmmdtkb@abincxzt.com");
INSERT INTO `wp_postmeta` VALUES("5080","2505","_bbp_anonymous_website","http://nexiumdrug.ga/#8307");
INSERT INTO `wp_postmeta` VALUES("5081","2505","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5082","2505","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5083","2505","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5084","2506","_bbp_anonymous_name","albuterol");
INSERT INTO `wp_postmeta` VALUES("5085","2506","_bbp_anonymous_email","zflbwxpp@ipsncgko.com");
INSERT INTO `wp_postmeta` VALUES("5086","2506","_bbp_anonymous_website","http://albuterol.in/#4987");
INSERT INTO `wp_postmeta` VALUES("5087","2506","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5088","2506","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5089","2506","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5090","2507","_bbp_anonymous_name","augmentin");
INSERT INTO `wp_postmeta` VALUES("5091","2507","_bbp_anonymous_email","zdpnhqbc@dkqwhuis.com");
INSERT INTO `wp_postmeta` VALUES("5092","2507","_bbp_anonymous_website","http://genericforaugmentin.pw/#1105");
INSERT INTO `wp_postmeta` VALUES("5093","2507","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5094","2507","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5095","2507","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5054","2501","_bbp_anonymous_name","buy wellbutrin xl");
INSERT INTO `wp_postmeta` VALUES("5040","2498","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5041","2498","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5042","2499","_bbp_anonymous_name","generic amitriptyline online");
INSERT INTO `wp_postmeta` VALUES("5043","2499","_bbp_anonymous_email","chvnpnjs@wmrucqvj.com");
INSERT INTO `wp_postmeta` VALUES("5044","2499","_bbp_anonymous_website","http://amitriptylinehcl25mgtab.cf/#5156");
INSERT INTO `wp_postmeta` VALUES("5045","2499","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5046","2499","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5047","2499","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5048","2500","_bbp_anonymous_name","generic for strattera");
INSERT INTO `wp_postmeta` VALUES("5049","2500","_bbp_anonymous_email","dafdpzfm@bkeuxuaw.com");
INSERT INTO `wp_postmeta` VALUES("5050","2500","_bbp_anonymous_website","http://purchasestattera.cf/#9429");
INSERT INTO `wp_postmeta` VALUES("5051","2500","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5052","2500","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5053","2500","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5039","2498","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5012","2494","_bbp_anonymous_name","zoloft generic");
INSERT INTO `wp_postmeta` VALUES("5013","2494","_bbp_anonymous_email","kosgxddr@aqzskijf.com");
INSERT INTO `wp_postmeta` VALUES("5014","2494","_bbp_anonymous_website","http://zoloftgeneric.ml/#5492");
INSERT INTO `wp_postmeta` VALUES("5015","2494","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5016","2494","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5017","2494","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5018","2495","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("5019","2495","_bbp_anonymous_email","vycokvyy@spooqlnd.com");
INSERT INTO `wp_postmeta` VALUES("5020","2495","_bbp_anonymous_website","http://lexapro5mg.ml/#1177");
INSERT INTO `wp_postmeta` VALUES("5021","2495","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5022","2495","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5023","2495","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5024","2496","_bbp_anonymous_name","nolvadex xt");
INSERT INTO `wp_postmeta` VALUES("5025","2496","_bbp_anonymous_email","hgjzqcgt@gmhlzpmc.com");
INSERT INTO `wp_postmeta` VALUES("5026","2496","_bbp_anonymous_website","http://nolvadex-xt.tk/#8189");
INSERT INTO `wp_postmeta` VALUES("5027","2496","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5028","2496","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5029","2496","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5030","2497","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("5031","2497","_bbp_anonymous_email","liglbgnt@joxkojst.com");
INSERT INTO `wp_postmeta` VALUES("5032","2497","_bbp_anonymous_website","http://mobic75mg.cf/#8592");
INSERT INTO `wp_postmeta` VALUES("5033","2497","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5034","2497","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5035","2497","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5036","2498","_bbp_anonymous_name","buy amoxicillin 500mg");
INSERT INTO `wp_postmeta` VALUES("5037","2498","_bbp_anonymous_email","fyhmxjuh@fxbxensw.com");
INSERT INTO `wp_postmeta` VALUES("5038","2498","_bbp_anonymous_website","http://buyamoxicillin500mg.ml/#8093");
INSERT INTO `wp_postmeta` VALUES("5009","2493","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4978","2488","_bbp_anonymous_website","http://tadalafil20mg.tk/#4051");
INSERT INTO `wp_postmeta` VALUES("4979","2488","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4980","2488","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4981","2488","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4982","2489","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4983","2489","_bbp_anonymous_email","gfkwwdgf@mvxzmmob.com");
INSERT INTO `wp_postmeta` VALUES("4984","2489","_bbp_anonymous_website","http://discountlevitra.cf/#7104");
INSERT INTO `wp_postmeta` VALUES("4985","2489","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4986","2489","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4987","2489","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4988","2490","_bbp_anonymous_name","visit website");
INSERT INTO `wp_postmeta` VALUES("4989","2490","_bbp_anonymous_email","wmspfxfk@vodhfewf.com");
INSERT INTO `wp_postmeta` VALUES("4990","2490","_bbp_anonymous_website","http://synthroid137mgwithoutprescription.ga/#1885");
INSERT INTO `wp_postmeta` VALUES("4991","2490","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4992","2490","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4993","2490","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4994","2491","_bbp_anonymous_name","alli tablets");
INSERT INTO `wp_postmeta` VALUES("4995","2491","_bbp_anonymous_email","ywipcsce@injahomg.com");
INSERT INTO `wp_postmeta` VALUES("4996","2491","_bbp_anonymous_website","http://allidrug.cf/#2013");
INSERT INTO `wp_postmeta` VALUES("4997","2491","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4998","2491","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4999","2491","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5000","2492","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("5001","2492","_bbp_anonymous_email","ouxbslfe@pqxmjeyy.com");
INSERT INTO `wp_postmeta` VALUES("5002","2492","_bbp_anonymous_website","http://cheapmobic.pw/#7021");
INSERT INTO `wp_postmeta` VALUES("5003","2492","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5004","2492","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5005","2492","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5006","2493","_bbp_anonymous_name","vermox");
INSERT INTO `wp_postmeta` VALUES("5007","2493","_bbp_anonymous_email","sffvchzt@zetqziuf.com");
INSERT INTO `wp_postmeta` VALUES("5008","2493","_bbp_anonymous_website","http://vermox.ml/#4299");
INSERT INTO `wp_postmeta` VALUES("4977","2488","_bbp_anonymous_email","wqmrutfl@jmfgwkug.com");
INSERT INTO `wp_postmeta` VALUES("4976","2488","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("4917","2478","_bbp_anonymous_email","ldtjtxhh@ykcpzlgv.com");
INSERT INTO `wp_postmeta` VALUES("4918","2478","_bbp_anonymous_website","http://buy-doxycycline.tk/#2306");
INSERT INTO `wp_postmeta` VALUES("4919","2478","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4920","2478","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4921","2478","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4922","2479","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("4923","2479","_bbp_anonymous_email","sizihykr@lbnjtoil.com");
INSERT INTO `wp_postmeta` VALUES("4924","2479","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#9383");
INSERT INTO `wp_postmeta` VALUES("4925","2479","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4926","2479","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4927","2479","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4928","2480","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("4929","2480","_bbp_anonymous_email","lowkuiju@ssyozbxv.com");
INSERT INTO `wp_postmeta` VALUES("4930","2480","_bbp_anonymous_website","http://xenical-orlistat-120mg.cf/#8928");
INSERT INTO `wp_postmeta` VALUES("4931","2480","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4932","2480","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4933","2480","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4934","2481","_bbp_anonymous_name","diflucan");
INSERT INTO `wp_postmeta` VALUES("4935","2481","_bbp_anonymous_email","yngnaoym@wbsiiutw.com");
INSERT INTO `wp_postmeta` VALUES("4936","2481","_bbp_anonymous_website","http://diflucanfluconazole.tk/#2840");
INSERT INTO `wp_postmeta` VALUES("4937","2481","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4938","2481","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4939","2481","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4940","2482","_bbp_anonymous_name","hello");
INSERT INTO `wp_postmeta` VALUES("4941","2482","_bbp_anonymous_email","hmftzz@nkytcz.com");
INSERT INTO `wp_postmeta` VALUES("4942","2482","_bbp_anonymous_website","http://qzfzrr.com/");
INSERT INTO `wp_postmeta` VALUES("4943","2482","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4944","2482","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4945","2482","_bbp_author_ip","62.210.91.186");
INSERT INTO `wp_postmeta` VALUES("4946","2483","_bbp_anonymous_name","xenical where to buy");
INSERT INTO `wp_postmeta` VALUES("4947","2483","_bbp_anonymous_email","mllpuprx@mqnxfhwc.com");
INSERT INTO `wp_postmeta` VALUES("4948","2483","_bbp_anonymous_website","http://orlistat120mg.ga/#3043");
INSERT INTO `wp_postmeta` VALUES("4949","2483","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4950","2483","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4951","2483","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4952","2484","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("4953","2484","_bbp_anonymous_email","jlikpdzr@zqnnjohs.com");
INSERT INTO `wp_postmeta` VALUES("4954","2484","_bbp_anonymous_website","http://vardenafil.pw/#8154");
INSERT INTO `wp_postmeta` VALUES("4955","2484","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4956","2484","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4957","2484","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4958","2485","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4959","2485","_bbp_anonymous_email","jaakkuwd@nlqatbkq.com");
INSERT INTO `wp_postmeta` VALUES("4960","2485","_bbp_anonymous_website","http://levitracoupons.ga/#7458");
INSERT INTO `wp_postmeta` VALUES("4961","2485","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4962","2485","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4963","2485","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4964","2486","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4965","2486","_bbp_anonymous_email","wjleycbd@yxgfrbil.com");
INSERT INTO `wp_postmeta` VALUES("4966","2486","_bbp_anonymous_website","http://finasteride.ml/#3022");
INSERT INTO `wp_postmeta` VALUES("4967","2486","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4968","2486","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4969","2486","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4970","2487","_bbp_anonymous_name","effexor xr 150 mg");
INSERT INTO `wp_postmeta` VALUES("4971","2487","_bbp_anonymous_email","xmcjgoyw@luvzmtjm.com");
INSERT INTO `wp_postmeta` VALUES("4972","2487","_bbp_anonymous_website","http://effexorxr150mg.pw/#8218");
INSERT INTO `wp_postmeta` VALUES("4973","2487","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4974","2487","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4975","2487","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4911","2477","_bbp_anonymous_email","wfilotph@qniijmdh.com");
INSERT INTO `wp_postmeta` VALUES("4910","2477","_bbp_anonymous_name","men viagra");
INSERT INTO `wp_postmeta` VALUES("4846","2466","_bbp_anonymous_website","http://finasteride.ga/#2577");
INSERT INTO `wp_postmeta` VALUES("4847","2466","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4848","2466","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4849","2466","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4850","2467","_bbp_anonymous_name","furosemide");
INSERT INTO `wp_postmeta` VALUES("4851","2467","_bbp_anonymous_email","nppqedgp@itfqvsjs.com");
INSERT INTO `wp_postmeta` VALUES("4852","2467","_bbp_anonymous_website","http://furosemide40mgdiuretic.pw/#3077");
INSERT INTO `wp_postmeta` VALUES("4853","2467","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4854","2467","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4855","2467","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4856","2468","_bbp_anonymous_name","discount cialis");
INSERT INTO `wp_postmeta` VALUES("4857","2468","_bbp_anonymous_email","pdtbpnaa@boninmci.com");
INSERT INTO `wp_postmeta` VALUES("4858","2468","_bbp_anonymous_website","http://discountcialis.tk/#6516");
INSERT INTO `wp_postmeta` VALUES("4859","2468","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4860","2468","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4861","2468","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4862","2469","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("4863","2469","_bbp_anonymous_email","zwtavera@jvrhgjjh.com");
INSERT INTO `wp_postmeta` VALUES("4864","2469","_bbp_anonymous_website","http://lasixwaterpill.cf/#3073");
INSERT INTO `wp_postmeta` VALUES("4865","2469","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4866","2469","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4867","2469","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4868","2470","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4869","2470","_bbp_anonymous_email","ckocqwuc@dvsfoetg.com");
INSERT INTO `wp_postmeta` VALUES("4870","2470","_bbp_anonymous_website","http://buy-zithromax.info/#8152");
INSERT INTO `wp_postmeta` VALUES("4871","2470","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4872","2470","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4873","2470","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4874","2471","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("4875","2471","_bbp_anonymous_email","ethhiljt@lrnsvehk.com");
INSERT INTO `wp_postmeta` VALUES("4876","2471","_bbp_anonymous_website","http://amoxil-875.ml/#3052");
INSERT INTO `wp_postmeta` VALUES("4877","2471","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4878","2471","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4879","2471","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4880","2472","_bbp_anonymous_name","purchase levitra online");
INSERT INTO `wp_postmeta` VALUES("4881","2472","_bbp_anonymous_email","qplhrdps@gupnaszx.com");
INSERT INTO `wp_postmeta` VALUES("4882","2472","_bbp_anonymous_website","http://levitraprofessional20mg.tk/#7407");
INSERT INTO `wp_postmeta` VALUES("4883","2472","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4884","2472","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4885","2472","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4886","2473","_bbp_anonymous_name","cipro buy online");
INSERT INTO `wp_postmeta` VALUES("4887","2473","_bbp_anonymous_email","pqjjjqgu@tckegcqd.com");
INSERT INTO `wp_postmeta` VALUES("4888","2473","_bbp_anonymous_website","http://ciprocost.cf/#4711");
INSERT INTO `wp_postmeta` VALUES("4889","2473","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4890","2473","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4891","2473","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4892","2474","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("4893","2474","_bbp_anonymous_email","fjkjhvyx@pobsvvwr.com");
INSERT INTO `wp_postmeta` VALUES("4894","2474","_bbp_anonymous_website","http://genericsildenafil.us/#2165");
INSERT INTO `wp_postmeta` VALUES("4895","2474","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4896","2474","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4897","2474","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4898","2475","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("4899","2475","_bbp_anonymous_email","eapwxuyl@rarhvnyd.com");
INSERT INTO `wp_postmeta` VALUES("4900","2475","_bbp_anonymous_website","http://vardenafil-hydrochloride.ml/#3827");
INSERT INTO `wp_postmeta` VALUES("4901","2475","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4902","2475","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4903","2475","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4904","2476","_bbp_anonymous_name","cephalexin 500 mg capsules");
INSERT INTO `wp_postmeta` VALUES("4905","2476","_bbp_anonymous_email","molyjwwr@vwtxglew.com");
INSERT INTO `wp_postmeta` VALUES("4906","2476","_bbp_anonymous_website","http://keflexantibiotic.cf/#9800");
INSERT INTO `wp_postmeta` VALUES("4907","2476","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4908","2476","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4909","2476","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4845","2466","_bbp_anonymous_email","rpoamivw@pkigcqjy.com");
INSERT INTO `wp_postmeta` VALUES("4844","2466","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4823","2462","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4824","2462","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4825","2462","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4826","2463","_bbp_anonymous_name","generic sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("4827","2463","_bbp_anonymous_email","xudwyquj@cfglvfwu.com");
INSERT INTO `wp_postmeta` VALUES("4828","2463","_bbp_anonymous_website","http://generic-sildenafil-citrate.ga/#3882");
INSERT INTO `wp_postmeta` VALUES("4829","2463","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4830","2463","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4831","2463","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4832","2464","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("4833","2464","_bbp_anonymous_email","epdgkxdz@qgxtugbu.com");
INSERT INTO `wp_postmeta` VALUES("4834","2464","_bbp_anonymous_website","http://buyretinaonline.ml/#8235");
INSERT INTO `wp_postmeta` VALUES("4835","2464","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4836","2464","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4837","2464","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4838","2465","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("4839","2465","_bbp_anonymous_email","tozmeapd@bafufrsu.com");
INSERT INTO `wp_postmeta` VALUES("4840","2465","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#7310");
INSERT INTO `wp_postmeta` VALUES("4841","2465","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4842","2465","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4843","2465","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("2987","2160","_bbp_anonymous_email","$$$####*@gmail.com");
INSERT INTO `wp_postmeta` VALUES("2988","2160","_bbp_anonymous_website","http://www.fpggolfcenter.com.br/UserFiles/public/johnny-manziel-jersey-youth.html");
INSERT INTO `wp_postmeta` VALUES("2989","2160","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("2990","2160","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("2991","2160","_bbp_author_ip","27.159.211.141");
INSERT INTO `wp_postmeta` VALUES("2992","2160","_bbp_last_reply_id","17153");
INSERT INTO `wp_postmeta` VALUES("2993","2160","_bbp_last_active_id","17153");
INSERT INTO `wp_postmeta` VALUES("2994","2160","_bbp_last_active_time","2015-03-27 04:19:09");
INSERT INTO `wp_postmeta` VALUES("2995","2160","_bbp_reply_count","173");
INSERT INTO `wp_postmeta` VALUES("2996","2160","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("2997","2160","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("2998","2161","_bbp_anonymous_name","Cheap NFL Jerseys Online");
INSERT INTO `wp_postmeta` VALUES("2999","2161","_bbp_anonymous_email","ecamfhtjw@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3000","2161","_bbp_anonymous_website","http://www.abcindustrial.co.uk/News/nflsaleonline.asp");
INSERT INTO `wp_postmeta` VALUES("3001","2161","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3002","2161","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3003","2161","_bbp_author_ip","27.159.211.141");
INSERT INTO `wp_postmeta` VALUES("3004","2161","_bbp_last_reply_id","19691");
INSERT INTO `wp_postmeta` VALUES("3005","2161","_bbp_last_active_id","19691");
INSERT INTO `wp_postmeta` VALUES("3006","2161","_bbp_last_active_time","2015-03-30 12:32:38");
INSERT INTO `wp_postmeta` VALUES("375","1167","header","yes");
INSERT INTO `wp_postmeta` VALUES("376","1167","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("377","1167","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("378","1167","_aviaLayoutBuilderCleanData","[av_sidebar widget_area=\'Contact\']

[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Contactez-nous !\' color=\'meta-heading\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_contact email=\'aurore.staiger@hotmail.fr\' button=\'Envoyer\' title=\'\' sent=\'Votre message a bien été envoyé!\' subject=\'\' autorespond=\'\' captcha=\'\']
[av_contact_field label=\'Nom\' type=\'text\' options=\'\' check=\'is_empty\' width=\'element_half\']
[av_contact_field label=\'E-Mail\' type=\'text\' options=\'\' check=\'is_email\' width=\'element_half\']
[av_contact_field label=\'Sujet de votre message\' type=\'text\' options=\'\' check=\'is_empty\' width=\'\']
[av_contact_field label=\'Message\' type=\'textarea\' options=\'\' check=\'is_empty\' width=\'\']
[/av_contact]

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1607","1639","_wp_attachment_metadata","a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:22:\"2013/04/favicon-01.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1063","734","_edit_lock","1429276061:5");
INSERT INTO `wp_postmeta` VALUES("379","1167","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("380","1167","sidebar","");
INSERT INTO `wp_postmeta` VALUES("381","1167","_avia_builder_shortcode_tree","a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:1;a:3:{s:3:\"tag\";s:10:\"av_contact\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:1;}}");
INSERT INTO `wp_postmeta` VALUES("1606","1639","_wp_attached_file","2013/04/favicon-01.png");
INSERT INTO `wp_postmeta` VALUES("1085","1407","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("6801","2792","_bbp_anonymous_email","qusskmzf@huhedpcf.com");
INSERT INTO `wp_postmeta` VALUES("6701","2775","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6702","2775","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6703","2775","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6704","2776","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("6705","2776","_bbp_anonymous_email","mdnnodai@owpkjmms.com");
INSERT INTO `wp_postmeta` VALUES("6706","2776","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#3872");
INSERT INTO `wp_postmeta` VALUES("6707","2776","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6708","2776","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6709","2776","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6710","2777","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("6711","2777","_bbp_anonymous_email","hwfsjzwk@bhzviamg.com");
INSERT INTO `wp_postmeta` VALUES("6712","2777","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#3929");
INSERT INTO `wp_postmeta` VALUES("6713","2777","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6714","2777","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6715","2777","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6716","2778","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("6717","2778","_bbp_anonymous_email","xrxrijtf@xmdmpbct.com");
INSERT INTO `wp_postmeta` VALUES("6718","2778","_bbp_anonymous_website","http://viagraonlinesales.pw/#6448");
INSERT INTO `wp_postmeta` VALUES("6719","2778","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6720","2778","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6721","2778","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6722","2779","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("6723","2779","_bbp_anonymous_email","avqfrpjq@cxyttkhb.com");
INSERT INTO `wp_postmeta` VALUES("6724","2779","_bbp_anonymous_website","http://buy-levitra.ga/#1079");
INSERT INTO `wp_postmeta` VALUES("6725","2779","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6726","2779","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6727","2779","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6728","2780","_bbp_anonymous_name","cheap cialis 5 mg");
INSERT INTO `wp_postmeta` VALUES("6729","2780","_bbp_anonymous_email","fwjnumeb@efqamwkt.com");
INSERT INTO `wp_postmeta` VALUES("6730","2780","_bbp_anonymous_website","http://cialis5mg.tk/#5748");
INSERT INTO `wp_postmeta` VALUES("6731","2780","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6732","2780","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6733","2780","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6734","2781","_bbp_anonymous_name","xenical 120mg");
INSERT INTO `wp_postmeta` VALUES("6735","2781","_bbp_anonymous_email","olqlxfsy@xkqdrcgb.com");
INSERT INTO `wp_postmeta` VALUES("6736","2781","_bbp_anonymous_website","http://xenical-120-mg.cf/#8264");
INSERT INTO `wp_postmeta` VALUES("6737","2781","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6738","2781","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6739","2781","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6740","2782","_bbp_anonymous_name","generic of accutane");
INSERT INTO `wp_postmeta` VALUES("6741","2782","_bbp_anonymous_email","jnvggtdl@ejvwdwkm.com");
INSERT INTO `wp_postmeta` VALUES("6742","2782","_bbp_anonymous_website","http://genericaccutane.nu/#8697");
INSERT INTO `wp_postmeta` VALUES("6743","2782","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6744","2782","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6745","2782","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6746","2783","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("6747","2783","_bbp_anonymous_email","cklalpeg@aeuijdbm.com");
INSERT INTO `wp_postmeta` VALUES("6748","2783","_bbp_anonymous_website","http://genericforcymbalta.ga/#1879");
INSERT INTO `wp_postmeta` VALUES("6749","2783","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6750","2783","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6751","2783","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6752","2784","_bbp_anonymous_name","tadalafil no prescription");
INSERT INTO `wp_postmeta` VALUES("6753","2784","_bbp_anonymous_email","wjocynmg@ukjnpmwi.com");
INSERT INTO `wp_postmeta` VALUES("6754","2784","_bbp_anonymous_website","http://tadalafil-no-prescription.cf/#8840");
INSERT INTO `wp_postmeta` VALUES("6755","2784","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6756","2784","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6757","2784","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6758","2785","_bbp_anonymous_name","lexapro 5mg");
INSERT INTO `wp_postmeta` VALUES("6759","2785","_bbp_anonymous_email","twnpqeid@ymcpsqng.com");
INSERT INTO `wp_postmeta` VALUES("6760","2785","_bbp_anonymous_website","http://lexapro5mg.ml/#5773");
INSERT INTO `wp_postmeta` VALUES("6761","2785","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6762","2785","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6763","2785","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6764","2786","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6765","2786","_bbp_anonymous_email","rnrpugml@rbloyixn.com");
INSERT INTO `wp_postmeta` VALUES("6766","2786","_bbp_anonymous_website","http://buy-mobic.tk/#6767");
INSERT INTO `wp_postmeta` VALUES("6767","2786","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6768","2786","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6769","2786","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6770","2787","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("6771","2787","_bbp_anonymous_email","zadycyzt@ealgzwic.com");
INSERT INTO `wp_postmeta` VALUES("6772","2787","_bbp_anonymous_website","http://cheapmobic.tk/#9700");
INSERT INTO `wp_postmeta` VALUES("6773","2787","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6774","2787","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6775","2787","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6776","2788","_bbp_anonymous_name","wellbutrin");
INSERT INTO `wp_postmeta` VALUES("6777","2788","_bbp_anonymous_email","yltcoqmn@kzbvvlks.com");
INSERT INTO `wp_postmeta` VALUES("6778","2788","_bbp_anonymous_website","http://wellbutrinmedication.cf/#4915");
INSERT INTO `wp_postmeta` VALUES("6779","2788","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6780","2788","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6781","2788","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6782","2789","_bbp_anonymous_name","cialus");
INSERT INTO `wp_postmeta` VALUES("6783","2789","_bbp_anonymous_email","jpkoawkq@jbjqmzcc.com");
INSERT INTO `wp_postmeta` VALUES("6784","2789","_bbp_anonymous_website","http://cialus.tk/#2740");
INSERT INTO `wp_postmeta` VALUES("6785","2789","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6786","2789","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6787","2789","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6788","2790","_bbp_anonymous_name","azithromycin zithromax");
INSERT INTO `wp_postmeta` VALUES("6789","2790","_bbp_anonymous_email","ossjdalk@ixlmxebl.com");
INSERT INTO `wp_postmeta` VALUES("6790","2790","_bbp_anonymous_website","http://buyzithromax.info/#4034");
INSERT INTO `wp_postmeta` VALUES("6791","2790","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6792","2790","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6793","2790","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6794","2791","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("6795","2791","_bbp_anonymous_email","xkbvghcm@jjpvogme.com");
INSERT INTO `wp_postmeta` VALUES("6796","2791","_bbp_anonymous_website","http://lasixwaterpill.cf/#3562");
INSERT INTO `wp_postmeta` VALUES("6797","2791","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6798","2791","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6799","2791","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6800","2792","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("6685","2772","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6686","2773","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6687","2773","_bbp_anonymous_email","xenkpmfm@qrudodqt.com");
INSERT INTO `wp_postmeta` VALUES("6688","2773","_bbp_anonymous_website","http://finasteridemedication.tk/#3326");
INSERT INTO `wp_postmeta` VALUES("6689","2773","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6690","2773","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6691","2773","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6692","2774","_bbp_anonymous_name","generic for augmentin");
INSERT INTO `wp_postmeta` VALUES("6693","2774","_bbp_anonymous_email","aggysrvk@xllwyqsx.com");
INSERT INTO `wp_postmeta` VALUES("6694","2774","_bbp_anonymous_website","http://genericforaugmentin.tk/#7947");
INSERT INTO `wp_postmeta` VALUES("6695","2774","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6696","2774","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6697","2774","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6698","2775","_bbp_anonymous_name","generic sildenafil citrate 100mg");
INSERT INTO `wp_postmeta` VALUES("6699","2775","_bbp_anonymous_email","hifptfvj@lzprhnne.com");
INSERT INTO `wp_postmeta` VALUES("6700","2775","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#2493");
INSERT INTO `wp_postmeta` VALUES("6684","2772","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4739","2448","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4740","2448","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4741","2448","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4742","2449","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4743","2449","_bbp_anonymous_email","egpswmsk@ugytnmlc.com");
INSERT INTO `wp_postmeta` VALUES("4744","2449","_bbp_anonymous_website","http://propeciahairgrowth.tk/#2519");
INSERT INTO `wp_postmeta` VALUES("4745","2449","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4746","2449","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4747","2449","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4748","2450","_bbp_anonymous_name","buy levitra online canada");
INSERT INTO `wp_postmeta` VALUES("4749","2450","_bbp_anonymous_email","tcrcfxbr@dijzvixx.com");
INSERT INTO `wp_postmeta` VALUES("4750","2450","_bbp_anonymous_website","http://buy-levitra.ga/#6560");
INSERT INTO `wp_postmeta` VALUES("4751","2450","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4752","2450","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4753","2450","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4754","2451","_bbp_anonymous_name","order generic viagra");
INSERT INTO `wp_postmeta` VALUES("4755","2451","_bbp_anonymous_email","wtmtzdgm@bwppocul.com");
INSERT INTO `wp_postmeta` VALUES("4756","2451","_bbp_anonymous_website","http://generic-viagra.info/#3832");
INSERT INTO `wp_postmeta` VALUES("4757","2451","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4758","2451","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4759","2451","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4760","2452","_bbp_anonymous_name","price of effexor");
INSERT INTO `wp_postmeta` VALUES("4761","2452","_bbp_anonymous_email","khndmbmy@bwapdqtn.com");
INSERT INTO `wp_postmeta` VALUES("4762","2452","_bbp_anonymous_website","http://venlafaxineeffexor.ml/#7436");
INSERT INTO `wp_postmeta` VALUES("4763","2452","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4764","2452","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4765","2452","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4766","2453","_bbp_anonymous_name","propecia hair growth");
INSERT INTO `wp_postmeta` VALUES("4767","2453","_bbp_anonymous_email","tawgrshj@shpfbrrm.com");
INSERT INTO `wp_postmeta` VALUES("4768","2453","_bbp_anonymous_website","http://propeciahairgrowth.ga/#7552");
INSERT INTO `wp_postmeta` VALUES("4769","2453","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4770","2453","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4771","2453","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4772","2454","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("4773","2454","_bbp_anonymous_email","iuuzwhvz@uvdhaklx.com");
INSERT INTO `wp_postmeta` VALUES("4774","2454","_bbp_anonymous_website","http://cheapmobic.tk/#5435");
INSERT INTO `wp_postmeta` VALUES("4775","2454","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4776","2454","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4777","2454","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4778","2455","_bbp_anonymous_name","purchase xenical");
INSERT INTO `wp_postmeta` VALUES("4779","2455","_bbp_anonymous_email","ftlhmtce@bwzghtne.com");
INSERT INTO `wp_postmeta` VALUES("4780","2455","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#9308");
INSERT INTO `wp_postmeta` VALUES("4781","2455","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4782","2455","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4783","2455","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4784","2456","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("4785","2456","_bbp_anonymous_email","ugxacoyf@lmjpikrn.com");
INSERT INTO `wp_postmeta` VALUES("4786","2456","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#9362");
INSERT INTO `wp_postmeta` VALUES("4787","2456","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4788","2456","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4789","2456","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4790","2457","_bbp_anonymous_name","buy cialis cheap online");
INSERT INTO `wp_postmeta` VALUES("4791","2457","_bbp_anonymous_email","uusteije@nlkfddic.com");
INSERT INTO `wp_postmeta` VALUES("4792","2457","_bbp_anonymous_website","http://buycialisonlinecheap.tk/#7788");
INSERT INTO `wp_postmeta` VALUES("4793","2457","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4794","2457","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4795","2457","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4796","2458","_bbp_anonymous_name","nexium drug");
INSERT INTO `wp_postmeta` VALUES("4797","2458","_bbp_anonymous_email","dweiajxq@mysmjlny.com");
INSERT INTO `wp_postmeta` VALUES("4798","2458","_bbp_anonymous_website","http://nexiumdrug.cf/#1281");
INSERT INTO `wp_postmeta` VALUES("4799","2458","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4800","2458","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4801","2458","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4802","2459","_bbp_anonymous_name","sildenafil generic");
INSERT INTO `wp_postmeta` VALUES("4803","2459","_bbp_anonymous_email","itererrc@goiiusgm.com");
INSERT INTO `wp_postmeta` VALUES("4804","2459","_bbp_anonymous_website","http://sildenafilgeneric.pw/#2208");
INSERT INTO `wp_postmeta` VALUES("4805","2459","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4806","2459","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4807","2459","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4808","2460","_bbp_anonymous_name","cymbalta generic");
INSERT INTO `wp_postmeta` VALUES("4809","2460","_bbp_anonymous_email","rzvmegth@fstlrrij.com");
INSERT INTO `wp_postmeta` VALUES("4810","2460","_bbp_anonymous_website","http://cymbaltageneric.ga/#9387");
INSERT INTO `wp_postmeta` VALUES("4811","2460","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4812","2460","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4813","2460","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4814","2461","_bbp_anonymous_name","viagr");
INSERT INTO `wp_postmeta` VALUES("4815","2461","_bbp_anonymous_email","hiabgdne@enyowvxd.com");
INSERT INTO `wp_postmeta` VALUES("4816","2461","_bbp_anonymous_website","http://viagr.ml/#7075");
INSERT INTO `wp_postmeta` VALUES("4817","2461","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4818","2461","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4819","2461","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4820","2462","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("4821","2462","_bbp_anonymous_email","xiblwmjn@gbzxddkt.com");
INSERT INTO `wp_postmeta` VALUES("4738","2448","_bbp_anonymous_website","http://retina005cream.ml/#7988");
INSERT INTO `wp_postmeta` VALUES("4737","2448","_bbp_anonymous_email","lphhenow@lklmqydr.com");
INSERT INTO `wp_postmeta` VALUES("4710","2443","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4711","2443","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4712","2444","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("4713","2444","_bbp_anonymous_email","sqkqqddk@qykwfrdi.com");
INSERT INTO `wp_postmeta` VALUES("4714","2444","_bbp_anonymous_website","http://generic-sildenafil.nu/#6432");
INSERT INTO `wp_postmeta` VALUES("4715","2444","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4716","2444","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4717","2444","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4718","2445","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("4719","2445","_bbp_anonymous_email","ccxykjhj@lxkfeqlu.com");
INSERT INTO `wp_postmeta` VALUES("4720","2445","_bbp_anonymous_website","http://alli-drug.cf/#7807");
INSERT INTO `wp_postmeta` VALUES("4721","2445","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4722","2445","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4723","2445","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4724","2446","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("4725","2446","_bbp_anonymous_email","fmthntwl@ziabntdw.com");
INSERT INTO `wp_postmeta` VALUES("4726","2446","_bbp_anonymous_website","http://generic-prozac.cf/#5404");
INSERT INTO `wp_postmeta` VALUES("4727","2446","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4728","2446","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4729","2446","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4730","2447","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4731","2447","_bbp_anonymous_email","tsmdjjhq@myiwvlgo.com");
INSERT INTO `wp_postmeta` VALUES("4732","2447","_bbp_anonymous_website","http://levitracheap.cf/#2338");
INSERT INTO `wp_postmeta` VALUES("4733","2447","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4734","2447","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4735","2447","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4736","2448","_bbp_anonymous_name","retin a 0.05 cream");
INSERT INTO `wp_postmeta` VALUES("4709","2443","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3418","2228","_bbp_anonymous_website","http://genericforcialis.ml/#5198");
INSERT INTO `wp_postmeta` VALUES("3417","2228","_bbp_anonymous_email","zulctxrc@lfemgxev.com");
INSERT INTO `wp_postmeta` VALUES("3411","2227","_bbp_anonymous_email","uaptfqwk@ooznhufs.com");
INSERT INTO `wp_postmeta` VALUES("3412","2227","_bbp_anonymous_website","http://buypropeciaonlinenorx.cf/#1947");
INSERT INTO `wp_postmeta` VALUES("3413","2227","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3414","2227","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3415","2227","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3416","2228","_bbp_anonymous_name","generic for cialis");
INSERT INTO `wp_postmeta` VALUES("2439","2009","_wp_attached_file","2013/04/S.Daycard-Heid-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2440","2009","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:1176;s:4:\"file\";s:28:\"2013/04/S.Daycard-Heid-1.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-1-733x1030.jpg\";s:5:\"width\";i:733;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-501x705.jpg\";s:5:\"width\";i:501;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x632.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:632;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2548","2034","_wp_attached_file","2014/05/logos-allier-01.png");
INSERT INTO `wp_postmeta` VALUES("2441","2011","_wp_attached_file","2013/04/S.Daycard-Heid-11.jpg");
INSERT INTO `wp_postmeta` VALUES("2442","2011","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:738;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-11.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-300x264.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-705x621.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:621;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x396.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("3410","2227","_bbp_anonymous_name","cheap propecia for sale");
INSERT INTO `wp_postmeta` VALUES("3409","2226","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3408","2226","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3365","2219","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3364","2219","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#9720");
INSERT INTO `wp_postmeta` VALUES("3363","2219","_bbp_anonymous_email","tjrijtmc@ocumlkuq.com");
INSERT INTO `wp_postmeta` VALUES("3164","2186","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("3163","2185","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3162","2185","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3161","2185","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3154","2184","_bbp_anonymous_website","http://viagrasofttabs.nu/generic-viagra-soft-tabs.html#6519");
INSERT INTO `wp_postmeta` VALUES("3155","2184","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3156","2184","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3157","2184","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3158","2185","_bbp_anonymous_name","hydrochlorothiazide 25 mg for sale");
INSERT INTO `wp_postmeta` VALUES("3159","2185","_bbp_anonymous_email","hrqayepv@xxplmbdi.com");
INSERT INTO `wp_postmeta` VALUES("3160","2185","_bbp_anonymous_website","http://hydrochlorothiazide.se/hydrochlorothiazide-for-sale.html#4810");
INSERT INTO `wp_postmeta` VALUES("3407","2226","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3406","2226","_bbp_anonymous_website","http://vermox-500.cf/#1491");
INSERT INTO `wp_postmeta` VALUES("3400","2225","_bbp_anonymous_website","http://zoloftdrug.tk/#7500");
INSERT INTO `wp_postmeta` VALUES("3401","2225","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3402","2225","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3403","2225","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3404","2226","_bbp_anonymous_name","buy vermox");
INSERT INTO `wp_postmeta` VALUES("3405","2226","_bbp_anonymous_email","deeizvcs@cxeznies.com");
INSERT INTO `wp_postmeta` VALUES("3275","2204","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3276","2204","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3277","2204","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3278","2205","_bbp_anonymous_name","hydrochlorothiazide 37.5");
INSERT INTO `wp_postmeta` VALUES("3279","2205","_bbp_anonymous_email","lpqzwkzg@ruwusmic.com");
INSERT INTO `wp_postmeta` VALUES("3280","2205","_bbp_anonymous_website","http://hydrochlorothiazide.se/#4882");
INSERT INTO `wp_postmeta` VALUES("3281","2205","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3282","2205","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3283","2205","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3284","2206","_bbp_anonymous_name","cipro");
INSERT INTO `wp_postmeta` VALUES("3285","2206","_bbp_anonymous_email","nriqxeud@taxvnwdx.com");
INSERT INTO `wp_postmeta` VALUES("3286","2206","_bbp_anonymous_website","http://cipro.in/#8757");
INSERT INTO `wp_postmeta` VALUES("3287","2206","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3288","2206","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3289","2206","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3290","2207","_bbp_anonymous_name","buy nolvadex online");
INSERT INTO `wp_postmeta` VALUES("3291","2207","_bbp_anonymous_email","snxtdbvf@sduvfkvg.com");
INSERT INTO `wp_postmeta` VALUES("3292","2207","_bbp_anonymous_website","http://buy-nolvadex.info/#2160");
INSERT INTO `wp_postmeta` VALUES("3293","2207","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3294","2207","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3295","2207","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3296","2208","_bbp_anonymous_name","accutane cost");
INSERT INTO `wp_postmeta` VALUES("3297","2208","_bbp_anonymous_email","ceimbjrw@xibopduf.com");
INSERT INTO `wp_postmeta` VALUES("3298","2208","_bbp_anonymous_website","http://genericaccutane.in/#3874");
INSERT INTO `wp_postmeta` VALUES("3299","2208","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3300","2208","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3301","2208","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3302","2209","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("3303","2209","_bbp_anonymous_email","wcacazpw@nmyuunyr.com");
INSERT INTO `wp_postmeta` VALUES("3304","2209","_bbp_anonymous_website","http://genericsildenafil.nu/#8537");
INSERT INTO `wp_postmeta` VALUES("3305","2209","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3306","2209","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3307","2209","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3308","2210","_bbp_anonymous_name","viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3309","2210","_bbp_anonymous_email","dvjokltk@zsbiwzjs.com");
INSERT INTO `wp_postmeta` VALUES("3310","2210","_bbp_anonymous_website","http://viagrasofttabs.nu/#8988");
INSERT INTO `wp_postmeta` VALUES("3311","2210","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3312","2210","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3313","2210","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3314","2211","_bbp_anonymous_name","viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("3315","2211","_bbp_anonymous_email","qrkcgcdy@pmgumalt.com");
INSERT INTO `wp_postmeta` VALUES("3316","2211","_bbp_anonymous_website","http://viagrasoft-tabs.ml/viagra-soft.html#1414");
INSERT INTO `wp_postmeta` VALUES("3317","2211","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3318","2211","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3319","2211","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3320","2212","_bbp_anonymous_name","viagra online");
INSERT INTO `wp_postmeta` VALUES("3321","2212","_bbp_anonymous_email","ykgaomgv@lipxkejq.com");
INSERT INTO `wp_postmeta` VALUES("3322","2212","_bbp_anonymous_website","http://genericsildenafil.nu/#2714");
INSERT INTO `wp_postmeta` VALUES("3323","2212","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3324","2212","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3325","2212","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3326","2213","_bbp_anonymous_name","hydrochlorothiazide");
INSERT INTO `wp_postmeta` VALUES("3327","2213","_bbp_anonymous_email","xqmtbuwu@foreexzb.com");
INSERT INTO `wp_postmeta` VALUES("3328","2213","_bbp_anonymous_website","http://hydrochlorothiazide.se/#6806");
INSERT INTO `wp_postmeta` VALUES("3329","2213","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3330","2213","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3331","2213","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3332","2214","_bbp_anonymous_name","clomid online pharmacy");
INSERT INTO `wp_postmeta` VALUES("3333","2214","_bbp_anonymous_email","ordgadhb@jbthrrwm.com");
INSERT INTO `wp_postmeta` VALUES("3334","2214","_bbp_anonymous_website","http://clomid.in/#6173");
INSERT INTO `wp_postmeta` VALUES("3335","2214","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3336","2214","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3337","2214","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3338","2215","_bbp_anonymous_name","low cost generic viagra");
INSERT INTO `wp_postmeta` VALUES("3339","2215","_bbp_anonymous_email","snhngfsu@nqaipsha.com");
INSERT INTO `wp_postmeta` VALUES("3340","2215","_bbp_anonymous_website","http://buyviagraonline.ml/#8540");
INSERT INTO `wp_postmeta` VALUES("3341","2215","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3342","2215","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3343","2215","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3344","2216","_bbp_anonymous_name","accutane online");
INSERT INTO `wp_postmeta` VALUES("3345","2216","_bbp_anonymous_email","igyhcetk@nkkpdglk.com");
INSERT INTO `wp_postmeta` VALUES("3346","2216","_bbp_anonymous_website","http://genericaccutane.in/#5937");
INSERT INTO `wp_postmeta` VALUES("3347","2216","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3348","2216","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3349","2216","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3350","2217","_bbp_anonymous_name","buy propecia online");
INSERT INTO `wp_postmeta` VALUES("3351","2217","_bbp_anonymous_email","jqywwcjx@gajskpln.com");
INSERT INTO `wp_postmeta` VALUES("3352","2217","_bbp_anonymous_website","http://genericpropecia.nu/#7716");
INSERT INTO `wp_postmeta` VALUES("3353","2217","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3354","2217","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3355","2217","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3356","2218","_bbp_anonymous_name","generic alli");
INSERT INTO `wp_postmeta` VALUES("3357","2218","_bbp_anonymous_email","gwgoxwjm@bcjqzcqj.com");
INSERT INTO `wp_postmeta` VALUES("3358","2218","_bbp_anonymous_website","http://allipills.tk/#7960");
INSERT INTO `wp_postmeta` VALUES("3359","2218","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3360","2218","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3361","2218","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3362","2219","_bbp_anonymous_name","buy viagra soft tabs");
INSERT INTO `wp_postmeta` VALUES("422","1248","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("423","1248","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("424","1248","sidebar","");
INSERT INTO `wp_postmeta` VALUES("425","1248","header","yes");
INSERT INTO `wp_postmeta` VALUES("426","1248","_avia_builder_shortcode_tree","a:31:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:5;}i:3;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}}s:5:\"index\";i:8;}i:4;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}i:5;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:6;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:14;}i:7;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:19;}}s:5:\"index\";i:17;}i:8;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:21;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:20;}i:9;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:24;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:25;}}s:5:\"index\";i:23;}i:10;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:27;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:28;}}s:5:\"index\";i:26;}i:11;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:30;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:31;}}s:5:\"index\";i:29;}i:12;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:32;}i:13;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:34;}}s:5:\"index\";i:33;}i:14;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:35;}i:15;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:37;}}s:5:\"index\";i:36;}i:16;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:39;}}s:5:\"index\";i:38;}i:17;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:41;}}s:5:\"index\";i:40;}i:18;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:43;}}s:5:\"index\";i:42;}i:19;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:45;}}s:5:\"index\";i:44;}i:20;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:47;}}s:5:\"index\";i:46;}i:21;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:48;}i:22;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:50;}}s:5:\"index\";i:49;}i:23;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:51;}i:24;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:53;}}s:5:\"index\";i:52;}i:25;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:55;}}s:5:\"index\";i:54;}i:26;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:56;}i:27;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:58;}}s:5:\"index\";i:57;}i:28;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:59;}i:29;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:61;}}s:5:\"index\";i:60;}i:30;a:3:{s:3:\"tag\";s:9:\"av_button\";s:7:\"content\";a:0:{}s:5:\"index\";i:62;}}");
INSERT INTO `wp_postmeta` VALUES("1462","1248","footer","");
INSERT INTO `wp_postmeta` VALUES("1751","1734","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1752","1734","_menu_item_orphaned","1399370100");
INSERT INTO `wp_postmeta` VALUES("427","1248","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("428","1248","_aviaLayoutBuilderCleanData","[av_one_full first]
[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'JEUDI 2 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\']
Durant ces deux journée des jeunes “facilitateurs” polyglottes du CUEJ ou de European Youthpress seront présents accueillir et guider les participants.
[/av_icon_box]

[av_one_half first]
[av_heading heading=\'9h30 : Accueil et Ice breaker coffee\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\' attachment=\'1474\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_heading heading=\'10h30 : Réu de lancement Kick off meeting\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\' attachment=\'1485\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h00 : Ateliers flash partage de compétences Sharing skills\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'\' attachment=\'\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'L’apport du multimédia\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Laurent Gontier (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/GieffersHanna-2015-300x300.jpeg\' attachment=\'19703\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le webdocumentaire\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Hanna Gieffers (Allemagne)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/GuadagniTommaso-2015-300x300.jpg\' attachment=\'19702\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Datajournalisme\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Tommaso Guadagni

[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/MartiniereMathieu-2015-300x300.jpg\' attachment=\'19704\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réussir un crowfunding\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'2\']
Mathieu Martinière (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/StrassenburgRomy-2015-296x300.jpg\' attachment=\'19705\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Bien vendre ses piges\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Romy Strassenburg (Allemagne)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/SansonStern-2014-287x300.jpg\' attachment=\'19706\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réseaux sociaux\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Catherine Sanson-Stern (France)
[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/VallellianPatrick-2015-298x300.jpg\' attachment=\'19707\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le long format\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Patrick Vallelian (Suisse)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/WildNicolas-2015-300x300.jpg\' attachment=\'19710\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'La BD-reportage\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Nicolas Wild (France)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/BulligPaula-2015-300x299.jpg\' attachment=\'19709\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'La BD-reportage\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Paula Bullig (Allemagne)
[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'13h : Déjeuner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'14h30 : Workshop Créer un nouveau média en 2h ? C’est possible ! (Ou presque)\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
En mode « Media Lab », les participants se répartissent en 4 groupes thématiques à l’intérieur desquels ils s’organisent en équipes aux compétences complémentaires.
Guidés par des modérateurs de Profession Pigiste, avec Romain Saillet comme référent, chaque équipe élabore le squelette d’un projet éditorial.

[/av_heading]
[/av_one_full]

[av_one_fourth first]
[av_icon_box icon=\'ue80d\' font=\'entypo-fontello\' position=\'left\' title=\'Webdocumentaire\' link=\'\' linktarget=\'\' linkelement=\'\']Cliquer ici pour ajouter votre propre texte

[/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue83b\' font=\'entypo-fontello\' position=\'left\' title=\'Reportage\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue8ab\' font=\'entypo-fontello\' position=\'left\' title=\'Journalisme de données\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue833\' font=\'entypo-fontello\' position=\'left\' title=\'Long format\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h30 : Pause\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'17h : Présentation de l’Afdas\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'10\' heading=\'17h20 : Restitution des ateliers\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Chaque équipe a cinq minutes pour « pitcher » le projet sur lequel elle a travaillé et le présenter aux participants de son groupe. Chaque groupe élit le meilleur projet.
[/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'18h20 : Un moment de liberté\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'19h : Apéritif\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'20h30 : Dîner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec une intervention de Gabriele Bertolli, de la direction générale de la DG Connect à la Commission européenne.
[/av_heading]

[av_button label=\'Voir le programme du vendredi\' link=\'page,1720\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'right\' icon_select=\'yes\' icon=\'ue832\' font=\'entypo-fontello\']

");
INSERT INTO `wp_postmeta` VALUES("1475","1574","_wp_attached_file","2013/04/48hbyPP.png");
INSERT INTO `wp_postmeta` VALUES("1476","1574","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1146;s:6:\"height\";i:606;s:4:\"file\";s:19:\"2013/04/48hbyPP.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"48hbyPP-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"48hbyPP-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x544.png\";s:5:\"width\";i:1030;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"48hbyPP-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"48hbyPP-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1146x430.png\";s:5:\"width\";i:1146;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"48hbyPP-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"48hbyPP-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"48hbyPP-705x372.png\";s:5:\"width\";i:705;s:6:\"height\";i:372;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"48hbyPP-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x237.png\";s:5:\"width\";i:450;s:6:\"height\";i:237;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1750","1734","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1749","1734","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1748","1734","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("429","1248","_dp_original","1236");
INSERT INTO `wp_postmeta` VALUES("4706","2443","_bbp_anonymous_name","levitra 20 mg price");
INSERT INTO `wp_postmeta` VALUES("4705","2442","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4693","2440","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4694","2441","_bbp_anonymous_name","purchase vardenafil");
INSERT INTO `wp_postmeta` VALUES("4695","2441","_bbp_anonymous_email","kjdnktwz@muxklcqk.com");
INSERT INTO `wp_postmeta` VALUES("4696","2441","_bbp_anonymous_website","http://generic-vardenafil.tk/#9144");
INSERT INTO `wp_postmeta` VALUES("4697","2441","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4698","2441","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4699","2441","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4700","2442","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("4701","2442","_bbp_anonymous_email","toiyrnkh@omivxvls.com");
INSERT INTO `wp_postmeta` VALUES("4702","2442","_bbp_anonymous_website","http://allipills.pw/#9004");
INSERT INTO `wp_postmeta` VALUES("4703","2442","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4704","2442","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4692","2440","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4674","2437","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4675","2437","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4676","2438","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("4677","2438","_bbp_anonymous_email","yeudausw@dcfzqzdx.com");
INSERT INTO `wp_postmeta` VALUES("4678","2438","_bbp_anonymous_website","http://prozac.in/#4734");
INSERT INTO `wp_postmeta` VALUES("4679","2438","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4680","2438","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4681","2438","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4682","2439","_bbp_anonymous_name","wellbutrin no prescription");
INSERT INTO `wp_postmeta` VALUES("4683","2439","_bbp_anonymous_email","gmghflhv@nwsmywkb.com");
INSERT INTO `wp_postmeta` VALUES("4684","2439","_bbp_anonymous_website","http://wellbutrin150mg.tk/#6426");
INSERT INTO `wp_postmeta` VALUES("4685","2439","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4686","2439","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4687","2439","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4688","2440","_bbp_anonymous_name","generic celexa");
INSERT INTO `wp_postmeta` VALUES("4689","2440","_bbp_anonymous_email","wahxxaap@moqtbeeb.com");
INSERT INTO `wp_postmeta` VALUES("4690","2440","_bbp_anonymous_website","http://celexageneric.ml/#4641");
INSERT INTO `wp_postmeta` VALUES("4691","2440","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4673","2437","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4671","2437","_bbp_anonymous_email","ypzuuser@gntpdcex.com");
INSERT INTO `wp_postmeta` VALUES("4670","2437","_bbp_anonymous_name","cost of xenical");
INSERT INTO `wp_postmeta` VALUES("4551","2417","_bbp_anonymous_email","vqcsxegv@qkcjgqdh.com");
INSERT INTO `wp_postmeta` VALUES("4552","2417","_bbp_anonymous_website","http://accutaneforsale.ml/#8976");
INSERT INTO `wp_postmeta` VALUES("4553","2417","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4554","2417","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4555","2417","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4556","2418","_bbp_anonymous_name","order amoxil online");
INSERT INTO `wp_postmeta` VALUES("4557","2418","_bbp_anonymous_email","fyhuwmut@qoykcsxm.com");
INSERT INTO `wp_postmeta` VALUES("4558","2418","_bbp_anonymous_website","http://amoxil.in/#3051");
INSERT INTO `wp_postmeta` VALUES("4559","2418","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4560","2418","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4561","2418","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4562","2419","_bbp_anonymous_name","generic sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("4563","2419","_bbp_anonymous_email","bisubzhm@dqqsrzrm.com");
INSERT INTO `wp_postmeta` VALUES("4564","2419","_bbp_anonymous_website","http://genericsildenafilcitrate.ml/#2549");
INSERT INTO `wp_postmeta` VALUES("4565","2419","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4566","2419","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4567","2419","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4568","2420","_bbp_anonymous_name","viagra online sales");
INSERT INTO `wp_postmeta` VALUES("4569","2420","_bbp_anonymous_email","zrnpslcw@dpznvmmh.com");
INSERT INTO `wp_postmeta` VALUES("4570","2420","_bbp_anonymous_website","http://viagraonlinesales.pw/#8993");
INSERT INTO `wp_postmeta` VALUES("4571","2420","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4572","2420","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4573","2420","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4574","2421","_bbp_anonymous_name","sildenafil otc");
INSERT INTO `wp_postmeta` VALUES("4575","2421","_bbp_anonymous_email","mcplpfpt@kbywyykc.com");
INSERT INTO `wp_postmeta` VALUES("4576","2421","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#2951");
INSERT INTO `wp_postmeta` VALUES("4577","2421","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4578","2421","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4579","2421","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4580","2422","_bbp_anonymous_name","celebrex prices");
INSERT INTO `wp_postmeta` VALUES("4581","2422","_bbp_anonymous_email","zmzzzjzy@rxchsfsk.com");
INSERT INTO `wp_postmeta` VALUES("4582","2422","_bbp_anonymous_website","http://celebrexcost.ml/#1986");
INSERT INTO `wp_postmeta` VALUES("4583","2422","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4584","2422","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4585","2422","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4586","2423","_bbp_anonymous_name","buy cialis online cheap");
INSERT INTO `wp_postmeta` VALUES("4587","2423","_bbp_anonymous_email","nkikxrtu@elnyztvc.com");
INSERT INTO `wp_postmeta` VALUES("4588","2423","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#8558");
INSERT INTO `wp_postmeta` VALUES("4589","2423","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4590","2423","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4591","2423","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4592","2424","_bbp_anonymous_name","buy prednisone without a prescription");
INSERT INTO `wp_postmeta` VALUES("4593","2424","_bbp_anonymous_email","ekgxmvkj@yehibexn.com");
INSERT INTO `wp_postmeta` VALUES("4594","2424","_bbp_anonymous_website","http://prednisone20mgmedication.cf/#5157");
INSERT INTO `wp_postmeta` VALUES("4595","2424","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4596","2424","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4597","2424","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4598","2425","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("4599","2425","_bbp_anonymous_email","qyqelbft@efczagrq.com");
INSERT INTO `wp_postmeta` VALUES("4600","2425","_bbp_anonymous_website","http://advair-diskus.ml/#4940");
INSERT INTO `wp_postmeta` VALUES("4601","2425","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4602","2425","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4603","2425","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4604","2426","_bbp_anonymous_name","generic accutane");
INSERT INTO `wp_postmeta` VALUES("4605","2426","_bbp_anonymous_email","wsoitsgc@rdmvxfkn.com");
INSERT INTO `wp_postmeta` VALUES("4606","2426","_bbp_anonymous_website","http://genericaccutane.nu/#9592");
INSERT INTO `wp_postmeta` VALUES("4607","2426","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4608","2426","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4609","2426","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4610","2427","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4611","2427","_bbp_anonymous_email","upvpmkxu@acooexjj.com");
INSERT INTO `wp_postmeta` VALUES("4612","2427","_bbp_anonymous_website","http://zithromaxzpack.ml/#5163");
INSERT INTO `wp_postmeta` VALUES("4613","2427","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4614","2427","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4615","2427","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4616","2428","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4617","2428","_bbp_anonymous_email","doiojtlo@fczkmcht.com");
INSERT INTO `wp_postmeta` VALUES("4618","2428","_bbp_anonymous_website","http://cialisprescription.ml/#2064");
INSERT INTO `wp_postmeta` VALUES("4619","2428","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4620","2428","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4621","2428","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4622","2429","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("4623","2429","_bbp_anonymous_email","dteoouhv@rphwnlgl.com");
INSERT INTO `wp_postmeta` VALUES("4624","2429","_bbp_anonymous_website","http://buymobic.se/#6888");
INSERT INTO `wp_postmeta` VALUES("4625","2429","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4626","2429","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4627","2429","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4628","2430","_bbp_anonymous_name","clindamycin");
INSERT INTO `wp_postmeta` VALUES("4629","2430","_bbp_anonymous_email","pfurgqjh@qrlvnqks.com");
INSERT INTO `wp_postmeta` VALUES("4630","2430","_bbp_anonymous_website","http://cleocint.tk/#2865");
INSERT INTO `wp_postmeta` VALUES("4631","2430","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4632","2430","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4633","2430","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4634","2431","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4635","2431","_bbp_anonymous_email","bzzolrrf@dblbnfni.com");
INSERT INTO `wp_postmeta` VALUES("4636","2431","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#6562");
INSERT INTO `wp_postmeta` VALUES("4637","2431","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4638","2431","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4639","2431","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4640","2432","_bbp_anonymous_name","doxy 200");
INSERT INTO `wp_postmeta` VALUES("4641","2432","_bbp_anonymous_email","tqftblhv@tpcyuaoo.com");
INSERT INTO `wp_postmeta` VALUES("4642","2432","_bbp_anonymous_website","http://doxy.cf/#1974");
INSERT INTO `wp_postmeta` VALUES("4643","2432","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4644","2432","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4645","2432","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4646","2433","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("4647","2433","_bbp_anonymous_email","wtddbqrb@mplhjxhv.com");
INSERT INTO `wp_postmeta` VALUES("4648","2433","_bbp_anonymous_website","http://buyventolininhaler.cf/#3534");
INSERT INTO `wp_postmeta` VALUES("4649","2433","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4650","2433","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4651","2433","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4652","2434","_bbp_anonymous_name","alli 120");
INSERT INTO `wp_postmeta` VALUES("4653","2434","_bbp_anonymous_email","kymybnwe@tihythwh.com");
INSERT INTO `wp_postmeta` VALUES("4654","2434","_bbp_anonymous_website","http://alli-120.cf/#8219");
INSERT INTO `wp_postmeta` VALUES("4655","2434","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4656","2434","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4657","2434","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4658","2435","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("4659","2435","_bbp_anonymous_email","znzvtkpt@oncprzoa.com");
INSERT INTO `wp_postmeta` VALUES("4660","2435","_bbp_anonymous_website","http://celebrex200.cf/#7731");
INSERT INTO `wp_postmeta` VALUES("4661","2435","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4662","2435","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4663","2435","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4664","2436","_bbp_anonymous_name","alli buy");
INSERT INTO `wp_postmeta` VALUES("4665","2436","_bbp_anonymous_email","dekmwono@fmwdsqnm.com");
INSERT INTO `wp_postmeta` VALUES("4666","2436","_bbp_anonymous_website","http://alli-diet-pill.cf/#4584");
INSERT INTO `wp_postmeta` VALUES("4667","2436","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4668","2436","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4669","2436","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4550","2417","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("4536","2414","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4537","2414","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4538","2415","_bbp_anonymous_name","how much is doxycycline");
INSERT INTO `wp_postmeta` VALUES("4539","2415","_bbp_anonymous_email","gtumhice@pfelativ.com");
INSERT INTO `wp_postmeta` VALUES("4540","2415","_bbp_anonymous_website","http://buy-doxycycline.us/#2960");
INSERT INTO `wp_postmeta` VALUES("4541","2415","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4542","2415","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4543","2415","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4544","2416","_bbp_anonymous_name","generic lexapro");
INSERT INTO `wp_postmeta` VALUES("4545","2416","_bbp_anonymous_email","lzblszit@napahgfc.com");
INSERT INTO `wp_postmeta` VALUES("4546","2416","_bbp_anonymous_website","http://generic-lexapro.cf/#3564");
INSERT INTO `wp_postmeta` VALUES("4547","2416","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4548","2416","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4549","2416","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4427","2396","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4428","2396","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4429","2396","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4430","2397","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("4431","2397","_bbp_anonymous_email","ewdrlgpm@pytkxrap.com");
INSERT INTO `wp_postmeta` VALUES("4432","2397","_bbp_anonymous_website","http://cheapnexium.tk/#6469");
INSERT INTO `wp_postmeta` VALUES("4433","2397","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4434","2397","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4435","2397","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4436","2398","_bbp_anonymous_name","accutane 30mg");
INSERT INTO `wp_postmeta` VALUES("4437","2398","_bbp_anonymous_email","rgjusuir@iqchnddz.com");
INSERT INTO `wp_postmeta` VALUES("4438","2398","_bbp_anonymous_website","http://buyaccutaneonline.tk/#3590");
INSERT INTO `wp_postmeta` VALUES("4439","2398","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4440","2398","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4441","2398","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4442","2399","_bbp_anonymous_name","more information");
INSERT INTO `wp_postmeta` VALUES("4443","2399","_bbp_anonymous_email","pdcsiobd@oaihwtnj.com");
INSERT INTO `wp_postmeta` VALUES("4444","2399","_bbp_anonymous_website","http://furosemide-40-mg-diuretic.cf/#1968");
INSERT INTO `wp_postmeta` VALUES("4445","2399","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4446","2399","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4447","2399","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4448","2400","_bbp_anonymous_name","purchase wellbutrin online");
INSERT INTO `wp_postmeta` VALUES("4449","2400","_bbp_anonymous_email","opjjhvkg@tlkbktdj.com");
INSERT INTO `wp_postmeta` VALUES("4450","2400","_bbp_anonymous_website","http://wellbutrinxl300mg.ml/#3334");
INSERT INTO `wp_postmeta` VALUES("4451","2400","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4452","2400","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4453","2400","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4454","2401","_bbp_anonymous_name","lexapro generic");
INSERT INTO `wp_postmeta` VALUES("4455","2401","_bbp_anonymous_email","crmshidx@izhjrlys.com");
INSERT INTO `wp_postmeta` VALUES("4456","2401","_bbp_anonymous_website","http://lexaprogeneric.ga/#5733");
INSERT INTO `wp_postmeta` VALUES("4457","2401","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4458","2401","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4459","2401","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4460","2402","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("4461","2402","_bbp_anonymous_email","lrfkfryy@wrsajcqm.com");
INSERT INTO `wp_postmeta` VALUES("4462","2402","_bbp_anonymous_website","http://cialisforsaleonline.tk/#3201");
INSERT INTO `wp_postmeta` VALUES("4463","2402","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4464","2402","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4465","2402","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4466","2403","_bbp_anonymous_name","generic of augmentin");
INSERT INTO `wp_postmeta` VALUES("4467","2403","_bbp_anonymous_email","orhjgzcl@ubystdro.com");
INSERT INTO `wp_postmeta` VALUES("4468","2403","_bbp_anonymous_website","http://genericforaugmentin.tk/#3530");
INSERT INTO `wp_postmeta` VALUES("4469","2403","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4470","2403","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4471","2403","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4472","2404","_bbp_anonymous_name","where to get cialis online");
INSERT INTO `wp_postmeta` VALUES("4473","2404","_bbp_anonymous_email","yxokvfum@vecjiasr.com");
INSERT INTO `wp_postmeta` VALUES("4474","2404","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#1050");
INSERT INTO `wp_postmeta` VALUES("4475","2404","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4476","2404","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4477","2404","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4478","2405","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("4479","2405","_bbp_anonymous_email","graqnxfd@gtljoryj.com");
INSERT INTO `wp_postmeta` VALUES("4480","2405","_bbp_anonymous_website","http://cephalexin500.cf/#4328");
INSERT INTO `wp_postmeta` VALUES("4481","2405","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4482","2405","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4483","2405","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4484","2406","_bbp_anonymous_name","zoloft");
INSERT INTO `wp_postmeta` VALUES("4485","2406","_bbp_anonymous_email","egyecibe@wuetkkwb.com");
INSERT INTO `wp_postmeta` VALUES("4486","2406","_bbp_anonymous_website","http://zoloft200mg.tk/#2572");
INSERT INTO `wp_postmeta` VALUES("4487","2406","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4488","2406","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4489","2406","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4490","2407","_bbp_anonymous_name","synthroid cost");
INSERT INTO `wp_postmeta` VALUES("4491","2407","_bbp_anonymous_email","nkqnuagf@uhsewwka.com");
INSERT INTO `wp_postmeta` VALUES("4492","2407","_bbp_anonymous_website","http://synthroid-generic.tk/#3175");
INSERT INTO `wp_postmeta` VALUES("4493","2407","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4494","2407","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4495","2407","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4496","2408","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("4497","2408","_bbp_anonymous_email","mdoocasw@uggfwsou.com");
INSERT INTO `wp_postmeta` VALUES("4498","2408","_bbp_anonymous_website","http://buy-propecia.cf/#9340");
INSERT INTO `wp_postmeta` VALUES("4499","2408","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4500","2408","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4501","2408","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4502","2409","_bbp_anonymous_name","alli pills");
INSERT INTO `wp_postmeta` VALUES("4503","2409","_bbp_anonymous_email","bnujiiyc@oikwleak.com");
INSERT INTO `wp_postmeta` VALUES("4504","2409","_bbp_anonymous_website","http://alli-pills.cf/#6505");
INSERT INTO `wp_postmeta` VALUES("4505","2409","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4506","2409","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4507","2409","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4508","2410","_bbp_anonymous_name","how to buy buproprion on line");
INSERT INTO `wp_postmeta` VALUES("4509","2410","_bbp_anonymous_email","isjefibv@vvwbkrfz.com");
INSERT INTO `wp_postmeta` VALUES("4510","2410","_bbp_anonymous_website","http://bupropionxl300.cf/#9625");
INSERT INTO `wp_postmeta` VALUES("4511","2410","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4512","2410","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4513","2410","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4514","2411","_bbp_anonymous_name","cheap prednisone online");
INSERT INTO `wp_postmeta` VALUES("4515","2411","_bbp_anonymous_email","tdxntmpp@ubxzwsdn.com");
INSERT INTO `wp_postmeta` VALUES("4516","2411","_bbp_anonymous_website","http://cheapprednisoneonline.tk/#4784");
INSERT INTO `wp_postmeta` VALUES("4517","2411","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4518","2411","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4519","2411","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4520","2412","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("4521","2412","_bbp_anonymous_email","qgqwvpuo@ylsbyjqn.com");
INSERT INTO `wp_postmeta` VALUES("4522","2412","_bbp_anonymous_website","http://genericzithromax.se/#8608");
INSERT INTO `wp_postmeta` VALUES("4523","2412","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4524","2412","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4525","2412","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4526","2413","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("4527","2413","_bbp_anonymous_email","irgscyzu@scoswriy.com");
INSERT INTO `wp_postmeta` VALUES("4528","2413","_bbp_anonymous_website","http://discountlevitra.pw/#1201");
INSERT INTO `wp_postmeta` VALUES("4529","2413","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4530","2413","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4531","2413","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4532","2414","_bbp_anonymous_name","effexor");
INSERT INTO `wp_postmeta` VALUES("4533","2414","_bbp_anonymous_email","oswqqylj@titndzqa.com");
INSERT INTO `wp_postmeta` VALUES("4534","2414","_bbp_anonymous_website","http://genericforeffexor.cf/#8801");
INSERT INTO `wp_postmeta` VALUES("4535","2414","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("1572","821","_edit_lock","1427966762:3");
INSERT INTO `wp_postmeta` VALUES("1573","821","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1575","1629","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1576","1629","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("6683","2772","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6682","2772","_bbp_anonymous_website","http://nolvadex-xt.tk/#4032");
INSERT INTO `wp_postmeta` VALUES("6622","2762","_bbp_anonymous_website","http://cheapaccutane.ml/#8666");
INSERT INTO `wp_postmeta` VALUES("6623","2762","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6624","2762","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6625","2762","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6626","2763","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("6627","2763","_bbp_anonymous_email","sfsdgmxx@osdxkdhn.com");
INSERT INTO `wp_postmeta` VALUES("6628","2763","_bbp_anonymous_website","http://genericsildenafil.us/#1243");
INSERT INTO `wp_postmeta` VALUES("6629","2763","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6630","2763","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6631","2763","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6632","2764","_bbp_anonymous_name","tadalafil 20 mg");
INSERT INTO `wp_postmeta` VALUES("6633","2764","_bbp_anonymous_email","ckiqasny@znhfeqzp.com");
INSERT INTO `wp_postmeta` VALUES("6634","2764","_bbp_anonymous_website","http://tadalafil20mg.tk/#2664");
INSERT INTO `wp_postmeta` VALUES("6635","2764","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6636","2764","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6637","2764","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6638","2765","_bbp_anonymous_name","find out more");
INSERT INTO `wp_postmeta` VALUES("6639","2765","_bbp_anonymous_email","xccwohbd@uqvilehe.com");
INSERT INTO `wp_postmeta` VALUES("6640","2765","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#6391");
INSERT INTO `wp_postmeta` VALUES("6641","2765","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6642","2765","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6643","2765","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6644","2766","_bbp_anonymous_name","celebrex 200");
INSERT INTO `wp_postmeta` VALUES("6645","2766","_bbp_anonymous_email","ellanmfi@kdvzrupa.com");
INSERT INTO `wp_postmeta` VALUES("6646","2766","_bbp_anonymous_website","http://celebrex200.cf/#3121");
INSERT INTO `wp_postmeta` VALUES("6647","2766","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6648","2766","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6649","2766","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6650","2767","_bbp_anonymous_name","lexapro no prescription");
INSERT INTO `wp_postmeta` VALUES("6651","2767","_bbp_anonymous_email","gamdaury@jklnycaf.com");
INSERT INTO `wp_postmeta` VALUES("6652","2767","_bbp_anonymous_website","http://generic-lexapro.cf/#8131");
INSERT INTO `wp_postmeta` VALUES("6653","2767","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6654","2767","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6655","2767","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6656","2768","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6657","2768","_bbp_anonymous_email","pqdtywzt@arsyomyx.com");
INSERT INTO `wp_postmeta` VALUES("6658","2768","_bbp_anonymous_website","http://generic-sildenafil.nu/#8470");
INSERT INTO `wp_postmeta` VALUES("6659","2768","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6660","2768","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6661","2768","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6662","2769","_bbp_anonymous_name","wow gold");
INSERT INTO `wp_postmeta` VALUES("6663","2769","_bbp_anonymous_email","gcggnnu@gmail.com");
INSERT INTO `wp_postmeta` VALUES("6664","2769","_bbp_anonymous_website","http://www.wowruler.com");
INSERT INTO `wp_postmeta` VALUES("6665","2769","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6666","2769","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("6667","2769","_bbp_author_ip","74.91.20.250");
INSERT INTO `wp_postmeta` VALUES("6668","2770","_bbp_anonymous_name","viagra by phone");
INSERT INTO `wp_postmeta` VALUES("6669","2770","_bbp_anonymous_email","vmtqxadv@zsbwbmxl.com");
INSERT INTO `wp_postmeta` VALUES("6670","2770","_bbp_anonymous_website","http://viagr.ml/#1906");
INSERT INTO `wp_postmeta` VALUES("6671","2770","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6672","2770","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6673","2770","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6674","2771","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("6675","2771","_bbp_anonymous_email","wzgsxnfp@vvfwbekt.com");
INSERT INTO `wp_postmeta` VALUES("6676","2771","_bbp_anonymous_website","http://tadalafil.in/#3767");
INSERT INTO `wp_postmeta` VALUES("6677","2771","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6678","2771","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6679","2771","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6680","2772","_bbp_anonymous_name","nolvadex xt");
INSERT INTO `wp_postmeta` VALUES("6681","2772","_bbp_anonymous_email","psfncbec@fxfovqtf.com");
INSERT INTO `wp_postmeta` VALUES("6621","2762","_bbp_anonymous_email","tcwtyrcg@ayftdztl.com");
INSERT INTO `wp_postmeta` VALUES("6485","2739","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6486","2739","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6487","2739","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6488","2740","_bbp_anonymous_name","cost of cipro");
INSERT INTO `wp_postmeta` VALUES("6489","2740","_bbp_anonymous_email","njgeuakq@cufsfgav.com");
INSERT INTO `wp_postmeta` VALUES("6490","2740","_bbp_anonymous_website","http://ciprocost.cf/#8302");
INSERT INTO `wp_postmeta` VALUES("6491","2740","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6492","2740","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6493","2740","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6494","2741","_bbp_anonymous_name","accutane generic");
INSERT INTO `wp_postmeta` VALUES("6495","2741","_bbp_anonymous_email","slrwwllz@aqaegeuv.com");
INSERT INTO `wp_postmeta` VALUES("6496","2741","_bbp_anonymous_website","http://accutanegeneric.pw/#2797");
INSERT INTO `wp_postmeta` VALUES("6497","2741","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6498","2741","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6499","2741","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6500","2742","_bbp_anonymous_name","aldeamentopeixinhosalentejo");
INSERT INTO `wp_postmeta` VALUES("6501","2742","_bbp_anonymous_email","ffjewrzf@gmail.com");
INSERT INTO `wp_postmeta` VALUES("6502","2742","_bbp_anonymous_website","http://www.aldeamentopeixinhosalentejo.com/");
INSERT INTO `wp_postmeta` VALUES("6503","2742","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6504","2742","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("6505","2742","_bbp_author_ip","222.77.203.168");
INSERT INTO `wp_postmeta` VALUES("6506","2743","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("6507","2743","_bbp_anonymous_email","anhpyekx@rlrhflue.com");
INSERT INTO `wp_postmeta` VALUES("6508","2743","_bbp_anonymous_website","http://alli-drug.cf/#3986");
INSERT INTO `wp_postmeta` VALUES("6509","2743","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6510","2743","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6511","2743","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6512","2744","_bbp_anonymous_name","check this out");
INSERT INTO `wp_postmeta` VALUES("6513","2744","_bbp_anonymous_email","bjmofjtc@bnpzodag.com");
INSERT INTO `wp_postmeta` VALUES("6514","2744","_bbp_anonymous_website","http://vermox.ml/#9729");
INSERT INTO `wp_postmeta` VALUES("6515","2744","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6516","2744","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6517","2744","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6518","2745","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("6519","2745","_bbp_anonymous_email","mvmemwqt@gkhvamef.com");
INSERT INTO `wp_postmeta` VALUES("6520","2745","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#5076");
INSERT INTO `wp_postmeta` VALUES("6521","2745","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6522","2745","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6523","2745","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6524","2746","_bbp_anonymous_name","zithromax buy");
INSERT INTO `wp_postmeta` VALUES("6525","2746","_bbp_anonymous_email","fnpbpavc@fpqqplaq.com");
INSERT INTO `wp_postmeta` VALUES("6526","2746","_bbp_anonymous_website","http://zithromaxzpack.ml/#5104");
INSERT INTO `wp_postmeta` VALUES("6527","2746","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6528","2746","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6529","2746","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6530","2747","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6531","2747","_bbp_anonymous_email","ypqtcsud@akvrzmst.com");
INSERT INTO `wp_postmeta` VALUES("6532","2747","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#6288");
INSERT INTO `wp_postmeta` VALUES("6533","2747","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6534","2747","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6535","2747","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6536","2748","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("6537","2748","_bbp_anonymous_email","ultczhcn@rkludfid.com");
INSERT INTO `wp_postmeta` VALUES("6538","2748","_bbp_anonymous_website","http://cialisforsaleonline.tk/#2900");
INSERT INTO `wp_postmeta` VALUES("6539","2748","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6540","2748","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6541","2748","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6542","2749","_bbp_anonymous_name","generic cialis india");
INSERT INTO `wp_postmeta` VALUES("6543","2749","_bbp_anonymous_email","wzbjfrhm@uutxkktk.com");
INSERT INTO `wp_postmeta` VALUES("6544","2749","_bbp_anonymous_website","http://discountgenericcialis.tk/#4474");
INSERT INTO `wp_postmeta` VALUES("6545","2749","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6546","2749","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6547","2749","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6548","2750","_bbp_anonymous_name","amoxil 875");
INSERT INTO `wp_postmeta` VALUES("6549","2750","_bbp_anonymous_email","pnclnboz@jiaovtol.com");
INSERT INTO `wp_postmeta` VALUES("6550","2750","_bbp_anonymous_website","http://amoxil-875.ml/#9614");
INSERT INTO `wp_postmeta` VALUES("6551","2750","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6552","2750","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6553","2750","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6554","2751","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6555","2751","_bbp_anonymous_email","ywjrfdra@mkwyhxby.com");
INSERT INTO `wp_postmeta` VALUES("6556","2751","_bbp_anonymous_website","http://finasteride.ml/#5061");
INSERT INTO `wp_postmeta` VALUES("6557","2751","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6558","2751","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6559","2751","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6560","2752","_bbp_anonymous_name","viagra 30 pills");
INSERT INTO `wp_postmeta` VALUES("6561","2752","_bbp_anonymous_email","omsznygd@nsofvcwz.com");
INSERT INTO `wp_postmeta` VALUES("6562","2752","_bbp_anonymous_website","http://buyviagra-softtabs.ga/#8182");
INSERT INTO `wp_postmeta` VALUES("6563","2752","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6564","2752","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6565","2752","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6566","2753","_bbp_anonymous_name","cephalexin 500 mg capsule");
INSERT INTO `wp_postmeta` VALUES("6567","2753","_bbp_anonymous_email","ayayxfjz@raquuihp.com");
INSERT INTO `wp_postmeta` VALUES("6568","2753","_bbp_anonymous_website","http://cephalexin500.cf/#8939");
INSERT INTO `wp_postmeta` VALUES("6569","2753","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6570","2753","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6571","2753","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6572","2754","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6573","2754","_bbp_anonymous_email","blwiuqeo@smkqhnyq.com");
INSERT INTO `wp_postmeta` VALUES("6574","2754","_bbp_anonymous_website","http://buy-sildenafil-citrate.ml/#7281");
INSERT INTO `wp_postmeta` VALUES("6575","2754","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6576","2754","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6577","2754","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6578","2755","_bbp_anonymous_name","xenical");
INSERT INTO `wp_postmeta` VALUES("6579","2755","_bbp_anonymous_email","cgzxojqz@lfmpymgy.com");
INSERT INTO `wp_postmeta` VALUES("6580","2755","_bbp_anonymous_website","http://xenical-orlistat-120mg.cf/#8247");
INSERT INTO `wp_postmeta` VALUES("6581","2755","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6582","2755","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6583","2755","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6584","2756","_bbp_anonymous_name","levitra discount");
INSERT INTO `wp_postmeta` VALUES("6585","2756","_bbp_anonymous_email","waihrawk@xdnfowkv.com");
INSERT INTO `wp_postmeta` VALUES("6586","2756","_bbp_anonymous_website","http://discountlevitra.cf/#9881");
INSERT INTO `wp_postmeta` VALUES("6587","2756","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6588","2756","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6589","2756","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6590","2757","_bbp_anonymous_name","where to buy doxycycline online");
INSERT INTO `wp_postmeta` VALUES("6591","2757","_bbp_anonymous_email","mxnnzswz@ulyrvcky.com");
INSERT INTO `wp_postmeta` VALUES("6592","2757","_bbp_anonymous_website","http://buy-doxycycline.tk/#6883");
INSERT INTO `wp_postmeta` VALUES("6593","2757","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6594","2757","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6595","2757","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6596","2758","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("6597","2758","_bbp_anonymous_email","albvopgp@gxurqbcu.com");
INSERT INTO `wp_postmeta` VALUES("6598","2758","_bbp_anonymous_website","http://propeciahairgrowth.ga/#2433");
INSERT INTO `wp_postmeta` VALUES("6599","2758","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6600","2758","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6601","2758","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6602","2759","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("6603","2759","_bbp_anonymous_email","sjlkswij@otsjjlxf.com");
INSERT INTO `wp_postmeta` VALUES("6604","2759","_bbp_anonymous_website","http://mobic75mg.cf/#3890");
INSERT INTO `wp_postmeta` VALUES("6605","2759","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6606","2759","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6607","2759","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6608","2760","_bbp_anonymous_name","levitra 20");
INSERT INTO `wp_postmeta` VALUES("6609","2760","_bbp_anonymous_email","frnavkcb@zhdlqlte.com");
INSERT INTO `wp_postmeta` VALUES("6610","2760","_bbp_anonymous_website","http://levitra20.tk/#7137");
INSERT INTO `wp_postmeta` VALUES("6611","2760","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6612","2760","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6613","2760","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6614","2761","_bbp_anonymous_name","cialis tadalafil");
INSERT INTO `wp_postmeta` VALUES("6615","2761","_bbp_anonymous_email","wjtcjugc@pizrxgqt.com");
INSERT INTO `wp_postmeta` VALUES("6616","2761","_bbp_anonymous_website","http://cialistadalafil.cf/#1323");
INSERT INTO `wp_postmeta` VALUES("6617","2761","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6618","2761","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6619","2761","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6620","2762","_bbp_anonymous_name","where to buy accutane online");
INSERT INTO `wp_postmeta` VALUES("5138","2515","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("5137","2514","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5136","2514","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5135","2514","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5133","2514","_bbp_anonymous_email","srcqpihj@bdcrjmdr.com");
INSERT INTO `wp_postmeta` VALUES("5134","2514","_bbp_anonymous_website","http://buyamoxicillin.se/#3086");
INSERT INTO `wp_postmeta` VALUES("5132","2514","_bbp_anonymous_name","can i buy amoxicillin over the counter");
INSERT INTO `wp_postmeta` VALUES("6279","2705","_bbp_anonymous_email","zuatklbl@txaccvhs.com");
INSERT INTO `wp_postmeta` VALUES("6280","2705","_bbp_anonymous_website","http://buy-doxycycline.pw/#4263");
INSERT INTO `wp_postmeta` VALUES("6281","2705","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6282","2705","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6283","2705","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6284","2706","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("6285","2706","_bbp_anonymous_email","axugkhyp@wsqzgdvg.com");
INSERT INTO `wp_postmeta` VALUES("6286","2706","_bbp_anonymous_website","http://amoxil.in/#1465");
INSERT INTO `wp_postmeta` VALUES("6287","2706","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6288","2706","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6289","2706","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6290","2707","_bbp_anonymous_name","order acyclovir online");
INSERT INTO `wp_postmeta` VALUES("6291","2707","_bbp_anonymous_email","mvxszckx@jfqevbin.com");
INSERT INTO `wp_postmeta` VALUES("6292","2707","_bbp_anonymous_website","http://orderacyclovir.ml/#7763");
INSERT INTO `wp_postmeta` VALUES("6293","2707","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6294","2707","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6295","2707","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6296","2708","_bbp_anonymous_name","online cialis pharmacy");
INSERT INTO `wp_postmeta` VALUES("6297","2708","_bbp_anonymous_email","peakfuap@jyitjmwu.com");
INSERT INTO `wp_postmeta` VALUES("6298","2708","_bbp_anonymous_website","http://onlinecialis.ml/#6082");
INSERT INTO `wp_postmeta` VALUES("6299","2708","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6300","2708","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6301","2708","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6302","2709","_bbp_anonymous_name","buy cialis online cheap");
INSERT INTO `wp_postmeta` VALUES("6303","2709","_bbp_anonymous_email","hmqowmak@cwymuoli.com");
INSERT INTO `wp_postmeta` VALUES("6304","2709","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#5070");
INSERT INTO `wp_postmeta` VALUES("6305","2709","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6269","2703","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6270","2703","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6271","2703","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6272","2704","_bbp_anonymous_name","cheap alli pills");
INSERT INTO `wp_postmeta` VALUES("6273","2704","_bbp_anonymous_email","menimgex@ivxanifc.com");
INSERT INTO `wp_postmeta` VALUES("6274","2704","_bbp_anonymous_website","http://alli-diet-pill.cf/#2755");
INSERT INTO `wp_postmeta` VALUES("6275","2704","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6276","2704","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6277","2704","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6278","2705","_bbp_anonymous_name","buy doxycycline");
INSERT INTO `wp_postmeta` VALUES("6268","2703","_bbp_anonymous_website","http://vardenafil-hydrochloride.ml/#3042");
INSERT INTO `wp_postmeta` VALUES("6250","2700","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#4033");
INSERT INTO `wp_postmeta` VALUES("6251","2700","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6252","2700","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6253","2700","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6254","2701","_bbp_anonymous_name","prozac online");
INSERT INTO `wp_postmeta` VALUES("6255","2701","_bbp_anonymous_email","hpkkybmm@mfjtmcro.com");
INSERT INTO `wp_postmeta` VALUES("6256","2701","_bbp_anonymous_website","http://prozac.in/#6291");
INSERT INTO `wp_postmeta` VALUES("6257","2701","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6258","2701","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6259","2701","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6260","2702","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("6261","2702","_bbp_anonymous_email","txadsvrp@bxmaxppt.com");
INSERT INTO `wp_postmeta` VALUES("6262","2702","_bbp_anonymous_website","http://buymobic.se/#8750");
INSERT INTO `wp_postmeta` VALUES("6263","2702","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6264","2702","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6265","2702","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6266","2703","_bbp_anonymous_name","vardenafil hydrochloride");
INSERT INTO `wp_postmeta` VALUES("6267","2703","_bbp_anonymous_email","znvbyuhp@rplqrrac.com");
INSERT INTO `wp_postmeta` VALUES("6232","2697","_bbp_anonymous_website","http://doxy.cf/#5778");
INSERT INTO `wp_postmeta` VALUES("6233","2697","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6234","2697","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6235","2697","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6236","2698","_bbp_anonymous_name","amoxicillin tablets");
INSERT INTO `wp_postmeta` VALUES("6237","2698","_bbp_anonymous_email","kerxfpvv@uqhsnmat.com");
INSERT INTO `wp_postmeta` VALUES("6238","2698","_bbp_anonymous_website","http://buyamoxicillin.biz/#6803");
INSERT INTO `wp_postmeta` VALUES("6239","2698","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6240","2698","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6241","2698","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6242","2699","_bbp_anonymous_name","buy ventolin inhaler without prescription");
INSERT INTO `wp_postmeta` VALUES("6243","2699","_bbp_anonymous_email","ybhxhjkb@fhoerqul.com");
INSERT INTO `wp_postmeta` VALUES("6244","2699","_bbp_anonymous_website","http://buyventolininhaler.cf/#7669");
INSERT INTO `wp_postmeta` VALUES("6245","2699","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6246","2699","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6247","2699","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6248","2700","_bbp_anonymous_name","buy cialis/canada");
INSERT INTO `wp_postmeta` VALUES("6249","2700","_bbp_anonymous_email","dxkycksx@dexwnswq.com");
INSERT INTO `wp_postmeta` VALUES("6217","2694","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6218","2695","_bbp_anonymous_name","order retin a without a prescription");
INSERT INTO `wp_postmeta` VALUES("6219","2695","_bbp_anonymous_email","oeznuewj@czeenmmc.com");
INSERT INTO `wp_postmeta` VALUES("6220","2695","_bbp_anonymous_website","http://retina005cream.ml/#7761");
INSERT INTO `wp_postmeta` VALUES("6221","2695","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6222","2695","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6223","2695","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6224","2696","_bbp_anonymous_name","cheap albuterol");
INSERT INTO `wp_postmeta` VALUES("6225","2696","_bbp_anonymous_email","avyteqfm@ixtzpupj.com");
INSERT INTO `wp_postmeta` VALUES("6226","2696","_bbp_anonymous_website","http://albuterol.in/#2247");
INSERT INTO `wp_postmeta` VALUES("6227","2696","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6228","2696","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6229","2696","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6230","2697","_bbp_anonymous_name","doxy");
INSERT INTO `wp_postmeta` VALUES("6231","2697","_bbp_anonymous_email","bsraxtjh@edoqljvv.com");
INSERT INTO `wp_postmeta` VALUES("6199","2691","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6200","2692","_bbp_anonymous_name","mobic price");
INSERT INTO `wp_postmeta` VALUES("6201","2692","_bbp_anonymous_email","eaiznktt@fxxhuion.com");
INSERT INTO `wp_postmeta` VALUES("6202","2692","_bbp_anonymous_website","http://cheapmobic.pw/#7871");
INSERT INTO `wp_postmeta` VALUES("6203","2692","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6204","2692","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6205","2692","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6206","2693","_bbp_anonymous_name","valtrex pill");
INSERT INTO `wp_postmeta` VALUES("6207","2693","_bbp_anonymous_email","vpoayter@gwemttwb.com");
INSERT INTO `wp_postmeta` VALUES("6208","2693","_bbp_anonymous_website","http://valtrex-500-mg.ga/#6008");
INSERT INTO `wp_postmeta` VALUES("6209","2693","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6210","2693","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6211","2693","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6212","2694","_bbp_anonymous_name","bonuses");
INSERT INTO `wp_postmeta` VALUES("6213","2694","_bbp_anonymous_email","kkrhdcny@urkcnzys.com");
INSERT INTO `wp_postmeta` VALUES("6214","2694","_bbp_anonymous_website","http://furosemide-40-mg-diuretic.cf/#9032");
INSERT INTO `wp_postmeta` VALUES("6215","2694","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6216","2694","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6198","2691","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6197","2691","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6178","2688","_bbp_anonymous_website","http://buyamoxicillin500mg.ml/#9370");
INSERT INTO `wp_postmeta` VALUES("6179","2688","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6180","2688","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6181","2688","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6182","2689","_bbp_anonymous_name","continue");
INSERT INTO `wp_postmeta` VALUES("6183","2689","_bbp_anonymous_email","qabwynht@txxwjlth.com");
INSERT INTO `wp_postmeta` VALUES("6184","2689","_bbp_anonymous_website","http://alli-pills.cf/#8944");
INSERT INTO `wp_postmeta` VALUES("6185","2689","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6186","2689","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6187","2689","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6188","2690","_bbp_anonymous_name","generic prozac");
INSERT INTO `wp_postmeta` VALUES("6189","2690","_bbp_anonymous_email","qgqvzawd@mmmpgyxs.com");
INSERT INTO `wp_postmeta` VALUES("6190","2690","_bbp_anonymous_website","http://generic-prozac.pw/#1115");
INSERT INTO `wp_postmeta` VALUES("6191","2690","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6192","2690","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6193","2690","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6194","2691","_bbp_anonymous_name","lasix");
INSERT INTO `wp_postmeta` VALUES("6195","2691","_bbp_anonymous_email","kisofrpq@lrhloexm.com");
INSERT INTO `wp_postmeta` VALUES("6196","2691","_bbp_anonymous_website","http://lasixdrug.tk/#6671");
INSERT INTO `wp_postmeta` VALUES("5205","2526","_bbp_anonymous_email","gsgyafgl@fkgflnbs.com");
INSERT INTO `wp_postmeta` VALUES("5206","2526","_bbp_anonymous_website","http://ordercialisonline.ml/#6443");
INSERT INTO `wp_postmeta` VALUES("5207","2526","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5208","2526","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5209","2526","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5210","2527","_bbp_anonymous_name","celebrex buy");
INSERT INTO `wp_postmeta` VALUES("5211","2527","_bbp_anonymous_email","uvtnpmtv@twvrgoqj.com");
INSERT INTO `wp_postmeta` VALUES("5212","2527","_bbp_anonymous_website","http://buycelebrex.se/#8593");
INSERT INTO `wp_postmeta` VALUES("5213","2527","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5214","2527","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5215","2527","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5216","2528","_bbp_anonymous_name","buy amoxicillin");
INSERT INTO `wp_postmeta` VALUES("5217","2528","_bbp_anonymous_email","ahflngni@inknrwye.com");
INSERT INTO `wp_postmeta` VALUES("5218","2528","_bbp_anonymous_website","http://buyamoxicillin.se/#7034");
INSERT INTO `wp_postmeta` VALUES("5219","2528","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5220","2528","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5221","2528","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5222","2529","_bbp_anonymous_name","effexor");
INSERT INTO `wp_postmeta` VALUES("5223","2529","_bbp_anonymous_email","pgjnrrjc@vbtjqdzj.com");
INSERT INTO `wp_postmeta` VALUES("5224","2529","_bbp_anonymous_website","http://effexorxr150mg.pw/#1230");
INSERT INTO `wp_postmeta` VALUES("5225","2529","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5226","2529","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5227","2529","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5228","2530","_bbp_anonymous_name","cephalexin 500");
INSERT INTO `wp_postmeta` VALUES("5229","2530","_bbp_anonymous_email","bpokjcfx@hzoctdtb.com");
INSERT INTO `wp_postmeta` VALUES("5230","2530","_bbp_anonymous_website","http://cephalexin500.cf/#7085");
INSERT INTO `wp_postmeta` VALUES("5231","2530","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5232","2530","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5233","2530","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5234","2531","_bbp_anonymous_name","mobic 15mg tab");
INSERT INTO `wp_postmeta` VALUES("5235","2531","_bbp_anonymous_email","ctdqedks@mpukvhqc.com");
INSERT INTO `wp_postmeta` VALUES("5236","2531","_bbp_anonymous_website","http://buy-mobic.tk/#9713");
INSERT INTO `wp_postmeta` VALUES("5237","2531","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5238","2531","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5239","2531","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5240","2532","_bbp_anonymous_name","lexapro");
INSERT INTO `wp_postmeta` VALUES("5241","2532","_bbp_anonymous_email","wvukwdaj@jexadsst.com");
INSERT INTO `wp_postmeta` VALUES("5242","2532","_bbp_anonymous_website","http://lexaprogeneric.ga/#5075");
INSERT INTO `wp_postmeta` VALUES("5243","2532","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5244","2532","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5245","2532","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5246","2533","_bbp_anonymous_name","synthroid");
INSERT INTO `wp_postmeta` VALUES("5247","2533","_bbp_anonymous_email","impyzgxz@xdwlayfr.com");
INSERT INTO `wp_postmeta` VALUES("5248","2533","_bbp_anonymous_website","http://synthroid-generic.tk/#8591");
INSERT INTO `wp_postmeta` VALUES("5249","2533","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5250","2533","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5251","2533","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5252","2534","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5253","2534","_bbp_anonymous_email","oabfqjlg@ytekpvmz.com");
INSERT INTO `wp_postmeta` VALUES("5254","2534","_bbp_anonymous_website","http://cialus.tk/#3815");
INSERT INTO `wp_postmeta` VALUES("5255","2534","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5256","2534","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5257","2534","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5258","2535","_bbp_anonymous_name","fluconazole diflucan");
INSERT INTO `wp_postmeta` VALUES("5259","2535","_bbp_anonymous_email","fcsldkbl@jjgkhmvq.com");
INSERT INTO `wp_postmeta` VALUES("5260","2535","_bbp_anonymous_website","http://diflucanfluconazole.tk/#1460");
INSERT INTO `wp_postmeta` VALUES("5261","2535","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5262","2535","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5263","2535","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5264","2536","_bbp_anonymous_name","amoxicillin 500mg price");
INSERT INTO `wp_postmeta` VALUES("5265","2536","_bbp_anonymous_email","bayrslte@ytonmrnu.com");
INSERT INTO `wp_postmeta` VALUES("5266","2536","_bbp_anonymous_website","http://buyamoxicillinonline.cf/#3517");
INSERT INTO `wp_postmeta` VALUES("5267","2536","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5268","2536","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5204","2526","_bbp_anonymous_name","buy cialis canada review");
INSERT INTO `wp_postmeta` VALUES("5200","2525","_bbp_anonymous_website","http://orlistat120mg.ga/#6292");
INSERT INTO `wp_postmeta` VALUES("5201","2525","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5202","2525","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5203","2525","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5199","2525","_bbp_anonymous_email","cngrraps@okjlarsb.com");
INSERT INTO `wp_postmeta` VALUES("5198","2525","_bbp_anonymous_name","xenical medication");
INSERT INTO `wp_postmeta` VALUES("5197","2524","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5179","2521","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5180","2522","_bbp_anonymous_name","doxy");
INSERT INTO `wp_postmeta` VALUES("5181","2522","_bbp_anonymous_email","dngoejpf@uzwhuyra.com");
INSERT INTO `wp_postmeta` VALUES("5182","2522","_bbp_anonymous_website","http://doxy.cf/#1843");
INSERT INTO `wp_postmeta` VALUES("5183","2522","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5184","2522","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5185","2522","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5186","2523","_bbp_anonymous_name","where to buy alli pills");
INSERT INTO `wp_postmeta` VALUES("5187","2523","_bbp_anonymous_email","hcsjhgwo@yomhdtdq.com");
INSERT INTO `wp_postmeta` VALUES("5188","2523","_bbp_anonymous_website","http://allipill.ml/#7908");
INSERT INTO `wp_postmeta` VALUES("5189","2523","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5190","2523","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5191","2523","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5192","2524","_bbp_anonymous_name","ventolin");
INSERT INTO `wp_postmeta` VALUES("5193","2524","_bbp_anonymous_email","sfueznfq@ejpyigaa.com");
INSERT INTO `wp_postmeta` VALUES("5194","2524","_bbp_anonymous_website","http://buyventolininhaler.cf/#1802");
INSERT INTO `wp_postmeta` VALUES("5195","2524","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5196","2524","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5174","2521","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("5175","2521","_bbp_anonymous_email","ysdvgwvz@ngytwvfu.com");
INSERT INTO `wp_postmeta` VALUES("5176","2521","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#7718");
INSERT INTO `wp_postmeta` VALUES("5177","2521","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5178","2521","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5159","2518","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5160","2518","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5161","2518","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5162","2519","_bbp_anonymous_name","buy online viagra");
INSERT INTO `wp_postmeta` VALUES("5163","2519","_bbp_anonymous_email","plszbvlj@oiautpxq.com");
INSERT INTO `wp_postmeta` VALUES("5164","2519","_bbp_anonymous_website","http://viagrabuyonline.ga/#6496");
INSERT INTO `wp_postmeta` VALUES("5165","2519","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5166","2519","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5167","2519","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5168","2520","_bbp_anonymous_name","accutane canada 40mg");
INSERT INTO `wp_postmeta` VALUES("5169","2520","_bbp_anonymous_email","kszwosvx@bmvykxuj.com");
INSERT INTO `wp_postmeta` VALUES("5170","2520","_bbp_anonymous_website","http://cheapaccutane.ml/#3248");
INSERT INTO `wp_postmeta` VALUES("5171","2520","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5172","2520","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5173","2520","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5156","2518","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("5157","2518","_bbp_anonymous_email","csnmnoyb@izryozxb.com");
INSERT INTO `wp_postmeta` VALUES("5158","2518","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#6689");
INSERT INTO `wp_postmeta` VALUES("5155","2517","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5154","2517","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5149","2516","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5150","2517","_bbp_anonymous_name","online cialis");
INSERT INTO `wp_postmeta` VALUES("5151","2517","_bbp_anonymous_email","ojyprpor@xwpkpmjx.com");
INSERT INTO `wp_postmeta` VALUES("5152","2517","_bbp_anonymous_website","http://onlinecialis.ml/#7982");
INSERT INTO `wp_postmeta` VALUES("5153","2517","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5144","2516","_bbp_anonymous_name","doxycycline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("5145","2516","_bbp_anonymous_email","paqpceqo@bnqblpff.com");
INSERT INTO `wp_postmeta` VALUES("5146","2516","_bbp_anonymous_website","http://buy-doxycycline.pw/#7330");
INSERT INTO `wp_postmeta` VALUES("5147","2516","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5148","2516","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6484","2739","_bbp_anonymous_website","http://generic-viagra.info/#9493");
INSERT INTO `wp_postmeta` VALUES("5367","2553","_bbp_anonymous_email","zreptnbn@vmvdrssn.com");
INSERT INTO `wp_postmeta` VALUES("5366","2553","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5361","2552","_bbp_anonymous_email","jqzzvpkh@znlgnapn.com");
INSERT INTO `wp_postmeta` VALUES("5362","2552","_bbp_anonymous_website","http://wellbutrinmedication.cf/#1337");
INSERT INTO `wp_postmeta` VALUES("5363","2552","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5364","2552","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5365","2552","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5296","2541","_bbp_anonymous_website","http://wellbutrin150mg.ga/#4891");
INSERT INTO `wp_postmeta` VALUES("5297","2541","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5298","2541","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5299","2541","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5300","2542","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5301","2542","_bbp_anonymous_email","dewcnmra@lqljqxsd.com");
INSERT INTO `wp_postmeta` VALUES("5302","2542","_bbp_anonymous_website","http://buy-propecia.cf/#4573");
INSERT INTO `wp_postmeta` VALUES("5303","2542","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5304","2542","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5305","2542","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5306","2543","_bbp_anonymous_name","livitra");
INSERT INTO `wp_postmeta` VALUES("5307","2543","_bbp_anonymous_email","ugtyprjg@jodszkjm.com");
INSERT INTO `wp_postmeta` VALUES("5308","2543","_bbp_anonymous_website","http://levitra20.tk/#9826");
INSERT INTO `wp_postmeta` VALUES("5309","2543","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5310","2543","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5311","2543","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5312","2544","_bbp_anonymous_name","nexium drug");
INSERT INTO `wp_postmeta` VALUES("5313","2544","_bbp_anonymous_email","xchepycp@jjtqjpqc.com");
INSERT INTO `wp_postmeta` VALUES("5314","2544","_bbp_anonymous_website","http://nexiumdrug.ga/#9903");
INSERT INTO `wp_postmeta` VALUES("5315","2544","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5316","2544","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5317","2544","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5318","2545","_bbp_anonymous_name","retin a 0.05 cream");
INSERT INTO `wp_postmeta` VALUES("5319","2545","_bbp_anonymous_email","tkbvpwuh@yrgcrevq.com");
INSERT INTO `wp_postmeta` VALUES("5320","2545","_bbp_anonymous_website","http://retina005cream.ml/#1205");
INSERT INTO `wp_postmeta` VALUES("5321","2545","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5322","2545","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5323","2545","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5324","2546","_bbp_anonymous_name","buying cialis in canada");
INSERT INTO `wp_postmeta` VALUES("5325","2546","_bbp_anonymous_email","xjimwffz@iwppbqrn.com");
INSERT INTO `wp_postmeta` VALUES("5326","2546","_bbp_anonymous_website","http://genericcialisonlineinuk.ml/#4133");
INSERT INTO `wp_postmeta` VALUES("5327","2546","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5328","2546","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5329","2546","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5330","2547","_bbp_anonymous_name","strattera");
INSERT INTO `wp_postmeta` VALUES("5331","2547","_bbp_anonymous_email","oucibqoa@gfmviiau.com");
INSERT INTO `wp_postmeta` VALUES("5332","2547","_bbp_anonymous_website","http://purchasestattera.cf/#3534");
INSERT INTO `wp_postmeta` VALUES("5333","2547","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5334","2547","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5335","2547","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5336","2548","_bbp_anonymous_name","cipro cost");
INSERT INTO `wp_postmeta` VALUES("5337","2548","_bbp_anonymous_email","yebfcwat@sgfcddxi.com");
INSERT INTO `wp_postmeta` VALUES("5338","2548","_bbp_anonymous_website","http://ciprocost.cf/#3601");
INSERT INTO `wp_postmeta` VALUES("5339","2548","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5340","2548","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5341","2548","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5342","2549","_bbp_anonymous_name","elavil medication");
INSERT INTO `wp_postmeta` VALUES("5343","2549","_bbp_anonymous_email","nchofybs@kwilzkvb.com");
INSERT INTO `wp_postmeta` VALUES("5344","2549","_bbp_anonymous_website","http://amitriptylinehcl25mgtab.cf/#6573");
INSERT INTO `wp_postmeta` VALUES("5345","2549","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5346","2549","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5347","2549","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5348","2550","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("5349","2550","_bbp_anonymous_email","tsycpmdr@pyfuwxay.com");
INSERT INTO `wp_postmeta` VALUES("5350","2550","_bbp_anonymous_website","http://keflexantibiotic.cf/#8561");
INSERT INTO `wp_postmeta` VALUES("5351","2550","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5352","2550","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5353","2550","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5354","2551","_bbp_anonymous_name","livetra");
INSERT INTO `wp_postmeta` VALUES("5355","2551","_bbp_anonymous_email","latlqvtl@gxciumcu.com");
INSERT INTO `wp_postmeta` VALUES("5356","2551","_bbp_anonymous_website","http://discountlevitra.cf/#7034");
INSERT INTO `wp_postmeta` VALUES("5357","2551","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5358","2551","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5359","2551","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5360","2552","_bbp_anonymous_name","wellbutrin 75mg");
INSERT INTO `wp_postmeta` VALUES("5282","2539","_bbp_anonymous_name","buy sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("5283","2539","_bbp_anonymous_email","qsdbeink@lreffwuy.com");
INSERT INTO `wp_postmeta` VALUES("5284","2539","_bbp_anonymous_website","http://buy-sildenafil-citrate.ml/#9657");
INSERT INTO `wp_postmeta` VALUES("5285","2539","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5286","2539","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5287","2539","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5288","2540","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5289","2540","_bbp_anonymous_email","wlkgnloa@irdsehpw.com");
INSERT INTO `wp_postmeta` VALUES("5290","2540","_bbp_anonymous_website","http://tadalafil-no-prescription.cf/#7005");
INSERT INTO `wp_postmeta` VALUES("5291","2540","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5292","2540","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5293","2540","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5294","2541","_bbp_anonymous_name","wellbutrin 150 mg");
INSERT INTO `wp_postmeta` VALUES("5295","2541","_bbp_anonymous_email","cqlcbodo@obtqxgus.com");
INSERT INTO `wp_postmeta` VALUES("5277","2538","_bbp_anonymous_email","mvbeyoes@utvkdrjn.com");
INSERT INTO `wp_postmeta` VALUES("5278","2538","_bbp_anonymous_website","http://xenical-120-mg.cf/#9593");
INSERT INTO `wp_postmeta` VALUES("5279","2538","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5280","2538","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5281","2538","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5276","2538","_bbp_anonymous_name","xenical 120 mg");
INSERT INTO `wp_postmeta` VALUES("5271","2537","_bbp_anonymous_email","athzivqt@rnychlbj.com");
INSERT INTO `wp_postmeta` VALUES("5272","2537","_bbp_anonymous_website","http://keflex500.tk/#6646");
INSERT INTO `wp_postmeta` VALUES("5273","2537","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5274","2537","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5275","2537","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5514","2577","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5515","2577","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5516","2578","_bbp_anonymous_name","cheap xenical");
INSERT INTO `wp_postmeta` VALUES("5517","2578","_bbp_anonymous_email","bgojlurz@hwrmfshm.com");
INSERT INTO `wp_postmeta` VALUES("5518","2578","_bbp_anonymous_website","http://xenicalorlistat120mg.tk/#9632");
INSERT INTO `wp_postmeta` VALUES("5519","2578","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5520","2578","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5521","2578","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5522","2579","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("5523","2579","_bbp_anonymous_email","cyswkkpy@neuysoig.com");
INSERT INTO `wp_postmeta` VALUES("5524","2579","_bbp_anonymous_website","http://buy-viagra-soft-tabs.ga/#1315");
INSERT INTO `wp_postmeta` VALUES("5525","2579","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5526","2579","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5527","2579","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5509","2576","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5510","2577","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5511","2577","_bbp_anonymous_email","xrobnkiy@ubhfquno.com");
INSERT INTO `wp_postmeta` VALUES("5512","2577","_bbp_anonymous_website","http://cialis5mg.tk/#1103");
INSERT INTO `wp_postmeta` VALUES("5513","2577","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5422","2562","_bbp_anonymous_website","http://xenical-orlistat-120mg.tk/#4045");
INSERT INTO `wp_postmeta` VALUES("5423","2562","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5424","2562","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5425","2562","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5426","2563","_bbp_anonymous_name","buy prednisone online without a script");
INSERT INTO `wp_postmeta` VALUES("5427","2563","_bbp_anonymous_email","kzrlgdqi@cfarxbwu.com");
INSERT INTO `wp_postmeta` VALUES("5428","2563","_bbp_anonymous_website","http://prednisone20mgmedication.cf/#2466");
INSERT INTO `wp_postmeta` VALUES("5429","2563","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5430","2563","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5431","2563","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5432","2564","_bbp_anonymous_name","alli drug");
INSERT INTO `wp_postmeta` VALUES("5433","2564","_bbp_anonymous_email","kxgvfyue@vpjuwrdr.com");
INSERT INTO `wp_postmeta` VALUES("5434","2564","_bbp_anonymous_website","http://allidrug.cf/#2130");
INSERT INTO `wp_postmeta` VALUES("5435","2564","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5436","2564","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5437","2564","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5438","2565","_bbp_anonymous_name","effexor xr 150");
INSERT INTO `wp_postmeta` VALUES("5439","2565","_bbp_anonymous_email","onxguouk@kqdupboz.com");
INSERT INTO `wp_postmeta` VALUES("5440","2565","_bbp_anonymous_website","http://genericforeffexor.cf/#5161");
INSERT INTO `wp_postmeta` VALUES("5441","2565","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5442","2565","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5443","2565","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5444","2566","_bbp_anonymous_name","lexapro 5mg");
INSERT INTO `wp_postmeta` VALUES("5445","2566","_bbp_anonymous_email","ixiboaie@yqlysugu.com");
INSERT INTO `wp_postmeta` VALUES("5446","2566","_bbp_anonymous_website","http://lexapro5mg.ml/#6010");
INSERT INTO `wp_postmeta` VALUES("5447","2566","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5448","2566","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5449","2566","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5450","2567","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5451","2567","_bbp_anonymous_email","dhqrebuj@cuhjwqmm.com");
INSERT INTO `wp_postmeta` VALUES("5452","2567","_bbp_anonymous_website","http://genericsildenafilcitrate.ml/#9120");
INSERT INTO `wp_postmeta` VALUES("5453","2567","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5454","2567","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5455","2567","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5456","2568","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("5457","2568","_bbp_anonymous_email","iqvmwznj@knmifxxp.com");
INSERT INTO `wp_postmeta` VALUES("5458","2568","_bbp_anonymous_website","http://buy-levitra.ga/#2453");
INSERT INTO `wp_postmeta` VALUES("5459","2568","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5460","2568","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5461","2568","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5462","2569","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("5463","2569","_bbp_anonymous_email","nswhfrru@yvopzugy.com");
INSERT INTO `wp_postmeta` VALUES("5464","2569","_bbp_anonymous_website","http://buy-doxycycline.us/#7287");
INSERT INTO `wp_postmeta` VALUES("5465","2569","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5466","2569","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5467","2569","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5468","2570","_bbp_anonymous_name","accutane");
INSERT INTO `wp_postmeta` VALUES("5469","2570","_bbp_anonymous_email","vtdbogia@elymrtip.com");
INSERT INTO `wp_postmeta` VALUES("5470","2570","_bbp_anonymous_website","http://genericaccutane.nu/#8709");
INSERT INTO `wp_postmeta` VALUES("5471","2570","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5472","2570","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5473","2570","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5474","2571","_bbp_anonymous_name","propecia hair growth");
INSERT INTO `wp_postmeta` VALUES("5475","2571","_bbp_anonymous_email","uaetibdp@aomnzrfe.com");
INSERT INTO `wp_postmeta` VALUES("5476","2571","_bbp_anonymous_website","http://propeciahairgrowth.ga/#4973");
INSERT INTO `wp_postmeta` VALUES("5477","2571","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5478","2571","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5479","2571","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5480","2572","_bbp_anonymous_name","accutane without prescription");
INSERT INTO `wp_postmeta` VALUES("5481","2572","_bbp_anonymous_email","lbomeylz@tafmxhrv.com");
INSERT INTO `wp_postmeta` VALUES("5482","2572","_bbp_anonymous_website","http://buyaccutaneonline.tk/#6854");
INSERT INTO `wp_postmeta` VALUES("5483","2572","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5484","2572","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5485","2572","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5486","2573","_bbp_anonymous_name","mobic 7.5 mg");
INSERT INTO `wp_postmeta` VALUES("5487","2573","_bbp_anonymous_email","egxmthvd@enibwury.com");
INSERT INTO `wp_postmeta` VALUES("5488","2573","_bbp_anonymous_website","http://mobic75mg.tk/#3746");
INSERT INTO `wp_postmeta` VALUES("5489","2573","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5490","2573","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5491","2573","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5492","2574","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("5493","2574","_bbp_anonymous_email","mxlfqmbu@dbzivutz.com");
INSERT INTO `wp_postmeta` VALUES("5494","2574","_bbp_anonymous_website","http://celebrex200.cf/#5060");
INSERT INTO `wp_postmeta` VALUES("5495","2574","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5496","2574","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5497","2574","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5498","2575","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("5499","2575","_bbp_anonymous_email","kfglzntu@whfqbydd.com");
INSERT INTO `wp_postmeta` VALUES("5500","2575","_bbp_anonymous_website","http://buyretinaonline.ml/#1425");
INSERT INTO `wp_postmeta` VALUES("5501","2575","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5502","2575","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5503","2575","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5504","2576","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("5505","2576","_bbp_anonymous_email","vtdhmxhm@qltfgpqd.com");
INSERT INTO `wp_postmeta` VALUES("5506","2576","_bbp_anonymous_website","http://levitracoupons.ga/#1149");
INSERT INTO `wp_postmeta` VALUES("5507","2576","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5508","2576","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5421","2562","_bbp_anonymous_email","ajyupdoa@gcunrdow.com");
INSERT INTO `wp_postmeta` VALUES("5420","2562","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("5419","2561","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5418","2561","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5410","2560","_bbp_anonymous_website","http://cheapmobic.tk/#9561");
INSERT INTO `wp_postmeta` VALUES("5411","2560","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5412","2560","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5413","2560","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5414","2561","_bbp_anonymous_name","orlistat alli");
INSERT INTO `wp_postmeta` VALUES("5415","2561","_bbp_anonymous_email","skptedlh@hczqngbc.com");
INSERT INTO `wp_postmeta` VALUES("5416","2561","_bbp_anonymous_website","http://alli-120.tk/#6963");
INSERT INTO `wp_postmeta` VALUES("5417","2561","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5395","2557","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5396","2558","_bbp_anonymous_name","zithromax antibiotic");
INSERT INTO `wp_postmeta` VALUES("5397","2558","_bbp_anonymous_email","fhmnywkc@juvxixtg.com");
INSERT INTO `wp_postmeta` VALUES("5398","2558","_bbp_anonymous_website","http://buy-zithromax.info/#5611");
INSERT INTO `wp_postmeta` VALUES("5399","2558","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5400","2558","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5401","2558","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5402","2559","_bbp_anonymous_name","propecia hair loss");
INSERT INTO `wp_postmeta` VALUES("5403","2559","_bbp_anonymous_email","nrjzbqcb@ivvlexnm.com");
INSERT INTO `wp_postmeta` VALUES("5404","2559","_bbp_anonymous_website","http://propeciahairloss.cf/#8644");
INSERT INTO `wp_postmeta` VALUES("5405","2559","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5406","2559","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5407","2559","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5408","2560","_bbp_anonymous_name","cheap mobic");
INSERT INTO `wp_postmeta` VALUES("5409","2560","_bbp_anonymous_email","pqzqmysu@bhasvrzk.com");
INSERT INTO `wp_postmeta` VALUES("5381","2555","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5382","2555","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5383","2555","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5384","2556","_bbp_anonymous_name","clindamycin purchase online");
INSERT INTO `wp_postmeta` VALUES("5385","2556","_bbp_anonymous_email","znpmymyy@yuevnvqv.com");
INSERT INTO `wp_postmeta` VALUES("5386","2556","_bbp_anonymous_website","http://cleocint.tk/#7819");
INSERT INTO `wp_postmeta` VALUES("5387","2556","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5388","2556","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5389","2556","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5390","2557","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5391","2557","_bbp_anonymous_email","wwirdyoo@cabnvlba.com");
INSERT INTO `wp_postmeta` VALUES("5392","2557","_bbp_anonymous_website","http://alli-120.cf/#1033");
INSERT INTO `wp_postmeta` VALUES("5393","2557","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5394","2557","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5380","2555","_bbp_anonymous_website","http://buy-doxycycline.pw/#5837");
INSERT INTO `wp_postmeta` VALUES("5376","2554","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5377","2554","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5378","2555","_bbp_anonymous_name","doxycycline prices");
INSERT INTO `wp_postmeta` VALUES("5379","2555","_bbp_anonymous_email","fmhyyiwb@wzyyhobl.com");
INSERT INTO `wp_postmeta` VALUES("5375","2554","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5369","2553","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5370","2553","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5371","2553","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5372","2554","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5373","2554","_bbp_anonymous_email","itdoffed@ihwenmvd.com");
INSERT INTO `wp_postmeta` VALUES("5374","2554","_bbp_anonymous_website","http://buy-cialis.se/#7503");
INSERT INTO `wp_postmeta` VALUES("6483","2739","_bbp_anonymous_email","eefmayvo@ryukxuyd.com");
INSERT INTO `wp_postmeta` VALUES("6370","2720","_bbp_anonymous_website","http://lisinopril-generic.ga/#9157");
INSERT INTO `wp_postmeta` VALUES("6371","2720","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6372","2720","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6373","2720","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6374","2721","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("6361","2718","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6362","2719","_bbp_anonymous_name","amitriptyline hydrochloride");
INSERT INTO `wp_postmeta` VALUES("6363","2719","_bbp_anonymous_email","zwdfnkdk@lbihxxua.com");
INSERT INTO `wp_postmeta` VALUES("6364","2719","_bbp_anonymous_website","http://amitriptylinehydrochloride.ga/#5055");
INSERT INTO `wp_postmeta` VALUES("6365","2719","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6366","2719","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6367","2719","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6368","2720","_bbp_anonymous_name","lisinopril");
INSERT INTO `wp_postmeta` VALUES("6369","2720","_bbp_anonymous_email","gxoqrvsh@dcbewzpx.com");
INSERT INTO `wp_postmeta` VALUES("6347","2716","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6348","2716","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6349","2716","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6350","2717","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("6351","2717","_bbp_anonymous_email","egvwwtfw@tdyzivvq.com");
INSERT INTO `wp_postmeta` VALUES("6352","2717","_bbp_anonymous_website","http://allidrug.cf/#5435");
INSERT INTO `wp_postmeta` VALUES("6353","2717","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6354","2717","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6355","2717","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6356","2718","_bbp_anonymous_name","alli 120 capsules");
INSERT INTO `wp_postmeta` VALUES("6357","2718","_bbp_anonymous_email","jfyrhlmq@ftltmjwc.com");
INSERT INTO `wp_postmeta` VALUES("6358","2718","_bbp_anonymous_website","http://alli-120.tk/#9766");
INSERT INTO `wp_postmeta` VALUES("6359","2718","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6360","2718","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6333","2714","_bbp_anonymous_email","toichijl@qhweghks.com");
INSERT INTO `wp_postmeta` VALUES("6334","2714","_bbp_anonymous_website","http://buyaccutaneonline.tk/#8465");
INSERT INTO `wp_postmeta` VALUES("6335","2714","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6336","2714","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6337","2714","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6338","2715","_bbp_anonymous_name","cephalexin");
INSERT INTO `wp_postmeta` VALUES("6339","2715","_bbp_anonymous_email","bvjgvits@kxalvsjo.com");
INSERT INTO `wp_postmeta` VALUES("6340","2715","_bbp_anonymous_website","http://keflex500.tk/#8739");
INSERT INTO `wp_postmeta` VALUES("6341","2715","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6342","2715","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6343","2715","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6344","2716","_bbp_anonymous_name","how do i get propecia");
INSERT INTO `wp_postmeta` VALUES("6345","2716","_bbp_anonymous_email","qzggacav@nryvmkur.com");
INSERT INTO `wp_postmeta` VALUES("6346","2716","_bbp_anonymous_website","http://propeciahairloss.cf/#8004");
INSERT INTO `wp_postmeta` VALUES("6332","2714","_bbp_anonymous_name","buy accutane online");
INSERT INTO `wp_postmeta` VALUES("6328","2713","_bbp_anonymous_website","http://celebrexcost.ml/#9901");
INSERT INTO `wp_postmeta` VALUES("6329","2713","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6330","2713","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6331","2713","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6327","2713","_bbp_anonymous_email","wkrnfyko@kqzvuhmq.com");
INSERT INTO `wp_postmeta` VALUES("6322","2712","_bbp_anonymous_website","http://levitraprofessional20mg.tk/#9599");
INSERT INTO `wp_postmeta` VALUES("6323","2712","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6324","2712","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6325","2712","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6326","2713","_bbp_anonymous_name","celebrex international pharmacy no prescription");
INSERT INTO `wp_postmeta` VALUES("6308","2710","_bbp_anonymous_name","wellbutrin");
INSERT INTO `wp_postmeta` VALUES("6309","2710","_bbp_anonymous_email","lpxxyffc@dgsdvjeq.com");
INSERT INTO `wp_postmeta` VALUES("6310","2710","_bbp_anonymous_website","http://wellbutrinxl300mg.ml/#9206");
INSERT INTO `wp_postmeta` VALUES("6311","2710","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6312","2710","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6313","2710","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6314","2711","_bbp_anonymous_name","retin-a");
INSERT INTO `wp_postmeta` VALUES("6315","2711","_bbp_anonymous_email","rnflrisb@lprxctgr.com");
INSERT INTO `wp_postmeta` VALUES("6316","2711","_bbp_anonymous_website","http://buyretinaonline.ml/#7054");
INSERT INTO `wp_postmeta` VALUES("6317","2711","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6318","2711","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6319","2711","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6320","2712","_bbp_anonymous_name","levitra");
INSERT INTO `wp_postmeta` VALUES("6321","2712","_bbp_anonymous_email","hogtqxvw@pnjjzofv.com");
INSERT INTO `wp_postmeta` VALUES("5622","2595","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5623","2595","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5624","2596","_bbp_anonymous_name","ipledge program accutane prescription for sale");
INSERT INTO `wp_postmeta` VALUES("5625","2596","_bbp_anonymous_email","wvggujrt@aamsimaj.com");
INSERT INTO `wp_postmeta` VALUES("5626","2596","_bbp_anonymous_website","http://accutaneforsale.ml/#3634");
INSERT INTO `wp_postmeta` VALUES("5627","2596","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5628","2596","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5629","2596","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5605","2592","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5606","2593","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5607","2593","_bbp_anonymous_email","qjudcomu@jzaituzq.com");
INSERT INTO `wp_postmeta` VALUES("5608","2593","_bbp_anonymous_website","http://buycialisonline.ml/#3838");
INSERT INTO `wp_postmeta` VALUES("5609","2593","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5610","2593","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5611","2593","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5612","2594","_bbp_anonymous_name","buy generic viagra no prescription");
INSERT INTO `wp_postmeta` VALUES("5613","2594","_bbp_anonymous_email","zecdmquo@ltfletfr.com");
INSERT INTO `wp_postmeta` VALUES("5614","2594","_bbp_anonymous_website","http://viagrasofttabs50mg.ml/#4023");
INSERT INTO `wp_postmeta` VALUES("5615","2594","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5616","2594","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5617","2594","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5618","2595","_bbp_anonymous_name","where to buy accutane");
INSERT INTO `wp_postmeta` VALUES("5619","2595","_bbp_anonymous_email","arxuzaci@sdosppht.com");
INSERT INTO `wp_postmeta` VALUES("5620","2595","_bbp_anonymous_website","http://wheretopurchaseaccutane.cf/#8194");
INSERT INTO `wp_postmeta` VALUES("5621","2595","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5587","2589","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5588","2590","_bbp_anonymous_name","cheapest levitra");
INSERT INTO `wp_postmeta` VALUES("5589","2590","_bbp_anonymous_email","ltxmziep@mzblhcol.com");
INSERT INTO `wp_postmeta` VALUES("5590","2590","_bbp_anonymous_website","http://discountlevitra.pw/#9901");
INSERT INTO `wp_postmeta` VALUES("5591","2590","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5592","2590","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5593","2590","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5594","2591","_bbp_anonymous_name","lexapro onlin3");
INSERT INTO `wp_postmeta` VALUES("5595","2591","_bbp_anonymous_email","uxsitsyl@zdaskayg.com");
INSERT INTO `wp_postmeta` VALUES("5596","2591","_bbp_anonymous_website","http://generic-lexapro.cf/#2907");
INSERT INTO `wp_postmeta` VALUES("5597","2591","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5598","2591","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5599","2591","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5600","2592","_bbp_anonymous_name","cialis otc");
INSERT INTO `wp_postmeta` VALUES("5601","2592","_bbp_anonymous_email","bnoiooqw@xqipqowo.com");
INSERT INTO `wp_postmeta` VALUES("5602","2592","_bbp_anonymous_website","http://discountgenericcialis.tk/#2448");
INSERT INTO `wp_postmeta` VALUES("5603","2592","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5604","2592","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5575","2587","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5576","2588","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5577","2588","_bbp_anonymous_email","gjbmfdqc@enbyejkr.com");
INSERT INTO `wp_postmeta` VALUES("5578","2588","_bbp_anonymous_website","http://buyzithromax.info/#1985");
INSERT INTO `wp_postmeta` VALUES("5579","2588","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5580","2588","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5581","2588","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5582","2589","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5583","2589","_bbp_anonymous_email","asehvdtn@fljocflm.com");
INSERT INTO `wp_postmeta` VALUES("5584","2589","_bbp_anonymous_website","http://cialistadalafil.cf/#2993");
INSERT INTO `wp_postmeta` VALUES("5585","2589","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5586","2589","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5561","2585","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5562","2585","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5563","2585","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5564","2586","_bbp_anonymous_name","buy sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("5565","2586","_bbp_anonymous_email","wyzjpwgn@jodddytj.com");
INSERT INTO `wp_postmeta` VALUES("5566","2586","_bbp_anonymous_website","http://buysildenafilcitrate.cf/#8080");
INSERT INTO `wp_postmeta` VALUES("5567","2586","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5568","2586","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5569","2586","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5570","2587","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5571","2587","_bbp_anonymous_email","ancqutoz@tuyixicf.com");
INSERT INTO `wp_postmeta` VALUES("5572","2587","_bbp_anonymous_website","http://cialisforsaleonline.tk/#8221");
INSERT INTO `wp_postmeta` VALUES("5573","2587","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5574","2587","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5557","2584","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5558","2585","_bbp_anonymous_name","generic viagra");
INSERT INTO `wp_postmeta` VALUES("5559","2585","_bbp_anonymous_email","yidfdwwm@fezcdsnd.com");
INSERT INTO `wp_postmeta` VALUES("5560","2585","_bbp_anonymous_website","http://generic-viagra.info/#9856");
INSERT INTO `wp_postmeta` VALUES("5556","2584","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5555","2584","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5550","2583","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5551","2583","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5552","2584","_bbp_anonymous_name","effexor xr 75 mg");
INSERT INTO `wp_postmeta` VALUES("5553","2584","_bbp_anonymous_email","sgsgfmzr@sqrqvsly.com");
INSERT INTO `wp_postmeta` VALUES("5554","2584","_bbp_anonymous_website","http://venlafaxineeffexor.ml/#5620");
INSERT INTO `wp_postmeta` VALUES("5530","2580","_bbp_anonymous_website","http://wheretogetcialisonline.pw/#5932");
INSERT INTO `wp_postmeta` VALUES("5531","2580","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5532","2580","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5533","2580","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5534","2581","_bbp_anonymous_name","advair diskus");
INSERT INTO `wp_postmeta` VALUES("5535","2581","_bbp_anonymous_email","flrvijdt@syiqojqz.com");
INSERT INTO `wp_postmeta` VALUES("5536","2581","_bbp_anonymous_website","http://advair-diskus.ml/#3353");
INSERT INTO `wp_postmeta` VALUES("5537","2581","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5538","2581","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5539","2581","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5540","2582","_bbp_anonymous_name","nexium capsules");
INSERT INTO `wp_postmeta` VALUES("5541","2582","_bbp_anonymous_email","rsdghtsu@kwiioopt.com");
INSERT INTO `wp_postmeta` VALUES("5542","2582","_bbp_anonymous_website","http://nexiumdrug.cf/#1723");
INSERT INTO `wp_postmeta` VALUES("5543","2582","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5544","2582","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5545","2582","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5546","2583","_bbp_anonymous_name","propecia from canada");
INSERT INTO `wp_postmeta` VALUES("5547","2583","_bbp_anonymous_email","frytyfri@rajscnvy.com");
INSERT INTO `wp_postmeta` VALUES("5548","2583","_bbp_anonymous_website","http://finasteride.ga/#3661");
INSERT INTO `wp_postmeta` VALUES("5549","2583","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("1012","1373","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:198;s:4:\"file\";s:26:\"2013/04/Logo48hcyan-01.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-300x106.png\";s:5:\"width\";i:300;s:6:\"height\";i:106;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-495x198.png\";s:5:\"width\";i:495;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x198.png\";s:5:\"width\";i:450;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x159.png\";s:5:\"width\";i:450;s:6:\"height\";i:159;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("6482","2739","_bbp_anonymous_name","order generic viagra");
INSERT INTO `wp_postmeta` VALUES("5739","2615","_bbp_anonymous_email","wwfouqlk@wvslpgkc.com");
INSERT INTO `wp_postmeta` VALUES("5722","2612","_bbp_anonymous_website","http://nolvadex-xt.tk/#4121");
INSERT INTO `wp_postmeta` VALUES("5723","2612","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5724","2612","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5725","2612","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5726","2613","_bbp_anonymous_name","buy prozac online");
INSERT INTO `wp_postmeta` VALUES("5727","2613","_bbp_anonymous_email","tsztcxdl@biprnkae.com");
INSERT INTO `wp_postmeta` VALUES("5728","2613","_bbp_anonymous_website","http://prozac.in/#5847");
INSERT INTO `wp_postmeta` VALUES("5729","2613","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5730","2613","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5731","2613","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5732","2614","_bbp_anonymous_name","bupropion");
INSERT INTO `wp_postmeta` VALUES("5733","2614","_bbp_anonymous_email","cecsajyi@ttrvmbzg.com");
INSERT INTO `wp_postmeta` VALUES("5734","2614","_bbp_anonymous_website","http://bupropionxl300.cf/#1310");
INSERT INTO `wp_postmeta` VALUES("5735","2614","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5736","2614","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5737","2614","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5738","2615","_bbp_anonymous_name","amoxicillin");
INSERT INTO `wp_postmeta` VALUES("5704","2609","_bbp_anonymous_website","http://zoloft200mg.tk/#8978");
INSERT INTO `wp_postmeta` VALUES("5705","2609","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5706","2609","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5707","2609","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5708","2610","_bbp_anonymous_name","finasteride");
INSERT INTO `wp_postmeta` VALUES("5709","2610","_bbp_anonymous_email","dzpnnojo@pptbtyam.com");
INSERT INTO `wp_postmeta` VALUES("5710","2610","_bbp_anonymous_website","http://finasteride.ml/#4214");
INSERT INTO `wp_postmeta` VALUES("5711","2610","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5712","2610","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5713","2610","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5714","2611","_bbp_anonymous_name","valtrex");
INSERT INTO `wp_postmeta` VALUES("5715","2611","_bbp_anonymous_email","obzesvyd@ilrfevxz.com");
INSERT INTO `wp_postmeta` VALUES("5716","2611","_bbp_anonymous_website","http://valtrex-500-mg.ga/#8246");
INSERT INTO `wp_postmeta` VALUES("5717","2611","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5718","2611","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5719","2611","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5720","2612","_bbp_anonymous_name","where to buy nolvadex");
INSERT INTO `wp_postmeta` VALUES("5721","2612","_bbp_anonymous_email","yociqzag@azbqbhnh.com");
INSERT INTO `wp_postmeta` VALUES("5687","2606","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5688","2606","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5689","2606","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5690","2607","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5691","2607","_bbp_anonymous_email","zagqwiks@wgqrgafb.com");
INSERT INTO `wp_postmeta` VALUES("5692","2607","_bbp_anonymous_website","http://buy-tadalafil-online.cf/#2693");
INSERT INTO `wp_postmeta` VALUES("5693","2607","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5694","2607","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5695","2607","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5696","2608","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("5697","2608","_bbp_anonymous_email","zbrjxcxu@jkxemobi.com");
INSERT INTO `wp_postmeta` VALUES("5698","2608","_bbp_anonymous_website","http://genericsildenafil.us/#3436");
INSERT INTO `wp_postmeta` VALUES("5699","2608","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5700","2608","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5701","2608","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5702","2609","_bbp_anonymous_name","zoloft buy");
INSERT INTO `wp_postmeta` VALUES("5703","2609","_bbp_anonymous_email","luumfozv@qzkuxtlg.com");
INSERT INTO `wp_postmeta` VALUES("5670","2603","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5671","2603","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5672","2604","_bbp_anonymous_name","Cartier love bracelet women 18k white gold");
INSERT INTO `wp_postmeta` VALUES("5673","2604","_bbp_anonymous_email","hfcsvbpqgy@hotmail.com");
INSERT INTO `wp_postmeta` VALUES("5674","2604","_bbp_anonymous_website","http://cartierlovebraceletunisexwhitegold.blogspot.com/");
INSERT INTO `wp_postmeta` VALUES("5675","2604","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5676","2604","_bbp_topic_id","2160");
INSERT INTO `wp_postmeta` VALUES("5677","2604","_bbp_author_ip","118.97.195.42");
INSERT INTO `wp_postmeta` VALUES("5678","2605","_bbp_anonymous_name","duloxetine cymbalta");
INSERT INTO `wp_postmeta` VALUES("5679","2605","_bbp_anonymous_email","eyolamte@msvluogc.com");
INSERT INTO `wp_postmeta` VALUES("5680","2605","_bbp_anonymous_website","http://cymbaltaduloxetine.tk/#6131");
INSERT INTO `wp_postmeta` VALUES("5681","2605","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5682","2605","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5683","2605","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5684","2606","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5685","2606","_bbp_anonymous_email","ssuomfyg@qxrsfrpa.com");
INSERT INTO `wp_postmeta` VALUES("5686","2606","_bbp_anonymous_website","http://genericzithromax.se/#1431");
INSERT INTO `wp_postmeta` VALUES("5659","2601","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5660","2602","_bbp_anonymous_name","view homepage");
INSERT INTO `wp_postmeta` VALUES("5661","2602","_bbp_anonymous_email","rlxgcvyr@ifxyzymx.com");
INSERT INTO `wp_postmeta` VALUES("5662","2602","_bbp_anonymous_website","http://wellbutrin150mg.tk/#6631");
INSERT INTO `wp_postmeta` VALUES("5663","2602","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5664","2602","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5665","2602","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5666","2603","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5667","2603","_bbp_anonymous_email","ldvnlkwn@vwxjgiev.com");
INSERT INTO `wp_postmeta` VALUES("5668","2603","_bbp_anonymous_website","http://buycialisonlinecheap.tk/#2505");
INSERT INTO `wp_postmeta` VALUES("5669","2603","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5645","2599","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5646","2599","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5647","2599","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5648","2600","_bbp_anonymous_name","zithromax");
INSERT INTO `wp_postmeta` VALUES("5649","2600","_bbp_anonymous_email","tboosfkx@ivduppwu.com");
INSERT INTO `wp_postmeta` VALUES("5650","2600","_bbp_anonymous_website","http://zithromaxzpack.ml/#4409");
INSERT INTO `wp_postmeta` VALUES("5651","2600","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5652","2600","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5653","2600","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5654","2601","_bbp_anonymous_name","buy cheap cialis online");
INSERT INTO `wp_postmeta` VALUES("5655","2601","_bbp_anonymous_email","lnlkwdup@wmdipulk.com");
INSERT INTO `wp_postmeta` VALUES("5656","2601","_bbp_anonymous_website","http://buycialisonlinecheap.ml/#2535");
INSERT INTO `wp_postmeta` VALUES("5657","2601","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5658","2601","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5644","2599","_bbp_anonymous_website","http://doxycycline100mgdogs.cf/#6515");
INSERT INTO `wp_postmeta` VALUES("5640","2598","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5641","2598","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5642","2599","_bbp_anonymous_name","doxycycline 100mg");
INSERT INTO `wp_postmeta` VALUES("5643","2599","_bbp_anonymous_email","tgcqagzg@ixremspp.com");
INSERT INTO `wp_postmeta` VALUES("5639","2598","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5633","2597","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5634","2597","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5635","2597","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5636","2598","_bbp_anonymous_name","celexa");
INSERT INTO `wp_postmeta` VALUES("5637","2598","_bbp_anonymous_email","mgvelpwg@xakfocfw.com");
INSERT INTO `wp_postmeta` VALUES("5638","2598","_bbp_anonymous_website","http://celexageneric.ml/#9197");
INSERT INTO `wp_postmeta` VALUES("3679","2271","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5977","2654","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5978","2655","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5979","2655","_bbp_anonymous_email","nsojlkst@ughrcdjn.com");
INSERT INTO `wp_postmeta` VALUES("5980","2655","_bbp_anonymous_website","http://alli-pills.cf/#5874");
INSERT INTO `wp_postmeta` VALUES("5981","2655","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5982","2655","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5983","2655","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5984","2656","_bbp_anonymous_name","generic for augmentin");
INSERT INTO `wp_postmeta` VALUES("5985","2656","_bbp_anonymous_email","cylvnrxp@xqgyxrxf.com");
INSERT INTO `wp_postmeta` VALUES("5986","2656","_bbp_anonymous_website","http://genericforaugmentin.tk/#5302");
INSERT INTO `wp_postmeta` VALUES("5987","2656","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5988","2656","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5989","2656","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5990","2657","_bbp_anonymous_name","acyclovir 5 cream");
INSERT INTO `wp_postmeta` VALUES("5991","2657","_bbp_anonymous_email","vxqyewlv@uduvoklg.com");
INSERT INTO `wp_postmeta` VALUES("5992","2657","_bbp_anonymous_website","http://orderacyclovir.ml/#8293");
INSERT INTO `wp_postmeta` VALUES("5993","2657","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5994","2657","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5995","2657","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5996","2658","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5997","2658","_bbp_anonymous_email","btyoamin@apgjelef.com");
INSERT INTO `wp_postmeta` VALUES("5998","2658","_bbp_anonymous_website","http://alli-drug.cf/#3705");
INSERT INTO `wp_postmeta` VALUES("5999","2658","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6000","2658","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6001","2658","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6002","2659","_bbp_anonymous_name","prozac");
INSERT INTO `wp_postmeta` VALUES("6003","2659","_bbp_anonymous_email","zjuutvwd@uoucmxtf.com");
INSERT INTO `wp_postmeta` VALUES("6004","2659","_bbp_anonymous_website","http://generic-prozac.cf/#5254");
INSERT INTO `wp_postmeta` VALUES("6005","2659","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6006","2659","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6007","2659","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6008","2660","_bbp_anonymous_name","generic viagra 100mg");
INSERT INTO `wp_postmeta` VALUES("6009","2660","_bbp_anonymous_email","kzzrtvlt@jbmludyq.com");
INSERT INTO `wp_postmeta` VALUES("6010","2660","_bbp_anonymous_website","http://viagr.ml/#2976");
INSERT INTO `wp_postmeta` VALUES("6011","2660","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6012","2660","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6013","2660","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6014","2661","_bbp_anonymous_name","finasteride medication");
INSERT INTO `wp_postmeta` VALUES("6015","2661","_bbp_anonymous_email","svndkjqd@xqjhhqua.com");
INSERT INTO `wp_postmeta` VALUES("6016","2661","_bbp_anonymous_website","http://finasteridemedication.tk/#8239");
INSERT INTO `wp_postmeta` VALUES("6017","2661","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6018","2661","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6019","2661","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6020","2662","_bbp_anonymous_name","doxycycline");
INSERT INTO `wp_postmeta` VALUES("5959","2651","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5960","2652","_bbp_anonymous_name","vardenafil");
INSERT INTO `wp_postmeta` VALUES("5961","2652","_bbp_anonymous_email","vcdyypxu@lgewgvmo.com");
INSERT INTO `wp_postmeta` VALUES("5962","2652","_bbp_anonymous_website","http://generic-vardenafil.tk/#3476");
INSERT INTO `wp_postmeta` VALUES("5963","2652","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5964","2652","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5965","2652","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5966","2653","_bbp_anonymous_name","tadalafil");
INSERT INTO `wp_postmeta` VALUES("5967","2653","_bbp_anonymous_email","vgrbzzof@uburofux.com");
INSERT INTO `wp_postmeta` VALUES("5968","2653","_bbp_anonymous_website","http://tadalafil20mg.tk/#9638");
INSERT INTO `wp_postmeta` VALUES("5969","2653","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5970","2653","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5971","2653","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5972","2654","_bbp_anonymous_name","propecia");
INSERT INTO `wp_postmeta` VALUES("5973","2654","_bbp_anonymous_email","cafsesjx@rejbwcce.com");
INSERT INTO `wp_postmeta` VALUES("5974","2654","_bbp_anonymous_website","http://propeciahairgrowth.tk/#6144");
INSERT INTO `wp_postmeta` VALUES("5975","2654","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5976","2654","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5947","2649","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5948","2650","_bbp_anonymous_name","levaquin");
INSERT INTO `wp_postmeta` VALUES("5949","2650","_bbp_anonymous_email","miguomdj@fdmiucbl.com");
INSERT INTO `wp_postmeta` VALUES("5950","2650","_bbp_anonymous_website","http://levaquin.se/#2469");
INSERT INTO `wp_postmeta` VALUES("5951","2650","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5952","2650","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5953","2650","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5954","2651","_bbp_anonymous_name","generic of accutane");
INSERT INTO `wp_postmeta` VALUES("5955","2651","_bbp_anonymous_email","lzdetvmz@vjdhjbey.com");
INSERT INTO `wp_postmeta` VALUES("5956","2651","_bbp_anonymous_website","http://accutanegeneric.pw/#3848");
INSERT INTO `wp_postmeta` VALUES("5957","2651","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5958","2651","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5933","2647","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5934","2647","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5935","2647","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5936","2648","_bbp_anonymous_name","mobic 7.5 mg tablet");
INSERT INTO `wp_postmeta` VALUES("5937","2648","_bbp_anonymous_email","rbrqeaec@cqgulpcv.com");
INSERT INTO `wp_postmeta` VALUES("5938","2648","_bbp_anonymous_website","http://mobic75mg.cf/#1882");
INSERT INTO `wp_postmeta` VALUES("5939","2648","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5940","2648","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5941","2648","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5942","2649","_bbp_anonymous_name","cheap generic prozac");
INSERT INTO `wp_postmeta` VALUES("5943","2649","_bbp_anonymous_email","xonmaoex@cuhlxnwg.com");
INSERT INTO `wp_postmeta` VALUES("5944","2649","_bbp_anonymous_website","http://generic-prozac.pw/#3923");
INSERT INTO `wp_postmeta` VALUES("5945","2649","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5946","2649","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5894","2641","_bbp_anonymous_name","neurontin gabapentin");
INSERT INTO `wp_postmeta` VALUES("5895","2641","_bbp_anonymous_email","ootmxunb@qiplofow.com");
INSERT INTO `wp_postmeta` VALUES("5896","2641","_bbp_anonymous_website","http://neurontingabapentin.ga/#8110");
INSERT INTO `wp_postmeta` VALUES("5897","2641","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5898","2641","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5899","2641","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5900","2642","_bbp_anonymous_name","discount cialis online");
INSERT INTO `wp_postmeta` VALUES("5901","2642","_bbp_anonymous_email","nxqgjeam@uzbqjzxy.com");
INSERT INTO `wp_postmeta` VALUES("5902","2642","_bbp_anonymous_website","http://discountcialis.tk/#3700");
INSERT INTO `wp_postmeta` VALUES("5903","2642","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5904","2642","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5905","2642","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5906","2643","_bbp_anonymous_name","amoxil");
INSERT INTO `wp_postmeta` VALUES("5907","2643","_bbp_anonymous_email","imjmwxza@aaezsbab.com");
INSERT INTO `wp_postmeta` VALUES("5908","2643","_bbp_anonymous_website","http://amoxil.in/#4945");
INSERT INTO `wp_postmeta` VALUES("5909","2643","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5910","2643","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5911","2643","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5912","2644","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("5913","2644","_bbp_anonymous_email","xvwkdxeb@fiykyvhe.com");
INSERT INTO `wp_postmeta` VALUES("5914","2644","_bbp_anonymous_website","http://cymbaltageneric.ga/#7102");
INSERT INTO `wp_postmeta` VALUES("5915","2644","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5916","2644","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5917","2644","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5918","2645","_bbp_anonymous_name","amoxil 875");
INSERT INTO `wp_postmeta` VALUES("5919","2645","_bbp_anonymous_email","wuteblel@qthovshs.com");
INSERT INTO `wp_postmeta` VALUES("5920","2645","_bbp_anonymous_website","http://amoxil-875.ml/#1002");
INSERT INTO `wp_postmeta` VALUES("5921","2645","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5922","2645","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5923","2645","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5924","2646","_bbp_anonymous_name","cymbalta");
INSERT INTO `wp_postmeta` VALUES("5925","2646","_bbp_anonymous_email","vycvjjfj@jhzmundr.com");
INSERT INTO `wp_postmeta` VALUES("5926","2646","_bbp_anonymous_website","http://genericforcymbalta.ga/#5770");
INSERT INTO `wp_postmeta` VALUES("5927","2646","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5928","2646","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5929","2646","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5930","2647","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("5931","2647","_bbp_anonymous_email","tydtwlqs@sxkxhump.com");
INSERT INTO `wp_postmeta` VALUES("5932","2647","_bbp_anonymous_website","http://cheapmobic.pw/#8074");
INSERT INTO `wp_postmeta` VALUES("5893","2640","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5838","2631","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5839","2631","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5840","2632","_bbp_anonymous_name","best price for viagra");
INSERT INTO `wp_postmeta` VALUES("5841","2632","_bbp_anonymous_email","ebduessx@jbavvqxg.com");
INSERT INTO `wp_postmeta` VALUES("5842","2632","_bbp_anonymous_website","http://buyviagra-softtabs.ga/#8611");
INSERT INTO `wp_postmeta` VALUES("5843","2632","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5844","2632","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5845","2632","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5846","2633","_bbp_anonymous_name","levitra cheap");
INSERT INTO `wp_postmeta` VALUES("5847","2633","_bbp_anonymous_email","cxdyiiyf@cnwnjtdm.com");
INSERT INTO `wp_postmeta` VALUES("5848","2633","_bbp_anonymous_website","http://levitracheap.cf/#5872");
INSERT INTO `wp_postmeta` VALUES("5849","2633","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5850","2633","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5851","2633","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5852","2634","_bbp_anonymous_name","albuterol");
INSERT INTO `wp_postmeta` VALUES("5853","2634","_bbp_anonymous_email","wkmlwpte@pvjmwdau.com");
INSERT INTO `wp_postmeta` VALUES("5854","2634","_bbp_anonymous_website","http://albuterol.in/#9141");
INSERT INTO `wp_postmeta` VALUES("5855","2634","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5856","2634","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5857","2634","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5858","2635","_bbp_anonymous_name","alli");
INSERT INTO `wp_postmeta` VALUES("5859","2635","_bbp_anonymous_email","rgkbzebk@dfwgjron.com");
INSERT INTO `wp_postmeta` VALUES("5860","2635","_bbp_anonymous_website","http://alli-diet-pill.cf/#9155");
INSERT INTO `wp_postmeta` VALUES("5861","2635","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5862","2635","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5863","2635","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5864","2636","_bbp_anonymous_name","buy cheap nexium");
INSERT INTO `wp_postmeta` VALUES("5865","2636","_bbp_anonymous_email","yvizgtha@yzmotoql.com");
INSERT INTO `wp_postmeta` VALUES("5866","2636","_bbp_anonymous_website","http://cheapnexium.tk/#1811");
INSERT INTO `wp_postmeta` VALUES("5867","2636","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5868","2636","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5869","2636","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5870","2637","_bbp_anonymous_name","generic sildenafil");
INSERT INTO `wp_postmeta` VALUES("5871","2637","_bbp_anonymous_email","rpksvzkb@dhizilky.com");
INSERT INTO `wp_postmeta` VALUES("5872","2637","_bbp_anonymous_website","http://generic-sildenafil.nu/#1437");
INSERT INTO `wp_postmeta` VALUES("5873","2637","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5874","2637","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5875","2637","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5876","2638","_bbp_anonymous_name","viagra stores");
INSERT INTO `wp_postmeta` VALUES("5877","2638","_bbp_anonymous_email","pestmqaf@segywqdk.com");
INSERT INTO `wp_postmeta` VALUES("5878","2638","_bbp_anonymous_website","http://buyviagrasofttabs.se/#9803");
INSERT INTO `wp_postmeta` VALUES("5879","2638","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5880","2638","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5881","2638","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5882","2639","_bbp_anonymous_name","furosemide 40 mg diuretic");
INSERT INTO `wp_postmeta` VALUES("5883","2639","_bbp_anonymous_email","hxgnxdte@jzpomggw.com");
INSERT INTO `wp_postmeta` VALUES("5884","2639","_bbp_anonymous_website","http://furosemide40mgdiuretic.pw/#6626");
INSERT INTO `wp_postmeta` VALUES("5885","2639","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5886","2639","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5887","2639","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5888","2640","_bbp_anonymous_name","buy vermox");
INSERT INTO `wp_postmeta` VALUES("5889","2640","_bbp_anonymous_email","ejnlehib@hxkdqjeh.com");
INSERT INTO `wp_postmeta` VALUES("5890","2640","_bbp_anonymous_website","http://vermox.ml/#4438");
INSERT INTO `wp_postmeta` VALUES("5891","2640","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5892","2640","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5837","2631","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5786","2623","_bbp_anonymous_name","lasix drug");
INSERT INTO `wp_postmeta` VALUES("5787","2623","_bbp_anonymous_email","autzpbre@vmakxkeo.com");
INSERT INTO `wp_postmeta` VALUES("5788","2623","_bbp_anonymous_website","http://lasixdrug.tk/#2715");
INSERT INTO `wp_postmeta` VALUES("5789","2623","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5790","2623","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5791","2623","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5792","2624","_bbp_anonymous_name","furosemide\\purchase");
INSERT INTO `wp_postmeta` VALUES("5793","2624","_bbp_anonymous_email","hfuhhifp@xuryfray.com");
INSERT INTO `wp_postmeta` VALUES("5794","2624","_bbp_anonymous_website","http://furosemide-40-mg-diuretic.cf/#6159");
INSERT INTO `wp_postmeta` VALUES("5795","2624","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5796","2624","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5797","2624","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5798","2625","_bbp_anonymous_name","lisinopril generic");
INSERT INTO `wp_postmeta` VALUES("5799","2625","_bbp_anonymous_email","ravzmsbe@cqdzblog.com");
INSERT INTO `wp_postmeta` VALUES("5800","2625","_bbp_anonymous_website","http://lisinopril-generic.ga/#9773");
INSERT INTO `wp_postmeta` VALUES("5801","2625","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5802","2625","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5803","2625","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5804","2626","_bbp_anonymous_name","online cialis canada");
INSERT INTO `wp_postmeta` VALUES("5805","2626","_bbp_anonymous_email","oqwnasuu@ivmwvkpi.com");
INSERT INTO `wp_postmeta` VALUES("5806","2626","_bbp_anonymous_website","http://onlinecialis.ml/#4608");
INSERT INTO `wp_postmeta` VALUES("5807","2626","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5808","2626","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5809","2626","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5810","2627","_bbp_anonymous_name","cheap prednisone online");
INSERT INTO `wp_postmeta` VALUES("5811","2627","_bbp_anonymous_email","ajkaptju@vkwsbzhm.com");
INSERT INTO `wp_postmeta` VALUES("5812","2627","_bbp_anonymous_website","http://cheapprednisoneonline.ga/#7293");
INSERT INTO `wp_postmeta` VALUES("5813","2627","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5814","2627","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5815","2627","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5816","2628","_bbp_anonymous_name","celebrex");
INSERT INTO `wp_postmeta` VALUES("5817","2628","_bbp_anonymous_email","xtcxvrir@uxhyqmki.com");
INSERT INTO `wp_postmeta` VALUES("5818","2628","_bbp_anonymous_website","http://celebrexcost.ml/#7488");
INSERT INTO `wp_postmeta` VALUES("5819","2628","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5820","2628","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5821","2628","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5822","2629","_bbp_anonymous_name","buy generic valtrex online");
INSERT INTO `wp_postmeta` VALUES("5823","2629","_bbp_anonymous_email","epqwrwrr@tshawbvy.com");
INSERT INTO `wp_postmeta` VALUES("5824","2629","_bbp_anonymous_website","http://valtrex-500mg.ml/#7007");
INSERT INTO `wp_postmeta` VALUES("5825","2629","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5826","2629","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5827","2629","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5828","2630","_bbp_anonymous_name","zoloft generic");
INSERT INTO `wp_postmeta` VALUES("5829","2630","_bbp_anonymous_email","ovgqakow@fstgdbci.com");
INSERT INTO `wp_postmeta` VALUES("5830","2630","_bbp_anonymous_website","http://zoloftgeneric.ml/#6383");
INSERT INTO `wp_postmeta` VALUES("5831","2630","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5832","2630","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5833","2630","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5834","2631","_bbp_anonymous_name","levitra professional 20 mg");
INSERT INTO `wp_postmeta` VALUES("5835","2631","_bbp_anonymous_email","vokcsnjd@hnzjxnog.com");
INSERT INTO `wp_postmeta` VALUES("5836","2631","_bbp_anonymous_website","http://levitraprofessional20mg.tk/#8049");
INSERT INTO `wp_postmeta` VALUES("5743","2615","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5744","2616","_bbp_anonymous_name","synthroid.com");
INSERT INTO `wp_postmeta` VALUES("5745","2616","_bbp_anonymous_email","jctbpidl@tvdibegz.com");
INSERT INTO `wp_postmeta` VALUES("5746","2616","_bbp_anonymous_website","http://synthroid137mgwithoutprescription.ga/#7349");
INSERT INTO `wp_postmeta` VALUES("5747","2616","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5748","2616","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5749","2616","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5750","2617","_bbp_anonymous_name","alli pill");
INSERT INTO `wp_postmeta` VALUES("5751","2617","_bbp_anonymous_email","xtayzrkv@asbpkirg.com");
INSERT INTO `wp_postmeta` VALUES("5752","2617","_bbp_anonymous_website","http://allipills.pw/#8331");
INSERT INTO `wp_postmeta` VALUES("5753","2617","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5754","2617","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5755","2617","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5756","2618","_bbp_anonymous_name","lasix water pills");
INSERT INTO `wp_postmeta` VALUES("5757","2618","_bbp_anonymous_email","qxhkqxzg@jmknhlnz.com");
INSERT INTO `wp_postmeta` VALUES("5758","2618","_bbp_anonymous_website","http://lasixwaterpill.cf/#5460");
INSERT INTO `wp_postmeta` VALUES("5759","2618","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5760","2618","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5761","2618","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5762","2619","_bbp_anonymous_name","wellbutrin xl 300 mg");
INSERT INTO `wp_postmeta` VALUES("5763","2619","_bbp_anonymous_email","wiggwhkx@agxowkpv.com");
INSERT INTO `wp_postmeta` VALUES("5764","2619","_bbp_anonymous_website","http://wellbutrinxl300mg.ml/#7004");
INSERT INTO `wp_postmeta` VALUES("5765","2619","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5766","2619","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5767","2619","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5768","2620","_bbp_anonymous_name","xenical orlistat 120mg");
INSERT INTO `wp_postmeta` VALUES("5769","2620","_bbp_anonymous_email","ummqvzzz@ktcisubs.com");
INSERT INTO `wp_postmeta` VALUES("5770","2620","_bbp_anonymous_website","http://xenical-orlistat-120mg.cf/#1969");
INSERT INTO `wp_postmeta` VALUES("5771","2620","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5772","2620","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5773","2620","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5774","2621","_bbp_anonymous_name","cialis prescription");
INSERT INTO `wp_postmeta` VALUES("5775","2621","_bbp_anonymous_email","kozkdbdo@pabikycm.com");
INSERT INTO `wp_postmeta` VALUES("5776","2621","_bbp_anonymous_website","http://cialisprescription.ml/#9359");
INSERT INTO `wp_postmeta` VALUES("5777","2621","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5778","2621","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5779","2621","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5780","2622","_bbp_anonymous_name","purchase vardenafil");
INSERT INTO `wp_postmeta` VALUES("5781","2622","_bbp_anonymous_email","ojtcawam@veahjhof.com");
INSERT INTO `wp_postmeta` VALUES("5782","2622","_bbp_anonymous_website","http://vardenafil.pw/#4002");
INSERT INTO `wp_postmeta` VALUES("5783","2622","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5784","2622","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5785","2622","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("1011","1373","_wp_attached_file","2013/04/Logo48hcyan-01.png");
INSERT INTO `wp_postmeta` VALUES("4352","2384","_bbp_anonymous_name","lasix buy online");
INSERT INTO `wp_postmeta` VALUES("4353","2384","_bbp_anonymous_email","rdeskmka@avxpuqac.com");
INSERT INTO `wp_postmeta` VALUES("4354","2384","_bbp_anonymous_website","http://lasixdrug.tk/#2504");
INSERT INTO `wp_postmeta` VALUES("4355","2384","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4356","2384","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4357","2384","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4358","2385","_bbp_anonymous_name","cheap accutane");
INSERT INTO `wp_postmeta` VALUES("4359","2385","_bbp_anonymous_email","bagerebq@edcjixen.com");
INSERT INTO `wp_postmeta` VALUES("4360","2385","_bbp_anonymous_website","http://cheapaccutane.ml/#5660");
INSERT INTO `wp_postmeta` VALUES("4361","2385","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4362","2385","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4363","2385","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4364","2386","_bbp_anonymous_name","levaquin");
INSERT INTO `wp_postmeta` VALUES("4365","2386","_bbp_anonymous_email","jplmdtsm@vrnxnskh.com");
INSERT INTO `wp_postmeta` VALUES("4366","2386","_bbp_anonymous_website","http://levaquin.se/#6855");
INSERT INTO `wp_postmeta` VALUES("4367","2386","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4368","2386","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4369","2386","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4370","2387","_bbp_anonymous_name","make viagra at home");
INSERT INTO `wp_postmeta` VALUES("4371","2387","_bbp_anonymous_email","wphapinh@wgcpyztf.com");
INSERT INTO `wp_postmeta` VALUES("4372","2387","_bbp_anonymous_website","http://viagrasofttabs50mg.ml/#6731");
INSERT INTO `wp_postmeta` VALUES("4373","2387","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4374","2387","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4375","2387","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4376","2388","_bbp_anonymous_name","tadalafil no prescription");
INSERT INTO `wp_postmeta` VALUES("4377","2388","_bbp_anonymous_email","slcpblnc@rvalnwsm.com");
INSERT INTO `wp_postmeta` VALUES("4378","2388","_bbp_anonymous_website","http://tadalafil-no-prescription.cf/#5441");
INSERT INTO `wp_postmeta` VALUES("4379","2388","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4380","2388","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4381","2388","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4382","2389","_bbp_anonymous_name","valtrex");
INSERT INTO `wp_postmeta` VALUES("4383","2389","_bbp_anonymous_email","nqypgppx@wyuvvfjs.com");
INSERT INTO `wp_postmeta` VALUES("4384","2389","_bbp_anonymous_website","http://valtrex-500mg.ml/#7666");
INSERT INTO `wp_postmeta` VALUES("4385","2389","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4386","2389","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4387","2389","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4388","2390","_bbp_anonymous_name","lisinopril");
INSERT INTO `wp_postmeta` VALUES("4389","2390","_bbp_anonymous_email","hkouatpp@dydqschd.com");
INSERT INTO `wp_postmeta` VALUES("4390","2390","_bbp_anonymous_website","http://lisinopril-generic.ga/#8439");
INSERT INTO `wp_postmeta` VALUES("4391","2390","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4392","2390","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4393","2390","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4394","2391","_bbp_anonymous_name","buy sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("4395","2391","_bbp_anonymous_email","xhwpvmet@cypurthn.com");
INSERT INTO `wp_postmeta` VALUES("4396","2391","_bbp_anonymous_website","http://buy-sildenafil-citrate.ml/#6299");
INSERT INTO `wp_postmeta` VALUES("4397","2391","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4398","2391","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4399","2391","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4400","2392","_bbp_anonymous_name","cephalexin drug");
INSERT INTO `wp_postmeta` VALUES("4401","2392","_bbp_anonymous_email","eeeudbwn@bvnpfbbe.com");
INSERT INTO `wp_postmeta` VALUES("4402","2392","_bbp_anonymous_website","http://keflex500.tk/#6379");
INSERT INTO `wp_postmeta` VALUES("4403","2392","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4404","2392","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4405","2392","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4406","2393","_bbp_anonymous_name","buy tadalafil online");
INSERT INTO `wp_postmeta` VALUES("4407","2393","_bbp_anonymous_email","iniuvouh@qerpnvgo.com");
INSERT INTO `wp_postmeta` VALUES("4408","2393","_bbp_anonymous_website","http://buy-tadalafil-online.cf/#7428");
INSERT INTO `wp_postmeta` VALUES("4409","2393","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4410","2393","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4411","2393","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4412","2394","_bbp_anonymous_name","buy mobic");
INSERT INTO `wp_postmeta` VALUES("4413","2394","_bbp_anonymous_email","jknghhjd@bdjqlpsh.com");
INSERT INTO `wp_postmeta` VALUES("4414","2394","_bbp_anonymous_website","http://buy-mobic.tk/#1788");
INSERT INTO `wp_postmeta` VALUES("4415","2394","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4416","2394","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4417","2394","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4418","2395","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("1066","1401","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("6468","2736","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6469","2736","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6470","2737","_bbp_anonymous_name","cialis prescription");
INSERT INTO `wp_postmeta` VALUES("6471","2737","_bbp_anonymous_email","qakhqjur@vpxfcvjy.com");
INSERT INTO `wp_postmeta` VALUES("6472","2737","_bbp_anonymous_website","http://cialisprescription.ml/#6856");
INSERT INTO `wp_postmeta` VALUES("6473","2737","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6474","2737","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6475","2737","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6476","2738","_bbp_anonymous_name","sildenafil generic");
INSERT INTO `wp_postmeta` VALUES("6477","2738","_bbp_anonymous_email","tnwhiytd@azinhhmb.com");
INSERT INTO `wp_postmeta` VALUES("6478","2738","_bbp_anonymous_website","http://sildenafilgeneric.pw/#1126");
INSERT INTO `wp_postmeta` VALUES("6479","2738","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6480","2738","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6481","2738","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6467","2736","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6453","2734","_bbp_anonymous_email","podrgfzd@gzxaiogg.com");
INSERT INTO `wp_postmeta` VALUES("6454","2734","_bbp_anonymous_website","http://neurontingabapentin.ga/#9935");
INSERT INTO `wp_postmeta` VALUES("6455","2734","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6456","2734","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6457","2734","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6458","2735","_bbp_anonymous_name","nexium");
INSERT INTO `wp_postmeta` VALUES("6459","2735","_bbp_anonymous_email","qzcjgljj@uuzeqftd.com");
INSERT INTO `wp_postmeta` VALUES("6460","2735","_bbp_anonymous_website","http://nexiumdrug.cf/#5476");
INSERT INTO `wp_postmeta` VALUES("6461","2735","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6462","2735","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6463","2735","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6464","2736","_bbp_anonymous_name","mobic");
INSERT INTO `wp_postmeta` VALUES("6465","2736","_bbp_anonymous_email","prqgcnwk@ivvpyjss.com");
INSERT INTO `wp_postmeta` VALUES("6466","2736","_bbp_anonymous_website","http://mobic75mg.tk/#4754");
INSERT INTO `wp_postmeta` VALUES("6436","2731","_bbp_anonymous_website","http://buyamoxicillin.se/#7187");
INSERT INTO `wp_postmeta` VALUES("6437","2731","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6438","2731","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6439","2731","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6440","2732","_bbp_anonymous_name","prednisone without a perscription");
INSERT INTO `wp_postmeta` VALUES("6441","2732","_bbp_anonymous_email","parkjvlx@lilvtstd.com");
INSERT INTO `wp_postmeta` VALUES("6442","2732","_bbp_anonymous_website","http://cheapprednisoneonline.tk/#4191");
INSERT INTO `wp_postmeta` VALUES("6443","2732","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6444","2732","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6445","2732","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6446","2733","_bbp_anonymous_name","purchase vardenafil");
INSERT INTO `wp_postmeta` VALUES("6447","2733","_bbp_anonymous_email","djetmcio@exbxfvch.com");
INSERT INTO `wp_postmeta` VALUES("6448","2733","_bbp_anonymous_website","http://vardenafil.pw/#6333");
INSERT INTO `wp_postmeta` VALUES("6449","2733","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6450","2733","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6451","2733","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6452","2734","_bbp_anonymous_name","neurontin gabapentin");
INSERT INTO `wp_postmeta` VALUES("6425","2729","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6426","2729","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6427","2729","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6428","2730","_bbp_anonymous_name","website here");
INSERT INTO `wp_postmeta` VALUES("6429","2730","_bbp_anonymous_email","xwcfnrxx@drprftfc.com");
INSERT INTO `wp_postmeta` VALUES("6430","2730","_bbp_anonymous_website","http://buy-zithromax.info/#1453");
INSERT INTO `wp_postmeta` VALUES("6431","2730","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6432","2730","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6433","2730","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6434","2731","_bbp_anonymous_name","buy amoxicillin");
INSERT INTO `wp_postmeta` VALUES("6435","2731","_bbp_anonymous_email","amfxwsxs@ewtgxslv.com");
INSERT INTO `wp_postmeta` VALUES("6411","2727","_bbp_anonymous_email","qqmeetqc@otidumdm.com");
INSERT INTO `wp_postmeta` VALUES("6412","2727","_bbp_anonymous_website","http://buycialisonlinecheap.tk/#9727");
INSERT INTO `wp_postmeta` VALUES("6413","2727","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6414","2727","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6415","2727","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6416","2728","_bbp_anonymous_name","generic viagra prices");
INSERT INTO `wp_postmeta` VALUES("6417","2728","_bbp_anonymous_email","jzaslrsn@dtildaqq.com");
INSERT INTO `wp_postmeta` VALUES("6418","2728","_bbp_anonymous_website","http://buyviagrasofttabs.se/#6211");
INSERT INTO `wp_postmeta` VALUES("6419","2728","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6420","2728","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6421","2728","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6422","2729","_bbp_anonymous_name","prednisone 20 mg medication");
INSERT INTO `wp_postmeta` VALUES("6423","2729","_bbp_anonymous_email","jtwitnyl@pevrvxjb.com");
INSERT INTO `wp_postmeta` VALUES("6424","2729","_bbp_anonymous_website","http://prednisone20mgmedication.cf/#6351");
INSERT INTO `wp_postmeta` VALUES("6395","2724","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6396","2724","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6397","2724","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6398","2725","_bbp_anonymous_name","levaquin");
INSERT INTO `wp_postmeta` VALUES("6399","2725","_bbp_anonymous_email","vcdezfwf@grmoeojt.com");
INSERT INTO `wp_postmeta` VALUES("6400","2725","_bbp_anonymous_website","http://levaquin.se/#6332");
INSERT INTO `wp_postmeta` VALUES("6401","2725","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6402","2725","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6403","2725","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6404","2726","_bbp_anonymous_name","nexium in canada");
INSERT INTO `wp_postmeta` VALUES("6405","2726","_bbp_anonymous_email","mpktqsxk@mjwflggp.com");
INSERT INTO `wp_postmeta` VALUES("6406","2726","_bbp_anonymous_website","http://nexiumdrug.ga/#8959");
INSERT INTO `wp_postmeta` VALUES("6407","2726","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6408","2726","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6409","2726","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6410","2727","_bbp_anonymous_name","buy cialis online cheap");
INSERT INTO `wp_postmeta` VALUES("6394","2724","_bbp_anonymous_website","http://genericsildenafilcitrate.ml/#5286");
INSERT INTO `wp_postmeta` VALUES("6377","2721","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6378","2721","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6379","2721","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6380","2722","_bbp_anonymous_name","generic for augmentin");
INSERT INTO `wp_postmeta` VALUES("6381","2722","_bbp_anonymous_email","wpayyyca@ijpeyauu.com");
INSERT INTO `wp_postmeta` VALUES("6382","2722","_bbp_anonymous_website","http://genericforaugmentin.pw/#5263");
INSERT INTO `wp_postmeta` VALUES("6383","2722","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6384","2722","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6385","2722","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6386","2723","_bbp_anonymous_name","buy viagra online");
INSERT INTO `wp_postmeta` VALUES("6387","2723","_bbp_anonymous_email","waqzqkra@nbicuxwq.com");
INSERT INTO `wp_postmeta` VALUES("6388","2723","_bbp_anonymous_website","http://viagrabuyonline.ga/#9258");
INSERT INTO `wp_postmeta` VALUES("6389","2723","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6390","2723","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6391","2723","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6392","2724","_bbp_anonymous_name","sildenafil");
INSERT INTO `wp_postmeta` VALUES("6393","2724","_bbp_anonymous_email","mfettrov@xntijlhu.com");
INSERT INTO `wp_postmeta` VALUES("6376","2721","_bbp_anonymous_website","http://buy-viagra-soft-tabs.ga/#6191");
INSERT INTO `wp_postmeta` VALUES("6375","2721","_bbp_anonymous_email","liwjrjcs@pjkzgwno.com");
INSERT INTO `wp_postmeta` VALUES("1067","1401","_edit_lock","1426615847:3");
INSERT INTO `wp_postmeta` VALUES("3680","2272","_bbp_anonymous_name","amitriptyline");
INSERT INTO `wp_postmeta` VALUES("3681","2272","_bbp_anonymous_email","zbmbnxed@vtrwsrde.com");
INSERT INTO `wp_postmeta` VALUES("3682","2272","_bbp_anonymous_website","http://amitriptylinehcl25mgtab.ga/#3144");
INSERT INTO `wp_postmeta` VALUES("3683","2272","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3684","2272","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3685","2272","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3686","2273","_bbp_anonymous_name","tretinoin");
INSERT INTO `wp_postmeta` VALUES("3687","2273","_bbp_anonymous_email","mutwdogd@ozhbxpak.com");
INSERT INTO `wp_postmeta` VALUES("3688","2273","_bbp_anonymous_website","http://tretinoin.se/#5515");
INSERT INTO `wp_postmeta` VALUES("3689","2273","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3690","2273","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3691","2273","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3692","2274","_bbp_anonymous_name","viagra");
INSERT INTO `wp_postmeta` VALUES("3693","2274","_bbp_anonymous_email","izepqfcr@clqscrfa.com");
INSERT INTO `wp_postmeta` VALUES("3694","2274","_bbp_anonymous_website","http://viagrasofttabs.in/#6332");
INSERT INTO `wp_postmeta` VALUES("3695","2274","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3696","2274","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3697","2274","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3698","2275","_bbp_anonymous_name","acyclovir herpes");
INSERT INTO `wp_postmeta` VALUES("1136","1420","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6159.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6159-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6159-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6159-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6159-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6159-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6159-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6159-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6159-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1135","1420","_wp_attached_file","2011/12/IMG_6159.jpg");
INSERT INTO `wp_postmeta` VALUES("1134","1419","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6157.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6157-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6157-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6157-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6157-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6157-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6157-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6157-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6157-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1133","1419","_wp_attached_file","2011/12/IMG_6157.jpg");
INSERT INTO `wp_postmeta` VALUES("1132","1418","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6115.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6115-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6115-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6115-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6115-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6115-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6115-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1131","1418","_wp_attached_file","2011/12/IMG_6115.jpg");
INSERT INTO `wp_postmeta` VALUES("1130","1417","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6114.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6114-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6114-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6114-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6114-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6114-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6114-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6114-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6114-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1129","1417","_wp_attached_file","2011/12/IMG_6114.jpg");
INSERT INTO `wp_postmeta` VALUES("1128","1416","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6111.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6111-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6111-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6111-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6111-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6111-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6111-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6111-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6111-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1127","1416","_wp_attached_file","2011/12/IMG_6111.jpg");
INSERT INTO `wp_postmeta` VALUES("1126","1415","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6097.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6097-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6097-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6097-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6097-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6097-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6097-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1125","1415","_wp_attached_file","2011/12/IMG_6097.jpg");
INSERT INTO `wp_postmeta` VALUES("1065","734","footer","");
INSERT INTO `wp_postmeta` VALUES("1083","1407","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1086","1407","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1060","1386","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1059","1386","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1058","1386","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1056","1386","_menu_item_url","http://dev48h.pigiste.org");
INSERT INTO `wp_postmeta` VALUES("1055","1386","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1054","1386","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1053","1386","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1052","1386","_menu_item_object","custom");
INSERT INTO `wp_postmeta` VALUES("1051","1386","_menu_item_object_id","1386");
INSERT INTO `wp_postmeta` VALUES("1050","1386","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1048","1385","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1047","1385","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1046","1385","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1064","734","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1044","1385","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1043","1385","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1042","1385","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1041","1385","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1040","1385","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1037","1385","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1013","1373","av-custom-link","");
INSERT INTO `wp_postmeta` VALUES("1038","1385","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1039","1385","_menu_item_object_id","1167");
INSERT INTO `wp_postmeta` VALUES("1082","1407","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1049","1386","_menu_item_type","custom");
INSERT INTO `wp_postmeta` VALUES("1014","1374","_wp_attached_file","2014/04/Imac48h-01.png");
INSERT INTO `wp_postmeta` VALUES("1015","1374","_wp_attachment_metadata","a:5:{s:5:\"width\";i:284;s:6:\"height\";i:284;s:4:\"file\";s:22:\"2014/04/Imac48h-01.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-284x270.png\";s:5:\"width\";i:284;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1016","1375","_wp_attached_file","2014/04/ipad.png");
INSERT INTO `wp_postmeta` VALUES("1017","1375","_wp_attachment_metadata","a:5:{s:5:\"width\";i:257;s:6:\"height\";i:200;s:4:\"file\";s:16:\"2014/04/ipad.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"ipad-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:14:\"ipad-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:16:\"ipad-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:16:\"ipad-257x185.png\";s:5:\"width\";i:257;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1018","1376","_wp_attached_file","2014/04/ipad48h.png");
INSERT INTO `wp_postmeta` VALUES("1019","1376","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1069;s:6:\"height\";i:826;s:4:\"file\";s:19:\"2014/04/ipad48h.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ipad48h-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"ipad48h-300x231.png\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x795.png\";s:5:\"width\";i:1030;s:6:\"height\";i:795;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"ipad48h-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"ipad48h-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"ipad48h-1069x430.png\";s:5:\"width\";i:1069;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"ipad48h-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"ipad48h-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"ipad48h-705x544.png\";s:5:\"width\";i:705;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"ipad48h-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x347.png\";s:5:\"width\";i:450;s:6:\"height\";i:347;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1020","1377","_wp_attached_file","2014/04/ipad48h2.png");
INSERT INTO `wp_postmeta` VALUES("1021","1377","_wp_attachment_metadata","a:5:{s:5:\"width\";i:534;s:6:\"height\";i:413;s:4:\"file\";s:20:\"2014/04/ipad48h2.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48h2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"ipad48h2-300x232.png\";s:5:\"width\";i:300;s:6:\"height\";i:232;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"ipad48h2-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"ipad48h2-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"ipad48h2-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"ipad48h2-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x270.png\";s:5:\"width\";i:534;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x360.png\";s:5:\"width\";i:534;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"ipad48h2-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x413.png\";s:5:\"width\";i:450;s:6:\"height\";i:413;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x348.png\";s:5:\"width\";i:450;s:6:\"height\";i:348;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1022","1378","_wp_attached_file","2014/04/imac48.png");
INSERT INTO `wp_postmeta` VALUES("1023","1378","_wp_attachment_metadata","a:5:{s:5:\"width\";i:788;s:6:\"height\";i:633;s:4:\"file\";s:18:\"2014/04/imac48.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"imac48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"imac48-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"imac48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"imac48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:18:\"imac48-788x430.png\";s:5:\"width\";i:788;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"imac48-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"imac48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:18:\"imac48-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:18:\"imac48-705x566.png\";s:5:\"width\";i:705;s:6:\"height\";i:566;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-788x360.png\";s:5:\"width\";i:788;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"imac48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"imac48-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"imac48-450x361.png\";s:5:\"width\";i:450;s:6:\"height\";i:361;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1024","1379","_wp_attached_file","2014/04/imac48heures.png");
INSERT INTO `wp_postmeta` VALUES("1025","1379","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:24:\"2014/04/imac48heures.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"imac48heures-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"imac48heures-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"imac48heures-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"imac48heures-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"imac48heures-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"imac48heures-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"imac48heures-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1026","1380","_wp_attached_file","2014/04/imac48heures3.png");
INSERT INTO `wp_postmeta` VALUES("1027","1380","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:25:\"2014/04/imac48heures3.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac48heures3-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac48heures3-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac48heures3-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac48heures3-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac48heures3-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac48heures3-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac48heures3-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1028","1381","_wp_attached_file","2014/04/ipad48.png");
INSERT INTO `wp_postmeta` VALUES("1029","1381","_wp_attachment_metadata","a:5:{s:5:\"width\";i:320;s:6:\"height\";i:414;s:4:\"file\";s:18:\"2014/04/ipad48.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"ipad48-231x300.png\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"ipad48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"ipad48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"ipad48-320x400.png\";s:5:\"width\";i:320;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"ipad48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x270.png\";s:5:\"width\";i:320;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x360.png\";s:5:\"width\";i:320;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1030","1382","_wp_attached_file","2014/04/ipa.png");
INSERT INTO `wp_postmeta` VALUES("1031","1382","_wp_attachment_metadata","a:5:{s:5:\"width\";i:215;s:6:\"height\";i:278;s:4:\"file\";s:15:\"2014/04/ipa.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"ipa-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"ipa-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"ipa-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"ipa-215x185.png\";s:5:\"width\";i:215;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"ipa-215x270.png\";s:5:\"width\";i:215;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"ipa-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1032","1383","_wp_attached_file","2014/04/txt.png");
INSERT INTO `wp_postmeta` VALUES("1033","1383","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:15:\"2014/04/txt.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"txt-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"txt-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"txt-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:14:\"txt-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:14:\"txt-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:14:\"txt-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:14:\"txt-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:14:\"txt-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:14:\"txt-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1034","1167","_edit_lock","1427965028:1");
INSERT INTO `wp_postmeta` VALUES("1035","1167","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1084","1407","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1036","1167","footer","nofooterwidgets");
INSERT INTO `wp_postmeta` VALUES("1137","1421","_wp_attached_file","2011/12/IMG_6167.jpg");
INSERT INTO `wp_postmeta` VALUES("1138","1421","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6167.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6167-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6167-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6167-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6167-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6167-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6167-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1148","44","_thumbnail_id","1420");
INSERT INTO `wp_postmeta` VALUES("1149","1422","_wp_attached_file","2011/12/IMG_5363.jpg");
INSERT INTO `wp_postmeta` VALUES("1150","1422","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5363.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5363-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5363-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5363-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5363-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5363-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5363-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5363-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5363-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1151","1423","_wp_attached_file","2011/12/IMG_5365.jpg");
INSERT INTO `wp_postmeta` VALUES("1152","1423","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5365.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5365-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5365-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5365-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5365-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5365-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5365-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5365-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5365-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1153","1424","_wp_attached_file","2011/12/IMG_5366.jpg");
INSERT INTO `wp_postmeta` VALUES("1154","1424","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5366.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5366-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5366-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5366-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5366-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5366-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5366-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5366-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5366-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1155","1425","_wp_attached_file","2011/12/IMG_5368.jpg");
INSERT INTO `wp_postmeta` VALUES("1156","1425","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5368.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5368-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5368-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5368-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5368-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5368-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5368-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5368-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5368-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1157","1426","_wp_attached_file","2011/12/IMG_5371.jpg");
INSERT INTO `wp_postmeta` VALUES("1158","1426","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5371.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5371-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5371-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5371-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5371-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5371-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5371-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5371-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5371-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1159","1427","_wp_attached_file","2011/12/IMG_5373.jpg");
INSERT INTO `wp_postmeta` VALUES("1160","1427","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5373.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5373-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5373-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5373-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5373-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5373-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5373-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5373-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5373-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1161","1428","_wp_attached_file","2011/12/IMG_5375.jpg");
INSERT INTO `wp_postmeta` VALUES("1162","1428","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5375.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5375-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5375-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5375-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5375-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5375-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5375-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5375-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5375-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5375-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1163","1429","_wp_attached_file","2011/12/IMG_8601.jpg");
INSERT INTO `wp_postmeta` VALUES("1164","1429","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8601.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8601-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8601-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8601-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8601-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8601-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8601-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8601-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8601-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8601-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1165","1430","_wp_attached_file","2011/12/IMG_8602.jpg");
INSERT INTO `wp_postmeta` VALUES("1166","1430","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8602.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8602-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8602-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8602-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8602-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8602-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8602-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8602-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8602-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8602-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1167","1431","_wp_attached_file","2011/12/IMG_8605.jpg");
INSERT INTO `wp_postmeta` VALUES("1168","1431","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_8605.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8605-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8605-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8605-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8605-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8605-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8605-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8605-705x705.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8605-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1169","1432","_wp_attached_file","2011/12/IMG_5358.jpg");
INSERT INTO `wp_postmeta` VALUES("1170","1432","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5358.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5358-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5358-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5358-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5358-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5358-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5358-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5358-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5358-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5358-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1171","751","_avia_builder_template_galerie_photo","{{{Galerie photo}}}[av_two_third first]
[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'portfolio\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("1172","1433","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1173","1433","_edit_lock","1427716571:5");
INSERT INTO `wp_postmeta` VALUES("1174","1434","_wp_attached_file","2014/04/IMG_4110.jpg");
INSERT INTO `wp_postmeta` VALUES("1175","1434","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4110.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4110-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4110-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4110-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4110-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4110-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4110-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4110-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4110-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4110-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4110-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4110-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4110-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4110-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4110-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1176","1435","_wp_attached_file","2014/04/IMG_4108.jpg");
INSERT INTO `wp_postmeta` VALUES("1177","1435","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1500;s:4:\"file\";s:20:\"2014/04/IMG_4108.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4108-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4108-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_4108-686x1030.jpg\";s:5:\"width\";i:686;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4108-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4108-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4108-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4108-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4108-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4108-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4108-470x705.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4108-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4108-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4108-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4108-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4108-450x675.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1178","1436","_wp_attached_file","2014/04/IMG_4106.jpg");
INSERT INTO `wp_postmeta` VALUES("1179","1436","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4106.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4106-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4106-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4106-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4106-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4106-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4106-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4106-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4106-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4106-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4106-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4106-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4106-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4106-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4106-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1180","1437","_wp_attached_file","2014/04/IMG_4105.jpg");
INSERT INTO `wp_postmeta` VALUES("1181","1437","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4105.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"IMG_4105-e1398421965268-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4105-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4105-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4105-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4105-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4105-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4105-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4105-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4105-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4105-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4105-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4105-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4105-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4105-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1182","1438","_wp_attached_file","2014/04/IMG_4104.jpg");
INSERT INTO `wp_postmeta` VALUES("1183","1438","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4104.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4104-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4104-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4104-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4104-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4104-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4104-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4104-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4104-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4104-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4104-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4104-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4104-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4104-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4104-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1184","1439","_wp_attached_file","2014/04/IMG_4103.jpg");
INSERT INTO `wp_postmeta` VALUES("1185","1439","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4103.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4103-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4103-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4103-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4103-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4103-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4103-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4103-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4103-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4103-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4103-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4103-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4103-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4103-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4103-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1186","1440","_wp_attached_file","2014/04/IMG_4102.jpg");
INSERT INTO `wp_postmeta` VALUES("1187","1440","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4102.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4102-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4102-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4102-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4102-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4102-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4102-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4102-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4102-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4102-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4102-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4102-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4102-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4102-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4102-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1188","1441","_wp_attached_file","2014/04/IMG_4101.jpg");
INSERT INTO `wp_postmeta` VALUES("1189","1441","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4101.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4101-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4101-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4101-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4101-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4101-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4101-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4101-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4101-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4101-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4101-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4101-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4101-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4101-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4101-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1190","1442","_wp_attached_file","2014/04/IMG_4100.jpg");
INSERT INTO `wp_postmeta` VALUES("1191","1442","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4100.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4100-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4100-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4100-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4100-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4100-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4100-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4100-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4100-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4100-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4100-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4100-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4100-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4100-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4100-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1192","1443","_wp_attached_file","2014/04/IMG_4099.jpg");
INSERT INTO `wp_postmeta` VALUES("1193","1443","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4099.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4099-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4099-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4099-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4099-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4099-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4099-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4099-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4099-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4099-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4099-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4099-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4099-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4099-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4099-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1194","1444","_wp_attached_file","2014/04/IMG_4098.jpg");
INSERT INTO `wp_postmeta` VALUES("1195","1444","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4098.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4098-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4098-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4098-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4098-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4098-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4098-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4098-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4098-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4098-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4098-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4098-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4098-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4098-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4098-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1196","1445","_wp_attached_file","2014/04/IMG_4097.jpg");
INSERT INTO `wp_postmeta` VALUES("1197","1445","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4097.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4097-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4097-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4097-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4097-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4097-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4097-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4097-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4097-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4097-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4097-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4097-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4097-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4097-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4097-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1198","1446","_wp_attached_file","2014/04/IMG_4096.jpg");
INSERT INTO `wp_postmeta` VALUES("1199","1446","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4096.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4096-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4096-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4096-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4096-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4096-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4096-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4096-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4096-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4096-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4096-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4096-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4096-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4096-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4096-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1200","1447","_wp_attached_file","2014/04/IMG_4095.jpg");
INSERT INTO `wp_postmeta` VALUES("1201","1447","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4095.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4095-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4095-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4095-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4095-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4095-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4095-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4095-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4095-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4095-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4095-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4095-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4095-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4095-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4095-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1202","1448","_wp_attached_file","2014/04/IMG_4111.jpg");
INSERT INTO `wp_postmeta` VALUES("1203","1448","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4111.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4111-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4111-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4111-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4111-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4111-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4111-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4111-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4111-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4111-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4111-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4111-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4111-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4111-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4111-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1204","1449","_wp_attached_file","2014/04/IMG_4092.jpg");
INSERT INTO `wp_postmeta` VALUES("1205","1449","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4092-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4092-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1206","1450","_wp_attached_file","2014/04/IMG_4086.jpg");
INSERT INTO `wp_postmeta` VALUES("1207","1450","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4086.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4086-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4086-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4086-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4086-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4086-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4086-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4086-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4086-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4086-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4086-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4086-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4086-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4086-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4086-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1208","1451","_wp_attached_file","2014/04/IMG_4083.jpg");
INSERT INTO `wp_postmeta` VALUES("1209","1451","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4083.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4083-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4083-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4083-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4083-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4083-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4083-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4083-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4083-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4083-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4083-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4083-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4083-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4083-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4083-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1210","1452","_wp_attached_file","2014/04/IMG_4082.jpg");
INSERT INTO `wp_postmeta` VALUES("1211","1452","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4082.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4082-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4082-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4082-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4082-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4082-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4082-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4082-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4082-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4082-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4082-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4082-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4082-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4082-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4082-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1212","1453","_wp_attached_file","2014/04/IMG_4079.jpg");
INSERT INTO `wp_postmeta` VALUES("1213","1453","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4079.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4079-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4079-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4079-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4079-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4079-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4079-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4079-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4079-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4079-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4079-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4079-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4079-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4079-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4079-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1214","1454","_wp_attached_file","2014/04/IMG_4078.jpg");
INSERT INTO `wp_postmeta` VALUES("1215","1454","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4078.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4078-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4078-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4078-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4078-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4078-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4078-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4078-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4078-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4078-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4078-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4078-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4078-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4078-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4078-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1216","1455","_wp_attached_file","2014/04/IMG_4077.jpg");
INSERT INTO `wp_postmeta` VALUES("1217","1455","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4077.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4077-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4077-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4077-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4077-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4077-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4077-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4077-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4077-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4077-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4077-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4077-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4077-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4077-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4077-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1218","1456","_wp_attached_file","2014/04/IMG_4074.jpg");
INSERT INTO `wp_postmeta` VALUES("1219","1456","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4074.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4074-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4074-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4074-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4074-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4074-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4074-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4074-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4074-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4074-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4074-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4074-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4074-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4074-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4074-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1220","1457","_wp_attached_file","2014/04/IMG_4073.jpg");
INSERT INTO `wp_postmeta` VALUES("1221","1457","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4073.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4073-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4073-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4073-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4073-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4073-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4073-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4073-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4073-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4073-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4073-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4073-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4073-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4073-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4073-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1222","1458","_wp_attached_file","2014/04/IMG_4072.jpg");
INSERT INTO `wp_postmeta` VALUES("1223","1458","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4072.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4072-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4072-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4072-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4072-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4072-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4072-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4072-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4072-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4072-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4072-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4072-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4072-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4072-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4072-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1224","1459","_wp_attached_file","2014/04/IMG_4091.jpg");
INSERT INTO `wp_postmeta` VALUES("1225","1459","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4091.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4091-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4091-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4091-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4091-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4091-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4091-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4091-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4091-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4091-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4091-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4091-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4091-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4091-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4091-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1226","1433","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1227","1433","_aviaLayoutBuilderCleanData","[av_two_third first]
[av_gallery ids=\'1435,1434,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]

[av_textblock ]
<p>
<h3>Lyon</h3>
<p>La seconde édition des 48h de la pige s\'est tenu à Lyon les 2 et 3 juillet 2012 à l’université de Lyon 3, en plein centre-ville. L’objectif était toujours le même : permettre à chacun d’élargir le réseau de contacts tout en s’informant et en partageant les expériences. <strong>Découvrez Lyon 2012 en images !</strong></p>
© Johann Trompat

[/av_textblock]

[/av_one_third][av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1228","1433","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1284","1471","_wp_attached_file","2011/12/BCR7615.jpg");
INSERT INTO `wp_postmeta` VALUES("1229","1433","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1230","1433","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1231","1433","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1232","1433","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1233","1433","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1234","1433","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1235","1433","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1236","1433","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1237","1433","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1238","1433","header","yes");
INSERT INTO `wp_postmeta` VALUES("1239","1433","footer","");
INSERT INTO `wp_postmeta` VALUES("1241","1437","_wp_attachment_backup_sizes","a:1:{s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:18:\"IMG_4105-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("6307","2709","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6306","2709","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6177","2688","_bbp_anonymous_email","rtgdiywh@htlobnji.com");
INSERT INTO `wp_postmeta` VALUES("6176","2688","_bbp_anonymous_name","purchase amoxicillin 500 mg");
INSERT INTO `wp_postmeta` VALUES("6175","2687","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("1248","1460","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1249","1460","_edit_lock","1427716563:5");
INSERT INTO `wp_postmeta` VALUES("1250","1460","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1251","1460","_aviaLayoutBuilderCleanData","[av_two_third first]
[av_gallery ids=\'1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1560,1561,1562,1563,1564,1565,1566\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'thumbnail\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]

[av_textblock ]
<p>
<h3>Préparation 2014</h3>
<p>Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir. Les prochaine 48 h. proposeront donc aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain, avec :<br />- des expériences de journalistes pigistes et une co-construction en atelier (quelles sont les expériences innovantes, singulières, mises en œuvre par des journalistes pigistes, comment ces expériences peuvent nourrir mon projet professionnel, à quelles conditions sont-elles transférables ?)<br />- des outils pour anticiper les évolutions de la presse (regard d\'experts sur les évolutions à moyen terme, compétences à développer)<br />- des réflexions pour anticiper ces changements (imaginer des réponses collectives, mieux gérer notre efficacité).<br />La convivialité sera bien évidemment au rendez-vous avec une soirée festive. <strong>Découvrez la session de préparation en images !</strong></p>

[/av_textblock]

[/av_one_third][av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1252","1460","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1253","1460","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1254","1460","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1255","1460","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1256","1460","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1257","1460","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1258","1460","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1259","1460","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1260","1460","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1261","1460","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1262","1460","header","yes");
INSERT INTO `wp_postmeta` VALUES("1263","1460","footer","");
INSERT INTO `wp_postmeta` VALUES("1264","1461","_wp_attached_file","2011/12/IMG_2519.jpg");
INSERT INTO `wp_postmeta` VALUES("1265","1461","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2519.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2519-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2519-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2519-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2519-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2519-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2519-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2519-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2519-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2519-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2519-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2519-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2519-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2519-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2519-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1266","1462","_wp_attached_file","2011/12/IMG_2518.jpg");
INSERT INTO `wp_postmeta` VALUES("1267","1462","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2518.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2518-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2518-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2518-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2518-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2518-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2518-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2518-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2518-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2518-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2518-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2518-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2518-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2518-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2518-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1268","1463","_wp_attached_file","2011/12/IMG_2513.jpg");
INSERT INTO `wp_postmeta` VALUES("1269","1463","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2513.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2513-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2513-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2513-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2513-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2513-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2513-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2513-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2513-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2513-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2513-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2513-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2513-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2513-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2513-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1270","1464","_wp_attached_file","2011/12/IMG_2507.jpg");
INSERT INTO `wp_postmeta` VALUES("1271","1464","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2507.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2507-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2507-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2507-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2507-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2507-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2507-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2507-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2507-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2507-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2507-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2507-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2507-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2507-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2507-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1272","1465","_wp_attached_file","2011/12/IMG_2506.jpg");
INSERT INTO `wp_postmeta` VALUES("1273","1465","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2506.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2506-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2506-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2506-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2506-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2506-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2506-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2506-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2506-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2506-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2506-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2506-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2506-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2506-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2506-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1274","1466","_wp_attached_file","2011/12/IMG_2504.jpg");
INSERT INTO `wp_postmeta` VALUES("1275","1466","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2504.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2504-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2504-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2504-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2504-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2504-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2504-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2504-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2504-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2504-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2504-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2504-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2504-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2504-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2504-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1276","1467","_wp_attached_file","2011/12/IMG_2503.jpg");
INSERT INTO `wp_postmeta` VALUES("1277","1467","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_2503.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2503-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2503-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_2503-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2503-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2503-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2503-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2503-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2503-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2503-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2503-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2503-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2503-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2503-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2503-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2503-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1278","1468","_wp_attached_file","2011/12/IMG_2500.jpg");
INSERT INTO `wp_postmeta` VALUES("1279","1468","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2500.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2500-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2500-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2500-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2500-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2500-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2500-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2500-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2500-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2500-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2500-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2500-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2500-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2500-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2500-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1280","1469","_wp_attached_file","2011/12/IMG_2502.jpg");
INSERT INTO `wp_postmeta` VALUES("1281","1469","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2502.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2502-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2502-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2502-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2502-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2502-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2502-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2502-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2502-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2502-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2502-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2502-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2502-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2502-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2502-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1282","1470","_wp_attached_file","2011/12/IMG_2520.jpg");
INSERT INTO `wp_postmeta` VALUES("1283","1470","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2520.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2520-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2520-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2520-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2520-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2520-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2520-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2520-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2520-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2520-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2520-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2520-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2520-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2520-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2520-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1285","1471","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7615.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7615-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7615-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7615-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7615-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7615-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7615-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7615-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7615-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7615-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7615-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7615-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7615-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7615-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7615-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1286","1472","_wp_attached_file","2011/12/BCR7621.jpg");
INSERT INTO `wp_postmeta` VALUES("1287","1472","_wp_attachment_metadata","a:5:{s:5:\"width\";i:664;s:6:\"height\";i:1000;s:4:\"file\";s:19:\"2011/12/BCR7621.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7621-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7621-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7621-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7621-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x430.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7621-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7621-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x575.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7621-468x705.jpg\";s:5:\"width\";i:468;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x270.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x360.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7621-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7621-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7621-450x677.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:677;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1288","1473","_wp_attached_file","2011/12/BCR7629.jpg");
INSERT INTO `wp_postmeta` VALUES("1289","1473","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7629.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7629-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7629-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7629-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7629-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7629-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7629-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7629-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7629-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7629-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7629-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7629-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7629-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7629-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7629-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1290","1474","_wp_attached_file","2011/12/BCR7638.jpg");
INSERT INTO `wp_postmeta` VALUES("1291","1474","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7638.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7638-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7638-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7638-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7638-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7638-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7638-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7638-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7638-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7638-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7638-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7638-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7638-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7638-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7638-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1292","1475","_wp_attached_file","2011/12/BCR7639.jpg");
INSERT INTO `wp_postmeta` VALUES("1293","1475","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7639.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7639-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7639-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7639-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7639-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7639-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7639-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7639-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7639-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7639-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7639-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7639-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7639-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7639-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7639-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1294","1476","_wp_attached_file","2011/12/BCR7643.jpg");
INSERT INTO `wp_postmeta` VALUES("1295","1476","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7643.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7643-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7643-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7643-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7643-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7643-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7643-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7643-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7643-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7643-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7643-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7643-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7643-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7643-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7643-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1296","1477","_wp_attached_file","2011/12/BCR7651.jpg");
INSERT INTO `wp_postmeta` VALUES("1297","1477","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7651.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7651-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7651-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7651-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7651-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7651-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7651-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7651-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7651-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7651-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7651-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7651-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7651-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7651-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7651-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1298","1478","_wp_attached_file","2011/12/BCR7652.jpg");
INSERT INTO `wp_postmeta` VALUES("1299","1478","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7652.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7652-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7652-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7652-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7652-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7652-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7652-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7652-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7652-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7652-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7652-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7652-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7652-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7652-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7652-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1300","1479","_wp_attached_file","2011/12/BCR7653.jpg");
INSERT INTO `wp_postmeta` VALUES("1301","1479","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7653.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7653-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7653-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7653-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7653-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7653-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7653-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7653-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7653-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7653-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7653-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7653-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7653-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7653-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7653-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1302","1480","_wp_attached_file","2011/12/BCR7655.jpg");
INSERT INTO `wp_postmeta` VALUES("1303","1480","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7655.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7655-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7655-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7655-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7655-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7655-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7655-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7655-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7655-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7655-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7655-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7655-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7655-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7655-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7655-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1304","1481","_wp_attached_file","2011/12/BCR7657.jpg");
INSERT INTO `wp_postmeta` VALUES("1305","1481","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7657.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7657-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7657-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7657-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7657-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7657-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7657-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7657-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7657-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7657-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7657-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7657-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7657-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7657-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7657-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1306","1482","_wp_attached_file","2011/12/BCR7659.jpg");
INSERT INTO `wp_postmeta` VALUES("1307","1482","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7659.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7659-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7659-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7659-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7659-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7659-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7659-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7659-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7659-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7659-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7659-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7659-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7659-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7659-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7659-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1308","1483","_wp_attached_file","2011/12/BCR7662.jpg");
INSERT INTO `wp_postmeta` VALUES("1309","1483","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7662.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7662-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7662-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7662-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7662-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7662-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7662-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7662-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7662-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7662-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7662-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7662-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7662-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7662-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7662-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1310","1484","_wp_attached_file","2011/12/BCR7665.jpg");
INSERT INTO `wp_postmeta` VALUES("1311","1484","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7665.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7665-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7665-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7665-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7665-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7665-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7665-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7665-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7665-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7665-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7665-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7665-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7665-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7665-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7665-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1312","1485","_wp_attached_file","2011/12/BCR7667.jpg");
INSERT INTO `wp_postmeta` VALUES("1313","1485","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7667.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7667-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7667-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7667-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7667-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7667-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7667-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7667-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7667-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7667-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7667-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7667-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7667-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7667-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7667-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1314","1486","_wp_attached_file","2011/12/BCR7671.jpg");
INSERT INTO `wp_postmeta` VALUES("1315","1486","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7671.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7671-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7671-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7671-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7671-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7671-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7671-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7671-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7671-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7671-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7671-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7671-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7671-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7671-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7671-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1316","1487","_wp_attached_file","2011/12/BCR7672.jpg");
INSERT INTO `wp_postmeta` VALUES("1317","1487","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7672.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7672-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7672-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7672-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7672-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7672-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7672-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7672-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7672-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7672-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7672-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7672-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7672-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7672-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7672-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1318","1488","_wp_attached_file","2011/12/BCR7673.jpg");
INSERT INTO `wp_postmeta` VALUES("1319","1488","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7673.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7673-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7673-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7673-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7673-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7673-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7673-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7673-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7673-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7673-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7673-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7673-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7673-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7673-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7673-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1320","1490","_wp_attached_file","2011/12/BCR7674.jpg");
INSERT INTO `wp_postmeta` VALUES("1321","1490","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7674.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7674-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7674-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7674-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7674-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7674-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7674-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7674-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7674-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7674-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7674-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7674-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7674-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7674-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7674-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1322","1491","_wp_attached_file","2011/12/BCR7675.jpg");
INSERT INTO `wp_postmeta` VALUES("1323","1491","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7675.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7675-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7675-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7675-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7675-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7675-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7675-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7675-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7675-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7675-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7675-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7675-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7675-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7675-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7675-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1324","1492","_wp_attached_file","2011/12/BCR7676.jpg");
INSERT INTO `wp_postmeta` VALUES("1325","1492","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7676.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7676-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7676-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7676-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7676-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7676-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7676-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7676-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7676-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7676-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7676-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7676-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7676-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7676-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7676-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1326","1493","_wp_attached_file","2011/12/BCR7697.jpg");
INSERT INTO `wp_postmeta` VALUES("1327","1493","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7697.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7697-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7697-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7697-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7697-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7697-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7697-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7697-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7697-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7697-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7697-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7697-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7697-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7697-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7697-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1328","1494","_wp_attached_file","2011/12/BCR7701.jpg");
INSERT INTO `wp_postmeta` VALUES("1329","1494","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7701.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7701-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7701-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7701-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7701-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7701-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7701-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7701-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7701-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7701-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7701-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7701-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7701-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7701-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7701-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1332","1497","_wp_attached_file","2011/12/BCR7708.jpg");
INSERT INTO `wp_postmeta` VALUES("1333","1497","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7708.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7708-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7708-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7708-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7708-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7708-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7708-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7708-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7708-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7708-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7708-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7708-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7708-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7708-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7708-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1334","1498","_wp_attached_file","2011/12/BCR7710.jpg");
INSERT INTO `wp_postmeta` VALUES("1335","1498","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7710.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7710-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7710-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7710-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7710-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7710-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7710-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7710-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7710-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7710-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7710-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7710-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7710-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7710-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7710-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1336","1499","_wp_attached_file","2011/12/BCR7711.jpg");
INSERT INTO `wp_postmeta` VALUES("1337","1499","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7711.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7711-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7711-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7711-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7711-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7711-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7711-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7711-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7711-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7711-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7711-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7711-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7711-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7711-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7711-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1338","1500","_wp_attached_file","2011/12/BCR7714.jpg");
INSERT INTO `wp_postmeta` VALUES("1339","1500","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7714.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7714-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7714-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7714-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7714-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7714-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7714-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7714-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7714-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7714-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7714-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7714-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7714-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7714-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7714-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("6025","2662","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("6026","2663","_bbp_anonymous_name","ordering prednisone");
INSERT INTO `wp_postmeta` VALUES("6024","2662","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("6023","2662","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("6022","2662","_bbp_anonymous_website","http://buy-doxycycline.tk/#2934");
INSERT INTO `wp_postmeta` VALUES("6021","2662","_bbp_anonymous_email","jmuqmvei@murijjya.com");
INSERT INTO `wp_postmeta` VALUES("5741","2615","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5742","2615","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5740","2615","_bbp_anonymous_website","http://buyamoxicillin500mg.ml/#1835");
INSERT INTO `wp_postmeta` VALUES("5632","2597","_bbp_anonymous_website","http://generic-sildenafil-citrate.ga/#1820");
INSERT INTO `wp_postmeta` VALUES("5631","2597","_bbp_anonymous_email","dtbyuqau@fdwqntit.com");
INSERT INTO `wp_postmeta` VALUES("5630","2597","_bbp_anonymous_name","generic sildenafil citrate");
INSERT INTO `wp_postmeta` VALUES("5529","2580","_bbp_anonymous_email","wsrcmtcm@swambhgz.com");
INSERT INTO `wp_postmeta` VALUES("5528","2580","_bbp_anonymous_name","cialis");
INSERT INTO `wp_postmeta` VALUES("5368","2553","_bbp_anonymous_website","http://sildenafilgeneric.pw/#5152");
INSERT INTO `wp_postmeta` VALUES("5270","2537","_bbp_anonymous_name","cephalexin keflex");
INSERT INTO `wp_postmeta` VALUES("5269","2536","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5143","2515","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("1371","1521","_wp_attached_file","2014/04/P1170592.jpg");
INSERT INTO `wp_postmeta` VALUES("1372","1521","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170592.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170592-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170592-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170592-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170592-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170592-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170592-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170592-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170592-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170592-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170592-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170592-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170592-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170592-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170592-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1373","1522","_wp_attached_file","2014/04/P1170587.jpg");
INSERT INTO `wp_postmeta` VALUES("1374","1522","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170587.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170587-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170587-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170587-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170587-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170587-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170587-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170587-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170587-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170587-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170587-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170587-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170587-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170587-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170587-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1375","1523","_wp_attached_file","2014/04/P1170539.jpg");
INSERT INTO `wp_postmeta` VALUES("1376","1523","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1332;s:4:\"file\";s:20:\"2014/04/P1170539.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170539-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170539-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"P1170539-773x1030.jpg\";s:5:\"width\";i:773;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170539-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170539-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170539-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170539-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170539-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170539-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170539-529x705.jpg\";s:5:\"width\";i:529;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170539-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170539-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170539-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170539-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170539-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1377","1524","_wp_attached_file","2014/04/P1170573.jpg");
INSERT INTO `wp_postmeta` VALUES("1378","1524","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170573.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170573-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170573-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170573-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170573-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170573-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170573-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170573-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170573-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170573-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170573-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170573-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170573-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170573-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170573-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1379","1525","_wp_attached_file","2014/04/P1170565.jpg");
INSERT INTO `wp_postmeta` VALUES("1380","1525","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170565.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170565-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170565-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170565-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170565-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170565-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170565-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170565-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170565-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170565-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170565-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170565-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170565-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170565-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170565-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1381","1526","_wp_attached_file","2014/04/P1170562.jpg");
INSERT INTO `wp_postmeta` VALUES("1382","1526","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170562.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170562-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170562-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170562-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170562-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170562-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170562-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170562-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170562-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170562-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170562-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170562-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170562-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170562-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170562-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1383","1527","_wp_attached_file","2014/04/P1170561.jpg");
INSERT INTO `wp_postmeta` VALUES("1384","1527","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170561.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170561-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170561-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170561-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170561-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170561-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170561-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170561-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170561-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170561-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170561-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170561-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170561-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170561-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170561-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1385","1528","_wp_attached_file","2014/04/P1170549.jpg");
INSERT INTO `wp_postmeta` VALUES("1386","1528","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170549.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170549-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170549-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170549-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170549-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170549-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170549-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170549-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170549-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170549-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170549-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170549-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170549-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170549-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170549-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1387","1529","_wp_attached_file","2014/04/P1170548.jpg");
INSERT INTO `wp_postmeta` VALUES("1388","1529","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170548.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170548-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170548-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170548-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170548-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170548-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170548-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170548-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170548-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170548-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170548-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170548-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170548-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170548-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170548-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1389","1530","_wp_attached_file","2014/04/P1170541.jpg");
INSERT INTO `wp_postmeta` VALUES("1390","1530","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:751;s:4:\"file\";s:20:\"2014/04/P1170541.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170541-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170541-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170541-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170541-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170541-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170541-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170541-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170541-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170541-705x529.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170541-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170541-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170541-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170541-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170541-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1391","1531","_wp_attached_file","2014/04/P1170537.jpg");
INSERT INTO `wp_postmeta` VALUES("1392","1531","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170537.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170537-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170537-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170537-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170537-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170537-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170537-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170537-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170537-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170537-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170537-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170537-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170537-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170537-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170537-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1393","1532","_wp_attached_file","2014/04/P1170536.jpg");
INSERT INTO `wp_postmeta` VALUES("1394","1532","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170536.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170536-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170536-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170536-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170536-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170536-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170536-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170536-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170536-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170536-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170536-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170536-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170536-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170536-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170536-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1395","1533","_wp_attached_file","2014/04/P1170531.jpg");
INSERT INTO `wp_postmeta` VALUES("1396","1533","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170531.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170531-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170531-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170531-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170531-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170531-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170531-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170531-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170531-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170531-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170531-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170531-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170531-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170531-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170531-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1397","1534","_wp_attached_file","2014/04/P1170527.jpg");
INSERT INTO `wp_postmeta` VALUES("1398","1534","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:751;s:4:\"file\";s:20:\"2014/04/P1170527.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170527-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170527-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170527-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170527-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170527-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170527-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170527-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170527-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170527-705x529.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170527-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170527-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170527-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170527-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170527-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1399","1535","_wp_attached_file","2014/04/P1170524.jpg");
INSERT INTO `wp_postmeta` VALUES("1400","1535","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1499;s:4:\"file\";s:20:\"2014/04/P1170524.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170524-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170524-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"P1170524-687x1030.jpg\";s:5:\"width\";i:687;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170524-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170524-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170524-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170524-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170524-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170524-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170524-470x705.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170524-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170524-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170524-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170524-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170524-450x674.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1401","1536","_wp_attached_file","2014/04/P1170520.jpg");
INSERT INTO `wp_postmeta` VALUES("1402","1536","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170520.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170520-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170520-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170520-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170520-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170520-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170520-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170520-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170520-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170520-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170520-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170520-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170520-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170520-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170520-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1403","1537","_wp_attached_file","2014/04/P1170517.jpg");
INSERT INTO `wp_postmeta` VALUES("1404","1537","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170517.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170517-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170517-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170517-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170517-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170517-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170517-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170517-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170517-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170517-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170517-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170517-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170517-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170517-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170517-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1405","1538","_wp_attached_file","2014/04/P1170608.jpg");
INSERT INTO `wp_postmeta` VALUES("1406","1538","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170608.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170608-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170608-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170608-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170608-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170608-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170608-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170608-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170608-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170608-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170608-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170608-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170608-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170608-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170608-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1407","1539","_wp_attached_file","2014/04/P1170507.jpg");
INSERT INTO `wp_postmeta` VALUES("1408","1539","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170507.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170507-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170507-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170507-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170507-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170507-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170507-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170507-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170507-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170507-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170507-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170507-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170507-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170507-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170507-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1409","1542","_wp_attached_file","2014/04/P11705921.jpg");
INSERT INTO `wp_postmeta` VALUES("1410","1542","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705921.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705921-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705921-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705921-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705921-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705921-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705921-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705921-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705921-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705921-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705921-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705921-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705921-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705921-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705921-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1411","1543","_wp_attached_file","2014/04/P11705871.jpg");
INSERT INTO `wp_postmeta` VALUES("1412","1543","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705871.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705871-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705871-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705871-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705871-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705871-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705871-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705871-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705871-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705871-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705871-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705871-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705871-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705871-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705871-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1413","1544","_wp_attached_file","2014/04/P11705391.jpg");
INSERT INTO `wp_postmeta` VALUES("1414","1544","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1332;s:4:\"file\";s:21:\"2014/04/P11705391.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705391-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705391-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"P11705391-773x1030.jpg\";s:5:\"width\";i:773;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705391-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705391-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705391-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705391-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705391-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705391-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705391-529x705.jpg\";s:5:\"width\";i:529;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705391-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705391-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705391-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705391-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705391-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1415","1545","_wp_attached_file","2014/04/P11705731.jpg");
INSERT INTO `wp_postmeta` VALUES("1416","1545","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705731.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705731-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705731-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705731-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705731-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705731-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705731-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705731-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705731-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705731-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705731-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705731-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705731-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705731-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705731-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1417","1546","_wp_attached_file","2014/04/P11705651.jpg");
INSERT INTO `wp_postmeta` VALUES("1418","1546","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705651.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705651-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705651-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705651-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705651-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705651-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705651-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705651-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705651-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705651-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705651-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705651-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705651-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705651-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705651-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1419","1547","_wp_attached_file","2014/04/P11705621.jpg");
INSERT INTO `wp_postmeta` VALUES("1420","1547","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705621.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705621-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705621-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705621-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705621-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705621-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705621-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705621-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705621-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705621-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705621-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705621-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705621-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705621-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705621-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1421","1548","_wp_attached_file","2014/04/P11705611.jpg");
INSERT INTO `wp_postmeta` VALUES("1422","1548","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705611.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705611-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705611-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705611-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705611-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705611-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705611-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705611-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705611-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705611-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705611-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705611-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705611-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705611-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705611-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1423","1549","_wp_attached_file","2014/04/P11705491.jpg");
INSERT INTO `wp_postmeta` VALUES("1424","1549","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705491.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705491-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705491-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705491-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705491-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705491-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705491-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705491-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705491-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705491-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705491-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705491-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705491-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705491-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705491-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1425","1550","_wp_attached_file","2014/04/P11705481.jpg");
INSERT INTO `wp_postmeta` VALUES("1426","1550","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705481.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705481-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705481-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705481-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705481-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705481-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705481-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705481-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705481-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705481-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705481-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705481-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705481-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705481-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705481-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1427","1551","_wp_attached_file","2014/04/P11705411.jpg");
INSERT INTO `wp_postmeta` VALUES("1428","1551","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:751;s:4:\"file\";s:21:\"2014/04/P11705411.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705411-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705411-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705411-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705411-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705411-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705411-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705411-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705411-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705411-705x529.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705411-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705411-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705411-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705411-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705411-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1429","1552","_wp_attached_file","2014/04/P11705371.jpg");
INSERT INTO `wp_postmeta` VALUES("1430","1552","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705371.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705371-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705371-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705371-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705371-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705371-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705371-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705371-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705371-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705371-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705371-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705371-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705371-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705371-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705371-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1431","1553","_wp_attached_file","2014/04/P11705361.jpg");
INSERT INTO `wp_postmeta` VALUES("1432","1553","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705361.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705361-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705361-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705361-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705361-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705361-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705361-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705361-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705361-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705361-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705361-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705361-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705361-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705361-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705361-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1433","1554","_wp_attached_file","2014/04/P11705311.jpg");
INSERT INTO `wp_postmeta` VALUES("1434","1554","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705311.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705311-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705311-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705311-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705311-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705311-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705311-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705311-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705311-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705311-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705311-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705311-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705311-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705311-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705311-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1435","1555","_wp_attached_file","2014/04/P11705271.jpg");
INSERT INTO `wp_postmeta` VALUES("1436","1555","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:751;s:4:\"file\";s:21:\"2014/04/P11705271.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705271-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705271-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705271-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705271-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705271-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705271-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705271-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705271-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705271-705x529.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705271-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705271-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705271-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705271-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705271-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1437","1556","_wp_attached_file","2014/04/P11705241.jpg");
INSERT INTO `wp_postmeta` VALUES("1438","1556","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1499;s:4:\"file\";s:21:\"2014/04/P11705241.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705241-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705241-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"P11705241-687x1030.jpg\";s:5:\"width\";i:687;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705241-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705241-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705241-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705241-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705241-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705241-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705241-470x705.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705241-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705241-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705241-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705241-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705241-450x674.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1439","1557","_wp_attached_file","2014/04/P11705201.jpg");
INSERT INTO `wp_postmeta` VALUES("1440","1557","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705201.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705201-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705201-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705201-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705201-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705201-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705201-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705201-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705201-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705201-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705201-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705201-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705201-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705201-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705201-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1441","1558","_wp_attached_file","2014/04/P11705171.jpg");
INSERT INTO `wp_postmeta` VALUES("1442","1558","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705171.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705171-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705171-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705171-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705171-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705171-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705171-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705171-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705171-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705171-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705171-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705171-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705171-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705171-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705171-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1443","1559","_wp_attached_file","2014/04/P11706081.jpg");
INSERT INTO `wp_postmeta` VALUES("1444","1559","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11706081.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11706081-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11706081-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11706081-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11706081-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11706081-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11706081-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11706081-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11706081-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11706081-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11706081-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11706081-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11706081-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11706081-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11706081-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1445","1560","_wp_attached_file","2014/04/P11705071.jpg");
INSERT INTO `wp_postmeta` VALUES("1446","1560","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:21:\"2014/04/P11705071.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"P11705071-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"P11705071-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"P11705071-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"P11705071-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"P11705071-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"P11705071-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"P11705071-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"P11705071-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"P11705071-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"P11705071-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"P11705071-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"P11705071-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"P11705071-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"P11705071-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1447","1561","_wp_attached_file","2014/04/P1170504.jpg");
INSERT INTO `wp_postmeta` VALUES("1448","1561","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170504.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170504-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170504-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170504-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170504-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170504-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170504-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170504-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170504-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170504-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170504-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170504-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170504-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170504-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170504-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1449","1562","_wp_attached_file","2014/04/P1170503.jpg");
INSERT INTO `wp_postmeta` VALUES("1450","1562","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170503.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170503-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170503-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170503-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170503-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170503-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170503-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170503-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170503-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170503-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170503-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170503-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170503-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170503-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170503-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1451","1563","_wp_attached_file","2014/04/P1170494.jpg");
INSERT INTO `wp_postmeta` VALUES("1452","1563","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170494.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170494-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170494-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170494-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170494-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170494-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170494-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170494-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170494-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170494-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170494-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170494-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170494-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170494-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170494-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1453","1564","_wp_attached_file","2014/04/P1170492.jpg");
INSERT INTO `wp_postmeta` VALUES("1454","1564","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170492.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170492-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170492-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170492-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170492-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170492-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170492-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170492-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170492-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170492-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170492-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170492-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170492-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170492-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170492-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1455","1565","_wp_attached_file","2014/04/P1170489.jpg");
INSERT INTO `wp_postmeta` VALUES("1456","1565","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170489.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170489-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170489-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170489-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170489-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170489-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170489-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170489-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170489-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170489-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170489-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170489-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170489-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170489-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170489-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1457","1566","_wp_attached_file","2014/04/P1170485.jpg");
INSERT INTO `wp_postmeta` VALUES("1458","1566","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170485.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170485-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170485-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170485-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170485-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170485-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170485-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170485-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170485-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170485-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170485-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170485-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170485-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170485-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170485-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1459","1460","_thumbnail_id","1560");
INSERT INTO `wp_postmeta` VALUES("1460","1248","_edit_lock","1429211553:3");
INSERT INTO `wp_postmeta` VALUES("1461","1248","_edit_last","3");
INSERT INTO `wp_postmeta` VALUES("1747","1734","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1746","1734","_menu_item_object_id","1722");
INSERT INTO `wp_postmeta` VALUES("1745","1734","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1744","1734","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1477","1574","av-custom-link","");
INSERT INTO `wp_postmeta` VALUES("5142","2515","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5139","2515","_bbp_anonymous_email","nsmzfxwl@hunydvte.com");
INSERT INTO `wp_postmeta` VALUES("5131","2513","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5130","2513","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5129","2513","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5128","2513","_bbp_anonymous_website","http://valtrex-500-mg.ga/#4139");
INSERT INTO `wp_postmeta` VALUES("5127","2513","_bbp_anonymous_email","bvvmxckj@ggqzaqgb.com");
INSERT INTO `wp_postmeta` VALUES("5126","2513","_bbp_anonymous_name","valtrex online no prescription");
INSERT INTO `wp_postmeta` VALUES("5125","2512","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5124","2512","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("5123","2512","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("5055","2501","_bbp_anonymous_email","uwcjgmpz@pkgwmyzz.com");
INSERT INTO `wp_postmeta` VALUES("5011","2493","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("5010","2493","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4915","2477","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4916","2478","_bbp_anonymous_name","buy doxycycline");
INSERT INTO `wp_postmeta` VALUES("4914","2477","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4913","2477","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4912","2477","_bbp_anonymous_website","http://buy-viagra-soft-tabs.ga/#5377");
INSERT INTO `wp_postmeta` VALUES("4822","2462","_bbp_anonymous_website","http://buyviagrasofttabs.se/#6137");
INSERT INTO `wp_postmeta` VALUES("4708","2443","_bbp_anonymous_website","http://levitra20.tk/#5778");
INSERT INTO `wp_postmeta` VALUES("4707","2443","_bbp_anonymous_email","axwxjbaw@tiwpkzvv.com");
INSERT INTO `wp_postmeta` VALUES("4672","2437","_bbp_anonymous_website","http://xenical-orlistat-120mg.tk/#6884");
INSERT INTO `wp_postmeta` VALUES("4426","2396","_bbp_anonymous_website","http://wellbutrinmedication.cf/#7859");
INSERT INTO `wp_postmeta` VALUES("4425","2396","_bbp_anonymous_email","mfhnyoti@wtpouvgf.com");
INSERT INTO `wp_postmeta` VALUES("4424","2396","_bbp_anonymous_name","wellbutrin");
INSERT INTO `wp_postmeta` VALUES("4423","2395","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4422","2395","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4421","2395","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("4351","2383","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4350","2383","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4262","2369","_bbp_anonymous_name","buy cialis online canada");
INSERT INTO `wp_postmeta` VALUES("4261","2368","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4231","2363","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("4230","2363","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("4083","2339","_bbp_anonymous_email","crjqzizy@kwwptjkp.com");
INSERT INTO `wp_postmeta` VALUES("3958","2318","_bbp_anonymous_website","http://buytretinoin.ml/#8176");
INSERT INTO `wp_postmeta` VALUES("3957","2318","_bbp_anonymous_email","hqllgaax@jamimzly.com");
INSERT INTO `wp_postmeta` VALUES("3956","2318","_bbp_anonymous_name","tretinoin cream");
INSERT INTO `wp_postmeta` VALUES("3955","2317","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3898","2308","_bbp_anonymous_website","http://lisinoprilhctz.ml/#1086");
INSERT INTO `wp_postmeta` VALUES("3846","2299","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3845","2299","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3799","2291","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3798","2291","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3752","2284","_bbp_anonymous_name","cheap generic india viagra");
INSERT INTO `wp_postmeta` VALUES("3751","2283","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("3750","2283","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3749","2283","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3701","2275","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3144","2182","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3145","2182","_bbp_author_ip","46.161.41.34");
INSERT INTO `wp_postmeta` VALUES("2985","2159","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("2986","2160","_bbp_anonymous_name","johnny manziel jersey youth");
INSERT INTO `wp_postmeta` VALUES("2959","2156","_bbp_reply_count","4");
INSERT INTO `wp_postmeta` VALUES("2960","2156","_bbp_reply_count_hidden","0");
INSERT INTO `wp_postmeta` VALUES("2961","2156","_bbp_voice_count","1");
INSERT INTO `wp_postmeta` VALUES("1574","821","footer","");
INSERT INTO `wp_postmeta` VALUES("1589","1631","_wp_attached_file","2014/04/titres-01.png");
INSERT INTO `wp_postmeta` VALUES("1590","1631","_wp_attachment_metadata","a:5:{s:5:\"width\";i:445;s:6:\"height\";i:100;s:4:\"file\";s:21:\"2014/04/titres-01.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"titres-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"titres-01-300x67.png\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"titres-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"titres-01-180x100.png\";s:5:\"width\";i:180;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"titres-01-260x100.png\";s:5:\"width\";i:260;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"titres-01-120x100.png\";s:5:\"width\";i:120;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1591","1632","_wp_attached_file","2014/04/titres-02.png");
INSERT INTO `wp_postmeta` VALUES("1592","1632","_wp_attachment_metadata","a:5:{s:5:\"width\";i:445;s:6:\"height\";i:100;s:4:\"file\";s:21:\"2014/04/titres-02.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"titres-02-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"titres-02-300x67.png\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"titres-02-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"titres-02-180x100.png\";s:5:\"width\";i:180;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"titres-02-260x100.png\";s:5:\"width\";i:260;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"titres-02-120x100.png\";s:5:\"width\";i:120;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1593","1633","_wp_attached_file","2014/04/titres-03.png");
INSERT INTO `wp_postmeta` VALUES("1594","1633","_wp_attachment_metadata","a:5:{s:5:\"width\";i:445;s:6:\"height\";i:100;s:4:\"file\";s:21:\"2014/04/titres-03.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"titres-03-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"titres-03-300x67.png\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"titres-03-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"titres-03-180x100.png\";s:5:\"width\";i:180;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"titres-03-260x100.png\";s:5:\"width\";i:260;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"titres-03-120x100.png\";s:5:\"width\";i:120;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1595","1634","_wp_attached_file","2014/04/BCR7696.jpg");
INSERT INTO `wp_postmeta` VALUES("1596","1634","_wp_attachment_metadata","a:5:{s:5:\"width\";i:4288;s:6:\"height\";i:2848;s:4:\"file\";s:19:\"2014/04/BCR7696.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7696-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7696-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"BCR7696-1030x684.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7696-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7696-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7696-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:20:\"BCR7696-1500x996.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:996;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7696-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7696-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7696-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7696-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7696-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7696-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7696-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7696-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7696-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996;s:6:\"credit\";s:36:\"Bruno Crozat      tel:06.21.98.25.33\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1372784015;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";s:2:\"20\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1597","1635","_wp_attached_file","2014/04/web-e1398432460429.jpg");
INSERT INTO `wp_postmeta` VALUES("1598","1635","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2493;s:6:\"height\";i:1050;s:4:\"file\";s:30:\"2014/04/web-e1398432460429.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"web-e1398432460429-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-300x126.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:126;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"web-e1398432460429-1030x433.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:28:\"web-e1398432460429-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:31:\"web-e1398432460429-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:31:\"web-e1398432460429-1500x631.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:631;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-705x296.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:296;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:31:\"web-e1398432460429-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:30:\"web-e1398432460429-450x189.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:189;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1599","1635","_edit_lock","1398432331:1");
INSERT INTO `wp_postmeta` VALUES("1600","1635","_wp_attachment_backup_sizes","a:17:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:2500;s:6:\"height\";i:1660;s:4:\"file\";s:7:\"web.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:13:\"web-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:15:\"web-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:16:\"web-1030x683.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"widget-orig\";a:4:{s:4:\"file\";s:13:\"web-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"square-orig\";a:4:{s:4:\"file\";s:15:\"web-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"featured-orig\";a:4:{s:4:\"file\";s:16:\"web-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"extra_large-orig\";a:4:{s:4:\"file\";s:16:\"web-1500x996.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:996;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-orig\";a:4:{s:4:\"file\";s:15:\"web-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"portfolio_small-orig\";a:4:{s:4:\"file\";s:15:\"web-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"gallery-orig\";a:4:{s:4:\"file\";s:15:\"web-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"masonry-orig\";a:4:{s:4:\"file\";s:15:\"web-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"entry_with_sidebar-orig\";a:4:{s:4:\"file\";s:15:\"web-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"entry_without_sidebar-orig\";a:4:{s:4:\"file\";s:16:\"web-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"shop_thumbnail-orig\";a:4:{s:4:\"file\";s:15:\"web-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"shop_catalog-orig\";a:4:{s:4:\"file\";s:15:\"web-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"shop_single-orig\";a:4:{s:4:\"file\";s:15:\"web-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("1601","1635","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1602","1636","_wp_attached_file","2014/04/Logo48hPP-01.png");
INSERT INTO `wp_postmeta` VALUES("1603","1636","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:309;s:4:\"file\";s:24:\"2014/04/Logo48hPP-01.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Logo48hPP-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-300x166.png\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"Logo48hPP-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-495x309.png\";s:5:\"width\";i:495;s:6:\"height\";i:309;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-558x270.png\";s:5:\"width\";i:558;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-450x309.png\";s:5:\"width\";i:450;s:6:\"height\";i:309;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"Logo48hPP-01-450x249.png\";s:5:\"width\";i:450;s:6:\"height\";i:249;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1604","1637","_wp_attached_file","2014/04/blancPP-01.png");
INSERT INTO `wp_postmeta` VALUES("1605","1637","_wp_attachment_metadata","a:5:{s:5:\"width\";i:381;s:6:\"height\";i:211;s:4:\"file\";s:22:\"2014/04/blancPP-01.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"blancPP-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"blancPP-01-300x166.png\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"blancPP-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"blancPP-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"blancPP-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"blancPP-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1608","1639","av-custom-link","");
INSERT INTO `wp_postmeta` VALUES("3675","2271","_bbp_anonymous_email","tahhiedk@csdotiln.com");
INSERT INTO `wp_postmeta` VALUES("3676","2271","_bbp_anonymous_website","http://orlistat120mg.tk/#3210");
INSERT INTO `wp_postmeta` VALUES("1615","1652","_wp_attachment_metadata","a:5:{s:5:\"width\";i:78;s:6:\"height\";i:192;s:4:\"file\";s:20:\"2014/04/marqueur.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"marqueur-78x80.png\";s:5:\"width\";i:78;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"marqueur-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"marqueur-78x180.png\";s:5:\"width\";i:78;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"marqueur-78x185.png\";s:5:\"width\";i:78;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"marqueur-78x120.png\";s:5:\"width\";i:78;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1616","1652","_edit_lock","1398441351:1");
INSERT INTO `wp_postmeta` VALUES("3192","2190","_bbp_topic_id","2161");
INSERT INTO `wp_postmeta` VALUES("3191","2190","_bbp_forum_id","1782");
INSERT INTO `wp_postmeta` VALUES("3190","2190","_bbp_anonymous_website","http://buycelebrex.biz/celebrex-international-pharmacy-no-prescription.html#2487");
INSERT INTO `wp_postmeta` VALUES("1614","1652","_wp_attached_file","2014/04/marqueur.png");
INSERT INTO `wp_postmeta` VALUES("2199","751","_avia_builder_template_type_galerie_photo","{{{type galerie photo}}}[av_two_third first]
[av_gallery ids=\'1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1560,1561,1562,1563,1564,1565,1566\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'thumbnail\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]
[av_textblock ]
<h3>Préparation 2014</h3>
Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir. Les prochaine 48 h. proposeront donc aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain, avec :
- des expériences de journalistes pigistes et une co-construction en atelier (quelles sont les expériences innovantes, singulières, mises en œuvre par des journalistes pigistes, comment ces expériences peuvent nourrir mon projet professionnel, à quelles conditions sont-elles transférables ?)
- des outils pour anticiper les évolutions de la presse (regard d\'experts sur les évolutions à moyen terme, compétences à développer)
- des réflexions pour anticiper ces changements (imaginer des réponses collectives, mieux gérer notre efficacité).
La convivialité sera bien évidemment au rendez-vous avec une soirée festive. <strong>Découvrez la cession de préparation en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("1617","1673","_wp_attached_file","2013/04/photo-morgan-railane.jpg");
INSERT INTO `wp_postmeta` VALUES("1618","1673","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:838;s:4:\"file\";s:32:\"2013/04/photo-morgan-railane.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"photo-morgan-railane-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"photo-morgan-railane-1030x719.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"photo-morgan-railane-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"photo-morgan-railane-1200x430.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-705x492.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"photo-morgan-railane-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"photo-morgan-railane-450x314.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:314;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1619","1676","_wp_attached_file","2013/04/Anne-Sophie.jpg");
INSERT INTO `wp_postmeta` VALUES("1620","1676","_wp_attachment_metadata","a:5:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:23:\"2013/04/Anne-Sophie.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Anne-Sophie-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:21:\"Anne-Sophie-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-550x430.jpg\";s:5:\"width\";i:550;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-550x270.jpg\";s:5:\"width\";i:550;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-550x360.jpg\";s:5:\"width\";i:550;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:23:\"Anne-Sophie-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1621","1677","_wp_attached_file","2013/04/Laurent-Poillot1.jpg");
INSERT INTO `wp_postmeta` VALUES("1622","1677","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:28:\"2013/04/Laurent-Poillot1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Laurent-Poillot1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"Laurent-Poillot1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x430.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x575.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x270.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x360.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"Laurent-Poillot1-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1623","1679","_wp_attached_file","2013/04/Laurent-Poillot11.jpg");
INSERT INTO `wp_postmeta` VALUES("1624","1679","_wp_attachment_metadata","a:5:{s:5:\"width\";i:495;s:6:\"height\";i:743;s:4:\"file\";s:29:\"2013/04/Laurent-Poillot11.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Laurent-Poillot11-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"Laurent-Poillot11-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-495x430.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-495x575.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-469x705.jpg\";s:5:\"width\";i:469;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-495x270.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-495x360.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot11-450x675.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1625","1680","_wp_attached_file","2013/04/Laurent-Poillot12.jpg");
INSERT INTO `wp_postmeta` VALUES("1626","1680","_wp_attachment_metadata","a:5:{s:5:\"width\";i:495;s:6:\"height\";i:492;s:4:\"file\";s:29:\"2013/04/Laurent-Poillot12.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Laurent-Poillot12-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-300x298.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"Laurent-Poillot12-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-495x430.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-495x270.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-495x360.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"Laurent-Poillot12-450x447.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:447;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1627","1682","_wp_attached_file","2013/04/jardinaud.jpg");
INSERT INTO `wp_postmeta` VALUES("1628","1682","_wp_attachment_metadata","a:5:{s:5:\"width\";i:440;s:6:\"height\";i:293;s:4:\"file\";s:21:\"2013/04/jardinaud.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"jardinaud-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"jardinaud-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"jardinaud-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"jardinaud-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"jardinaud-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"jardinaud-440x270.jpg\";s:5:\"width\";i:440;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"jardinaud-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1629","1683","_wp_attached_file","2013/04/jardinaud1.jpg");
INSERT INTO `wp_postmeta` VALUES("1630","1683","_wp_attachment_metadata","a:5:{s:5:\"width\";i:495;s:6:\"height\";i:330;s:4:\"file\";s:22:\"2013/04/jardinaud1.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"jardinaud1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"jardinaud1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"jardinaud1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"jardinaud1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"jardinaud1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"jardinaud1-495x270.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"jardinaud1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"jardinaud1-450x330.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:330;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:22:\"jardinaud1-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1631","1684","_wp_attached_file","2013/04/jardinaud2.jpg");
INSERT INTO `wp_postmeta` VALUES("1632","1684","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:22:\"2013/04/jardinaud2.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"jardinaud2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"jardinaud2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"jardinaud2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"jardinaud2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:22:\"jardinaud2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"jardinaud2-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"jardinaud2-600x270.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"jardinaud2-600x360.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"jardinaud2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"jardinaud2-450x400.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:22:\"jardinaud2-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1633","1685","_wp_attached_file","2013/04/Marmotte.jpg");
INSERT INTO `wp_postmeta` VALUES("1634","1685","_wp_attachment_metadata","a:5:{s:5:\"width\";i:490;s:6:\"height\";i:500;s:4:\"file\";s:20:\"2013/04/Marmotte.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"Marmotte-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Marmotte-294x300.jpg\";s:5:\"width\";i:294;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"Marmotte-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"Marmotte-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"Marmotte-490x430.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"Marmotte-490x400.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"Marmotte-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"Marmotte-490x270.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"Marmotte-490x360.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"Marmotte-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"Marmotte-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"Marmotte-450x459.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:459;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1635","1686","_wp_attached_file","2013/04/01-0111.png");
INSERT INTO `wp_postmeta` VALUES("1636","1686","_wp_attachment_metadata","a:5:{s:5:\"width\";i:816;s:6:\"height\";i:612;s:4:\"file\";s:19:\"2013/04/01-0111.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"01-0111-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"01-0111-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"01-0111-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"01-0111-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:19:\"01-0111-816x430.png\";s:5:\"width\";i:816;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"01-0111-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"01-0111-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"01-0111-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"01-0111-705x528.png\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"01-0111-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:19:\"01-0111-816x360.png\";s:5:\"width\";i:816;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"01-0111-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"01-0111-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"01-0111-450x337.png\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1637","1697","_wp_attached_file","2013/04/Vanish.jpg");
INSERT INTO `wp_postmeta` VALUES("1638","1697","_wp_attachment_metadata","a:5:{s:5:\"width\";i:640;s:6:\"height\";i:523;s:4:\"file\";s:18:\"2013/04/Vanish.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Vanish-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Vanish-300x245.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"Vanish-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"Vanish-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:18:\"Vanish-640x430.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"Vanish-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"Vanish-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"Vanish-640x270.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"Vanish-640x360.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"Vanish-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"Vanish-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"Vanish-450x367.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2193","1880","_wp_attached_file","2014/05/marqueur-01.png");
INSERT INTO `wp_postmeta` VALUES("2194","1880","_wp_attachment_metadata","a:5:{s:5:\"width\";i:83;s:6:\"height\";i:98;s:4:\"file\";s:23:\"2014/05/marqueur-01.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"marqueur-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:21:\"marqueur-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1640","1720","_edit_last","3");
INSERT INTO `wp_postmeta` VALUES("1641","1720","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1642","1720","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1643","1720","_aviaLayoutBuilderCleanData","[av_one_full first]
[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'VENDREDI 4 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\']
Durant ces deux journée des jeunes “facilitateurs” polyglottes du CUEJ ou de European Youthpress seront présents accueillir et guider les participants.
[/av_icon_box]

[av_one_full first]
[av_heading heading=\'9H30 : Tables rondes en parallèle\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_half first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/TR-terrain-3juil15-300x102.jpg\' attachment=\'19712\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Quelles réalités pour les pigistes de différents pays européens ? Statuts, financement, formation, marché...\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec trois intervenants :
- Stefania Mizara, photojournaliste indépendante grecque, organisatrice de Visa pour l\'image à Athènes,
- Alberto Campi, photojournaliste indépendant italien, lauréat du Swiss Photo Award, 
- Romy Strassenburg, journaliste pigiste allemande basée à Paris.

[/av_heading]
[/av_one_half]

[av_one_half]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2014/05/HUNTER-2013-original1-300x182.jpg\' attachment=\'1991\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Enquêter en Europe, méthodologie, financement, contraintes\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec trois intervenants :
- Brigitte Alfter, directrice de Journalismfund,
 - Drew Sullivan, de l\'OCCRP (Organize crime and reporting project),
- Benoît Hervieux-Léger, de l\'Unesco.

[/av_heading]
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h15 : ateliers approfondis\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/SullivanDrew-2015-300x300.jpg\' attachment=\'19713\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading heading=\'Réussir un projet éditorial à plusieurs\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec Drew Sullivan de l\'OCCRP (Organize crime and reporting project), branche de l\'ICIJ (International consortium of journalists)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/LazarevaAlla-2015.jpg\' attachment=\'19717\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading heading=\'Travailler en zone de conflit\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
avec Alla Lazareva, ukrainienne, ancienne rédactrice en chef de “la semaine ukrainienne”

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/LoVersoFabio-20151-300x300.jpg\' attachment=\'19720\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'Savoir se vendre\' color=\'meta-heading\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec Fabio Lo Verso, fondateur de La Cité (Suisse) qui a noué un partenariat avec Médiapart
[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/VallellianPatrick-2015-298x300.jpg\' attachment=\'19707\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading heading=\'Travailler sur du long format\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec Patrick Vallelian, grand reporter, fondateur du pure player suisse Sept.info, axé sur des formats longs, des reportages, des photos.
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/GuadagniTommaso-2015-300x300.jpg\' attachment=\'19702\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading heading=\'Datajournalisme\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec Tommaso Guadagni (Italie)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/BulligPaula-2015-300x299.jpg\' attachment=\'19709\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'Le reportage en BD\' color=\'meta-heading\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec le binôme Nicolas Wild / Paula Bullig
[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'13h00 : Déjeuner\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]

[av_heading heading=\'14h30 : Table ronde, quelle information pour quelle démocratie ?\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec cinq intervenants : 
- Zekirja Shabanib, président de l\'association des journalistes du Kosovo,
- Nikolay Staykov, journaliste indépendant d\'investigation parmi les plus connus en Bulgarie sur la corruption,
- Alla Lazareva, ukrainienne, ancienne rédactrice en chef de “la semaine ukrainienne”,  
- Fabio Lo Verso, fondateur de La Cité, Suisse,
- Martin Maska, tchèque, membre de la direction d’European Youth Press.




[/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2015/04/TableRonde-vendaprem.jpg\' attachment=\'19721\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\']

[/av_one_full][av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h : Réunion de clôture\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'14\' padding=\'10\']
Les 4 équipes victorieuses des Média Lab pitchent leur projet.
Le public vote et le meilleur projet reçoit un prix.

[/av_heading]
[/av_one_full]

[av_one_full first]
[av_button label=\'Voir le programme du Jeudi\' link=\'page,1248\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'left\' icon_select=\'yes\' icon=\'ue831\' font=\'entypo-fontello\']
[/av_one_full]

");
INSERT INTO `wp_postmeta` VALUES("1644","1720","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1645","1720","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1646","1720","header","yes");
INSERT INTO `wp_postmeta` VALUES("2091","751","_avia_builder_template_jeudi","{{{jeudi}}}[av_one_full first]
[av_heading tag=\'h1\' padding=\'0\' heading=\'Le programme des 48h 2014 : HORIZON 2030\' color=\'meta-heading\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Anticiper les évolutions de la presse, se positionner sur les compétences à acquérir.\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'JEUDI 3 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]

[av_one_half first]
[av_heading heading=\'9h : Accueil\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\' attachment=\'1474\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_heading heading=\'10h30 : Plénière\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\' attachment=\'1485\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h00 : Ils inventent leur métier de journaliste pigiste\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/photo-morgan-railane-495x400.jpg\' attachment=\'1673\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'J’ai créé mon entreprise de presse\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Morgan Railane, journaliste pigiste, créateur de CA Presse.

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/Anne-Sophie-495x400.jpg\' attachment=\'1676\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Je suis devenu journaliste grâce à mon blog\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Anne-Sophie Novel, journaliste pigiste

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/Laurent-Poillot12-495x400.jpg\' attachment=\'1680\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'J’ai monté un espace de co-working dans l’hyper-centre de Lyon\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Laurent Poillot, journaliste pigiste

[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/jardinaud2-495x400.jpg\' attachment=\'1684\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Mon travail de journaliste me permet de bien gagner ma vie\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Manuel Jardinaud, journaliste pigiste, président de l\'Association des journalistes de l\'information sociale

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/Marmotte-490x400.jpg\' attachment=\'1685\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Je fais valoir mes droits sans me mettre en danger\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Sabine Germain, journaliste pigiste

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/01-0111-495x400.png\' attachment=\'1686\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Je suis journaliste pigiste et les médias du monde entier me respectent\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Invité Surprise

[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'12h30 : Déjeuner\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'14h : Les ateliers de l’intelligence collective\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_fifth first]
[av_icon_box icon=\'ue864\' font=\'entypo-fontello\' position=\'left\' title=\'Créer son entreprise de presse\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fifth]

[av_one_fifth]
[av_icon_box icon=\'ue82b\' font=\'entypo-fontello\' position=\'left\' title=\'Augmenter sa notoriété grâce à un blog\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fifth]

[av_one_fifth]
[av_icon_box icon=\'ue80b\' font=\'entypo-fontello\' position=\'left\' title=\'Imaginer et créer un espace de co-working\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fifth]

[av_one_fifth]
[av_icon_box icon=\'ue8c5\' font=\'entypo-fontello\' position=\'left\' title=\'Atteindre son revenu idéal à la pige\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fifth]

[av_one_fifth]
[av_icon_box icon=\'ue824\' font=\'entypo-fontello\' position=\'left\' title=\'Faire valoir ses droits sans se mettre en danger\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fifth]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h30 : Restitution des ateliers de l’intelligence collective\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_two_third first]
[av_heading heading=\'17h00 : Les ressorts pour être un acteur du changement\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Avec Sophie Wahnich, historienne et directrice de recherche au CNRS

[/av_heading]
[/av_two_third]

[av_one_third]
[av_image src=\'http://dev48h.pigiste.org/wp-content/uploads/2013/04/Vanish-495x400.jpg\' attachment=\'1697\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'18h30 à 20h30 : Apéritif en plein air\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'20h30 : Dîner et soirée surprise\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_button label=\'Voir le programme du vendredi\' link=\'page,1720\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'right\' icon_select=\'yes\' icon=\'ue832\' font=\'entypo-fontello\']");
INSERT INTO `wp_postmeta` VALUES("1656","1722","header","yes");
INSERT INTO `wp_postmeta` VALUES("1657","1722","footer","");
INSERT INTO `wp_postmeta` VALUES("1647","1720","footer","");
INSERT INTO `wp_postmeta` VALUES("1648","1720","_edit_lock","1429259297:3");
INSERT INTO `wp_postmeta` VALUES("1649","1722","_edit_last","3");
INSERT INTO `wp_postmeta` VALUES("1650","1722","_edit_lock","1429044791:3");
INSERT INTO `wp_postmeta` VALUES("1651","1722","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1652","1722","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1653","1722","_aviaLayoutBuilderCleanData","[av_one_full first]

[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[/av_one_full][av_one_half first]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'top\' title=\'JEUDI 2 JUILLET\' link=\'page\' linktarget=\'\' linkelement=\'both\']Découvrez ici le programme de la journée du jeudi 2 juillet

[/av_icon_box]
[/av_one_half]

[av_one_half]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'top\' title=\'VENDREDI 3 JUILLET\' link=\'page\' linktarget=\'\' linkelement=\'both\']Découvrez ici le programme de la journée du vendredi 3 juillet

[/av_icon_box]
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

");
INSERT INTO `wp_postmeta` VALUES("1654","1722","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1655","1722","sidebar","");
INSERT INTO `wp_postmeta` VALUES("2092","1817","_wp_attached_file","2014/05/Eric-Sherrer.jpg");
INSERT INTO `wp_postmeta` VALUES("2093","1817","_wp_attachment_metadata","a:5:{s:5:\"width\";i:372;s:6:\"height\";i:245;s:4:\"file\";s:24:\"2014/05/Eric-Sherrer.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Eric-Sherrer-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"Eric-Sherrer-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"Eric-Sherrer-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"Eric-Sherrer-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"Eric-Sherrer-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"Eric-Sherrer-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:7:\"Laurent\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1323690388;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2094","1818","_wp_attached_file","2014/05/Eric-Sherrer1.jpg");
INSERT INTO `wp_postmeta` VALUES("2095","1818","_wp_attachment_metadata","a:5:{s:5:\"width\";i:607;s:6:\"height\";i:400;s:4:\"file\";s:25:\"2014/05/Eric-Sherrer1.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Eric-Sherrer1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"Eric-Sherrer1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-607x270.jpg\";s:5:\"width\";i:607;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-607x360.jpg\";s:5:\"width\";i:607;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"Eric-Sherrer1-450x400.jpg\";s:5:\"width\";i: